/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp;

import org.apache.solr.client.solrj.SolrQuery;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchQuery {
    private String naam;
    private String term;
    private String[] extraFilters;
    private String[] facetQueries;
    private String[] facets;
    private String sortField;
    private String sortOrder;
    private int start = 0;
    private int numResults = 10;
    private String searchFields;
    private String authorizationQuery;

    public SearchQuery() {
    }

    public SearchQuery(String naam, String term, String[] extraFilters, String[] facetQueries, String[] facets, String sortField, String sortOrder, String searchFields, String authorizationQuery, int start, int numResults) {
        this.naam = naam;
        this.term = term;
        this.extraFilters = extraFilters;
        this.facetQueries = facetQueries;
        this.facets = facets;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.searchFields = searchFields;
        this.authorizationQuery = authorizationQuery;
        this.start = start;
        this.numResults = numResults;
    }

    public SearchQuery(String naam, String term, String extraFilter, String facetQuery, String facet, String sortField, String sortOrder, String searchFields, String authorizationQuery, int start, int numResults) {
        this.naam = naam;
        this.term = term;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.searchFields = searchFields;
        this.authorizationQuery = authorizationQuery;
        if (extraFilter != null) {
            this.extraFilters = extraFilter.split(";");
        }
        if (facetQuery != null) {
            this.facetQueries = facetQuery.split(";");
        }
        if (facet != null) {
            this.facets = facet.split(",");
        }
        this.start = start;
        this.numResults = numResults;
    }

    public SolrQuery toQuery() {
        SolrQuery query = new SolrQuery();
        String queryString = this.createTerm();
        queryString = queryString + " AND " + this.authorizationQuery;
        query.setQuery(queryString);
        query.setRequestHandler("/select");
        query.setFacet(true);
        if (this.facets != null) {
            query.addFacetField(this.facets);
            query.setFacetSort("index");
        }
        if (this.extraFilters != null) {
            query.addFilterQuery(new String[]{this.createExtraFiltersQuery()});
        }
        if (this.facetQueries != null) {
            query.addFilterQuery(this.facetQueries);
        }
        if (this.sortField == null) {
            this.sortField = "naam";
        }
        SolrQuery.ORDER order = null;
        order = this.sortOrder == null ? SolrQuery.ORDER.asc : (this.sortOrder.equals("asc") ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        query.addSort(this.sortField, order);
        query.setStart(Integer.valueOf(this.start));
        query.setFacetMinCount(1);
        query.setRows(Integer.valueOf(this.numResults));
        return query;
    }

    private String createExtraFiltersQuery() {
        String filter = null;
        for (String extraFilter : this.extraFilters) {
            filter = filter == null ? extraFilter : filter + " or " + extraFilter;
        }
        return filter;
    }

    public SolrQuery toQueryAll() {
        SolrQuery query = this.toQuery();
        query.setFields(new String[]{"id"});
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        query.setStart(Integer.valueOf(0));
        return query;
    }

    public SolrQuery toQueryAll(int maxDocs) {
        SolrQuery query = this.toQueryAll();
        query.setRows(Integer.valueOf(maxDocs));
        return query;
    }

    private String createTerm() {
        String[] fields;
        String query = "";
        for (String field : fields = this.searchFields.split(",")) {
            if (query.length() > 0) {
                query = query + " OR ";
            }
            query = query + field + ":" + this.term;
        }
        if (!query.isEmpty()) {
            query = "(" + query + ")";
        }
        return query;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("naam", (Object)this.naam);
        json.put("term", (Object)this.term);
        json.put("extraFilters", (Object)this.extraFilters);
        json.put("facetQueries", (Object)this.facetQueries);
        json.put("facets", (Object)this.facets);
        json.put("sortField", (Object)this.sortField);
        json.put("sortOrder", (Object)this.sortOrder);
        json.put("start", this.start);
        json.put("numResults", this.numResults);
        json.put("searchFields", (Object)this.searchFields);
        json.put("authorizationQuery", (Object)this.authorizationQuery);
        return json;
    }

    public String getNaam() {
        return this.naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String[] getExtraFilters() {
        return this.extraFilters;
    }

    public void setExtraFilters(String[] extraFilters) {
        this.extraFilters = extraFilters;
    }

    public String[] getFacets() {
        return this.facets;
    }

    public void setFacets(String[] facets) {
        this.facets = facets;
    }

    public void setExtraFilter(String extraFilter) {
        if (extraFilter != null) {
            this.extraFilters = extraFilter.split(";");
        }
    }

    public void setFacets(String facet) {
        if (facet != null) {
            this.facets = facet.split(",");
        }
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public String getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(String searchFields) {
        this.searchFields = searchFields;
    }

    public String getAuthorizationQuery() {
        return this.authorizationQuery;
    }

    public void setAuthorizationQuery(String authorizationQuery) {
        this.authorizationQuery = authorizationQuery;
    }

    public String[] getFacetQueries() {
        return this.facetQueries;
    }

    public void setFacetQueries(String[] facetQueries) {
        this.facetQueries = facetQueries;
    }
}

