package nl.b3p.pzh.rwbp.entity;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@Entity
public class BouwplanAdditionalVariable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @ManyToOne
    @JoinColumn(name = "config_variable")
    private ProvincieAdditionalVariable variable;
    private String variableValue;
    
    @ManyToOne(fetch = FetchType.LAZY)
    private Bouwplan bouwplan;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ProvincieAdditionalVariable getVariable() {
        return variable;
    }

    public void setVariable(ProvincieAdditionalVariable variable) {
        this.variable = variable;
    }

    public Bouwplan getBouwplan() {
        return bouwplan;
    }

    public void setBouwplan(Bouwplan bouwplan) {
        this.bouwplan = bouwplan;
    }

    public String getVariableValue() {
        return variableValue;
    }

    public void setVariableValue(String variableValue) {
        this.variableValue = variableValue;
    }

    public JSONObject toJSON() throws JSONException{
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("variable", variable.getId());
        json.put("value",variableValue);
        return json;
    }
}
