package nl.b3p.pzh.rwbp.entity;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@Entity
public class BouwplanVariable {            

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    
    private Integer year;
    private Integer gepland;
    private Boolean gerealiseerd;
    private Integer sloop;
    private Boolean gerealiseerdesloop;
  
    private String type;
    private Integer koop1;
    private Integer koop2;
    private Integer koop3;
    private Integer koop4;
    private Integer kooponb;
    private Integer huur1;
    private Integer huur2;
    private Integer huur3;
    private Integer huur4;
    private Integer huuronb;
    private Integer onbekend;
    private Boolean afgeleidedata;
    
    @Transient
    public static final String TYPE_MEERGEZINS = "meergezins";
    public static final String TYPE_EENGEZINS = "eengezins";
    public static final String TYPE_ONBEKEND = "onbekend";
    
    @ManyToOne
    @JoinColumn(name = "bouwplan")
    private Bouwplan bouwplan;

    // <editor-fold desc="Getters and Setters" defaultstate="collapsed">
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getGerealiseerdesloop() {
        return gerealiseerdesloop;
    }

    public void setGerealiseerdesloop(Boolean gerealiseerdesloop) {
        this.gerealiseerdesloop = gerealiseerdesloop;
    }

    public Bouwplan getBouwplan() {
        return bouwplan;
    }

    public void setBouwplan(Bouwplan bouwplan) {
        this.bouwplan = bouwplan;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getGepland() {
        return gepland;
    }

    public void setGepland(Integer gepland) {
        this.gepland = gepland;
    }

    public Boolean getGerealiseerd() {
        return gerealiseerd;
    }

    public void setGerealiseerd(Boolean gerealiseerd) {
        this.gerealiseerd = gerealiseerd;
    }

    public Integer getSloop() {
        return sloop;
    }

    public void setSloop(Integer sloop) {
        this.sloop = sloop;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getKoop1() {
        return koop1;
    }

    public void setKoop1(Integer koop1) {
        this.koop1 = koop1;
    }

    public Integer getKoop2() {
        return koop2;
    }

    public void setKoop2(Integer koop2) {
        this.koop2 = koop2;
    }

    public Integer getKoop3() {
        return koop3;
    }

    public void setKoop3(Integer koop3) {
        this.koop3 = koop3;
    }

    public Integer getKoop4() {
        return koop4;
    }

    public void setKoop4(Integer koop4) {
        this.koop4 = koop4;
    }

    public Integer getKooponb() {
        return kooponb;
    }

    public void setKooponb(Integer kooponb) {
        this.kooponb = kooponb;
    }

    public Integer getHuur1() {
        return huur1;
    }

    public void setHuur1(Integer huur1) {
        this.huur1 = huur1;
    }

    public Integer getHuur2() {
        return huur2;
    }

    public void setHuur2(Integer huur2) {
        this.huur2 = huur2;
    }

    public Integer getHuur3() {
        return huur3;
    }

    public void setHuur3(Integer huur3) {
        this.huur3 = huur3;
    }

    public Integer getHuur4() {
        return huur4;
    }

    public void setHuur4(Integer huur4) {
        this.huur4 = huur4;
    }

    public Integer getHuuronb() {
        return huuronb;
    }

    public void setHuuronb(Integer huuronb) {
        this.huuronb = huuronb;
    }

    public Integer getOnbekend() {
        return onbekend;
    }

    public void setOnbekend(Integer onbekend) {
        this.onbekend = onbekend;
    }

    public Boolean getAfgeleidedata() {
        return afgeleidedata;
    }

    public void setAfgeleidedata(Boolean afgeleidedata) {
        this.afgeleidedata = afgeleidedata;
    }
    
    // </editor-fold>
    
    public JSONObject toJSON() throws JSONException{
        JSONObject bv = new JSONObject();
        bv.put("id",id);
        bv.put("sloop",sloop);
        bv.put("gerealiseerd",gerealiseerd);
        bv.put("gepland",gepland);
        bv.put("year", year);
       
        bv.put("gerealiseerdsloop", gerealiseerdesloop);
        
        bv.put("type", type);
        bv.put("koop1", koop1);
        bv.put("koop2", koop2);
        bv.put("koop3", koop3);
        bv.put("koop4", koop4);
        bv.put("kooponb", kooponb);
        bv.put("huur1", huur1);
        bv.put("huur2", huur2);
        bv.put("huur3", huur3);
        bv.put("huur4", huur4);
        bv.put("huuronb", huuronb);
        bv.put("onbekend", onbekend);
        bv.put("afgeleidedata", afgeleidedata);

        return bv;
    }
    public Map toPrintMap() throws JSONException{
        Map<String,Object> bv = new HashMap<String,Object>();
        bv.put("id",id);
        bv.put("sloop",sloop);
        bv.put("gerealiseerd",gerealiseerd);
        bv.put("gepland",gepland);
        bv.put("year", year);
       
        bv.put("gerealiseerdsloop", gerealiseerdesloop);
        bv.put("type", type);
        
        bv.put(type + "koop1", koop1);
        bv.put(type + "koop2", koop2);
        bv.put(type + "koop3", koop3);
        bv.put(type + "koop4", koop4);
        bv.put(type + "kooponb", kooponb);
        bv.put(type + "huur1", huur1);
        bv.put(type + "huur2", huur2);
        bv.put(type + "huur3", huur3);
        bv.put(type + "huur4", huur4);
        bv.put(type + "huuronb", huuronb);
        bv.put(type + "onbekend", onbekend);
        return bv;
    }

    public static BouwplanVariable fromJSON(JSONObject json) throws JSONException{
        BouwplanVariable bv = new BouwplanVariable();
        if(json.has("id")){
            bv.setId(json.getInt("id"));
        }
        bv.setGepland(json.optInt("gepland",0));
        bv.setGerealiseerd(json.optBoolean("gerealiseerd",false));
        bv.setSloop(json.optInt("sloop",0));
        bv.setYear(json.getInt("year"));
        bv.setGerealiseerdesloop(json.optBoolean("gerealiseerdsloop", false)); // gerealiseerdsloop ipv gerealiseerdesloop is intentioneel. Komt door autogegenereerde fieldnames. Sorry voor de inconsistentie..
       
        bv.setType(json.optString("type", "onbekend"));
        bv.setKoop1(json.optInt("koop1", 0));
        bv.setKoop2(json.optInt("koop2", 0));
        bv.setKoop3(json.optInt("koop3", 0));
        bv.setKoop4(json.optInt("koop4", 0));
        bv.setKooponb(json.optInt("kooponb", 0));
        bv.setHuur1(json.optInt("huur1", 0));
        bv.setHuur2(json.optInt("huur2", 0));
        bv.setHuur3(json.optInt("huur3", 0));
        bv.setHuur4(json.optInt("huur4", 0));
        bv.setHuuronb(json.optInt("huuronb", 0));
        bv.setOnbekend(json.optInt("onbekend", 0));
        bv.setAfgeleidedata(json.optBoolean("afgeleidedata", false));
 
        return bv;
    }
}
