package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.VariableType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernatespatial.criterion.SpatialRestrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Meine Toonen
 */
@StrictBinding
public class SearchActionBean extends ViewerActionBean {

    private static final Log log = LogFactory.getLog(SearchActionBean.class);
  
    @Validate
    private String provincie;

    @Validate
    private String regio;
    
    @Validate
    private String geom;

    @Validate
    private String x;
    @Validate
    private String y;
    private GeometryFactory geoFact=new GeometryFactory(new PrecisionModel(), 28992);
    private List<Regio> regios = new ArrayList<Regio>();
    private List<Gemeente> gemeentes = new ArrayList<Gemeente>();

    private String facets = "";

    private String initialExtent;
        
    @DefaultHandler
    public Resolution searchdefault() {        
        return new ForwardResolution("/WEB-INF/jsp/search.jsp");
    }

    @After(stages = LifecycleStage.BindingAndValidation)
    public void createLists() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();

        if (gebruiker != null) {
            facets = getFacetsForUser();
            Provincie p = gebruiker.resolveProvincie();

            Envelope bbox = null;
            if(gebruiker.getProvincie() != null){
                bbox = gebruiker.getProvincie().getTheGeom().getEnvelopeInternal();
                provincie = p.getNaam();
            }

            if(gebruiker.getRegio() != null){
                regio = gebruiker.getRegio().getNaam();
                bbox = gebruiker.getRegio().getTheGeom().getEnvelopeInternal();

            }
            
            if( gebruiker.getGemeente() != null ){
                bbox = gebruiker.getGemeente().getGemeenteGeom().getTheGeom().getEnvelopeInternal();
            }
            if(bbox != null){
                initialExtent = getExtent(bbox).toString();
            }

            gemeentes = em.createQuery("FROM Gemeente where provincie = :provincie order by naam").setParameter("provincie", p).getResultList();
            regios = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", p).getResultList();
        }else{
            if(provincie != null){
                try{
                    Provincie p = em.createQuery("FROM Provincie where naam = :name", Provincie.class).setParameter("name", provincie).getSingleResult();
                    gemeentes = em.createQuery("FROM Gemeente where provincie = :provincie order by naam").setParameter("provincie", p).getResultList();
                    regios = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", p).getResultList();
                }catch(Exception e){
                }
            }
            
            if(gemeentes.isEmpty()){
                gemeentes = em.createQuery("FROM Gemeente order by naam").getResultList();
                regios = em.createQuery("from Regio order by naam").getResultList();
            }
        }
    }
    
    public Resolution filterGemeente(){
        EntityManager em = Stripersist.getEntityManager();
        Provincie p = null;
        Regio r = null;
        
        List<String> regioList = Arrays.asList(regio.split(","));
        List<Regio> rs;
        if(provincie != null){
            p = em.createQuery("FROM Provincie where naam = :name", Provincie.class).setParameter("name", provincie).getSingleResult();
            rs = em.createQuery("select r from Regio r join r.provincie p where p = :provincie and r.naam in :regio order by r.naam", Regio.class).setParameter("provincie", p).setParameter("regio", regioList).getResultList();
            
        }else{
            rs = em.createQuery("select r from Regio r where r.naam in :regio order by r.naam", Regio.class).setParameter("regio", regioList).getResultList();
        }
        
        gemeentes = em.createQuery("FROM Gemeente where regio in :regio order by naam").setParameter("regio", rs).getResultList();
        
        final JSONArray ar = new JSONArray();
        for (Gemeente gemeente : gemeentes) {
            ar.put(gemeente.getNaam());
        }
        
        return new StreamingResolution("application/json") {
            @Override
            public void stream(HttpServletResponse response) throws Exception {                
                response.getWriter().print(ar.toString());
            }
        };
    }

    private JSONObject getExtent(Envelope e) throws JSONException{
        JSONObject extent = new JSONObject();

        extent.put("minx", e.getMinX());
        extent.put("miny", e.getMinY());
        extent.put("maxx", e.getMaxX());
        extent.put("maxy", e.getMaxY());
        return extent;
    }

    public Resolution close(){
        return new ForwardResolution("/WEB-INF/jsp/search.jsp");
    }

    /*Get by x y*/
    public Resolution getBouwplanIdsByCoord() {
        Double x = new Double(this.x);
        Double y = new Double(this.y);
        Point point = geoFact.createPoint(new Coordinate(x, y));
        EntityManager em = Stripersist.getEntityManager();
        Session sess = (Session) em.getDelegate();
        Criteria criteria = sess.createCriteria(Bouwplan.class);
        criteria.add(Restrictions.isNotNull("the_geom"));
        criteria.add(SpatialRestrictions.intersects("the_geom", point));
        criteria.add(Restrictions.sqlRestriction("statusprojectid <> 13"));
        
        List<Bouwplan> geselecteerdePlannenAll = criteria.list();
        Iterator<Bouwplan> it = geselecteerdePlannenAll.iterator();
        final JSONArray validBouwplannen = new JSONArray();
        while (it.hasNext()){                    
            Bouwplan b = it.next();            
            if (BouwplanUtils.isAuthorized(b, gebruiker)){
                validBouwplannen.put(b.getId());
            }
        }
        
        return new StreamingResolution("application/json") {
            @Override
            public void stream(HttpServletResponse response) throws Exception {                
                response.getWriter().print(validBouwplannen.toString());
            }
        };
    }

    private String getFacetsForUser(){
        String facets = "";

        EntityManager em = Stripersist.getEntityManager();
        Provincie p = gebruiker.resolveProvincie();
        List<ConfigurableVariable> vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", VariableType.SEARCH).getResultList();
        List<String> facetsList = em.createQuery("select variable.name FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie")
                .setParameter("vars", vars).setParameter("provincie", p).getResultList();
        facets = StringUtils.join(facetsList, ",");
        return facets;
    }

    // <editor-fold defaultstate="collapsed" desc="getters en setters">

    public String getProvincie() {
        return provincie;
    }

    public void setProvincie(String provincie) {
        this.provincie = provincie;
    }
  
    public String getGeom() {
        return geom;
    }

    public void setGeom(String geom) {
        this.geom = geom;
    }

    public String getX() {
        return x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public String getFacets() {
        return facets;
    }

    public void setFacets(String facets) {
        this.facets = facets;
    }

    public List<Regio> getRegios() {
        return regios;
    }

    public void setRegios(List<Regio> regios) {
        this.regios = regios;
    }

    public List<Gemeente> getGemeentes() {
        return gemeentes;
    }

    public void setGemeentes(List<Gemeente> gemeentes) {
        this.gemeentes = gemeentes;
    }
    
    public String getRegio() {
        return regio;
    }

    public void setRegio(String regio) {
        this.regio = regio;
    }

    public String getInitialExtent() {
        return initialExtent;
    }

    public void setInitialExtent(String initialExtent) {
        this.initialExtent = initialExtent;
    }

    // </editor-fold>


}
