/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.EmailTypeConverter;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Bouwplanopmerking;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@CustomPopulationStrategy(value=BeanFirstPopulationStrategy.class)
public class AdminUserActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(AdminUserActionBean.class);
    private Long exportAantal;
    private List<Gebruiker> gebruikersList = new ArrayList();
    private List<Provincie> provinciesList = new ArrayList();
    private List<Gemeente> gemeenteList = new ArrayList();
    private List<Regio> regioList = new ArrayList();
    @ValidateNestedProperties(value={@Validate(field="id", on={"save"}), @Validate(field="username", required=true, maxlength=255, on={"save"}), @Validate(field="fullname", required=true, maxlength=255, on={"save"}), @Validate(field="email", required=true, converter=EmailTypeConverter.class, maxlength=255, on={"save"}), @Validate(field="phone", maxlength=255, on={"save"})})
    private Gebruiker user;
    @Validate
    private boolean nieuweGebruiker = true;
    @Validate(maxlength=255)
    private String wachtwoord;
    @Validate(required=true, on={"save"})
    private String toegang;
    @Validate
    private Integer gemeente;
    @Validate
    private Integer regio;
    @Validate
    private Integer provincie;
    private final String JSP_USER = "/WEB-INF/jsp/admin/user.jsp";

    @DefaultHandler
    public Resolution view() {
        this.nieuweGebruiker = true;
        this.user = new Gebruiker();
        return new ForwardResolution("/WEB-INF/jsp/admin/user.jsp");
    }

    public Resolution selectGebruiker() {
        this.nieuweGebruiker = false;
        if (this.user != null) {
            if (this.user.getGemeente() != null) {
                this.toegang = "gemeente";
            } else if (this.user.getRegio() != null) {
                this.toegang = "regio";
            } else if (this.user.getProvincie() != null) {
                this.toegang = "provincie";
            } else if (this.user.isRijk()) {
                this.toegang = "rijk";
            } else if (this.user.isBeheerder()) {
                this.toegang = "beheerder";
            }
        }
        return new ForwardResolution("/WEB-INF/jsp/admin/user.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void loadEntity() {
        Integer gebruikerId = null;
        Integer id = null;
        try {
            gebruikerId = Integer.parseInt(this.context.getRequest().getParameter("gebruikerid"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            id = Integer.parseInt(this.context.getRequest().getParameter("user.id"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id != null) {
            gebruikerId = id;
        }
        if (gebruikerId != null) {
            EntityManager em = Stripersist.getEntityManager();
            this.user = (Gebruiker)em.find(Gebruiker.class, (Object)gebruikerId);
            if (!this.hasRightsToChange(this.gebruiker, this.user)) {
                this.user = null;
                this.getContext().getMessages().add(new SimpleError("U heeft geen rechten om deze gebruiker aan te passen", new Object[0]));
            }
        }
    }

    public Resolution save() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        EntityManager em = Stripersist.getEntityManager();
        if (this.wachtwoord != null) {
            this.user.changePassword(this.context.getRequest(), this.wachtwoord);
        }
        ValidationErrors errors = this.context.getValidationErrors();
        if (this.nieuweGebruiker) {
            if (this.toegang.equals("gemeente")) {
                if (this.gemeente == null) {
                    errors.add("gemeente", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
                    return new ForwardResolution("/WEB-INF/jsp/admin/user.jsp");
                }
                Gemeente gem = (Gemeente)em.find(Gemeente.class, (Object)this.gemeente);
                this.user.setGemeente(gem);
            } else if (this.toegang.equals("regio")) {
                if (this.regio == null) {
                    errors.add("regio", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
                    return new ForwardResolution("/WEB-INF/jsp/admin/user.jsp");
                }
                Regio reg = (Regio)em.find(Regio.class, (Object)this.regio);
                this.user.setRegio(reg);
            } else if (this.toegang.equals("provincie")) {
                if (this.provincie == null) {
                    errors.add("provincie", (ValidationError)new LocalizableError("validation.required.valueNotPresent", new Object[0]));
                    return new ForwardResolution("/WEB-INF/jsp/admin/user.jsp");
                }
                Provincie p = (Provincie)em.find(Provincie.class, (Object)this.provincie);
                this.user.setProvincie(p);
            } else if (this.toegang.equals("beheerder")) {
                this.user.setBeheerder(true);
            } else if (this.toegang.equals("rijk")) {
                this.user.setRijk(true);
            }
        }
        if (!this.hasRightsToChange(this.gebruiker, this.user)) {
            this.getContext().getMessages().add(new SimpleError("U heeft niet voldoende rechten om deze gebruiker te wijzigen.", new Object[0]));
        }
        em.persist((Object)this.user);
        em.flush();
        this.createLists();
        em.getTransaction().commit();
        SimpleMessage me = new SimpleMessage("Opslaan gelukt", new Object[0]);
        this.context.getMessages().add(me);
        return new ForwardResolution("/WEB-INF/jsp/admin/user.jsp");
    }

    public Resolution delete() {
        if (this.user != null) {
            if (this.user.getId() == this.gebruiker.getId()) {
                this.getContext().getMessages().add(new SimpleError("Het is niet mogelijk om de gebruiker te verwijderen waar u ook mee bent ingelogd", new Object[0]));
            } else if (this.hasRightsToChange(this.gebruiker, this.user)) {
                EntityManager em = Stripersist.getEntityManager();
                List bps = em.createQuery("FROM Bouwplan where gebruiker = :geb", Bouwplan.class).setParameter("geb", (Object)this.user).getResultList();
                for (Bouwplan bp : bps) {
                    bp.setGebruiker(null);
                    em.persist((Object)bp);
                }
                List opmerkingen = em.createQuery("FROM Bouwplanopmerking where gebruiker = :geb", Bouwplanopmerking.class).setParameter("geb", (Object)this.user).getResultList();
                for (Bouwplanopmerking opmerking : opmerkingen) {
                    em.remove((Object)opmerking);
                }
                em.remove((Object)this.user);
                em.getTransaction().commit();
                this.user = null;
                this.createLists();
            } else {
                this.getContext().getMessages().add(new SimpleError("Het is niet mogelijk om de gebruiker te verwijderen waar u ook mee bent ingelogd", new Object[0]));
            }
        }
        return new ForwardResolution("/WEB-INF/jsp/admin/user.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    private void createLists() {
        EntityManager em = Stripersist.getEntityManager();
        this.gemeenteList = this.gebruiker.isBeheerder() ? em.createQuery("from Gemeente order by naam").getResultList() : (this.gebruiker.getProvincie() != null ? em.createQuery("from Gemeente WHERE provincie = :provincie order by naam").setParameter("provincie", (Object)this.gebruiker.getProvincie()).getResultList() : new ArrayList());
        this.regioList = this.gebruiker.isBeheerder() ? em.createQuery("from Regio order by naam").getResultList() : (this.gebruiker.getProvincie() != null ? em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", (Object)this.gebruiker.getProvincie()).getResultList() : new ArrayList());
        if (this.gebruiker.isBeheerder()) {
            this.gebruikersList = em.createQuery("from Gebruiker order by username").getResultList();
        } else if (this.gebruiker.isRijk()) {
            this.gebruikersList = em.createQuery("from Gebruiker where rijk = :r and beheerder = false").setParameter("r", (Object)true).getResultList();
        } else if (this.gebruiker.getProvincie() != null) {
            this.gebruikersList = em.createQuery("select g from Gebruiker g left join g.gemeente gem WHERE g.beheerder = false and (gem.provincie = :provincie OR g.provincie = :provincie OR g.regio in (select r from Regio r join r.provincie p where p = :provincie)) order by username").setParameter("provincie", (Object)this.gebruiker.getProvincie()).getResultList();
        }
        if (this.gebruiker.isBeheerder()) {
            this.provinciesList = em.createQuery("from Provincie order by naam").getResultList();
        } else if (this.gebruiker.getProvincie() != null) {
            this.provinciesList.add(this.gebruiker.getProvincie());
        } else {
            this.provinciesList = new ArrayList();
        }
        this.exportAantal = (Long)this.context.getRequest().getSession().getAttribute("exportAantal");
    }

    @ValidationMethod(on={"save"})
    public void validateGebruiker() {
        EntityManager em = Stripersist.getEntityManager();
        ValidationErrors errors = this.context.getValidationErrors();
        List users = null;
        users = !this.nieuweGebruiker ? em.createQuery("from Gebruiker where username = :username and id != :id").setParameter("username", (Object)this.user.getUsername()).setParameter("id", (Object)this.user.getId()).getResultList() : em.createQuery("from Gebruiker where username = :username").setParameter("username", (Object)this.user.getUsername()).getResultList();
        if (users != null && users.size() > 0) {
            errors.add("gebruikersnaam", (ValidationError)new LocalizableError("validation.field.notUnique", new Object[0]));
        }
        if (this.user.getUsername().equals(this.wachtwoord)) {
            errors.add("gebruikersnaam en wachtwoord", (ValidationError)new LocalizableError("validation.field.notTheSame", new Object[0]));
        }
    }

    public boolean isNieuweGebruiker() {
        return this.nieuweGebruiker;
    }

    public void setNieuweGebruiker(boolean nieuweGebruiker) {
        this.nieuweGebruiker = nieuweGebruiker;
    }

    public Integer getProvincie() {
        return this.provincie;
    }

    public void setProvincie(Integer provincie) {
        this.provincie = provincie;
    }

    public Long getExportAantal() {
        return this.exportAantal;
    }

    public void setExportAantal(Long exportAantal) {
        this.exportAantal = exportAantal;
    }

    public List<Gebruiker> getGebruikersList() {
        return this.gebruikersList;
    }

    public void setGebruikersList(List<Gebruiker> gebruikersList) {
        this.gebruikersList = gebruikersList;
    }

    public Integer getGemeente() {
        return this.gemeente;
    }

    public void setGemeente(Integer gemeente) {
        this.gemeente = gemeente;
    }

    public Integer getRegio() {
        return this.regio;
    }

    public void setRegio(Integer regio) {
        this.regio = regio;
    }

    public String getToegang() {
        return this.toegang;
    }

    public void setToegang(String toegang) {
        this.toegang = toegang;
    }

    public String getWachtwoord() {
        return this.wachtwoord;
    }

    public void setWachtwoord(String wachtwoord) {
        this.wachtwoord = wachtwoord;
    }

    public List<Provincie> getProvinciesList() {
        return this.provinciesList;
    }

    public void setProvinciesList(List<Provincie> provinciesList) {
        this.provinciesList = provinciesList;
    }

    public List<Gemeente> getGemeenteList() {
        return this.gemeenteList;
    }

    public void setGemeenteList(List<Gemeente> gemeenteList) {
        this.gemeenteList = gemeenteList;
    }

    public List<Regio> getRegioList() {
        return this.regioList;
    }

    public void setRegioList(List<Regio> regioList) {
        this.regioList = regioList;
    }

    public Gebruiker getUser() {
        return this.user;
    }

    public void setUser(Gebruiker user) {
        this.user = user;
    }

    private boolean hasRightsToChange(Gebruiker login, Gebruiker g) {
        Provincie p;
        if (login.isBeheerder()) {
            return true;
        }
        if (g.isBeheerder()) {
            return false;
        }
        if (login.getProvincie() != null && (p = g.resolveProvincie()) != null && p.getId().equals(login.getProvincie().getId())) {
            return true;
        }
        return login.isRijk() && g.isRijk();
    }
}

