<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<stripes:layout-definition>
    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
        <head>
            <title>Planmonitor Wonen - ${pageTitle}</title>
            <meta http-equiv="Content-type" content="text/html; charset=UTF-8" />
            <meta http-equiv="X-UA-Compatible" content="IE=Edge">
            <link rel="shortcut icon" href="./images/favicon.ico" />
            <link rel="stylesheet" type="text/css" href="./js/extjs/resources/css/crisp/ext-theme-crisp-all.css">
            <link href="./styles/rwbp.css" rel="stylesheet" type="text/css" />
            <link href="./styles/${fn:replace(actionBean.resolvedProvincie.naam,'â','a')}.css" rel="stylesheet" type="text/css" />
            <!--[if lte IE 7]> <link href="./styles/rwbp-ie7.css" rel="stylesheet" type="text/css" /> <![endif]-->
            <!--[if lte IE 8]> <link href="./styles/rwbp-ie8.css" rel="stylesheet" type="text/css" /> <![endif]-->
            <script type="text/javascript">
                var contextPath = "${pageContext.request.contextPath}";
            </script>
            <script type="text/javascript" src="./js/jquery-1.11.2.min.js"></script>
            <script type="text/javascript" src="./js/jquery-ui-1.11.2.min.js"></script>
            <script type="text/javascript" src="./js/jquery.cookie.js"></script>
            <script type="text/javascript" src="./js/beheer.js"></script>
            <stripes:layout-component name="head"/>
        </head>
        <body>
            <div id="header">
                <stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.SearchActionBean" event="searchdefault"><stripes:param name="reset" value="true"/>
                    <div class="logo">                        
                    </div> 
                </stripes:link>
                <div id="menu">
                    <div id="leftmenu">
                        <button class="inputbutton menubutton" onclick="document.location='<stripes:url value="/Search.action" />'">zoeken</button>
                        <c:choose>
                            <c:when test="${actionBean.isGemeente == false}"><button class="inputbutton menubutton disabled" disabled="disabled">toevoegen</button></c:when>
                            <c:otherwise><button class="inputbutton menubutton" onclick="document.location='<stripes:url value="/Edit.action?add=true" />'">toevoegen</button></c:otherwise>
                        </c:choose>
                        <button class="inputbutton menubutton" onclick="document.location='<stripes:url value="/Export.action" />'">exporteren <c:if test="${not empty exportAantal}"><c:out value="(${exportAantal})"/></c:if></button>
                        <button class="inputbutton menubutton" onclick="document.location='<stripes:url value="/ImportPlan.action" />'">importeren</button>
                    </div>
                    <div id="rightmenu">
                        <div class="menuitems">
                            <c:if test="${actionBean.gebruiker.rijk == true || actionBean.isBeheerder == true || actionBean.gebruiker.provincie != null}">
                                <b>beheer</b> |
                            </c:if>
                            <a href="${actionBean.help}">Help</a> | <a href="mailto:${actionBean.mail}">contact</a> | <a href="${actionBean.about}" target="_blank">over</a>  | <stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.ProfielActionBean">profiel</stripes:link> | <stripes:link href="/logout.jsp">uitloggen</stripes:link>
                        </div>
                        <div class="ingelogdals">ingelogd als: <strong><c:out value="${actionBean.naamGebruiker}"/></strong></div>
                    </div>
                </div>
            </div>
            <div id="content" class="grayborder">
                <stripes:layout-component name="content"/>
            </div>
        </body>
    </html>

</stripes:layout-definition>
