Ext.define('B3p.planmonitor.ConditionalCounter', {
    parentField: null,
    config: {
        parent: '',
        rowSelector: '',
        conditionSelector: ''
    },
    constructor: function(config) {
        this.initConfig(config);
        this.parentField = document.querySelector(this.config.parent);
    },
    getTotal: function() {
        return this.getTotalForRows();
    },
    getTotalForRows: function() {
        // Find all fields
        if(!this.parentField){
            return;
        }
        var total = 0;
        var rows = this.parentField.querySelectorAll(this.config.rowSelector);
        var fields;
        var checkbox;
        for(var i = 0; i < rows.length; i++) {
            checkbox = rows[i].querySelector(this.config.conditionSelector);
            // Only compute total if condition is met
            if(!checkbox.checked) {
                continue;
            }
            fields = rows[i].querySelectorAll('input');
            for(var j = 0; j < fields.length; j++) {
                // Skip if field is checkbox
                if(fields[j] === checkbox) {
                    continue;
                }
                total += +(fields[j].value);
            }
        }
        return total;
    }
});