Ext.define('B3p.planmonitor.PlannerGrid', {
    initCompleted: false,
    tableBody: null,
    tableFoot: null,
    totalsCounter: null,
    firstInit:null,
    config: {
        container: null,
        beginYear: null,
        endYear: null,
        labels:null,
        canEdit:null,
        data: {},
        type: "",
        afgeleidedata:false,
        typeLabel: "",
        cols: ["Koop1", "Koop2", "Koop3", "Koop4", "Koop Onb.", "Huur1", "Huur2", "Huur3", "Huur4", "Huur Onb.", "Onbekend", "Gerealiseerd"],
    },
    constructor: function(config) {
        this.initConfig(config);
        this.config.labels["Gerealiseerd"] = "Gereal.";
        this.gridClass = 'planning-counter-uitgebreid-' + Ext.id();
        this.initForm();
        this.firstInit = true;
        this.popupOpen();
    },
    popupOpen: function() {
        var begin = parseInt(Ext.get( "jaar_eerste_oplevering").getValue(), 10);
        var end = parseInt(Ext.get( "jaar_laatste_oplevering").getValue(), 10);
        if(!this.initCompleted || this.config.beginYear !== begin || this.config.endYear !== end) {
            this.config.beginYear = begin;
            this.config.endYear = end;
            this.createForm(this.config.data);
        }
    },
    getTotalCounter: function() {
        return this.totalsCounter;
    },
    getTotal : function(){
        return this.totalsCounter.getTotal();
    },
    getRealisedTotal : function(){
        return this.gerealiseerdCounter.getTotal();
    },
    getBouwplanVariables: function (){
        var planVariables = {};
        var yearVariables;
        for (var i = this.config.beginYear; i <= this.config.endYear; i++) {
            yearVariables = this.getBouwplanVariable(i);
            planVariables[yearVariables.year] = yearVariables;
        }
        return planVariables;
    },
    getBouwplanVariable: function (year){
        var lowerCaseName;
        var element;
        var varKey;
        var bouwplanVariable = {
            "year": year,
            "type": this.config.type,
            afgeleidedata: this.config.afgeleidedata
        };
        for(var i = 0; i < this.config.cols.length; i++) {
            lowerCaseName = this.classForCol(this.config.cols[i]);
            element = document.getElementById(lowerCaseName + year + this.config.type);
            bouwplanVariable[lowerCaseName] = lowerCaseName === 'gerealiseerd' ? element.checked : +(element.value);
        }
        return bouwplanVariable;
    },
    setBouwplanVariables: function(planVariables) {
        var planVariable;
        var element;
        for(var year in planVariables) if(planVariables.hasOwnProperty(year)) {
            planVariable = planVariables[year];
            for(var key in planVariable) if(planVariable.hasOwnProperty(key) && key !== "year") {
                element = document.getElementById(key + year + this.config.type);
                element.value = planVariable[key];
            }
        }
    },
    runCounters: function() {
        this.totalsCounter.resetTotals();
    },
    initForm: function() {
        var table = document.createElement ("table");
        table.className = ['planning-uitgebreid-grid', this.gridClass].join(' ');
        this.tableHeader = document.createElement('thead');
        table.appendChild(this.tableHeader);
        this.tableBody = document.createElement("tbody");
        table.appendChild(this.tableBody);
        this.tableFoot = document.createElement('tfoot');
        table.appendChild(this.tableFoot);
        this.config.container.appendChild(table);
    },
    createForm: function(data) {
        if(!this.firstInit){
            this.initCompleted = true;
        }else{
            this.firstInit = false;
        }

        this.tableHeader.appendChild(this.createSectionHeader());
        var colHeaders = this.createHeader(this.config.type);
        colHeaders.className = 'rowcontent row-' + this.config.type;
        this.tableBody.appendChild(colHeaders);
        for (var i = this.config.beginYear; i <= this.config.endYear; i++) {
            var yearData = data && data.hasOwnProperty(i) ? data[i] : {};
            var row = this.createRow(i, this.config.type, yearData);
            if(i === this.config.endYear) {
                row.className += ' last-rowcontent';
            }
            this.tableBody.appendChild(row);
        }
        this.tableBody.appendChild(this.createSectionFooter());

        var totalClasses = [];
        for (var j = 0; j < this.config.cols.length; j++) {
            totalClasses.push(this.classForCol(this.config.cols[j]));
        }

        var type = this.classForCol(this.config.type);
        totalClasses.push('type-' + type);
        for (var k = this.config.beginYear; k <= this.config.endYear; k++) {
            totalClasses.push(type + '-year-' + k);
        }
        for (var l = 0; l < this.config.cols.length; l++) {
            totalClasses.push('type-' + type + '-' + this.classForCol(this.config.cols[l]));
        }

        this.totalsCounter = Ext.create('B3p.planmonitor.TotalCounter', {
            parent: '.' + this.gridClass,
            fields: totalClasses,
            repeatingFields: 4
        });
        this.gerealiseerdCounter = Ext.create('B3p.planmonitor.ConditionalCounter', {
            parent: '.' + this.gridClass,
            rowSelector: '.inputrow',
            conditionSelector: '.gerealiseerd_checkbox'
        });
    },
    createSectionHeader: function() {
        var rowHeader = document.createElement('tr');
        var rowHeaderTd = document.createElement('th');
        var baseClassname = 'rowheader header-' + this.config.type;
        var containerClassname = this.config.container.className;
        rowHeaderTd.setAttribute('colspan', this.config.cols.length + 2); // 2 = Jaar + Subtotal column
        rowHeaderTd.innerHTML = this.config.typeLabel;
        rowHeaderTd.setAttribute('data-collapsed', '0');
        rowHeader.className = baseClassname;
        rowHeaderTd.addEventListener('click', (function() {
            var expand = rowHeaderTd.getAttribute('data-collapsed') === '1';
            rowHeader.className = baseClassname + (expand ? '' : ' collapsed');
            this.config.container.className = containerClassname + (expand ? '' : ' collapsed');
            rowHeaderTd.setAttribute('data-collapsed', (expand ? '0' : '1'));
            this.tableBody.style.display = expand ? 'table-row-group' : 'none';
        }).bind(this));
        rowHeader.appendChild(rowHeaderTd);
        return rowHeader;
    },
    createSectionFooter: function() {
        var rowFooter = document.createElement('tr');
        rowFooter.className = 'rowfooter' + ' footer-' + this.config.type;
        var rowFooterTd = document.createElement('th');
        rowFooterTd.innerHTML = 'Subtot.';
        rowFooter.appendChild(rowFooterTd);
        for( var i = 0 ; i < this.config.cols.length ;i++){
            if(this.config.cols[i] === "Gerealiseerd") {
                rowFooter.appendChild(document.createElement('td'));
            } else {
                rowFooter.appendChild(this.createTotalTD('type-' + this.classForCol(this.config.type) + '-' + this.classForCol(this.config.cols[i])));
            }
        }
        rowFooter.appendChild(this.createTotalTD('type-' + this.classForCol(this.config.type)));
        return rowFooter;
    },
    createHeader: function(){
        var tr = document.createElement("tr");
        var th = document.createElement("th");
        var label;
        th.innerHTML = "Jaar";
        tr.appendChild(th);
        for( var i = 0 ; i < this.config.cols.length ;i++){
            th = document.createElement("th");
            label = this.config.cols[i];
            tr.appendChild(th);
            if(this.config.labels.hasOwnProperty(label)) {
                label = this.config.labels[label];
            }
            th.innerHTML = label;
            th.title = label;
        }
        th = document.createElement("th");
        th.innerHTML = 'Subtot.';
        tr.appendChild(th);
        return tr;
    },
    addTotalRow: function() {
        this.tableFoot.appendChild(this.createTotal());
    },
    createTotal: function(){
        var tr = document.createElement ("tr");
        var th = document.createElement("th");
        th.innerHTML = "Totaal";
        tr.appendChild(th);
        for( var i = 0 ; i < this.config.cols.length ;i++){
            if(this.config.cols[i] === "Gerealiseerd") {
                tr.appendChild(document.createElement('td'));
            } else {

                tr.appendChild(this.createTotalTD(this.classForCol(this.config.cols[i])));
            }
        }
        tr.appendChild(this.createTotalTD('table'));
        return tr;
    },
    createTotalTD: function(type){
        var td = document.createElement("td");
        var subtotal = document.createElement("span");
        subtotal.className = "total "+ type + "-total";
        td.appendChild(subtotal);
        return td;
    },
    createRow: function (year, type, yearData){
        var tr = document.createElement ("tr");
        tr.className = 'rowcontent inputrow row-' + type.toLowerCase();
        var td = document.createElement("td");
        td.innerHTML = year === -1 ? "Onbekend" : year;
        tr.appendChild(td);
        for (var i = 0 ; i < this.config.cols.length ; i ++){
            var col = this.createColumn(year, type, this.config.cols[i], yearData);
            if(col){
                tr.appendChild(col);
            }
        }
        tr.appendChild(this.createTotalTD(this.classForCol(type) + '-year-' + year));
        return tr;
    },
    createColumn: function(year, type, colName, yearData){
        var td = document.createElement("td");
        var lowerCaseName = this.classForCol(colName);
        var typeClass = this.classForCol(type);
        var dataKey = typeClass + lowerCaseName;
        var inputField = document.createElement("input");
        inputField.id = lowerCaseName + year + type.toLowerCase();
        inputField.name = lowerCaseName + year + type.toLowerCase();
        if(!this.config.canEdit) {
            inputField.disabled = true;
        }
        if(colName === "Gerealiseerd") {
            inputField.className = 'gerealiseerd_checkbox';
            inputField.type = "checkbox";
            inputField.value = '1';
            inputField.checked = yearData.hasOwnProperty(lowerCaseName) && lowerCaseName[lowerCaseName];
        } else {
            inputField.type = "text";
            // multiple classes for each 'totals' situation
            inputField.className = "numeric " +
                lowerCaseName + ' '+ // col total
                typeClass + '-year-' + year + ' ' + // row total
                'type-' + typeClass + ' ' +// type total
                'type-' + typeClass + '-' + lowerCaseName; // type col total
            inputField.value = yearData.hasOwnProperty(lowerCaseName) ? yearData[lowerCaseName] : "";
        }
        td.appendChild(inputField);
        return td;
    },
    classForCol: function(col) {
        return col.replace(/[^a-zA-Z0-9\-]/g, "").toLowerCase();
    }
});