Ext.define('B3p.planmonitor.SearchNG', {
    extend: 'Ext.util.Observable',
    currentTerm:null,
    currentFacetQueries:null,

    currentPage:null,
    sortDropdown:null,
    startValue:null,
    startField:null,
    startExtent:null,
    config: {
        searchURL: null,
        searchButton: null,
        resetButton: null,
        sortToggle: null,
        resultsPerPage: null,
        resultStatus: null,
        resultDiv: null,
        facetDiv: null,
        sortField: null,
        sortOrder: null,
        paginationDiv: null,
        facettingFields: null,
        maxPages: null,
        searchFields: null,
        termField: null,
        viewer: null,
        defaultExtraQueries: null,
        reloadPrevious:null
    },
    constructor: function (config) {
        B3p.planmonitor.SearchNG.superclass.constructor.call(this,config);
        this.initConfig(config);
    },
    start : function(field, value, initialExtent){
        this.config.viewer.initViewer();
        this.currentPage = 1;
        if(this.config.defaultExtraQueries){
            this.currentFacetQueries = this.config.defaultExtraQueries.split(";");
        }else{
            this.currentFacetQueries = [];
        }
        Ext.get("regio").addListener("change",function(event){
            this.updateGemeenteDropdown();
        }, this);
        this.initSearch();
        if(field && value){
            this.startField = field;
            this.startValue = value;
            if(this.config.facettingFields.length > 0){
               this.config.facettingFields  += ",";
            }
            this.config.facettingFields  += field;
            this.currentFacetQueries.push(field + ":" + value);
        }
        if(initialExtent){
            this.startExtent = Ext.JSON.decode(initialExtent);
        }
        this.search("*", this.getFacetQueries(), this.getExtraQueries(), this.config.reloadPrevious,this.startExtent);
    },
    reset : function(){
        var field = Ext.get(this.config.termField);
        field.dom.value = "";
        //  reset dropdowns
        $("#gemeente").val(null);
        $("#regio").val(null);
        var combos = Ext.ComponentQuery.query("combo");
        Ext.Array.each(combos, function(combo){
            combo.setValue(null);
        });

        this.start(this.startField, this.startValue);
    },

    initSearch: function() {
        var me = this;
        // Listen to <enter> in search field
        Ext.get(this.config.termField).addListener("keyup",function(event){
            if(event.keyCode === 13){
                me.submitTerm();
            }
        }, this);
        // Listen to search button click
        Ext.get(this.config.searchButton).addListener("click",function(event) {
            me.submitTerm();
        }, this);
        // Listen to search button click
        Ext.get(this.config.resetButton).addListener("click",function(event) {
            me.reset();
        }, this);
        // Enable dropdown
        this.sortDropdown = Ext.create('B3p.planmonitor.Dropdown', {
            toggle: '#' + this.config.sortToggle,
            value: 1,
            values: [
                { label: 'Datum laatst gewijzigd', value: "datumlaatstewijziging" },
                { label: 'Aantal woningen', value: "aantal_woningen" },
                { label: 'Jaar eerste oplevering', value: "jaareersteoplevering" }
            ],
            listeners: {
                change: {
                    fn: function (valueObject) {
                        var value = valueObject.value;
                        if(value === null){
                            return;
                        }
                        if(this.config.sortField === value){
                            this.config.sortField = "naam_facet";
                            this.config.sortOrder = "asc";
                        }else{
                            this.config.sortField = value;
                            this.config.sortOrder = "desc";
                        }
                        if(value === "jaareersteoplevering"){
                            this.config.sortOrder = "asc";
                        }
                        this.submitTerm();
                    },
                    scope: this
                }
            }
        });
        // Enable toggling between advanced/simple search
        var advancedVisible = false;
        $('.toggle').on('click', function(e) {
            e.preventDefault();
            var toggle = $(this);
            advancedVisible = !advancedVisible;
            var currentText = toggle.text();
            toggle.text(toggle.data('toggle-text'));
            toggle.data('toggle-text', currentText);
            if(advancedVisible) {
                $('.advanced-search').removeClass('hidden');
            } else {
                $('.advanced-search').addClass('hidden');
            }
        });
        $('.advanced-search').addClass('hidden').removeClass('default-hidden');
        $('.result-export').on('click', function(e) {
            e.preventDefault();
            var url = "Export.action?addToExport=true";
            window.location = url;
        });
    },
    submitTerm : function (){
        this.currentPage = 1;
        var field = Ext.get(this.config.termField);
        var term = field.getValue();
        term = term ? term : "*";
        this.search(term,this.getFacetQueries(),this.getExtraQueries());
    },
    search: function (term, facetQuery,extraQuery,reloadPrevious, extent) {
        this.currentTerm = term;
        var me = this;
        me.extent = extent;
        Ext.Ajax.request({
            url: this.config.searchURL,
            scope:me,
            params: {
                search: true,
                term: term,
                extraFilter: extraQuery,
                facetQuery: facetQuery,
                numResults: this.config.resultsPerPage,
                searchFields: this.config.searchFields,
                sortField: this.config.sortField,
                sortOrder: this.config.sortOrder,
                start: ( me.currentPage - 1) * me.config.resultsPerPage,
                facet:this.config.facettingFields,
                reloadPrevious:reloadPrevious
            },
            success: function (result) {
                var response = Ext.JSON.decode(result.responseText);
                if (response.success) {
                    me.currentTerm = response.searchQuery.term;
                    var facetQueries = response.searchQuery.facetQueries;
                    me.currentFacetQueries= facetQueries;
                    me.currentPage = Math.floor(response.start / response.numResults) + 1;
                    if(reloadPrevious){
                        me.processExtraFilter(response.searchQuery.extraFilters);
                        Ext.get("searchField").dom.value = me.currentTerm;
                    }
                    me.buildInterface(response);
                    if(me.extent){
                        me.config.viewer.naarBbox(me.extent);
                    }else{
                        me.config.viewer.naarBbox(response.extent);
                    }
                    me.processMapVariables(response.mapVariables);
                    
                } else {
                    console.log("Cannot load searchresults: ", response);
                    throw "Cannot load searchresults: " + response;
                }
                me.fireEvent("search_finished", response);
            },
            failure: function (error) {
                console.log("Cannot load searchresults: ", error);
                throw "Cannot load searchresults: " + error;
            }
        });
    },

    clickFacet: function (facet, value, item) {
        this.currentPage = 1;
        var query = facet + ":\"" + value + "\"";
        if(Ext.Array.contains(this.currentFacetQueries,query)){
            this.removeFacet(query);
        }else{
            this.currentFacetQueries.push(query);
        }
        this.setFacetActive(value, facet, item);
        this.search(this.currentTerm, this.getFacetQueries(),this.getExtraQueries());
    },
    buildInterface: function (response) {
        this.clearDiv(this.config.resultDiv);
        this.clearDiv(this.config.facetDiv);
        this.clearDiv(this.config.paginationDiv);

        var results = response.results;
        var facets = response.facets;
        var total = response.total;
        var start = response.start;
        var numResults = results.length;

        this.processResults(results, start, total);
        this.processFacets(facets);
        this.createPagination(total, this.config.resultsPerPage);
    },
    processMapVariables : function(mapVariables){
        var sldKey = mapVariables.sldKey;
        this.config.viewer.addSLD(sldKey);
    },
    processExtraFilter: function(extraFilters){
        var regioFilters = [];
        var gemeenteFilters = [];
        if(extraFilters){
            for (var  i = 0 ; i < extraFilters.length ;i++){
                var filter = extraFilters[i];
                var type = filter.substring(0,filter.indexOf(":"));
                var value = filter.substring(filter.indexOf(":")+1).split("\"").join("");
                if(type === "regio_facet"){
                    regioFilters.push(value);

                }else if(type === "gemeente_facet"){
                    gemeenteFilters.push(value);
                }
            }
            $("#regio").val(regioFilters);
            Ext.ComponentQuery.query("#ext-regio")[0].setValue(regioFilters);

            $("#gemeente").val(gemeenteFilters);
            Ext.ComponentQuery.query("#ext-gemeente")[0].setValue(gemeenteFilters);
            if(gemeenteFilters.length > 0 || regioFilters.length > 0){
                $('.toggle').click();
            }
        }
        
    },
    processResults: function (results, start, total) {
        var resultDiv = Ext.get(this.config.resultDiv);
        var resultStatus = "U heeft gezocht op <strong>" + this.currentTerm + "</strong>";
        var extraFilters = this.getExtraQueries();
        if(extraFilters.length > 0){
            var gemeentes = $("#gemeente").val();
            var regios = $("#regio").val();

            if(regios !== null && regios !== "" && regios !== "Selecteer 1 of meerdere regio’s (CTRL)"){
                resultStatus += " in regio(s) <strong>" + regios + "</strong>";
            }
            if(gemeentes !== null && gemeentes !== "" && gemeentes !== "Selecteer 1 of meerdere gemeentes (CTRL)"){
                resultStatus += " in gemeente(s) <strong>" + gemeentes + "</strong>";
            }
        }
        resultStatus += " en dit levert <strong>" + total + "</strong> resultaten op.";
        Ext.get(this.config.resultStatus).setHtml(resultStatus);
        for (var i = 0; i < results.length; i++) {
            var div = this.createResult(results[i], i + start);
            resultDiv.appendChild(div);
        }
    },
    createResult: function (item, index) {
        var jaarlaatstewijziging = item.datumlaatstewijziging;
        var resultdateclass = "result-date";
        var warningtext = "";
        if(jaarlaatstewijziging){
            jaarlaatstewijziging = jaarlaatstewijziging.substring(jaarlaatstewijziging.lastIndexOf("-") + 1);
            var currentyear = new Date().getFullYear();
            if(jaarlaatstewijziging < (currentyear - 1)){
                resultdateclass += "-warning";
                warningtext = "Het plan is meer dan een jaar niet geüpdatet. Graag bijwerken.";
            }
        }
        var div = document.createElement("div");
        div.className = "result-row";
        div.innerHTML = '<a href="Edit.action?edit=true&bouwplan=' + item.id + '">' + (item.naam ? item.naam : item.id) + '</a>' +
            '<span class="result-year">' + (item.jaareersteoplevering ? item.jaareersteoplevering : '-') + '</span>' +
            '<span class="result-count">' + ( item.aantal_woningen ? item.aantal_woningen : 0) + '</span>' +
            '<span title="' + warningtext + '" class="' + resultdateclass + '">' + (item.datumlaatstewijziging ? item.datumlaatstewijziging : '-') + '</span>' +
            '<span class="result-desc">' + item.gemeente +', '+ item.regio + '</span>';
        var list = document.createElement('li');
        list.setAttribute('data-index', index + 1);
        list.appendChild(div);
        return list;
    },
    processFacets :function (facets){
        var parent =  Ext.get(this.config.facetDiv);
        for(var i = 0 ; i < facets.length ; i++){
            var facet = facets[i];
            var facetDiv = this.createFacet(facet);
            parent.appendChild(facetDiv);
        }
    },

    createFacet : function(facet){
        var div = document.createElement("div");
        div.className = "facet";
        div.innerHTML = '<strong>' + facet.label + "</strong>";
        var listcontainer = document.createElement('ul');
        div.appendChild(listcontainer);
        for(var i = 0 ; i< facet.values.length; i++){
            var value  = facet.values[i];
            var valueDiv = this.createFacetValue(value,facet);
            listcontainer.appendChild(valueDiv);
        }
        if(facet.values.length > 4){
            var showToggle = document.createElement('a');
            showToggle.href = '#';
            showToggle.innerHTML = '+ toon meer';
            showToggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                if(div.className.indexOf('showall') !== -1) {
                    div.className = div.className.replace(' showall', '');
                    showToggle.innerHTML = '+ toon meer';
                } else {
                    div.className = div.className + ' showall';
                    showToggle.innerHTML = '- toon minder';
                }
            });
            div.appendChild(showToggle);
        }
        return div;
    },
    createFacetValue: function(value,facet) {
        var me = this;
        var item = document.createElement("li");
        item.setAttribute("id", facet.name+ "_" + value.name);
        item.innerHTML = value.name + " (" + value.count + ")";
        item.addEventListener('click', function() {
            me.clickFacet(facet.name, value.name, item);
        });
        this.setFacetActive(value, facet, item);
        return item;
    },
    setFacetActive: function(value, facet, item) {
        var removeButton = item.querySelector(".remove");
        if(Ext.Array.contains(this.currentFacetQueries, facet.name + ":\"" + value.name + "\"")) {
            item.className = 'active';
            if(!removeButton) {
                item.innerHTML += '<a href="#" class="remove">&#x2573;</a>';
            }
        } else {
            item.className = '';
            if(removeButton) {
                item.removeChild(removeButton);
            }
        }
    },
    updateGemeenteDropdown: function () {
        var regio = $("#regio").val();
        var combo = Ext.ComponentQuery.query("#ext-gemeente")[0];
        var store = combo.getStore();
        store.clearFilter();
        if(regio === '') {
            return;
        }
        var me = this;
        Ext.Ajax.request({
            url: this.config.gemeenteURL,
            scope: me,
            params: {
                provincie: this.config.provincie,
                regio: regio
            },
            success: function (result) {
                var newOptions = Ext.JSON.decode(result.responseText);
                store.filterBy(function(item) {
                    var itemVal = item.get(combo.valueField);
                    return newOptions.indexOf(itemVal) !== -1;
                });
            },
            failure: function (error) {

            }
        });
    },
    getExtraQueries : function(){
        var gemeentes = $("#gemeente").val();
        gemeentes = gemeentes.split(",");
        var gemeenteQuery = [];
        for (var i = 0 ; i < gemeentes.length ; i++){
            var gemeente = gemeentes[i];
            if(gemeente.indexOf("Selecteer 1 of meerdere gemeentes (CTRL)") !== 0 && gemeente !== ""){
                gemeenteQuery.push( "gemeente_facet:\""  + gemeente + "\"");
            }
        }

        var regios = $("#regio").val();
        regios = regios.split(",");
        var regioQuery = [];
        for (var i = 0 ; i < regios.length ; i++){
            var regio = regios[i];
            if(regio.indexOf("Selecteer 1 of meerdere regio’s (CTRL)") !== 0 && regio !== ""){
                regioQuery.push("regio_facet:\""  + regio + "\"");
            }
        }
        gemeenteQuery = gemeenteQuery.concat(regioQuery);
        return gemeenteQuery.join(";");
    },
    getFacetQueries : function(){
        return this.currentFacetQueries.join(";");
    },

    // Pagination stuff
    createPagination: function(total, resultsPerPage) {
        var maxPages = 0;
        var me = this;
        if(!this.config.maxPages){
            maxPages = Math.ceil(total/resultsPerPage);
        }else{
            maxPages = this.config.maxPages;
        }
        var links = [];
        var i;
        links.push({
            label: 'vorige',
            cmd: this.currentPage === 1 ? null : (function() { me.previousPage(); })
        });
        if(maxPages <= 8) {
            for(i = 1; i <= maxPages; i++) {
                links.push(this.createDefaultLink(i));
            }
        }else if(this.currentPage >= maxPages - 4) {
            for(i = 1; i <= 2; i++){
                links.push(this.createDefaultLink(i, true));
            }
            links.push({
                label: '...'
            });
            for(i = maxPages - 5; i <= maxPages; i++) {
                links.push(this.createDefaultLink(i));
            }

        }else{
            if(this.currentPage === 1){
                for(i = 1; i <= 4; i++) {
                    links.push(this.createDefaultLink(i));
                }
            } else {
                for(i = this.currentPage - 1; i <= this.currentPage + 2; i++) {
                    links.push(this.createDefaultLink(i));
                }
           }
            links.push({
                label: '...'
            });
            for(i = maxPages - 3; i <= maxPages; i++) {
                links.push(this.createDefaultLink(i, true));
            }
        }
        links.push({
            label: 'volgende',
            cmd: this.currentPage === maxPages ? null : (function() { me.nextPage(); })
        });
        this.createLinks(links);
    },

    createDefaultLink: function(i, notSelected) {
        var me = this;
        return {
            label: i,
            cmd: (i ===  this.currentPage && !notSelected) ? null : (function() { me.toPage(i); }),
            class: (i === this.currentPage && !notSelected) ? 'selected' : ''
        };
    },

    createLinks: function(links) {
        var container = Ext.get(this.config.paginationDiv);
        var me = this;
        for(var i = 0; i < links.length; i++) {
            var link = links[i];
            var element = null;
            if(link.cmd) {
                element = document.createElement('a');
                element.href = '#';
                element.setAttribute('href', "#");
                element.addEventListener("click", link.cmd, false);
            } else {
                element = document.createElement('span');
                if(link.class) {
                    element.className = link.class;
                }
            }

            element.innerHTML = link.label;
            container.appendChild(element);

            if(i !== (links.length - 1)) {
                var el = document.createElement('span');
                el.innerHTML = " | ";
                container.appendChild(el);
            }
        }
    },
    clearDiv : function (div){
        var container = document.getElementById(div);
        if(!container) {
            return;
        }
        while (container.firstChild) {
            container.removeChild(container.firstChild);
        }
    },
    removeFacet: function (query) {
        Ext.Array.remove(this.currentFacetQueries, query);
    },
    nextPage : function (){
        this.toPage(this.currentPage + 1);
    },
    previousPage : function(){
        this.toPage(this.currentPage - 1);
    },
    toPage : function(page){
        this.currentPage = page;
        this.search(this.currentTerm, this.getFacetQueries(), this.getExtraQueries());
    }
});