CREATE OR REPLACE VIEW status_view AS
select b.id, b.prognose_start, b.prognose_oplevering, spl.type as statusplanologisch, spt.type as statusproject, b.status_namelijk,
(select vs.type from bouwplanvoortgang bv left join voortgangstatus vs on vs.id = bv.voortgangstatusid where bv.voortgangsoortid = 1 and bv.bouwplanid = b.id) as alg_voortgang,
(select bv.toelichting from bouwplanvoortgang bv where bv.voortgangsoortid = 1 and bv.bouwplanid = b.id) as alg_toelichting,
(select vs.type from bouwplanvoortgang bv left join voortgangstatus vs on vs.id = bv.voortgangstatusid where bv.voortgangsoortid = 2 and bv.bouwplanid = b.id) as plan_voortgang,
(select bv.toelichting from bouwplanvoortgang bv where bv.voortgangsoortid = 2 and bv.bouwplanid = b.id) as plan_toelichting,
(select vs.type from bouwplanvoortgang bv left join voortgangstatus vs on vs.id = bv.voortgangstatusid where bv.voortgangsoortid = 3 and bv.bouwplanid = b.id) as start_voortgang,
(select bv.toelichting from bouwplanvoortgang bv where bv.voortgangsoortid = 3 and bv.bouwplanid = b.id) as start_toelichting,
(select vs.type from bouwplanvoortgang bv left join voortgangstatus vs on vs.id = bv.voortgangstatusid where bv.voortgangsoortid = 4 and bv.bouwplanid = b.id) as bouwrijp_voortgang,
(select bv.toelichting from bouwplanvoortgang bv where bv.voortgangsoortid = 4 and bv.bouwplanid = b.id) as bouwrijp_toelichting,
(select vs.type from bouwplanvoortgang bv left join voortgangstatus vs on vs.id = bv.voortgangstatusid where bv.voortgangsoortid = 5 and bv.bouwplanid = b.id) as vergunning_voortgang,
(select bv.toelichting from bouwplanvoortgang bv where bv.voortgangsoortid = 5 and bv.bouwplanid = b.id) as vergunning_toelichting,
(select vs.type from bouwplanvoortgang bv left join voortgangstatus vs on vs.id = bv.voortgangstatusid where bv.voortgangsoortid = 6 and bv.bouwplanid = b.id) as overig_voortgang,
(select bv.toelichting from bouwplanvoortgang bv where bv.voortgangsoortid = 6 and bv.bouwplanid = b.id) as overig_toelichting
from bouwplan b
left join statusplanologisch spl
on b.statusplanologischid = spl.id
left join statusproject spt
on b.statusprojectid = spt.id
where statusprojectid != 11
and the_geom IS NOT NULL
  ORDER BY id;

ALTER TABLE status_view OWNER TO rwbp;