package nl.b3p.pzh.rwbp;

import org.apache.solr.client.solrj.SolrQuery;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author meine
 */
public class SearchQuery {

    private String naam;

    private String term;

    private String[] extraFilters;

    private String[] facetQueries;

    private String[] facets;

    private String sortField;

    private String sortOrder;

    private int start = 0;

    private int numResults = 10;

    private String searchFields;

    private String authorizationQuery;
    
    public SearchQuery() {
    }

    public SearchQuery(String naam, String term, String[] extraFilters,String[] facetQueries, String[] facets, String sortField, String sortOrder, String searchFields, String authorizationQuery, int start, int numResults) {
        this.naam = naam;
        this.term = term;
        this.extraFilters = extraFilters;
        this.facetQueries = facetQueries;
        this.facets = facets;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.searchFields = searchFields;
        this.authorizationQuery = authorizationQuery;
        this.start = start;
        this.numResults = numResults;
    }
      public SearchQuery(String naam, String term, String extraFilter, String facetQuery, String facet, String sortField, String sortOrder, String searchFields, String authorizationQuery, int start, int numResults) {
        this.naam = naam;
        this.term = term;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.searchFields = searchFields;
        this.authorizationQuery = authorizationQuery;
        if(extraFilter != null){
            extraFilters = extraFilter.split(";");
        }

        if(facetQuery != null){
            facetQueries = facetQuery.split(";");
        }

        if(facet !=null){
            facets = facet.split(",");
        }
        this.start = start;
        this.numResults = numResults;
    }

    public SolrQuery toQuery(){
        SolrQuery query = new SolrQuery();
        String queryString = createTerm();
        queryString += " AND " + authorizationQuery;
        query.setQuery(queryString);
        query.setRequestHandler("/select");
        query.setFacet(true);

        if (facets != null) {
            query.addFacetField(facets);
            query.setFacetSort("index");
        }
        
        if(extraFilters != null){
            query.addFilterQuery(createExtraFiltersQuery());
        }
        
        if(facetQueries != null){
            query.addFilterQuery(facetQueries);
        }

        if (sortField == null) {
            sortField = "naam";
        }
        SolrQuery.ORDER order = null;
        if (sortOrder == null) {
            order = SolrQuery.ORDER.asc;
        } else {
            order = sortOrder.equals("asc") ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
        }

        query.addSort(sortField, order);
        query.setStart(start);
        query.setFacetMinCount(1);
        query.setRows(numResults);
        return query;
    }

    private String createExtraFiltersQuery(){
        String filter = null;
        for (String extraFilter : extraFilters) {
            if(filter == null){
                filter = extraFilter;
            }else{
                filter += " or " + extraFilter;
            }
        }
        return filter;
    }

    public SolrQuery toQueryAll(){
        SolrQuery query = toQuery();

        query.setFields("id");

        query.setRows(2147483647); // max value of integer. Should be enough to get all documents, perhaps do a sanity cap?
        query.setStart(0);
        return query;
    }

    public SolrQuery toQueryAll(int maxDocs){
        SolrQuery query = toQueryAll();

        query.setRows(maxDocs);
        return query;
    }


    private String createTerm(){
        String query = "";
        String[] fields = searchFields.split(",");
        for (String field : fields) {
            if(query.length() > 0){
                query +=" OR ";
            }
            query += field + ":" + term;
        }
        if(!query.isEmpty()){
            query = "(" + query + ")";
        }
        return query;
    }

    public JSONObject toJSON() throws JSONException{
        JSONObject json = new JSONObject();
        json.put("naam", naam);
        json.put("term", term);
        json.put("extraFilters", extraFilters);
        json.put("facetQueries", facetQueries);
        json.put("facets", facets);
        json.put("sortField", sortField);
        json.put("sortOrder", sortOrder);
        json.put("start", start);
        json.put("numResults", numResults);
        json.put("searchFields", searchFields);
        json.put("authorizationQuery", authorizationQuery);
        return json;
    }
    // <editor-fold desc="Getters and Setters" defaultstate="collapsed">
    public String getNaam() {
        return naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public String getTerm() {
        return term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String[] getExtraFilters() {
        return extraFilters;
    }

    public void setExtraFilters(String[] extraFilters) {
        this.extraFilters = extraFilters;
    }

    public String[] getFacets() {
        return facets;
    }

    public void setFacets(String[] facets) {
        this.facets = facets;
    }

    public void setExtraFilter(String extraFilter) {
        if(extraFilter != null){
            this.extraFilters = extraFilter.split(";");
        }
    }

    public void setFacets(String facet) {
        if(facet != null){
            this.facets = facet.split(",");
        }
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getNumResults() {
        return numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public String getSearchFields() {
        return searchFields;
    }

    public void setSearchFields(String searchFields) {
        this.searchFields = searchFields;
    }

    public String getAuthorizationQuery() {
        return authorizationQuery;
    }

    public void setAuthorizationQuery(String authorizationQuery) {
        this.authorizationQuery = authorizationQuery;
    }

    public String[] getFacetQueries() {
        return facetQueries;
    }

    public void setFacetQueries(String[] facetQueries) {
        this.facetQueries = facetQueries;
    }
    // </editor-fold>
}
