/*
 * Copyright (C) 2013-2015 B3Partners B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package nl.b3p.pzh.rwbp;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

/**
 * This class will initialize the solr server: the setup of the index and the
 * initialization of the SolrServer object. This in order to limit the number of
 * connections to the index.
 *
 * @author Meine Toonen
 */
public class SolrInitializer implements ServletContextListener {

    private static SolrServer server;
    private static final Log log = LogFactory.getLog(SolrInitializer.class);

    private ServletContext context;

    // Defaults
    private static final String SOLR_CORE_NAME = "planmonitor";
    private final String SOLR_URL = "planmonitor.solr.url";

    private String solrUrl;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        log.debug("SolrInitializer initializing");
        this.context = sce.getServletContext();
        init();

        inializeSolr();
    }

    private void inializeSolr() {
        log.debug("Initialize the Solr Server instance");
        server = new HttpSolrServer(solrUrl +SOLR_CORE_NAME);
    }

    public static SolrServer getServerInstance() {
        return server;
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if(server != null){
            server.shutdown();
            log.debug("SolrInitializer destroyed");
        }
    }

    private void init(){
        solrUrl = context.getInitParameter(SOLR_URL);
    }
}
