package nl.b3p.pzh.rwbp.entity;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

/**
 *
 * @author Jytte
 */

@Entity
public class Gemeente {

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;

    private String code;

    private String naam;
    @ManyToOne(fetch= FetchType.LAZY)
    @JoinColumn(name="regioid")
    private Regio regio;

    @OneToMany(fetch= FetchType.LAZY)
    @JoinColumn(name = "gemeenteid")
    private Set<Bouwplan> bouwplannen = new HashSet<Bouwplan>();
    
    @OneToOne(fetch= FetchType.LAZY)
    @JoinColumn(name = "geomid")
    private GemeenteGeom gemeenteGeom;
    
    @ManyToOne(fetch= FetchType.LAZY)
    private Provincie provincie;
    
    //<editor-fold defaultstate="collapsed" desc="Getters and Setters">
    public String getCode() {
        return code;
    }
    
    public void setCode(String code) {
        this.code = code;
    }
    
    public int getId() {
        return id;
    }
    
    public void setId(int id) {
        this.id = id;
    }
    
    public String getNaam() {
        return naam;
    }
    
    public void setNaam(String naam) {
        this.naam = naam;
    }
    
    public Set<Bouwplan> getBouwplannen() {
        return bouwplannen;
    }
    
    public void setBouwplannen(Set<Bouwplan> bouwplannen) {
        this.bouwplannen = bouwplannen;
    }
    
    public Regio getRegio() {
        return regio;
    }
    
    public void setRegio(Regio regio) {
        this.regio = regio;
    }
    
    public Geometry getTheGeom() {
        return this.gemeenteGeom.getTheGeom();
    }
    
    public void setTheGeom(Geometry theGeom) {
        this.gemeenteGeom.setTheGeom(theGeom);
    }

    public GemeenteGeom getGemeenteGeom() {
        return gemeenteGeom;
    }

    public void setGemeenteGeom(GemeenteGeom gemeenteGeom) {
        this.gemeenteGeom = gemeenteGeom;
    }

    public Provincie getProvincie() {
        return provincie;
    }

    public void setProvincie(Provincie provincie) {
        this.provincie = provincie;
    }
    //</editor-fold>
}
