/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author meine
 */

@Entity
public class ProvincieAdditionalVariableValue {

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;

    @ManyToMany(fetch = FetchType.LAZY)
    @JoinTable(name="regio_additional_values",
                joinColumns={@JoinColumn(name="value")},
                inverseJoinColumns={@JoinColumn(name="regio")})
    private List<Regio> regios = new ArrayList<Regio>();

    private String value;

    private boolean usedByMunicipalities = true;

    @ManyToOne( fetch = FetchType.LAZY)
    private ProvincieAdditionalVariable provincieadditionalvariable;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public List<Regio> getRegios() {
        return regios;
    }

    public void setRegios(List<Regio> regios) {
        this.regios = regios;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUsedByMunicipalities() {
        return usedByMunicipalities;
    }

    public void setUsedByMunicipalities(boolean usedByMunicipalities) {
        this.usedByMunicipalities = usedByMunicipalities;
    }

    public ProvincieAdditionalVariable getProvincieadditionalvariable() {
        return provincieadditionalvariable;
    }

    public void setProvincieadditionalvariable(ProvincieAdditionalVariable provincieadditionalvariable) {
        this.provincieadditionalvariable = provincieadditionalvariable;
    }

    public JSONObject toJSON() throws JSONException{
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("value", value);
        JSONArray regiosJSON = new JSONArray();
        for (Regio regio : regios) {
            regiosJSON.put(regio.getId());
        }
        if(usedByMunicipalities){
            regiosJSON.put(-1);
        }
        json.put("regios", regiosJSON);

        return json;
    }
}
