/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.Bouwplanopmerking;
import nl.b3p.pzh.rwbp.entity.Bouwplanvoortgang;
import nl.b3p.pzh.rwbp.entity.Extraveld;
import nl.b3p.pzh.rwbp.entity.Factmetperiode;
import nl.b3p.pzh.rwbp.entity.Gerealiseerd;
import nl.b3p.pzh.rwbp.entity.Periode;
import nl.b3p.pzh.rwbp.entity.Plantype;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.Statusplanologisch;
import nl.b3p.pzh.rwbp.entity.Voortgangsoort;
import nl.b3p.pzh.rwbp.entity.Voortgangstatus;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author meine
 */
@StrictBinding
public class ConverterActionBean implements ActionBean {

    public static final int FACT_GEPLAND = 1;
    
    private ActionBeanContext context;

    @Validate
    private boolean commit = false;

    @Validate boolean removeOld = false;

    @Validate
    private Bouwplan bouwplan;

    @Validate
    private boolean makeVars = false;

    @Validate
    private Provincie provincie;

    private Map<Provincie,Map<String, ProvincieAdditionalVariable>> provvars = new HashMap<Provincie, Map<String,ProvincieAdditionalVariable>>();
    
    public Resolution convert() {

        final EntityManager em = Stripersist.getEntityManager();
        return new StreamingResolution("text/plain") {
            @Override
            public void stream(HttpServletResponse response) throws Exception {
                PrintWriter out = new PrintWriter(response.getWriter());
                List<Bouwplan> toConvert = em.createQuery("From Bouwplan where gemeente.provincie = :provincie AND jaar_eerste_oplevering is null").setParameter("provincie", provincie).getResultList();
                int counter = 0;
                for (Bouwplan bouwplan : toConvert) {
                    out.format("Converteren bouwplan #%d: %s \r\n: ", bouwplan.getId(), bouwplan.getNaam());
                    convertBouwplan(bouwplan);
                    counter++;
                    out.flush();
                    if(counter > 110){
                        counter=0;
                        out.write("Committing... \r\n");
                        out.write("*******************************************************\r\n");
                        if (commit) {
                            em.getTransaction().commit();
                        }

                    }
                }
                if (commit) {
                    em.getTransaction().commit();
                }
            }
        };
    }

    public Resolution onlyRemove() {
        if(commit){
            EntityManager em = Stripersist.getEntityManager();
            em.getTransaction().commit();
        }
        return new ForwardResolution("");
    }

    public Resolution convertOne() {
        convertBouwplan(bouwplan);
        if(commit){
            EntityManager em = Stripersist.getEntityManager();
            em.getTransaction().commit();
        }
        return new ForwardResolution("");
    }

    @Before
    private void before(){
        EntityManager em = Stripersist.getEntityManager();

        if(removeOld){
            List<Bouwplan> old = em.createQuery("FROM Bouwplan where statusprojectid = 11").getResultList();
            for (Bouwplan old1 : old) {
                for (Bouwplanopmerking bouwplanOpmerkingen : old1.getBouwplanOpmerkingen()) {
                    em.remove(bouwplanOpmerkingen);
                }
                em.remove(old1);
            }
        }
        List<Provincie> provincies = em.createQuery("FROM Provincie").getResultList();
        List<Voortgangsoort> voortgangssoorten = em.createQuery("FROM Voortgangsoort").getResultList();

        if (makeVars) {
            // maak additionele variabele voro provincie (als nog niet bestaat)
            List<Voortgangstatus> voortgangsstatus = em.createQuery("FROM Voortgangstatus").getResultList();

            for (Provincie prov : provincies) {
                List<Regio> regioList = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", prov).getResultList();
                Map<String, ProvincieAdditionalVariable> vars = new HashMap<String, ProvincieAdditionalVariable>();
                for (Voortgangsoort voortgangssoort : voortgangssoorten) {
                    ProvincieAdditionalVariable pav = new ProvincieAdditionalVariable();
                    pav.setProvincie(prov);
                    pav.setAdditionField(false);
                    pav.setProvinceField(false);
                    pav.setAdditional_variable(voortgangssoort.getType());
                    pav.setUsedByMunicipalities(true);
                    pav.setRegios(regioList);
                    pav.setLocation("voortgang");
                    pav.setType("dropdown");
                    List<ProvincieAdditionalVariableValue> values = new ArrayList<ProvincieAdditionalVariableValue>();
                    for (Voortgangstatus status : voortgangsstatus) {
                        ProvincieAdditionalVariableValue val = new ProvincieAdditionalVariableValue();
                        val.setRegios(regioList);
                        val.setUsedByMunicipalities(true);
                        val.setValue(status.getType());
                        val.setProvincieadditionalvariable(pav);
                        values.add(val);
                        em.persist(val);
                    }
                    pav.setValues(values);
                    em.persist(pav);
                    vars.put(voortgangssoort.getType(), pav);
                }
                provvars.put(prov, vars);
            }
        //statusplanologisch
            // bouwplanvoortgang
            //bouwrijp_voortgang
            //bouwvergunning_voortgang
            //overig_voortgang
        }else{
            for (Provincie provincy : provincies) {
                Map<String, ProvincieAdditionalVariable> vars = new HashMap<String, ProvincieAdditionalVariable>();
                for (Voortgangsoort soort : voortgangssoorten) {
                    List<ProvincieAdditionalVariable> pavs = em.createQuery("from ProvincieAdditionalVariable where provincie = :provincie and additional_variable = :var")
                            .setParameter("provincie", provincy).setParameter("var", soort.getType()).getResultList();
                    for (ProvincieAdditionalVariable pav : pavs) {
                        vars.put(soort.getType(), pav);
                    }
                }
                provvars.put(provincy, vars);
            }
        }
        int b = 1;
        int a = b+10;

    }

    private void convertBouwplan(Bouwplan bouwplan) {
        List<Map<String, Object>> waardes = makefactList(FACT_GEPLAND, bouwplan);

        convertGlobalValues(waardes, bouwplan);
        convertDetails(waardes, bouwplan);
        calculateMinMaxYear(waardes, bouwplan);
        convertKnelpunten(bouwplan);
        convertOpmerkingen(bouwplan);
        convertStatus(bouwplan);
        EntityManager em = Stripersist.getEntityManager();
        em.persist(bouwplan);

        int a = 0;
    }

    private void convertStatus(Bouwplan bouwplan){
        // maak per bouwplan de bouwplanvariable voro de configurable variable van het type status
        EntityManager em = Stripersist.getEntityManager();
        Set<Bouwplanvoortgang> vg = bouwplan.getBouwplanvoortgang();
        Provincie p = bouwplan.getGemeente().getProvincie();
        for (Bouwplanvoortgang voortgang : vg) {
            ProvincieAdditionalVariable pav = provvars.get(p).get(voortgang.getVoortgangsoort().getType());
            BouwplanAdditionalVariable bav = new BouwplanAdditionalVariable();
            bav.setBouwplan(bouwplan);
            bav.setVariable(pav);
            List<ProvincieAdditionalVariableValue> vals = pav.getValues();
            for (ProvincieAdditionalVariableValue val : vals) {
                if(val.getValue().equalsIgnoreCase(voortgang.getVoortgangstatus().getType())){
                    bav.setVariableValue(""+val.getId());
                }
            }
            em.persist(bav);
        }

        if(bouwplan.getPlantype() == null){
            Plantype onbekend = em.find(Plantype.class, 99);
            bouwplan.setPlantype(onbekend);
        }

        if(bouwplan.getStatusplanologisch() == null){
            Statusplanologisch onbekend = em.find(Statusplanologisch.class, 1);
            bouwplan.setStatusplanologisch(onbekend);
        }
        bouwplan.setDatumlaatstewijziging(bouwplan.getGebruikeractiontijd());
    }
    
    private void convertOpmerkingen(Bouwplan bouwplan){
        Set<Bouwplanopmerking> opmerkingen = bouwplan.getBouwplanOpmerkingen();
        String value = "";
        String provincievalue = "";
        boolean prive = false;
        for (Bouwplanopmerking opmerking : opmerkingen) {
            if (opmerking.getGebruiker() != null && opmerking.getGebruiker().getProvincie() != null) {
                provincievalue += "\r\n";
                provincievalue += opmerking.getOpmerking();
            } else {
                value += "\r\n";
                value += opmerking.getOpmerking();
            }
            if (opmerking.getAccesslevel().getType().equalsIgnoreCase("Prive")){
                prive = true;
            }
        }
        bouwplan.setOpmerkingen(value);
        bouwplan.setOpmerkingenprive(prive);
        bouwplan.setOpmerkingenprovincie(provincievalue);
    }
    
    private void convertKnelpunten(Bouwplan bouwplan){
        String knelpunten = "";
        Set<Bouwplanvoortgang> bv = bouwplan.getBouwplanvoortgang();
        for (Bouwplanvoortgang bv1 : bv) {
            if (bv1.getToelichting() != null && !bv1.getToelichting().isEmpty()) {
                knelpunten += "\r\n";
                knelpunten += bv1.getVoortgangsoort().getType() + " toelichting: " + bv1.getToelichting();
            }
        }
        bouwplan.setKnelpunten(knelpunten);
    }

    private void convertDetails(List<Map<String, Object>> waardes, Bouwplan bouwplan) {
        EntityManager em = Stripersist.getEntityManager();
        boolean hasYear = false;
        for (Map<String, Object> jaar : waardes) {
            if (jaar.containsKey("Jaar")) {
                hasYear = true;
                String yearString = (String) jaar.get("Jaar");
                Integer year = Integer.parseInt(yearString);
                year = correctYear(year);
                BouwplanVariable bv = new BouwplanVariable();
                bv.setBouwplan(bouwplan);
                bv.setYear(year);

                int gepland = jaar.containsKey("Nieuwbouw") ? (Integer) jaar.get("Nieuwbouw") : 0;
                int sloop = jaar.containsKey("Sloop") ? (Integer) jaar.get("Sloop") : 0;
                Object gerealiseerd = jaar.get("Gerealiseerd");
                bv.setSloop(sloop);
                bv.setGepland(gepland);
                if (gerealiseerd != null && ((Gerealiseerd) gerealiseerd).compareTo(Gerealiseerd.Ja) == 0) {
                    bv.setGerealiseerd(true);
                }
                em.persist(bv);
            }
        }
        if(hasYear){
            bouwplan.setDetailType("normaal");
        }
    }

    private void convertGlobalValues(List<Map<String, Object>> waardes, Bouwplan bouwplan) {
        int huur1 = aggregate(waardes, "HuurGoedkoop");
        huur1 += aggregate(waardes, "HuurSociaal");
        huur1 += aggregate(waardes, "HuurSociaal3");
        huur1 += aggregate(waardes, "HuurSociaal4");

        int huur2 = aggregate(waardes, "HuurMarkt");

        int huur3 = aggregate(waardes, "HuurMarkt2");

        int huuronbekend = aggregate(waardes, "HuurOnbekend");
        // Koop
        int koop1 = aggregate(waardes, "KoopSociaal");

        int koop2 = aggregate(waardes, "KoopMarkt");

        int koop3 = aggregate(waardes, "KoopMarkt2");

        int koop4 = aggregate(waardes, "KoopMarkt3");

        koop4 += aggregate(waardes, "KoopMarkt4");

        int kooponbekend = aggregate(waardes, "KoopOnbekend");

        // woningtypen
        int meergezins = aggregateFuzzy(waardes, "Meergezins", false, false);
        int eensgezins = aggregateFuzzy(waardes, "Eensgezins", false,false);
        int onbekend = aggregateFuzzy(waardes, "OnbekendOnbekend", false,false);

        // Totalen
        int sloop = aggregateFuzzy(waardes, "Sloop",false,false);
        int restcapaciteit = aggregateFuzzy(waardes, "Nieuwbouw", true, false);
        int gerealiseerdeCapaciteit = aggregateFuzzy(waardes, "Nieuwbouw", true, true);
        int totaalCapaciteit = restcapaciteit + gerealiseerdeCapaciteit;

        bouwplan.setKoop1(koop1);
        bouwplan.setKoop2(koop2);
        bouwplan.setKoop3(koop3);
        bouwplan.setKoop4(koop4);
        bouwplan.setKoopprijsonbekend(kooponbekend);
        bouwplan.setKooptotaal(koop1 + koop2 + koop3 + koop4 + kooponbekend);

        bouwplan.setHuur1(huur1);
        bouwplan.setHuur2(huur2);
        bouwplan.setHuur3(huur3);
        bouwplan.setHuur4(0);
        bouwplan.setHuurprijsonbekend(huuronbekend);
        bouwplan.setHuurtotaal(huur1 + huur2 + huur3 + huuronbekend);

        bouwplan.setEensgezins(eensgezins);
        bouwplan.setMeergezins(meergezins);
        bouwplan.setWoningtypeonbekend(onbekend);

        bouwplan.setRestcapaciteit(restcapaciteit);
        bouwplan.setResterendesloop(sloop);
        bouwplan.setGerealiseerdecapaciteit(gerealiseerdeCapaciteit);
        bouwplan.setTotaalcapaciteit(totaalCapaciteit);

    }

    private Integer correctYear(Integer year){
        if (year > 2019) {
            if (year == 2020) {
                year = 2024;
            } else if (year == 2025) {
                year = 2029;
            } else {
                year = 2040;
            }
        }
        return year;
    }

    private void calculateMinMaxYear(List<Map<String, Object>> values, Bouwplan bouwplan){
        int min = 99999;
        int max = -1;
        for (Map<String, Object> jaar : values) {
            
            if (jaar.containsKey("Jaar")) {
                String yearString = (String) jaar.get("Jaar");
                Integer year = Integer.parseInt(yearString);
                year = correctYear(year);
                int gepland = jaar.containsKey("Nieuwbouw") ? (Integer) jaar.get("Nieuwbouw") : 0;
                int sloop = jaar.containsKey("Sloop") ? (Integer) jaar.get("Sloop") : 0;
                if(gepland > 0 || sloop > 0){
                    min = Math.min(year, min);
                    max = Math.max(year, max);
                }
                
            }
        }
        if(min == 99999){
            min = 2015;
        }
        if(min < 2013){
            min = 2013;
        }
        if(max == -1){
            max = 2015;
        }
        bouwplan.setJaar_eerste_oplevering(min);
        bouwplan.setJaar_laatste_oplevering(max);
    }

    private int aggregateFuzzy(List<Map<String, Object>> values, String index, boolean useRealised, boolean realised) {
        int value = 0;
        for (Map<String, Object> jaar : values) {
            String yearString = (String) jaar.get("Jaar");
            Integer year = Integer.parseInt(yearString);
            if(year < 2013){
                continue;
            }
            for (String key : jaar.keySet()) {
                if (key.contains(index)) {
                    value += jaar.containsKey(key) ? (Integer) jaar.get(key) : 0;
                }
            }
        }
        return value;
    }

    private int aggregate(List<Map<String, Object>> values, String index) {
        int value = 0;
        for (Map<String, Object> jaar : values) {
            String yearString = (String) jaar.get("Jaar");
            Integer year = Integer.parseInt(yearString);
            if(year < 2013){
                continue;
            }
            if (jaar.containsKey(index + "Eensgezins")) {
                value += jaar.containsKey(index + "Eensgezins") ? (Integer) jaar.get(index + "Eensgezins") : 0;
                value += jaar.containsKey(index + "Meergezins") ? (Integer) jaar.get(index + "Meergezins") : 0;
                value += jaar.containsKey(index + "Onbekend") ? (Integer) jaar.get(index + "Onbekend") : 0;
            }
        }
        return value;
    }


    public static List makefactList(int resultType, Bouwplan bouwplan) {
        EntityManager em = Stripersist.getEntityManager();

        List tempList = new ArrayList();

        List jaren = em.createQuery("from Periode order by id asc").getResultList();
        for (Iterator it = jaren.iterator(); it.hasNext();) {
            Periode periode = (Periode) it.next();

            Map jaarmap = new HashMap();
            jaarmap.put("Jaar", periode.getJaar());
            jaarmap.put("JaarOmschrijving", periode.getOmschrijving());

            if (bouwplan != null && bouwplan.getId() != null) {
                List fmplist = em.createQuery("from Factmetperiode where "
                        + "bouwplan = :bouwplan and periode = :periode")
                        .setParameter("bouwplan", bouwplan)
                        .setParameter("periode", periode).getResultList();

                for (Iterator iter = fmplist.iterator(); iter.hasNext();) {
                    Factmetperiode fmp = (Factmetperiode) iter.next();

                    switch (fmp.getFactSoort().getId()) {
                        case BouwplanUtils.HUURGOEDKOOPEENSGEZINS:
                            jaarmap.put("HuurGoedkoopEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURGOEDKOOPMEERGEZINS:
                            jaarmap.put("HuurGoedkoopMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURGOEDKOOPONBEKEND:
                            jaarmap.put("HuurGoedkoopOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAALEENSGEZINS:
                            jaarmap.put("HuurSociaalEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAALMEERGEZINS:
                            jaarmap.put("HuurSociaalMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAALONBEKEND:
                            jaarmap.put("HuurSociaalOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAAL3EENSGEZINS:
                            jaarmap.put("HuurSociaal3Eensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAAL3MEERGEZINS:
                            jaarmap.put("HuurSociaal3Meergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAAL3ONBEKEND:
                            jaarmap.put("HuurSociaal3Onbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAAL4EENSGEZINS:
                            jaarmap.put("HuurSociaal4Eensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAAL4MEERGEZINS:
                            jaarmap.put("HuurSociaal4Meergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURSOCIAAL4ONBEKEND:
                            jaarmap.put("HuurSociaal4Onbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURMARKTEENSGEZINS:
                            jaarmap.put("HuurMarktEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURMARKTMEERGEZINS:
                            jaarmap.put("HuurMarktMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURMARKTONBEKEND:
                            jaarmap.put("HuurMarktOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURMARKT2EENSGEZINS:
                            jaarmap.put("HuurMarkt2Eensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURMARKT2MEERGEZINS:
                            jaarmap.put("HuurMarkt2Meergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURMARKT2ONBEKEND:
                            jaarmap.put("HuurMarkt2Onbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURONBEKENDEENSGEZINS:
                            jaarmap.put("HuurOnbekendEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURONBEKENDMEERGEZINS:
                            jaarmap.put("HuurOnbekendMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.HUURONBEKENDONBEKEND:
                            jaarmap.put("HuurOnbekendOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPSOCIAALEENSGEZINS:
                            jaarmap.put("KoopSociaalEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPSOCIAALMEERGEZINS:
                            jaarmap.put("KoopSociaalMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPSOCIAALONBEKEND:
                            jaarmap.put("KoopSociaalOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKTEENSGEZINS:
                            jaarmap.put("KoopMarktEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKTMEERGEZINS:
                            jaarmap.put("KoopMarktMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKTONBEKEND:
                            jaarmap.put("KoopMarktOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT2EENSGEZINS:
                            jaarmap.put("KoopMarkt2Eensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT2MEERGEZINS:
                            jaarmap.put("KoopMarkt2Meergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT2ONBEKEND:
                            jaarmap.put("KoopMarkt2Onbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT3EENSGEZINS:
                            jaarmap.put("KoopMarkt3Eensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT3MEERGEZINS:
                            jaarmap.put("KoopMarkt3Meergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT3ONBEKEND:
                            jaarmap.put("KoopMarkt3Onbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT4EENSGEZINS:
                            jaarmap.put("KoopMarkt4Eensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT4MEERGEZINS:
                            jaarmap.put("KoopMarkt4Meergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPMARKT4ONBEKEND:
                            jaarmap.put("KoopMarkt4Onbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPONBEKENDEENSGEZINS:
                            jaarmap.put("KoopOnbekendEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPONBEKENDMEERGEZINS:
                            jaarmap.put("KoopOnbekendMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.KOOPONBEKENDONBEKEND:
                            jaarmap.put("KoopOnbekendOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.ONBEKENDONBEKEND:
                            jaarmap.put("OnbekendOnbekend", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.ONBEKENDEENSGEZINS:
                            jaarmap.put("OnbekendEensgezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.ONBEKENDMEERGEZINS:
                            jaarmap.put("OnbekendMeergezins", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.SLOOP:
                            jaarmap.put("Sloop", factAantal(resultType, fmp));
                            break;
                        case BouwplanUtils.GEREALISEERD:
                            jaarmap.put("Gerealiseerd", Gerealiseerd.fromOrdinal(factAantal(resultType, fmp)));
                            break;
                    }
                }
                jaarmap.put("Nieuwbouw", factAantalNieuwbouw(resultType, periode, bouwplan));

                /* Voor alle extra velden van het geselecteerde jaar word een list gemaakt, met
                 * daarin per veld een map met id, soortid en aantal. Id is nodig om nieuwe waardes
                 * weer op te kunnen slaan.
                 */
                List extravelden = em.createQuery("from Extraveld where bouwplan = :bouwplan and periode = :periode")
                        .setParameter("bouwplan", bouwplan)
                        .setParameter("periode", periode).getResultList();

                List velden = new ArrayList();

                for (Iterator er = extravelden.iterator(); er.hasNext();) {
                    Extraveld extraveld = (Extraveld) er.next();
                    Map extra = new HashMap();
                    extra.put("id", extraveld.getId());
                    extra.put("soort", extraveld.getExtraveldsoort().getId());
                    extra.put("soortnaam", extraveld.getExtraveldsoort().getType());
                    if (resultType == FACT_GEPLAND) {
                        extra.put("aantal", extraveld.getAantalgepland());
                    }

                    velden.add(extra);
                }
                jaarmap.put("extravelden", velden);

                tempList.add(jaarmap);
            } else {
                // maak lege lijst zodat alle velden wel op het scherm verschijnen
                jaarmap.put("HuurGoedkoopEensgezins", factAantal(resultType, null));
                jaarmap.put("HuurGoedkoopMeergezins", factAantal(resultType, null));
                jaarmap.put("HuurGoedkoopOnbekend", factAantal(resultType, null));
                jaarmap.put("HuurSociaalEensgezins", factAantal(resultType, null));
                jaarmap.put("HuurSociaalMeergezins", factAantal(resultType, null));
                jaarmap.put("HuurSociaalOnbekend", factAantal(resultType, null));
                jaarmap.put("HuurSociaal3Eensgezins", factAantal(resultType, null));
                jaarmap.put("HuurSociaal3Meergezins", factAantal(resultType, null));
                jaarmap.put("HuurSociaal3Onbekend", factAantal(resultType, null));
                jaarmap.put("HuurSociaal4Eensgezins", factAantal(resultType, null));
                jaarmap.put("HuurSociaal4Meergezins", factAantal(resultType, null));
                jaarmap.put("HuurSociaal4Onbekend", factAantal(resultType, null));
                jaarmap.put("HuurMarktEensgezins", factAantal(resultType, null));
                jaarmap.put("HuurMarktMeergezins", factAantal(resultType, null));
                jaarmap.put("HuurMarktOnbekend", factAantal(resultType, null));
                jaarmap.put("HuurMarkt2Eensgezins", factAantal(resultType, null));
                jaarmap.put("HuurMarkt2Meergezins", factAantal(resultType, null));
                jaarmap.put("HuurMarkt2Onbekend", factAantal(resultType, null));
                jaarmap.put("HuurOnbekendEensgezins", factAantal(resultType, null));
                jaarmap.put("HuurOnbekendMeergezins", factAantal(resultType, null));
                jaarmap.put("HuurOnbekendOnbekend", factAantal(resultType, null));
                jaarmap.put("KoopSociaalEensgezins", factAantal(resultType, null));
                jaarmap.put("KoopSociaalMeergezins", factAantal(resultType, null));
                jaarmap.put("KoopSociaalOnbekend", factAantal(resultType, null));
                jaarmap.put("KoopMarktEensgezins", factAantal(resultType, null));
                jaarmap.put("KoopMarktMeergezins", factAantal(resultType, null));
                jaarmap.put("KoopMarktOnbekend", factAantal(resultType, null));
                jaarmap.put("KoopMarkt2Eensgezins", factAantal(resultType, null));
                jaarmap.put("KoopMarkt2Meergezins", factAantal(resultType, null));
                jaarmap.put("KoopMarkt2Onbekend", factAantal(resultType, null));
                jaarmap.put("KoopMarkt3Eensgezins", factAantal(resultType, null));
                jaarmap.put("KoopMarkt3Meergezins", factAantal(resultType, null));
                jaarmap.put("KoopMarkt3Onbekend", factAantal(resultType, null));
                jaarmap.put("KoopMarkt4Eensgezins", factAantal(resultType, null));
                jaarmap.put("KoopMarkt4Meergezins", factAantal(resultType, null));
                jaarmap.put("KoopMarkt4Onbekend", factAantal(resultType, null));
                jaarmap.put("KoopOnbekendEensgezins", factAantal(resultType, null));
                jaarmap.put("KoopOnbekendMeergezins", factAantal(resultType, null));
                jaarmap.put("KoopOnbekendOnbekend", factAantal(resultType, null));
                jaarmap.put("OnbekendOnbekend", factAantal(resultType, null));
                jaarmap.put("OnbekendEensgezins", factAantal(resultType, null));
                jaarmap.put("OnbekendMeergezins", factAantal(resultType, null));
                jaarmap.put("Nieuwbouw", factAantal(resultType, null));
                jaarmap.put("Sloop", factAantal(resultType, null));
                jaarmap.put("Gerealiseerd", factAantal(resultType, null));

                tempList.add(jaarmap);
            }
        }

        return tempList;
    }


    private static Integer factAantal(int resultType, Factmetperiode fmp) {
        Integer result = null;
        if (fmp == null) {
            result = 0;
        } else if (resultType == FACT_GEPLAND) {
            result = fmp.getPlanningaantal();
        }

        return result;
    }


    private static Integer factAantalNieuwbouw(int resultType, Periode p, Bouwplan bouwplan) {
        EntityManager em = Stripersist.getEntityManager();
        Integer result = 0;
        if (p == null) {
            result = 0;
        } else if (resultType == FACT_GEPLAND) {
            Long aantal = (Long) em.createQuery("select sum(planningaantal) from Factmetperiode where "
                    + "bouwplan = :bouwplan and periode = :periode "
                    + "and factsoortid != 1 and factsoortid != 2 and factsoortid != 27")
                    .setParameter("bouwplan", bouwplan)
                    .setParameter("periode", p).getSingleResult();
            if (aantal != null) {
                result = aantal.intValue();
            }
        }

        return result;
    }
    // <editor-fold defaultstate="collapsed" desc="Getters enzo">
    public ActionBeanContext getContext() {
        return context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public boolean isCommit() {
        return commit;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public Bouwplan getBouwplan() {
        return bouwplan;
    }

    public void setBouwplan(Bouwplan bouwplan) {
        this.bouwplan = bouwplan;
    }

    public Provincie getProvincie() {
        return provincie;
    }

    public void setProvincie(Provincie provincie) {
        this.provincie = provincie;
    }

    public boolean isRemoveOld() {
        return removeOld;
    }

    public void setRemoveOld(boolean removeOld) {
        this.removeOld = removeOld;
    }
    
    public boolean isMakeVars() {
        return makeVars;
    }

    public void setMakeVars(boolean makeVars) {
        this.makeVars = makeVars;
    }


    //</editor-fold>

}
