/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import nl.b3p.pzh.rwbp.MD5Hasher;
import nl.b3p.pzh.rwbp.SldMapEntry;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieService;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.export.ExportConfigServlet;
import static nl.b3p.pzh.rwbp.stripes.SearchActionBean.getSldMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Roy Braam
 */
@StrictBinding
public class ViewerActionBean implements ActionBean {

    private static final Log log = LogFactory.getLog(ViewerActionBean.class);

    protected ActionBeanContext context;
    protected Gebruiker gebruiker;
    private String naamGebruiker;
    private Boolean isBeheerder = false;
    private Boolean isGemeente = false;
    private Provincie resolvedProvincie;
    private String mail;
    private String about;
    private String help;

    // Map variables
    private String layers = "";
    private String querylayers = "";
    private String httpRequestParams = "";

    private String absoluteUrlPrefix;
    private String mapserverUrl;

    private String sldkey_eenvoudig;
    private static final String SLD_MAP_ATTR = "SLDMAP";
    private static final int EXPIRATIONTIMESLDENTRY = 1000 * 60 * 60 * 8;

    private List<ProvincieService> provincieServices = new ArrayList<ProvincieService>();

    @Before(stages = LifecycleStage.HandlerResolution)
    public void gebruikerOphalen() {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker) context.getRequest().getUserPrincipal();

        if (ingelogd != null) {
            gebruiker = em.find(Gebruiker.class, ingelogd.getId());
            naamGebruiker = gebruiker.getFullname();
            isBeheerder = gebruiker.isBeheerder();

            Gemeente gemeente = gebruiker.getGemeente();
            if (gemeente != null) {
                isGemeente = true;
            } else {
                isGemeente = false;
            }
            resolvedProvincie = gebruiker.resolveProvincie();

            Hibernate.initialize(resolvedProvincie);

            List<ConfigurableVariable> vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", VariableType.GENERAL).getResultList();
            List<ProvincieVariable> provincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie AND variable in :vars").setParameter("provincie", resolvedProvincie).setParameter("vars", vars).getResultList();
            for (ProvincieVariable provincieVariable : provincieVars) {
                ConfigurableVariable var = provincieVariable.getVariable();
                if (var.getName().equals("mailadress")) {
                    mail = provincieVariable.getValue();
                } else if (var.getName().equals("aboutlink")) {
                    about = provincieVariable.getValue();
                } else if (var.getName().equals("helplink")) {
                    help = provincieVariable.getValue();
                }
            }

        }else{
            naamGebruiker = "Openbaar";
        }
    }

    // Map variables
    private void initUrls() {
        HttpServletRequest request = context.getRequest();

        String address = null;
        try {
            address = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), "").toString();
        } catch (MalformedURLException ex) {
            log.error(ex);
        }
        absoluteUrlPrefix = address;
        mapserverUrl = ExportConfigServlet.getMapserverUrl();
    }

    @Before(stages = LifecycleStage.BindingAndValidation)
    public void initViewer() {
        initUrls();
        initLayers();
        layers = "bouwplan_openbaar";
        querylayers = "bouwplan_openbaar";

        if (gebruiker != null) {
            if (getGebruiker().getGemeente() != null) {
                int gemeenteid = getGebruiker().getGemeente().getId();
                layers += ",bouwplan_gemeente";
                querylayers += ",bouwplan_gemeente";
                httpRequestParams = "gemeenteid=" + gemeenteid;
            } else if (getGebruiker().getRegio() != null) {
                int regioid = getGebruiker().getRegio().getId();
                layers += ",bouwplan_regio";
                querylayers += ",bouwplan_regio";
                httpRequestParams = "regioid=" + regioid;
            } else if (getGebruiker().getProvincie() != null) {
                int provincieid = getGebruiker().getProvincie().getId();
                layers += ",bouwplan_provincie";
                querylayers += ",bouwplan_provincie";
                httpRequestParams = "provincieid=" + provincieid;
            } else if (gebruiker.isRijk()) {
                layers += ",bouwplan_rijk";
                querylayers += ",bouwplan_rijk";
            }

            EntityManager em = Stripersist.getEntityManager();
            Provincie p = gebruiker.resolveProvincie();
            if (p != null) {
                provincieServices = em.createQuery("from ProvincieService where provincie = :provincie").setParameter("provincie", p).getResultList();
            }
        }
    }

    protected void initLayers() {
        String[] extraLagen = new String[0];
        String extraLaagId = "";
        if (gebruiker != null) {
            extraLagen = new String[1];
            if (gebruiker.getGemeente() != null) {
                extraLaagId += gebruiker.getGemeente().getId();
                extraLagen[0] = "bouwplan_gemeente";
            } else if (gebruiker.getRegio() != null) {
                extraLaagId += gebruiker.getRegio().getId();
                extraLagen[0] = "bouwplan_regio";
            } else if (gebruiker.getProvincie() != null) {
                extraLaagId += gebruiker.getProvincie().getId();
                extraLagen[0] = "bouwplan_provincie";
            } else if (gebruiker.isRijk()) {
                extraLagen[0] = "bouwplan_rijk";
            }
        }
        createHashMapEntry(layers, "", "", "", extraLagen, extraLaagId);
    }

    private void createHashMapEntry(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagId) {
        ServletContext sc = context.getServletContext();
        synchronized (sc) {
            Map<String, SldMapEntry> sldMap = getSldMap(sc);
            String parameterString = createParameterString(layers, cbpids, obpids, cbpnrs, extraLagen, extraLaagId);
            if (!sldMap.containsKey(parameterString)) {
                sldkey_eenvoudig = createHash(parameterString);
                sldMap.put(sldkey_eenvoudig, new SldMapEntry(cbpids, obpids, cbpnrs, layers, extraLagen, extraLaagId));
            }
        }
    }

    private String createParameterString(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagid) {

        String parameterString = cbpids + obpids + cbpnrs + layers;
        for (String extraLaag : extraLagen) {
            parameterString += extraLaag;
        }
        parameterString += extraLaagid;
        return parameterString;
    }

    private String createHash(String parameterString) {
        try {
            return MD5Hasher.MD5(parameterString);
        } catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        } catch (UnsupportedEncodingException ex) {
            log.error(ex.getMessage());
        }
        return null;

    }

    private static void expireSldMapEntries(Map<String, SldMapEntry> map) {
        List<String> keysToExpire = new ArrayList<String>();
        long currentTime = new Date().getTime();
        for (Map.Entry<String, SldMapEntry> entry : map.entrySet()) {
            long entryTime = entry.getValue().getStart().getTime();
            if ((currentTime - entryTime) >= EXPIRATIONTIMESLDENTRY) {
                keysToExpire.add(entry.getKey());
            }
        }
        for (String key : keysToExpire) {
            log.debug("Removing expired SLD for key " + key);
            map.remove(key);
        }
    }

    public static Map<String, SldMapEntry> getSldMap(ServletContext sc) {
        synchronized (sc) {
            Map<String, SldMapEntry> sldMap = (Map<String, SldMapEntry>) sc.getAttribute(SLD_MAP_ATTR);
            if (sldMap == null) {
                sldMap = Collections.synchronizedMap(new HashMap<String, SldMapEntry>());
                sc.setAttribute(SLD_MAP_ATTR, sldMap);
            } else {
                expireSldMapEntries(sldMap);
            }

            return sldMap;
        }
    }

    //<editor-fold defaultstate="collapsed" desc="Getters setters">
    public ActionBeanContext getContext() {
        return context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Gebruiker getGebruiker() {
        return gebruiker;
    }

    public void setGebruiker(Gebruiker gebruiker) {
        this.gebruiker = gebruiker;
    }

    public String getNaamGebruiker() {
        return naamGebruiker;
    }

    public void setNaamGebruiker(String naamGebruiker) {
        this.naamGebruiker = naamGebruiker;
    }

    public Boolean getIsBeheerder() {
        return isBeheerder;
    }

    public void setIsBeheerder(Boolean isBeheerder) {
        this.isBeheerder = isBeheerder;
    }

    public Boolean getIsGemeente() {
        return isGemeente;
    }

    public void setIsGemeente(Boolean isGemeente) {
        this.isGemeente = isGemeente;
    }

    public Provincie getResolvedProvincie() {
        return resolvedProvincie;
    }

    public void setResolvedProvincie(Provincie resolvedProvincie) {
        this.resolvedProvincie = resolvedProvincie;
    }

    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getAbout() {
        return about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public String getHelp() {
        return help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getLayers() {
        return layers;
    }

    public void setLayers(String layers) {
        this.layers = layers;
    }

    public String getQuerylayers() {
        return querylayers;
    }

    public void setQuerylayers(String querylayers) {
        this.querylayers = querylayers;
    }

    public String getHttpRequestParams() {
        return httpRequestParams;
    }

    public void setHttpRequestParams(String httpRequestParams) {
        this.httpRequestParams = httpRequestParams;
    }

    public String getAbsoluteUrlPrefix() {
        return absoluteUrlPrefix;
    }

    public void setAbsoluteUrlPrefix(String absoluteUrlPrefix) {
        this.absoluteUrlPrefix = absoluteUrlPrefix;
    }

    public String getMapserverUrl() {
        return mapserverUrl;
    }

    public void setMapserverUrl(String mapserverUrl) {
        this.mapserverUrl = mapserverUrl;
    }

    public String getSldkey_eenvoudig() {
        return sldkey_eenvoudig;
    }

    public void setSldkey_eenvoudig(String sldkey_eenvoudig) {
        this.sldkey_eenvoudig = sldkey_eenvoudig;
    }

    public List<ProvincieService> getProvincieServices() {
        return provincieServices;
    }

    public void setProvincieServices(List<ProvincieService> provincieServices) {
        this.provincieServices = provincieServices;
    }

    //</editor-fold>
}
