-- View: volledig_overzicht_shape_view
drop view volledig_hoofdscherm_view;
DROP VIEW volledig_overzicht_shape_view;

CREATE OR REPLACE VIEW volledig_overzicht_shape_view AS 
 SELECT b.the_geom,
    b.id,
    to_char(b.datumlaatstewijziging, 'DD-MM-YYYY') as gewijzigd,
    b.plan_identificatie AS planidentificatie,
    b.naam,
    gem.naam AS gemeente,
    b.plaatsnaam,
    r.naam AS regio,
    b.referentienummer,
    b.bestemmingsplannaam,
    b.imronummer,
    b.masterplan,
    ot.type AS opdrachtg_type,
    b.ontwikkelaar_namelijk AS opdrachtge_namelijk,

    b.knelpunten,

    g.naam AS gebruikgegevens,
    sp.type AS status_plan,
    stp.type AS status_proj,

    b.jaar_eerste_oplevering,
    b.jaar_laatste_oplevering,
    b.totaalcapaciteit,
    b.gerealiseerdecapaciteit AS gereal_cap,
    b.restcapaciteit,
    
    b.resterendesloop AS rest_sloop,
    b.totaalsloop as totaal_sloop,
    b.gerealiseerdesloop as gerealiseerde_sloop,

    b.meergezins,
    b.eensgezins,
    b.woningtypeonbekend as onbekend,
    
    b.huur1,
    b.huur2,
    b.huur3,
    b.huur4,
    b.huurprijsonbekend,
    b.huurtotaal,

    b.koop1,
    b.koop2,
    b.koop3,
    b.koop4,
    b.kooptotaal,
    b.koopprijsonbekend,

    b.detail_type,
    b.detail_type_sloop,
    p.type as plantype,
    w.type as woonmilieu_abf6,
    b.woonmilieuabf14 as woonmilieuabf14

   FROM bouwplan b
     LEFT JOIN ontwikkelaartype ot ON b.ontwikkelaartypeid = ot.id
     LEFT JOIN plantype p ON b.plantypeid = p.id
     LEFT JOIN woonmilieu w ON b.woonmilieuid = w.id
     LEFT JOIN gebruikgegevens g ON b.gebruikgegevensid = g.id
     LEFT JOIN gemeente gem ON b.gemeenteid = gem.id
     LEFT JOIN regio r ON r.id = gem.regioid
     JOIN statusplanologisch sp ON b.statusplanologischid = sp.id
     JOIN statusproject stp ON stp.id = b.statusprojectid;

ALTER TABLE volledig_overzicht_shape_view
  OWNER TO planmonitor;
-- View: volledig_overzicht_view

-- 

-- View: volledig_detailplanning_view

 
drop view volledig_detailplanning_view;
CREATE OR REPLACE VIEW volledig_detailplanning_view AS 

--3. wel detailplanning sloop, wel detailplanning plancapaciteit

SELECT 
    bv.id AS bvid,
    bv.bouwplan AS id,
    bv.year,
    bv.gepland,
    bv.sloop,
    bv.eengezinshuur1,
    bv.eengezinshuur2,
    bv.eengezinshuur3,
    bv.eengezinshuur4,
    bv.eengezinshuuronb,
    bv.eengezinskoop1,
    bv.eengezinskoop2,
    bv.eengezinskoop3,
    bv.eengezinskoop4,
    bv.eengezinskooponb,
    bv.meergezinshuur1,
    bv.meergezinshuur2,
    bv.meergezinshuur3,
    bv.meergezinshuur4,
    bv.meergezinshuuronb,
    bv.meergezinskoop1,
    bv.meergezinskoop2,
    bv.meergezinskoop3,
    bv.meergezinskoop4,
    bv.meergezinskooponb,
    bv.onbekendhuur1,
    bv.onbekendhuur2,
    bv.onbekendhuur3,
    bv.onbekendhuur4,
    bv.onbekendhuuronb,
    bv.onbekendkoop1,
    bv.onbekendkoop2,
    bv.onbekendkoop3,
    bv.onbekendkoop4,
    bv.onbekendkooponb,
    bv.onbekendgerealiseerd,
    bv.eengezinsgerealiseerd,
    bv.meergezinsgerealiseerd,
    bv.gerealiseerd,
    bv.gerealiseerdesloop,
    bv.meergezinsonbekend,
    bv.eengezinsonbekend,
    bv.onbekendonbekend
   FROM bouwplan_variable bv inner join bouwplan bp on bv.bouwplan = bp.id
   where (bp.detail_type = 'uitgebreid' or bp.detail_type = 'normaal' ) and bp.detail_type_sloop = 'normaal'

   UNION
   
--1. geen detailplanning sloop, geen detailplanning plancapaciteit

select 
row_number() over ()::integer as bvid,
id,
0,
totaalcapaciteit,
totaalsloop,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
false,
false,
false,
false,
false,
0,
0,
0
from bouwplan 
where (detail_type = 'Geen detailplanning' or detail_type is null) and ( detail_type_sloop is null or detail_type_sloop = 'Geen detailplanning voor sloop')

UNION

--2. wel detailplanning sloop, geen detailplanning plancapaciteit

-- totaalcapaciteit uit bouwplan
select 
row_number() over ()::integer as bvid,
id,
0,
totaalcapaciteit,
null,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
null,
null,
null,
null,
null,
0,
0,
0
from bouwplan 
where (detail_type = 'Geen detailplanning' or detail_type is null) and detail_type_sloop = 'normaal'
UNION
-- sloop uit bouwplan_variable

 SELECT 
    bv.id AS bvid,
    bv.bouwplan AS id,
    bv.year,
    null,
    bv.sloop,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null
   FROM bouwplan_variable bv inner join bouwplan bp on bv.bouwplan = bp.id
   where (bp.detail_type = 'Geen detailplanning' or bp.detail_type is null) and bp.detail_type_sloop = 'normaal'

UNION

--4. geen detailplanning sloop, wel detailplanning plancapaciteit


SELECT 
    bv.id AS bvid,
    bv.bouwplan AS id,
    bv.year,
    bv.gepland,
    null,
    bv.eengezinshuur1,
    bv.eengezinshuur2,
    bv.eengezinshuur3,
    bv.eengezinshuur4,
    bv.eengezinshuuronb,
    bv.eengezinskoop1,
    bv.eengezinskoop2,
    bv.eengezinskoop3,
    bv.eengezinskoop4,
    bv.eengezinskooponb,
    bv.meergezinshuur1,
    bv.meergezinshuur2,
    bv.meergezinshuur3,
    bv.meergezinshuur4,
    bv.meergezinshuuronb,
    bv.meergezinskoop1,
    bv.meergezinskoop2,
    bv.meergezinskoop3,
    bv.meergezinskoop4,
    bv.meergezinskooponb,
    bv.onbekendhuur1,
    bv.onbekendhuur2,
    bv.onbekendhuur3,
    bv.onbekendhuur4,
    bv.onbekendhuuronb,
    bv.onbekendkoop1,
    bv.onbekendkoop2,
    bv.onbekendkoop3,
    bv.onbekendkoop4,
    bv.onbekendkooponb,
    bv.onbekendgerealiseerd,
    bv.eengezinsgerealiseerd,
    bv.meergezinsgerealiseerd,
    bv.gerealiseerd,
    bv.gerealiseerdesloop,
    bv.meergezinsonbekend,
    bv.eengezinsonbekend,
    bv.onbekendonbekend
   FROM bouwplan_variable bv inner join bouwplan bp on bv.bouwplan = bp.id
   where (bp.detail_type = 'uitgebreid' or bp.detail_type = 'normaal' ) and (bp.detail_type_sloop = 'Geen detailplanning voor sloop' or bp.detail_type_sloop is null)

   UNION

   select 
row_number() over ()::integer as bvid,
id,
0,
null,
totaalsloop,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
null,
null,
null,
null,
null,
0,
0,
0
from bouwplan 
where (detail_type = 'Geen detailplanning' or detail_type is null) and detail_type_sloop = 'normaal';


ALTER TABLE volledig_detailplanning_view
  OWNER TO planmonitor;

alter view volledig_detailplanning_view owner to planmonitor;


CREATE OR REPLACE VIEW volledig_hoofdscherm_view AS 
 SELECT 
 volledig_overzicht_shape_view.id,
    volledig_overzicht_shape_view.gewijzigd,
    volledig_overzicht_shape_view.planidentificatie,
    volledig_overzicht_shape_view.naam as plannaam,
    volledig_overzicht_shape_view.gemeente,
    volledig_overzicht_shape_view.plaatsnaam,
    volledig_overzicht_shape_view.regio,
    volledig_overzicht_shape_view.referentienummer,
    volledig_overzicht_shape_view.bestemmingsplannaam,
    volledig_overzicht_shape_view.imronummer,
    volledig_overzicht_shape_view.masterplan,
    volledig_overzicht_shape_view.opdrachtg_type as opdr_type,
    volledig_overzicht_shape_view.opdrachtge_namelijk AS opdr_nml,
    volledig_overzicht_shape_view.gebruikgegevens,
    volledig_overzicht_shape_view.status_plan,
    volledig_overzicht_shape_view.knelpunten,
    volledig_overzicht_shape_view.status_proj,
    volledig_overzicht_shape_view.jaar_eerste_oplevering,
    volledig_overzicht_shape_view.jaar_laatste_oplevering,
    volledig_overzicht_shape_view.totaalcapaciteit as totaalcap,
    volledig_overzicht_shape_view.gereal_cap  AS gereal_cap,
    volledig_overzicht_shape_view.restcapaciteit as restcap,
    volledig_overzicht_shape_view.rest_sloop,
    volledig_overzicht_shape_view.gerealiseerde_sloop  as gereal_slp,
    volledig_overzicht_shape_view.totaal_sloop as totaal_slp,
    volledig_overzicht_shape_view.detail_type as detailcap,
    volledig_overzicht_shape_view.detail_type_sloop as detailslp,
    volledig_overzicht_shape_view.plantype,
    volledig_overzicht_shape_view.woonmilieu_abf6 as woonmabf6,
    volledig_overzicht_shape_view.woonmilieuabf14 as woonmabf14,
    volledig_overzicht_shape_view.meergezins,
    volledig_overzicht_shape_view.eensgezins as eengezins,
    volledig_overzicht_shape_view.onbekend,
    volledig_overzicht_shape_view.huur1,
    volledig_overzicht_shape_view.huur2,
    volledig_overzicht_shape_view.huur3,
    volledig_overzicht_shape_view.huur4,
    volledig_overzicht_shape_view.huurprijsonbekend,
    volledig_overzicht_shape_view.huurtotaal,
    volledig_overzicht_shape_view.koop1,
    volledig_overzicht_shape_view.koop2,
    volledig_overzicht_shape_view.koop3,
    volledig_overzicht_shape_view.koop4,
    volledig_overzicht_shape_view.kooptotaal,
    volledig_overzicht_shape_view.koopprijsonbekend,
    volledig_overzicht_shape_view.totaalcapaciteit - (volledig_overzicht_shape_view.huurtotaal + volledig_overzicht_shape_view.kooptotaal) as onb_kp_hr
    
   FROM volledig_overzicht_shape_view;

ALTER TABLE volledig_hoofdscherm_view
  OWNER TO planmonitor;



----
drop view basis_shape ;
create or replace view basis_shape as
select b.id, b.naam as plannaam, g.naam as gemeente, b.the_geom
from bouwplan b inner join gemeente g on b.gemeenteid = g.id;


ALTER TABLE basis_shape
  OWNER TO planmonitor;

drop view eenvoudig_optional_variables_view;
drop view volledig_optional_variables_view;

  create view volledig_optional_variables_view as

select 
b.id, 
case 
when exists (select label 
from configurable_variable cv inner join provincie_variable pav 
on pav.config_variable = cv.id where type =  'OPTIONAL' and provincie = g.provincie  and name = 'woonmilieu_abf-14')  
then b.woonmilieuabf14
else  null
end as "Woonmilieu ABF-14",

case 
when exists (select label 
from configurable_variable cv inner join provincie_variable pav 
on pav.config_variable = cv.id where type =  'OPTIONAL' and provincie = g.provincie and name = 'woonmilieu_abf')  
then wm.type
else  null
end as "Woonmilieu ABF-6",

case 
when exists (select label 
from configurable_variable cv inner join provincie_variable pav 
on pav.config_variable = cv.id where type =  'OPTIONAL' and provincie = g.provincie  and name = 'type_woning')  
then pt.type
else  null
end as "Plantype"

from bouwplan b 
inner join gemeente g on g.id = b.gemeenteid
inner join woonmilieu wm on wm.id = b.woonmilieuid
inner join plantype pt on pt.id = b.plantypeid;

alter table volledig_optional_variables_view owner to planmonitor;



create view eenvoudig_optional_variables_view as 
	select * from volledig_optional_variables_view;


alter table eenvoudig_optional_variables_view owner to planmonitor;


-- View: volledig_totaal_uitgebreid_view

-- DROP VIEW volledig_totaal_uitgebreid_view;

-- View: volledig_totaal_uitgebreid_view

 -- View: volledig_totaal_uitgebreid_view

-- DROP VIEW volledig_totaal_uitgebreid_view;

CREATE OR REPLACE VIEW volledig_totaal_uitgebreid_view AS 
 SELECT 
    bp.id AS bvid,
    bp.bouwplan AS id,
    bp.year,
    bp.gepland,
    bp.sloop,
    bp.eengezinshuur1,
    bp.eengezinshuur2,
    bp.eengezinshuur3,
    bp.eengezinshuur4,
    bp.eengezinshuuronb,
    bp.eengezinskoop1,
    bp.eengezinskoop2,
    bp.eengezinskoop3,
    bp.eengezinskoop4,
    bp.eengezinskooponb,
    bp.meergezinshuur1,
    bp.meergezinshuur2,
    bp.meergezinshuur3,
    bp.meergezinshuur4,
    bp.meergezinshuuronb,
    bp.meergezinskoop1,
    bp.meergezinskoop2,
    bp.meergezinskoop3,
    bp.meergezinskoop4,
    bp.meergezinskooponb,
    bp.onbekendhuur1,
    bp.onbekendhuur2,
    bp.onbekendhuur3,
    bp.onbekendhuur4,
    bp.onbekendhuuronb,
    bp.onbekendkoop1,
    bp.onbekendkoop2,
    bp.onbekendkoop3,
    bp.onbekendkoop4,
    bp.onbekendkooponb,
    bp.onbekendgerealiseerd,
    bp.eengezinsgerealiseerd,
    bp.meergezinsgerealiseerd,
    bp.gerealiseerd,
    bp.gerealiseerdesloop,
    bp.meergezinsonbekend,
    bp.eengezinsonbekend,
    bp.onbekendonbekend
   FROM bouwplan_variable bp
union
select row_number() over ()::integer as bvid,
id,
0,
totaalcapaciteit,
totaalsloop,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
null,
null,
null,
null,
null,
0,
0,
0
from bouwplan 
   ;

ALTER TABLE volledig_totaal_uitgebreid_view
  OWNER TO planmonitor;


-- View: eenvoudig_overzicht_shape_view

 DROP VIEW eenvoudig_overzicht_shape_view;
 -- View: eenvoudig_overzicht_shape_view

-- DROP VIEW eenvoudig_overzicht_shape_view;

CREATE OR REPLACE VIEW eenvoudig_overzicht_shape_view AS 
 SELECT b.the_geom,
    b.id,
    to_char(b.datumlaatstewijziging, 'DD-MM-YYYY'::text) AS gewijzigd,
    b.plan_identificatie AS planidentificatie,
    b.naam as plannaam,
    g.naam AS gemeente,
    b.plaatsnaam,
    r.naam AS regio,
    b.referentienummer,
    b.bestemmingsplannaam,
    b.imronummer,
    b.masterplan,
    o.type AS opdr_type,
    b.ontwikkelaar_namelijk AS opdr_nml,
    gg.naam AS gebruikgegevens,
    p.type AS plantype,
    s.type AS status_plan,
    sp.type AS status_proj,
    b.knelpunten,
    b.jaar_eerste_oplevering,
    b.jaar_laatste_oplevering,
    b.totaalcapaciteit as totaalcap,
    b.gerealiseerdecapaciteit AS gereal_cap,
    b.restcapaciteit as restcap,
    b.resterendesloop AS rest_sloop,
    b.totaalsloop as totaal_slp,
    b.gerealiseerdesloop as gereal_slp,
    b.detail_type as detailcap,
    b.detail_type_sloop detailslp,
    b.woonmilieuabf14 AS woonmabf14,
    wm.type AS woonmabf6,
    b.meergezins,
    b.eensgezins as eengezins,
    b.woningtypeonbekend AS onbekend,
    b.huur1,
    b.huur2,
    b.huur3,
    b.huur4,
    b.huurprijsonbekend,
    b.huurtotaal,
    b.koop1,
    b.koop2,
    b.koop3,
    b.koop4,
    b.kooptotaal,
    b.koopprijsonbekend,
    b.totaalcapaciteit - (b.huurtotaal + b.kooptotaal) as onb_kp_hr/*,
    gepland.gepland2013 AS gep2013,
    gepland.gepland2014 AS gep2014,
    gepland.gepland2015 AS gep2015,
    gepland.gepland2016 AS gep2016,
    gepland.gepland2017 AS gep2017,
    gepland.gepland2018 AS gep2018,
    gepland.gepland2019 AS gep2019,
    gepland.gepland2020 AS gep2020,
    gepland.gepland2021 AS gep2021,
    gepland.gepland2022 AS gep2022,
    gepland.gepland2023 AS gep2023,
    gepland.gepland2024 AS gep2024,
    gepland.gepland2025 AS gep2025,
    gepland.gepland2026 AS gep2026,
    gepland.gepland2027 AS gep2027,
    gepland.gepland2028 AS gep2028,
    gepland.gepland2029 AS gep2029,
    gepland.gepland2030 AS gep2030,
    gepland.gepland2031 AS gep2031,
    gepland.gepland2032 AS gep2032,
    gepland.gepland2033 AS gep2033,
    gepland.gepland2034 AS gep2034,
    gepland.gepland2035 AS gep2035,
    gepland.gepland2036 AS gep2036,
    gepland.gepland2037 AS gep2037,
    gepland.gepland2038 AS gep2038,
    gepland.gepland2039 AS gep2039,
    gepland.gepland2040 AS gep2040*/
   FROM bouwplan b
     --LEFT JOIN bouwplan_data_gepland() gepland(bouwplan, gepland2013, gepland2014, gepland2015, gepland2016, gepland2017, gepland2018, gepland2019, gepland2020, gepland2021, gepland2022, gepland2023, gepland2024, gepland2025, gepland2026, gepland2027, gepland2028, gepland2029, gepland2030, gepland2031, gepland2032, gepland2033, gepland2034, gepland2035, gepland2036, gepland2037, gepland2038, gepland2039, gepland2040) ON b.id = gepland.bouwplan
     JOIN gemeente g ON b.gemeenteid = g.id
     JOIN gebruikgegevens gg ON gg.id = b.gebruikgegevensid
     JOIN regio r ON g.regioid = r.id
     LEFT JOIN ontwikkelaartype o ON b.ontwikkelaartypeid = o.id
     LEFT JOIN woonmilieu wm ON wm.id = b.woonmilieuid
     LEFT JOIN plantype p ON b.plantypeid = p.id
     JOIN statusplanologisch s ON b.statusplanologischid = s.id
     JOIN statusproject sp ON b.statusprojectid = sp.id;

ALTER TABLE eenvoudig_overzicht_shape_view
  OWNER TO planmonitor;

-- View: bouwplan_view

-- DROP VIEW bouwplan_view;


CREATE OR REPLACE VIEW bouwplan_view AS 
 SELECT b.id,
    b.the_geom,
    b.naam,
    b.gebruikgegevensid,
        CASE b.plantypeid
            WHEN 1 THEN '#048500'::text
            WHEN 2 THEN '#0000FF'::text
            WHEN 3 THEN '#FFE100'::text
            WHEN 6 THEN '#FF8800'::text
            WHEN 7 THEN '#FF2A00'::text
            WHEN 99 THEN '#C0C0C0'::text
            ELSE '#000000'::text
        END AS plantype,
    b.gemeenteid,
    g.regioid,
    g.provincie AS provincieid,
    b.statusprojectid
   FROM bouwplan b
     LEFT JOIN gemeente g ON b.gemeenteid = g.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE bouwplan_view
  OWNER TO planmonitor;
/*
drop view volledig_extravelden_view;
drop view extragepland_view;
drop view extragerealiseerd_view;
drop view volledig_aantal_view_incl_gerealiseerd;
DROP VIEW rapportage_planninghov_view;
drop view gepland_view;
drop view totalen_per_gemeente_view;
drop view info_openbaar_view;
drop view planningaantal_per_soort_per_periode_per_bouwplan;
drop view status_view;
drop view volledig_opmerking_view;*/
