<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" session="false" pageEncoding="UTF-8"%>

<stripes:layout-render name="/WEB-INF/jsp/templates/viewerTemplate.jsp" pageTitle="Exporteren">
    <stripes:layout-component name="content">
        <stripes:form id="exportForm" beanclass="nl.b3p.pzh.rwbp.stripes.ExportActionBean">
        <div class="contentpadding">
            <div class="pull-left editform" style="width: 610px;">
                <h1>Exporteren</h1>

                <p style="color:red"><stripes:messages/>
                <stripes:errors/></p>

                <strong><c:out value="${actionBean.resultCount}"/></strong> plannen geselecteerd om te exporteren
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <stripes:submit name="deleteAll" class="inputbutton searchbutton" onclick="return confirm('Weet u zeker dat u alle plannen wilt verwijderen uit de exportlijst?');">Alles verwijderen</stripes:submit>
                <stripes:submit name="print" class="inputbutton searchbutton">Printen</stripes:submit>

                <table class="exporttablehead" id="exporttablehead">
                    <tr>
                        <th style="width: 37px;">&nbsp;</th>
                        <th style="width: 267px;"><a href="#" class="sort1-1">plannaam</a></th>
                        <th style="width: 51px;"><a href="#" class="sort2-0">no.</a></th>
                        <th style="width: 104px;"><a href="#" class="sort3-0">gemeente</a></th>
                        <th style="width: 108px;"><a href="#" class="sort4-0">gebruiker</a></th>
                        <th style="width: 41px;">&nbsp;</th>
                    </tr>
                </table>

                <div class="scroll" id="scrolldiv">
                    <table class="exporttablebody" id="exporttablebody">
                        <colgroup span="7">
                            <col style="width: 35px;" />
                            <col style="width: 267px;" />
                            <col style="width: 51px;" />
                            <col style="width: 104px;" />
                            <col style="width: 108px;" />
                            <col style="width: 23px;" />
                        </colgroup>
                        <thead style="display: none;">
                            <tr>
                                <th>&nbsp;</th>
                                <th>plannaam</th>
                                <th>no.</th>
                                <th>gemeente</th>
                                <th>gebruiker</th>
                                <th>&nbsp;</th>
                            </tr>
                        </thead>
                        <tbody>
                        <c:if test="${not empty actionBean.bouwplannen}">
                        <c:set var="teller" value="1"/>
                        <c:set var="style" value="odd"/>

                        <c:forEach var="plan" items="${actionBean.bouwplannen}">
                            <tr class="${style}">
                                <td style="padding-left: 2px;"><c:out value="${teller}"/>.</td>
                                <td><c:out value="${plan.naam}"/></td>
                                <td><c:out value="${plan.id}"/></td>
                                <td><c:out value="${plan.gemeente.naam}"/></td>
                                <td><c:out value="${plan.gebruiker.fullname}"/></td>
                                <td><stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.ExportActionBean" onclick="return confirm('Weet u zeker dat u dit plan wilt verwijderen uit de exportlijst?');" event="delete"><stripes:param name="id" value="${plan.id}"/><img src="./images/delete.png" alt="delete" /></stripes:link></td>
                            </tr>
                            <c:set var="teller" value="${teller+1}"/>
                            <c:choose>
                                <c:when test="${style == 'odd'}">
                                    <c:set var="style" value="even"/>
                                </c:when>
                                <c:otherwise>
                                    <c:set var="style" value="odd"/>
                                </c:otherwise>
                            </c:choose>
                        </c:forEach>
                        </c:if>
                        </tbody>
                    </table>
                </div>

                <script type="text/javascript">
                    (function() {
                        var $div = $("#scrolldiv");
                        var $table = $("#exporttablebody");
                        if($div.height() > $table.height()) $div.height($table.height());
                        function exportModeChanged(){
                            $("#exportForm").attr("action", $("#exportForm").attr("action") + "?updateSelection");
                            $("#exportForm").submit();
                        }
                    })();
                </script>

            </div>
            <div class="pull-left editform" style="width: 300px; margin-left: 35px;">
                <h1>&nbsp;</h1>
                <strong>Type export</strong><br/>
                <stripes:checkbox name="exportvolledig" style="border:0px;"/>Volledige export <br/>
                <stripes:checkbox name="exporteenvoudig" style="border:0px;"/>Eenvoudige export <br/>
                        <c:choose>
                    <c:when test="${actionBean.geenEmail}">
                        <stripes:submit name="makeExport" disabled="disabled" value="Exporteer" class="inputbutton exportbutton disabled"/>
                    </c:when>
                    <c:otherwise>
                        <stripes:submit name="makeExport" value="Exporteer" class="inputbutton exportbutton"/>
                    </c:otherwise>
                </c:choose>
            </div>
            <div style="clear: both;"></div>
        </div>
        </stripes:form>
    </stripes:layout-component>
</stripes:layout-render>