Ext.define('B3p.planmonitor.Fields', {

    varcreator: null,
    editmode: false,
    variableid: 0,
    tableBody: null,
    editlabel: false,

    config: {
        container: '.variables-table',
        tableContainer: '.table-container',
        addClass: 'add-var',
        editClass: 'edit-var',
        removeClass: 'delete-var',
        variables: [],
        labels:[],
        regios: [],
        dialog: '#addedit-variable',
        saveurl: '',
        saveLabelUrl: '',
        removeurl: '',
        savebutton: '.save-var',
        cancelbutton: '.cancel-var'
    },

    constructor: function(config) {
        this.initConfig(config);
        this.createTable();
        this.initEditLabels();
        document.querySelector(this.config.container).addEventListener('click', this.handleEvent.bind(this));
        document.querySelector(this.config.dialog + ' ' + this.config.savebutton).addEventListener('click', this.saveVariable.bind(this));
        document.querySelector(this.config.dialog + ' ' + this.config.cancelbutton).addEventListener('click', this.cancelVariable.bind(this));
        var me = this;
        $("[name='savedOptVars_checkbox']").on('change',function(event){
            me.handleSavedOptChange(event);
        });
    },

    handleSavedOptChange : function (event){
        var input = event.currentTarget;
        var checked = input.checked;
        var value = input.value;
        var name = input.name;
        var hiddenField = $("#savedOptVars" + value);
        if(checked){
            hiddenField[0].value = value;
        }else{
            hiddenField[0].value = null;
        }
        var d = 0;
    },

    handleEvent: function(e) {
        if(e.target.className.indexOf(this.config.addClass) !== -1) {
            e.preventDefault();
            this.addVariable();
        }
        if(e.target.className.indexOf(this.config.editClass) !== -1) {
            e.preventDefault();
            this.editVariable(e.target.getAttribute('data-varid'));
        }
        if(e.target.className.indexOf(this.config.removeClass) !== -1) {
            e.preventDefault();
            this.removeVariable(e.target.getAttribute('data-varid'));
        }
    },
    
    initEditLabels: function() {
        var labels = document.querySelectorAll('.edit-labels a');
        for(var i = 0; i < labels.length; i++) {
            labels[i].addEventListener('click', this.handleEditLabel.bind(this));
        }
    },

    handleEditLabel: function(e) {
        e.preventDefault();
        var name = e.target.getAttribute('data-varlabel');
        var label = this.findLabel(name);
        if(label){
            this.editlabel = true;
        }else{
            label = {};
        }
        this._editVar({
            regios: this.config.regios,
            saveurl: this.config.saveLabelUrl,
            variableName: name,
            variableType: 'text',
            variableId: label.id,
            hideLocation: true,
            hideProvince: true,
            values: label.values,
            selectedRegios: label.regios,
            hideType: true,
            isLabel: true
        }, label.id);
    },

    saveVariable: function(e) {
        e.preventDefault();
        if(this.varcreator === null) {
            return;
        }
        var saved = this.varcreator.saveVariable();
        saved.done(this.variableSaved.bind(this));
        saved.fail(function(jqXhr, textStatus){
            alert(textStatus);
        });
    },

    cancelVariable: function() {
        this.editlabel = false;
        this.closeDialog();
    },

    getTablebody: function() {
        return this.tableBody;
    },

    createTable: function() {
        var tableContainer = document.querySelector(this.config.container + ' ' + this.config.tableContainer);
        var table = document.createElement('table');
        table.className = 'exporttablehead exporttablebody';
        table.setAttribute('style', 'width: 680px; margin-top: 0px;');
        tableContainer.appendChild(table);
        var thead = document.createElement('thead');
        table.appendChild(thead);
        var theadrow = document.createElement('tr');
        thead.appendChild(theadrow);
        theadrow.appendChild(this.createHeaderCell('Variable', 'width: 410px;'));
        theadrow.appendChild(this.createHeaderCell('Type', 'width: 80px;'));
        theadrow.appendChild(this.createHeaderCell('Plaats', 'width: 130px;'));
        theadrow.appendChild(this.createHeaderCell('&nbsp;', 'width: 30px;'));
        theadrow.appendChild(this.createHeaderCell('&nbsp;', 'width: 30px;'));
        this.tableBody = document.createElement('tbody');
        table.appendChild(this.tableBody);
        for(var i = 0; i < this.config.variables.length; i++) {
            this.tableBody.appendChild(this.createTableRow(this.config.variables[i]));
        }
    },

    createHeaderCell: function(name, style) {
        var th = document.createElement('th');
        th.innerHTML = name;
        th.setAttribute('style', style);
        return th;
    },

    createTableRow: function(variable) {
        var row = document.createElement('tr');
        row.setAttribute('data-varid', variable.id);
        row.appendChild(this.createTableCell(variable.name, 'name'));
        row.appendChild(this.createTableCell(this.findLabelInCollection(B3p.planmonitor.Config.variabletypes, variable.type), 'type'));
        row.appendChild(this.createTableCell(this.findLabelInCollection(B3p.planmonitor.Config.blocks, variable.location), 'location'));
        row.appendChild(this.createTableCellButton('edit', variable.id));
        row.appendChild(this.createTableCellButton('delete', variable.id));
        return row;
    },

    createTableCell: function(contents, className) {
        var td = document.createElement('td');
        td.innerHTML = contents;
        td.className = className;
        return td;
    },

    createTableCellButton: function(type, id) {
        var td = document.createElement('td');
        var img = document.createElement('img');
        img.src = './images/' + (type === 'edit' ? 'pencil' : 'delete') + '.png';
        img.alt = (type === 'edit' ? 'bewerken' : 'verwijderen');
        img.className = type + '-var';
        img.setAttribute('data-varid', id);
        td.appendChild(img);
        return td;
    },

    findLabelInCollection: function(collection, value) {
        for(var i = 0; i < collection.length; i++) {
            if(collection[i].id === value) {
                return collection[i].label;
            }
        }
        return "";
    },

    findTableRow: function(id) {
        var tbody = this.getTablebody();
        var trows = tbody.querySelectorAll('tr');
        id = parseInt(id, 10);
        for(var i = 0; i < trows.length; i++) {
            if(parseInt(trows[i].getAttribute('data-varid'), 10) === id) {
                return trows[i];
            }
        }
        return null;
    },

    variableSaved: function(data) {
        if(this.editlabel) {
            var varIndex = this.findLabel(data.name,'index');
            this.config.labels[varIndex] = data;
            this.editlabel = false;
        } else if(this.editmode) {
            var tr = this.findTableRow(this.variableid);
            tr.querySelector('.name').innerHTML = data.name;
            tr.querySelector('.type').innerHTML = this.findLabelInCollection(B3p.planmonitor.Config.variabletypes, data.type);
            tr.querySelector('.location').innerHTML = this.findLabelInCollection(B3p.planmonitor.Config.blocks, data.location);
            var varIndex = this.findVariableIndex(data.id);
            this.config.variables[varIndex] = data;
        } else {
            if(data.label){
                this.config.labels.push(data);
            }else{
                this.getTablebody().appendChild(this.createTableRow(data));
                this.config.variables.push(data);
            }
        }
        this.closeDialog();
    },

    findVariable: function(id) {
        return this.findVar(id, 'object');
    },

    findVariableIndex: function(id) {
        return this.findVar(id, 'index');
    },

    findVar: function(id, returnVal) {
        id = parseInt(id, 10);
        for(var i = 0; i < this.config.variables.length; i++) {
            if(this.config.variables[i].id === id) {
                if(returnVal === 'index') return i;
                return this.config.variables[i];
            }
        }
        return null;
    },

    findLabel: function(name,returnVal){
        for(var i = 0; i < this.config.labels.length; i++) {
            if(this.config.labels[i].name === name) {
              if(returnVal === 'index') return i;
                return this.config.labels[i];
            }
        }
        return null;
    },

    addVariable: function() {
        this.openDialog();
        this.editmode = false;
        this.variableid = 0;
        this.varcreator = Ext.create('B3p.planmonitor.VariableCreator', {
            regios: this.config.regios,
            saveurl: this.config.saveurl
        });
    },

    editVariable: function(id) {
        this.editmode = true;
        this.variableid = id;
        var variable = this.findVariable(id);
        this._editVar({
            regios: this.config.regios,
            saveurl: this.config.saveurl,
            variableName: variable.name,
            variableType: variable.type,
            mainCategory: variable.mainCategory,
            provinceField: variable.provinceField ? 'ja' : 'nee',
            uitgebreidsteField: variable.uitgebreidsteField ? 'ja' : 'nee',
            variableLocation: variable.location,
            addupField: variable.additionField ? 'ja' : 'nee',
            values: variable.values,
            selectedRegios: variable.regios,
            variableId: id
        }, id);
    },
    
    _editVar: function(variable, id) {
        this.openDialog();
        this.varcreator = Ext.create('B3p.planmonitor.VariableCreator', variable);
    },

    removeVariable: function(id) {
        if(confirm("Weet u zeker dat u deze variabele wilt verwijderen?")){
            this.findVariable(id);
            var tablerow = this.findTableRow(id);
            $.ajax(this.config.removeurl, {
                data: {
                    variable: id
                },
                type: 'GET'
            }).done(function(response) {
                if(!response.success) {
                    alert('Foutmelding: ' + response.message);
                    return;
                }
                tablerow.parentNode.removeChild(tablerow);
            });
        }
    },

    openDialog: function() {
        $(this.config.dialog).dialog("open");
    },

    closeDialog: function() {
        $(this.config.dialog).dialog("close");
    }

});