/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportBouwplannenDownload
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ExportBouwplannenDownload.class);
    private static String cachePath;
    private static String ZIPNAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        OutputStream out = null;
        try {
            String tempDirName = request.getParameter("filename");
            String prefix = File.separator;
            File workingDir = new File(cachePath + prefix + tempDirName);
            out = response.getOutputStream();
            Date nowDate = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            sdf.applyPattern("yyyy-MM-dd_HH-mm");
            String now = sdf.format(nowDate);
            ZipOutputStream zip = null;
            FileOutputStream fos = null;
            response.setContentType("application/zip");
            response.setHeader("Content-disposition", "attachment; filename=\"" + now + "_" + ZIPNAME + "\";");
            try {
                zip = new ZipOutputStream(out);
                this.putDirInZip(zip, workingDir, "");
            }
            catch (Exception ex) {
                log.error((Object)"Exception in creating zip: ", (Throwable)ex);
            }
            finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Can't close zip.", (Throwable)e);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ExportBouwplannenDownload.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ExportBouwplannenDownload.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void putDirInZip(ZipOutputStream zip, File dirFile, String rootEntity) throws IOException, Exception {
        byte[] buffer = new byte[8192];
        if (rootEntity == null) {
            rootEntity = "";
        }
        if (rootEntity.length() > 0 && rootEntity.lastIndexOf(File.separator) != rootEntity.length() - 1) {
            rootEntity = rootEntity + File.separator;
        }
        if (dirFile.exists()) {
            if (dirFile.isDirectory()) {
                File[] files = dirFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    int len;
                    if (files[i].isDirectory()) {
                        this.putDirInZip(zip, files[i], rootEntity + files[i].getName() + File.separator);
                        continue;
                    }
                    if (files[i].getName().equalsIgnoreCase(ZIPNAME)) continue;
                    zip.putNextEntry(new ZipEntry(rootEntity + files[i].getName()));
                    FileInputStream fis = new FileInputStream(files[i]);
                    while ((len = fis.read(buffer)) > 0) {
                        zip.write(buffer, 0, len);
                    }
                    zip.closeEntry();
                    fis.close();
                    files[i].delete();
                }
                dirFile.delete();
            } else {
                throw new Exception("File is not a directory");
            }
        }
        zip.closeEntry();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("cacheDir") != null) {
                cachePath = this.getServletContext().getRealPath(config.getInitParameter("cacheDir"));
            }
            if (config.getInitParameter("zipname") != null) {
                ZIPNAME = config.getInitParameter("zipname");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    static {
        ZIPNAME = "bouwplannen.zip";
    }
}

