/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.parse;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.persistence.EntityManager;
import nl.b3p.commons.services.StreamCopy;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gebruikgegevens;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Ontwikkelaartype;
import nl.b3p.pzh.rwbp.entity.Plantype;
import nl.b3p.pzh.rwbp.entity.Statusplanologisch;
import nl.b3p.pzh.rwbp.entity.Statusproject;
import nl.b3p.pzh.rwbp.entity.Woonmilieu;
import nl.b3p.pzh.rwbp.export.ExportConfigServlet;
import nl.b3p.pzh.rwbp.parse.Parser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.stripesstuff.stripersist.Stripersist;

public class ShapeParser
extends Parser {
    private static final Log log = LogFactory.getLog(ShapeParser.class);
    public static final String ID = "id";
    public static final String NAAM = "plannaam";
    public static final String PLANIDENTIFICATIE = "planidenti";
    public static final String GEMEENTE = "gemeente";
    public static final String PLAATSNAAM = "plaatsnaam";
    public static final String REFERENTIE = "referentie";
    public static final String BESTEMMINGSPLANNAAM = "bestemming";
    public static final String IMRO_NUMMER = "imronummer";
    public static final String MASTERPLAN = "masterplan";
    public static final String ONTWIKKELAARSTYPE = "opdr_type";
    public static final String ONTWIKKELAAR_NAMELIJK = "opdr_nml";
    public static final String PLANTYPE = "plantype";
    public static final String STATUSPLAN = "status_pla";
    public static final String STATUSPROJECT = "status_pro";
    public static final String KNELPUNTEN = "knelpunten";
    public static final String JAAR_BEGIN = "jaar_eerst";
    public static final String JAAR_EIND = "jaar_laats";
    public static final String PLANCAPACITEIT = "totaalcap";
    public static final String RESTCAPACITEIT = "restcap";
    public static final String SLOOP = "totaal_slp";
    public static final String RESTSLOOP = "rest_sloop";
    public static final String GEREALISEERDCAPACITEIT = "gereal_cap";
    public static final String GEREALISEERDSLOOP = "gereal_slp";
    public static final String DETAILCAPACITEIT = "detailcap";
    public static final String DETAILSLOOP = "detailslp";
    public static final String WONINGTYPE_MEERGEZINS = "meergezins";
    public static final String WONINGTYPE_EENGEZINS = "eengezins";
    public static final String WONINGTYPE_ONBEKEND = "onbekend";
    public static final String WONINGTYPE_HUUR1 = "huur1";
    public static final String WONINGTYPE_HUUR2 = "huur2";
    public static final String WONINGTYPE_HUUR3 = "huur3";
    public static final String WONINGTYPE_HUUR4 = "huur4";
    public static final String WONINGTYPE_HUURONBEKEND = "huurprijso";
    public static final String WONINGTYPE_HUURTOTAAL = "huurtotaal";
    public static final String WONINGTYPE_KOOP1 = "koop1";
    public static final String WONINGTYPE_KOOP2 = "koop2";
    public static final String WONINGTYPE_KOOP3 = "koop3";
    public static final String WONINGTYPE_KOOP4 = "koop4";
    public static final String WONINGTYPE_KOOPONBEKEND = "koopprijso";
    public static final String WONINGTYPE_KOOPTOTAAL = "kooptotaal";
    public static final String WONINGTYPE_ONBEKEND_KOOP_HUUR = "onb_kp_hr";
    public static final String GEBRUIKSGEGEVENS = "gebruikgeg";
    public static final String WOONMILIEU6 = "woonmabf6";
    public static final String WOONMILIEU14 = "woonmabf14";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Bouwplan> parse(InputStream is, Gebruiker gebruiker) throws IOException, Exception {
        String workingName = ExportConfigServlet.uniqueName(File.separator, "", true);
        File workingDir = new File(workingName);
        workingDir.mkdir();
        List<Bouwplan> bouwplannen = null;
        try {
            this.writeZipToWorkingDir(is, workingDir);
            bouwplannen = this.parseFiles(workingDir, gebruiker);
        }
        finally {
            ShapeParser.deleteDir(workingDir);
        }
        return bouwplannen;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = false;
                if (children[i].isDirectory()) {
                    ShapeParser.deleteDir(children[i]);
                    continue;
                }
                children[i].delete();
            }
            return dir.delete();
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipToWorkingDir(InputStream is, File workingDir) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(is);){
            ZipEntry currentFile;
            byte[] buffer = new byte[2048];
            while ((currentFile = zip.getNextEntry()) != null) {
                String newFile = workingDir.getAbsolutePath() + File.separator + currentFile.getName();
                File file = new File(newFile);
                this.createParentDir(new File(newFile));
                if (currentFile.isDirectory()) continue;
                try (FileOutputStream os = new FileOutputStream(newFile);){
                    StreamCopy.copy((InputStream)zip, (OutputStream)os);
                }
                catch (FileNotFoundException fne) {
                    log.debug((Object)fne);
                }
                finally {
                    zip.closeEntry();
                }
            }
        }
    }

    private List<Bouwplan> parseFiles(File file, Gebruiker gebruiker) throws IOException, Exception {
        ArrayList<Bouwplan> bouwplannen = new ArrayList<Bouwplan>();
        if (file.isDirectory() && file.listFiles() != null) {
            for (File f : file.listFiles()) {
                bouwplannen.addAll(this.parseFiles(f, gebruiker));
            }
        } else if (file.isFile() && file.getName().toLowerCase().endsWith(".shp")) {
            bouwplannen.addAll(this.parseShape(file, gebruiker));
        }
        return bouwplannen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Bouwplan> parseShape(File file, Gebruiker gebruiker) throws IOException, Exception {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
        DataStore datastore = DataStoreFinder.getDataStore(map);
        SimpleFeatureSource fs = datastore.getFeatureSource(datastore.getTypeNames()[0]);
        FeatureCollection fc = fs.getFeatures();
        FeatureIterator iterator = fc.features();
        EntityManager em = Stripersist.getEntityManager();
        ArrayList<Bouwplan> bouwplannen = new ArrayList<Bouwplan>();
        try {
            while (iterator.hasNext()) {
                List list;
                List list2;
                EasyFeature f = new EasyFeature(iterator.next());
                Bouwplan b = new Bouwplan();
                b.setNaam(f.getString(NAAM));
                String gemeente = f.getString(GEMEENTE);
                if (gemeente != null && (list2 = em.createQuery("FROM Gemeente where naam=:n").setParameter("n", (Object)gemeente).getResultList()).size() > 0) {
                    b.setGemeente((Gemeente)list2.get(0));
                }
                b.setPlaatsnaam(f.getString(PLAATSNAAM));
                b.setPlanIdentificatie(f.getString(PLANIDENTIFICATIE));
                b.setReferentienummer(f.getString(REFERENTIE));
                b.setBestemmingsplannaam(f.getString(BESTEMMINGSPLANNAAM));
                b.setImronummer(f.getString(IMRO_NUMMER));
                b.setMasterplan(f.getString(MASTERPLAN));
                String ontwType = f.getString(ONTWIKKELAARSTYPE);
                if (ontwType != null) {
                    List list3 = em.createQuery("FROM Ontwikkelaartype where type=:t").setParameter("t", (Object)ontwType).getResultList();
                    if (list3.size() > 0) {
                        b.setOntwikkelaartype((Ontwikkelaartype)list3.get(0));
                    }
                } else {
                    b.setOntwikkelaartype(null);
                }
                b.setOntwikkelaar_namelijk(f.getString(ONTWIKKELAAR_NAMELIJK));
                String plantype = f.getString(PLANTYPE);
                if (plantype != null) {
                    List list4 = em.createQuery("FROM Plantype where type=:t").setParameter("t", (Object)plantype).getResultList();
                    if (list4.size() > 0) {
                        b.setPlantype((Plantype)list4.get(0));
                    }
                } else {
                    b.setPlantype(null);
                }
                String statusPlan = f.getString(STATUSPLAN);
                if (statusPlan != null) {
                    List list5 = em.createQuery("FROM Statusplanologisch where type=:t").setParameter("t", (Object)statusPlan).getResultList();
                    if (list5.size() > 0) {
                        b.setStatusplanologisch((Statusplanologisch)list5.get(0));
                    }
                } else {
                    b.setStatusplanologisch(null);
                }
                String statusProject = f.getString(STATUSPROJECT);
                if (statusProject != null && (list = em.createQuery("FROM Statusproject where type=:t").setParameter("t", (Object)statusProject).getResultList()).size() > 0) {
                    b.setStatusproject((Statusproject)list.get(0));
                }
                if (b.getStatusproject() == null) {
                    Statusproject sp = (Statusproject)em.find(Statusproject.class, (Object)Statusproject.ONBEKEND_ID);
                    b.setStatusproject(sp);
                }
                b.setKnelpunten(f.getString(KNELPUNTEN));
                b.setJaar_eerste_oplevering(f.getInteger(JAAR_BEGIN));
                b.setJaar_laatste_oplevering(f.getInteger(JAAR_EIND));
                b.setTotaalcapaciteit(f.getInteger(PLANCAPACITEIT));
                b.setRestcapaciteit(f.getInteger(RESTCAPACITEIT));
                b.setResterendesloop(f.getInteger(RESTSLOOP));
                b.setTotaalsloop(f.getInteger(SLOOP));
                b.setGerealiseerdecapaciteit(f.getInteger(GEREALISEERDCAPACITEIT));
                b.setGerealiseerdesloop(f.getInteger(GEREALISEERDSLOOP));
                b.setDetailType(f.getString(DETAILCAPACITEIT));
                b.setDetailTypeSloop(f.getString(DETAILSLOOP));
                b.setMeergezins(f.getInteger(WONINGTYPE_MEERGEZINS));
                b.setEensgezins(f.getInteger(WONINGTYPE_EENGEZINS));
                b.setWoningtypeonbekend(f.getInteger(WONINGTYPE_ONBEKEND));
                b.setHuur1(f.getInteger(WONINGTYPE_HUUR1));
                b.setHuur2(f.getInteger(WONINGTYPE_HUUR2));
                b.setHuur3(f.getInteger(WONINGTYPE_HUUR3));
                b.setHuur4(f.getInteger(WONINGTYPE_HUUR4));
                b.setHuurprijsonbekend(f.getInteger(WONINGTYPE_HUURONBEKEND));
                b.setHuurtotaal(f.getInteger(WONINGTYPE_HUURTOTAAL));
                b.setKoop1(f.getInteger(WONINGTYPE_KOOP1));
                b.setKoop2(f.getInteger(WONINGTYPE_KOOP2));
                b.setKoop3(f.getInteger(WONINGTYPE_KOOP3));
                b.setKoop4(f.getInteger(WONINGTYPE_KOOP4));
                b.setKoopprijsonbekend(f.getInteger(WONINGTYPE_KOOPONBEKEND));
                b.setKooptotaal(f.getInteger(WONINGTYPE_KOOPTOTAAL));
                b.setOnbekendonbekend(f.getInteger(WONINGTYPE_ONBEKEND_KOOP_HUUR));
                String gebruikgegevens = f.getString(GEBRUIKSGEGEVENS);
                Gebruikgegevens gg = null;
                try {
                    gg = (Gebruikgegevens)em.createQuery("FROM Gebruikgegevens where naam = :gg", Gebruikgegevens.class).setParameter("gg", (Object)gebruikgegevens).getSingleResult();
                }
                catch (Exception e) {
                    gg = (Gebruikgegevens)em.find(Gebruikgegevens.class, (Object)3);
                }
                b.setGebruikgegevens(gg);
                b.setDatumlaatstewijziging(new Date());
                String woonmilieu6 = f.getString(WOONMILIEU6);
                if (woonmilieu6 != null) {
                    Woonmilieu wm = (Woonmilieu)em.createQuery("FROM Woonmilieu where type=:t", Woonmilieu.class).setParameter("t", (Object)woonmilieu6).getSingleResult();
                    b.setWoonmilieu(wm);
                }
                String woonmilieu14 = f.getString(WOONMILIEU14);
                b.setWoonmilieuabf14(woonmilieu14);
                List<BouwplanVariable> bvs = this.loadPlanning(b, f);
                b.setBouwplanVariables(bvs);
                Geometry geom = f.getGeometry();
                try {
                    b.setThe_geom(this.correctGeometry(geom));
                }
                catch (Exception cause) {
                    throw new Exception("Fout bij laden geometry van plan met naam: " + b.getNaam() + ". Reden: " + cause.getMessage(), cause);
                }
                bouwplannen.add(b);
            }
        }
        finally {
            iterator.close();
        }
        return bouwplannen;
    }

    private List<BouwplanVariable> loadPlanning(Bouwplan b, EasyFeature f) throws IOException {
        ArrayList<BouwplanVariable> bvs = new ArrayList<BouwplanVariable>();
        for (int i = 2013; i < 2041; ++i) {
            BouwplanVariable bv = this.getBouwplanVariable(b, f, i);
            bvs.add(bv);
        }
        return bvs;
    }

    private BouwplanVariable getBouwplanVariable(Bouwplan b, EasyFeature f, int year) {
        Integer value = 0;
        String key = "gep" + year;
        BouwplanVariable var = new BouwplanVariable();
        try {
            value = f.getInteger(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        var.setBouwplan(b);
        var.setGepland(value);
        var.setYear(year);
        return var;
    }

    private void createParentDir(File f) {
        if (f.getParentFile().exists()) {
            return;
        }
        f.getParentFile().mkdir();
        this.createParentDir(f.getParentFile());
    }

    private class EasyFeature {
        private Feature feature;

        public EasyFeature(Feature f) {
            this.feature = f;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public Object getObject(String name) {
            Property p = this.feature.getProperty(name);
            if (p == null && (p = this.feature.getProperty(name.toUpperCase())) == null && (p = this.feature.getProperty(name.toLowerCase())) == null) {
                return null;
            }
            return p.getValue();
        }

        public String getString(String name) throws IOException {
            Object o = this.getObject(name);
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                String s = (String)o;
                if (s.length() == 0) {
                    return null;
                }
                return (String)o;
            }
            return o.toString();
        }

        public Date getDate(String name) throws IOException {
            Object o = this.getObject(name);
            if (o == null) {
                return null;
            }
            if (o instanceof Date) {
                return (Date)o;
            }
            throw new IOException("Object \"" + name + "\" not of type Date: ");
        }

        public Integer getInteger(String name) throws IOException {
            Object o = this.getObject(name);
            if (o == null) {
                return null;
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof Double) {
                return ((Double)o).intValue();
            }
            if (o instanceof Long) {
                return ((Long)o).intValue();
            }
            throw new IOException("Object \"" + name + "\" not of type Integer: ");
        }

        public Geometry getGeometry() {
            return (Geometry)this.feature.getDefaultGeometryProperty().getValue();
        }
    }
}

