package nl.b3p.pzh.rwbp.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 * List of ids matching the variable:
    1;'status_project'
    2;'plannaam'
    3;'geometrie'
    4;'status_planologisch'
    5;'toelichting_planologisch'
    6;'aantal_bouw'
    7;'aantal_sloop'
    8;'type_woning'
    9;'eigendoms_situatie'
    10;'prijsklasse'
    11;'toelichting_project'
    12;'toelichting_type'

 */
@Entity
public class ProvincieVariable {
    
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    
    @ManyToOne
    @JoinColumn(name="config_variable")
    private ConfigurableVariable variable;
    
    @ManyToOne
    @JoinColumn(name="provincie")
    private Provincie provincie;

    @Column(name="variable_value")
    private String value;
    
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ConfigurableVariable getVariable() {
        return variable;
    }

    public void setVariable(ConfigurableVariable variable) {
        this.variable = variable;
    }

    public Provincie getProvincie() {
        return provincie;
    }

    public void setProvincie(Provincie provincie) {
        this.provincie = provincie;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
    
}
