package nl.b3p.pzh.rwbp.entity;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author Jytte
 */

@Entity
public class Regio {

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;

    private String naam;
    
    @ManyToMany(cascade = {CascadeType.ALL},fetch= FetchType.LAZY)
    @JoinTable(name="regio_provincie",
                joinColumns={@JoinColumn(name="regio")},
                inverseJoinColumns={@JoinColumn(name="provincie")})
    private Set<Provincie> provincie = new HashSet<Provincie>();
    
    @org.hibernate.annotations.Type(type="org.hibernatespatial.GeometryUserType")
    private Geometry theGeom;

    @OneToMany(mappedBy="regio",fetch= FetchType.LAZY)
    private Set<Gemeente> gemeente = new HashSet<Gemeente>();
    
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNaam() {
        return naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public Geometry getTheGeom() {
        return theGeom;
    }

    public void setTheGeom(Geometry theGeom) {
        this.theGeom = theGeom;
    }
    
    public Set<Provincie> getProvincie() {
        return provincie;
    }

    public void setProvincie(Set<Provincie> provincie) {
        this.provincie = provincie;
    }

    public Set<Gemeente> getGemeente() {
        return gemeente;
    }

    public void setGemeente(Set<Gemeente> gemeente) {
        this.gemeente = gemeente;
    }

    public JSONObject toJSON() throws JSONException{
        JSONObject json = new JSONObject();
        json.put("id",id);
        json.put("label",naam);

        return json;
    }
}
