package nl.b3p.pzh.rwbp.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.fileupload.FileUploadBase;

/**
 *
 * @author Jytte
 */

/*
 * Met deze servlet is het mogelijk om de export zip te downloaden.
 * De gebruiker heeft een link via de mail gekregen.
 * http://host/pzh-rwbp/services/ExportBouwplannenDownload?filename=FZCMWNULH9
 * De files worden na het downloaden verwijderd van de server.
 */
public class ExportBouwplannenDownload extends HttpServlet{

    private static final Log log = LogFactory.getLog(ExportBouwplannenDownload.class);
    private static String cachePath;
    private static String ZIPNAME = "bouwplannen.zip";

    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {
        
        OutputStream out = null;

        try {
            String tempDirName = request.getParameter("filename");
            String prefix = File.separator;
            File workingDir = new File(cachePath + prefix + tempDirName);
            out = response.getOutputStream();

            // bepaal datum voor in zipnaam
            Date nowDate = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = (SimpleDateFormat) SimpleDateFormat.getDateInstance();
            sdf.applyPattern("yyyy-MM-dd_HH-mm");
            String now = sdf.format(nowDate);
            //maak de zip file.
            ZipOutputStream zip = null;
            FileOutputStream fos = null;
            //set headers.
            response.setContentType("application/zip");
            response.setHeader(FileUploadBase.CONTENT_DISPOSITION, "attachment; filename=\"" + now + "_" + ZIPNAME + "\";");
            try {
                zip = new ZipOutputStream(out);
                putDirInZip(zip, workingDir, "");
            } catch (Exception ex) {
                log.error("Exception in creating zip: ", ex);
                //throw ex;
            } finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                } catch (Exception e) {
                    log.error("Can't close zip.", e);
                    //throw e;
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(ExportBouwplannenDownload.class.getName()).log(Level.SEVERE, null, ex);
            //throw ex;
        } finally {
            try {
            out.close();
            } catch (IOException ex) {
                Logger.getLogger(ExportBouwplannenDownload.class.getName()).log(Level.SEVERE, null, ex);
                //throw e;
            }
        }
    }
  
    private void putDirInZip(ZipOutputStream zip, File dirFile, String rootEntity) throws IOException, Exception {
        byte[] buffer = new byte[8192];
        if (rootEntity == null) {
            rootEntity = "";
        }
        if (rootEntity.length() > 0) {
            if (rootEntity.lastIndexOf(File.separator) != rootEntity.length() - 1) {
                rootEntity += File.separator;
            }
        }

        if (dirFile.exists()) {
            if (dirFile.isDirectory()) {
                File[] files = dirFile.listFiles();
                for (int i = 0; i < files.length; i++) {
                    if (files[i].isDirectory()) {
                        putDirInZip(zip, files[i], rootEntity + files[i].getName() + File.separator);
                    } else {
                        //zorg dat hij zichzelf niet schrijft.
                        if (!files[i].getName().equalsIgnoreCase(ZIPNAME)) {
                            zip.putNextEntry(new ZipEntry(rootEntity + files[i].getName()));
                            FileInputStream fis = new FileInputStream(files[i]);
                            int len;
                            while ((len = fis.read(buffer)) > 0) {
                                zip.write(buffer, 0, len);
                            }
                            zip.closeEntry();
                            fis.close();
                            files[i].delete();
                        }

                    }
                }
                dirFile.delete();
            } else {
                throw new Exception("File is not a directory");
            }
        }
        zip.closeEntry();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("cacheDir") != null) {
                cachePath = getServletContext().getRealPath(config.getInitParameter("cacheDir"));
            }
            if (config.getInitParameter("zipname") != null) {
                ZIPNAME = config.getInitParameter("zipname");
            }
        } catch (Exception e) {
            throw new ServletException(e);
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Returns a short description of the servlet.
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
