package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.VariableType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@StrictBinding
public class AdminGeneralActionBean extends ViewerActionBean {

    private static final Log log = LogFactory.getLog(AdminGeneralActionBean.class);
    private final String JSP = "/WEB-INF/jsp/admin/general.jsp";
    private List<ConfigurableVariable> vars = new ArrayList<ConfigurableVariable>();
    @ValidateNestedProperties({
        @Validate(field = "value"),
        @Validate(field = "id")
    })
    private Map<Integer, ProvincieVariable> varMap = new HashMap<Integer, ProvincieVariable>();

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution save() {
        Provincie p = gebruiker.resolveProvincie();
        EntityManager em = Stripersist.getEntityManager();
        Set<Integer> keys = varMap.keySet();
        for (Integer key : keys) {
            ProvincieVariable provVar = varMap.get(key);
            ConfigurableVariable cv = em.find(ConfigurableVariable.class, key);
            provVar.setVariable(cv);
            provVar.setProvincie(p);
            em.persist(provVar);
        }
        em.getTransaction().commit();
        createList();
        return new ForwardResolution(JSP);
    }
    
    @Before(stages = LifecycleStage.BindingAndValidation)
    private void createList() {
        EntityManager em = Stripersist.getEntityManager();
        Provincie p = gebruiker.getProvincie();
        vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", VariableType.GENERAL).getResultList();

        varMap = new HashMap<Integer, ProvincieVariable>();
        List<ProvincieVariable> provincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie AND variable in :vars").setParameter("provincie",p).setParameter("vars", vars).getResultList();
        for (ProvincieVariable provincieVariable : provincieVars) {
            varMap.put(provincieVariable.getVariable().getId(), provincieVariable);
        }

    }

    // <editor-fold defaultstate="collapsed" desc="getters en setters">
    public List<ConfigurableVariable> getVars() {
        return vars;
    }

    public void setVars(List<ConfigurableVariable> vars) {
        this.vars = vars;
    }

    public Map<Integer, ProvincieVariable> getVarMap() {
        return varMap;
    }

    public void setVarMap(Map<Integer, ProvincieVariable> varMap) {
        this.varMap = varMap;
    }
    // </editor-fold>
}
