/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.MD5Hasher;
import nl.b3p.pzh.rwbp.SearchQuery;
import nl.b3p.pzh.rwbp.SldMapEntry;
import nl.b3p.pzh.rwbp.SolrInitializer;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Provincie;
import static nl.b3p.pzh.rwbp.stripes.SearchActionBean.getSldMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FacetField.Count;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Meine Toonen
 */
@StrictBinding
public class SolrActionBean extends ViewerActionBean {

    private static final Log log = LogFactory.getLog(SolrActionBean.class);
    public static final String SEARCH_PROPERTIES = "searchProperties";

    @Validate
    private String naam;

    @Validate
    private String term;

    @Validate
    private String extraFilter;

    @Validate
    private String facetQuery;

    @Validate
    private String facet;

    @Validate
    private String sortField;

    @Validate
    private String sortOrder;

    @Validate
    private boolean reloadPrevious;

    @Validate
    private int start = 0;

    @Validate
    private int numResults = 10;

    @Validate
    private String searchFields;

    private String layers;
    private String sldKey = "";

    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");

    @DefaultHandler
    public Resolution search() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("success", false);
        try {
            String authQuery = getAuthorizedQuery();
            SearchQuery sq = null;
            if (reloadPrevious) {
                sq = (SearchQuery) context.getRequest().getSession().getAttribute(SEARCH_PROPERTIES);
            }

            if(sq == null){
                sq = new SearchQuery(naam, term, extraFilter, facetQuery, facet, sortField, sortOrder, searchFields, authQuery, start, numResults);
                context.getRequest().getSession().setAttribute(SEARCH_PROPERTIES, sq);
            }
            QueryResponse rsp = BouwplanUtils.getResponse(sq.toQuery());
            SolrDocumentList list = rsp.getResults();

            JSONArray respDocs = new JSONArray();
            int total = new Long(list.getNumFound()).intValue();
            obj.put("total", total);

            obj.put("results", respDocs);
            JSONObject extent = null;
            List<Integer> zichtbaarIds = new ArrayList<Integer>();
            for (SolrDocument solrDocument : list) {
                JSONObject doc = solrDocumentToResult(solrDocument);
                if (doc != null) {
                    respDocs.put(doc);
                    zichtbaarIds.add(doc.getInt("id"));
                    extent = processExtent(doc, extent);
                }
            }
            JSONArray facets = getFacetInformation(rsp);
            obj.put("facets", facets);
            obj.put("numResults", numResults);
            obj.put("start", start);
            obj.put("success", true);
            obj.put("extent", extent);
            obj.put("searchQuery", sq.toJSON());
            obj.put("mapVariables", doKaartlijstRequests(sq, total, zichtbaarIds));
        } catch (SolrServerException ex) {
            log.error("Error searchign solr:", ex);
        } catch (JSONException ex) {
            log.error("Error searchign solr:", ex);
        }
        return new StreamingResolution("application/json", obj.toString(4));
    }

    private JSONObject processExtent(JSONObject doc, JSONObject extent) throws JSONException {
        if (!doc.getBoolean("heeft_geometrie")) {
            return extent;
        }
        double minX = doc.getDouble("minx");
        double minY = doc.getDouble("miny");
        double maxX = doc.getDouble("maxx");
        double maxY = doc.getDouble("maxy");

        if (extent == null) {
            extent = new JSONObject();
            extent.put("minx", minX);
            extent.put("miny", minY);
            extent.put("maxx", maxX);
            extent.put("maxy", maxY);
            return extent;
        }

        double curMinX = extent.getDouble("minx");
        double curMinY = extent.getDouble("miny");
        double curMaxX = extent.getDouble("maxx");
        double curMaxY = extent.getDouble("maxy");

        if (curMinX > minX) {
            extent.put("minx", minX);
        }
        if (curMinY > minY) {
            extent.put("miny", minY);
        }
        if (curMaxX < maxX) {
            extent.put("maxx", maxX);
        }
        if (curMaxY < maxY) {
            extent.put("maxy", maxY);
        }
        return extent;
    }

    private String getAuthorizedQuery() {
        String rechtenQuery = "";

        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker) context.getRequest().getUserPrincipal();

        boolean prov = context.getRequest().isUserInRole("provincie");
        boolean regio = context.getRequest().isUserInRole("regio");
        boolean gemeente = context.getRequest().isUserInRole("gemeente");
        boolean rijk = context.getRequest().isUserInRole("rijk");
        boolean admin = false;
        boolean openbaar = false;
        String resultField = "";
        if (ingelogd != null) {
            gebruiker = em.find(Gebruiker.class, ingelogd.getId());
            admin = ingelogd.isBeheerder();

            if (gebruiker.getGemeente() != null) {
                resultField = "\"" + gebruiker.getGemeente().getNaam() + "\"";
            } else if (gebruiker.getRegio() != null) {
                resultField = "\"" + gebruiker.getRegio().getNaam() + "\"";
            } else if (gebruiker.getProvincie() != null) {
                resultField = gebruiker.getProvincie().getNaam();
            } else if (gebruiker.isRijk()) {
                resultField = "Nederland";
            }
        }else{
            openbaar = true;
        }

        final String OPENBAAR = "Openbaar";
        final String EIGEN_NIVEAU = "\"Gemeente, eigen regio, eigen provincie\"";
        final String INGELOGD = "\"Alle ingelogde gebruikers\"";
        final String GEMEENTE = "\"Alleen gemeente\"";
        final String GEMEENTE_EIGENREGIO = "\"Gemeente, eigen regio\"";
        if (prov) {
            rechtenQuery = " (gebruikgegevens_facet:" + OPENBAAR + " or (provincie_facet:" + resultField + " and gebruikgegevens_facet:" + EIGEN_NIVEAU + ")" + " or (gebruikgegevens_facet:" + INGELOGD + "))";
        } else if (regio) {
            rechtenQuery = " (gebruikgegevens_facet:" + OPENBAAR + " or (regio_facet:" + resultField + " and (gebruikgegevens_facet:" + EIGEN_NIVEAU + " or gebruikgegevens_facet:"+ GEMEENTE_EIGENREGIO+")) or (gebruikgegevens_facet:" + INGELOGD + "))";
        } else if (gemeente) {
            Provincie p = gebruiker.resolveProvincie();
            String provincie = p != null ? p.getNaam() : null;
            rechtenQuery = " (gebruikgegevens_facet:" + OPENBAAR  + " or (gemeente_facet:" + resultField + " and (gebruikgegevens_facet:" + GEMEENTE + " or gebruikgegevens_facet:" + GEMEENTE_EIGENREGIO + " or gebruikgegevens_facet:" + EIGEN_NIVEAU +" )) or (gebruikgegevens_facet:" + INGELOGD + ")";
            rechtenQuery += " or( provincie_facet:" + provincie + " and (gebruikgegevens_facet:" + EIGEN_NIVEAU + " or gebruikgegevens_facet:"+GEMEENTE_EIGENREGIO + ")) )";
        } else if (rijk || admin ) {
            rechtenQuery = " gebruikgegevens_facet:" + OPENBAAR + " or gebruikgegevens_facet:" + INGELOGD;
        }else if(openbaar){
            rechtenQuery = " (gebruikgegevens_facet:" + OPENBAAR + ")";
        }

        return rechtenQuery;
    }

    public Resolution add() throws SolrServerException, IOException {
        SolrServer server = SolrInitializer.getServerInstance();
        EntityManager em = Stripersist.getEntityManager();
        UpdateResponse ur = server.deleteByQuery("*:*");
        Query q = em.createQuery("FROM Bouwplan", Bouwplan.class);
        List<Bouwplan> lijst = q.getResultList();
        List<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        int counter = 0;
        for (Bouwplan bp : lijst) {
            SolrInputDocument doc = createDocument(bp);
            docs.add(doc);
            counter++;
            if (counter > 100) {
                UpdateResponse resp = server.add(docs);
                server.commit();
                counter = 0;
                docs = new ArrayList<SolrInputDocument>();
            }
        }
        if(!docs.isEmpty()){
            UpdateResponse resp = server.add(docs);
        }
        server.commit();
        return new StreamingResolution("plain/text", "");
    }

    public static void removeSingleBouwplan(Bouwplan bp) {
        try {
            SolrServer server = SolrInitializer.getServerInstance();
            server.deleteById(bp.getId().toString());
            server.commit();
        } catch (SolrServerException ex) {
            log.error("Error removing bouwplan:", ex);
        } catch (IOException ex) {
            log.error("Error removing bouwplan:", ex);
        }
    }

    public static void removeMultipleBouwplans(List<String> ids){
        try {
            SolrServer server = SolrInitializer.getServerInstance();
            server.deleteById(ids);
            server.commit();
        } catch (SolrServerException ex) {
            log.error("Error removing bouwplan:", ex);
        } catch (IOException ex) {
            log.error("Error removing bouwplan:", ex);
        }
    }

    public static void addSingleBouwplan(Bouwplan bp) {
        try {
            SolrServer server = SolrInitializer.getServerInstance();
            SolrInputDocument doc = createDocument(bp);

            server.add(doc);
            server.commit();
        } catch (SolrServerException ex) {
            log.error("Error adding bouwplan:", ex);
        } catch (IOException ex) {
            log.error("Error adding bouwplan:", ex);
        }
    }

    private static SolrInputDocument createDocument(Bouwplan plan) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("id", plan.getId());
        doc.addField("aanmaakdatum", plan.getAanmaakdatum());
        doc.addField("naam", plan.getNaam());
        doc.addField("bestemmingsplannaam", plan.getBestemmingsplannaam());
        doc.addField("gemeente", plan.getGemeente().getNaam());
        doc.addField("plaatsnaam", plan.getPlaatsnaam());
        if( plan.getGemeente().getRegio() != null){
            doc.addField("regio", plan.getGemeente().getRegio().getNaam());
        }
        doc.addField("provincie", plan.getGemeente().getProvincie().getNaam());
        doc.addField("statusplanologisch", plan.getStatusplanologisch() != null ? plan.getStatusplanologisch().getType() : null);
        doc.addField("statusproject", plan.getStatusproject() != null ? plan.getStatusproject().getType() : null);
        doc.addField("gebruikgegevens", plan.getGebruikgegevens() != null ? plan.getGebruikgegevens().getNaam() : null);
        doc.addField("woonmilieu", plan.getWoonmilieu() != null ? plan.getWoonmilieu().getType() : null);
        doc.addField("ontwikkelaartype", plan.getOntwikkelaartype() != null ? plan.getOntwikkelaartype().getType() : null);
        doc.addField("plantype", plan.getPlantype() != null ? plan.getPlantype().getType() : null);
        doc.addField("woonmilieurosetta", plan.getWoonmilieu_rosetta() != null ? plan.getWoonmilieu_rosetta().getValue() : null);

        Polygon p = plan.getThe_geom();
        if (p != null) {
            Envelope e = p.getEnvelopeInternal();
            doc.addField("minx", e.getMinX());
            doc.addField("miny", e.getMinY());
            doc.addField("maxx", e.getMaxX());
            doc.addField("maxy", e.getMaxY());
        }

        //   Long woningen = BouwplanUtils.getNumberOfBuildings(plan.getId());
        doc.addField("aantal_woningen", plan.getTotaalcapaciteit());
        doc.addField("jaareersteoplevering", plan.getJaar_eerste_oplevering());
        doc.addField("datumlaatstewijziging", plan.getDatumlaatstewijziging());
        doc.addField("heeft_geometrie", plan.getThe_geom() != null);
        return doc;
    }

    private JSONObject solrDocumentToResult(SolrDocument doc) throws JSONException {
        JSONObject result = new JSONObject();

        Collection<String> fields = doc.getFieldNames();
        for (String field : fields) {
            if(field.equals("datumlaatstewijziging")){
                Date d = (Date)doc.get(field);
                result.put(field, sdf.format(d));
            }else{
                result.put(field, doc.get(field));
            }
        }
        return result;
    }

    private JSONArray getFacetInformation(QueryResponse resp) throws JSONException {
        JSONArray facets = new JSONArray();

        List<FacetField> fields = resp.getFacetFields();
        for (FacetField field : fields) {
            JSONObject jsonField = new JSONObject();
            jsonField.put("count", field.getValueCount());
            jsonField.put("name", field.getName());
            String name = field.getName();
            String label = name.replace("_facet", "");
            label = label.substring(0, 1).toUpperCase() + label.substring(1);
            jsonField.put("label", label);
            List<Count> values = field.getValues();
            JSONArray jsonValues = new JSONArray();
            for (Count value : values) {
                JSONObject jsonValue = new JSONObject();
                jsonValue.put("name", value.getName());
                jsonValue.put("count", value.getCount());

                jsonValues.put(jsonValue);
            }
            jsonField.put("values", jsonValues);
            facets.put(jsonField);
        }

        return facets;
    }

    private JSONObject doKaartlijstRequests(SearchQuery sq, int max, List<Integer> zichtbaarIds) {
        JSONObject mapVariables = new JSONObject();
        try {
            int offset = sq.getStart();
            List<Integer> allIds = BouwplanUtils.getAllIdsFromQuery(sq, max);
            makeKaartLijsten(allIds, zichtbaarIds, offset);
            mapVariables.put("sldKey", sldKey);
        } catch (SolrServerException ex) {
            log.error("Cannot find all ids:", ex);
        } catch (JSONException ex) {
            log.error("Cannot add mapvariables to response json: ", ex);
        }
        return mapVariables;
    }

    private void makeKaartLijsten(List<Integer> ids, List<Integer> zichtbaarIds, int offset) {
        int beginnummering = 1;
        ids.removeAll(zichtbaarIds);

        String zichtbaar = "";
        String nummering = "";
        String gevonden = "";

        beginnummering = offset + 1;

        int aantal = zichtbaarIds.size();
        int i = 1;
        for (Iterator<Integer> it = zichtbaarIds.iterator(); it.hasNext();) {
            Integer id = it.next();
            if (i == aantal) {
                zichtbaar = zichtbaar + id;
                nummering = nummering + beginnummering;
            } else {
                zichtbaar = zichtbaar + id + ",";
                nummering = nummering + beginnummering + ",";
            }
            i++;
            beginnummering++;
        }
        if (ids.size() > 0) {
            aantal = ids.size();
            i = 1;
            for (Iterator it = ids.iterator(); it.hasNext();) {
                Integer bouwplanid = (Integer) it.next();
                if (i == aantal) {
                    gevonden = gevonden + bouwplanid;
                } else {
                    gevonden = gevonden + bouwplanid + ",";
                }
                i++;
            }
        }

        String[] extraLagen = new String[0];
        String extraLaagId = "";
        if (gebruiker != null) {
            extraLagen = new String[1];
            if (gebruiker.getGemeente() != null) {
                extraLaagId += gebruiker.getGemeente().getId();
                extraLagen[0] = "bouwplan_gemeente";
            } else if (gebruiker.getRegio() != null) {
                extraLaagId += gebruiker.getRegio().getId();
                extraLagen[0] = "bouwplan_regio";
            } else if (gebruiker.getProvincie() != null) {
                extraLaagId += gebruiker.getProvincie().getId();
                extraLagen[0] = "bouwplan_provincie";
            } else if (gebruiker.isRijk()) {
                extraLagen[0] = "bouwplan_rijk";
            }
        }
        initLayers();
        createHashMapEntry(layers, zichtbaar, gevonden, nummering, extraLagen, extraLaagId);
    }

    private void createHashMapEntry(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagId) {
        ServletContext sc = context.getServletContext();
        synchronized (sc) {
            Map<String, SldMapEntry> sldMap = getSldMap(sc);
            String parameterString = createParameterString(layers, cbpids, obpids, cbpnrs, extraLagen, extraLaagId);
            if (!sldMap.containsKey(parameterString)) {
                sldKey = createHash(parameterString);
                sldMap.put(sldKey, new SldMapEntry(cbpids, obpids, cbpnrs, layers, extraLagen, extraLaagId));
            }
        }
    }

    public void initLayers() {
        layers = "bouwplan_openbaar,bouwplan_openbaar_afgerond,bouwplan_openbaar_vervallen";
        if (gebruiker != null) {
            if (getGebruiker().getGemeente() != null) {
                layers += ",bouwplan_gemeente,bouwplan_gemeente_afgerond,bouwplan_gemeente_vervallen";
            } else if (getGebruiker().getRegio() != null) {
                layers += ",bouwplan_regio,bouwplan_regio_afgerond,bouwplan_regio_vervallen";
            } else if (getGebruiker().getProvincie() != null) {
                layers += ",bouwplan_provincie,bouwplan_provincie_afgerond,bouwplan_provincie_vervallen";
            } else if (gebruiker.isRijk()) {
                layers += ",bouwplan_rijk,bouwplan_rijk_afgerond,bouwplan_rijk_vervallen";
            }
        }
    }

    private String createParameterString(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagid) {
        String parameterString = cbpids + obpids + cbpnrs + layers;
        for (String extraLaag : extraLagen) {
            parameterString += extraLaag;
        }
        parameterString += extraLaagid;
        return parameterString;
    }

    private static String createHash(String parameterString) {
        try {
            return MD5Hasher.MD5(parameterString);
        } catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        } catch (UnsupportedEncodingException ex) {
            log.error(ex.getMessage());
        }
        return null;
    }

    // <editor-fold defaultstate="collapsed" desc="Getters and setters">
    public String getTerm() {
        return term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getExtraFilter() {
        return extraFilter;
    }

    public void setExtraFilter(String extraFilter) {
        this.extraFilter = extraFilter;
    }

    public String getFacet() {
        return facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getNaam() {
        return naam;
    }

    public void setNaam(String naam) {
        this.naam = naam;
    }

    public int getNumResults() {
        return numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public String getSearchFields() {
        return searchFields;
    }

    public void setSearchFields(String searchFields) {
        this.searchFields = searchFields;
    }

    public boolean isReloadPrevious() {
        return reloadPrevious;
    }

    public void setReloadPrevious(boolean reloadPrevious) {
        this.reloadPrevious = reloadPrevious;
    }

    public String getFacetQuery() {
        return facetQuery;
    }

    public void setFacetQuery(String facetQuery) {
        this.facetQuery = facetQuery;
    }
    // </editor-fold>

}
