/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.printen;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import nl.b3p.pzh.rwbp.printen.Legend;
import nl.b3p.pzh.rwbp.printen.LegendPart;
import nl.b3p.pzh.rwbp.printen.PrintExtraInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlRootElement(name="info")
@XmlType(propOrder={"title", "subtitle", "date", "imageUrl", "legendUrls", "bbox", "remark", "quality", "angle", "overviewUrl", "extra"})
public class PrintInfo {
    private static final Log log = LogFactory.getLog(PrintInfo.class);
    private String title;
    private String subtitle;
    private String date;
    private String imageUrl;
    private String bbox;
    private String remark;
    private int quality;
    private int angle;
    private List<PrintExtraInfo> extra = new ArrayList();
    private List<Legend> legendUrls = new ArrayList();
    private List<File> tempFiles = new ArrayList();
    private String overviewUrl;

    @XmlElement(name="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlElement(name="date")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @XmlElement(name="imageUrl")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @XmlElement(name="bbox")
    public String getBbox() {
        return this.bbox;
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    @XmlElement(name="remark")
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @XmlElement(name="quality")
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @XmlElement(name="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setLegendUrls(List<Legend> legendUrls) {
        this.legendUrls = legendUrls;
    }

    @XmlElementWrapper(name="legendUrls")
    @XmlElement(name="legendUrl")
    public List<Legend> getLegendUrls() {
        return this.legendUrls;
    }

    @XmlElement(name="angle")
    public int getAngle() {
        return this.angle;
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    @XmlElement(name="overviewUrl")
    public String getOverviewUrl() {
        return this.overviewUrl;
    }

    public void setOverviewUrl(String overviewUrl) {
        this.overviewUrl = overviewUrl;
    }

    @XmlElementWrapper(name="extra")
    @XmlElement(name="info")
    public List<PrintExtraInfo> getExtra() {
        return this.extra;
    }

    public void setExtra(List<PrintExtraInfo> extra) {
        this.extra = extra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLegendImagesAndReadDimensions() {
        for (Legend l : this.legendUrls) {
            for (LegendPart lp : l.getLegendParts()) {
                File legendFile = null;
                InputStream in = null;
                ByteArrayOutputStream legendMemoryCache = new ByteArrayOutputStream();
                FileOutputStream fos = null;
                try {
                    log.debug((Object)("Loading legend from URL: " + lp.getUrl()));
                    URL u = new URL(lp.getUrl());
                    in = u.openStream();
                    IOUtils.copy((InputStream)in, (OutputStream)legendMemoryCache);
                    legendFile = File.createTempFile("legend_img_", null);
                    this.tempFiles.add(legendFile);
                    legendFile.deleteOnExit();
                    fos = new FileOutputStream(legendFile);
                    IOUtils.copy((InputStream)new ByteArrayInputStream(legendMemoryCache.toByteArray()), (OutputStream)fos);
                    fos.flush();
                    lp.setUrl(legendFile.toURI().toString());
                    log.debug((Object)("Legend part url changed to point to temporary file: " + lp.getUrl()));
                    Dimension dim = PrintInfo.getImageDimension((InputStream)new ByteArrayInputStream(legendMemoryCache.toByteArray()));
                    if (dim == null) {
                        log.debug((Object)"No dimensions could be determined");
                        continue;
                    }
                    lp.setWidth(Integer.valueOf((int)dim.getWidth()));
                    lp.setHeight(Integer.valueOf((int)dim.getHeight()));
                    log.debug((Object)String.format("Dimensions: %d x %d", lp.getWidth(), lp.getHeight()));
                }
                catch (Exception e) {
                    log.warn((Object)("Exception loading legend dimensions from URL " + lp.getUrl()), (Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dimension getImageDimension(InputStream image) throws IOException {
        try (ImageInputStream in = ImageIO.createImageInputStream(image);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        return null;
    }

    public void removeLegendImagesCache() {
        for (File tempFile : this.tempFiles) {
            try {
                tempFile.delete();
                log.debug((Object)("Temporary file deleted: " + tempFile.getCanonicalPath()));
            }
            catch (Exception e) {
                try {
                    log.error((Object)("Error deleting temporary file " + tempFile.getCanonicalPath()), (Throwable)e);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

