/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.pzh.rwbp.SearchQuery;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.export.ExportBouwplannenThread;
import nl.b3p.pzh.rwbp.stripes.BouwplanUtils;
import nl.b3p.pzh.rwbp.stripes.PrintActionBean;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.stripesstuff.plugin.session.Session;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
public class ExportActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(ExportActionBean.class);
    @Session
    private Set<Integer> plannenToExport = new HashSet();
    private List<Bouwplan> bouwplannen = new ArrayList();
    private Long resultCount;
    @Session
    private Long exportAantal;
    private boolean geenEmail = false;
    private boolean emailMelding = false;
    private String email;
    @Validate
    private boolean exportvolledig = true;
    @Validate
    private boolean exporteenvoudig = false;

    @DefaultHandler
    public Resolution export() {
        this.getExportplannen();
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void checkMail() {
        if (this.getGebruiker().getEmail() == null || this.getGebruiker().getEmail().length() <= 0) {
            this.getContext().getMessages().add(new SimpleMessage("Er is geen e-mail adres opgegeven voor deze gebruiker. <br>Het is daarom niet mogelijk om een export te doen. <br>Ga naar profiel om uw e-mail adres in te voeren.", new Object[0]));
            this.geenEmail = true;
        } else {
            this.email = this.getGebruiker().getEmail();
        }
    }

    public Resolution delete() {
        Integer id = new Integer(this.context.getRequest().getParameter("id").toString());
        this.plannenToExport.remove(id);
        this.getExportplannen();
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    public Resolution deleteAll() {
        this.plannenToExport = new HashSet();
        this.exportAantal = null;
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    public Resolution makeExport() {
        EntityManager em = Stripersist.getEntityManager();
        ArrayList bpsToExport = new ArrayList(this.plannenToExport);
        Integer[] geselecteerdePlannen = bpsToExport.toArray(new Integer[0]);
        if (bpsToExport.isEmpty()) {
            this.getContext().getMessages().add(new SimpleMessage("Er zijn geen bouwplannen geselecteerd op te exporteren. <br>Voeg bouwplannen toe via de zoekfunctie.", new Object[0]));
            return new ForwardResolution("/WEB-INF/jsp/export.jsp");
        }
        Gebruiker dbGebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)this.gebruiker.getId());
        String servletPath = this.context.getRequest().getServletPath();
        String totaalPath = this.context.getRequest().getRequestURL().toString();
        String path = totaalPath.substring(0, totaalPath.length() - servletPath.length());
        try {
            ExportBouwplannenThread ebpt = new ExportBouwplannenThread(geselecteerdePlannen, dbGebruiker, path, this.exporteenvoudig, this.exportvolledig);
            ebpt.start();
            this.getContext().getMessages().add(new SimpleMessage("De export wordt voor u gemaakt. Zodra dit klaar is ontvangt u een email bericht op '" + this.gebruiker.getEmail() + "' met daarin een link waarmee u de export kunt downloaden.", new Object[0]));
            this.emailMelding = true;
        }
        catch (Exception e) {
            this.context.getValidationErrors().add("exportMode", (ValidationError)new SimpleError("Exporttype niet herkent: " + e, new Object[0]));
            return this.export();
        }
        this.getExportplannen();
        return this.updateSelection();
    }

    public Resolution print() throws Exception {
        PrintActionBean print = new PrintActionBean();
        print.setContext(this.context);
        ArrayList bps = new ArrayList(this.plannenToExport);
        print.setBouwplans(bps);
        print.setMapserverUrl(this.getMapserverUrl());
        print.setLayers(this.getLayers());
        print.setHttpRequestParams(this.getHttpRequestParams());
        return print.print();
    }

    public Resolution updateSelection() {
        this.bouwplannen = this.getFilteredList();
        this.resultCount = new Long(this.bouwplannen.size());
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    private List<Bouwplan> getFilteredList() {
        EntityManager em = Stripersist.getEntityManager();
        List currentList = em.createQuery("from Bouwplan as bp where id in (:ids) order by naam asc").setParameter("ids", (Object)this.plannenToExport).getResultList();
        return currentList;
    }

    public Resolution addToExport() throws SolrServerException {
        List add = new ArrayList();
        Object searchProperties = this.context.getRequest().getSession().getAttribute("searchProperties");
        if (searchProperties != null) {
            SearchQuery query = (SearchQuery)searchProperties;
            add = BouwplanUtils.getAllIdsFromQuery((SearchQuery)query);
            if (this.plannenToExport == null) {
                this.plannenToExport = new HashSet();
            }
            this.plannenToExport.addAll(add);
        }
        this.getExportplannen();
        return new ForwardResolution("/WEB-INF/jsp/export.jsp");
    }

    public void getExportplannen() {
        if (this.plannenToExport != null && !this.plannenToExport.isEmpty()) {
            this.bouwplannen = this.getFilteredList();
            this.resultCount = new Long(this.bouwplannen.size());
            this.exportAantal = new Long(this.bouwplannen.size());
        }
    }

    public List<Bouwplan> getBouwplannen() {
        return this.bouwplannen;
    }

    public void setBouwplannen(List<Bouwplan> bouwplannen) {
        this.bouwplannen = bouwplannen;
    }

    public Long getResultCount() {
        return this.resultCount;
    }

    public void setResultCount(Long resultCount) {
        this.resultCount = resultCount;
    }

    public Long getExportAantal() {
        return this.exportAantal;
    }

    public void setExportAantal(Long exportAantal) {
        this.exportAantal = exportAantal;
    }

    public boolean isGeenEmail() {
        return this.geenEmail;
    }

    public void setGeenEmail(boolean geenEmail) {
        this.geenEmail = geenEmail;
    }

    public boolean isEmailMelding() {
        return this.emailMelding;
    }

    public void setEmailMelding(boolean emailMelding) {
        this.emailMelding = emailMelding;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isExportvolledig() {
        return this.exportvolledig;
    }

    public void setExportvolledig(boolean exportvolledig) {
        this.exportvolledig = exportvolledig;
    }

    public boolean isExporteenvoudig() {
        return this.exporteenvoudig;
    }

    public void setExporteenvoudig(boolean exporteenvoudig) {
        this.exporteenvoudig = exporteenvoudig;
    }
}

