/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import nl.b3p.pzh.rwbp.MD5Hasher;
import nl.b3p.pzh.rwbp.SldMapEntry;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieService;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.export.ExportConfigServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.stripesstuff.stripersist.Stripersist;

/*
 * Exception performing whole class analysis ignored.
 */
@StrictBinding
public class ViewerActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(ViewerActionBean.class);
    protected ActionBeanContext context;
    protected Gebruiker gebruiker;
    private String naamGebruiker;
    private Boolean isBeheerder = false;
    private Boolean isGemeente = false;
    private Provincie resolvedProvincie;
    private String mail;
    private String about;
    private String help;
    private String layers = "";
    private String querylayers = "";
    private String httpRequestParams = "";
    private String absoluteUrlPrefix;
    private String mapserverUrl;
    private String sldkey_eenvoudig;
    private static final String SLD_MAP_ATTR = "SLDMAP";
    private static final int EXPIRATIONTIMESLDENTRY = 28800000;
    private List<ProvincieService> provincieServices = new ArrayList();

    @Before(stages={LifecycleStage.HandlerResolution})
    public void gebruikerOphalen() {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker ingelogd = (Gebruiker)this.context.getRequest().getUserPrincipal();
        if (ingelogd != null) {
            this.gebruiker = (Gebruiker)em.find(Gebruiker.class, (Object)ingelogd.getId());
            this.naamGebruiker = this.gebruiker.getFullname();
            this.isBeheerder = this.gebruiker.isBeheerder();
            Gemeente gemeente = this.gebruiker.getGemeente();
            this.isGemeente = gemeente != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.resolvedProvincie = this.gebruiker.resolveProvincie();
            Hibernate.initialize((Object)this.resolvedProvincie);
            List vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", (Object)VariableType.GENERAL).getResultList();
            List provincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie AND variable in :vars").setParameter("provincie", (Object)this.resolvedProvincie).setParameter("vars", (Object)vars).getResultList();
            for (ProvincieVariable provincieVariable : provincieVars) {
                ConfigurableVariable var = provincieVariable.getVariable();
                if (var.getName().equals("mailadress")) {
                    this.mail = provincieVariable.getValue();
                    continue;
                }
                if (var.getName().equals("aboutlink")) {
                    this.about = provincieVariable.getValue();
                    continue;
                }
                if (!var.getName().equals("helplink")) continue;
                this.help = provincieVariable.getValue();
            }
        } else {
            this.naamGebruiker = "Openbaar";
        }
    }

    private void initUrls() {
        HttpServletRequest request = this.context.getRequest();
        String address = null;
        try {
            address = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), "").toString();
        }
        catch (MalformedURLException ex) {
            log.error((Object)ex);
        }
        this.absoluteUrlPrefix = address;
        this.mapserverUrl = ExportConfigServlet.getMapserverUrl();
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void initViewer() {
        this.initUrls();
        this.initLayers();
        this.layers = "bouwplan_openbaar";
        this.querylayers = "bouwplan_openbaar";
        if (this.gebruiker != null) {
            if (this.getGebruiker().getGemeente() != null) {
                int gemeenteid = this.getGebruiker().getGemeente().getId();
                this.layers = this.layers + ",bouwplan_gemeente";
                this.querylayers = this.querylayers + ",bouwplan_gemeente";
                this.httpRequestParams = "gemeenteid=" + gemeenteid;
            } else if (this.getGebruiker().getRegio() != null) {
                int regioid = this.getGebruiker().getRegio().getId();
                this.layers = this.layers + ",bouwplan_regio";
                this.querylayers = this.querylayers + ",bouwplan_regio";
                this.httpRequestParams = "regioid=" + regioid;
            } else if (this.getGebruiker().getProvincie() != null) {
                int provincieid = this.getGebruiker().getProvincie().getId();
                this.layers = this.layers + ",bouwplan_provincie";
                this.querylayers = this.querylayers + ",bouwplan_provincie";
                this.httpRequestParams = "provincieid=" + provincieid;
            } else if (this.gebruiker.isRijk()) {
                this.layers = this.layers + ",bouwplan_rijk";
                this.querylayers = this.querylayers + ",bouwplan_rijk";
            }
            EntityManager em = Stripersist.getEntityManager();
            Provincie p = this.gebruiker.resolveProvincie();
            if (p != null) {
                this.provincieServices = em.createQuery("from ProvincieService where provincie = :provincie").setParameter("provincie", (Object)p).getResultList();
            }
        }
    }

    protected void initLayers() {
        String[] extraLagen = new String[]{};
        String extraLaagId = "";
        if (this.gebruiker != null) {
            extraLagen = new String[1];
            if (this.gebruiker.getGemeente() != null) {
                extraLaagId = extraLaagId + this.gebruiker.getGemeente().getId();
                extraLagen[0] = "bouwplan_gemeente";
            } else if (this.gebruiker.getRegio() != null) {
                extraLaagId = extraLaagId + this.gebruiker.getRegio().getId();
                extraLagen[0] = "bouwplan_regio";
            } else if (this.gebruiker.getProvincie() != null) {
                extraLaagId = extraLaagId + this.gebruiker.getProvincie().getId();
                extraLagen[0] = "bouwplan_provincie";
            } else if (this.gebruiker.isRijk()) {
                extraLagen[0] = "bouwplan_rijk";
            }
        }
        this.createHashMapEntry(this.layers, "", "", "", extraLagen, extraLaagId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHashMapEntry(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagId) {
        ServletContext sc;
        ServletContext servletContext = sc = this.context.getServletContext();
        synchronized (servletContext) {
            Map sldMap = ViewerActionBean.getSldMap((ServletContext)sc);
            String parameterString = this.createParameterString(layers, cbpids, obpids, cbpnrs, extraLagen, extraLaagId);
            if (!sldMap.containsKey(parameterString)) {
                this.sldkey_eenvoudig = this.createHash(parameterString);
                sldMap.put(this.sldkey_eenvoudig, new SldMapEntry(cbpids, obpids, cbpnrs, layers, extraLagen, extraLaagId));
            }
        }
    }

    private String createParameterString(String layers, String cbpids, String obpids, String cbpnrs, String[] extraLagen, String extraLaagid) {
        String parameterString = cbpids + obpids + cbpnrs + layers;
        for (String extraLaag : extraLagen) {
            parameterString = parameterString + extraLaag;
        }
        parameterString = parameterString + extraLaagid;
        return parameterString;
    }

    private String createHash(String parameterString) {
        try {
            return MD5Hasher.MD5((String)parameterString);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)ex.getMessage());
        }
        return null;
    }

    private static void expireSldMapEntries(Map<String, SldMapEntry> map) {
        ArrayList<String> keysToExpire = new ArrayList<String>();
        long currentTime = new Date().getTime();
        for (Map.Entry<String, SldMapEntry> entry : map.entrySet()) {
            long entryTime = entry.getValue().getStart().getTime();
            if (currentTime - entryTime < 28800000L) continue;
            keysToExpire.add(entry.getKey());
        }
        for (String key : keysToExpire) {
            log.debug((Object)("Removing expired SLD for key " + key));
            map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, SldMapEntry> getSldMap(ServletContext sc) {
        ServletContext servletContext = sc;
        synchronized (servletContext) {
            Map<String, SldMapEntry> sldMap = (Map<String, SldMapEntry>)sc.getAttribute("SLDMAP");
            if (sldMap == null) {
                sldMap = Collections.synchronizedMap(new HashMap());
                sc.setAttribute("SLDMAP", sldMap);
            } else {
                ViewerActionBean.expireSldMapEntries((Map)sldMap);
            }
            return sldMap;
        }
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Gebruiker getGebruiker() {
        return this.gebruiker;
    }

    public void setGebruiker(Gebruiker gebruiker) {
        this.gebruiker = gebruiker;
    }

    public String getNaamGebruiker() {
        return this.naamGebruiker;
    }

    public void setNaamGebruiker(String naamGebruiker) {
        this.naamGebruiker = naamGebruiker;
    }

    public Boolean getIsBeheerder() {
        return this.isBeheerder;
    }

    public void setIsBeheerder(Boolean isBeheerder) {
        this.isBeheerder = isBeheerder;
    }

    public Boolean getIsGemeente() {
        return this.isGemeente;
    }

    public void setIsGemeente(Boolean isGemeente) {
        this.isGemeente = isGemeente;
    }

    public Provincie getResolvedProvincie() {
        return this.resolvedProvincie;
    }

    public void setResolvedProvincie(Provincie resolvedProvincie) {
        this.resolvedProvincie = resolvedProvincie;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getLayers() {
        return this.layers;
    }

    public void setLayers(String layers) {
        this.layers = layers;
    }

    public String getQuerylayers() {
        return this.querylayers;
    }

    public void setQuerylayers(String querylayers) {
        this.querylayers = querylayers;
    }

    public String getHttpRequestParams() {
        return this.httpRequestParams;
    }

    public void setHttpRequestParams(String httpRequestParams) {
        this.httpRequestParams = httpRequestParams;
    }

    public String getAbsoluteUrlPrefix() {
        return this.absoluteUrlPrefix;
    }

    public void setAbsoluteUrlPrefix(String absoluteUrlPrefix) {
        this.absoluteUrlPrefix = absoluteUrlPrefix;
    }

    public String getMapserverUrl() {
        return this.mapserverUrl;
    }

    public void setMapserverUrl(String mapserverUrl) {
        this.mapserverUrl = mapserverUrl;
    }

    public String getSldkey_eenvoudig() {
        return this.sldkey_eenvoudig;
    }

    public void setSldkey_eenvoudig(String sldkey_eenvoudig) {
        this.sldkey_eenvoudig = sldkey_eenvoudig;
    }

    public List<ProvincieService> getProvincieServices() {
        return this.provincieServices;
    }

    public void setProvincieServices(List<ProvincieService> provincieServices) {
        this.provincieServices = provincieServices;
    }
}

