<%-- 
    Document   : beheer
    Created on : Jul 23, 2010, 11:44:13 AM
    Author     : Jytte
--%>

<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" session="false" pageEncoding="UTF-8"%>

<stripes:layout-render name="/WEB-INF/jsp/templates/tabTemplate.jsp" pageTitle="Beheer">
    <stripes:layout-component name="content">
        <stripes:form id="beheerForm" beanclass="nl.b3p.pzh.rwbp.stripes.AdminUserActionBean">
            <stripes:hidden name="nieuweGebruiker"/>
            <div class="contentpadding">
                <div class="editform">
                    <table class="exporttablehead" style="width: 1222px; margin-top: 0px;">
                        <tr>
                            <th style="width: 124px;">Gebruikersnaam</th>
                            <th style="width: 256px;">Naam</th>
                            <th style="width: 239px;">E-mail</th>
                            <th style="width: 119px;">Telefoonnummer</th>
                            <th style="width: 242px;">Toegangsniveau</th>
                            <th style="width: 32px">&nbsp;</th>
                            <th style="width: 47px">&nbsp;</th>
                        </tr>
                    </table>

                    <div class="scroll" id="scrolldiv" style="width: 1222px;height:350px;">
                        <table class="exporttablebody" id="exporttablebody" style="width: 1205px;">
                            <c:if test="${not empty actionBean.gebruikersList}">
                                <c:set var="style" value="odd"/>
                                <c:forEach var="gebruiker" items="${actionBean.gebruikersList}">
                                    <tr class="${style}">
                                        <td style="padding-left: 2px; width: 122px;">
                                            <stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.AdminUserActionBean" event="selectGebruiker">
                                                <stripes:param name="gebruikerid" value="${gebruiker.id}"/>
                                                <c:out value="${gebruiker.username}"/>
                                            </stripes:link>
                                        </td>
                                        <td style="width: 256px;"><c:out value="${gebruiker.fullname}"/></td>
                                        <td style="width: 239px;"><c:out value="${gebruiker.email}"/></td>
                                        <td style="width: 119px;"><c:out value="${gebruiker.phone}"/></td>
                                        <td style="width: 242px;">
                                            <c:if test="${!empty gebruiker.gemeente}">
                                                gemeente <c:out value="${gebruiker.gemeente.naam}"/>
                                            </c:if>
                                            <c:if test="${!empty gebruiker.regio}">
                                                regio <c:out value="${gebruiker.regio.naam}"/>
                                            </c:if>
                                            <c:if test="${gebruiker.beheerder}">
                                                beheerder
                                            </c:if>
                                            <c:if test="${!gebruiker.beheerder && !empty gebruiker.provincie}">
                                                provincie <c:out value="${gebruiker.provincie.naam}"/>
                                            </c:if>
                                            <c:if test="${gebruiker.rijk}">Rijk</c:if>
                                        </td>
                                        <td style="width: 32px;"> 
                                            <stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.AdminUserActionBean" onclick="return confirm('Weet u zeker dat u deze gebruiker wilt verwijderen?');" event="delete"><stripes:param name="gebruikerid" value="${gebruiker.id}"/><img src="./images/delete.png" alt="delete" /></stripes:link>
                                        </td>
                                        <td style="width: 32px;"></td>
                                    </tr>
                                    <c:choose>
                                        <c:when test="${style == 'odd'}">
                                            <c:set var="style" value="even"/>
                                        </c:when>
                                        <c:otherwise>
                                            <c:set var="style" value="odd"/>
                                        </c:otherwise>
                                    </c:choose>
                                </c:forEach>
                            </c:if>
                        </table>
                    </div>                
                </div>
                <div style="clear: both; height: 20px;"></div>
                <p style="color:red"><stripes:errors/></p>
                <p style="color:green"><stripes:messages/></p>
                <div class="editform">
                    <div style="float: left; margin-right: 20px; width: 440px;">
                        <strong>Gebruikersgegevens</strong>
                        <stripes:hidden name="user.id"/>
                        <table>
                            <tr>
                                <td>Gebruikersnaam</td>
                                <td><stripes:text name="user.username"/></td>
                            </tr>
                            <tr>
                                <td>Wachtwoord</td>
                                <td><stripes:password name="wachtwoord"/></td>
                            </tr>
                            <tr>
                                <td>Naam</td>
                                <td><stripes:text name="user.fullname"/></td>
                            </tr>
                            <tr>
                                <td>E-mail</td>
                                <td><stripes:text name="user.email"/></td>
                            </tr>
                            <tr>
                                <td>Telefoonnummer</td>
                                <td><stripes:text name="user.phone"/></td>
                            </tr>

                        </table>
                    </div>
                    <c:choose>
                        <c:when test="${actionBean.nieuweGebruiker == true}">
                            <div style="float: left; width: 400px;">
                                <strong>Toegangsniveau</strong>
                                <table style="float: left; width: 460px;">
                                    <c:if test="${not empty actionBean.gemeenteList}">
                                        <tr>
                                            <td style="width: 150px;">
                                                <label><stripes:radio id="toegangGemeente" name="toegang" value="gemeente"/> Gemeente</label>
                                            </td>
                                            <td style="padding-bottom: 5px; height: 30px;" class="access-level-select">
                                                <stripes:select name="gemeente" id="gemeente" style="width: 300px; padding: 3px;">
                                                    <stripes:option  value=""><c:out value=""/></stripes:option>
                                                    <c:forEach var="gemeente" items="${actionBean.gemeenteList}">
                                                        <stripes:option  value="${gemeente.id}"><c:out value="${gemeente.naam}"/></stripes:option>
                                                    </c:forEach>
                                                </stripes:select>
                                            </td>
                                        </tr>
                                    </c:if>
                                    <c:if test="${not empty actionBean.regioList}">
                                        <tr>
                                            <td>
                                                <label><stripes:radio id="toegangRegio" name="toegang" value="regio"/> Regio</label>
                                            </td>
                                            <td style="padding-bottom: 5px; height: 30px;" class="access-level-select">
                                                <stripes:select name="regio" id="regio" style="width: 300px; padding: 3px;">
                                                    <stripes:option  value=""><c:out value=""/></stripes:option>
                                                    <c:forEach var="regio" items="${actionBean.regioList}">
                                                        <stripes:option  value="${regio.id}"><c:out value="${regio.naam}"/></stripes:option>
                                                    </c:forEach>
                                                </stripes:select>
                                            </td>
                                        </tr>
                                    </c:if>
                                    <c:if test="${not empty actionBean.provinciesList}">
                                        <tr>
                                            <td>
                                                <label><stripes:radio id="toegangProvincie" name="toegang" value="provincie"/> Provincie</label>
                                            </td>
                                            <td style="padding-bottom: 5px; height: 30px;" class="access-level-select">
                                                <stripes:select name="provincie" id="provincie" style="width: 300px; padding: 3px;">
                                                    <stripes:option value=""></stripes:option>
                                                    <stripes:options-collection collection="${actionBean.provinciesList}" value="id" label="naam" />
                                                </stripes:select>
                                            </td>
                                        </tr>
                                    </c:if>
                                        <tr>
                                            <c:if test="${actionBean.gebruiker.beheerder}">
                                                <td style="padding-bottom: 5px;"><stripes:radio name="toegang" value="beheerder"/>Beheerder</td>
                                            </c:if>
                                            <c:if test="${actionBean.gebruiker.beheerder || actionBean.gebruiker.rijk}">
                                                <td style="padding-bottom: 5px;"><stripes:radio name="toegang" value="rijk"/>Rijk</td>
                                            </c:if>
                                        </tr>
                                </table>
                                <script type="text/javascript">
                                    Ext.onReady(function() {
                                        var selects = document.querySelectorAll('.access-level-select > div');
                                        var radiobuttons = document.querySelectorAll('[name=toegang]');
                                        function hideSelects() {
                                            var checked = document.querySelector('[name=toegang]:checked');
                                            if(checked === null) {
                                                checked = radiobuttons[0];
                                                checked.checked = true;
                                            }
                                            var checkedselect = checked.parentNode.parentNode.parentNode.querySelector('.access-level-select > div');
                                            for(var i = 0; i < selects.length; i++) {
                                                selects[i].style.visibility = 'hidden';
                                            }
                                            checkedselect.style.visibility = 'visible';
                                        }
                                        for(var i = 0; i < radiobuttons.length; i++) {
                                            radiobuttons[i].addEventListener('change', hideSelects);
                                        }
                                        hideSelects();
                                    });
                                </script>
                            </div>
                        </c:when>
                        <c:otherwise>
                            <stripes:hidden name="toegang"/>
                        </c:otherwise>
                    </c:choose>
                    <div style="clear: both;"></div>
                    <div style="float: left; margin-top: 20px; width: 770px; text-align: right;">
                        <stripes:submit name="save" class="inputbutton menubutton" style="width: auto;">opslaan</stripes:submit>
                        <stripes:submit name="view" class="inputbutton menubutton" style="width: auto;">annuleren</stripes:submit>
                    </div>
                    <div style="clear: both;"></div>
                </div>
            </div>
        </stripes:form>
    </stripes:layout-component>
</stripes:layout-render>
