Ext.define("Ext.draw.ContainerBase",{extend:"Ext.panel.Panel",requires:["Ext.window.Window"],layout:"container",addElementListener:function(){var b=this,a=arguments;if(b.rendered){b.el.on.apply(b.el,a)}else{b.on("render",function(){b.el.on.apply(b.el,a)})}},removeElementListener:function(){var b=this,a=arguments;if(b.rendered){b.el.un.apply(b.el,a)}},afterRender:function(){this.callParent(arguments);this.initAnimator()},getItems:function(){var b=this,a=b.items;if(!a||!a.isMixedCollection){b.initItems()}return b.items},onRender:function(){this.callParent(arguments);this.element=this.el;this.innerElement=this.body},setItems:function(a){this.items=a;return a},setSurfaceSize:function(b,a){this.resizeHandler({width:b,height:a});this.renderFrame()},onResize:function(){var a=this.body.lastBox;this.onBodyResize(a.width,a.height)},preview:function(){var a=this.getImage();new Ext.window.Window({title:"Chart Preview",closeable:true,renderTo:Ext.getBody(),autoShow:true,maximizeable:true,maximized:true,border:true,layout:{type:"hbox",pack:"center",align:"middle"},items:{xtype:"container",items:{xtype:"image",mode:"img",cls:Ext.baseCSSPrefix+"chart-image",src:a.data,listeners:{afterrender:function(){var e=this,b=e.imgEl.dom,d=a.type==="svg"?1:(window.devicePixelRatio||1),c;if(!b.naturalWidth||!b.naturalHeight){b.onload=function(){var g=b.naturalWidth,f=b.naturalHeight;e.setWidth(Math.floor(g/d));e.setHeight(Math.floor(f/d))}}else{c=e.getSize();e.setWidth(Math.floor(c.width/d));e.setHeight(Math.floor(c.height/d))}}}}}})},privates:{getTargetEl:function(){return this.innerElement}}});Ext.define("Ext.draw.SurfaceBase",{extend:"Ext.Widget"});Ext.define("Ext.draw.Color",{statics:{colorToHexRe:/(.*?)rgb\((\d+),\s*(\d+),\s*(\d+)\)/,rgbToHexRe:/\s*rgb\((\d+),\s*(\d+),\s*(\d+)\)/,rgbaToHexRe:/\s*rgba\((\d+),\s*(\d+),\s*(\d+),\s*([\.\d]+)\)/,hexRe:/\s*#([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)\s*/,NONE:"none",RGB_NONE:"rgb(0, 0, 0)",RGBA_NONE:"rgba(0, 0, 0, 0)"},isColor:true,lightnessFactor:0.2,constructor:function(d,b,a,c){this.setRGB(d,b,a,c)},setRGB:function(e,c,a,d){var b=this;b.r=Math.min(255,Math.max(0,e));b.g=Math.min(255,Math.max(0,c));b.b=Math.min(255,Math.max(0,a));if(d===undefined){b.a=1}else{b.a=Math.min(1,Math.max(0,d))}},getGrayscale:function(){return this.r*0.3+this.g*0.59+this.b*0.11},getHSL:function(i){var j=this,a=j.r/255,f=j.g/255,k=j.b/255,m=Math.max(a,f,k),d=Math.min(a,f,k),n=m-d,e,o=0,c=0.5*(m+d);if(d!==m){o=(c<0.5)?n/(m+d):n/(2-m-d);if(a===m){e=60*(f-k)/n}else{if(f===m){e=120+60*(k-a)/n}else{e=240+60*(a-f)/n}}if(e<0){e+=360}if(e>=360){e-=360}}if(i){i[0]=e;i[1]=o;i[2]=c}else{i=[e,o,c]}return i},setHSL:function(g,f,e){var j,d,b,a=Math.abs,i=Math.floor;g=(g%360+360)%360;f=f>1?1:f<0?0:f;e=e>1?1:e<0?0:e;if(f===0||g===null){e*=255;this.setRGB(e,e,e)}else{g/=60;j=f*(1-a(2*e-1));d=j*(1-a(g-2*i(g/2)-1));b=e-j/2;b*=255;j*=255;d*=255;switch(i(g)){case 0:this.setRGB(j+b,d+b,b);break;case 1:this.setRGB(d+b,j+b,b);break;case 2:this.setRGB(b,j+b,d+b);break;case 3:this.setRGB(b,d+b,j+b);break;case 4:this.setRGB(d+b,b,j+b);break;case 5:this.setRGB(j+b,b,d+b);break}}return this},createLighter:function(b){var a=this.getHSL();b=b||this.lightnessFactor;a[2]=a[2]+b;if(a[2]>1){a[2]=1}else{if(a[2]<0){a[2]=0}}return Ext.draw.Color.fromHSL(a[0],a[1],a[2])},createDarker:function(a){a=a||this.lightnessFactor;return this.createLighter(-a)},toString:function(){var f=this,c=Math.round;if(f.a===1){var e=c(f.r).toString(16),d=c(f.g).toString(16),a=c(f.b).toString(16);e=(e.length===1)?"0"+e:e;d=(d.length===1)?"0"+d:d;a=(a.length===1)?"0"+a:a;return["#",e,d,a].join("")}else{return"rgba("+[c(f.r),c(f.g),c(f.b),f.a===0?0:f.a.toFixed(15)].join(", ")+")"}},toHex:function(b){if(Ext.isArray(b)){b=b[0]}if(!Ext.isString(b)){return""}if(b.substr(0,1)==="#"){return b}var e=Ext.draw.Color.colorToHexRe.exec(b);if(Ext.isArray(e)){var f=parseInt(e[2],10),d=parseInt(e[3],10),a=parseInt(e[4],10),c=a|(d<<8)|(f<<16);return e[1]+"#"+("000000"+c.toString(16)).slice(-6)}else{return""}},setFromString:function(j){var e,h,f,c,d=1,i=parseInt;if(j==="none"){this.r=this.g=this.b=this.a=0;return this}if((j.length===4||j.length===7)&&j.substr(0,1)==="#"){e=j.match(Ext.draw.Color.hexRe);if(e){h=i(e[1],16)>>0;f=i(e[2],16)>>0;c=i(e[3],16)>>0;if(j.length===4){h+=(h*16);f+=(f*16);c+=(c*16)}}}else{if((e=j.match(Ext.draw.Color.rgbToHexRe))){h=+e[1];f=+e[2];c=+e[3]}else{if((e=j.match(Ext.draw.Color.rgbaToHexRe))){h=+e[1];f=+e[2];c=+e[3];d=+e[4]}else{if(Ext.draw.Color.ColorList.hasOwnProperty(j.toLowerCase())){return this.setFromString(Ext.draw.Color.ColorList[j.toLowerCase()])}}}}if(typeof h==="undefined"){return this}this.r=h;this.g=f;this.b=c;this.a=d;return this}},function(){var a=new this();this.addStatics({fly:function(f,e,c,d){switch(arguments.length){case 1:a.setFromString(f);break;case 3:case 4:a.setRGB(f,e,c,d);break;default:return null}return a},ColorList:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4","indianred ":"#cd5c5c","indigo ":"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},fromHSL:function(d,c,b){return(new this(0,0,0,0)).setHSL(d,c,b)},fromString:function(b){return(new this(0,0,0,0)).setFromString(b)},create:function(b){if(b instanceof this){return b}else{if(Ext.isArray(b)){return new Ext.draw.Color(b[0],b[1],b[2],b[3])}else{if(Ext.isString(b)){return Ext.draw.Color.fromString(b)}else{if(arguments.length>2){return new Ext.draw.Color(arguments[0],arguments[1],arguments[2],arguments[3])}else{return new Ext.draw.Color(0,0,0,0)}}}}}})});(function(){function a(d,c,b){return d+(c-d)*b}Ext.define("Ext.draw.sprite.AnimationParser",{singleton:true,attributeRe:/^url\(#([a-zA-Z\-]+)\)$/,requires:["Ext.draw.Color"],color:{parseInitial:function(c,b){if(Ext.isString(c)){c=Ext.draw.Color.create(c)}if(Ext.isString(b)){b=Ext.draw.Color.create(b)}if((c instanceof Ext.draw.Color)&&(b instanceof Ext.draw.Color)){return[[c.r,c.g,c.b,c.a],[b.r,b.g,b.b,b.a]]}else{return[c||b,b||c]}},compute:function(d,c,b){if(!Ext.isArray(d)||!Ext.isArray(c)){return c||d}else{return[a(d[0],c[0],b),a(d[1],c[1],b),a(d[2],c[2],b),a(d[3],c[3],b)]}},serve:function(c){var b=Ext.draw.Color.fly(c[0],c[1],c[2],c[3]);return b.toString()}},number:{parse:function(b){return b===null?null:+b},compute:function(d,c,b){if(!Ext.isNumber(d)||!Ext.isNumber(c)){return c||d}else{return a(d,c,b)}}},angle:{parseInitial:function(c,b){if(b-c>Math.PI){b-=Math.PI*2}else{if(b-c<-Math.PI){b+=Math.PI*2}}return[c,b]},compute:function(d,c,b){if(!Ext.isNumber(d)||!Ext.isNumber(c)){return c||d}else{return a(d,c,b)}}},path:{parseInitial:function(m,n){var c=m.toStripes(),o=n.toStripes(),e,d,k=c.length,p=o.length,h,f,b,g=o[p-1],l=[g[g.length-2],g[g.length-1]];for(e=k;e<p;e++){c.push(c[k-1].slice(0))}for(e=p;e<k;e++){o.push(l.slice(0))}b=c.length;o.path=n;o.temp=new Ext.draw.Path();for(e=0;e<b;e++){h=c[e];f=o[e];k=h.length;p=f.length;o.temp.types.push("M");for(d=p;d<k;d+=6){f.push(l[0],l[1],l[0],l[1],l[0],l[1])}g=o[o.length-1];l=[g[g.length-2],g[g.length-1]];for(d=k;d<p;d+=6){h.push(l[0],l[1],l[0],l[1],l[0],l[1])}for(e=0;e<f.length;e++){f[e]-=h[e]}for(e=2;e<f.length;e+=6){o.temp.types.push("C")}}return[c,o]},compute:function(c,l,m){if(m>=1){return l.path}var e=0,f=c.length,d=0,b,k,h,n=l.temp.coords,g=0;for(;e<f;e++){k=c[e];h=l[e];b=k.length;for(d=0;d<b;d++){n[g++]=h[d]*m+k[d]}}return l.temp}},data:{compute:function(h,j,k,g){var m=h.length-1,b=j.length-1,e=Math.max(m,b),d,l,c;if(!g||g===h){g=[]}g.length=e+1;for(c=0;c<=e;c++){d=h[Math.min(c,m)];l=j[Math.min(c,b)];if(isNaN(d)){g[c]=l}else{g[c]=(l-d)*k+d}}return g}},text:{compute:function(d,c,b){return d.substr(0,Math.round(d.length*(1-b)))+c.substr(Math.round(c.length*(1-b)))}},limited:"number",limited01:"number"})})();(function(){if(!Ext.global.Float32Array){var a=function(d){if(typeof d==="number"){this.length=d}else{if("length" in d){this.length=d.length;for(var c=0,b=d.length;c<b;c++){this[c]=+d[c]}}}};a.prototype=[];Ext.global.Float32Array=a}})();Ext.define("Ext.draw.Draw",{singleton:true,radian:Math.PI/180,pi2:Math.PI*2,reflectFn:function(b){return b},rad:function(a){return a%360*Math.PI/180},degrees:function(a){return a*180/Math.PI%360},isBBoxIntersect:function(b,a,c){c=c||0;return(Math.max(b.x,a.x)-c>Math.min(b.x+b.width,a.x+a.width))||(Math.max(b.y,a.y)-c>Math.min(b.y+b.height,a.y+a.height))},spline:function(m){var e,c,k=m.length,b,h,l,f,a=0,g=new Float32Array(m.length),n=new Float32Array(m.length*3-2);g[0]=0;g[k-1]=0;for(e=1;e<k-1;e++){g[e]=(m[e+1]+m[e-1]-2*m[e])-g[e-1];a=1/(4-a);g[e]*=a}for(e=k-2;e>0;e--){a=3.732050807568877+48.248711305964385/(-13.928203230275537+Math.pow(0.07179676972449123,e));g[e]-=g[e+1]*a}f=m[0];b=f-g[0];for(e=0,c=0;e<k-1;c+=3){l=f;h=b;e++;f=m[e];b=f-g[e];n[c]=l;n[c+1]=(b+2*h)/3;n[c+2]=(b*2+h)/3}n[c]=f;return n},getAnchors:function(e,d,i,h,t,s,o){o=o||4;var n=Math.PI,p=n/2,k=Math.abs,a=Math.sin,b=Math.cos,f=Math.atan,r,q,g,j,m,l,v,u,c;r=(i-e)/o;q=(t-i)/o;if((h>=d&&h>=s)||(h<=d&&h<=s)){g=j=p}else{g=f((i-e)/k(h-d));if(d<h){g=n-g}j=f((t-i)/k(h-s));if(s<h){j=n-j}}c=p-((g+j)%(n*2))/2;if(c>p){c-=n}g+=c;j+=c;m=i-r*a(g);l=h+r*b(g);v=i+q*a(j);u=h+q*b(j);if((h>d&&l<d)||(h<d&&l>d)){m+=k(d-l)*(m-i)/(l-h);l=d}if((h>s&&u<s)||(h<s&&u>s)){v-=k(s-u)*(v-i)/(u-h);u=s}return{x1:m,y1:l,x2:v,y2:u}},smooth:function(l,j,o){var k=l.length,h,g,c,b,q,p,n,m,f=[],e=[],d,a;for(d=0;d<k-1;d++){h=l[d];g=j[d];if(d===0){n=h;m=g;f.push(n);e.push(m);if(k===1){break}}c=l[d+1];b=j[d+1];q=l[d+2];p=j[d+2];if(isNaN(q)||isNaN(p)){f.push(n,c,c);e.push(m,b,b);break}a=this.getAnchors(h,g,c,b,q,p,o);f.push(n,a.x1,c);e.push(m,a.y1,b);n=a.x2;m=a.y2}return{smoothX:f,smoothY:e}},updateIOS:Ext.os.is.iOS?function(){var a=Ext.getBody().createChild({style:"position: absolute; top: 0px; bottom: 0px; left: 0px; right: 0px; background: rgba(0,0,0,0.001); z-index: 100000"});Ext.draw.Animator.schedule(function(){a.destroy()})}:Ext.emptyFn});Ext.define("Ext.draw.gradient.Gradient",{isGradient:true,config:{stops:[]},applyStops:function(f){var e=[],d=f.length,c,b,a;for(c=0;c<d;c++){b=f[c];a=Ext.draw.Color.fly(b.color||"none");e.push({offset:Math.min(1,Math.max(0,"offset" in b?b.offset:b.position||0)),color:a.toString()})}e.sort(function(h,g){return h.offset-g.offset});return e},onClassExtended:function(a,b){if(!b.alias&&b.type){b.alias="gradient."+b.type}},constructor:function(a){this.initConfig(a)},generateGradient:Ext.emptyFn});Ext.define("Ext.draw.gradient.GradientDefinition",{singleton:true,urlStringRe:/^url\(#([\w\-]+)\)$/,gradients:{},add:function(a){var b=this.gradients,c,e,d;for(c=0,e=a.length;c<e;c++){d=a[c];if(Ext.isString(d.id)){b[d.id]=d}}},get:function(d){var a=this.gradients,b=d.match(this.urlStringRe),c;if(b&&b[1]&&(c=a[b[1]])){return c||d}return d}});Ext.define("Ext.draw.sprite.AttributeParser",{singleton:true,attributeRe:/^url\(#([a-zA-Z\-]+)\)$/,requires:["Ext.draw.Color","Ext.draw.gradient.GradientDefinition"],"default":function(a){return a},string:function(a){return String(a)},number:function(a){if(!isNaN(a)){return a}},angle:function(a){if(!isNaN(a)){a%=Math.PI*2;if(a<-Math.PI){a+=Math.PI*2}if(a>Math.PI){a-=Math.PI*2}return a}},data:function(a){if(Ext.isArray(a)){return a.slice()}else{if(a instanceof Float32Array){return new Float32Array(a)}}},bool:function(a){return !!a},color:function(a){if(a instanceof Ext.draw.Color){return a.toString()}else{if(a instanceof Ext.draw.gradient.Gradient){return a}else{if(!a){return"none"}else{if(Ext.isString(a)){if(a.substr(0,3)==="url"){a=Ext.draw.gradient.GradientDefinition.get(a);if(Ext.isString(a)){return a}}else{return Ext.draw.Color.fly(a).toString()}}}}}if(a.type==="linear"){return Ext.create("Ext.draw.gradient.Linear",a)}else{if(a.type==="radial"){return Ext.create("Ext.draw.gradient.Radial",a)}else{if(a.type==="pattern"){return Ext.create("Ext.draw.gradient.Pattern",a)}}}},limited:function(a,b){return function(c){return isNaN(c)?undefined:Math.min(Math.max(+c,a),b)}},limited01:function(a){return isNaN(a)?undefined:Math.min(Math.max(+a,0),1)},enums:function(){var d={},a=Array.prototype.slice.call(arguments,0),b,c;for(b=0,c=a.length;b<c;b++){d[a[b]]=true}return function(e){return e in d?e:undefined}}});Ext.define("Ext.draw.sprite.AttributeDefinition",{requires:["Ext.draw.sprite.AttributeParser","Ext.draw.sprite.AnimationParser"],config:{defaults:{},aliases:{},animationProcessors:{},processors:{},dirtyTriggers:{},updaters:{}},inheritableStatics:{processorRe:/^(\w+)\(([\w\-,]*)\)$/},constructor:function(a){var b=this;b.initConfig(a)},applyDefaults:function(b,a){a=Ext.apply(a||{},this.normalize(b));return a},applyAliases:function(b,a){return Ext.apply(a||{},b)},applyProcessors:function(d,i){this.getAnimationProcessors();var a,j=i||{},g=Ext.draw.sprite.AttributeParser,h=this.self.processorRe,f={},c,b,e;for(a in d){e=d[a];if(!Ext.isFunction(e)){if(Ext.isString(e)){b=e.match(h);if(b){e=g[b[1]].apply(g,b[2].split(","))}else{f[a]=e;c=true;e=g[e]}}else{continue}}j[a]=e}if(c){this.setAnimationProcessors(f)}return j},applyAnimationProcessors:function(c,a){var e=Ext.draw.sprite.AnimationParser,d;if(!a){a={}}for(var b in c){d=c[b];if(d==="none"){a[b]=null}else{if(Ext.isString(d)&&!(b in a)){if(d in e){while(Ext.isString(e[d])){d=e[d]}a[b]=e[d]}}else{if(Ext.isObject(d)){a[b]=d}}}}return a},applyDirtyTriggers:function(c,b){if(!b){b={}}for(var a in c){b[a]=c[a].split(",")}return b},applyUpdaters:function(b,a){return Ext.apply(a||{},b)},batchedNormalize:function(f,o){if(!f){return{}}var g=this,k=g.getProcessors(),d=g.getAliases(),a=f.translation||f.translate,p={},h,j,b,e,q,c,n,m,l;if("rotation" in f){q=f.rotation}else{q=("rotate" in f)?f.rotate:undefined}if("scaling" in f){c=f.scaling}else{c=("scale" in f)?f.scale:undefined}if(typeof c!=="undefined"){if(Ext.isNumber(c)){p.scalingX=c;p.scalingY=c}else{if("x" in c){p.scalingX=c.x}if("y" in c){p.scalingY=c.y}if("centerX" in c){p.scalingCenterX=c.centerX}if("centerY" in c){p.scalingCenterY=c.centerY}}}if(typeof q!=="undefined"){if(Ext.isNumber(q)){q=Ext.draw.Draw.rad(q);p.rotationRads=q}else{if("rads" in q){p.rotationRads=q.rads}else{if("degrees" in q){if(Ext.isArray(q.degrees)){p.rotationRads=Ext.Array.map(q.degrees,function(i){return Ext.draw.Draw.rad(i)})}else{p.rotationRads=Ext.draw.Draw.rad(q.degrees)}}}if("centerX" in q){p.rotationCenterX=q.centerX}if("centerY" in q){p.rotationCenterY=q.centerY}}}if(typeof a!=="undefined"){if("x" in a){p.translationX=a.x}if("y" in a){p.translationY=a.y}}if("matrix" in f){n=Ext.draw.Matrix.create(f.matrix);l=n.split();p.matrix=n;p.rotationRads=l.rotation;p.rotationCenterX=0;p.rotationCenterY=0;p.scalingX=l.scaleX;p.scalingY=l.scaleY;p.scalingCenterX=0;p.scalingCenterY=0;p.translationX=l.translateX;p.translationY=l.translateY}for(b in f){e=f[b];if(typeof e==="undefined"){continue}else{if(Ext.isArray(e)){if(b in d){b=d[b]}if(b in k){p[b]=[];for(h=0,j=e.length;h<j;h++){m=k[b].call(this,e[h]);if(typeof m!=="undefined"){p[b][h]=m}}}else{if(o){p[b]=e}}}else{if(b in d){b=d[b]}if(b in k){e=k[b].call(this,e);if(typeof e!=="undefined"){p[b]=e}}else{if(o){p[b]=e}}}}}return p},normalize:function(j,k){if(!j){return{}}var f=this,g=f.getProcessors(),d=f.getAliases(),a=j.translation||j.translate,l={},b,e,m,c,i,h;if("rotation" in j){m=j.rotation}else{m=("rotate" in j)?j.rotate:undefined}if("scaling" in j){c=j.scaling}else{c=("scale" in j)?j.scale:undefined}if(a){if("x" in a){l.translationX=a.x}if("y" in a){l.translationY=a.y}}if(typeof c!=="undefined"){if(Ext.isNumber(c)){l.scalingX=c;l.scalingY=c}else{if("x" in c){l.scalingX=c.x}if("y" in c){l.scalingY=c.y}if("centerX" in c){l.scalingCenterX=c.centerX}if("centerY" in c){l.scalingCenterY=c.centerY}}}if(typeof m!=="undefined"){if(Ext.isNumber(m)){m=Ext.draw.Draw.rad(m);l.rotationRads=m}else{if("rads" in m){l.rotationRads=m.rads}else{if("degrees" in m){l.rotationRads=Ext.draw.Draw.rad(m.degrees)}}if("centerX" in m){l.rotationCenterX=m.centerX}if("centerY" in m){l.rotationCenterY=m.centerY}}}if("matrix" in j){i=Ext.draw.Matrix.create(j.matrix);h=i.split();l.matrix=i;l.rotationRads=h.rotation;l.rotationCenterX=0;l.rotationCenterY=0;l.scalingX=h.scaleX;l.scalingY=h.scaleY;l.scalingCenterX=0;l.scalingCenterY=0;l.translationX=h.translateX;l.translationY=h.translateY}for(b in j){e=j[b];if(typeof e==="undefined"){continue}if(b in d){b=d[b]}if(b in g){e=g[b].call(this,e);if(typeof e!=="undefined"){l[b]=e}}else{if(k){l[b]=e}}}return l},setBypassingNormalization:function(a,c,b){return c.pushDown(a,b)},set:function(a,c,b){b=this.normalize(b);return this.setBypassingNormalization(a,c,b)}});Ext.define("Ext.draw.Matrix",{statics:{createAffineMatrixFromTwoPair:function(h,t,g,s,k,o,i,j){var v=g-h,u=s-t,e=i-k,q=j-o,d=1/(v*v+u*u),p=v*e+u*q,n=e*u-v*q,m=-p*h-n*t,l=n*h-p*t;return new this(p*d,-n*d,n*d,p*d,m*d+k,l*d+o)},createPanZoomFromTwoPair:function(q,e,p,c,h,s,n,g){if(arguments.length===2){return this.createPanZoomFromTwoPair.apply(this,q.concat(e))}var k=p-q,j=c-e,d=(q+p)*0.5,b=(e+c)*0.5,o=n-h,a=g-s,f=(h+n)*0.5,l=(s+g)*0.5,m=k*k+j*j,i=o*o+a*a,t=Math.sqrt(i/m);return new this(t,0,0,t,f-t*d,l-t*b)},fly:(function(){var a=null,b=function(c){a.elements=c;return a};return function(c){if(!a){a=new Ext.draw.Matrix()}a.elements=c;Ext.draw.Matrix.fly=b;return a}})(),create:function(a){if(a instanceof this){return a}return new this(a)}},constructor:function(e,d,a,f,c,b){if(e&&e.length===6){this.elements=e.slice()}else{if(e!==undefined){this.elements=[e,d,a,f,c,b]}else{this.elements=[1,0,0,1,0,0]}}},prepend:function(a,l,h,g,m,k){var b=this.elements,d=b[0],j=b[1],e=b[2],c=b[3],i=b[4],f=b[5];b[0]=a*d+h*j;b[1]=l*d+g*j;b[2]=a*e+h*c;b[3]=l*e+g*c;b[4]=a*i+h*f+m;b[5]=l*i+g*f+k;return this},prependMatrix:function(a){return this.prepend.apply(this,a.elements)},append:function(a,l,h,g,m,k){var b=this.elements,d=b[0],j=b[1],e=b[2],c=b[3],i=b[4],f=b[5];b[0]=a*d+l*e;b[1]=a*j+l*c;b[2]=h*d+g*e;b[3]=h*j+g*c;b[4]=m*d+k*e+i;b[5]=m*j+k*c+f;return this},appendMatrix:function(a){return this.append.apply(this,a.elements)},set:function(f,e,a,g,c,b){var d=this.elements;d[0]=f;d[1]=e;d[2]=a;d[3]=g;d[4]=c;d[5]=b;return this},inverse:function(i){var g=this.elements,o=g[0],m=g[1],l=g[2],k=g[3],j=g[4],h=g[5],n=1/(o*k-m*l);o*=n;m*=n;l*=n;k*=n;if(i){i.set(k,-m,-l,o,l*h-k*j,m*j-o*h);return i}else{return new Ext.draw.Matrix(k,-m,-l,o,l*h-k*j,m*j-o*h)}},translate:function(a,c,b){if(b){return this.prepend(1,0,0,1,a,c)}else{return this.append(1,0,0,1,a,c)}},scale:function(f,e,c,a,b){var d=this;if(e==null){e=f}if(c===undefined){c=0}if(a===undefined){a=0}if(b){return d.prepend(f,0,0,e,c-c*f,a-a*e)}else{return d.append(f,0,0,e,c-c*f,a-a*e)}},rotate:function(g,e,c,b){var d=this,f=Math.cos(g),a=Math.sin(g);e=e||0;c=c||0;if(b){return d.prepend(f,a,-a,f,e-f*e+c*a,c-f*c-e*a)}else{return d.append(f,a,-a,f,e-f*e+c*a,c-f*c-e*a)}},rotateFromVector:function(a,h,c){var e=this,g=Math.sqrt(a*a+h*h),f=a/g,b=h/g;if(c){return e.prepend(f,b,-b,f,0,0)}else{return e.append(f,b,-b,f,0,0)}},clone:function(){return new Ext.draw.Matrix(this.elements)},flipX:function(){return this.append(-1,0,0,1,0,0)},flipY:function(){return this.append(1,0,0,-1,0,0)},skewX:function(a){return this.append(1,Math.tan(a),0,-1,0,0)},skewY:function(a){return this.append(1,0,Math.tan(a),-1,0,0)},reset:function(){return this.set(1,0,0,1,0,0)},precisionCompensate:function(j,g){var c=this.elements,f=c[0],e=c[1],i=c[2],h=c[3],d=c[4],b=c[5],a=e*i-f*h;g.b=j*e/f;g.c=j*i/h;g.d=j;g.xx=f/j;g.yy=h/j;g.dx=(b*f*i-d*f*h)/a/j;g.dy=(d*e*h-b*f*h)/a/j},precisionCompensateRect:function(j,g){var b=this.elements,f=b[0],e=b[1],i=b[2],h=b[3],c=b[4],a=b[5],d=i/f;g.b=j*e/f;g.c=j*d;g.d=j*h/f;g.xx=f/j;g.yy=f/j;g.dx=(a*i-c*h)/(e*d-h)/j;g.dy=-(a*f-c*e)/(e*d-h)/j},x:function(a,c){var b=this.elements;return a*b[0]+c*b[2]+b[4]},y:function(a,c){var b=this.elements;return a*b[1]+c*b[3]+b[5]},get:function(b,a){return +this.elements[b+a*2].toFixed(4)},transformPoint:function(a){var b=this.elements;return[a[0]*b[0]+a[1]*b[2]+b[4],a[0]*b[1]+a[1]*b[3]+b[5]]},transformBBox:function(q,i,j){var b=this.elements,d=q.x,r=q.y,g=q.width*0.5,o=q.height*0.5,a=b[0],s=b[1],n=b[2],k=b[3],e=d+g,c=r+o,p,f,m;if(i){g-=i;o-=i;m=[Math.sqrt(b[0]*b[0]+b[2]*b[2]),Math.sqrt(b[1]*b[1]+b[3]*b[3])];p=Math.abs(g*a)+Math.abs(o*n)+Math.abs(m[0]*i);f=Math.abs(g*s)+Math.abs(o*k)+Math.abs(m[1]*i)}else{p=Math.abs(g*a)+Math.abs(o*n);f=Math.abs(g*s)+Math.abs(o*k)}if(!j){j={}}j.x=e*a+c*n+b[4]-p;j.y=e*s+c*k+b[5]-f;j.width=p+p;j.height=f+f;return j},transformList:function(e){var b=this.elements,a=b[0],h=b[2],l=b[4],k=b[1],g=b[3],j=b[5],f=e.length,c,d;for(d=0;d<f;d++){c=e[d];e[d]=[c[0]*a+c[1]*h+l,c[0]*k+c[1]*g+j]}return e},isIdentity:function(){var a=this.elements;return a[0]===1&&a[1]===0&&a[2]===0&&a[3]===1&&a[4]===0&&a[5]===0},equals:function(a){var c=this.elements,b=a.elements;return c[0]===b[0]&&c[1]===b[1]&&c[2]===b[2]&&c[3]===b[3]&&c[4]===b[4]&&c[5]===b[5]},toArray:function(){var a=this.elements;return[a[0],a[2],a[4],a[1],a[3],a[5]]},toVerticalArray:function(){return this.elements.slice()},toString:function(){var a=this;return[a.get(0,0),a.get(0,1),a.get(1,0),a.get(1,1),a.get(2,0),a.get(2,1)].join(",")},toContext:function(a){a.transform.apply(a,this.elements);return this},toSvg:function(){var a=this.elements;return"matrix("+a[0].toFixed(9)+","+a[1].toFixed(9)+","+a[2].toFixed(9)+","+a[3].toFixed(9)+","+a[4].toFixed(9)+","+a[5].toFixed(9)+")"},getScaleX:function(){var a=this.elements;return Math.sqrt(a[0]*a[0]+a[2]*a[2])},getScaleY:function(){var a=this.elements;return Math.sqrt(a[1]*a[1]+a[3]*a[3])},getXX:function(){return this.elements[0]},getXY:function(){return this.elements[1]},getYX:function(){return this.elements[2]},getYY:function(){return this.elements[3]},getDX:function(){return this.elements[4]},getDY:function(){return this.elements[5]},split:function(){var c=this.elements,e=c[0],d=c[1],a=c[2],f=c[3],b={translateX:c[4],translateY:c[5]};b.scaleX=Math.sqrt(e*e+a*a);b.shear=(e*d+a*f)/b.scaleX;d-=b.shear*e;f-=b.shear*a;b.scaleY=Math.sqrt(d*d+f*f);b.shear/=b.scaleY;b.rotation=-Math.atan2(a/b.scaleX,d/b.scaleY);b.isSimple=Math.abs(b.shear)<1e-9&&(!b.rotation||Math.abs(b.scaleX-b.scaleY)<1e-9);return b}},function(){function b(e,c,d){e[c]={get:function(){return this.elements[d]},set:function(f){this.elements[d]=f}}}if(Object.defineProperties){var a={};b(a,"a",0);b(a,"b",1);b(a,"c",2);b(a,"d",3);b(a,"e",4);b(a,"f",5);Object.defineProperties(this.prototype,a)}this.prototype.multiply=this.prototype.appendMatrix});Ext.define("Ext.draw.modifier.Modifier",{mixins:{observable:"Ext.mixin.Observable"},config:{previous:null,next:null,sprite:null},constructor:function(a){this.mixins.observable.constructor.call(this,a)},updateNext:function(a){if(a){a.setPrevious(this)}},updatePrevious:function(a){if(a){a.setNext(this)}},prepareAttributes:function(a){if(this._previous){this._previous.prepareAttributes(a)}},popUp:function(a,b){if(this._next){this._next.popUp(a,b)}else{Ext.apply(a,b)}},pushDown:function(a,c){if(this._previous){return this._previous.pushDown(a,c)}else{for(var b in c){if(c[b]===a[b]){delete c[b]}}return c}}});Ext.define("Ext.draw.modifier.Target",{requires:["Ext.draw.Matrix"],extend:"Ext.draw.modifier.Modifier",alias:"modifier.target",statics:{uniqueId:0},prepareAttributes:function(a){if(this._previous){this._previous.prepareAttributes(a)}a.attributeId="attribute-"+Ext.draw.modifier.Target.uniqueId++;if(!a.hasOwnProperty("canvasAttributes")){a.bbox={plain:{dirty:true},transform:{dirty:true}};a.dirty=true;a.dirtyFlags={};a.canvasAttributes={};a.matrix=new Ext.draw.Matrix();a.inverseMatrix=new Ext.draw.Matrix()}},setDirtyFlags:function(g,k){Ext.apply(g,k);var n=this._sprite,m=n.self.def._dirtyTriggers,b,a=g.dirtyFlags,d,f,j,c,e,h,l;for(b in k){if((j=m[b])){e=0;while((c=j[e++])){if(!(d=a[c])){d=a[c]=[]}d.push(b)}}}for(b in k){f=true;break}if(!f){return}if(a.canvas){l=a.canvas;delete a.canvas;for(e=0,h=l.length;e<h;e++){b=l[e];g.canvasAttributes[b]=g[b]}}if(g.hasOwnProperty("children")){for(e=0,h=g.children.length;e<h;e++){Ext.apply(g.children[e].dirtyFlags,a);n.updateDirtyFlags(g.children[e])}}n.setDirty(true)},popUp:function(a,b){this.setDirtyFlags(a,b);this._sprite.updateDirtyFlags(a)},pushDown:function(a,b){if(this._previous){b=this._previous.pushDown(a,b)}this.setDirtyFlags(a,b);this._sprite.updateDirtyFlags(a);return b}});(function(){var f=Math.pow,j=Math.sin,m=Math.cos,k=Math.sqrt,e=Math.PI,c,n,a,h,g,d,b;a=["quad","cubic","quart","quint"];c={pow:function(l,i){return f(l,i[0]||6)},expo:function(i){return f(2,8*(i-1))},circ:function(i){return 1-k(1-i*i)},sine:function(i){return 1-j((1-i)*e/2)},back:function(i,l){l=l||1.616;return i*i*((l+1)*i-l)},bounce:function(q){var o;for(var l=0,i=1;1;l+=i,i/=2){if(q>=(7-4*l)/11){o=i*i-f((11-6*l-11*q)/4,2);break}}return o},elastic:function(l,i){return f(2,10*--l)*m(20*l*e*(i||1)/3)}};n=function(l,i){i=i&&i.length?i:[i];return Ext.apply(l,{easeIn:function(o){return l(o,i)},easeOut:function(o){return 1-l(1-o,i)},easeInOut:function(o){return(o<=0.5)?l(2*o,i)/2:(2-l(2*(1-o),i))/2}})};h=function(i){return function(l){return f(l,i)}};for(d=0,b=a.length;d<b;++d){c[a[d]]=h(d+2)}c.linear=function(i){return i};for(g in c){if(c.hasOwnProperty(g)){n(c[g])}}Ext.define("Ext.draw.TimingFunctions",{singleton:true,easingMap:{linear:c.linear,easeIn:c.quad.easeIn,easeOut:c.quad.easeOut,easeInOut:c.quad.easeInOut,backIn:c.back,backOut:function(i,l){return 1-c.back(1-i,l)},backInOut:function(i,l){if(i<0.5){return c.back(i*2,l)*0.5}else{return 1-c.back((1-i)*2,l)*0.5}},elasticIn:function(i,l){return 1-c.elastic(1-i,l)},elasticOut:c.elastic,bounceIn:c.bounce,bounceOut:function(i){return 1-c.bounce(1-i)}}},function(){Ext.apply(this,c)})})();Ext.define("Ext.draw.Animator",{uses:["Ext.draw.Draw"],singleton:true,frameCallbacks:{},frameCallbackId:0,scheduled:0,frameStartTimeOffset:Ext.now(),animations:[],running:false,animationTime:function(){return Ext.AnimationQueue.frameStartTime-this.frameStartTimeOffset},add:function(a){if(!this.contains(a)){this.animations.push(a);Ext.draw.Animator.ignite();if("fireEvent" in a){a.fireEvent("animationstart",a)}}},remove:function(d){var c=this,e=c.animations,b=0,a=e.length;for(;b<a;++b){if(e[b]===d){e.splice(b,1);if("fireEvent" in d){d.fireEvent("animationend",d)}return}}},contains:function(a){return Ext.Array.indexOf(this.animations,a)>-1},empty:function(){return this.animations.length===0},step:function(d){var c=this,f=c.animations,e,a=0,b=f.length;for(;a<b;a++){e=f[a];e.step(d);if(!e.animating){f.splice(a,1);a--;b--;if(e.fireEvent){e.fireEvent("animationend")}}}},schedule:function(c,a){a=a||this;var b="frameCallback"+(this.frameCallbackId++);if(Ext.isString(c)){c=a[c]}Ext.draw.Animator.frameCallbacks[b]={fn:c,scope:a,once:true};this.scheduled++;Ext.draw.Animator.ignite();return b},cancel:function(a){if(Ext.draw.Animator.frameCallbacks[a]&&Ext.draw.Animator.frameCallbacks[a].once){this.scheduled--;delete Ext.draw.Animator.frameCallbacks[a]}},addFrameCallback:function(c,a){a=a||this;if(Ext.isString(c)){c=a[c]}var b="frameCallback"+(this.frameCallbackId++);Ext.draw.Animator.frameCallbacks[b]={fn:c,scope:a};return b},removeFrameCallback:function(a){delete Ext.draw.Animator.frameCallbacks[a]},fireFrameCallbacks:function(){var c=this.frameCallbacks,d,b,a;for(d in c){a=c[d];b=a.fn;if(Ext.isString(b)){b=a.scope[b]}b.call(a.scope);if(c[d]&&a.once){this.scheduled--;delete c[d]}}},handleFrame:function(){this.step(this.animationTime());this.fireFrameCallbacks();if(!this.scheduled&&this.empty()){Ext.AnimationQueue.stop(this.handleFrame,this);this.running=false}},ignite:function(){if(!this.running){this.running=true;Ext.AnimationQueue.start(this.handleFrame,this);Ext.draw.Draw.updateIOS()}}});Ext.define("Ext.draw.modifier.Animation",{requires:["Ext.draw.TimingFunctions","Ext.draw.Animator"],extend:"Ext.draw.modifier.Modifier",alias:"modifier.animation",config:{easing:function(a){return a},duration:0,customEasings:{},customDurations:{},customDuration:null},constructor:function(){this.anyAnimation=false;this.anySpecialAnimations=false;this.animating=0;this.animatingPool=[];this.callParent(arguments)},prepareAttributes:function(a){if(!a.hasOwnProperty("timers")){a.animating=false;a.timers={};a.animationOriginal=Ext.Object.chain(a);a.animationOriginal.prototype=a}if(this._previous){this._previous.prepareAttributes(a.animationOriginal)}},updateSprite:function(a){this.setConfig(a.config.fx)},updateDuration:function(a){this.anyAnimation=a>0},applyEasing:function(a){if(typeof a==="string"){return Ext.draw.TimingFunctions.easingMap[a]}else{return a}},applyCustomEasings:function(a,e){e=e||{};var g,d,b,h,c,f;for(d in a){g=true;h=a[d];b=d.split(",");if(typeof h==="string"){h=Ext.draw.TimingFunctions.easingMap[h]}for(c=0,f=b.length;c<f;c++){e[b[c]]=h}}if(g){this.anySpecialAnimations=g}return e},setEasingOn:function(a,e){a=Ext.Array.from(a).slice();var c={},d=a.length,b=0;for(;b<d;b++){c[a[b]]=e}this.setCustomEasings(c)},clearEasingOn:function(a){a=Ext.Array.from(a,true);var b=0,c=a.length;for(;b<c;b++){delete this._customEasings[a[b]]}},applyCustomDurations:function(g,h){h=h||{};var e,c,f,a,b,d;for(c in g){e=true;f=g[c];a=c.split(",");for(b=0,d=a.length;b<d;b++){h[a[b]]=f}}if(e){this.anySpecialAnimations=e}return h},applyCustomDuration:function(a,b){if(a){this.getCustomDurations();this.setCustomDurations(a)}},setDurationOn:function(b,e){b=Ext.Array.from(b).slice();var a={},c=0,d=b.length;for(;c<d;c++){a[b[c]]=e}this.setCustomDurations(a)},clearDurationOn:function(a){a=Ext.Array.from(a,true);var b=0,c=a.length;for(;b<c;b++){delete this._customDurations[a[b]]}},setAnimating:function(b,a){var e=this,d,c;if(b.animating!==a){b.animating=a;if(a){e.animatingPool.push(b);if(e.animating===0){Ext.draw.Animator.add(e)}e.animating++}else{for(d=0,c=0;d<e.animatingPool.length;d++){if(e.animatingPool[d]!==b){e.animatingPool[c++]=e.animatingPool[d]}}e.animating=e.animatingPool.length=c}}},setAttrs:function(q,s){var m=q.timers,h=this._sprite.self.def._animationProcessors,f=this._easing,e=this._duration,j=this._customDurations,i=this._customEasings,g=this.anySpecialAnimations,n=this.anyAnimation||g,r=q.animationOriginal,d=false,k,t,l,o,c,p,a;if(!n){for(t in s){if(q[t]===s[t]){delete s[t]}else{q[t]=s[t]}delete r[t];delete m[t]}return s}else{for(t in s){l=s[t];o=q[t];if(l!==o&&o!==undefined&&o!==null&&(c=h[t])){p=f;a=e;if(g){if(t in i){p=i[t]}if(t in j){a=j[t]}}if(o&&o.isGradient||l&&l.isGradient){a=0}if(a){if(!m[t]){m[t]={}}k=m[t];k.start=0;k.easing=p;k.duration=a;k.compute=c.compute;k.serve=c.serve||Ext.draw.Draw.reflectFn;if(c.parseInitial){var b=c.parseInitial(o,l);k.source=b[0];k.target=b[1]}else{if(c.parse){k.source=c.parse(o);k.target=c.parse(l)}else{k.source=o;k.target=l}}m[t]=k;r[t]=l;delete s[t];d=true;continue}else{delete r[t]}}else{delete r[t]}delete m[t]}}if(d&&!q.animating){this.setAnimating(q,true)}return s},updateAttributes:function(g){if(!g.animating){return{}}var h={},f=false,d=g.animationOriginal,e=g.timers,c=Ext.draw.Animator.animationTime(),a,b,i;if(g.lastUpdate===c){return{}}for(a in e){b=e[a];if(!b.start){b.start=c;i=0}else{i=(c-b.start)/b.duration}if(i>=1){h[a]=d[a];delete d[a];delete e[a]}else{h[a]=b.serve(b.compute(b.source,b.target,b.easing(i),g[a]));f=true}}g.lastUpdate=c;this.setAnimating(g,f);return h},pushDown:function(a,b){b=this.superclass.pushDown.call(this,a.animationOriginal,b);return this.setAttrs(a,b)},popUp:function(a,b){a=a.prototype;b=this.setAttrs(a,b);if(this._next){return this._next.popUp(a,b)}else{return Ext.apply(a,b)}},step:function(){var g=this,d=g.animatingPool.slice(),a,c,f;for(c=0,f=d.length;c<f;c++){a=d[c];var e=this.updateAttributes(a),b;for(b in e){if(this._next){this._next.popUp(a,e)}break}}},stop:function(){this.step();var d=this,b=d.animatingPool,a,c;for(a=0,c=b.length;a<c;a++){b[a].animating=false}d.animatingPool.length=0;d.animating=0;Ext.draw.Animator.remove(d)},destroy:function(){var a=this;a.animatingPool.length=0;a.animating=0}});Ext.define("Ext.draw.modifier.Highlight",{extend:"Ext.draw.modifier.Modifier",alias:"modifier.highlight",config:{enabled:false,highlightStyle:null},preFx:true,applyHighlightStyle:function(b,a){a=a||{};if(this.getSprite()){Ext.apply(a,this.getSprite().self.def.normalize(b))}else{Ext.apply(a,b)}return a},prepareAttributes:function(a){if(!a.hasOwnProperty("highlightOriginal")){a.highlighted=false;a.highlightOriginal=Ext.Object.chain(a);a.highlightOriginal.prototype=a}if(this._previous){this._previous.prepareAttributes(a.highlightOriginal)}},updateSprite:function(b,a){if(b){if(this.getHighlightStyle()){this._highlightStyle=b.self.def.normalize(this.getHighlightStyle())}this.setHighlightStyle(b.config.highlight)}var c=b.self.def;this.setSprite(b);c.setConfig({defaults:{highlighted:false},processors:{highlighted:"bool"},dirtyTriggers:{},updaters:{}})},filterChanges:function(a,e){var f=this,b,c=a.highlightOriginal,d=f.getHighlightStyle();if(a.highlighted){for(b in e){if(d.hasOwnProperty(b)){c[b]=e[b];delete e[b]}}}for(b in e){if(b!=="highlighted"&&c[b]===e[b]){delete e[b]}}return e},pushDown:function(a,e){var d=this.getHighlightStyle(),c=a.highlightOriginal,f,b;if(e.hasOwnProperty("highlighted")){f=e.highlighted;delete e.highlighted;if(this._previous){e=this._previous.pushDown(c,e)}e=this.filterChanges(a,e);if(f!==a.highlighted){if(f){for(b in d){if(b in e){c[b]=e[b]}else{c[b]=a[b]}if(c[b]!==d[b]){e[b]=d[b]}}}else{for(b in d){if(!(b in e)){e[b]=c[b]}delete c[b]}}e.highlighted=f}}else{if(this._previous){e=this._previous.pushDown(c,e)}e=this.filterChanges(a,e)}return e},popUp:function(a,b){b=this.filterChanges(a,b);Ext.draw.modifier.Modifier.prototype.popUp.call(this,a,b)}});Ext.define("Ext.draw.sprite.Sprite",{alias:"sprite.sprite",mixins:{observable:"Ext.mixin.Observable"},requires:["Ext.draw.Draw","Ext.draw.gradient.Gradient","Ext.draw.sprite.AttributeDefinition","Ext.draw.modifier.Target","Ext.draw.modifier.Animation","Ext.draw.modifier.Highlight"],isSprite:true,inheritableStatics:{def:{processors:{strokeStyle:"color",fillStyle:"color",strokeOpacity:"limited01",fillOpacity:"limited01",lineWidth:"number",lineCap:"enums(butt,round,square)",lineJoin:"enums(round,bevel,miter)",lineDash:"data",lineDashOffset:"number",miterLimit:"number",shadowColor:"color",shadowOffsetX:"number",shadowOffsetY:"number",shadowBlur:"number",globalAlpha:"limited01",globalCompositeOperation:"enums(source-over,destination-over,source-in,destination-in,source-out,destination-out,source-atop,destination-atop,lighter,xor,copy)",hidden:"bool",transformFillStroke:"bool",zIndex:"number",translationX:"number",translationY:"number",rotationRads:"number",rotationCenterX:"number",rotationCenterY:"number",scalingX:"number",scalingY:"number",scalingCenterX:"number",scalingCenterY:"number",constrainGradients:"bool"},aliases:{stroke:"strokeStyle",fill:"fillStyle",color:"fillStyle","stroke-width":"lineWidth","stroke-linecap":"lineCap","stroke-linejoin":"lineJoin","stroke-miterlimit":"miterLimit","text-anchor":"textAlign",opacity:"globalAlpha",translateX:"translationX",translateY:"translationY",rotateRads:"rotationRads",rotateCenterX:"rotationCenterX",rotateCenterY:"rotationCenterY",scaleX:"scalingX",scaleY:"scalingY",scaleCenterX:"scalingCenterX",scaleCenterY:"scalingCenterY"},defaults:{hidden:false,zIndex:0,strokeStyle:"none",fillStyle:"none",lineWidth:1,lineDash:[],lineDashOffset:0,lineCap:"butt",lineJoin:"miter",miterLimit:10,shadowColor:"none",shadowOffsetX:0,shadowOffsetY:0,shadowBlur:0,globalAlpha:1,strokeOpacity:1,fillOpacity:1,transformFillStroke:false,translationX:0,translationY:0,rotationRads:0,rotationCenterX:null,rotationCenterY:null,scalingX:1,scalingY:1,scalingCenterX:null,scalingCenterY:null,constrainGradients:false},dirtyTriggers:{hidden:"canvas",zIndex:"zIndex",globalAlpha:"canvas",globalCompositeOperation:"canvas",transformFillStroke:"canvas",strokeStyle:"canvas",fillStyle:"canvas",strokeOpacity:"canvas",fillOpacity:"canvas",lineWidth:"canvas",lineCap:"canvas",lineJoin:"canvas",lineDash:"canvas",lineDashOffset:"canvas",miterLimit:"canvas",shadowColor:"canvas",shadowOffsetX:"canvas",shadowOffsetY:"canvas",shadowBlur:"canvas",translationX:"transform",translationY:"transform",rotationRads:"transform",rotationCenterX:"transform",rotationCenterY:"transform",scalingX:"transform",scalingY:"transform",scalingCenterX:"transform",scalingCenterY:"transform",constrainGradients:"canvas"},updaters:{bbox:function(a){a.bbox.plain.dirty=true;a.bbox.transform.dirty=true;if(a.rotationRads!==0&&(a.rotationCenterX===null||a.rotationCenterY===null)||((a.scalingX!==1||a.scalingY!==1)&&(a.scalingCenterX===null||a.scalingCenterY===null))){if(!a.dirtyFlags.transform){a.dirtyFlags.transform=[]}}},zIndex:function(a){a.dirtyZIndex=true},transform:function(a){a.dirtyTransform=true;a.bbox.transform.dirty=true}}}},attr:{},config:{parent:null,surface:null},onClassExtended:function(d,c){var b=d.superclass.self.def.initialConfig,a;if(c.inheritableStatics&&c.inheritableStatics.def){a=Ext.merge({},b,c.inheritableStatics.def);d.def=Ext.create("Ext.draw.sprite.AttributeDefinition",a);delete c.inheritableStatics.def}else{d.def=Ext.create("Ext.draw.sprite.AttributeDefinition",b)}},constructor:function(b){var c=this;b=Ext.isObject(b)?b:{};c.id=b.id||Ext.id(null,"ext-sprite-");c.attr={};c.mixins.observable.constructor.apply(c,arguments);var a=Ext.Array.from(b.modifiers,true);c.prepareModifiers(a);c.initializeAttributes();c.setAttributes(c.self.def.getDefaults(),true);c.setAttributes(b)},getDirty:function(){return this.attr.dirty},setDirty:function(a){if((this.attr.dirty=a)){if(this._parent){this._parent.setDirty(true)}}},addModifier:function(a,b){var c=this;if(!(a instanceof Ext.draw.modifier.Modifier)){a=Ext.factory(a,null,null,"modifier")}a.setSprite(this);if(a.preFx||a.config&&a.config.preFx){if(c.fx.getPrevious()){c.fx.getPrevious().setNext(a)}a.setNext(c.fx)}else{c.topModifier.getPrevious().setNext(a);a.setNext(c.topModifier)}if(b){c.initializeAttributes()}return a},prepareModifiers:function(d){var c=this,a,b;c.topModifier=new Ext.draw.modifier.Target({sprite:c});c.fx=new Ext.draw.modifier.Animation({sprite:c});c.fx.setNext(c.topModifier);for(a=0,b=d.length;a<b;a++){c.addModifier(d[a],false)}},initializeAttributes:function(){var a=this;a.topModifier.prepareAttributes(a.attr)},updateDirtyFlags:function(b){var e=this,g=b.dirtyFlags,d=e.self.def._updaters,f=false,c=false,a,h;do{f=false;for(h in g){f=true;a=g[h];delete g[h];e.updateDirtyFlags=Ext.emptyFn;if(d[h]){d[h].call(e,b,a)}delete e.updateDirtyFlags}c=c||f}while(f);if(c){e.setDirty(true)}},setAttributes:function(c,d,b){var a=this.attr;if(d){if(b){this.topModifier.pushDown(a,c)}else{this.topModifier.pushDown(a,Ext.apply({},c))}}else{this.topModifier.pushDown(a,this.self.def.normalize(c))}},setAttributesBypassingNormalization:function(b,a){return this.setAttributes(b,true,a)},getBBox:function(d){var e=this,a=e.attr,f=a.bbox,c=f.plain,b=f.transform;if(c.dirty){e.updatePlainBBox(c);c.dirty=false}if(d){return c}else{e.applyTransformations();if(b.dirty){e.updateTransformedBBox(b,c);b.dirty=false}return b}},updatePlainBBox:Ext.emptyFn,updateTransformedBBox:function(a,b){this.attr.matrix.transformBBox(b,0,a)},getBBoxCenter:function(a){var b=this.getBBox(a);if(b){return[b.x+b.width*0.5,b.y+b.height*0.5]}else{return[0,0]}},hide:function(){this.attr.hidden=true;this.setDirty(true);return this},show:function(){this.attr.hidden=false;this.setDirty(true);return this},useAttributes:function(i,e){this.applyTransformations();var f=this.attr,h=f.canvasAttributes,d=h.strokeStyle,g=h.fillStyle,b=h.lineDash,c=h.lineDashOffset,a;if(d){if(d.isGradient){i.strokeStyle="black";i.strokeGradient=d}else{i.strokeGradient=false}}if(g){if(g.isGradient){i.fillStyle="black";i.fillGradient=g}else{i.fillGradient=false}}if(b&&i.setLineDash){i.setLineDash(b)}if(c&&typeof i.lineDashOffset==="number"){i.lineDashOffset=c}for(a in h){if(h[a]!==undefined&&h[a]!==i[a]){i[a]=h[a]}}if(f.constrainGradients){i.setGradientBBox({x:e[0],y:e[1],width:e[2],height:e[3]})}else{i.setGradientBBox(this.getBBox(f.transformFillStroke))}},applyTransformations:function(d){if(!d&&!this.attr.dirtyTransform){return}var l=this,i=l.attr,a=l.getBBoxCenter(true),h=a[0],g=a[1],p=i.translationX,n=i.translationY,o=i.scalingX,m=i.scalingY===null?i.scalingX:i.scalingY,f=i.scalingCenterX===null?h:i.scalingCenterX,e=i.scalingCenterY===null?g:i.scalingCenterY,k=i.rotationRads,c=i.rotationCenterX===null?h:i.rotationCenterX,b=i.rotationCenterY===null?g:i.rotationCenterY,q=Math.cos(k),j=Math.sin(k);if(o===1&&m===1){f=0;e=0}if(k===0){c=0;b=0}i.matrix.elements=[q*o,j*m,-j*o,q*m,f+(c-q*c-f+b*j)*o+p,e+(b-q*b-e+c*-j)*m+n];i.matrix.inverse(i.inverseMatrix);i.dirtyTransform=false;i.bbox.transform.dirty=true},preRender:Ext.emptyFn,render:Ext.emptyFn,repaint:function(){var a=this.getSurface();if(a){a.renderFrame()}},destroy:function(){var b=this,a=b.topModifier,c;while(a){c=a;a=a.getPrevious();c.destroy()}delete b.attr;b.destroy=Ext.emptyFn;if(b.fireEvent("beforedestroy",b)!==false){b.fireEvent("destroy",b)}this.callParent()}},function(){this.def=Ext.create("Ext.draw.sprite.AttributeDefinition",this.def)});(function(){var b=2.0943951023931953,a=Math.abs,d=Math.cos,g=Math.cos,c=Math.acos,f=Math.sqrt,h=Math.exp,e=Math.log;Ext.define("Ext.draw.Solver",{singleton:true,cubicRoot:function(i){if(i>0){return h(e(i)/3)}else{if(i<0){return -h(e(-i)/3)}else{return 0}}},linearFunction:function(k,j){var i;if(k===0){i=function(l){return j};i.solve=function(l){return[]}}else{i=function(l){return k*l+j};i.solve=function(l){return[(l-j)/k]}}return i},quadraticFunction:function(k,j,p){var i;if(k===0){return this.linearFunction(j,p)}else{i=function(q){return(k*q+j)*q+p};var o=j*j-4*k*p,n=function(q){return o+4*k*q},m=1/k*0.5,l=-m*j;m=a(m);i.solve=function(r){var q=n(r);if(q<0){return[]}q=f(q);return[l-q*m,l+q*m]}}return i},cubicFunction:function(s,r,p,o){var v;if(s===0){return this.quadraticFunction(r,p,o)}else{v=function(w){return((s*w+r)*w+p)*w+o};var m=r/s/3,i=p/s,l=o/s,q=m*m,u=(m*i-l)*0.5-m*q,t=q-i/3,k=t*t*t;if(t===0){v.solve=function(w){return[-m+this.cubicRoot(u*2+w/s)]}}else{if(t>0){var j=f(t),n=j*j*j;j+=j}v.solve=function(E){E/=s;var A=u+E*0.5,C=A*A-k;if(C>0){C=f(C);return[-m+this.cubicRoot(A+C)+this.cubicRoot(A-C)]}else{if(C===0){var D=this.cubicRoot(A),F=-m-D;if(A>=0){return[F,F,-m+2*D]}else{return[-m+2*D,F,F]}}else{var B=c(A/n)/3,z=j*g(B)-m,x=j*g(B+b)-m,w=j*g(B-b)-m;if(z<x){if(x<w){return[z,x,w]}else{if(z<w){return[z,w,x]}else{return[w,z,x]}}}else{if(z<w){return[x,z,w]}else{if(x<w){return[x,w,z]}else{return[w,x,z]}}}}}}}}return v},createBezierSolver:function(j,i,l,k){return this.cubicFunction(3*(i-l)+k-j,3*(j-2*i+l),3*(i-j),j)}})})();Ext.define("Ext.draw.Path",{requires:["Ext.draw.Draw","Ext.draw.Solver"],statics:{pathRe:/,?([achlmqrstvxz]),?/gi,pathRe2:/-/gi,pathSplitRe:/\s|,/g},svgString:"",constructor:function(a){var b=this;b.coords=[];b.types=[];b.cursor=null;b.startX=0;b.startY=0;b.solvers={};if(a){b.fromSvgString(a)}},clear:function(){var a=this;a.coords.length=0;a.types.length=0;a.cursor=null;a.startX=0;a.startY=0;a.solvers={};a.dirt()},dirt:function(){this.svgString=""},moveTo:function(a,c){var b=this;if(!b.cursor){b.cursor=[a,c]}b.coords.push(a,c);b.types.push("M");b.startX=a;b.startY=c;b.cursor[0]=a;b.cursor[1]=c;b.dirt()},lineTo:function(a,c){var b=this;if(!b.cursor){b.cursor=[a,c];b.coords.push(a,c);b.types.push("M")}else{b.coords.push(a,c);b.types.push("L")}b.cursor[0]=a;b.cursor[1]=c;b.dirt()},bezierCurveTo:function(c,e,b,d,a,g){var f=this;if(!f.cursor){f.moveTo(c,e)}f.coords.push(c,e,b,d,a,g);f.types.push("C");f.cursor[0]=a;f.cursor[1]=g;f.dirt()},quadraticCurveTo:function(b,e,a,d){var c=this;if(!c.cursor){c.moveTo(b,e)}c.bezierCurveTo((c.cursor[0]*2+b)/3,(c.cursor[1]*2+e)/3,(a*2+b)/3,(d*2+e)/3,a,d)},closePath:function(){var a=this;if(a.cursor){a.types.push("Z");a.dirt()}},arcTo:function(A,f,z,d,j,i,v){var E=this;if(i===undefined){i=j}if(v===undefined){v=0}if(!E.cursor){E.moveTo(A,f);return}if(j===0||i===0){E.lineTo(A,f);return}z-=A;d-=f;var B=E.cursor[0]-A,g=E.cursor[1]-f,C=z*g-d*B,b,a,l,r,k,q,x=Math.sqrt(B*B+g*g),u=Math.sqrt(z*z+d*d),t,e,c;if(C===0){E.lineTo(A,f);return}if(i!==j){b=Math.cos(v);a=Math.sin(v);l=b/j;r=a/i;k=-a/j;q=b/i;var D=l*B+r*g;g=k*B+q*g;B=D;D=l*z+r*d;d=k*z+q*d;z=D}else{B/=j;g/=i;z/=j;d/=i}e=B*u+z*x;c=g*u+d*x;t=1/(Math.sin(Math.asin(Math.abs(C)/(x*u))*0.5)*Math.sqrt(e*e+c*c));e*=t;c*=t;var o=(e*B+c*g)/(B*B+g*g),m=(e*z+c*d)/(z*z+d*d);var n=B*o-e,p=g*o-c,h=z*m-e,y=d*m-c,w=Math.atan2(p,n),s=Math.atan2(y,h);if(C>0){if(s<w){s+=Math.PI*2}}else{if(w<s){w+=Math.PI*2}}if(i!==j){e=b*e*j-a*c*i+A;c=a*c*i+b*c*i+f;E.lineTo(b*j*n-a*i*p+e,a*j*n+b*i*p+c);E.ellipse(e,c,j,i,v,w,s,C<0)}else{e=e*j+A;c=c*i+f;E.lineTo(j*n+e,i*p+c);E.ellipse(e,c,j,i,v,w,s,C<0)}},ellipse:function(g,f,c,a,q,m,d,e){var n=this,o=n.coords,b=o.length,l,k,h;if(d-m>=Math.PI*2){n.ellipse(g,f,c,a,q,m,m+Math.PI,e);n.ellipse(g,f,c,a,q,m+Math.PI,d,e);return}if(!e){if(d<m){d+=Math.PI*2}l=n.approximateArc(o,g,f,c,a,q,m,d)}else{if(m<d){m+=Math.PI*2}l=n.approximateArc(o,g,f,c,a,q,d,m);for(k=b,h=o.length-2;k<h;k+=2,h-=2){var p=o[k];o[k]=o[h];o[h]=p;p=o[k+1];o[k+1]=o[h+1];o[h+1]=p}}if(!n.cursor){n.cursor=[o[o.length-2],o[o.length-1]];n.types.push("M")}else{n.cursor[0]=o[o.length-2];n.cursor[1]=o[o.length-1];n.types.push("L")}for(k=2;k<l;k+=6){n.types.push("C")}n.dirt()},arc:function(b,f,a,d,c,e){this.ellipse(b,f,a,a,0,d,c,e)},rect:function(b,e,c,a){if(c==0||a==0){return}var d=this;d.moveTo(b,e);d.lineTo(b+c,e);d.lineTo(b+c,e+a);d.lineTo(b,e+a);d.closePath()},approximateArc:function(s,i,f,o,n,d,x,v){var e=Math.cos(d),z=Math.sin(d),k=Math.cos(x),l=Math.sin(x),q=e*k*o-z*l*n,y=-e*l*o-z*k*n,p=z*k*o+e*l*n,w=-z*l*o+e*k*n,m=Math.PI/2,r=2,j=q,u=y,h=p,t=w,b=0.547443256150549,C,g,A,a,B,c;v-=x;if(v<0){v+=Math.PI*2}s.push(q+i,p+f);while(v>=m){s.push(j+u*b+i,h+t*b+f,j*b+u+i,h*b+t+f,u+i,t+f);r+=6;v-=m;C=j;j=u;u=-C;C=h;h=t;t=-C}if(v){g=(0.3294738052815987+0.012120855841304373*v)*v;A=Math.cos(v);a=Math.sin(v);B=A+g*a;c=a-g*A;s.push(j+u*g+i,h+t*g+f,j*B+u*c+i,h*B+t*c+f,j*A+u*a+i,h*A+t*a+f);r+=6}return r},arcSvg:function(j,h,r,m,w,t,c){if(j<0){j=-j}if(h<0){h=-h}var x=this,u=x.cursor[0],f=x.cursor[1],a=(u-t)/2,y=(f-c)/2,d=Math.cos(r),s=Math.sin(r),o=a*d+y*s,v=-a*s+y*d,i=o/j,g=v/h,p=i*i+g*g,e=(u+t)*0.5,b=(f+c)*0.5,l=0,k=0;if(p>=1){p=Math.sqrt(p);j*=p;h*=p}else{p=Math.sqrt(1/p-1);if(m===w){p=-p}l=p*j*g;k=-p*h*i;e+=d*l-s*k;b+=s*l+d*k}var q=Math.atan2((v-k)/h,(o-l)/j),n=Math.atan2((-v-k)/h,(-o-l)/j)-q;if(w){if(n<=0){n+=Math.PI*2}}else{if(n>=0){n-=Math.PI*2}}x.ellipse(e,b,j,h,r,q,q+n,1-w)},fromSvgString:function(e){if(!e){return}var m=this,h,l={a:7,c:6,h:1,l:2,m:2,q:4,s:4,t:2,v:1,z:0,A:7,C:6,H:1,L:2,M:2,Q:4,S:4,T:2,V:1,Z:0},k="",g,f,c=0,b=0,d=false,j,n,a;if(Ext.isString(e)){h=e.replace(Ext.draw.Path.pathRe," $1 ").replace(Ext.draw.Path.pathRe2," -").split(Ext.draw.Path.pathSplitRe)}else{if(Ext.isArray(e)){h=e.join(",").split(Ext.draw.Path.pathSplitRe)}}for(j=0,n=0;j<h.length;j++){if(h[j]!==""){h[n++]=h[j]}}h.length=n;m.clear();for(j=0;j<h.length;){k=d;d=h[j];a=(d.toUpperCase()!==d);j++;switch(d){case"M":m.moveTo(c=+h[j],b=+h[j+1]);j+=2;while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c=+h[j],b=+h[j+1]);j+=2}break;case"L":m.lineTo(c=+h[j],b=+h[j+1]);j+=2;while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c=+h[j],b=+h[j+1]);j+=2}break;case"A":while(j<n&&!l.hasOwnProperty(h[j])){m.arcSvg(+h[j],+h[j+1],+h[j+2]*Math.PI/180,+h[j+3],+h[j+4],c=+h[j+5],b=+h[j+6]);j+=7}break;case"C":while(j<n&&!l.hasOwnProperty(h[j])){m.bezierCurveTo(+h[j],+h[j+1],g=+h[j+2],f=+h[j+3],c=+h[j+4],b=+h[j+5]);j+=6}break;case"Z":m.closePath();break;case"m":m.moveTo(c+=+h[j],b+=+h[j+1]);j+=2;while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c+=+h[j],b+=+h[j+1]);j+=2}break;case"l":m.lineTo(c+=+h[j],b+=+h[j+1]);j+=2;while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c+=+h[j],b+=+h[j+1]);j+=2}break;case"a":while(j<n&&!l.hasOwnProperty(h[j])){m.arcSvg(+h[j],+h[j+1],+h[j+2]*Math.PI/180,+h[j+3],+h[j+4],c+=+h[j+5],b+=+h[j+6]);j+=7}break;case"c":while(j<n&&!l.hasOwnProperty(h[j])){m.bezierCurveTo(c+(+h[j]),b+(+h[j+1]),g=c+(+h[j+2]),f=b+(+h[j+3]),c+=+h[j+4],b+=+h[j+5]);j+=6}break;case"z":m.closePath();break;case"s":if(!(k==="c"||k==="C"||k==="s"||k==="S")){g=c;f=b}while(j<n&&!l.hasOwnProperty(h[j])){m.bezierCurveTo(c+c-g,b+b-f,g=c+(+h[j]),f=b+(+h[j+1]),c+=+h[j+2],b+=+h[j+3]);j+=4}break;case"S":if(!(k==="c"||k==="C"||k==="s"||k==="S")){g=c;f=b}while(j<n&&!l.hasOwnProperty(h[j])){m.bezierCurveTo(c+c-g,b+b-f,g=+h[j],f=+h[j+1],c=(+h[j+2]),b=(+h[j+3]));j+=4}break;case"q":while(j<n&&!l.hasOwnProperty(h[j])){m.quadraticCurveTo(g=c+(+h[j]),f=b+(+h[j+1]),c+=+h[j+2],b+=+h[j+3]);j+=4}break;case"Q":while(j<n&&!l.hasOwnProperty(h[j])){m.quadraticCurveTo(g=+h[j],f=+h[j+1],c=+h[j+2],b=+h[j+3]);j+=4}break;case"t":if(!(k==="q"||k==="Q"||k==="t"||k==="T")){g=c;f=b}while(j<n&&!l.hasOwnProperty(h[j])){m.quadraticCurveTo(g=c+c-g,f=b+b-f,c+=+h[j+1],b+=+h[j+2]);j+=2}break;case"T":if(!(k==="q"||k==="Q"||k==="t"||k==="T")){g=c;f=b}while(j<n&&!l.hasOwnProperty(h[j])){m.quadraticCurveTo(g=c+c-g,f=b+b-f,c=(+h[j+1]),b=(+h[j+2]));j+=2}break;case"h":while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c+=+h[j],b);j++}break;case"H":while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c=+h[j],b);j++}break;case"v":while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c,b+=+h[j]);j++}break;case"V":while(j<n&&!l.hasOwnProperty(h[j])){m.lineTo(c,b=+h[j]);j++}break}}},rayTestLine:function(d,f,c,e,b,g){var a;if(f===e){if(g===f){if(Math.min(d,c)<=b&&b<=Math.max(d,c)){return -1}}else{return 0}}if(f<g&&g<e||e<g&&g<f){a=(g-f)*(c-d)/(e-f)+d;if(a===b){return -1}else{if(a<b){return 0}else{return 1}}}else{return 0}},rayTestCubicBezier:function(c,j,b,h,a,f,n,d,i,g,k){if(Math.min(c,b,a,n)<=i&&i<=Math.max(c,b,a,n)){if(Math.min(j,h,f,d)<=g&&g<=Math.max(j,h,f,d)){var e=this,m=e.solvers[k]||(e.solvers[k]=Ext.draw.Solver.createBezierSolver(c,b,a,n)),l=m.solve(g);return(+(i<=l[0]&&0<=l[0]&&l[0]<=1))+(+(i<=l[1]&&0<=l[1]&&l[1]<=1))+(+(i<=l[2]&&0<=l[2]&&l[2]<=1))}}return 0},isPointInPath:function(p,n){var m=this,f,e,g=0,l=0,h=m.types,o=m.coords,k=h.length,d=null,c=null,b=0,a=0;for(f=0,e=0;f<k;f++){switch(h[f]){case"M":if(d!==null){l=m.rayTestLine(d,c,b,a,p,n);if(l<0){g+=1}else{g+=l}}d=b=o[e];c=a=o[e+1];e+=2;break;case"L":l=m.rayTestLine(b,a,o[e],o[e+1],p,n);if(l<0){return true}g+=l;b=o[e];a=o[e+1];e+=2;break;case"C":l=m.rayTestCubicBezier(b,a,o[e],o[e+1],o[e+2],o[e+3],o[e+4],o[e+5],p,n,f);if(l<0){return true}g+=l;b=o[e+4];a=o[e+5];e+=6;break;case"Z":break}}return g%2===1},clone:function(){var a=this,b=new Ext.draw.Path();b.coords=a.coords.slice(0);b.types=a.types.slice(0);b.cursor=a.cursor?a.cursor.slice(0):null;b.startX=a.startX;b.startY=a.startY;b.svgString=a.svgString;return b},transform:function(j){if(j.isIdentity()){return}var a=j.getXX(),e=j.getYX(),m=j.getDX(),l=j.getXY(),d=j.getYY(),k=j.getDY(),h=this.coords,b=0,c=h.length,g,f;for(;b<c;b+=2){g=h[b];f=h[b+1];h[b]=g*a+f*e+m;h[b+1]=g*l+f*d+k}this.dirt()},getDimension:function(g){if(!g){g={}}if(!this.types||!this.types.length){g.x=0;g.y=0;g.width=0;g.height=0;return g}g.left=Infinity;g.top=Infinity;g.right=-Infinity;g.bottom=-Infinity;var d=0,b=0,c=this.types,f=this.coords,e=c.length,a,h;for(;d<e;d++){switch(c[d]){case"M":case"L":a=f[b];h=f[b+1];g.left=Math.min(a,g.left);g.top=Math.min(h,g.top);g.right=Math.max(a,g.right);g.bottom=Math.max(h,g.bottom);b+=2;break;case"C":this.expandDimension(g,a,h,f[b],f[b+1],f[b+2],f[b+3],a=f[b+4],h=f[b+5]);b+=6;break}}g.x=g.left;g.y=g.top;g.width=g.right-g.left;g.height=g.bottom-g.top;return g},getDimensionWithTransform:function(n,e){if(!this.types||!this.types.length){if(!e){e={}}e.x=0;e.y=0;e.width=0;e.height=0;return e}e.left=Infinity;e.top=Infinity;e.right=-Infinity;e.bottom=-Infinity;var a=n.getXX(),h=n.getYX(),q=n.getDX(),p=n.getXY(),g=n.getYY(),o=n.getDY(),c=0,b=0,d=this.types,m=this.coords,f=d.length,l,k;for(;c<f;c++){switch(d[c]){case"M":case"L":l=m[b]*a+m[b+1]*h+q;k=m[b]*p+m[b+1]*g+o;e.left=Math.min(l,e.left);e.top=Math.min(k,e.top);e.right=Math.max(l,e.right);e.bottom=Math.max(k,e.bottom);b+=2;break;case"C":this.expandDimension(e,l,k,m[b]*a+m[b+1]*h+q,m[b]*p+m[b+1]*g+o,m[b+2]*a+m[b+3]*h+q,m[b+2]*p+m[b+3]*g+o,l=m[b+4]*a+m[b+5]*h+q,k=m[b+4]*p+m[b+5]*g+o);b+=6;break}}if(!e){e={}}e.x=e.left;e.y=e.top;e.width=e.right-e.left;e.height=e.bottom-e.top;return e},expandDimension:function(i,d,p,k,g,j,e,c,o){var m=this,f=i.left,a=i.right,q=i.top,n=i.bottom,h=m.dim||(m.dim=[]);m.curveDimension(d,k,j,c,h);f=Math.min(f,h[0]);a=Math.max(a,h[1]);m.curveDimension(p,g,e,o,h);q=Math.min(q,h[0]);n=Math.max(n,h[1]);i.left=f;i.right=a;i.top=q;i.bottom=n},curveDimension:function(p,n,k,j,h){var i=3*(-p+3*(n-k)+j),g=6*(p-2*n+k),f=-3*(p-n),o,m,e=Math.min(p,j),l=Math.max(p,j),q;if(i===0){if(g===0){h[0]=e;h[1]=l;return}else{o=-f/g;if(0<o&&o<1){m=this.interpolate(p,n,k,j,o);e=Math.min(e,m);l=Math.max(l,m)}}}else{q=g*g-4*i*f;if(q>=0){q=Math.sqrt(q);o=(q-g)/2/i;if(0<o&&o<1){m=this.interpolate(p,n,k,j,o);e=Math.min(e,m);l=Math.max(l,m)}if(q>0){o-=q/i;if(0<o&&o<1){m=this.interpolate(p,n,k,j,o);e=Math.min(e,m);l=Math.max(l,m)}}}}h[0]=e;h[1]=l},interpolate:function(f,e,j,i,g){if(g===0){return f}if(g===1){return i}var h=(1-g)/g;return g*g*g*(i+h*(3*j+h*(3*e+h*f)))},fromStripes:function(g){var e=this,c=0,d=g.length,b,a,f;e.clear();for(;c<d;c++){f=g[c];e.coords.push.apply(e.coords,f);e.types.push("M");for(b=2,a=f.length;b<a;b+=6){e.types.push("C")}}if(!e.cursor){e.cursor=[]}e.cursor[0]=e.coords[e.coords.length-2];e.cursor[1]=e.coords[e.coords.length-1];e.dirt()},toStripes:function(h){var o=h||[],p,n,l,b,a,f,e,d,c,g=this.types,m=this.coords,k=g.length;for(d=0,c=0;d<k;d++){switch(g[d]){case"M":p=[f=b=m[c++],e=a=m[c++]];o.push(p);break;case"L":n=m[c++];l=m[c++];p.push((b+b+n)/3,(a+a+l)/3,(b+n+n)/3,(a+l+l)/3,b=n,a=l);break;case"C":p.push(m[c++],m[c++],m[c++],m[c++],b=m[c++],a=m[c++]);break;case"Z":n=f;l=e;p.push((b+b+n)/3,(a+a+l)/3,(b+n+n)/3,(a+l+l)/3,b=n,a=l);break}}return o},updateSvgString:function(){var a=[],d=this.types,f=this.coords,e=d.length,c=0,b=0;for(;c<e;c++){switch(d[c]){case"M":a.push("M"+f[b]+","+f[b+1]);b+=2;break;case"L":a.push("L"+f[b]+","+f[b+1]);b+=2;break;case"C":a.push("C"+f[b]+","+f[b+1]+" "+f[b+2]+","+f[b+3]+" "+f[b+4]+","+f[b+5]);b+=6;break;case"Z":a.push("Z");break}}this.svgString=a.join("")},toString:function(){if(!this.svgString){this.updateSvgString()}return this.svgString}});Ext.define("Ext.draw.sprite.Path",{extend:"Ext.draw.sprite.Sprite",requires:["Ext.draw.Draw","Ext.draw.Path"],alias:["sprite.path","Ext.draw.Sprite"],type:"path",inheritableStatics:{def:{processors:{path:function(b,a){if(!(b instanceof Ext.draw.Path)){b=new Ext.draw.Path(b)}return b}},aliases:{d:"path"},dirtyTriggers:{path:"bbox"},updaters:{path:function(a){var b=a.path;if(!b||b.bindAttr!==a){b=new Ext.draw.Path();b.bindAttr=a;a.path=b}b.clear();this.updatePath(b,a);a.dirtyFlags.bbox=["path"]}}}},updatePlainBBox:function(a){if(this.attr.path){this.attr.path.getDimension(a)}},updateTransformedBBox:function(a){if(this.attr.path){this.attr.path.getDimensionWithTransform(this.attr.matrix,a)}},render:function(b,c){var d=this.attr.matrix,a=this.attr;if(!a.path||a.path.coords.length===0){return}d.toContext(c);c.appendPath(a.path);c.fillStroke(a)},updatePath:function(b,a){}});Ext.define("Ext.draw.sprite.Circle",{extend:"Ext.draw.sprite.Path",alias:"sprite.circle",type:"circle",inheritableStatics:{def:{processors:{cx:"number",cy:"number",r:"number"},aliases:{radius:"r",x:"cx",y:"cy",centerX:"cx",centerY:"cy"},defaults:{cx:0,cy:0,r:4},dirtyTriggers:{cx:"path",cy:"path",r:"path"}}},updatePlainBBox:function(c){var b=this.attr,a=b.cx,e=b.cy,d=b.r;c.x=a-d;c.y=e-d;c.width=d+d;c.height=d+d},updateTransformedBBox:function(d){var i=this.attr,f=i.cx,e=i.cy,a=i.r,j=i.matrix,c=j.getScaleX(),b=j.getScaleY(),k,g;k=c*a;g=b*a;d.x=j.x(f,e)-k;d.y=j.y(f,e)-g;d.width=k+k;d.height=g+g},updatePath:function(b,a){b.arc(a.cx,a.cy,a.r,0,Math.PI*2,false)}});Ext.define("Ext.draw.sprite.Arc",{extend:"Ext.draw.sprite.Circle",alias:"sprite.arc",type:"arc",inheritableStatics:{def:{processors:{startAngle:"number",endAngle:"number",anticlockwise:"bool"},aliases:{from:"startAngle",to:"endAngle",start:"startAngle",end:"endAngle"},defaults:{startAngle:0,endAngle:Math.PI*2,anticlockwise:false},dirtyTriggers:{startAngle:"path",endAngle:"path",anticlockwise:"path"}}},updatePath:function(b,a){b.arc(a.cx,a.cy,a.r,a.startAngle,a.endAngle,a.anticlockwise)}});Ext.define("Ext.draw.sprite.Arrow",{extend:"Ext.draw.sprite.Path",alias:"sprite.arrow",inheritableStatics:{def:{processors:{x:"number",y:"number",size:"number"},defaults:{x:0,y:0,size:4},dirtyTriggers:{x:"path",y:"path",size:"path"}}},updatePath:function(d,b){var c=b.size*1.5,a=b.x-b.lineWidth/2,e=b.y;d.fromSvgString("M".concat(a-c*0.7,",",e-c*0.4,"l",[c*0.6,0,0,-c*0.4,c,c*0.8,-c,c*0.8,0,-c*0.4,-c*0.6,0],"z"))}});Ext.define("Ext.draw.sprite.Composite",{extend:"Ext.draw.sprite.Sprite",alias:"sprite.composite",type:"composite",constructor:function(){this.callParent(arguments);this.sprites=[];this.sprites.map={}},add:function(c){if(!c.isSprite){c=Ext.create("sprite."+c.type,c);c.setParent(this);c.setSurface(this.getSurface())}var b=c.applyTransformations,d=this,a=d.attr;c.applyTransformations=function(){if(c.attr.dirtyTransform){a.dirtyTransform=true;a.bbox.plain.dirty=true;a.bbox.transform.dirty=true}b.call(c)};this.sprites.push(c);this.sprites.map[c.id]=c.getId();a.bbox.plain.dirty=true;a.bbox.transform.dirty=true;return c},updateSurface:function(a){for(var b=0,c=this.sprites.length;b<c;b++){this.sprites[b].setSurface(a)}},addAll:function(b){if(b.isSprite||b.type){this.add(b)}else{if(Ext.isArray(b)){var a=0;while(a<b.length){this.add(b[a++])}}}},updatePlainBBox:function(g){var e=this,b=Infinity,h=-Infinity,f=Infinity,a=-Infinity,j,k,c,d;for(c=0,d=e.sprites.length;c<d;c++){j=e.sprites[c];j.applyTransformations();k=j.getBBox();if(b>k.x){b=k.x}if(h<k.x+k.width){h=k.x+k.width}if(f>k.y){f=k.y}if(a<k.y+k.height){a=k.y+k.height}}g.x=b;g.y=f;g.width=h-b;g.height=a-f},render:function(a,b,f){var d=this.attr.matrix,c,e;d.toContext(b);for(c=0,e=this.sprites.length;c<e;c++){a.renderSprite(this.sprites[c],f)}}});Ext.define("Ext.draw.sprite.Cross",{extend:"Ext.draw.sprite.Path",alias:"sprite.cross",inheritableStatics:{def:{processors:{x:"number",y:"number",size:"number"},defaults:{x:0,y:0,size:4},dirtyTriggers:{x:"path",y:"path",size:"path"}}},updatePath:function(d,b){var c=b.size/1.7,a=b.x-b.lineWidth/2,e=b.y;d.fromSvgString("M".concat(a-c,",",e,"l",[-c,-c,c,-c,c,c,c,-c,c,c,-c,c,c,c,-c,c,-c,-c,-c,c,-c,-c,"z"]))}});Ext.define("Ext.draw.sprite.Diamond",{extend:"Ext.draw.sprite.Path",alias:"sprite.diamond",inheritableStatics:{def:{processors:{x:"number",y:"number",size:"number"},defaults:{x:0,y:0,size:4},dirtyTriggers:{x:"path",y:"path",size:"path"}}},updatePath:function(d,b){var c=b.size*1.25,a=b.x-b.lineWidth/2,e=b.y;d.fromSvgString(["M",a,e-c,"l",c,c,-c,c,-c,-c,c,-c,"z"])}});Ext.define("Ext.draw.sprite.Ellipse",{extend:"Ext.draw.sprite.Path",alias:"sprite.ellipse",type:"circle",inheritableStatics:{def:{processors:{cx:"number",cy:"number",rx:"number",ry:"number",axisRotation:"number"},aliases:{radius:"r",x:"cx",y:"cy",centerX:"cx",centerY:"cy",radiusX:"rx",radiusY:"ry"},defaults:{cx:0,cy:0,rx:1,ry:1,axisRotation:0},dirtyTriggers:{cx:"path",cy:"path",rx:"path",ry:"path",axisRotation:"path"}}},updatePlainBBox:function(c){var b=this.attr,a=b.cx,f=b.cy,e=b.rx,d=b.ry;c.x=a-e;c.y=f-d;c.width=e+e;c.height=d+d},updateTransformedBBox:function(d){var i=this.attr,f=i.cx,e=i.cy,c=i.rx,b=i.ry,l=b/c,m=i.matrix.clone(),a,q,k,j,p,o,n,g;m.append(1,0,0,l,0,e*(1-l));a=m.getXX();k=m.getYX();p=m.getDX();q=m.getXY();j=m.getYY();o=m.getDY();n=Math.sqrt(a*a+k*k)*c;g=Math.sqrt(q*q+j*j)*c;d.x=f*a+e*k+p-n;d.y=f*q+e*j+o-g;d.width=n+n;d.height=g+g},updatePath:function(b,a){b.ellipse(a.cx,a.cy,a.rx,a.ry,a.axisRotation,0,Math.PI*2,false)}});Ext.define("Ext.draw.sprite.EllipticalArc",{extend:"Ext.draw.sprite.Ellipse",alias:"sprite.ellipticalArc",type:"ellipticalArc",inheritableStatics:{def:{processors:{startAngle:"number",endAngle:"number",anticlockwise:"bool"},aliases:{from:"startAngle",to:"endAngle",start:"startAngle",end:"endAngle"},defaults:{startAngle:0,endAngle:Math.PI*2,anticlockwise:false},dirtyTriggers:{startAngle:"path",endAngle:"path",anticlockwise:"path"}}},updatePath:function(b,a){b.ellipse(a.cx,a.cy,a.rx,a.ry,a.axisRotation,a.startAngle,a.endAngle,a.anticlockwise)}});Ext.define("Ext.draw.sprite.Rect",{extend:"Ext.draw.sprite.Path",alias:"sprite.rect",type:"rect",inheritableStatics:{def:{processors:{x:"number",y:"number",width:"number",height:"number",radius:"number"},aliases:{},dirtyTriggers:{x:"path",y:"path",width:"path",height:"path",radius:"path"},defaults:{x:0,y:0,width:1,height:1,radius:0}}},updatePlainBBox:function(b){var a=this.attr;b.x=a.x;b.y=a.y;b.width=a.width;b.height=a.height},updateTransformedBBox:function(a,b){this.attr.matrix.transformBBox(b,this.attr.radius,a)},updatePath:function(f,d){var c=d.x,g=d.y,e=d.width,b=d.height,a=Math.min(d.radius,Math.abs(d.height)*0.5,Math.abs(d.width)*0.5);if(a===0){f.rect(c,g,e,b)}else{f.moveTo(c+a,g);f.arcTo(c+e,g,c+e,g+b,a);f.arcTo(c+e,g+b,c,g+b,a);f.arcTo(c,g+b,c,g,a);f.arcTo(c,g,c+a,g,a)}}});Ext.define("Ext.draw.sprite.Image",{extend:"Ext.draw.sprite.Rect",alias:"sprite.image",type:"image",statics:{imageLoaders:{}},inheritableStatics:{def:{processors:{src:"string"},defaults:{src:"",width:null,height:null}}},render:function(c,o){var j=this,h=j.attr,n=h.matrix,a=h.src,l=h.x,k=h.y,b=h.width,m=h.height,g=Ext.draw.sprite.Image.imageLoaders[a],f,d,e;if(g&&g.done){n.toContext(o);d=g.image;o.drawImage(d,l,k,b||(d.naturalWidth||d.width)/c.devicePixelRatio,m||(d.naturalHeight||d.height)/c.devicePixelRatio)}else{if(!g){f=new Image();g=Ext.draw.sprite.Image.imageLoaders[a]={image:f,done:false,pendingSprites:[j],pendingSurfaces:[c]};f.width=b;f.height=m;f.onload=function(){if(!g.done){g.done=true;for(e=0;e<g.pendingSprites.length;e++){g.pendingSprites[e].setDirty(true)}for(e in g.pendingSurfaces){g.pendingSurfaces[e].renderFrame()}}};f.src=a}else{Ext.Array.include(g.pendingSprites,j);Ext.Array.include(g.pendingSurfaces,c)}}}});Ext.define("Ext.draw.sprite.Instancing",{extend:"Ext.draw.sprite.Sprite",alias:"sprite.instancing",type:"instancing",isInstancing:true,config:{template:null},instances:null,applyTemplate:function(a){if(!a.isSprite){if(!a.xclass&&!a.type){a.type="circle"}a=Ext.create(a.xclass||"sprite."+a.type,a)}a.setParent(this);return a},updateTemplate:function(a){a.setSurface(this.getSurface());a.attr.children=this.instances=[];this.position=0},updateSurface:function(a){var b=this.getTemplate();if(b){b.setSurface(a)}},createInstance:function(d,f,g,c){var e=this.getTemplate(),b=e.attr,a=Ext.Object.chain(b);e.topModifier.prepareAttributes(a);e.attr=a;e.setAttributes(d,g,c);a.data=f;a.template=e;this.instances.push(a);e.attr=b;this.position++;return a},getBBox:function(){return null},getBBoxFor:function(b,d){var c=this.getTemplate(),a=c.attr,e;c.attr=this.instances[b];e=c.getBBox(d);c.attr=a;return e},render:function(b,l,d,h){var g=this,j=g.getTemplate(),k=g.attr.matrix,c=j.attr,a=g.instances,e,f=g.position;k.toContext(l);j.preRender(b,l,d,h);j.useAttributes(l,h);for(e=0;e<f;e++){if(a[e].dirtyZIndex){break}}for(e=0;e<f;e++){if(a[e].hidden){continue}l.save();j.attr=a[e];j.useAttributes(l,h);j.render(b,l,d,h);l.restore()}j.attr=c},setAttributesFor:function(c,e,f){var d=this.getTemplate(),b=d.attr,a=this.instances[c];d.attr=a;if(f){e=Ext.apply({},e)}else{e=d.self.def.normalize(e)}d.topModifier.pushDown(a,e);d.updateDirtyFlags(a);d.attr=b},destroy:function(){this.callParent();this.instances.length=0;this.instances=null;if(this.getTemplate()){this.getTemplate().destroy()}}});Ext.define("Ext.draw.sprite.Line",{extend:"Ext.draw.sprite.Sprite",alias:"sprite.line",type:"line",inheritableStatics:{def:{processors:{fromX:"number",fromY:"number",toX:"number",toY:"number"},defaults:{fromX:0,fromY:0,toX:1,toY:1,strokeStyle:"black"}}},updatePlainBBox:function(b){var a=this.attr,f=Math.min(a.fromX,a.toX),d=Math.min(a.fromY,a.toY),e=Math.max(a.fromX,a.toX),c=Math.max(a.fromY,a.toY);b.x=f;b.y=d;b.width=e-f;b.height=c-d},render:function(b,c){var a=this.attr,d=this.attr.matrix;d.toContext(c);c.beginPath();c.moveTo(a.fromX,a.fromY);c.lineTo(a.toX,a.toY);c.stroke()}});Ext.define("Ext.draw.sprite.Plus",{extend:"Ext.draw.sprite.Path",alias:"sprite.plus",inheritableStatics:{def:{processors:{x:"number",y:"number",size:"number"},defaults:{x:0,y:0,size:4},dirtyTriggers:{x:"path",y:"path",size:"path"}}},updatePath:function(d,b){var c=b.size/1.3,a=b.x-b.lineWidth/2,e=b.y;d.fromSvgString("M".concat(a-c/2,",",e-c/2,"l",[0,-c,c,0,0,c,c,0,0,c,-c,0,0,c,-c,0,0,-c,-c,0,0,-c,"z"]))}});Ext.define("Ext.draw.sprite.Sector",{extend:"Ext.draw.sprite.Path",alias:"sprite.sector",type:"sector",inheritableStatics:{def:{processors:{centerX:"number",centerY:"number",startAngle:"number",endAngle:"number",startRho:"number",endRho:"number",margin:"number"},aliases:{rho:"endRho"},dirtyTriggers:{centerX:"path,bbox",centerY:"path,bbox",startAngle:"path,bbox",endAngle:"path,bbox",startRho:"path,bbox",endRho:"path,bbox",margin:"path,bbox"},defaults:{centerX:0,centerY:0,startAngle:0,endAngle:0,startRho:0,endRho:150,margin:0,path:"M 0,0"}}},updatePath:function(j,h){var g=Math.min(h.startAngle,h.endAngle),c=Math.max(h.startAngle,h.endAngle),b=(g+c)*0.5,d=h.margin,f=h.centerX,e=h.centerY,i=Math.min(h.startRho,h.endRho),a=Math.max(h.startRho,h.endRho);if(d){f+=d*Math.cos(b);e+=d*Math.sin(b)}j.moveTo(f+i*Math.cos(g),e+i*Math.sin(g));j.lineTo(f+a*Math.cos(g),e+a*Math.sin(g));j.arc(f,e,a,g,c,false);j.lineTo(f+i*Math.cos(c),e+i*Math.sin(c));j.arc(f,e,i,c,g,true)}});Ext.define("Ext.draw.sprite.Square",{extend:"Ext.draw.sprite.Rect",alias:"sprite.square",inheritableStatics:{def:{processors:{size:"number"},defaults:{size:4},dirtyTriggers:{size:"size"},updaters:{size:function(a){var c=a.size,b=a.lineWidth/2;this.setAttributes({x:a.x-c-b,y:a.y-c,height:2*c,width:2*c})}}}}});Ext.define("Ext.draw.TextMeasurer",{singleton:true,requires:["Ext.util.TextMetrics"],measureDiv:null,measureCache:{},precise:Ext.isIE8,measureDivTpl:{tag:"div",overflow:"hidden",position:"relative","float":"left",width:0,height:0,children:{tag:"div",display:"block",position:"absolute",x:-100000,y:-100000,padding:0,margin:0,"z-index":-100000,"white-space":"nowrap"}},actualMeasureText:function(g,b){var e=Ext.draw.TextMeasurer,f=e.measureDiv,a=100000,c;if(!f){var d=Ext.Element.create({style:{overflow:"hidden",position:"relative","float":"left",width:0,height:0}});e.measureDiv=f=Ext.Element.create({});f.setStyle({position:"absolute",x:a,y:a,"z-index":-a,"white-space":"nowrap",display:"block",padding:0,margin:0});Ext.getBody().appendChild(d);d.appendChild(f)}if(b){f.setStyle({font:b,lineHeight:"normal"})}f.setText("("+g+")");c=f.getSize();f.setText("()");c.width-=f.getSize().width;return c},measureTextSingleLine:function(h,d){if(this.precise){return this.preciseMeasureTextSingleLine(h,d)}h=h.toString();var a=this.measureCache,g=h.split(""),c=0,j=0,l,b,e,f,k;if(!a[d]){a[d]={}}a=a[d];if(a[h]){return a[h]}for(e=0,f=g.length;e<f;e++){b=g[e];if(!(l=a[b])){k=this.actualMeasureText(b,d);l=a[b]=k}c+=l.width;j=Math.max(j,l.height)}return a[h]={width:c,height:j}},preciseMeasureTextSingleLine:function(c,a){c=c.toString();var b=this.measureDiv||(this.measureDiv=Ext.getBody().createChild(this.measureDivTpl).down("div"));b.setStyle({font:a||""});return Ext.util.TextMetrics.measure(b,c)},measureText:function(e,b){var h=e.split("\n"),d=h.length,f=0,a=0,j,c,g;if(d===1){return this.measureTextSingleLine(e,b)}g=[];for(c=0;c<d;c++){j=this.measureTextSingleLine(h[c],b);g.push(j);f+=j.height;a=Math.max(a,j.width)}return{width:a,height:f,sizes:g}}});Ext.define("Ext.draw.sprite.Text",{extend:"Ext.draw.sprite.Sprite",requires:["Ext.draw.TextMeasurer"],alias:"sprite.text",type:"text",lineBreakRe:/\n/g,inheritableStatics:{shortHand1Re:/'(.*)'/g,shortHand2Re:/ /g,shortHand3Re:/\s*,\s*/g,shortHand4Re:/\$\$\$\$/g,def:{processors:{x:"number",y:"number",text:"string",fontSize:function(a){if(!isNaN(a)){return +a+"px"}else{if(a.match(Ext.dom.Element.unitRe)){return a}}},fontStyle:"enums(,italic,oblique)",fontVariant:"enums(,small-caps)",fontWeight:(function(a){return function(b){if(!b){return""}else{if(b==="normal"){return""}else{if(!isNaN(b)){b=+b;if(100<=b&&b<=900){return b}}else{if(b in a){return b}}}}}})({normal:true,bold:true,bolder:true,lighter:true}),fontFamily:"string",textAlign:(function(a){return function(b){return a[b]||"center"}})({start:"start",left:"start",center:"center",middle:"center",end:"end",right:"end"}),textBaseline:(function(a){return function(b){return a[b]||"alphabetic"}})({top:"top",hanging:"hanging",middle:"middle",center:"middle",alphabetic:"alphabetic",ideographic:"ideographic",bottom:"bottom"}),font:"string"},aliases:{"font-size":"fontSize","font-family":"fontFamily","font-weight":"fontWeight","font-variant":"fontVariant","text-anchor":"textAlign"},defaults:{fontStyle:"",fontVariant:"",fontWeight:"",fontSize:"10px",fontFamily:"sans-serif",font:"10px sans-serif",textBaseline:"alphabetic",textAlign:"start",strokeStyle:Ext.draw.Color.RGBA_NONE,fillStyle:"#000",x:0,y:0,text:""},dirtyTriggers:{fontStyle:"font,bbox",fontVariant:"font,bbox",fontWeight:"font,bbox",fontSize:"font,bbox",fontFamily:"font,bbox",font:"font-short-hand,bbox,canvas",textBaseline:"bbox",textAlign:"bbox",x:"bbox",y:"bbox",text:"bbox"},updaters:{"font-short-hand":(function(a){return function(c){var g=c.font,h,b,d,f,e;g=g.replace(Ext.draw.sprite.Text.shortHand1Re,function(i,j){return j.replace(Ext.draw.sprite.Text.shortHand2Re,"$$$$")});g=g.replace(Ext.draw.sprite.Text.shortHand3Re,",");h=g.split(" ");c={};for(d=0,f=h.length;d<f;d++){b=h[d];e=a[b];if(e){c[e]=b}else{if(b.match(Ext.dom.Element.unitRe)){c.fontSize=b}else{c.fontFamily=b.replace(Ext.draw.sprite.Text.shortHand4Re," ")}}}this.setAttributes(c,true)}})({italic:"fontStyle",oblique:"fontStyle",bold:"fontWeight",bolder:"fontWeight",lighter:"fontWeight","100":"fontWeight","200":"fontWeight","300":"fontWeight","400":"fontWeight","500":"fontWeight","600":"fontWeight","700":"fontWeight","800":"fontWeight","900":"fontWeight","small-caps":"fontVariant"}),font:function(b){var a="";if(b.fontWeight){a+=b.fontWeight+" "}if(b.fontStyle){a+=b.fontStyle+" "}if(b.fontVariant){a+=b.fontVariant+" "}if(b.fontSize){a+=b.fontSize+" "}if(b.fontFamily){a+=b.fontFamily}this.setAttributes({font:a},true)}}}},constructor:function(a){if(a&&a.font){a=Ext.clone(a);for(var b in a){if(b!=="font"&&b.indexOf("font")===0){delete a[b]}}}Ext.draw.sprite.Sprite.prototype.constructor.call(this,a)},getBBox:function(c){var d=this,b=d.attr.bbox.plain,a=d.getSurface();if(b.dirty){d.updatePlainBBox(b);b.dirty=false}if(a.getInherited().rtl&&a.getFlipRtlText()){d.updatePlainBBox(b,true)}return d.callParent([c])},rtlAlignments:{start:"end",center:"center",end:"start"},updatePlainBBox:function(f,v){var w=this,s=w.attr,k=s.x,j=s.y,m=[],p=s.font,n=s.text,o=s.textBaseline,g=s.textAlign,q=(v&&w.oldSize)?w.oldSize:(w.oldSize=Ext.draw.TextMeasurer.measureText(n,p)),t=w.getSurface(),l=t.getInherited().rtl,r=l&&t.getFlipRtlText(),d=t.getRect(),b=q.sizes,c=q.height,e=q.width,h=b?b.length:0,a,u=0;switch(o){case"hanging":case"top":break;case"ideographic":case"bottom":j-=c;break;case"alphabetic":j-=c*0.8;break;case"middle":j-=c*0.5;break}if(r){k=d[2]-d[0]-k;g=w.rtlAlignments[g]}switch(g){case"start":if(l){for(;u<h;u++){a=b[u].width;m.push(-(e-a))}}break;case"end":k-=e;if(l){break}for(;u<h;u++){a=b[u].width;m.push(e-a)}break;case"center":k-=e*0.5;for(;u<h;u++){a=b[u].width;m.push((l?-1:1)*(e-a)*0.5)}break}s.textAlignOffsets=m;f.x=k;f.y=j;f.width=e;f.height=c},setText:function(a){this.setAttributes({text:a},true)},setElementStyles:function(b,d){var e=b.stylesCache||(b.stylesCache={}),c=b.dom.style,a;for(a in d){if(e[a]!==d[a]){e[a]=c[a]=d[a]}}},render:function(a,m,f){var d=this,c=d.attr,l=Ext.draw.Matrix.fly(c.matrix.elements.slice(0)),k=d.getBBox(true),o=c.textAlignOffsets,h=Ext.draw.Color.RGBA_NONE,g,e,b,n,j;if(c.text.length===0){return}n=c.text.split("\n");j=k.height/n.length;g=c.bbox.plain.x;e=c.bbox.plain.y+j*0.78;l.toContext(m);if(a.getInherited().rtl){g+=c.bbox.plain.width}for(b=0;b<n.length;b++){if(m.fillStyle!==h){m.fillText(n[b],g+(o[b]||0),e+j*b)}if(m.strokeStyle!==h){m.strokeText(n[b],g+(o[b]||0),e+j*b)}}}});Ext.define("Ext.draw.sprite.Tick",{extend:"Ext.draw.sprite.Line",alias:"sprite.tick",inheritableStatics:{def:{processors:{x:"number",y:"number",size:"number"},defaults:{x:0,y:0,size:4},dirtyTriggers:{x:"tick",y:"tick",size:"tick"},updaters:{tick:function(b){var d=b.size*1.5,c=b.lineWidth/2,a=b.x,e=b.y;this.setAttributes({fromX:a-c,fromY:e-d,toX:a-c,toY:e+d})}}}}});Ext.define("Ext.draw.sprite.Triangle",{extend:"Ext.draw.sprite.Path",alias:"sprite.triangle",inheritableStatics:{def:{processors:{x:"number",y:"number",size:"number"},defaults:{x:0,y:0,size:4},dirtyTriggers:{x:"path",y:"path",size:"path"}}},updatePath:function(d,b){var c=b.size*2.2,a=b.x,e=b.y;d.fromSvgString("M".concat(a,",",e,"m0-",c*0.58,"l",c*0.5,",",c*0.87,"-",c,",0z"))}});Ext.define("Ext.draw.gradient.Linear",{extend:"Ext.draw.gradient.Gradient",type:"linear",config:{degrees:0},setAngle:function(a){this.setDegrees(a)},generateGradient:function(q,o){var c=Ext.draw.Draw.rad(this.getDegrees()),p=Math.cos(c),j=Math.sin(c),m=o.width,f=o.height,d=o.x+m*0.5,b=o.y+f*0.5,n=this.getStops(),g=n.length,k,a,e;if(!isNaN(d)&&!isNaN(b)&&f>0&&m>0){a=(Math.sqrt(f*f+m*m)*Math.abs(Math.cos(c-Math.atan(f/m))))/2;k=q.createLinearGradient(d+p*a,b+j*a,d-p*a,b-j*a);for(e=0;e<g;e++){k.addColorStop(n[e].offset,n[e].color)}return k}return"none"}});Ext.define("Ext.draw.gradient.Radial",{extend:"Ext.draw.gradient.Gradient",type:"radial",config:{start:{x:0,y:0,r:0},end:{x:0,y:0,r:1}},applyStart:function(a,b){if(!b){return a}var c={x:b.x,y:b.y,r:b.r};if("x" in a){c.x=a.x}else{if("centerX" in a){c.x=a.centerX}}if("y" in a){c.y=a.y}else{if("centerY" in a){c.y=a.centerY}}if("r" in a){c.r=a.r}else{if("radius" in a){c.r=a.radius}}return c},applyEnd:function(b,a){if(!a){return b}var c={x:a.x,y:a.y,r:a.r};if("x" in b){c.x=b.x}else{if("centerX" in b){c.x=b.centerX}}if("y" in b){c.y=b.y}else{if("centerY" in b){c.y=b.centerY}}if("r" in b){c.r=b.r}else{if("radius" in b){c.r=b.radius}}return c},generateGradient:function(n,m){var a=this.getStart(),b=this.getEnd(),k=m.width*0.5,d=m.height*0.5,j=m.x+k,f=m.y+d,g=n.createRadialGradient(j+a.x*k,f+a.y*d,a.r*Math.max(k,d),j+b.x*k,f+b.y*d,b.r*Math.max(k,d)),l=this.getStops(),e=l.length,c;for(c=0;c<e;c++){g.addColorStop(l[c].offset,l[c].color)}return g}});Ext.define("Ext.draw.Surface",{extend:"Ext.draw.SurfaceBase",xtype:"surface",requires:["Ext.draw.sprite.*","Ext.draw.gradient.*","Ext.draw.sprite.AttributeDefinition","Ext.draw.Matrix","Ext.draw.Draw"],uses:["Ext.draw.engine.Canvas"],devicePixelRatio:window.devicePixelRatio||1,statics:{stableSort:function(f){if(f.length<2){return}var e={},b,a=[],c,d,g;for(c=0,d=f.length;c<d;c++){g=f[c].attr.zIndex;if(!e[g]){e[g]=[f[c]]}else{e[g].push(f[c])}}b=Ext.Object.getKeys(e).sort(function(i,h){return i-h});for(c=0,d=b.length;c<d;c++){a.push.apply(a,e[b[c]])}for(c=0,d=f.length;c<d;c++){f[c]=a[c]}}},config:{cls:Ext.baseCSSPrefix+"surface",rect:null,background:null,items:[],dirty:false,flipRtlText:false},isSurface:true,dirtyPredecessor:0,constructor:function(a){var b=this;b.predecessors=[];b.successors=[];b.pendingRenderFrame=false;b.map={};b.callParent([a]);b.matrix=new Ext.draw.Matrix();b.inverseMatrix=b.matrix.inverse(b.inverseMatrix);b.resetTransform()},roundPixel:function(a){return Math.round(this.devicePixelRatio*a)/this.devicePixelRatio},waitFor:function(a){var b=this,c=b.predecessors;if(!Ext.Array.contains(c,a)){c.push(a);a.successors.push(b);if(a._dirty){b.dirtyPredecessor++}}},setDirty:function(d){if(this._dirty!==d){var c=this.successors,a,b,e=c.length;for(b=0;b<e;b++){a=c[b];if(d){a.dirtyPredecessor++;a.setDirty(true)}else{a.dirtyPredecessor--;if(a.dirtyPredecessor===0&&a.pendingRenderFrame){a.renderFrame()}}}this._dirty=d}},applyElement:function(b,a){if(a){a.set(b)}else{a=Ext.Element.create(b)}this.setDirty(true);return a},applyBackground:function(a,b){this.setDirty(true);if(Ext.isString(a)){a={fillStyle:a}}return Ext.factory(a,Ext.draw.sprite.Rect,b)},applyRect:function(a,b){if(b&&a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]){return}if(Ext.isArray(a)){return[a[0],a[1],a[2],a[3]]}else{if(Ext.isObject(a)){return[a.x||a.left,a.y||a.top,a.width||(a.right-a.left),a.height||(a.bottom-a.top)]}}},updateRect:function(i){var h=this,c=i[0],f=i[1],g=c+i[2],a=f+i[3],e=h.getBackground(),d=h.element;d.setLocalXY(Math.floor(c),Math.floor(f));d.setSize(Math.ceil(g-Math.floor(c)),Math.ceil(a-Math.floor(f)));if(e){e.setAttributes({x:0,y:0,width:Math.ceil(g-Math.floor(c)),height:Math.ceil(a-Math.floor(f))})}h.setDirty(true)},resetTransform:function(){this.matrix.set(1,0,0,1,0,0);this.inverseMatrix.set(1,0,0,1,0,0);this.setDirty(true)},get:function(a){return this.map[a]||this.items[a]},add:function(){var g=this,e=Array.prototype.slice.call(arguments),j=Ext.isArray(e[0]),a=[],h,d,f,b,c;f=Ext.Array.clean(j?e[0]:e);if(!f.length){return a}d=g.prepareItems(f);for(b=0,c=d.length;b<c;b++){h=d[b];g.map[h.getId()]=h;a.push(h);h.setParent(g);h.setSurface(g);g.onAdd(h)}f=g.getItems();if(f){f.push.apply(f,a)}g.dirtyZIndex=true;g.setDirty(true);if(!j&&a.length===1){return a[0]}else{return a}},onAdd:Ext.emptyFn,remove:function(a,b){if(a){delete this.map[a.getId()];if(b){a.destroy()}else{a.setParent(null);a.setSurface(null);Ext.Array.remove(this.getItems(),a)}this.dirtyZIndex=true;this.setDirty(true)}},removeAll:function(d){var a=this.getItems(),b=a.length,c;if(d){while(b>0){a[--b].destroy()}}else{while(b>0){b--;c=a[b];c.setParent(null);c.setSurface(null)}}a.length=0;this.map={};this.dirtyZIndex=true},applyItems:function(a){if(this.getItems()){this.removeAll(true)}return Ext.Array.from(this.add(a))},prepareItems:function(a){a=[].concat(a);var g=this,f,c,e,b,d=function(h){this.remove(h,false)};for(c=0,e=a.length;c<e;c++){f=a[c];if(!(f instanceof Ext.draw.sprite.Sprite)){f=a[c]=g.createItem(f)}f.on("beforedestroy",d,g)}return a},createItem:function(a){return Ext.create(a.xclass||"sprite."+a.type,a)},getBBox:function(f,b){var f=Ext.Array.from(f),c=Infinity,h=-Infinity,g=Infinity,a=-Infinity,j,k,d,e;for(d=0,e=f.length;d<e;d++){j=f[d];k=j.getBBox(b);if(c>k.x){c=k.x}if(h<k.x+k.width){h=k.x+k.width}if(g>k.y){g=k.y}if(a<k.y+k.height){a=k.y+k.height}}return{x:c,y:g,width:h-c,height:a-g}},emptyRect:[0,0,0,0],getEventXY:function(d){var g=this,f=g.getInherited().rtl,c=d.getXY(),a=g.el.up(),i=a.getXY(),h=g.getRect()||g.emptyRect,j=[],b;if(f){b=a.getWidth();j[0]=i[0]-c[0]-h[0]+b}else{j[0]=c[0]-i[0]-h[0]}j[1]=c[1]-i[1]-h[1];return j},clear:Ext.emptyFn,orderByZIndex:function(){var d=this,a=d.getItems(),e=false,b,c;if(d.getDirty()){for(b=0,c=a.length;b<c;b++){if(a[b].attr.dirtyZIndex){e=true;break}}if(e){Ext.draw.Surface.stableSort(a);this.setDirty(true)}for(b=0,c=a.length;b<c;b++){a[b].attr.dirtyZIndex=false}}},repaint:function(){var a=this;a.repaint=Ext.emptyFn;Ext.defer(function(){delete a.repaint;a.element.repaint()},1)},renderFrame:function(){if(!this.element){return}if(this.dirtyPredecessor>0){this.pendingRenderFrame=true;return}var g=this,f=this.getRect(),c=g.getBackground(),a=g.getItems(),e,b,d;if(!f){return}g.orderByZIndex();if(g.getDirty()){g.clear();g.clearTransform();if(c){g.renderSprite(c)}for(b=0,d=a.length;b<d;b++){e=a[b];if(false===g.renderSprite(e)){return}e.attr.textPositionCount=g.textPosition}g.setDirty(false)}},renderSprite:Ext.emptyFn,clearTransform:Ext.emptyFn,getDirty:function(){return this._dirty},destroy:function(){var a=this;a.removeAll();a.setBackground(null);a.predecessors=null;a.successors=null;a.callParent()}});Ext.define("Ext.draw.engine.SvgContext",{toSave:["strokeOpacity","strokeStyle","fillOpacity","fillStyle","globalAlpha","lineWidth","lineCap","lineJoin","lineDash","lineDashOffset","miterLimit","shadowOffsetX","shadowOffsetY","shadowBlur","shadowColor","globalCompositeOperation","position","fillGradient","strokeGradient"],strokeOpacity:1,strokeStyle:"none",fillOpacity:1,fillStyle:"none",lineDash:[],lineDashOffset:0,globalAlpha:1,lineWidth:1,lineCap:"butt",lineJoin:"miter",miterLimit:10,shadowOffsetX:0,shadowOffsetY:0,shadowBlur:0,shadowColor:"none",globalCompositeOperation:"src",urlStringRe:/^url\(#([\w\-]+)\)$/,constructor:function(a){this.surface=a;this.state=[];this.matrix=new Ext.draw.Matrix();this.path=null;this.clear()},clear:function(){this.group=this.surface.mainGroup;this.position=0;this.path=null},getElement:function(a){return this.surface.getSvgElement(this.group,a,this.position++)},removeElement:function(d){var d=Ext.fly(d),h,g,b,f,a,e,c;if(!d){return}if(d.dom.tagName==="g"){a=d.dom.gradients;for(c in a){a[c].destroy()}}else{h=d.getAttribute("fill");g=d.getAttribute("stroke");b=h&&h.match(this.urlStringRe);f=g&&g.match(this.urlStringRe);if(b&&b[1]){e=Ext.fly(b[1]);if(e){e.destroy()}}if(f&&f[1]){e=Ext.fly(f[1]);if(e){e.destroy()}}}d.destroy()},save:function(){var c=this.toSave,e={},d=this.getElement("g"),b,a;for(a=0;a<c.length;a++){b=c[a];if(b in this){e[b]=this[b]}}this.position=0;e.matrix=this.matrix.clone();this.state.push(e);this.group=d;return d},restore:function(){var d=this.toSave,e=this.state.pop(),c=this.group.dom.childNodes,b,a;while(c.length>this.position){this.removeElement(c[c.length-1])}for(a=0;a<d.length;a++){b=d[a];if(b in e){this[b]=e[b]}else{delete this[b]}}this.setTransform.apply(this,e.matrix.elements);this.group=this.group.getParent()},transform:function(f,b,e,g,d,c){if(this.path){var a=Ext.draw.Matrix.fly([f,b,e,g,d,c]).inverse();this.path.transform(a)}this.matrix.append(f,b,e,g,d,c)},setTransform:function(e,a,d,f,c,b){if(this.path){this.path.transform(this.matrix)}this.matrix.reset();this.transform(e,a,d,f,c,b)},scale:function(a,b){this.transform(a,0,0,b,0,0)},rotate:function(d){var c=Math.cos(d),a=Math.sin(d),b=-Math.sin(d),e=Math.cos(d);this.transform(c,a,b,e,0,0)},translate:function(a,b){this.transform(1,0,0,1,a,b)},setGradientBBox:function(a){this.bbox=a},beginPath:function(){this.path=new Ext.draw.Path()},moveTo:function(a,b){if(!this.path){this.beginPath()}this.path.moveTo(a,b);this.path.element=null},lineTo:function(a,b){if(!this.path){this.beginPath()}this.path.lineTo(a,b);this.path.element=null},rect:function(b,d,c,a){this.moveTo(b,d);this.lineTo(b+c,d);this.lineTo(b+c,d+a);this.lineTo(b,d+a);this.closePath()},strokeRect:function(b,d,c,a){this.beginPath();this.rect(b,d,c,a);this.stroke()},fillRect:function(b,d,c,a){this.beginPath();this.rect(b,d,c,a);this.fill()},closePath:function(){if(!this.path){this.beginPath()}this.path.closePath();this.path.element=null},arcSvg:function(d,a,f,g,c,b,e){if(!this.path){this.beginPath()}this.path.arcSvg(d,a,f,g,c,b,e);this.path.element=null},arc:function(b,f,a,d,c,e){if(!this.path){this.beginPath()}this.path.arc(b,f,a,d,c,e);this.path.element=null},ellipse:function(a,h,g,f,d,c,b,e){if(!this.path){this.beginPath()}this.path.ellipse(a,h,g,f,d,c,b,e);this.path.element=null},arcTo:function(b,e,a,d,g,f,c){if(!this.path){this.beginPath()}this.path.arcTo(b,e,a,d,g,f,c);this.path.element=null},bezierCurveTo:function(d,f,b,e,a,c){if(!this.path){this.beginPath()}this.path.bezierCurveTo(d,f,b,e,a,c);this.path.element=null},strokeText:function(d,a,e){d=String(d);if(this.strokeStyle){var b=this.getElement("text"),c=this.surface.getSvgElement(b,"tspan",0);this.surface.setElementAttributes(b,{x:a,y:e,transform:this.matrix.toSvg(),stroke:this.strokeStyle,fill:"none",opacity:this.globalAlpha,"stroke-opacity":this.strokeOpacity,style:"font: "+this.font,"stroke-dasharray":this.lineDash.join(","),"stroke-dashoffset":this.lineDashOffset});if(this.lineDash.length){this.surface.setElementAttributes(b,{"stroke-dasharray":this.lineDash.join(","),"stroke-dashoffset":this.lineDashOffset})}if(c.dom.firstChild){c.dom.removeChild(c.dom.firstChild)}this.surface.setElementAttributes(c,{"alignment-baseline":"alphabetic"});c.dom.appendChild(document.createTextNode(Ext.String.htmlDecode(d)))}},fillText:function(d,a,e){d=String(d);if(this.fillStyle){var b=this.getElement("text"),c=this.surface.getSvgElement(b,"tspan",0);this.surface.setElementAttributes(b,{x:a,y:e,transform:this.matrix.toSvg(),fill:this.fillStyle,opacity:this.globalAlpha,"fill-opacity":this.fillOpacity,style:"font: "+this.font});if(c.dom.firstChild){c.dom.removeChild(c.dom.firstChild)}this.surface.setElementAttributes(c,{"alignment-baseline":"alphabetic"});c.dom.appendChild(document.createTextNode(Ext.String.htmlDecode(d)))}},drawImage:function(c,k,i,l,e,p,n,a,g){var f=this,d=f.getElement("image"),j=k,h=i,b=typeof l==="undefined"?c.width:l,m=typeof e==="undefined"?c.height:e,o=null;if(typeof g!=="undefined"){o=k+" "+i+" "+l+" "+e;j=p;h=n;b=a;m=g}d.dom.setAttributeNS("http://www.w3.org/1999/xlink","href",c.src);f.surface.setElementAttributes(d,{viewBox:o,x:j,y:h,width:b,height:m,opacity:f.globalAlpha,transform:f.matrix.toSvg()})},fill:function(){if(!this.path){return}if(this.fillStyle){var c,a=this.fillGradient,d=this.bbox,b=this.path.element;if(!b){c=this.path.toString();b=this.path.element=this.getElement("path");this.surface.setElementAttributes(b,{d:c,transform:this.matrix.toSvg()})}this.surface.setElementAttributes(b,{fill:a&&d?a.generateGradient(this,d):this.fillStyle,"fill-opacity":this.fillOpacity*this.globalAlpha})}},stroke:function(){if(!this.path){return}if(this.strokeStyle){var c,b=this.strokeGradient,d=this.bbox,a=this.path.element;if(!a||!this.path.svgString){c=this.path.toString();if(!c){return}a=this.path.element=this.getElement("path");this.surface.setElementAttributes(a,{fill:"none",d:c,transform:this.matrix.toSvg()})}this.surface.setElementAttributes(a,{stroke:b&&d?b.generateGradient(this,d):this.strokeStyle,"stroke-linecap":this.lineCap,"stroke-linejoin":this.lineJoin,"stroke-width":this.lineWidth,"stroke-opacity":this.strokeOpacity*this.globalAlpha,"stroke-dasharray":this.lineDash.join(","),"stroke-dashoffset":this.lineDashOffset});if(this.lineDash.length){this.surface.setElementAttributes(a,{"stroke-dasharray":this.lineDash.join(","),"stroke-dashoffset":this.lineDashOffset})}}},fillStroke:function(a,e){var b=this,d=b.fillStyle,g=b.strokeStyle,c=b.fillOpacity,f=b.strokeOpacity;if(e===undefined){e=a.transformFillStroke}if(!e){a.inverseMatrix.toContext(b)}if(d&&c!==0){b.fill()}if(g&&f!==0){b.stroke()}},appendPath:function(a){this.path=a.clone()},createLinearGradient:function(d,g,b,e){var f=this,c=f.surface.getNextDef("linearGradient"),a=f.group.dom.gradients||(f.group.dom.gradients={}),h;f.surface.setElementAttributes(c,{x1:d,y1:g,x2:b,y2:e,gradientUnits:"userSpaceOnUse"});h=new Ext.draw.engine.SvgContext.Gradient(f,f.surface,c);a[c.dom.id]=h;return h},createRadialGradient:function(b,j,d,a,i,c){var g=this,e=g.surface.getNextDef("radialGradient"),f=g.group.dom.gradients||(g.group.dom.gradients={}),h;g.surface.setElementAttributes(e,{fx:b,fy:j,cx:a,cy:i,r:c,gradientUnits:"userSpaceOnUse"});h=new Ext.draw.engine.SvgContext.Gradient(g,g.surface,e,d/c);f[e.dom.id]=h;return h}});Ext.define("Ext.draw.engine.SvgContext.Gradient",{statics:{map:{}},constructor:function(c,a,d,b){var f=this.statics().map,e;e=f[d.dom.id];if(e){e.element=null}f[d.dom.id]=this;this.ctx=c;this.surface=a;this.element=d;this.position=0;this.compression=b||0},addColorStop:function(d,b){var c=this.surface.getSvgElement(this.element,"stop",this.position++),a=this.compression;this.surface.setElementAttributes(c,{offset:(((1-a)*d+a)*100).toFixed(2)+"%","stop-color":b,"stop-opacity":Ext.draw.Color.fly(b).a.toFixed(15)})},toString:function(){var a=this.element.dom.childNodes;while(a.length>this.position){Ext.fly(a[a.length-1]).destroy()}return"url(#"+this.element.getId()+")"},destroy:function(){var b=this.statics().map,a=this.element;if(a){delete b[a.dom.id];a.destroy()}this.callParent()}});Ext.define("Ext.draw.engine.Svg",{extend:"Ext.draw.Surface",requires:["Ext.draw.engine.SvgContext"],statics:{BBoxTextCache:{}},config:{highPrecision:false},getElementConfig:function(){return{reference:"element",style:{position:"absolute"},children:[{reference:"innerElement",style:{width:"100%",height:"100%",position:"relative"},children:[{tag:"svg",reference:"svgElement",namespace:"http://www.w3.org/2000/svg",width:"100%",height:"100%",version:1.1}]}]}},constructor:function(a){var b=this;b.callParent([a]);b.mainGroup=b.createSvgNode("g");b.defElement=b.createSvgNode("defs");b.svgElement.appendChild(b.mainGroup);b.svgElement.appendChild(b.defElement);b.ctx=new Ext.draw.engine.SvgContext(b)},createSvgNode:function(a){var b=document.createElementNS("http://www.w3.org/2000/svg",a);return Ext.get(b)},getSvgElement:function(d,b,a){var c;if(d.dom.childNodes.length>a){c=d.dom.childNodes[a];if(c.tagName===b){return Ext.get(c)}else{Ext.destroy(c)}}c=Ext.get(this.createSvgNode(b));if(a===0){d.insertFirst(c)}else{c.insertAfter(Ext.fly(d.dom.childNodes[a-1]))}c.cache={};return c},setElementAttributes:function(d,b){var f=d.dom,a=d.cache,c,e;for(c in b){e=b[c];if(a[c]!==e){a[c]=e;f.setAttribute(c,e)}}},getNextDef:function(a){return this.getSvgElement(this.defElement,a,this.defPosition++)},clearTransform:function(){var a=this;a.mainGroup.set({transform:a.matrix.toSvg()})},clear:function(){this.ctx.clear();this.defPosition=0},renderSprite:function(b){var d=this,c=d.getRect(),a=d.ctx;if(b.attr.hidden||b.attr.opacity===0){a.save();a.restore();return}b.element=a.save();b.preRender(this);b.useAttributes(a,c);if(false===b.render(this,a,[0,0,c[2],c[3]])){return false}b.setDirty(false);a.restore()},flatten:function(e,b){var c='<?xml version="1.0" standalone="yes"?>',f=Ext.getClassName(this),a,g,d;c+='<svg version="1.1" baseProfile="full" xmlns="http://www.w3.org/2000/svg" width="'+e.width+'" height="'+e.height+'">';for(d=0;d<b.length;d++){a=b[d];if(Ext.getClassName(a)!==f){continue}g=a.getRect();c+='<g transform="translate('+g[0]+","+g[1]+')">';c+=this.serializeNode(a.svgElement.dom);c+="</g>"}c+="</svg>";return{data:"data:image/svg+xml;utf8,"+encodeURIComponent(c),type:"svg"}},serializeNode:function(d){var b="",c,f,a,e;if(d.nodeType===document.TEXT_NODE){return d.nodeValue}b+="<"+d.nodeName;if(d.attributes.length){for(c=0,f=d.attributes.length;c<f;c++){a=d.attributes[c];b+=" "+a.name+'="'+a.value+'"'}}b+=">";if(d.childNodes&&d.childNodes.length){for(c=0,f=d.childNodes.length;c<f;c++){e=d.childNodes[c];b+=this.serializeNode(e)}}b+="</"+d.nodeName+">";return b},destroy:function(c,a,d){var b=this;b.ctx.destroy();b.mainGroup.destroy();delete b.mainGroup;delete b.ctx;b.callParent(arguments)},remove:function(a,b){if(a&&a.element){if(this.ctx){this.ctx.removeElement(a.element)}else{a.element.destroy()}a.element=null}this.callParent(arguments)}});Ext.draw||(Ext.draw={});Ext.draw.engine||(Ext.draw.engine={});Ext.draw.engine.excanvas=true;if(!document.createElement("canvas").getContext){(function(){var ab=Math;var n=ab.round;var l=ab.sin;var A=ab.cos;var H=ab.abs;var N=ab.sqrt;var d=10;var f=d/2;var z=+navigator.userAgent.match(/MSIE ([\d.]+)?/)[1];function y(){return this.context_||(this.context_=new D(this))}var t=Array.prototype.slice;function g(j,m,p){var i=t.call(arguments,2);return function(){return j.apply(m,i.concat(t.call(arguments)))}}function af(i){return String(i).replace(/&/g,"&amp;").replace(/"/g,"&quot;")}function Y(m,j,i){Ext.onReady(function(){if(!m.namespaces[j]){m.namespaces.add(j,i,"#default#VML")}})}function R(j){Y(j,"g_vml_","urn:schemas-microsoft-com:vml");Y(j,"g_o_","urn:schemas-microsoft-com:office:office");if(!j.styleSheets.ex_canvas_){var i=j.createStyleSheet();i.owningElement.id="ex_canvas_";i.cssText="canvas{display:inline-block;overflow:hidden;text-align:left;width:300px;height:150px}"}}R(document);var e={init:function(i){var j=i||document;j.createElement("canvas");j.attachEvent("onreadystatechange",g(this.init_,this,j))},init_:function(p){var m=p.getElementsByTagName("canvas");for(var j=0;j<m.length;j++){this.initElement(m[j])}},initElement:function(j){if(!j.getContext){j.getContext=y;R(j.ownerDocument);j.innerHTML="";j.attachEvent("onpropertychange",x);j.attachEvent("onresize",W);var i=j.attributes;if(i.width&&i.width.specified){j.style.width=i.width.nodeValue+"px"}else{j.width=j.clientWidth}if(i.height&&i.height.specified){j.style.height=i.height.nodeValue+"px"}else{j.height=j.clientHeight}}return j}};function x(j){var i=j.srcElement;switch(j.propertyName){case"width":i.getContext().clearRect();i.style.width=i.attributes.width.nodeValue+"px";i.firstChild.style.width=i.clientWidth+"px";break;case"height":i.getContext().clearRect();i.style.height=i.attributes.height.nodeValue+"px";i.firstChild.style.height=i.clientHeight+"px";break}}function W(j){var i=j.srcElement;if(i.firstChild){i.firstChild.style.width=i.clientWidth+"px";i.firstChild.style.height=i.clientHeight+"px"}}e.init();var k=[];for(var ae=0;ae<16;ae++){for(var ad=0;ad<16;ad++){k[ae*16+ad]=ae.toString(16)+ad.toString(16)}}function B(){return[[1,0,0],[0,1,0],[0,0,1]]}function J(p,m){var j=B();for(var i=0;i<3;i++){for(var ah=0;ah<3;ah++){var Z=0;for(var ag=0;ag<3;ag++){Z+=p[i][ag]*m[ag][ah]}j[i][ah]=Z}}return j}function v(j,i){i.fillStyle=j.fillStyle;i.lineCap=j.lineCap;i.lineJoin=j.lineJoin;i.lineWidth=j.lineWidth;i.miterLimit=j.miterLimit;i.shadowBlur=j.shadowBlur;i.shadowColor=j.shadowColor;i.shadowOffsetX=j.shadowOffsetX;i.shadowOffsetY=j.shadowOffsetY;i.strokeStyle=j.strokeStyle;i.globalAlpha=j.globalAlpha;i.font=j.font;i.textAlign=j.textAlign;i.textBaseline=j.textBaseline;i.arcScaleX_=j.arcScaleX_;i.arcScaleY_=j.arcScaleY_;i.lineScale_=j.lineScale_}var b={aliceblue:"#F0F8FF",antiquewhite:"#FAEBD7",aquamarine:"#7FFFD4",azure:"#F0FFFF",beige:"#F5F5DC",bisque:"#FFE4C4",black:"#000000",blanchedalmond:"#FFEBCD",blueviolet:"#8A2BE2",brown:"#A52A2A",burlywood:"#DEB887",cadetblue:"#5F9EA0",chartreuse:"#7FFF00",chocolate:"#D2691E",coral:"#FF7F50",cornflowerblue:"#6495ED",cornsilk:"#FFF8DC",crimson:"#DC143C",cyan:"#00FFFF",darkblue:"#00008B",darkcyan:"#008B8B",darkgoldenrod:"#B8860B",darkgray:"#A9A9A9",darkgreen:"#006400",darkgrey:"#A9A9A9",darkkhaki:"#BDB76B",darkmagenta:"#8B008B",darkolivegreen:"#556B2F",darkorange:"#FF8C00",darkorchid:"#9932CC",darkred:"#8B0000",darksalmon:"#E9967A",darkseagreen:"#8FBC8F",darkslateblue:"#483D8B",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",darkturquoise:"#00CED1",darkviolet:"#9400D3",deeppink:"#FF1493",deepskyblue:"#00BFFF",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1E90FF",firebrick:"#B22222",floralwhite:"#FFFAF0",forestgreen:"#228B22",gainsboro:"#DCDCDC",ghostwhite:"#F8F8FF",gold:"#FFD700",goldenrod:"#DAA520",grey:"#808080",greenyellow:"#ADFF2F",honeydew:"#F0FFF0",hotpink:"#FF69B4",indianred:"#CD5C5C",indigo:"#4B0082",ivory:"#FFFFF0",khaki:"#F0E68C",lavender:"#E6E6FA",lavenderblush:"#FFF0F5",lawngreen:"#7CFC00",lemonchiffon:"#FFFACD",lightblue:"#ADD8E6",lightcoral:"#F08080",lightcyan:"#E0FFFF",lightgoldenrodyellow:"#FAFAD2",lightgreen:"#90EE90",lightgrey:"#D3D3D3",lightpink:"#FFB6C1",lightsalmon:"#FFA07A",lightseagreen:"#20B2AA",lightskyblue:"#87CEFA",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#B0C4DE",lightyellow:"#FFFFE0",limegreen:"#32CD32",linen:"#FAF0E6",magenta:"#FF00FF",mediumaquamarine:"#66CDAA",mediumblue:"#0000CD",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",mediumseagreen:"#3CB371",mediumslateblue:"#7B68EE",mediumspringgreen:"#00FA9A",mediumturquoise:"#48D1CC",mediumvioletred:"#C71585",midnightblue:"#191970",mintcream:"#F5FFFA",mistyrose:"#FFE4E1",moccasin:"#FFE4B5",navajowhite:"#FFDEAD",oldlace:"#FDF5E6",olivedrab:"#6B8E23",orange:"#FFA500",orangered:"#FF4500",orchid:"#DA70D6",palegoldenrod:"#EEE8AA",palegreen:"#98FB98",paleturquoise:"#AFEEEE",palevioletred:"#DB7093",papayawhip:"#FFEFD5",peachpuff:"#FFDAB9",peru:"#CD853F",pink:"#FFC0CB",plum:"#DDA0DD",powderblue:"#B0E0E6",rosybrown:"#BC8F8F",royalblue:"#4169E1",saddlebrown:"#8B4513",salmon:"#FA8072",sandybrown:"#F4A460",seagreen:"#2E8B57",seashell:"#FFF5EE",sienna:"#A0522D",skyblue:"#87CEEB",slateblue:"#6A5ACD",slategray:"#708090",slategrey:"#708090",snow:"#FFFAFA",springgreen:"#00FF7F",steelblue:"#4682B4",tan:"#D2B48C",thistle:"#D8BFD8",tomato:"#FF6347",turquoise:"#40E0D0",violet:"#EE82EE",wheat:"#F5DEB3",whitesmoke:"#F5F5F5",yellowgreen:"#9ACD32"};function M(j){var p=j.indexOf("(",3);var i=j.indexOf(")",p+1);var m=j.substring(p+1,i).split(",");if(m.length!=4||j.charAt(3)!="a"){m[3]=1}return m}function c(i){return parseFloat(i)/100}function r(j,m,i){return Math.min(i,Math.max(m,j))}function I(ag){var i,ai,aj,ah,ak,Z;ah=parseFloat(ag[0])/360%360;if(ah<0){ah++}ak=r(c(ag[1]),0,1);Z=r(c(ag[2]),0,1);if(ak==0){i=ai=aj=Z}else{var j=Z<0.5?Z*(1+ak):Z+ak-Z*ak;var m=2*Z-j;i=a(m,j,ah+1/3);ai=a(m,j,ah);aj=a(m,j,ah-1/3)}return"#"+k[Math.floor(i*255)]+k[Math.floor(ai*255)]+k[Math.floor(aj*255)]}function a(j,i,m){if(m<0){m++}if(m>1){m--}if(6*m<1){return j+(i-j)*6*m}else{if(2*m<1){return i}else{if(3*m<2){return j+(i-j)*(2/3-m)*6}else{return j}}}}var C={};function F(j){if(j in C){return C[j]}var ag,Z=1;j=String(j);if(j.charAt(0)=="#"){ag=j}else{if(/^rgb/.test(j)){var p=M(j);var ag="#",ah;for(var m=0;m<3;m++){if(p[m].indexOf("%")!=-1){ah=Math.floor(c(p[m])*255)}else{ah=+p[m]}ag+=k[r(ah,0,255)]}Z=+p[3]}else{if(/^hsl/.test(j)){var p=M(j);ag=I(p);Z=p[3]}else{ag=b[j]||j}}}return C[j]={color:ag,alpha:Z}}var o={style:"normal",variant:"normal",weight:"normal",size:10,family:"sans-serif"};var L={};function E(i){if(L[i]){return L[i]}var p=document.createElement("div");var m=p.style;try{m.font=i}catch(j){}return L[i]={style:m.fontStyle||o.style,variant:m.fontVariant||o.variant,weight:m.fontWeight||o.weight,size:m.fontSize||o.size,family:m.fontFamily||o.family}}function u(m,j){var i={};for(var ah in m){i[ah]=m[ah]}var ag=parseFloat(j.currentStyle.fontSize),Z=parseFloat(m.size);if(typeof m.size=="number"){i.size=m.size}else{if(m.size.indexOf("px")!=-1){i.size=Z}else{if(m.size.indexOf("em")!=-1){i.size=ag*Z}else{if(m.size.indexOf("%")!=-1){i.size=(ag/100)*Z}else{if(m.size.indexOf("pt")!=-1){i.size=Z/0.75}else{i.size=ag}}}}}i.size*=0.981;return i}function ac(i){return i.style+" "+i.variant+" "+i.weight+" "+i.size+"px "+i.family}var s={butt:"flat",round:"round"};function S(i){return s[i]||"square"}function D(i){this.m_=B();this.mStack_=[];this.aStack_=[];this.currentPath_=[];this.strokeStyle="#000";this.fillStyle="#000";this.lineWidth=1;this.lineJoin="miter";this.lineCap="butt";this.miterLimit=d*1;this.globalAlpha=1;this.font="10px sans-serif";this.textAlign="left";this.textBaseline="alphabetic";this.canvas=i;var m="width:"+i.clientWidth+"px;height:"+i.clientHeight+"px;overflow:hidden;position:absolute";var j=i.ownerDocument.createElement("div");j.style.cssText=m;i.appendChild(j);var p=j.cloneNode(false);p.style.backgroundColor="red";p.style.filter="alpha(opacity=0)";i.appendChild(p);this.element_=j;this.arcScaleX_=1;this.arcScaleY_=1;this.lineScale_=1}var q=D.prototype;q.clearRect=function(){if(this.textMeasureEl_){this.textMeasureEl_.removeNode(true);this.textMeasureEl_=null}this.element_.innerHTML=""};q.beginPath=function(){this.currentPath_=[]};q.moveTo=function(j,i){var m=V(this,j,i);this.currentPath_.push({type:"moveTo",x:m.x,y:m.y});this.currentX_=m.x;this.currentY_=m.y};q.lineTo=function(j,i){var m=V(this,j,i);this.currentPath_.push({type:"lineTo",x:m.x,y:m.y});this.currentX_=m.x;this.currentY_=m.y};q.bezierCurveTo=function(m,j,ak,aj,ai,ag){var i=V(this,ai,ag);var ah=V(this,m,j);var Z=V(this,ak,aj);K(this,ah,Z,i)};function K(i,Z,m,j){i.currentPath_.push({type:"bezierCurveTo",cp1x:Z.x,cp1y:Z.y,cp2x:m.x,cp2y:m.y,x:j.x,y:j.y});i.currentX_=j.x;i.currentY_=j.y}q.quadraticCurveTo=function(ai,m,j,i){var ah=V(this,ai,m);var ag=V(this,j,i);var aj={x:this.currentX_+2/3*(ah.x-this.currentX_),y:this.currentY_+2/3*(ah.y-this.currentY_)};var Z={x:aj.x+(ag.x-this.currentX_)/3,y:aj.y+(ag.y-this.currentY_)/3};K(this,aj,Z,ag)};q.arc=function(al,aj,ak,ag,j,m){ak*=d;var ap=m?"at":"wa";var am=al+A(ag)*ak-f;var ao=aj+l(ag)*ak-f;var i=al+A(j)*ak-f;var an=aj+l(j)*ak-f;if(am==i&&!m){am+=0.125}var Z=V(this,al,aj);var ai=V(this,am,ao);var ah=V(this,i,an);this.currentPath_.push({type:ap,x:Z.x,y:Z.y,radius:ak,xStart:ai.x,yStart:ai.y,xEnd:ah.x,yEnd:ah.y})};q.rect=function(m,j,i,p){this.moveTo(m,j);this.lineTo(m+i,j);this.lineTo(m+i,j+p);this.lineTo(m,j+p);this.closePath()};q.strokeRect=function(m,j,i,p){var Z=this.currentPath_;this.beginPath();this.moveTo(m,j);this.lineTo(m+i,j);this.lineTo(m+i,j+p);this.lineTo(m,j+p);this.closePath();this.stroke();this.currentPath_=Z};q.fillRect=function(m,j,i,p){var Z=this.currentPath_;this.beginPath();this.moveTo(m,j);this.lineTo(m+i,j);this.lineTo(m+i,j+p);this.lineTo(m,j+p);this.closePath();this.fill();this.currentPath_=Z};q.createLinearGradient=function(j,p,i,m){var Z=new U("gradient");Z.x0_=j;Z.y0_=p;Z.x1_=i;Z.y1_=m;return Z};q.createRadialGradient=function(p,ag,m,j,Z,i){var ah=new U("gradientradial");ah.x0_=p;ah.y0_=ag;ah.r0_=m;ah.x1_=j;ah.y1_=Z;ah.r1_=i;return ah};q.drawImage=function(an,j){var ah,Z,aj,ar,al,ak,ao,av;var ai=an.runtimeStyle.width;var am=an.runtimeStyle.height;an.runtimeStyle.width="auto";an.runtimeStyle.height="auto";var ag=an.width;var aq=an.height;an.runtimeStyle.width=ai;an.runtimeStyle.height=am;if(arguments.length==3){ah=arguments[1];Z=arguments[2];al=ak=0;ao=aj=ag;av=ar=aq}else{if(arguments.length==5){ah=arguments[1];Z=arguments[2];aj=arguments[3];ar=arguments[4];al=ak=0;ao=ag;av=aq}else{if(arguments.length==9){al=arguments[1];ak=arguments[2];ao=arguments[3];av=arguments[4];ah=arguments[5];Z=arguments[6];aj=arguments[7];ar=arguments[8]}else{throw Error("Invalid number of arguments")}}}var au=V(this,ah,Z);var at=[];var i=10;var p=10;var ap=this.m_;at.push(" <g_vml_:group",' coordsize="',d*i,",",d*p,'"',' coordorigin="0,0"',' style="width:',n(i*ap[0][0]),"px;height:",n(p*ap[1][1]),"px;position:absolute;","top:",n(au.y/d),"px;left:",n(au.x/d),"px; rotation:",n(Math.atan(ap[0][1]/ap[1][1])*180/Math.PI),";");at.push('" >','<g_vml_:image src="',an.src,'"',' style="width:',d*aj,"px;"," height:",d*ar,'px"',' cropleft="',al/ag,'"',' croptop="',ak/aq,'"',' cropright="',(ag-al-ao)/ag,'"',' cropbottom="',(aq-ak-av)/aq,'"'," />","</g_vml_:group>");this.element_.insertAdjacentHTML("BeforeEnd",at.join(""))};q.stroke=function(ak){var ai=[];var m=10;var al=10;ai.push("<g_vml_:shape",' filled="',!!ak,'"',' style="position:absolute;width:',m,"px;height:",al,'px;left:0px;top:0px;"',' coordorigin="0,0"',' coordsize="',d*m,",",d*al,'"',' stroked="',!ak,'"',' path="');var Z={x:null,y:null};var aj={x:null,y:null};for(var ag=0;ag<this.currentPath_.length;ag++){var j=this.currentPath_[ag];var ah;switch(j.type){case"moveTo":ah=j;ai.push(" m ",n(j.x),",",n(j.y));break;case"lineTo":ai.push(" l ",n(j.x),",",n(j.y));break;case"close":ai.push(" x ");j=null;break;case"bezierCurveTo":ai.push(" c ",n(j.cp1x),",",n(j.cp1y),",",n(j.cp2x),",",n(j.cp2y),",",n(j.x),",",n(j.y));break;case"at":case"wa":ai.push(" ",j.type," ",n(j.x-this.arcScaleX_*j.radius),",",n(j.y-this.arcScaleY_*j.radius)," ",n(j.x+this.arcScaleX_*j.radius),",",n(j.y+this.arcScaleY_*j.radius)," ",n(j.xStart),",",n(j.yStart)," ",n(j.xEnd),",",n(j.yEnd));break}if(j){if(Z.x==null||j.x<Z.x){Z.x=j.x}if(aj.x==null||j.x>aj.x){aj.x=j.x}if(Z.y==null||j.y<Z.y){Z.y=j.y}if(aj.y==null||j.y>aj.y){aj.y=j.y}}}ai.push(' ">');if(!ak){w(this,ai)}else{G(this,ai,Z,aj)}ai.push("</g_vml_:shape>");this.element_.insertAdjacentHTML("beforeEnd",ai.join(""))};function w(m,ag){var j=F(m.strokeStyle);var p=j.color;var Z=j.alpha*m.globalAlpha;var i=m.lineScale_*m.lineWidth;if(i<1){Z*=i}ag.push("<g_vml_:stroke",' opacity="',Z,'"',' joinstyle="',m.lineJoin,'"',' miterlimit="',m.miterLimit,'"',' endcap="',S(m.lineCap),'"',' weight="',i,'px"',' color="',p,'" />')}function G(aq,ai,aK,ar){var aj=aq.fillStyle;var aB=aq.arcScaleX_;var aA=aq.arcScaleY_;var j=ar.x-aK.x;var p=ar.y-aK.y;if(aj instanceof U){var an=0;var aF={x:0,y:0};var ax=0;var am=1;if(aj.type_=="gradient"){var al=aj.x0_/aB;var m=aj.y0_/aA;var ak=aj.x1_/aB;var aM=aj.y1_/aA;var aJ=V(aq,al,m);var aI=V(aq,ak,aM);var ag=aI.x-aJ.x;var Z=aI.y-aJ.y;an=Math.atan2(ag,Z)*180/Math.PI;if(an<0){an+=360}if(an<0.000001){an=0}}else{var aJ=V(aq,aj.x0_,aj.y0_);aF={x:(aJ.x-aK.x)/j,y:(aJ.y-aK.y)/p};j/=aB*d;p/=aA*d;var aD=ab.max(j,p);ax=2*aj.r0_/aD;am=2*aj.r1_/aD-ax}var av=aj.colors_;av.sort(function(aN,i){return aN.offset-i.offset});var ap=av.length;var au=av[0].color;var at=av[ap-1].color;var az=av[0].alpha*aq.globalAlpha;var ay=av[ap-1].alpha*aq.globalAlpha;var aE=[];for(var aH=0;aH<ap;aH++){var ao=av[aH];aE.push(ao.offset*am+ax+" "+ao.color)}ai.push('<g_vml_:fill type="',aj.type_,'"',' method="none" focus="100%"',' color="',au,'"',' color2="',at,'"',' colors="',aE.join(","),'"',' opacity="',ay,'"',' g_o_:opacity2="',az,'"',' angle="',an,'"',' focusposition="',aF.x,",",aF.y,'" />')}else{if(aj instanceof T){if(j&&p){var ah=-aK.x;var aC=-aK.y;ai.push("<g_vml_:fill",' position="',ah/j*aB*aB,",",aC/p*aA*aA,'"',' type="tile"',' src="',aj.src_,'" />')}}else{var aL=F(aq.fillStyle);var aw=aL.color;var aG=aL.alpha*aq.globalAlpha;ai.push('<g_vml_:fill color="',aw,'" opacity="',aG,'" />')}}}q.fill=function(){this.$stroke(true)};q.closePath=function(){this.currentPath_.push({type:"close"})};function V(j,Z,p){var i=j.m_;return{x:d*(Z*i[0][0]+p*i[1][0]+i[2][0])-f,y:d*(Z*i[0][1]+p*i[1][1]+i[2][1])-f}}q.save=function(){var i={};v(this,i);this.aStack_.push(i);this.mStack_.push(this.m_);this.m_=J(B(),this.m_)};q.restore=function(){if(this.aStack_.length){v(this.aStack_.pop(),this);this.m_=this.mStack_.pop()}};function h(i){return isFinite(i[0][0])&&isFinite(i[0][1])&&isFinite(i[1][0])&&isFinite(i[1][1])&&isFinite(i[2][0])&&isFinite(i[2][1])}function aa(j,i,p){if(!h(i)){return}j.m_=i;if(p){var Z=i[0][0]*i[1][1]-i[0][1]*i[1][0];j.lineScale_=N(H(Z))}}q.translate=function(m,j){var i=[[1,0,0],[0,1,0],[m,j,1]];aa(this,J(i,this.m_),false)};q.rotate=function(j){var p=A(j);var m=l(j);var i=[[p,m,0],[-m,p,0],[0,0,1]];aa(this,J(i,this.m_),false)};q.scale=function(m,j){this.arcScaleX_*=m;this.arcScaleY_*=j;var i=[[m,0,0],[0,j,0],[0,0,1]];aa(this,J(i,this.m_),true)};q.transform=function(Z,p,ah,ag,j,i){var m=[[Z,p,0],[ah,ag,0],[j,i,1]];aa(this,J(m,this.m_),true)};q.setTransform=function(ag,Z,ai,ah,p,j){var i=[[ag,Z,0],[ai,ah,0],[p,j,1]];aa(this,i,true)};q.drawText_=function(am,ak,aj,ap,ai){var ao=this.m_,at=1000,j=0,ar=at,ah={x:0,y:0},ag=[];var i=u(E(this.font),this.element_);var p=ac(i);var au=this.element_.currentStyle;var Z=this.textAlign.toLowerCase();switch(Z){case"left":case"center":case"right":break;case"end":Z=au.direction=="ltr"?"right":"left";break;case"start":Z=au.direction=="rtl"?"right":"left";break;default:Z="left"}switch(this.textBaseline){case"hanging":case"top":ah.y=i.size/1.75;break;case"middle":break;default:case null:case"alphabetic":case"ideographic":case"bottom":ah.y=-i.size/3;break}switch(Z){case"right":j=at;ar=0.05;break;case"center":j=ar=at/2;break}var aq=V(this,ak+ah.x,aj+ah.y);ag.push('<g_vml_:line from="',-j,' 0" to="',ar,' 0.05" ',' coordsize="100 100" coordorigin="0 0"',' filled="',!ai,'" stroked="',!!ai,'" style="position:absolute;width:1px;height:1px;left:0px;top:0px;">');if(ai){w(this,ag)}else{G(this,ag,{x:-j,y:0},{x:ar,y:i.size})}var an=ao[0][0].toFixed(3)+","+ao[1][0].toFixed(3)+","+ao[0][1].toFixed(3)+","+ao[1][1].toFixed(3)+",0,0";var al=n(aq.x/d)+","+n(aq.y/d);ag.push('<g_vml_:skew on="t" matrix="',an,'" ',' offset="',al,'" origin="',j,' 0" />','<g_vml_:path textpathok="true" />','<g_vml_:textpath on="true" string="',af(am),'" style="v-text-align:',Z,";font:",af(p),'" /></g_vml_:line>');this.element_.insertAdjacentHTML("beforeEnd",ag.join(""))};q.fillText=function(m,i,p,j){this.drawText_(m,i,p,j,false)};q.strokeText=function(m,i,p,j){this.drawText_(m,i,p,j,true)};q.measureText=function(m){if(!this.textMeasureEl_){var i='<span style="position:absolute;top:-20000px;left:0;padding:0;margin:0;border:none;white-space:pre;"></span>';this.element_.insertAdjacentHTML("beforeEnd",i);this.textMeasureEl_=this.element_.lastChild}var j=this.element_.ownerDocument;this.textMeasureEl_.innerHTML="";this.textMeasureEl_.style.font=this.font;this.textMeasureEl_.appendChild(j.createTextNode(m));return{width:this.textMeasureEl_.offsetWidth}};q.clip=function(){};q.arcTo=function(){};q.createPattern=function(j,i){return new T(j,i)};function U(i){this.type_=i;this.x0_=0;this.y0_=0;this.r0_=0;this.x1_=0;this.y1_=0;this.r1_=0;this.colors_=[]}U.prototype.addColorStop=function(j,i){i=F(i);this.colors_.push({offset:j,color:i.color,alpha:i.alpha})};function T(j,i){Q(j);switch(i){case"repeat":case null:case"":this.repetition_="repeat";break;case"repeat-x":case"repeat-y":case"no-repeat":this.repetition_=i;break;default:O("SYNTAX_ERR")}this.src_=j.src;this.width_=j.width;this.height_=j.height}function O(i){throw new P(i)}function Q(i){if(!i||i.nodeType!=1||i.tagName!="IMG"){O("TYPE_MISMATCH_ERR")}if(i.readyState!="complete"){O("INVALID_STATE_ERR")}}function P(i){this.code=this[i];this.message=i+": DOM Exception "+this.code}var X=P.prototype=new Error;X.INDEX_SIZE_ERR=1;X.DOMSTRING_SIZE_ERR=2;X.HIERARCHY_REQUEST_ERR=3;X.WRONG_DOCUMENT_ERR=4;X.INVALID_CHARACTER_ERR=5;X.NO_DATA_ALLOWED_ERR=6;X.NO_MODIFICATION_ALLOWED_ERR=7;X.NOT_FOUND_ERR=8;X.NOT_SUPPORTED_ERR=9;X.INUSE_ATTRIBUTE_ERR=10;X.INVALID_STATE_ERR=11;X.SYNTAX_ERR=12;X.INVALID_MODIFICATION_ERR=13;X.NAMESPACE_ERR=14;X.INVALID_ACCESS_ERR=15;X.VALIDATION_ERR=16;X.TYPE_MISMATCH_ERR=17;G_vmlCanvasManager=e;CanvasRenderingContext2D=D;CanvasGradient=U;CanvasPattern=T;DOMException=P})()}Ext.define("Ext.draw.engine.Canvas",{extend:"Ext.draw.Surface",config:{highPrecision:false},requires:["Ext.draw.engine.excanvas","Ext.draw.Animator"],statics:{contextOverrides:{setGradientBBox:function(a){this.bbox=a},fill:function(){var c=this.fillStyle,a=this.fillGradient,b=this.fillOpacity,d=this.globalAlpha,e=this.bbox;if(c!==Ext.draw.Color.RGBA_NONE&&b!==0){if(a&&e){this.fillStyle=a.generateGradient(this,e)}if(b!==1){this.globalAlpha=d*b}this.$fill();if(b!==1){this.globalAlpha=d}if(a&&e){this.fillStyle=c}}},stroke:function(){var e=this.strokeStyle,c=this.strokeGradient,a=this.strokeOpacity,b=this.globalAlpha,d=this.bbox;if(e!==Ext.draw.Color.RGBA_NONE&&a!==0){if(c&&d){this.strokeStyle=c.generateGradient(this,d)}if(a!==1){this.globalAlpha=b*a}this.$stroke();if(a!==1){this.globalAlpha=b}if(c&&d){this.strokeStyle=e}}},fillStroke:function(d,e){var j=this,i=this.fillStyle,h=this.fillOpacity,f=this.strokeStyle,c=this.strokeOpacity,b=j.shadowColor,a=j.shadowBlur,g=Ext.draw.Color.RGBA_NONE;if(e===undefined){e=d.transformFillStroke}if(!e){d.inverseMatrix.toContext(j)}if(i!==g&&h!==0){j.fill();j.shadowColor=g;j.shadowBlur=0}if(f!==g&&c!==0){j.stroke()}j.shadowColor=b;j.shadowBlur=a},ellipse:function(g,e,c,a,j,b,f,d){var i=Math.cos(j),h=Math.sin(j);this.transform(i*c,h*c,-h*a,i*a,g,e);this.arc(0,0,1,b,f,d);this.transform(i/c,-h/a,h/c,i/a,-(i*g+h*e)/c,(h*g-i*e)/a)},appendPath:function(g){var e=this,c=0,a=0,b=g.types,f=g.coords,d=g.types.length;e.beginPath();for(;c<d;c++){switch(b[c]){case"M":e.moveTo(f[a],f[a+1]);a+=2;break;case"L":e.lineTo(f[a],f[a+1]);a+=2;break;case"C":e.bezierCurveTo(f[a],f[a+1],f[a+2],f[a+3],f[a+4],f[a+5]);a+=6;break;case"Z":e.closePath();break}}},save:function(){var c=this.toSave,d=c.length,e=d&&{},b=0,a;for(;b<d;b++){a=c[b];if(a in this){e[a]=this[a]}}this.state.push(e);this.$save()},restore:function(){var b=this.state.pop(),a;if(b){for(a in b){this[a]=b[a]}}this.$restore()}}},splitThreshold:3000,toSave:["fillGradient","strokeGradient"],getElementConfig:function(){return{reference:"element",style:{position:"absolute"},children:[{reference:"innerElement",style:{width:"100%",height:"100%",position:"relative"}}]}},createCanvas:function(){var c=Ext.Element.create({tag:"canvas",cls:Ext.baseCSSPrefix+"surface-canvas"});window.G_vmlCanvasManager&&G_vmlCanvasManager.initElement(c.dom);var e=Ext.draw.engine.Canvas.contextOverrides,a=c.dom.getContext("2d"),d=a.webkitBackingStorePixelRatio||a.mozBackingStorePixelRatio||a.msBackingStorePixelRatio||a.oBackingStorePixelRatio||a.backingStorePixelRatio||1,b;this.devicePixelRatio/=(Ext.os.is.WindowsPhone)?window.innerWidth/window.screen.width:d;if(a.ellipse){delete e.ellipse}a.state=[];a.toSave=this.toSave;for(b in e){a["$"+b]=a[b]}Ext.apply(a,e);if(this.getHighPrecision()){this.enablePrecisionCompensation(a)}else{this.disablePrecisionCompensation(a)}this.innerElement.appendChild(c);this.canvases.push(c);this.contexts.push(a)},initElement:function(){this.callParent();this.canvases=[];this.contexts=[];this.activeCanvases=0},afterCachedConfig:function(){this.callParent();this.createCanvas()},updateHighPrecision:function(a){var e=this.contexts,d=e.length,c,b;for(c=0;c<d;c++){b=e[c];if(a){this.enablePrecisionCompensation(b)}else{this.disablePrecisionCompensation(b)}}},precisionNames:["rect","fillRect","strokeRect","clearRect","moveTo","lineTo","arc","arcTo","save","restore","updatePrecisionCompensate","setTransform","transform","scale","translate","rotate","quadraticCurveTo","bezierCurveTo","createLinearGradient","createRadialGradient","fillText","strokeText","drawImage"],disablePrecisionCompensation:function(b){var a=Ext.draw.engine.Canvas.contextOverrides,f=this.precisionNames,e=f.length,d,c;for(d=0;d<e;d++){c=f[d];if(!(c in a)){delete b[c]}}this.setDirty(true)},enablePrecisionCompensation:function(j){var c=this,a=1,g=1,l=0,k=0,i=new Ext.draw.Matrix(),b=[],e={},d=Ext.draw.engine.Canvas.contextOverrides,h=j.constructor.prototype;var f={toSave:c.toSave,rect:function(m,p,n,o){return h.rect.call(this,m*a+l,p*g+k,n*a,o*g)},fillRect:function(m,p,n,o){this.updatePrecisionCompensateRect();h.fillRect.call(this,m*a+l,p*g+k,n*a,o*g);this.updatePrecisionCompensate()},strokeRect:function(m,p,n,o){this.updatePrecisionCompensateRect();h.strokeRect.call(this,m*a+l,p*g+k,n*a,o*g);this.updatePrecisionCompensate()},clearRect:function(m,p,n,o){return h.clearRect.call(this,m*a+l,p*g+k,n*a,o*g)},moveTo:function(m,n){return h.moveTo.call(this,m*a+l,n*g+k)},lineTo:function(m,n){return h.lineTo.call(this,m*a+l,n*g+k)},arc:function(n,r,m,p,o,q){this.updatePrecisionCompensateRect();h.arc.call(this,n*a+l,r*a+k,m*a,p,o,q);this.updatePrecisionCompensate()},arcTo:function(o,q,n,p,m){this.updatePrecisionCompensateRect();h.arcTo.call(this,o*a+l,q*g+k,n*a+l,p*g+k,m*a);this.updatePrecisionCompensate()},save:function(){b.push(i);i=i.clone();d.save.call(this);h.save.call(this)},restore:function(){i=b.pop();d.restore.call(this);h.restore.call(this);this.updatePrecisionCompensate()},updatePrecisionCompensate:function(){i.precisionCompensate(c.devicePixelRatio,e);a=e.xx;g=e.yy;l=e.dx;k=e.dy;h.setTransform.call(this,c.devicePixelRatio,e.b,e.c,e.d,0,0)},updatePrecisionCompensateRect:function(){i.precisionCompensateRect(c.devicePixelRatio,e);a=e.xx;g=e.yy;l=e.dx;k=e.dy;h.setTransform.call(this,c.devicePixelRatio,e.b,e.c,e.d,0,0)},setTransform:function(q,o,n,m,r,p){i.set(q,o,n,m,r,p);this.updatePrecisionCompensate()},transform:function(q,o,n,m,r,p){i.append(q,o,n,m,r,p);this.updatePrecisionCompensate()},scale:function(n,m){this.transform(n,0,0,m,0,0)},translate:function(n,m){this.transform(1,0,0,1,n,m)},rotate:function(o){var n=Math.cos(o),m=Math.sin(o);this.transform(n,m,-m,n,0,0)},quadraticCurveTo:function(n,p,m,o){h.quadraticCurveTo.call(this,n*a+l,p*g+k,m*a+l,o*g+k)},bezierCurveTo:function(r,p,o,n,m,q){h.bezierCurveTo.call(this,r*a+l,p*g+k,o*a+l,n*g+k,m*a+l,q*g+k)},createLinearGradient:function(n,p,m,o){this.updatePrecisionCompensateRect();var q=h.createLinearGradient.call(this,n*a+l,p*g+k,m*a+l,o*g+k);this.updatePrecisionCompensate();return q},createRadialGradient:function(p,r,o,n,q,m){this.updatePrecisionCompensateRect();var s=h.createLinearGradient.call(this,p*a+l,r*a+k,o*a,n*a+l,q*a+k,m*a);this.updatePrecisionCompensate();return s},fillText:function(o,m,p,n){h.setTransform.apply(this,i.elements);if(typeof n==="undefined"){h.fillText.call(this,o,m,p)}else{h.fillText.call(this,o,m,p,n)}this.updatePrecisionCompensate()},strokeText:function(o,m,p,n){h.setTransform.apply(this,i.elements);if(typeof n==="undefined"){h.strokeText.call(this,o,m,p)}else{h.strokeText.call(this,o,m,p,n)}this.updatePrecisionCompensate()},fill:function(){var m=this.fillGradient,n=this.bbox;this.updatePrecisionCompensateRect();if(m&&n){this.fillStyle=m.generateGradient(this,n)}h.fill.call(this);this.updatePrecisionCompensate()},stroke:function(){var m=this.strokeGradient,n=this.bbox;this.updatePrecisionCompensateRect();if(m&&n){this.strokeStyle=m.generateGradient(this,n)}h.stroke.call(this);this.updatePrecisionCompensate()},drawImage:function(u,s,r,q,p,o,n,m,t){switch(arguments.length){case 3:return h.drawImage.call(this,u,s*a+l,r*g+k);case 5:return h.drawImage.call(this,u,s*a+l,r*g+k,q*a,p*g);case 9:return h.drawImage.call(this,u,s,r,q,p,o*a+l,n*g*k,m*a,t*g)}}};Ext.apply(j,f);this.setDirty(true)},updateRect:function(n){this.callParent([n]);var m=this,c=Math.floor(n[0]),v=Math.floor(n[1]),a=Math.ceil(n[0]+n[2]),o=Math.ceil(n[1]+n[3]),u=m.devicePixelRatio,s=a-c,j=o-v,p=Math.round(m.splitThreshold/u),q=Math.ceil(s/p),k=m.activeCanvases,f,g,e,d;for(f=0,g=0;f<q;f++,g+=p){if(f>=m.canvases.length){m.createCanvas()}e=m.canvases[f].dom;e.style.left=g+"px";if(j*u!==e.height){e.height=j*u;e.style.height=j+"px"}d=Math.min(p,s-g);if(d*u!==e.width){e.width=d*u;e.style.width=d+"px"}m.applyDefaults(m.contexts[f])}for(;f<k;f++){e=m.canvases[f].dom;e.width=0;e.height=0}m.activeCanvases=q;m.clear()},clearTransform:function(){var c=this,d=c.activeCanvases,b,a;for(b=0;b<d;b++){a=c.contexts[b];a.translate(-c.splitThreshold*b,0);a.scale(c.devicePixelRatio,c.devicePixelRatio);c.matrix.toContext(a)}},renderSprite:function(n){var g=this,j=g.getRect(),f=g.matrix,l=n._parent,k=Ext.draw.Matrix.fly([1,0,0,1,0,0]),o,d,e,p,b,c=0,h,m=j[2],a;while(l&&(l!==g)){k.prependMatrix(l.matrix||l.attr&&l.attr.matrix);l=l.getParent()}k.prependMatrix(f);o=n.getBBox();if(o){o=k.transformBBox(o)}n.preRender(g);if(n.attr.hidden||n.attr.globalAlpha===0){n.setDirty(false);return}h=0;a=h+j[3];for(d=0,e=0;d<g.activeCanvases;d++,e+=g.splitThreshold/g.devicePixelRatio){p=g.contexts[d];b=Math.min(j[2]-e,g.splitThreshold/g.devicePixelRatio);c=e;m=c+b;if(o){if(o.x>m||o.x+o.width<c||o.y>a||o.y+o.height<h){continue}}p.save();n.useAttributes(p,j);if(false===n.render(g,p,[c,h,b,a-h],j)){return false}p.restore()}n.setDirty(false)},flatten:function(j,a){var c=document.createElement("canvas"),e=Ext.getClassName(this),f=this.devicePixelRatio,h=c.getContext("2d"),b,g,d;c.width=Math.ceil(j.width*f);c.height=Math.ceil(j.height*f);for(d=0;d<a.length;d++){b=a[d];if(Ext.getClassName(b)!==e){continue}g=b.getRect();h.drawImage(b.canvases[0].dom,g[0]*f,g[1]*f)}return{data:c.toDataURL(),type:"png"}},applyDefaults:function(a){var b=Ext.draw.Color.RGBA_NONE;a.strokeStyle=b;a.fillStyle=b;a.textAlign="start";a.textBaseline="alphabetic";a.miterLimit=1},clear:function(){var d=this,e=this.activeCanvases,c,b,a;for(c=0;c<e;c++){b=d.canvases[c].dom;a=d.contexts[c];a.setTransform(1,0,0,1,0,0);a.clearRect(0,0,b.width,b.height)}d.setDirty(true)},destroy:function(){var c=this,a,b=c.canvases.length;for(a=0;a<b;a++){c.contexts[a]=null;c.canvases[a].destroy();c.canvases[a]=null}delete c.contexts;delete c.canvases;c.callParent(arguments)}},function(){if(Ext.os.is.Android4&&Ext.browser.is.Chrome){this.prototype.splitThreshold=3000}else{if(Ext.os.is.Android){this.prototype.splitThreshold=10000000000}}});Ext.define("Ext.draw.Container",{extend:"Ext.draw.ContainerBase",alternateClassName:"Ext.draw.Component",xtype:"draw",defaultType:"surface",requires:["Ext.draw.Surface","Ext.draw.engine.Svg","Ext.draw.engine.Canvas","Ext.draw.gradient.GradientDefinition"],engine:"Ext.draw.engine.Canvas",config:{cls:Ext.baseCSSPrefix+"draw-container",resizeHandler:null,background:null,sprites:null,gradients:[]},defaultDownloadServerUrl:"http://svg.sencha.io",supportedFormats:["png","pdf","jpeg","gif"],supportedOptions:{version:Ext.isNumber,data:Ext.isString,format:function(a){return Ext.Array.indexOf(this.supportedFormats,a)>=0},filename:Ext.isString,width:Ext.isNumber,height:Ext.isNumber,scale:Ext.isNumber,pdf:Ext.isObject,jpeg:Ext.isObject},initAnimator:function(){this.frameCallbackId=Ext.draw.Animator.addFrameCallback("renderFrame",this)},applyGradients:function(b){var a=[],c,f,d,e;if(!Ext.isArray(b)){return a}for(c=0,f=b.length;c<f;c++){d=b[c];if(!Ext.isObject(d)){continue}if(typeof d.type!=="string"){d.type="linear"}if(d.angle){d.degrees=d.angle;delete d.angle}if(Ext.isObject(d.stops)){d.stops=(function(i){var g=[],h;for(e in i){h=i[e];h.offset=e/100;g.push(h)}return g})(d.stops)}a.push(d)}Ext.draw.gradient.GradientDefinition.add(a);return a},applySprites:function(d){if(!d){return}d=Ext.Array.from(d);var c=d.length,b,a;for(b=0;b<c;b++){if(d[b].surface instanceof Ext.draw.Surface){a=d[b].surface}else{if(Ext.isString(d[b].surface)){a=this.getSurface(d[b].surface)}else{a=this.getSurface("main")}}a.add(d[b])}},onPlaceWatermark:Ext.emptyFn,onBodyResize:function(){var d=this,c=d.element.getSize(),b=d.getResizeHandler()||d.resizeHandler,a;d.fireEvent("resize",d,c);a=b.call(d,c);if(a!==false){d.renderFrame();d.onPlaceWatermark(c.width,c.height)}},resizeHandler:function(a){this.getItems().each(function(b){b.setRect([0,0,a.width,a.height])})},getSurface:function(d){d=this.getId()+"-"+(d||"main");var c=this,b=c.getItems(),a=b.get(d);if(!a){a=c.add({xclass:c.engine,id:d});a.renderFrame()}return a},renderFrame:function(){var e=this,a=e.getItems(),b,d,c;for(b=0,d=a.length;b<d;b++){c=a.items[b];if(c.isSurface){c.renderFrame()}}},getImage:function(k){var l=this.innerElement.getSize(),a=Array.prototype.slice.call(this.items.items),d,g,c=this.surfaceZIndexes,f,e,b,h;for(e=1;e<a.length;e++){b=a[e];h=c[b.type];f=e-1;while(f>=0&&c[a[f].type]>h){a[f+1]=a[f];f--}a[f+1]=b}d=a[0].flatten(l,a);if(k==="image"){g=new Image();g.src=d.data;d.data=g;return d}if(k==="stream"){d.data=d.data.replace(/^data:image\/[^;]+/,"data:application/octet-stream");return d}return d},download:function(d){var e=this,a=[],b,c,f;d=Ext.apply({version:2,data:e.getImage().data},d);for(c in d){if(d.hasOwnProperty(c)){f=d[c];if(c in e.supportedOptions){if(e.supportedOptions[c].call(e,f)){a.push({tag:"input",type:"hidden",name:c,value:Ext.isObject(f)?Ext.JSON.encode(f):f})}}}}b=Ext.dom.Helper.markup({tag:"html",children:[{tag:"head"},{tag:"body",children:[{tag:"form",method:"POST",action:d.url||e.defaultDownloadServerUrl,children:a},{tag:"script",type:"text/javascript",children:'document.getElementsByTagName("form")[0].submit();'}]}]});window.open("","ImageDownload_"+Date.now()).document.write(b)},destroy:function(){var a=this.frameCallbackId;if(a){Ext.draw.Animator.removeFrameCallback(a)}this.callParent()}},function(){if(location.search.match("svg")){Ext.draw.Container.prototype.engine="Ext.draw.engine.Svg"}else{if((Ext.os.is.BlackBerry&&Ext.os.version.getMajor()===10)||(Ext.browser.is.AndroidStock4&&(Ext.os.version.getMinor()===1||Ext.os.version.getMinor()===2||Ext.os.version.getMinor()===3))){Ext.draw.Container.prototype.engine="Ext.draw.engine.Svg"}}});Ext.define("Ext.chart.theme.Base",{mixins:{factoryable:"Ext.mixin.Factoryable"},requires:["Ext.draw.Color"],factoryConfig:{type:"chart.theme"},isTheme:true,config:{baseColor:null,colors:undefined,gradients:null,chart:{defaults:{background:"white"}},axis:{defaults:{label:{x:0,y:0,textBaseline:"middle",textAlign:"center",fontSize:"default",fontFamily:"default",fontWeight:"default"},title:{fontSize:"default*1.23",fontFamily:"default",fontWeight:"default"}},top:{style:{textPadding:5}},bottom:{style:{textPadding:5}}},series:{defaults:{label:{fontFamily:"default",fontWeight:"default",fontSize:"default*1.077",textBaseline:"middle",textAlign:"center"},labelOverflowPadding:5}},sprites:{text:{fontSize:"default",fontWeight:"default",fontFamily:"default"}},seriesThemes:undefined,markerThemes:{type:["circle","cross","plus","square","triangle","diamond"]},useGradients:false,background:null},colorDefaults:["#94ae0a","#115fa6","#a61120","#ff8809","#ffd13e","#a61187","#24ad9a","#7c7474","#a66111"],constructor:function(a){this.initConfig(a);this.resolveDefaults()},defaultRegEx:/^default([+\-/\*]\d+(?:\.\d+)?)?$/,defaultOperators:{"*":function(b,a){return b*a},"+":function(b,a){return b+a},"-":function(b,a){return b-a}},resolveDefaults:function(){var a=this;Ext.onReady(function(){var f=Ext.clone(a.getSprites()),e=Ext.clone(a.getAxis()),d=Ext.clone(a.getSeries()),g,c,b;if(!a.superclass.defaults){g=Ext.getBody().createChild({tag:"div",cls:"x-component"});a.superclass.defaults={fontFamily:g.getStyle("fontFamily"),fontWeight:g.getStyle("fontWeight"),fontSize:parseFloat(g.getStyle("fontSize")),fontVariant:g.getStyle("fontVariant"),fontStyle:g.getStyle("fontStyle")}}a.replaceDefaults(f.text);a.setSprites(f);for(c in e){b=e[c];a.replaceDefaults(b.label);a.replaceDefaults(b.title)}a.setAxis(e);for(c in d){b=d[c];a.replaceDefaults(b.label)}a.setSeries(d)})},replaceDefaults:function(h){var e=this,g=e.superclass.defaults,a=e.defaultRegEx,d,f,c,b;if(Ext.isObject(h)){for(d in g){c=a.exec(h[d]);if(c){f=g[d];c=c[1];if(c){b=e.defaultOperators[c.charAt(0)];f=Math.round(b(f,parseFloat(c.substr(1))))}h[d]=f}}}},applyBaseColor:function(c){var a,b;if(c){a=c.isColor?c:Ext.draw.Color.fromString(c);b=a.getHSL()[2];if(b<0.15){a=a.createLighter(0.3)}else{if(b<0.3){a=a.createLighter(0.15)}else{if(b>0.85){a=a.createDarker(0.3)}else{if(b>0.7){a=a.createDarker(0.15)}}}}this.setColors([a.createDarker(0.3).toString(),a.createDarker(0.15).toString(),a.toString(),a.createLighter(0.12).toString(),a.createLighter(0.24).toString(),a.createLighter(0.31).toString()])}return c},applyColors:function(a){return a||this.colorDefaults},updateUseGradients:function(a){if(a){this.updateGradients({type:"linear",degrees:90})}},updateBackground:function(a){if(a){var b=this.getChart();b.defaults.background=a;this.setChart(b)}},updateGradients:function(a){var c=this.getColors(),e=[],h,b,d,f,g;if(Ext.isObject(a)){for(f=0,g=c&&c.length||0;f<g;f++){b=Ext.draw.Color.fromString(c[f]);if(b){d=b.createLighter(0.15).toString();h=Ext.apply(Ext.Object.chain(a),{stops:[{offset:1,color:b.toString()},{offset:0,color:d.toString()}]});e.push(h)}}this.setColors(e)}},applySeriesThemes:function(a){this.getBaseColor();this.getUseGradients();this.getGradients();var b=this.getColors();if(!a){a={fillStyle:Ext.Array.clone(b),strokeStyle:Ext.Array.map(b,function(d){var c=Ext.draw.Color.fromString(d.stops?d.stops[0].color:d);return c.createDarker(0.15).toString()})}}return a}});Ext.define("Ext.chart.theme.Default",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.default","chart.theme.Base"]});Ext.define("Ext.chart.Markers",{extend:"Ext.draw.sprite.Instancing",defaultCategory:"default",constructor:function(){this.callParent(arguments);this.categories={};this.revisions={}},clear:function(a){a=a||this.defaultCategory;if(!(a in this.revisions)){this.revisions[a]=1}else{this.revisions[a]++}},putMarkerFor:function(e,b,c,a,f){e=e||this.defaultCategory;var d=this,g=d.categories[e]||(d.categories[e]={});if(c in g){d.setAttributesFor(g[c],b,a)}else{g[c]=d.instances.length;d.createInstance(b,null,a)}d.instances[g[c]].category=e;if(!f){d.instances[g[c]].revision=d.revisions[e]||(d.revisions[e]=1)}},getMarkerBBoxFor:function(c,a,b){if(c in this.categories){var d=this.categories[c];if(a in d){return this.getBBoxFor(d[a],b)}}},getBBox:function(){return null},render:function(b,l,d){var g=this,k=g.revisions,j=g.attr.matrix,h=g.getTemplate(),c=h.attr,a=g.instances,e,f=g.instances.length;j.toContext(l);h.preRender(b,l,d);h.useAttributes(l,d);for(e=0;e<f;e++){if(a[e].hidden||a[e].revision!==k[a[e].category]){continue}l.save();h.attr=a[e];h.useAttributes(l,d);h.render(b,l,d);l.restore()}h.attr=c}});Ext.define("Ext.chart.label.Callout",{extend:"Ext.draw.modifier.Modifier",prepareAttributes:function(a){if(!a.hasOwnProperty("calloutOriginal")){a.calloutOriginal=Ext.Object.chain(a);a.calloutOriginal.prototype=a}if(this._previous){this._previous.prepareAttributes(a.calloutOriginal)}},setAttrs:function(e,h){var d=e.callout,i=e.calloutOriginal,l=e.bbox.plain,c=(l.width||0)+e.labelOverflowPadding,m=(l.height||0)+e.labelOverflowPadding,p,o;if("callout" in h){d=h.callout}if("callout" in h||"calloutPlaceX" in h||"calloutPlaceY" in h||"x" in h||"y" in h){var n="rotationRads" in h?i.rotationRads=h.rotationRads:i.rotationRads,g="x" in h?(i.x=h.x):i.x,f="y" in h?(i.y=h.y):i.y,b="calloutPlaceX" in h?h.calloutPlaceX:e.calloutPlaceX,a="calloutPlaceY" in h?h.calloutPlaceY:e.calloutPlaceY,k="calloutVertical" in h?h.calloutVertical:e.calloutVertical,j;n%=Math.PI*2;if(Math.cos(n)<0){n=(n+Math.PI)%(Math.PI*2)}if(n>Math.PI){n-=Math.PI*2}if(k){n=n*(1-d)-Math.PI/2*d;j=c;c=m;m=j}else{n=n*(1-d)}h.rotationRads=n;h.x=g*(1-d)+b*d;h.y=f*(1-d)+a*d;p=b-g;o=a-f;if(Math.abs(o*c)>Math.abs(p*m)){if(o>0){h.calloutEndX=h.x-(m/2)*(p/o)*d;h.calloutEndY=h.y-(m/2)*d}else{h.calloutEndX=h.x+(m/2)*(p/o)*d;h.calloutEndY=h.y+(m/2)*d}}else{if(p>0){h.calloutEndX=h.x-c/2;h.calloutEndY=h.y-(c/2)*(o/p)*d}else{h.calloutEndX=h.x+c/2;h.calloutEndY=h.y+(c/2)*(o/p)*d}}if(h.calloutStartX&&h.calloutStartY){h.calloutHasLine=(p>0&&h.calloutStartX<h.calloutEndX)||(p<=0&&h.calloutStartX>h.calloutEndX)||(o>0&&h.calloutStartY<h.calloutEndY)||(o<=0&&h.calloutStartY>h.calloutEndY)}else{h.calloutHasLine=true}}return h},pushDown:function(a,b){b=Ext.draw.modifier.Modifier.prototype.pushDown.call(this,a.calloutOriginal,b);return this.setAttrs(a,b)},popUp:function(a,b){a=a.prototype;b=this.setAttrs(a,b);if(this._next){return this._next.popUp(a,b)}else{return Ext.apply(a,b)}}});Ext.define("Ext.chart.label.Label",{extend:"Ext.draw.sprite.Text",requires:["Ext.chart.label.Callout"],inheritableStatics:{def:{processors:{callout:"limited01",calloutHasLine:"bool",calloutPlaceX:"number",calloutPlaceY:"number",calloutStartX:"number",calloutStartY:"number",calloutEndX:"number",calloutEndY:"number",calloutColor:"color",calloutWidth:"number",calloutVertical:"bool",labelOverflowPadding:"number",display:"enums(none,under,over,rotate,insideStart,insideEnd,inside,outside)",orientation:"enums(horizontal,vertical)",renderer:"default"},defaults:{callout:0,calloutHasLine:true,calloutPlaceX:0,calloutPlaceY:0,calloutStartX:0,calloutStartY:0,calloutEndX:0,calloutEndY:0,calloutWidth:1,calloutVertical:false,calloutColor:"black",labelOverflowPadding:5,display:"none",orientation:"",renderer:null},dirtyTriggers:{callout:"transform",calloutPlaceX:"transform",calloutPlaceY:"transform",labelOverflowPadding:"transform",calloutRotation:"transform",display:"hidden"},updaters:{hidden:function(a){a.hidden=a.display==="none"}}}},config:{fx:{customDurations:{callout:200}},field:null,calloutLine:true},applyCalloutLine:function(a){if(a){return Ext.apply({},a)}},prepareModifiers:function(){this.callParent(arguments);this.calloutModifier=new Ext.chart.label.Callout({sprite:this});this.fx.setNext(this.calloutModifier);this.calloutModifier.setNext(this.topModifier)},render:function(b,c){var e=this,a=e.attr,d=a.calloutColor;c.save();c.globalAlpha*=a.callout;if(c.globalAlpha>0&&a.calloutHasLine){if(d&&d.isGradient){d=d.getStops()[0].color}c.strokeStyle=d;c.fillStyle=d;c.lineWidth=a.calloutWidth;c.beginPath();c.moveTo(e.attr.calloutStartX,e.attr.calloutStartY);c.lineTo(e.attr.calloutEndX,e.attr.calloutEndY);c.stroke();c.beginPath();c.arc(e.attr.calloutStartX,e.attr.calloutStartY,1*a.calloutWidth,0,2*Math.PI,true);c.fill();c.beginPath();c.arc(e.attr.calloutEndX,e.attr.calloutEndY,1*a.calloutWidth,0,2*Math.PI,true);c.fill()}c.restore();Ext.draw.sprite.Text.prototype.render.apply(e,arguments)}});Ext.define("Ext.chart.series.Series",{requires:["Ext.chart.Markers","Ext.chart.label.Label","Ext.tip.ToolTip"],mixins:{observable:"Ext.mixin.Observable"},type:null,seriesType:"sprite",identifiablePrefix:"ext-line-",observableType:"series",darkerStrokeRatio:0.15,config:{chart:null,title:null,renderer:null,showInLegend:true,triggerAfterDraw:false,style:{},subStyle:{},themeStyle:{},colors:null,useDarkerStrokeColor:true,store:null,label:{},labelOverflowPadding:null,labelField:null,showMarkers:true,marker:null,markerSubStyle:null,itemInstancing:null,background:null,highlightItem:null,surface:null,overlaySurface:null,hidden:false,highlight:false,highlightCfg:{merge:function(a){return a},$value:{fillStyle:"yellow",strokeStyle:"red"}},animation:null,tooltip:null},directions:[],sprites:null,themeColorCount:function(){return 1},themeMarkerCount:function(){return 0},getFields:function(f){var e=this,a=[],c,b,d;for(b=0,d=f.length;b<d;b++){c=e["get"+f[b]+"Field"]();a.push(c)}return a},applyAnimation:function(a,b){if(!a){a={duration:0}}else{if(a===true){a={easing:"easeInOut",duration:500}}}return b?Ext.apply({},a,b):a},updateTitle:function(a){if(!this._chart){return}var h=this,a=Ext.Array.from(a),g=h.getChart(),c=g.getSeries(),b=Ext.Array.indexOf(c,h),e=g.getLegendStore(),f=Math.min(a.length,h.getYField().length),d,k,j;if(b!==-1){for(d=0;d<f;d++){j=a[d];if(j){k=e.getAt(b+d);k.set("name",j)}}}},applyHighlight:function(a,b){if(Ext.isObject(a)){a=Ext.merge({},this.config.highlightCfg,a)}else{if(a===true){a=this.config.highlightCfg}}return Ext.apply(b||{},a)},applyItemInstancing:function(a,b){return Ext.merge(b||{},a)},setAttributesForItem:function(a,b){if(a&&a.sprite){if(a.sprite.itemsMarker&&a.category==="items"){a.sprite.putMarker(a.category,b,a.index,false,true)}if(a.sprite.isMarkerHolder&&a.category==="markers"){a.sprite.putMarker(a.category,b,a.index,false,true)}else{if(a.sprite instanceof Ext.draw.sprite.Instancing){a.sprite.setAttributesFor(a.index,b)}else{a.sprite.setAttributes(b)}}}},getBBoxForItem:function(a){if(a&&a.sprite){if(a.sprite.itemsMarker&&a.category==="items"){return a.sprite.getMarkerBBox(a.category,a.index)}else{if(a.sprite instanceof Ext.draw.sprite.Instancing){return a.sprite.getBBoxFor(a.index)}else{return a.sprite.getBBox()}}}return null},applyHighlightItem:function(b,a){if(b===a){return}if(Ext.isObject(b)&&Ext.isObject(a)){if(b.sprite===a.sprite&&b.index===a.index){return}}return b},updateHighlightItem:function(b,a){this.setAttributesForItem(a,{highlighted:false});this.setAttributesForItem(b,{highlighted:true})},constructor:function(a){var b=this;b.getId();b.sprites=[];b.dataRange=[];Ext.ComponentManager.register(b);if(a){if(a.tips){a=Ext.apply({tooltip:a.tips},a)}if(a.highlightCfg){a=Ext.apply({highlight:a.highlightCfg},a)}}b.mixins.observable.constructor.call(b,a)},applyTooltip:function(f,e){var d=this.getChart(),g=d.getInteractions(),c,b;var a=Ext.apply({},f,{renderer:Ext.emptyFn,constrainPosition:true,shrinkWrapDock:true,autoHide:true,offsetX:10,offsetY:10});for(c=0;c<g.length;c++){if(g[c].type==="itemhightlight"){b=true;break}}if(!b){g.push("itemhighlight");d.setInteractions(g)}return new Ext.tip.ToolTip(a)},showTip:function(l,m){var d=this,n=d.getTooltip(),j,a,i,f,h,k,g,e,b,c;if(!n){return}clearTimeout(d.tooltipTimeout);b=n.config;if(n.trackMouse){m[0]+=b.offsetX;m[1]+=b.offsetY}else{j=l.sprite;a=j.getSurface();i=Ext.get(a.getId());if(i){k=l.series.getBBoxForItem(l);g=k.x+k.width/2;e=k.y+k.height/2;h=a.matrix.transformPoint([g,e]);f=i.getXY();c=a.getInherited().rtl;g=c?f[0]+i.getWidth()-h[0]:f[0]+h[0];e=f[1]+h[1];m=[g,e]}}n.config.renderer.call(n,l.record,l);n.show(m)},hideTip:function(b){var a=this,c=a.getTooltip();if(!c){return}clearTimeout(a.tooltipTimeout);a.tooltipTimeout=Ext.defer(function(){c.hide()},1)},applyStore:function(a){return a&&Ext.StoreManager.lookup(a)},getStore:function(){return this._store||this.getChart()&&this.getChart().getStore()},updateStore:function(b,h){var f=this,a=this.getChart()&&this.getChart().getStore(),g=f.getSprites(),e=g.length,d,c;b=b||a;h=h||a;if(h){h.un({datachanged:"onDataChanged",update:"onDataChanged",scope:f})}if(b){b.on({datachanged:"onDataChanged",update:"onDataChanged",scope:f});for(d=0;d<e;d++){c=g[d];if(c.setStore){c.setStore(b)}}f.onDataChanged()}},onStoreChange:function(a,b){if(!this._store){this.updateStore(a,b)}},coordinateStacked:function(x,d,h){var z=this,e=z.getStore(),o=e.getData().items,b=z["get"+x+"Axis"](),s=z.getHidden(),n={min:0,max:0},m=z["fieldCategory"+x],c,t,r,q,p,a,A,u={},w=[],g,l=[],y=[],v=z.getStacked(),f=z.getSprites();if(f.length>0){for(t=0;t<m.length;t++){c=m[t];p=z.getFields([c]);for(r=0;r<o.length;r++){w[r]=0;l[r]=0;y[r]=0}for(r=0;r<p.length;r++){u={};a=p[r];if(s[r]){u["dataStart"+c]=w;u["data"+c]=w;f[r].setAttributes(u);continue}A=z.coordinateData(o,a,b);if(v){g=[];for(q=0;q<o.length;q++){if(!A[q]){A[q]=0}if(A[q]>=0){w[q]=l[q];l[q]+=A[q];g[q]=l[q]}else{w[q]=y[q];y[q]+=A[q];g[q]=y[q]}}u["dataStart"+c]=w;u["data"+c]=g;z.getRangeOfData(w,n);z.getRangeOfData(g,n)}else{u["dataStart"+c]=w;u["data"+c]=A;z.getRangeOfData(A,n)}f[r].setAttributes(u)}}z.dataRange[d]=n.min;z.dataRange[d+h]=n.max;u={};u["dataMin"+x]=n.min;u["dataMax"+x]=n.max;for(t=0;t<f.length;t++){f[t].setAttributes(u)}}},coordinate:function(o,m,e){var l=this,p=l.getStore(),h=l.getHidden(),k=p.getData().items,b=l["get"+o+"Axis"](),f={min:Infinity,max:-Infinity},q=l["fieldCategory"+o]||[o],g=l.getFields(q),d,n,c,a={},j=l.getSprites();if(j.length>0){if(!Ext.isBoolean(h)||!h){for(d=0;d<q.length;d++){n=g[d];c=l.coordinateData(k,n,b);l.getRangeOfData(c,f);a["data"+q[d]]=c}}l.dataRange[m]=f.min;l.dataRange[m+e]=f.max;a["dataMin"+o]=f.min;a["dataMax"+o]=f.max;if(b){b.range=null;a["range"+o]=b.getRange()}for(d=0;d<j.length;d++){j[d].setAttributes(a)}}},coordinateData:function(g,j,b){var c=[],a=g.length,e=b&&b.getLayout(),f=b?function(k,m,i,l){return e.getCoordFor(k,m,i,l)}:function(i){return +i},d,h;for(d=0;d<a;d++){h=g[d].data[j];c[d]=!Ext.isEmpty(h)?f(h,j,d,g):h}return c},getRangeOfData:function(g,b){var d,e=g.length,f,c=b.min,a=b.max;for(d=0;d<e;d++){f=g[d];if(f<c){c=f}if(f>a){a=f}}b.min=c;b.max=a},updateLabelData:function(){var h=this,l=h.getStore(),g=l.getData().items,f=h.getSprites(),a=h.getLabel().getTemplate(),n=Ext.Array.from(a.getField()||h.getLabelField()),c,b,e,d,m,k;if(!f.length||!n.length){return}for(c=0;c<f.length;c++){d=[];m=f[c];k=m.getField();if(Ext.Array.indexOf(n,k)<0){k=n[c]}for(b=0,e=g.length;b<e;b++){d.push(g[b].get(k))}m.setAttributes({labels:d})}},updateLabelField:function(b){var a=this.getLabel().getTemplate();if(!a.config.field){a.setField(b)}},processData:function(){if(!this.getStore()){return}var d=this,f=this.directions,a,c=f.length,e,b;for(a=0;a<c;a++){e=f[a];if(d["get"+e+"Axis"]){b=d["get"+e+"Axis"]();if(b){b.processData(d);continue}}if(d["coordinate"+e]){d["coordinate"+e]()}}d.updateLabelData()},applyBackground:function(a){if(this.getChart()){this.getSurface().setBackground(a);return this.getSurface().getBackground()}else{return a}},updateChart:function(c,a){var b=this;if(a){a.un("axeschange","onAxesChange",b);b.sprites=[];b.setSurface(null);b.setOverlaySurface(null);b.onChartDetached(a)}if(c){b.setSurface(c.getSurface("series"));b.setOverlaySurface(c.getSurface("overlay"));c.on("axeschange","onAxesChange",b);if(c.getAxes()){b.onAxesChange(c)}b.onChartAttached(c)}b.updateStore(b._store,null)},onAxesChange:function(h){var k=this,g=h.getAxes(),c,a={},b={},e=false,j=this.directions,l,d,f;for(d=0,f=j.length;d<f;d++){l=j[d];b[l]=k.getFields(k["fieldCategory"+l])}for(d=0,f=g.length;d<f;d++){c=g[d];if(!a[c.getDirection()]){a[c.getDirection()]=[c]}else{a[c.getDirection()].push(c)}}for(d=0,f=j.length;d<f;d++){l=j[d];if(k["get"+l+"Axis"]()){continue}if(a[l]){c=k.findMatchingAxis(a[l],b[l]);if(c){k["set"+l+"Axis"](c);if(c.getNeedHighPrecision()){e=true}}}}this.getSurface().setHighPrecision(e)},findMatchingAxis:function(f,e){var d,c,b,a;for(b=0;b<f.length;b++){d=f[b];c=d.getFields();if(!c.length){return d}else{if(e){for(a=0;a<e.length;a++){if(Ext.Array.indexOf(c,e[a])>=0){return d}}}}}},onChartDetached:function(a){var b=this;b.fireEvent("chartdetached",a,b);a.un("storechange","onStoreChange",b)},onChartAttached:function(a){var b=this;b.setBackground(b.getBackground());b.fireEvent("chartattached",a,b);a.on("storechange","onStoreChange",b);b.processData()},updateOverlaySurface:function(a){var b=this;if(a){if(b.getLabel()){b.getOverlaySurface().add(b.getLabel())}}},applyLabel:function(a,b){if(!b){b=new Ext.chart.Markers({zIndex:10});b.setTemplate(new Ext.chart.label.Label(a))}else{b.getTemplate().setAttributes(a)}return b},createItemInstancingSprite:function(c,b){var e=this,d,f=new Ext.chart.Markers();f.setAttributes({zIndex:Number.MAX_VALUE});var a=Ext.apply({},b);if(e.getHighlight()){a.highlight=e.getHighlight();a.modifiers=["highlight"]}f.setTemplate(a);d=f.getTemplate();d.setAttributes(e.getStyle());d.fx.on("animationstart","onSpriteAnimationStart",this);d.fx.on("animationend","onSpriteAnimationEnd",this);c.bindMarker("items",f);e.getSurface().add(f);return f},getDefaultSpriteConfig:function(){return{type:this.seriesType,renderer:this.getRenderer()}},createSprite:function(){var f=this,a=f.getSurface(),e=f.getItemInstancing(),b,c,d=a.add(f.getDefaultSpriteConfig());d.setAttributes(this.getStyle());if(e){d.itemsMarker=f.createItemInstancingSprite(d,e)}if(d.bindMarker){if(f.getShowMarkers()&&f.getMarker()){b=new Ext.chart.Markers();c=Ext.Object.chain(f.getMarker());if(f.getHighlight()){c.highlight=f.getHighlight();c.modifiers=["highlight"]}b.setTemplate(c);b.getTemplate().fx.setCustomDurations({translationX:0,translationY:0});d.dataMarker=b;d.bindMarker("markers",b);f.getOverlaySurface().add(b)}if(f.getLabel().getTemplate().getField()||f.getLabelField()){d.bindMarker("labels",f.getLabel())}}if(d.setStore){d.setStore(f.getStore())}d.fx.on("animationstart","onSpriteAnimationStart",f);d.fx.on("animationend","onSpriteAnimationEnd",f);f.sprites.push(d);return d},getSprites:Ext.emptyFn,onDataChanged:function(){var d=this,c=d.getChart(),b=c&&c.getStore(),a=d.getStore();if(a!==b){d.processData()}},isXType:function(a){return a==="series"},getItemId:function(){return this.getId()},applyThemeStyle:function(e,a){var b=this,d,c;d=e&&e.subStyle&&e.subStyle.fillStyle;c=d&&e.subStyle.strokeStyle;if(d&&!c){e.subStyle.strokeStyle=b.getStrokeColorsFromFillColors(d)}d=e&&e.markerSubStyle&&e.markerSubStyle.fillStyle;c=d&&e.markerSubStyle.strokeStyle;if(d&&!c){e.markerSubStyle.strokeStyle=b.getStrokeColorsFromFillColors(d)}return Ext.apply(a||{},e)},applyStyle:function(c,b){var a=Ext.ClassManager.get(Ext.ClassManager.getNameByAlias("sprite."+this.seriesType));if(a&&a.def){c=a.def.normalize(c)}return Ext.apply(b||{},c)},applySubStyle:function(b,c){var a=Ext.ClassManager.get(Ext.ClassManager.getNameByAlias("sprite."+this.seriesType));if(a&&a.def){b=a.def.batchedNormalize(b,true)}return Ext.merge(c||{},b)},applyMarker:function(c,a){var d=(c&&c.type)||(a&&a.type)||"circle",b=Ext.ClassManager.get(Ext.ClassManager.getNameByAlias("sprite."+d));if(b&&b.def){c=b.def.normalize(c,true);c.type=d}return Ext.merge(a||{},c)},applyMarkerSubStyle:function(c,a){var d=(c&&c.type)||(a&&a.type)||"circle",b=Ext.ClassManager.get(Ext.ClassManager.getNameByAlias("sprite."+d));if(b&&b.def){c=b.def.batchedNormalize(c,true)}return Ext.merge(a||{},c)},updateHidden:function(a){this.getColors();this.getSubStyle();this.setSubStyle({hidden:a});this.processData();this.doUpdateStyles()},setHiddenByIndex:function(a,b){if(Ext.isArray(this.getHidden())){this.getHidden()[a]=b;this.updateHidden(this.getHidden())}else{this.setHidden(b)}},getStrokeColorsFromFillColors:function(a){var c=this,e=c.getUseDarkerStrokeColor(),b=(Ext.isNumber(e)?e:c.darkerStrokeRatio),d;if(e){d=Ext.Array.map(a,function(f){f=Ext.isString(f)?f:f.stops[0].color;f=Ext.draw.Color.fromString(f);return f.createDarker(b).toString()})}else{d=Ext.Array.clone(a)}return d},updateThemeColors:function(b){var c=this,d=c.getThemeStyle(),a=Ext.Array.clone(b),f=c.getStrokeColorsFromFillColors(b),e={fillStyle:a,strokeStyle:f};d.subStyle=Ext.apply(d.subStyle||{},e);d.markerSubStyle=Ext.apply(d.markerSubStyle||{},e);c.doUpdateStyles()},updateTheme:function(c){var f=this,a=c.getSeries(),l=f.getInitialConfig(),b=f.defaultConfig,e=f.getConfigurator().configs,h=a.defaults,i=a[f.type],j,g,m,k,d;a=Ext.merge({},h,i);for(j in a){g=a[j];d=e[j];if(g!==null&&g!==undefined&&d){k=l[j];m=Ext.isObject(g);if(k===b[j]||m){if(m){g=Ext.merge({},g,k)}f[d.names.set](g)}}}},updateChartColors:function(a){var b=this;if(!b.getColors()){b.updateThemeColors(a)}},updateColors:function(a){this.updateThemeColors(a)},updateStyle:function(){this.doUpdateStyles()},updateSubStyle:function(){this.doUpdateStyles()},updateThemeStyle:function(){this.doUpdateStyles()},doUpdateStyles:function(){var f=this,g=f.sprites,c=f.getItemInstancing(),b=0,e=g&&g.length,a=f.getMarker(),d;for(;b<e;b++){d=f.getStyleByIndex(b);if(c){g[b].itemsMarker.getTemplate().setAttributes(d)}g[b].setAttributes(d);if(a&&g[b].dataMarker){g[b].dataMarker.getTemplate().setAttributes(f.getMarkerStyleByIndex(b))}}},getStyleWithTheme:function(){var b=this,c=b.getThemeStyle(),d=(c&&c.style)||{},a=Ext.applyIf(Ext.apply({},b.getStyle()),d);return a},getSubStyleWithTheme:function(){var c=this,d=c.getThemeStyle(),a=(d&&d.subStyle)||{},b=Ext.applyIf(Ext.apply({},c.getSubStyle()),a);return b},getStyleByIndex:function(b){var e=this,h=e.getThemeStyle(),d,g,c,f,a={};d=e.getStyle();g=(h&&h.style)||{};c=e.styleDataForIndex(e.getSubStyle(),b);f=e.styleDataForIndex((h&&h.subStyle),b);Ext.apply(a,g);Ext.apply(a,f);Ext.apply(a,d);Ext.apply(a,c);return a},getMarkerStyleByIndex:function(d){var g=this,c=g.getThemeStyle(),a,e,k,j,b,l,h,f,m={};a=g.getStyle();e=(c&&c.style)||{};k=g.styleDataForIndex(g.getSubStyle(),d);j=g.styleDataForIndex((c&&c.subStyle),d);b=g.getMarker();l=(c&&c.marker)||{};h=g.getMarkerSubStyle();f=g.styleDataForIndex((c&&c.markerSubStyle),d);Ext.apply(m,e);Ext.apply(m,j);Ext.apply(m,l);Ext.apply(m,f);Ext.apply(m,a);Ext.apply(m,k);Ext.apply(m,b);Ext.apply(m,h);return m},styleDataForIndex:function(d,c){var e,b,a={};if(d){for(b in d){e=d[b];if(Ext.isArray(e)){a[b]=e[c%e.length]}else{a[b]=e}}}return a},getItemForPoint:Ext.emptyFn,getItemByIndex:function(b){if(this.getSprites()){var e=this,c=e.getSprites()[0],a=e.getStore(),d;if(c){d={series:this,category:this.getItemInstancing()?"items":"markers",index:b,record:a.getData().items[b],field:this.getYField(),sprite:c};return d}}},onSpriteAnimationStart:function(a){this.fireEvent("animationstart",a)},onSpriteAnimationEnd:function(a){this.fireEvent("animationend",a)},provideLegendInfo:function(a){a.push({name:this.getTitle()||this.getId(),mark:"black",disabled:this.getHidden(),series:this.getId(),index:0})},destroy:function(){var b=this,a=b.getStore(),c=b.getConfig("tooltip",true);b.clearListeners();Ext.ComponentManager.unregister(b);if(a&&a.getAutoDestroy()){Ext.destroy(a)}b.setStore(null);if(c){Ext.destroy(c);clearTimeout(b.tooltipTimeout)}b.callParent()}});Ext.define("Ext.chart.interactions.Abstract",{xtype:"interaction",mixins:{observable:"Ext.mixin.Observable"},config:{gestures:{tap:"onGesture"},chart:null,enabled:true},throttleGap:0,stopAnimationBeforeSync:false,constructor:function(a){var b=this;b.mixins.observable.constructor.call(b,a);b.getId();Ext.ComponentManager.register(b)},initialize:Ext.emptyFn,updateChart:function(c,a){var b=this;if(a===c){return}if(a){b.removeChartListener(a)}if(c){b.addChartListener()}},updateEnabled:function(a){var c=this,b=c.getChart();if(b){if(a){c.addChartListener()}else{c.removeChartListener(b)}}},onGesture:Ext.emptyFn,getItemForEvent:function(d){var b=this,a=b.getChart(),c=a.getEventXY(d);return a.getItemForPoint(c[0],c[1])},getItemsForEvent:function(d){var b=this,a=b.getChart(),c=a.getEventXY(d);return a.getItemsForPoint(c[0],c[1])},addChartListener:function(){var c=this,b=c.getChart(),e=c.getGestures(),a;if(!c.getEnabled()){return}function d(f,g){b.addElementListener(f,c.listeners[f]=function(j){var i=c.getLocks(),h;if(c.getEnabled()&&(!(f in i)||i[f]===c)){h=(Ext.isFunction(g)?g:c[g]).apply(this,arguments);if(h===false&&j&&j.stopPropagation){j.stopPropagation()}return h}},c)}c.listeners=c.listeners||{};for(a in e){d(a,e[a])}},removeChartListener:function(c){var d=this,e=d.getGestures(),b;function a(f){c.removeElementListener(f,d.listeners[f]);delete d.listeners[f]}if(d.listeners){for(b in e){a(b)}}},lockEvents:function(){var d=this,c=d.getLocks(),a=Array.prototype.slice.call(arguments),b=a.length;while(b--){c[a[b]]=d}},unlockEvents:function(){var c=this.getLocks(),a=Array.prototype.slice.call(arguments),b=a.length;while(b--){delete c[a[b]]}},getLocks:function(){var a=this.getChart();return a.lockedEvents||(a.lockedEvents={})},isMultiTouch:function(){if(Ext.browser.is.IE10){return true}return !(Ext.browser.is.AndroidStock2||Ext.os.is.Desktop)},initializeDefaults:Ext.emptyFn,doSync:function(){var b=this,a=b.getChart();if(b.syncTimer){clearTimeout(b.syncTimer);b.syncTimer=null}if(b.stopAnimationBeforeSync){a.resizing=true}a.redraw();if(b.stopAnimationBeforeSync){a.resizing=false}b.syncThrottle=Date.now()+b.throttleGap},sync:function(){var a=this;if(a.throttleGap&&Ext.frameStartTime<a.syncThrottle){if(a.syncTimer){return}a.syncTimer=Ext.defer(function(){a.doSync()},a.throttleGap)}else{a.doSync()}},getItemId:function(){return this.getId()},isXType:function(a){return a==="interaction"},destroy:function(){var b=this,a=b.getChart();b.removeChartListener(a);Ext.ComponentManager.unregister(b);delete b.listeners;b.callParent()}},function(){if(Ext.browser.is.AndroidStock2){this.prototype.throttleGap=20}else{if(Ext.os.is.Android4){this.prototype.throttleGap=40}}});Ext.define("Ext.chart.MarkerHolder",{extend:"Ext.Mixin",mixinConfig:{id:"markerHolder",after:{constructor:"constructor",preRender:"preRender"}},isMarkerHolder:true,constructor:function(){this.boundMarkers={};this.cleanRedraw=false},bindMarker:function(b,a){if(a){if(!this.boundMarkers[b]){this.boundMarkers[b]=[]}Ext.Array.include(this.boundMarkers[b],a)}},getBoundMarker:function(a){return this.boundMarkers[a]},preRender:function(){var d=this.boundMarkers,g,b,c,f,h=this.getId(),e=this.getParent(),a=this.surfaceMatrix?this.surfaceMatrix.set(1,0,0,1,0,0):(this.surfaceMatrix=new Ext.draw.Matrix());this.cleanRedraw=!this.attr.dirty;if(!this.cleanRedraw){for(b in this.boundMarkers){if(d[b]){for(g=d[b],c=0,f=g.length;c<f;c++){g[c].clear(h)}}}}while(e&&e.attr&&e.attr.matrix){a.prependMatrix(e.attr.matrix);e=e.getParent()}a.prependMatrix(e.matrix);this.surfaceMatrix=a;this.inverseSurfaceMatrix=a.inverse(this.inverseSurfaceMatrix)},putMarker:function(a,f,e,c,j){var h,d,g,b=this.getId();if(this.boundMarkers[a]){for(h=this.boundMarkers[a],d=0,g=h.length;d<g;d++){h[d].putMarkerFor(b,f,e,c,j)}}},getMarkerBBox:function(b,a,c){var d=this.boundMarkers[b],e=this.getId();if(d){return d[0].getMarkerBBoxFor(e,a,c)}}});Ext.define("Ext.chart.axis.sprite.Axis",{extend:"Ext.draw.sprite.Sprite",type:"axis",mixins:{markerHolder:"Ext.chart.MarkerHolder"},requires:["Ext.draw.sprite.Text"],inheritableStatics:{def:{processors:{grid:"bool",axisLine:"bool",minorTicks:"bool",minorTickSize:"number",majorTicks:"bool",majorTickSize:"number",length:"number",startGap:"number",endGap:"number",dataMin:"number",dataMax:"number",visibleMin:"number",visibleMax:"number",position:"enums(left,right,top,bottom,angular,radial,gauge)",minStepSize:"number",estStepSize:"number",titleOffset:"number",textPadding:"number",min:"number",max:"number",centerX:"number",centerY:"number",radius:"number",totalAngle:"number",baseRotation:"number",data:"default",enlargeEstStepSizeByText:"bool"},defaults:{grid:false,axisLine:true,minorTicks:false,minorTickSize:3,majorTicks:true,majorTickSize:5,length:0,startGap:0,endGap:0,visibleMin:0,visibleMax:1,dataMin:0,dataMax:1,position:"",minStepSize:0,estStepSize:20,min:0,max:1,centerX:0,centerY:0,radius:1,baseRotation:0,data:null,titleOffset:0,textPadding:0,scalingCenterY:0,scalingCenterX:0,strokeStyle:"black",enlargeEstStepSizeByText:false},dirtyTriggers:{minorTickSize:"bbox",majorTickSize:"bbox",position:"bbox,layout",axisLine:"bbox,layout",min:"layout",max:"layout",length:"layout",minStepSize:"layout",estStepSize:"layout",data:"layout",dataMin:"layout",dataMax:"layout",visibleMin:"layout",visibleMax:"layout",enlargeEstStepSizeByText:"layout"},updaters:{layout:function(){this.doLayout()}}}},config:{label:null,layout:null,segmenter:null,renderer:null,layoutContext:null,axis:null},thickness:0,stepSize:0,getBBox:function(){return null},doDefaultRender:function(a){return this.segmenter.renderer(a,this)},doLayout:function(){var h=this,f=h.getAxis().getChart();if(f.isInitializing){return}var b=h.attr,g=h.getLayout(),c=f.getInherited().rtl,e=b.dataMin+(b.dataMax-b.dataMin)*b.visibleMin,a=b.dataMin+(b.dataMax-b.dataMin)*b.visibleMax,d={attr:b,segmenter:h.getSegmenter(),renderer:h.doDefaultRender};if(b.position==="left"||b.position==="right"){b.translationX=0;b.translationY=a*b.length/(a-e);b.scalingX=1;b.scalingY=-b.length/(a-e);b.scalingCenterY=0;b.scalingCenterX=0;h.applyTransformations(true)}else{if(b.position==="top"||b.position==="bottom"){if(c){b.translationX=b.length+e*b.length/(a-e)+1}else{b.translationX=-e*b.length/(a-e)}b.translationY=0;b.scalingX=(c?-1:1)*b.length/(a-e);b.scalingY=1;b.scalingCenterY=0;b.scalingCenterX=0;h.applyTransformations(true)}}if(g){g.calculateLayout(d);h.setLayoutContext(d)}},iterate:function(e,j){var c,g,a,b,h,d,k=Ext.Array.some,m=Math.abs,f;if(e.getLabel){if(e.min<e.from){j.call(this,e.min,e.getLabel(e.min),-1,e)}for(c=0;c<=e.steps;c++){j.call(this,e.get(c),e.getLabel(c),c,e)}if(e.max>e.to){j.call(this,e.max,e.getLabel(e.max),e.steps+1,e)}}else{b=this.getAxis();h=b.floatingAxes;d=[];f=(e.to-e.from)/(e.steps+1);if(b.getFloating()){for(a in h){d.push(h[a])}}function l(i){return !d.length||k(d,function(n){return m(n-i)>f})}if(e.min<e.from&&l(e.min)){j.call(this,e.min,e.min,-1,e)}for(c=0;c<=e.steps;c++){g=e.get(c);if(l(g)){j.call(this,g,g,c,e)}}if(e.max>e.to&&l(e.max)){j.call(this,e.max,e.max,e.steps+1,e)}}},renderTicks:function(l,m,s,p){var v=this,k=v.attr,u=k.position,n=k.matrix,e=0.5*k.lineWidth,f=n.getXX(),i=n.getDX(),j=n.getYY(),h=n.getDY(),o=s.majorTicks,d=k.majorTickSize,a=s.minorTicks,r=k.minorTickSize;if(o){switch(u){case"right":function q(w){return function(x,z,y){x=l.roundPixel(x*j+h)+e;m.moveTo(0,x);m.lineTo(w,x)}}v.iterate(o,q(d));a&&v.iterate(a,q(r));break;case"left":function t(w){return function(x,z,y){x=l.roundPixel(x*j+h)+e;m.moveTo(p[2]-w,x);m.lineTo(p[2],x)}}v.iterate(o,t(d));a&&v.iterate(a,t(r));break;case"bottom":function c(w){return function(x,z,y){x=l.roundPixel(x*f+i)-e;m.moveTo(x,0);m.lineTo(x,w)}}v.iterate(o,c(d));a&&v.iterate(a,c(r));break;case"top":function b(w){return function(x,z,y){x=l.roundPixel(x*f+i)-e;m.moveTo(x,p[3]);m.lineTo(x,p[3]-w)}}v.iterate(o,b(d));a&&v.iterate(a,b(r));break;case"angular":v.iterate(o,function(w,y,x){w=w/(k.max+1)*Math.PI*2+k.baseRotation;m.moveTo(k.centerX+(k.length)*Math.cos(w),k.centerY+(k.length)*Math.sin(w));m.lineTo(k.centerX+(k.length+d)*Math.cos(w),k.centerY+(k.length+d)*Math.sin(w))});break;case"gauge":var g=v.getGaugeAngles();v.iterate(o,function(w,y,x){w=(w-k.min)/(k.max-k.min+1)*k.totalAngle-k.totalAngle+g.start;m.moveTo(k.centerX+(k.length)*Math.cos(w),k.centerY+(k.length)*Math.sin(w));m.lineTo(k.centerX+(k.length+d)*Math.cos(w),k.centerY+(k.length+d)*Math.sin(w))});break}}},renderLabels:function(t,u,D,x){var G=this,s=G.attr,d=0.5*s.lineWidth,E=s.position,v=s.matrix,z=s.textPadding,f=v.getXX(),l=v.getDX(),q=v.getYY(),k=v.getDY(),a=0,w=D.majorTicks,C=Math.max(s.majorTickSize,s.minorTickSize)+s.lineWidth,i=G.getLabel(),o,y,A=null,n=0,B=0,e=D.segmenter,r=G.getRenderer(),H=G.getAxis().getTitle(),g=H&&H.attr.text!==""&&H.getBBox(),j,F=null,c,p,m,b;if(w&&i&&!i.attr.hidden){o=i.attr.font;if(u.font!==o){u.font=o}i.setAttributes({translationX:0,translationY:0},true,true);i.applyTransformations();j=i.attr.inverseMatrix.elements.slice(0);switch(E){case"left":b=g?g.x+g.width:0;i.setAttributes({translationX:t.roundPixel(b+(x[2]-b-C)/2+l)-d},true,true);break;case"right":b=g?x[2]-g.x:0;i.setAttributes({translationX:t.roundPixel(C+(x[2]-C-b)/2+l)+d},true,true);break;case"top":b=g?g.y+g.height:0;i.setAttributes({translationY:t.roundPixel(b+(x[3]-b-C)/2)-d},true,true);break;case"bottom":b=g?x[3]-g.y:0;i.setAttributes({translationY:t.roundPixel(C+(x[3]-C-b)/2)+d},true,true);break;case"radial":i.setAttributes({translationX:s.centerX},true,true);break;case"angular":i.setAttributes({translationY:s.centerY},true,true);break;case"gauge":i.setAttributes({translationY:s.centerY},true,true);break}if(E==="left"||E==="right"){G.iterate(w,function(I,K,J){if(K===undefined){return}m=r?r.call(G,K,D,A):e.renderer(K,D,A);A=K;i.setAttributes({text:String(m),translationY:t.roundPixel(I*q+k)},true,true);i.applyTransformations();a=Math.max(a,i.getBBox().width+C);if(a<=G.thickness){p=Ext.draw.Matrix.fly(i.attr.matrix.elements.slice(0));c=p.prepend.apply(p,j).transformBBox(i.getBBox(true));if(F&&!Ext.draw.Draw.isBBoxIntersect(c,F,z)){return}t.renderSprite(i);F=c;n+=c.height;B++}})}else{if(E==="top"||E==="bottom"){G.iterate(w,function(I,K,J){if(K===undefined){return}m=r?r.call(this,K,D,A):e.renderer(K,D,A);A=K;i.setAttributes({text:String(m),translationX:t.roundPixel(I*f+l)},true,true);i.applyTransformations();a=Math.max(a,i.getBBox().height+C);if(a<=G.thickness){p=Ext.draw.Matrix.fly(i.attr.matrix.elements.slice(0));c=p.prepend.apply(p,j).transformBBox(i.getBBox(true));if(F&&!Ext.draw.Draw.isBBoxIntersect(c,F,z)){return}t.renderSprite(i);F=c;n+=c.width;B++}})}else{if(E==="radial"){G.iterate(w,function(I,K,J){if(K===undefined){return}m=r?r.call(G,K,D,A):e.renderer(K,D,A);A=K;if(typeof m!=="undefined"){i.setAttributes({text:String(m),translationX:s.centerX-t.roundPixel(I)/s.max*s.length*Math.cos(s.baseRotation+Math.PI/2),translationY:s.centerY-t.roundPixel(I)/s.max*s.length*Math.sin(s.baseRotation+Math.PI/2)},true,true);i.applyTransformations();c=i.attr.matrix.transformBBox(i.getBBox(true));if(F&&!Ext.draw.Draw.isBBoxIntersect(c,F)){return}t.renderSprite(i);F=c;n+=c.width;B++}})}else{if(E==="angular"){y=s.majorTickSize+s.lineWidth*0.5+(parseInt(i.attr.fontSize,10)||10)/2;G.iterate(w,function(I,K,J){if(K===undefined){return}m=r?r.call(G,K,D,A):e.renderer(K,D,A);A=K;a=Math.max(a,Math.max(s.majorTickSize,s.minorTickSize)+(s.lineCap!=="butt"?s.lineWidth*0.5:0));if(typeof m!=="undefined"){var L=I/(s.max+1)*Math.PI*2+s.baseRotation;i.setAttributes({text:String(m),translationX:s.centerX+(s.length+y)*Math.cos(L),translationY:s.centerY+(s.length+y)*Math.sin(L)},true,true);i.applyTransformations();c=i.attr.matrix.transformBBox(i.getBBox(true));if(F&&!Ext.draw.Draw.isBBoxIntersect(c,F)){return}t.renderSprite(i);F=c;n+=c.width;B++}})}else{if(E==="gauge"){var h=G.getGaugeAngles();G.iterate(w,function(I,K,J){if(K===undefined){return}m=r?r.call(G,K,D,A):e.renderer(K,D,A);A=K;if(typeof m!=="undefined"){var L=(I-s.min)/(s.max-s.min+1)*s.totalAngle-s.totalAngle+h.start;i.setAttributes({text:String(m),translationX:s.centerX+(s.length+10)*Math.cos(L),translationY:s.centerY+(s.length+10)*Math.sin(L)},true,true);i.applyTransformations();c=i.attr.matrix.transformBBox(i.getBBox(true));if(F&&!Ext.draw.Draw.isBBoxIntersect(c,F)){return}t.renderSprite(i);F=c;n+=c.width;B++}})}}}}}if(s.enlargeEstStepSizeByText&&B){n/=B;n+=C;n*=2;if(s.estStepSize<n){s.estStepSize=n}}if(Math.abs(G.thickness-(a))>1){G.thickness=a;s.bbox.plain.dirty=true;s.bbox.transform.dirty=true;G.doThicknessChanged();return false}}},renderAxisLine:function(a,i,e,c){var h=this,g=h.attr,b=g.lineWidth*0.5,j=g.position,d,f;if(g.axisLine&&g.length){switch(j){case"left":d=a.roundPixel(c[2])-b;i.moveTo(d,-g.endGap);i.lineTo(d,g.length+g.startGap);break;case"right":i.moveTo(b,-g.endGap);i.lineTo(b,g.length+g.startGap);break;case"bottom":i.moveTo(-g.startGap,b);i.lineTo(g.length+g.endGap,b);break;case"top":d=a.roundPixel(c[3])-b;i.moveTo(-g.startGap,d);i.lineTo(g.length+g.endGap,d);break;case"angular":i.moveTo(g.centerX+g.length,g.centerY);i.arc(g.centerX,g.centerY,g.length,0,Math.PI*2,true);break;case"gauge":f=h.getGaugeAngles();i.moveTo(g.centerX+Math.cos(f.start)*g.length,g.centerY+Math.sin(f.start)*g.length);i.arc(g.centerX,g.centerY,g.length,f.start,f.end,true);break}}},getGaugeAngles:function(){var a=this,c=a.attr.totalAngle,b;if(c<=Math.PI){b=(Math.PI-c)*0.5}else{b=-(Math.PI*2-c)*0.5}b=Math.PI*2-b;return{start:b,end:b-c}},renderGridLines:function(k,l,q,o){var r=this,i=r.attr,m=i.matrix,c=i.startGap,a=i.endGap,b=m.getXX(),h=m.getYY(),f=m.getDX(),e=m.getDY(),s=i.position,n=q.majorTicks,d,p,g;if(i.grid){if(n){if(s==="left"||s==="right"){g=i.min*h+e+a+c;r.iterate(n,function(j,u,t){d=j*h+e+a;r.putMarker("horizontal-"+(t%2?"odd":"even"),{y:d,height:g-d},p=t,true);g=d});p++;d=0;r.putMarker("horizontal-"+(p%2?"odd":"even"),{y:d,height:g-d},p,true)}else{if(s==="top"||s==="bottom"){g=i.min*b+f+c;if(c){r.putMarker("vertical-even",{x:0,width:g},-1,true)}r.iterate(n,function(j,u,t){d=j*b+f+c;r.putMarker("vertical-"+(t%2?"odd":"even"),{x:d,width:g-d},p=t,true);g=d});p++;d=i.length+i.startGap+i.endGap;r.putMarker("vertical-"+(p%2?"odd":"even"),{x:d,width:g-d},p,true)}else{if(s==="radial"){r.iterate(n,function(j,u,t){if(!j){return}d=j/i.max*i.length;r.putMarker("circular-"+(t%2?"odd":"even"),{scalingX:d,scalingY:d},t,true);g=d})}else{if(s==="angular"){r.iterate(n,function(j,u,t){if(!i.length){return}d=j/(i.max+1)*Math.PI*2+i.baseRotation;r.putMarker("radial-"+(t%2?"odd":"even"),{rotationRads:d,rotationCenterX:0,rotationCenterY:0,scalingX:i.length,scalingY:i.length},t,true);g=d})}}}}}}},renderLimits:function(){var q=this,a=q.getAxis(),d=Ext.Array.from(a.getLimits());if(!d.length){return}var o=a.limits.surface.getRect(),l=q.attr,m=l.matrix,r=l.position,j=Ext.Object.chain,s=a.limits.titles,c,h,b,p,k,n,f,g,e;s.instances=[];s.position=0;if(r==="left"||r==="right"){for(n=0,f=d.length;n<f;n++){p=j(d[n]);!p.line&&(p.line={});k=Ext.isString(p.value)?a.getCoordFor(p.value):p.value;k=k*m.getYY()+m.getDY();p.line.y=k;q.putMarker("horizontal-limit-lines",p.line,n,true);if(p.line.title){s.createInstance(p.line.title);c=s.getBBoxFor(s.position-1);h=p.line.title.position||(r==="left"?"start":"end");switch(h){case"start":g=10;break;case"end":g=o[2]-10;break;case"middle":g=o[2]/2;break}s.setAttributesFor(s.position-1,{x:g,y:k-c.height/2,textAlign:h,fillStyle:p.line.title.fillStyle||p.line.strokeStyle})}}}else{if(r==="top"||r==="bottom"){for(n=0,f=d.length;n<f;n++){p=j(d[n]);!p.line&&(p.line={});k=Ext.isString(p.value)?a.getCoordFor(p.value):p.value;k=k*m.getXX()+m.getDX();p.line.x=k;q.putMarker("vertical-limit-lines",p.line,n,true);if(p.line.title){s.createInstance(p.line.title);c=s.getBBoxFor(s.position-1);h=p.line.title.position||(r==="top"?"end":"start");switch(h){case"start":e=o[3]-c.width/2-10;break;case"end":e=c.width/2+10;break;case"middle":e=o[3]/2;break}s.setAttributesFor(s.position-1,{x:k+c.height/2,y:e,fillStyle:p.line.title.fillStyle||p.line.strokeStyle,rotationRads:Math.PI/2})}}}else{if(r==="radial"){for(n=0,f=d.length;n<f;n++){p=j(d[n]);!p.line&&(p.line={});k=Ext.isString(p.value)?a.getCoordFor(p.value):p.value;if(k>l.max){continue}k=k/l.max*l.length;p.line.cx=l.centerX;p.line.cy=l.centerY;p.line.scalingX=k;p.line.scalingY=k;q.putMarker("circular-limit-lines",p.line,n,true);if(p.line.title){s.createInstance(p.line.title);c=s.getBBoxFor(s.position-1);s.setAttributesFor(s.position-1,{x:l.centerX,y:l.centerY-k-c.height/2,fillStyle:p.line.title.fillStyle||p.line.strokeStyle})}}}else{if(r==="angular"){for(n=0,f=d.length;n<f;n++){p=j(d[n]);!p.line&&(p.line={});k=Ext.isString(p.value)?a.getCoordFor(p.value):p.value;k=k/(l.max+1)*Math.PI*2+l.baseRotation;p.line.translationX=l.centerX;p.line.translationY=l.centerY;p.line.rotationRads=k;p.line.rotationCenterX=0;p.line.rotationCenterY=0;p.line.scalingX=l.length;p.line.scalingY=l.length;q.putMarker("radial-limit-lines",p.line,n,true);if(p.line.title){s.createInstance(p.line.title);c=s.getBBoxFor(s.position-1);b=((k>-0.5*Math.PI&&k<0.5*Math.PI)||(k>1.5*Math.PI&&k<2*Math.PI))?1:-1;s.setAttributesFor(s.position-1,{x:l.centerX+0.5*l.length*Math.cos(k)+b*c.height/2*Math.sin(k),y:l.centerY+0.5*l.length*Math.sin(k)-b*c.height/2*Math.cos(k),rotationRads:b===1?k:k-Math.PI,fillStyle:p.line.title.fillStyle||p.line.strokeStyle})}}}else{if(r==="gauge"){}}}}}},doThicknessChanged:function(){var a=this.getAxis();if(a){a.onThicknessChanged()}},render:function(a,b,c){var e=this,d=e.getLayoutContext();if(d){if(false===e.renderLabels(a,b,d,c)){return false}b.beginPath();e.renderTicks(a,b,d,c);e.renderAxisLine(a,b,d,c);e.renderGridLines(a,b,d,c);e.renderLimits();b.stroke()}}});Ext.define("Ext.chart.axis.segmenter.Segmenter",{config:{axis:null},constructor:function(a){this.initConfig(a)},renderer:function(b,a){return String(b)},from:function(a){return a},diff:Ext.emptyFn,align:Ext.emptyFn,add:Ext.emptyFn,preferredStep:Ext.emptyFn});Ext.define("Ext.chart.axis.segmenter.Names",{extend:"Ext.chart.axis.segmenter.Segmenter",alias:"segmenter.names",renderer:function(b,a){return b},diff:function(b,a,c){return Math.floor(a-b)},align:function(c,b,a){return Math.floor(c)},add:function(c,b,a){return c+b},preferredStep:function(c,a,b,d){return{unit:1,step:1}}});Ext.define("Ext.chart.axis.segmenter.Numeric",{extend:"Ext.chart.axis.segmenter.Segmenter",alias:"segmenter.numeric",isNumeric:true,renderer:function(b,a){return b.toFixed(Math.max(0,a.majorTicks.unit.fixes))},diff:function(b,a,c){return Math.floor((a-b)/c.scale)},align:function(c,b,a){return Math.floor(c/(a.scale*b))*a.scale*b},add:function(c,b,a){return c+b*a.scale},preferredStep:function(c,a){var b=Math.floor(Math.log(a)*Math.LOG10E),d=Math.pow(10,b);a/=d;if(a<2){a=2}else{if(a<5){a=5}else{if(a<10){a=10;b++}}}return{unit:{fixes:-b,scale:d},step:a}},exactStep:function(c,a){var b=Math.floor(Math.log(a)*Math.LOG10E),d=Math.pow(10,b);return{unit:{fixes:-b+(a%d===0?0:1),scale:1},step:a}},adjustByMajorUnit:function(e,g,c){var d=c[0],b=c[1],a=e*g,f=d%a;if(f!==0){c[0]=d-f+(d<0?-a:0)}f=b%a;if(f!==0){c[1]=b-f+(b>0?a:0)}}});Ext.define("Ext.chart.axis.segmenter.Time",{extend:"Ext.chart.axis.segmenter.Segmenter",alias:"segmenter.time",config:{step:null},renderer:function(c,b){var a=Ext.Date;switch(b.majorTicks.unit){case"y":return a.format(c,"Y");case"mo":return a.format(c,"Y-m");case"d":return a.format(c,"Y-m-d")}return a.format(c,"Y-m-d\nH:i:s")},from:function(a){return new Date(a)},diff:function(c,a,d){var b=Ext.Date;if(isFinite(c)){c=new Date(c)}if(isFinite(a)){a=new Date(a)}return b.diff(c,a,d)},align:function(a,c,b){if(b==="d"&&c>=7){a=Ext.Date.align(a,"d",c);a.setDate(a.getDate()-a.getDay()+1);return a}else{return Ext.Date.align(a,b,c)}},add:function(c,b,a){return Ext.Date.add(new Date(c),a,b)},preferredStep:function(b,e){if(this.getStep()){return this.getStep()}var h=new Date(+b),k=new Date(+b+Math.ceil(e)),l=Ext.Date,d=[[l.YEAR,1,2,5,10,20,50,100,200,500],[l.MONTH,1,3,6],[l.DAY,1,7,14],[l.HOUR,1,6,12],[l.MINUTE,1,5,15,30],[l.SECOND,1,5,15,30],[l.MILLI,1,2,5,10,20,50,100,200,500]],m;for(var c=0;c<d.length;c++){var g=d[c][0],f=this.diff(h,k,g);if(f>0){for(var a=1;a<d[c].length;a++){if(f<=d[c][a]){m={unit:g,step:d[c][a]};break}}if(!m){c--;m={unit:d[c][0],step:1}}break}}if(!m){m={unit:l.DAY,step:1}}return m}});Ext.define("Ext.chart.axis.layout.Layout",{mixins:{observable:"Ext.mixin.Observable"},config:{axis:null},constructor:function(a){this.mixins.observable.constructor.call(this,a)},processData:function(b){var e=this,c=e.getAxis(),f=c.getDirection(),g=c.boundSeries,a,d;if(b){b["coordinate"+f]()}else{for(a=0,d=g.length;a<d;a++){g[a]["coordinate"+f]()}}},calculateMajorTicks:function(a){var f=this,e=a.attr,d=e.max-e.min,i=d/Math.max(1,e.length)*(e.visibleMax-e.visibleMin),h=e.min+d*e.visibleMin,b=e.min+d*e.visibleMax,g=e.estStepSize*i,c=f.snapEnds(a,e.min,e.max,g);if(c){f.trimByRange(a,c,h,b);a.majorTicks=c}},calculateMinorTicks:function(a){if(this.snapMinorEnds){a.minorTicks=this.snapMinorEnds(a)}},calculateLayout:function(b){var c=this,a=b.attr;if(a.length===0){return null}if(a.majorTicks){c.calculateMajorTicks(b);if(a.minorTicks){c.calculateMinorTicks(b)}}},snapEnds:Ext.emptyFn,trimByRange:function(b,f,i,a){var g=b.segmenter,j=f.unit,h=g.diff(f.from,i,j),d=g.diff(f.from,a,j),c=Math.max(0,Math.ceil(h/f.step)),e=Math.min(f.steps,Math.floor(d/f.step));if(e<f.steps){f.to=g.add(f.from,e*f.step,j)}if(f.max>a){f.max=f.to}if(f.from<i){f.from=g.add(f.from,c*f.step,j);while(f.from<i){c++;f.from=g.add(f.from,f.step,j)}}if(f.min<i){f.min=f.from}f.steps=e-c}});Ext.define("Ext.chart.axis.layout.Discrete",{extend:"Ext.chart.axis.layout.Layout",alias:"axisLayout.discrete",processData:function(){var f=this,d=f.getAxis(),c=d.boundSeries,g=d.getDirection(),b,e,a;this.labels=[];this.labelMap={};for(b=0,e=c.length;b<e;b++){a=c[b];if(a["get"+g+"Axis"]()===d){a["coordinate"+g]()}}d.getSprites()[0].setAttributes({data:this.labels});this.fireEvent("datachange",this.labels)},calculateLayout:function(a){a.data=this.labels;this.callParent([a])},calculateMajorTicks:function(a){var g=this,f=a.attr,d=a.data,e=f.max-f.min,j=e/Math.max(1,f.length)*(f.visibleMax-f.visibleMin),i=f.min+e*f.visibleMin,b=f.min+e*f.visibleMax,h=f.estStepSize*j;var c=g.snapEnds(a,Math.max(0,f.min),Math.min(f.max,d.length-1),h);if(c){g.trimByRange(a,c,i,b);a.majorTicks=c}},snapEnds:function(e,d,a,b){b=Math.ceil(b);var c=Math.floor((a-d)/b),f=e.data;return{min:d,max:a,from:d,to:c*b+d,step:b,steps:c,unit:1,getLabel:function(g){return f[this.from+this.step*g]},get:function(g){return this.from+this.step*g}}},trimByRange:function(b,f,h,a){var i=f.unit,g=Math.ceil((h-f.from)/i)*i,d=Math.floor((a-f.from)/i)*i,c=Math.max(0,Math.ceil(g/f.step)),e=Math.min(f.steps,Math.floor(d/f.step));if(e<f.steps){f.to=e}if(f.max>a){f.max=f.to}if(f.from<h&&f.step>0){f.from=f.from+c*f.step*i;while(f.from<h){c++;f.from+=f.step*i}}if(f.min<h){f.min=f.from}f.steps=e-c},getCoordFor:function(c,d,a,b){this.labels.push(c);return this.labels.length-1}});Ext.define("Ext.chart.axis.layout.CombineDuplicate",{extend:"Ext.chart.axis.layout.Discrete",alias:"axisLayout.combineDuplicate",getCoordFor:function(d,e,b,c){if(!(d in this.labelMap)){var a=this.labelMap[d]=this.labels.length;this.labels.push(d);return a}return this.labelMap[d]}});Ext.define("Ext.chart.axis.layout.Continuous",{extend:"Ext.chart.axis.layout.Layout",alias:"axisLayout.continuous",config:{adjustMinimumByMajorUnit:false,adjustMaximumByMajorUnit:false},getCoordFor:function(c,d,a,b){return +c},snapEnds:function(a,d,i,h){var f=a.segmenter,c=this.getAxis(),l=c.getMajorTickSteps(),e=l&&f.exactStep?f.exactStep(d,(i-d)/l):f.preferredStep(d,h),k=e.unit,b=e.step,j=f.align(d,b,k),g=f.diff(d,i,k)+1;return{min:f.from(d),max:f.from(i),from:j,to:f.add(j,g*b,k),step:b,steps:g,unit:k,get:function(m){return f.add(this.from,this.step*m,k)}}},snapMinorEnds:function(a){var e=a.majorTicks,m=this.getAxis().getMinorTickSteps(),f=a.segmenter,d=e.min,i=e.max,k=e.from,l=e.unit,b=e.step/m,n=b*l.scale,j=k-d,c=Math.floor(j/n),h=c+Math.floor((i-e.to)/n)+1,g=e.steps*m+h;return{min:d,max:i,from:d+j%n,to:f.add(k,g*b,l),step:b,steps:g,unit:l,get:function(o){return(o%m+c+1!==0)?f.add(this.from,this.step*o,l):null}}}});Ext.define("Ext.chart.axis.Axis",{xtype:"axis",mixins:{observable:"Ext.mixin.Observable"},requires:["Ext.chart.axis.sprite.Axis","Ext.chart.axis.segmenter.*","Ext.chart.axis.layout.*"],config:{position:"bottom",fields:[],label:undefined,grid:false,limits:null,renderer:null,chart:null,style:null,margin:0,titleMargin:4,background:null,minimum:NaN,maximum:NaN,reconcileRange:false,minZoom:1,maxZoom:10000,layout:"continuous",segmenter:"numeric",hidden:false,majorTickSteps:0,minorTickSteps:0,adjustByMajorUnit:true,title:null,increment:0.5,length:0,center:null,radius:null,totalAngle:Math.PI,rotation:null,labelInSpan:null,visibleRange:[0,1],needHighPrecision:false,linkedTo:null,floating:null},titleOffset:0,animating:0,prevMin:0,prevMax:1,boundSeries:[],sprites:null,surface:null,range:null,xValues:[],yValues:[],masterAxis:null,applyRotation:function(b){var a=Math.PI*2;return(b%a+Math.PI)%a-Math.PI},updateRotation:function(b){var c=this.getSprites(),a=this.getPosition();if(!this.getHidden()&&a==="angular"&&c[0]){c[0].setAttributes({baseRotation:b})}},applyTitle:function(c,b){var a;if(Ext.isString(c)){c={text:c}}if(!b){b=Ext.create("sprite.text",c);if((a=this.getSurface())){a.add(b)}}else{b.setAttributes(c)}return b},applyFloating:function(b,a){if(b===null){b={value:null,alongAxis:null}}else{if(Ext.isNumber(b)){b={value:b,alongAxis:null}}}if(Ext.isObject(b)){if(a&&a.alongAxis){delete this.getChart().getAxis(a.alongAxis).floatingAxes[this.getId()]}return b}return a},constructor:function(a){var b=this,c;b.sprites=[];b.labels=[];b.floatingAxes={};if(a.position==="angular"){a.style=a.style||{};a.style.estStepSize=1}if("id" in a){c=a.id}else{if("id" in b.config){c=b.config.id}else{c=b.getId()}}b.id=c;b.setId(c);b.mixins.observable.constructor.apply(b,arguments);Ext.ComponentManager.register(b);this.initConfig(a)},getAlignment:function(){switch(this.getPosition()){case"left":case"right":return"vertical";case"top":case"bottom":return"horizontal";case"radial":return"radial";case"angular":return"angular"}},getGridAlignment:function(){switch(this.getPosition()){case"left":case"right":return"horizontal";case"top":case"bottom":return"vertical";case"radial":return"circular";case"angular":return"radial"}},getSurface:function(){var e=this,d=e.getChart();if(d&&!e.surface){var b=e.surface=d.getSurface(e.getId(),"axis"),c=e.gridSurface=d.getSurface("main"),a=e.getSprites()[0],f=e.getGridAlignment();c.waitFor(b);e.getGrid();if(e.getLimits()){e.limits={surface:d.getSurface("overlay"),lines:new Ext.chart.Markers(),titles:new Ext.draw.sprite.Instancing()};e.limits.lines.setTemplate({xclass:"grid."+f});e.limits.lines.getTemplate().setAttributes({strokeStyle:"black"});e.limits.surface.add(e.limits.lines);a.bindMarker(f+"-limit-lines",e.limits.lines);e.limitTitleTpl=new Ext.draw.sprite.Text();e.limits.titles.setTemplate(e.limitTitleTpl);e.limits.surface.add(e.limits.titles);d.on("redraw",e.renderLimits,e)}}return e.surface},updateGrid:function(b){var e=this,d=e.getChart();if(!d){e.on({chartattached:Ext.bind(e.updateGrid,e,[b]),single:true});return}var c=e.gridSurface,g;var a=e.getSprites()[0],f=e.getGridAlignment();if(b){g=e.gridSpriteEven;if(!g){g=e.gridSpriteEven=new Ext.chart.Markers();c.add(g);a.bindMarker(f+"-even",g)}g.setTemplate({xclass:"grid."+f});if(Ext.isObject(b)){g.getTemplate().setAttributes(b);if(Ext.isObject(b.even)){g.getTemplate().setAttributes(b.even)}}g=e.gridSpriteOdd;if(!g){g=e.gridSpriteOdd=new Ext.chart.Markers();c.add(g);a.bindMarker(f+"-odd",g)}g.setTemplate({xclass:"grid."+f});if(Ext.isObject(b)){g.getTemplate().setAttributes(b);if(Ext.isObject(b.odd)){g.getTemplate().setAttributes(b.odd)}}}},renderLimits:function(){this.getSprites()[0].renderLimits()},getCoordFor:function(c,d,a,b){return this.getLayout().getCoordFor(c,d,a,b)},applyPosition:function(a){return a.toLowerCase()},applyLength:function(b,a){return b>0?b:a},applyLabel:function(b,a){if(!a){a=new Ext.draw.sprite.Text({})}if(this.limitTitleTpl){this.limitTitleTpl.setAttributes(b)}a.setAttributes(b);return a},applyLayout:function(b,a){b=Ext.factory(b,null,a,"axisLayout");b.setAxis(this);return b},applySegmenter:function(a,b){a=Ext.factory(a,null,b,"segmenter");a.setAxis(this);return a},updateMinimum:function(){this.range=null},updateMaximum:function(){this.range=null},hideLabels:function(){this.getSprites()[0].setDirty(true);this.setLabel({hidden:true})},showLabels:function(){this.getSprites()[0].setDirty(true);this.setLabel({hidden:false})},renderFrame:function(){this.getSurface().renderFrame()},updateChart:function(d,b){var c=this,a;if(b){b.un("serieschange",c.onSeriesChange,c);c.linkAxis();c.fireEvent("chartdetached",b,c)}if(d){d.on("serieschange",c.onSeriesChange,c);c.surface=null;a=c.getSurface();c.getLabel().setSurface(a);a.add(c.getSprites());a.add(c.getTitle());c.fireEvent("chartattached",d,c)}},applyBackground:function(a){var b=Ext.ClassManager.getByAlias("sprite.rect");return b.def.normalize(a)},processData:function(){this.getLayout().processData();this.range=null},getDirection:function(){return this.getChart().getDirectionForAxis(this.getPosition())},isSide:function(){var a=this.getPosition();return a==="left"||a==="right"},applyFields:function(a){return Ext.Array.from(a)},applyVisibleRange:function(a,c){if(a[0]>a[1]){var b=a[0];a[0]=a[1];a[0]=b}if(a[1]===a[0]){a[1]+=1/this.getMaxZoom()}if(a[1]>a[0]+1){a[0]=0;a[1]=1}else{if(a[0]<0){a[1]-=a[0];a[0]=0}else{if(a[1]>1){a[0]-=a[1]-1;a[1]=1}}}if(c&&a[0]===c[0]&&a[1]===c[1]){return undefined}return a},updateVisibleRange:function(a){this.fireEvent("transformed",this,a)},onSeriesChange:function(e){var f=this,b=e.getSeries(),j="get"+f.getDirection()+"Axis",g=[],c,d=b.length,a,h;for(c=0;c<d;c++){if(this===b[c][j]()){g.push(b[c])}}f.boundSeries=g;a=f.getLinkedTo();h=a&&e.getAxis(a);if(h){f.linkAxis(h)}else{f.getLayout().processData()}},linkAxis:function(a){var c=this;function b(f,d,e){e.getLayout()[f]("datachange","onDataChange",d);e[f]("rangechange","onRangeChange",d)}if(c.masterAxis){b("un",c,c.masterAxis);c.masterAxis=null}if(a){if(a.type!==this.type){throw"Linked axes must be of the same type."}b("on",c,a);c.onDataChange(a.getLayout().labels);c.onRangeChange(a.range);c.setStyle(Ext.apply({},c.config.style,a.config.style));c.setTitle(Ext.apply({},c.config.title,a.config.title));c.setLabel(Ext.apply({},c.config.label,a.config.label));c.masterAxis=a}},onDataChange:function(a){this.getLayout().labels=a},onRangeChange:function(a){this.range=a},applyRange:function(a){if(!a){return this.dataRange.slice(0)}else{return[a[0]===null?this.dataRange[0]:a[0],a[1]===null?this.dataRange[1]:a[1]]}},getRange:function(){var m=this,b="get"+m.getDirection()+"Range";if(m.range){return m.range}if(!isNaN(m.getMinimum())&&!isNaN(m.getMaximum())){return m.range=[m.getMinimum(),m.getMaximum()]}var d=Infinity,n=-Infinity,o=m.boundSeries,h=m.getLayout(),l=m.getSegmenter(),p=m.getVisibleRange(),a,j,g,f,e,k;for(e=0,k=o.length;e<k;e++){f=o[e];var c=f[b]();if(c){if(c[0]<d){d=c[0]}if(c[1]>n){n=c[1]}}}if(!isFinite(n)){n=m.prevMax}if(!isFinite(d)){d=m.prevMin}if(m.getLabelInSpan()||d===n){n+=m.getIncrement();d-=m.getIncrement()}if(!isNaN(m.getMinimum())){d=m.getMinimum()}else{m.prevMin=d}if(!isNaN(m.getMaximum())){n=m.getMaximum()}else{m.prevMax=n}m.range=[d,n];if(m.getReconcileRange()){m.reconcileRange()}if(m.getAdjustByMajorUnit()&&l.adjustByMajorUnit&&!m.getMajorTickSteps()){j=Ext.Object.chain(m.getSprites()[0].attr);j.min=m.range[0];j.max=m.range[1];j.visibleMin=p[0];j.visibleMax=p[1];a={attr:j,segmenter:l};h.calculateLayout(a);g=a.majorTicks;if(g){l.adjustByMajorUnit(g.step,g.unit.scale,m.range);j.min=m.range[0];j.max=m.range[1];delete a.majorTicks;h.calculateLayout(a);g=a.majorTicks;l.adjustByMajorUnit(g.step,g.unit.scale,m.range)}else{if(!m.hasClearRangePending){m.hasClearRangePending=true;m.getChart().on("layout","clearRange",m)}}}m.fireEvent("rangechange",m.range);return m.range},clearRange:function(){delete this.hasClearRangePending;this.range=null},reconcileRange:function(){var e=this,g=e.getChart().getAxes(),f=e.getDirection(),b,d,c,a;if(!g){return}for(b=0,d=g.length;b<d;b++){c=g[b];a=c.getRange();if(c===e||c.getDirection()!==f||!a||!c.getReconcileRange()){continue}if(a[0]<e.range[0]){e.range[0]=a[0]}if(a[1]>e.range[1]){e.range[1]=a[1]}}},applyStyle:function(c,b){var a=Ext.ClassManager.getByAlias("sprite."+this.seriesType);if(a&&a.def){c=a.def.normalize(c)}b=Ext.apply(b||{},c);return b},updateTheme:function(c){var g=this,i=c.getAxis(),d=g.getPosition(),m=g.getInitialConfig(),b=g.defaultConfig,f=g.getConfigurator().configs,a=i.defaults,l=i[d],j,h,n,k,e;i=Ext.merge({},a,l);for(j in i){h=i[j];e=f[j];if(h!==null&&h!==undefined&&e){k=m[j];n=Ext.isObject(h);if(k===b[j]||n){if(n){h=Ext.merge({},h,k)}g[e.names.set](h)}}}},updateCenter:function(b){var e=this.getSprites(),a=e[0],d=b[0],c=b[1];if(a){a.setAttributes({centerX:d,centerY:c})}if(this.gridSpriteEven){this.gridSpriteEven.getTemplate().setAttributes({translationX:d,translationY:c,rotationCenterX:d,rotationCenterY:c})}if(this.gridSpriteOdd){this.gridSpriteOdd.getTemplate().setAttributes({translationX:d,translationY:c,rotationCenterX:d,rotationCenterY:c})}},getSprites:function(){if(!this.getChart()){return}var g=this,b=g.masterAxis?g.masterAxis.range:g.getRange(),a=g.getPosition(),e=g.getChart(),h=e.getAnimation(),d,c,f=g.getLength();if(h===false){h={duration:0}}if(b){c=Ext.applyIf({position:a,axis:g,min:b[0],max:b[1],length:f,grid:g.getGrid(),hidden:g.getHidden(),titleOffset:g.titleOffset,layout:g.getLayout(),segmenter:g.getSegmenter(),totalAngle:g.getTotalAngle(),label:g.getLabel()},g.getStyle());if(!g.sprites.length){d=new Ext.chart.axis.sprite.Axis(c);d.fx.setCustomDurations({baseRotation:0});d.fx.on("animationstart","onAnimationStart",g);d.fx.on("animationend","onAnimationEnd",g);d.setLayout(g.getLayout());d.setSegmenter(g.getSegmenter());d.setLabel(g.getLabel());g.sprites.push(d);g.updateTitleSprite()}else{d=g.sprites[0];d.fx.setConfig(h);d.setAttributes(c)}if(g.getRenderer()){d.setRenderer(g.getRenderer())}}return g.sprites},updateTitleSprite:function(){if(!this.sprites[0]||isNaN(this.getLength())){return}var f=this,h=this.sprites[0].thickness,a=f.getSurface(),g=f.getTitle(),e=f.getPosition(),c=f.getMargin(),i=f.getTitleMargin(),b=f.getLength(),d=a.roundPixel(b/2);if(g){switch(e){case"top":g.setAttributes({x:d,y:c+i/2,textBaseline:"top",textAlign:"center"},true,true);g.applyTransformations();f.titleOffset=g.getBBox().height+i;break;case"bottom":g.setAttributes({x:d,y:h+i/2,textBaseline:"top",textAlign:"center"},true,true);g.applyTransformations();f.titleOffset=g.getBBox().height+i;break;case"left":g.setAttributes({x:c+i/2,y:d,textBaseline:"top",textAlign:"center",rotationCenterX:c+i/2,rotationCenterY:d,rotationRads:-Math.PI/2},true,true);g.applyTransformations();f.titleOffset=g.getBBox().width+i;break;case"right":g.setAttributes({x:h-c+i/2,y:d,textBaseline:"bottom",textAlign:"center",rotationCenterX:h+i/2,rotationCenterY:d,rotationRads:Math.PI/2},true,true);g.applyTransformations();f.titleOffset=g.getBBox().width+i;break}}},onThicknessChanged:function(){this.getChart().onThicknessChanged()},getThickness:function(){if(this.getHidden()){return 0}return(this.sprites[0]&&this.sprites[0].thickness||1)+this.titleOffset+this.getMargin()},onAnimationStart:function(){this.animating++;if(this.animating===1){this.fireEvent("animationstart")}},onAnimationEnd:function(){this.animating--;if(this.animating===0){this.fireEvent("animationend")}},getItemId:function(){return this.getId()},getAncestorIds:function(){return[this.getChart().getId()]},isXType:function(a){return a==="axis"},destroy:function(){var a=this.getChart();if(a){a.un("redraw",this.renderLimits,this)}this.linkAxis();Ext.ComponentManager.unregister(this);this.callParent()}});Ext.define("Ext.chart.LegendBase",{extend:"Ext.view.View",config:{tpl:['<div class="',Ext.baseCSSPrefix,'legend-container">','<tpl for=".">','<div class="',Ext.baseCSSPrefix,'legend-item">',"<span ",'class="',Ext.baseCSSPrefix,"legend-item-marker {[ values.disabled ? Ext.baseCSSPrefix + 'legend-inactive' : '' ]}\" ",'style="background:{mark};">',"</span>{name}","</div>","</tpl>","</div>"],nodeContainerSelector:"div."+Ext.baseCSSPrefix+"legend-container",itemSelector:"div."+Ext.baseCSSPrefix+"legend-item",docked:"bottom"},setDocked:function(c){var a=this.ownerCt,b;this.docked=c;switch(c){case"top":case"bottom":this.addCls("x-horizontal");b="hbox";break;case"left":case"right":this.removeCls("x-horizontal");b="vbox";break}if(a){a.setDocked(c)}},setStore:function(a){this.bindStore(a)},onItemClick:function(a,c,b,d){this.callParent(arguments);this.toggleItem(b)}});Ext.define("Ext.chart.Legend",{xtype:"legend",extend:"Ext.chart.LegendBase",config:{baseCls:"x-legend",padding:5,rect:null,disableSelection:true,toggleable:true},toggleItem:function(c){if(this.getToggleable()){var b=this.getStore(),a=b&&b.getAt(c);if(a){a.set("disabled",!a.get("disabled"))}}}});Ext.define("Ext.chart.AbstractChart",{extend:"Ext.draw.Container",requires:["Ext.chart.theme.Default","Ext.chart.series.Series","Ext.chart.interactions.Abstract","Ext.chart.axis.Axis","Ext.data.StoreManager","Ext.chart.Legend","Ext.data.Store"],defaultBindProperty:"store",version:"2.5.0",delegationRegex:/^item([a-z]+)$/i,domEvents:new RegExp("click|focus|blur|paste|input|mousemove|mousedown|mouseup|mouseover|mouseout|keyup|keydown|keypress|submit|pinch|pinchstart|pinchend|touchmove|touchstart|touchend|rotate|rotatestart|rotateend|drag|dragstart|dragend|tap|doubletap|singletap"),config:{store:"ext-empty-store",theme:"default",style:null,shadow:false,animation:!Ext.isIE8,series:[],axes:[],legend:null,colors:null,insetPadding:{top:10,left:10,right:10,bottom:10},background:null,interactions:[],mainRect:null,resizeHandler:null,highlightItem:null},resizing:0,animationSuspended:0,surfaceZIndexes:{background:0,main:1,grid:2,series:3,axis:4,chart:5,overlay:6,events:7},animating:0,layoutSuspended:0,applyAnimation:function(a,b){if(!a){a={duration:0}}else{if(a===true){a={easing:"easeInOut",duration:500}}}return b?Ext.apply({},a,b):a},applyInsetPadding:function(b,a){if(!Ext.isObject(b)){return Ext.util.Format.parseBox(b)}else{if(!a){return b}else{return Ext.apply(a,b)}}},suspendAnimation:function(){this.animationSuspended++;if(this.animationSuspended===1){var b=this.getSeries(),a=-1,c=b.length;while(++a<c){b[a].setAnimation(this.getAnimation())}}},resumeAnimation:function(){this.animationSuspended--;if(this.animationSuspended===0){var b=this.getSeries(),a=-1,c=b.length;while(++a<c){b[a].setAnimation(this.getAnimation())}}},suspendChartLayout:function(){this.layoutSuspended++;if(this.layoutSuspended===1){if(this.scheduledLayoutId){this.layoutInSuspension=true;this.cancelLayout()}else{this.layoutInSuspension=false}}},resumeChartLayout:function(){this.layoutSuspended--;if(this.layoutSuspended===0){if(this.layoutInSuspension){this.scheduleLayout()}}},cancelLayout:function(){if(this.scheduledLayoutId){Ext.draw.Animator.cancel(this.scheduledLayoutId);this.scheduledLayoutId=null}},scheduleLayout:function(){var a=this;if(a.rendered&&!a.scheduledLayoutId){a.scheduledLayoutId=Ext.draw.Animator.schedule("doScheduleLayout",a)}},doScheduleLayout:function(){if(this.layoutSuspended){this.layoutInSuspension=true}else{this.performLayout()}},getAnimation:function(){if(this.resizing||this.animationSuspended){return{duration:0}}else{return this.callParent()}},constructor:function(a){var b=this;b.itemListeners={};b.surfaceMap={};b.isInitializing=true;b.suspendChartLayout();b.callParent(arguments);delete b.isInitializing;b.getSurface("main");b.getSurface("chart").setFlipRtlText(b.getInherited().rtl);b.getSurface("overlay").waitFor(b.getSurface("series"));b.resumeChartLayout()},applySprites:function(b){var a=this.getSurface("chart");b=Ext.Array.from(b);a.removeAll(true);a.add(b)},initItems:function(){var a=this.items,b,d,c;if(a&&!a.isMixedCollection){this.items=[];a=Ext.Array.from(a);for(b=0,d=a.length;b<d;b++){c=a[b];if(c.type){Ext.Error.raise("To add custom sprites to the chart use the 'sprites' config.")}else{this.items.push(c)}}}this.callParent()},applyBackground:function(b,c){var a=this.getSurface("background");if(b){a.remove(c,true);if(b.type==="image"&&Ext.isString(b.src)){c=a.add(b)}else{c=a.add({type:"rect",fillStyle:b})}}return c},getLegendStore:function(){return this.legendStore},refreshLegendStore:function(){if(this.getLegendStore()){var d,e,c=this.getSeries(),b,a=[];if(c){for(d=0,e=c.length;d<e;d++){b=c[d];if(b.getShowInLegend()){b.provideLegendInfo(a)}}}this.getLegendStore().setData(a)}},resetLegendStore:function(){if(this.getLegendStore()){var d=this.getLegendStore().getData().items,b,c=d.length,a;for(b=0;b<c;b++){a=d[b];a.beginEdit();a.set("disabled",false);a.commit()}}},onUpdateLegendStore:function(b,a){var d=this.getSeries(),c;if(a&&d){c=d.map[a.get("series")];if(c){c.setHiddenByIndex(a.get("index"),a.get("disabled"));this.redraw()}}},resizeHandler:function(a){var b=this;b.scheduleLayout();return false},applyMainRect:function(a,b){if(!b){return a}this.getSeries();this.getAxes();if(a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]&&a[3]===b[3]){return b}else{return a}},getAxis:function(a){if(a instanceof Ext.chart.axis.Axis){return a}else{if(Ext.isNumber(a)){return this.getAxes()[a]}else{if(Ext.isString(a)){return Ext.ComponentMgr.get(a)}else{return null}}}},getSurface:function(b,c){b=b||"main";c=c||b;var d=this,a=this.callParent([b]),e=d.surfaceZIndexes;if(c in e){a.element.setStyle("zIndex",e[c])}if(!d.surfaceMap[c]){d.surfaceMap[c]=[]}if(Ext.Array.indexOf(d.surfaceMap[c],(a))<0){a.type=c;d.surfaceMap[c].push(a)}return a},applyAxes:function(b,k){this.resizing++;this.getStore();if(!k){k=[];k.map={}}var l=[],g,h,c,d,e,a,f={left:"right",right:"left"},j=k.map;l.map={};b=Ext.Array.from(b,true);for(g=0,h=b.length;g<h;g++){c=Ext.Object.chain(b[g]);if(!c){continue}e=c.linkedTo;a=c.id;if(Ext.isNumber(e)){c=Ext.merge({},b[e],c)}else{if(Ext.isString(e)){Ext.Array.each(b,function(i){if(i.id===c.linkedTo){c=Ext.merge({},i,c);return false}})}}c.id=a;if(this.getInherited().rtl){c.position=f[c.position]||c.position}c=Ext.factory(c,null,d=j[c.getId&&c.getId()||c.id],"axis");if(c){c.setChart(this);l.push(c);l.map[c.getId()]=c;if(!d){c.on("animationstart","onAnimationStart",this);c.on("animationend","onAnimationEnd",this)}}}for(g in j){if(!l.map[g]){j[g].destroy()}}this.resizing--;return l},updateAxes:function(a){this.scheduleLayout()},circularCopyArray:function(e,f,d){var c=[],b,a=e&&e.length;if(a){for(b=0;b<d;b++){c.push(e[(f+b)%a])}}return c},circularCopyObject:function(f,g,d){var c=this,b,e,a={};if(d){for(b in f){if(f.hasOwnProperty(b)){e=f[b];if(Ext.isArray(e)){a[b]=c.circularCopyArray(e,g,d)}else{a[b]=e}}}}return a},getColors:function(){var b=this,a=b.config.colors,c=b.getTheme();if(Ext.isArray(a)&&a.length>0){a=b.applyColors(a)}return a||(c&&c.getColors())},applyColors:function(a){a=Ext.Array.map(a,function(b){if(Ext.isString(b)){return b}else{return b.toString()}});return a},updateColors:function(c){var k=this,f=k.getTheme(),a=c||(f&&f.getColors()),m=a.length,l=0,g=k.getSeries(),d=g&&g.length,e,j,b,h;if(m){for(e=0;e<d;e++){j=g[e];h=j.themeColorCount();b=k.circularCopyArray(a,l,h);l+=h;j.updateChartColors(b)}}k.refreshLegendStore()},applyTheme:function(a){if(a&&a.isTheme){return a}return Ext.Factory.chartTheme(a)},updateTheme:function(d){var k=this,h=k.getAxes(),e=k.getSeries(),a=k.getColors(),j,b,m=0,g=0,f,l,c;k.updateChartTheme(d);for(c=0;c<h.length;c++){h[c].updateTheme(d)}for(c=0;c<e.length;c++){e[c].updateTheme(d);j=e[c];b={};if(d.getSeriesThemes){l=j.themeColorCount();b.subStyle=k.circularCopyObject(d.getSeriesThemes(),m,l);m+=l}else{b.subStyle={}}if(d.getMarkerThemes){f=j.themeMarkerCount();b.markerSubStyle=k.circularCopyObject(d.getMarkerThemes(),g,f);g+=f}else{b.markerSubStyle={}}}k.updateSpriteTheme(d);k.updateColors(a)},updateChartTheme:function(b){var g=this,i=b.getChart(),l=g.getInitialConfig(),a=g.defaultConfig,d=g.getConfigurator().configs,e=i.defaults,f=i[g.xtype],j,h,m,k,c;i=Ext.merge({},e,f);for(j in i){h=i[j];c=d[j];if(h!==null&&h!==undefined&&c){k=l[j];m=Ext.isObject(h);if(k===a[j]||m){if(m){h=Ext.merge({},h,k)}g[c.names.set](h)}}}},updateSpriteTheme:function(c){var j=this,e=j.getSurface("chart"),h=e.getItems(),m=c.getSprites(),k,a,l,f,d,b,g;for(b=0,g=h.length;b<g;b++){k=h[b];a=m[k.type];if(a){f={};d=k.type==="text";for(l in a){if(!(l in k.config)){if(!(d&&l.indexOf("font")===0&&k.config.font)){f[l]=a[l]}}}k.setAttributes(f)}}},applySeries:function(e,d){var g=this,j=[],h,a,c,f,b;g.resizing++;g.getAxes();if(!d){d=[];h=d.map={}}j.map={};e=Ext.Array.from(e,true);for(c=0,f=e.length;c<f;c++){b=e[c];if(!b){continue}a=d.map[b.getId&&b.getId()||b.id];if(b instanceof Ext.chart.series.Series){if(a!==b){if(a){a.destroy()}g.addItemListenersToSeries(b)}b.setChart(g)}else{if(Ext.isObject(b)){if(a){a.setConfig(b);b=a}else{if(Ext.isString(b)){b=Ext.create(b.xclass||("series."+b),{chart:g})}else{b.chart=g;b=Ext.create(b.xclass||("series."+b.type),b)}b.on("animationstart","onAnimationStart",g);b.on("animationend","onAnimationEnd",g);g.addItemListenersToSeries(b)}}}j.push(b);j.map[b.getId()]=b}for(c in h){if(!j.map[h[c].getId()]){h[c].destroy()}}g.resizing--;return j},applyLegend:function(b,a){return Ext.factory(b,Ext.chart.Legend,a)},updateLegend:function(b,a){if(a){a.destroy()}if(b){this.getItems();this.legendStore=new Ext.data.Store({autoDestroy:true,fields:["id","name","mark","disabled","series","index"]});b.setStore(this.legendStore);this.refreshLegendStore();this.legendStore.on("update","onUpdateLegendStore",this)}},setParent:function(a){this.callParent(arguments);if(a&&this.getLegend()){a.add(this.getLegend())}},updateSeries:function(b,a){this.resizing++;this.fireEvent("serieschange",this,b,a);this.refreshLegendStore();this.scheduleLayout();this.resizing--},applyInteractions:function(h,d){if(!d){d=[];d.map={}}var g=this,a=[],c=d.map,e,f,b;a.map={};h=Ext.Array.from(h,true);for(e=0,f=h.length;e<f;e++){b=h[e];if(!b){continue}b=Ext.factory(b,null,c[b.getId&&b.getId()||b.id],"interaction");if(b){b.setChart(g);a.push(b);a.map[b.getId()]=b}}for(e in c){if(!a.map[c[e]]){c[e].destroy()}}return a},applyStore:function(a){return a&&Ext.StoreManager.lookup(a)},updateStore:function(a,c){var b=this;if(c){c.unAfter({datachanged:"onDataChanged",update:"onDataChanged",scope:b});if(c.autoDestroy){c.destroy()}}if(a){a.onAfter({datachanged:"onDataChanged",update:"onDataChanged",scope:b})}b.fireEvent("storechange",a,c);b.onDataChanged()},redraw:function(){this.fireEvent("redraw",this)},performLayout:function(){var d=this,b=d.innerElement.getSize(),c=[0,0,b.width,b.height],a=d.getBackground();d.hasFirstLayout=true;d.fireEvent("layout");d.cancelLayout();d.getSurface("background").setRect(c);d.getSurface("chart").setRect(c);a.setAttributes({width:b.width,height:b.height})},getEventXY:function(a){return this.getSurface().getEventXY(a)},getItemForPoint:function(a,h){var g=this,c=g.getSeries(),b=c.length,e=g.hasFirstLayout?b-1:-1,d,f;while(e>=0){d=c[e];f=d.getItemForPoint(a,h);if(f){return f}e--}return null},getItemsForPoint:function(a,h){var g=this,e=g.getSeries(),c,b=[];for(var d=0;d<e.length;d++){c=e[d];var f=c.getItemForPoint(a,h);if(f){b.push(f)}}return b},delayThicknessChanged:0,thicknessChanged:false,suspendThicknessChanged:function(){this.delayThicknessChanged++},resumeThicknessChanged:function(){if(this.delayThicknessChanged>0){this.delayThicknessChanged--;if(this.delayThicknessChanged===0&&this.thicknessChanged){this.onThicknessChanged()}}},onAnimationStart:function(){this.fireEvent("animationstart",this)},onAnimationEnd:function(){this.fireEvent("animationend",this)},onThicknessChanged:function(){if(this.delayThicknessChanged===0){this.thicknessChanged=false;this.performLayout()}else{this.thicknessChanged=true}},onDataChanged:function(){var g=this;if(g.isInitializing){return}var f=g.getMainRect(),b=g.getStore(),d=g.getSeries(),h=g.getAxes(),a=g.getColors(),c,e;if(!b||!h||!d){return}if(!f){g.on({redraw:g.onDataChanged,scope:g,single:true});return}for(c=0,e=d.length;c<e;c++){d[c].processData()}g.updateColors(a);g.redraw()},bindStore:function(a){this.setStore(a)},applyHighlightItem:function(b,a){if(b===a){return}if(Ext.isObject(b)&&Ext.isObject(a)){if(b.sprite===a.sprite&&b.index===a.index){return}}return b},updateHighlightItem:function(b,a){if(a){a.series.setAttributesForItem(a,{highlighted:false})}if(b){b.series.setAttributesForItem(b,{highlighted:true});this.fireEvent("itemhighlight",b)}},addItemListenersToSeries:function(c){for(var a in this.itemListeners){var e=this.itemListeners[a],b,d;for(b=0,d=e.length;b<d;b++){c.addListener.apply(c,e[b])}}},addItemListener:function(a,g,j,k,b){var h=this.itemListeners[a]||(this.itemListeners[a]=[]),d=this.getSeries(),f,c,e;h.push([a,g,j,k,b]);if(d){for(c=0,e=d.length;c<e;c++){f=d[c];f.addListener(a,g,j,k,b)}}},remoteItemListener:function(a,g,j,k,b){var h=this.itemListeners[a],d=this.getSeries(),f,c,e;if(h){for(c=0,e=h.length;c<e;c++){if(h[c].fn===g){h.splice(c,1);if(d){for(c=0,e=d.length;c<e;c++){f=d[c];f.removeListener(a,g,j,k,b)}}break}}}},doAddListener:function(c,e,d,b,a){if(c.match(this.delegationRegex)){return this.addItemListener(c,e,d||this,b,a)}else{if(c.match(this.domEvents)){return this.element.doAddListener.apply(this.element,arguments)}else{return this.callParent(arguments)}}},doRemoveListener:function(c,e,d,b,a){if(c.match(this.delegationRegex)){return this.remoteItemListener(c,e,d||this,b,a)}else{if(c.match(this.domEvents)){return this.element.doRemoveListener.apply(this.element,arguments)}else{return this.callParent(arguments)}}},onItemRemove:function(a){this.callParent(arguments);if(this.surfaceMap){Ext.Array.remove(this.surfaceMap[a.type],a);if(this.surfaceMap[a.type].length===0){delete this.surfaceMap[a.type]}}},destroy:function(){var c=this,a=[],b=c.getLegend();c.surfaceMap=null;c.setHighlightItem(null);c.setSeries(a);c.setAxes(a);c.setInteractions(a);if(b){b.destroy();c.setLegend(null)}c.legendStore=null;c.setStore(null);c.cancelLayout();this.callParent(arguments)},getRefItems:function(b){var g=this,e=g.getSeries(),h=g.getAxes(),a=g.getInteractions(),c=[],d,f;for(d=0,f=e.length;d<f;d++){c.push(e[d]);if(e[d].getRefItems){c.push.apply(c,e[d].getRefItems(b))}}for(d=0,f=h.length;d<f;d++){c.push(h[d]);if(h[d].getRefItems){c.push.apply(c,h[d].getRefItems(b))}}for(d=0,f=a.length;d<f;d++){c.push(a[d]);if(a[d].getRefItems){c.push.apply(c,a[d].getRefItems(b))}}return c}});Ext.define("Ext.chart.overrides.AbstractChart",{override:"Ext.chart.AbstractChart",updateLegend:function(b,a){var c;this.callParent(arguments);if(b){c=b.docked;this.addDocked({dock:c,xtype:"panel",shrinkWrap:true,autoScroll:true,layout:{type:c==="top"||c==="bottom"?"hbox":"vbox",pack:"center"},items:b,cls:Ext.baseCSSPrefix+"legend-panel"})}}});Ext.define("Ext.chart.grid.HorizontalGrid",{extend:"Ext.draw.sprite.Sprite",alias:"grid.horizontal",inheritableStatics:{def:{processors:{x:"number",y:"number",width:"number",height:"number"},defaults:{x:0,y:0,width:1,height:1,strokeStyle:"#DDD"}}},render:function(b,c,e){var a=this.attr,f=b.roundPixel(a.y),d=c.lineWidth*0.5;c.beginPath();c.rect(e[0]-b.matrix.getDX(),f+d,+e[2],a.height);c.fill();c.beginPath();c.moveTo(e[0]-b.matrix.getDX(),f+d);c.lineTo(e[0]+e[2]-b.matrix.getDX(),f+d);c.stroke()}});Ext.define("Ext.chart.grid.VerticalGrid",{extend:"Ext.draw.sprite.Sprite",alias:"grid.vertical",inheritableStatics:{def:{processors:{x:"number",y:"number",width:"number",height:"number"},defaults:{x:0,y:0,width:1,height:1,strokeStyle:"#DDD"}}},render:function(c,d,f){var b=this.attr,a=c.roundPixel(b.x),e=d.lineWidth*0.5;d.beginPath();d.rect(a-e,f[1]-c.matrix.getDY(),b.width,f[3]);d.fill();d.beginPath();d.moveTo(a-e,f[1]-c.matrix.getDY());d.lineTo(a-e,f[1]+f[3]-c.matrix.getDY());d.stroke()}});Ext.define("Ext.chart.CartesianChart",{extend:"Ext.chart.AbstractChart",alternateClassName:"Ext.chart.Chart",requires:["Ext.chart.grid.HorizontalGrid","Ext.chart.grid.VerticalGrid"],config:{flipXY:false,innerRect:[0,0,1,1],innerPadding:{top:0,left:0,right:0,bottom:0}},xtype:["cartesian","chart"],applyInnerPadding:function(b,a){if(!Ext.isObject(b)){return Ext.util.Format.parseBox(b)}else{if(!a){return b}else{return Ext.apply(a,b)}}},getDirectionForAxis:function(a){var b=this.getFlipXY();if(a==="left"||a==="right"){if(b){return"X"}else{return"Y"}}else{if(b){return"Y"}else{return"X"}}},performLayout:function(){this.resizing++;this.callParent();this.suspendThicknessChanged();var A=this,d=A.getSurface("chart").getRect(),o=d[2],n=d[3],z=A.getAxes(),b,q=A.getSeries(),h,l,a,f=A.getInsetPadding(),v=A.getInnerPadding(),r,c,e=Ext.apply({},f),u,p,s,k,m,y,t,x,g,j=A.getInherited().rtl,w=A.getFlipXY();if(o<=0||n<=0){return}for(x=0;x<z.length;x++){b=z[x];l=b.getSurface();m=b.getFloating();y=m?m.value:null;a=b.getThickness();switch(b.getPosition()){case"top":l.setRect([0,e.top+1,o,a]);break;case"bottom":l.setRect([0,n-(e.bottom+a),o,a]);break;case"left":l.setRect([e.left,0,a,n]);break;case"right":l.setRect([o-(e.right+a),0,a,n]);break}if(y===null){e[b.getPosition()]+=a}}o-=e.left+e.right;n-=e.top+e.bottom;u=[e.left,e.top,o,n];e.left+=v.left;e.top+=v.top;e.right+=v.right;e.bottom+=v.bottom;p=o-v.left-v.right;s=n-v.top-v.bottom;A.setInnerRect([e.left,e.top,p,s]);if(p<=0||s<=0){return}A.setMainRect(u);A.getSurface().setRect(u);for(x=0,g=A.surfaceMap.grid&&A.surfaceMap.grid.length;x<g;x++){c=A.surfaceMap.grid[x];c.setRect(u);c.matrix.set(1,0,0,1,v.left,v.top);c.matrix.inverse(c.inverseMatrix)}for(x=0;x<z.length;x++){b=z[x];l=b.getSurface();t=l.matrix;k=t.elements;switch(b.getPosition()){case"top":case"bottom":k[4]=e.left;b.setLength(p);break;case"left":case"right":k[5]=e.top;b.setLength(s);break}b.updateTitleSprite();t.inverse(l.inverseMatrix)}for(x=0,g=q.length;x<g;x++){h=q[x];r=h.getSurface();r.setRect(u);if(w){if(j){r.matrix.set(0,-1,-1,0,v.left+p,v.top+s)}else{r.matrix.set(0,-1,1,0,v.left,v.top+s)}}else{r.matrix.set(1,0,0,-1,v.left,v.top+s)}r.matrix.inverse(r.inverseMatrix);h.getOverlaySurface().setRect(u)}A.redraw();A.onPlaceWatermark(d[2],d[3]);this.resizing--;this.resumeThicknessChanged()},refloatAxes:function(){var h=this,g=h.getAxes(),c,d,n,f,l,b,k,p=h.innerElement.getSize(),o=h.getInsetPadding(),a=p.width-o.left-o.right,m=p.height-o.top-o.bottom,j;for(var e=0;e<g.length;e++){c=g[e];f=c.getFloating();l=f?f.value:null;if(l!==null){d=c.getSurface();n=d.getRect();if(!n){continue}n=n.slice();b=h.getAxis(f.alongAxis);if(b){j=b.getAlignment()==="horizontal";if(Ext.isString(l)){l=b.getCoordFor(l)}b.floatingAxes[c.getId()]=l;k=b.getSprites()[0].attr.matrix;if(j){l=l*k.getXX()+k.getDX()}else{l=l*k.getYY()+k.getDY()}}else{j=c.getAlignment()==="horizontal";l=d.roundPixel(0.01*l*(j?m:a))}switch(c.getPosition()){case"top":n[1]=o.top+l-n[3]+1;break;case"bottom":n[1]=o.top+(b?l:m-l);break;case"left":n[0]=o.left+l-n[2]+1;break;case"right":n[0]=o.left+(b?l:a-l)-1;break}d.setRect(n)}}},redraw:function(){var D=this,m=D.getSeries(),A=D.getAxes(),b=D.getMainRect(),s,v,x=D.getInnerPadding(),h,o,u,f,t,B,w,e,c,a,n,q,z=D.getFlipXY(),r,p,y=1000,C,l,k,g,d;if(!b){return}s=b[2]-x.left-x.right;v=b[3]-x.top-x.bottom;for(B=0;B<m.length;B++){if((c=m[B].getXAxis())){q=c.getVisibleRange();o=c.getRange();o=[o[0]+(o[1]-o[0])*q[0],o[0]+(o[1]-o[0])*q[1]]}else{o=m[B].getXRange()}if((a=m[B].getYAxis())){q=a.getVisibleRange();u=a.getRange();u=[u[0]+(u[1]-u[0])*q[0],u[0]+(u[1]-u[0])*q[1]]}else{u=m[B].getYRange()}t={visibleMinX:o[0],visibleMaxX:o[1],visibleMinY:u[0],visibleMaxY:u[1],innerWidth:s,innerHeight:v,flipXY:z};h=m[B].getSprites();for(w=0;w<h.length;w++){r=h[w];p=(r.attr.zIndex||0);if(p<y){p+=(B+1)*100+y;r.attr.zIndex=p;C=r.boundMarkers;if(C){l=(C.items?C.items.length:0);if(l){for(k=0;k<l;k++){g=C.items[k];d=(g.attr.zIndex||0);if(d==Number.MAX_VALUE){g.attr.zIndex=p}else{if(d<y){g.attr.zIndex=p+d}}}}}}r.setAttributes(t,true)}}for(B=0;B<A.length;B++){e=A[B];f=e.isSide();h=e.getSprites();n=e.getRange();q=e.getVisibleRange();t={dataMin:n[0],dataMax:n[1],visibleMin:q[0],visibleMax:q[1]};if(f){t.length=v;t.startGap=x.bottom;t.endGap=x.top}else{t.length=s;t.startGap=x.left;t.endGap=x.right}for(w=0;w<h.length;w++){h[w].setAttributes(t,true)}}D.renderFrame();D.callParent(arguments)},renderFrame:function(){this.refloatAxes();this.callParent(arguments)},onPlaceWatermark:function(c,a){var e=this,b=e.watermarkElement,d=b&&(e.getSurface?e.getSurface("main").getRect():e.getItems().get(0).getRect());if(d){b.setStyle({right:Math.round(c-(d[2]+d[0]))+"px",bottom:Math.round(a-(d[3]+d[1]))+"px"})}}});Ext.define("Ext.chart.grid.CircularGrid",{extend:"Ext.draw.sprite.Circle",alias:"grid.circular",inheritableStatics:{def:{defaults:{r:1,strokeStyle:"#DDD"}}}});Ext.define("Ext.chart.grid.RadialGrid",{extend:"Ext.draw.sprite.Path",alias:"grid.radial",inheritableStatics:{def:{processors:{startRadius:"number",endRadius:"number"},defaults:{startRadius:0,endRadius:1,scalingCenterX:0,scalingCenterY:0,strokeStyle:"#DDD"},dirtyTriggers:{startRadius:"path,bbox",endRadius:"path,bbox"}}},render:function(){this.callParent(arguments)},updatePath:function(d,a){var b=a.startRadius,c=a.endRadius;d.moveTo(b,0);d.lineTo(c,0)}});Ext.define("Ext.chart.PolarChart",{requires:["Ext.chart.grid.CircularGrid","Ext.chart.grid.RadialGrid"],extend:"Ext.chart.AbstractChart",xtype:"polar",config:{center:[0,0],radius:0,innerPadding:0},getDirectionForAxis:function(a){if(a==="radial"){return"Y"}else{return"X"}},applyCenter:function(a,b){if(b&&a[0]===b[0]&&a[1]===b[1]){return}return[+a[0],+a[1]]},updateCenter:function(a){var g=this,h=g.getAxes(),e,d=g.getSeries(),b,c,f;for(c=0,f=h.length;c<f;c++){e=h[c];e.setCenter(a)}for(c=0,f=d.length;c<f;c++){b=d[c];b.setCenter(a)}},applyInnerPadding:function(b,a){return Ext.isNumber(b)?b:a},doSetSurfaceRect:function(b,c){var a=this.getMainRect();b.setRect(c);b.matrix.set(1,0,0,1,a[0]-c[0],a[1]-c[1]);b.inverseMatrix.set(1,0,0,1,c[0]-a[0],c[1]-a[1])},applyAxes:function(f,h){var e=this,g=Ext.Array.from(e.config.series)[0],b,d,c,a;if(g.type==="radar"&&f&&f.length){for(b=0,d=f.length;b<d;b++){c=f[b];if(c.position==="angular"){a=true;break}}if(!a){f.push({type:"category",position:"angular",fields:g.xField||g.angleField,style:{estStepSize:1},grid:true})}}return this.callParent(arguments)},performLayout:function(){try{this.resizing++;this.callParent();this.suspendThicknessChanged();var E=this,g=E.getSurface("chart").getRect(),u=E.getInsetPadding(),F=E.getInnerPadding(),k=Ext.apply({},u),d,r=g[2]-u.left-u.right,q=g[3]-u.top-u.bottom,w=[u.left,u.top,r,q],t=E.getSeries(),o,s=r-F*2,v=q-F*2,C=[s*0.5+F,v*0.5+F],h=Math.min(s,v)*0.5,z=E.getAxes(),f,a,j,l=[],n=[],D=h-F,y,m,b,p,x,c,B;E.setMainRect(w);E.doSetSurfaceRect(E.getSurface(),w);for(y=0,m=E.surfaceMap.grid&&E.surfaceMap.grid.length;y<m;y++){E.doSetSurfaceRect(E.surfaceMap.grid[y],g)}for(y=0,m=z.length;y<m;y++){f=z[y];switch(f.getPosition()){case"angular":l.push(f);break;case"radial":n.push(f);break}}for(y=0,m=l.length;y<m;y++){f=l[y];p=f.getFloating();x=p?p.value:null;E.doSetSurfaceRect(f.getSurface(),g);a=f.getThickness();for(d in k){k[d]+=a}r=g[2]-k.left-k.right;q=g[3]-k.top-k.bottom;b=Math.min(r,q)*0.5;if(y===0){D=b-F}f.setMinimum(0);f.setLength(b);f.getSprites();j=f.sprites[0].attr.lineWidth*0.5;for(d in k){k[d]+=j}}for(y=0,m=n.length;y<m;y++){f=n[y];E.doSetSurfaceRect(f.getSurface(),w);f.setMinimum(0);f.setLength(D);f.getSprites()}for(y=0,m=t.length;y<m;y++){o=t[y];if(o.type==="gauge"&&!c){c=o}else{o.setRadius(D)}E.doSetSurfaceRect(o.getSurface(),w)}E.doSetSurfaceRect(E.getSurface("overlay"),g);if(c){c.setRect(w);B=c.getRadius()-F;E.setRadius(B);E.setCenter(c.getCenter());c.setRadius(B);if(z.length&&z[0].getPosition()==="gauge"){f=z[0];E.doSetSurfaceRect(f.getSurface(),g);f.setTotalAngle(c.getTotalAngle());f.setLength(B)}}else{E.setRadius(h);E.setCenter(C)}E.redraw()}catch(A){throw A}finally{this.resizing--;this.resumeThicknessChanged()}},refloatAxes:function(){var j=this,g=j.getAxes(),h=j.getMainRect(),f,k,b,d,a,c,e;if(!h){return}e=0.5*Math.min(h[2],h[3]);for(d=0,a=g.length;d<a;d++){c=g[d];f=c.getFloating();k=f?f.value:null;if(k!==null){b=j.getAxis(f.alongAxis);if(c.getPosition()==="angular"){if(b){k=b.getLength()*k/b.getRange()[1]}else{k=0.01*k*e}c.sprites[0].setAttributes({length:k},true)}else{if(b){if(Ext.isString(k)){k=b.getCoordFor(k)}k=k/(b.getRange()[1]+1)*Math.PI*2-Math.PI*1.5+c.getRotation()}else{k=Ext.draw.Draw.rad(k)}c.sprites[0].setAttributes({baseRotation:k},true)}}}},redraw:function(){var f=this,g=f.getAxes(),d,c=f.getSeries(),a,b,e;for(b=0,e=g.length;b<e;b++){d=g[b];d.getSprites()}for(b=0,e=c.length;b<e;b++){a=c[b];a.getSprites()}f.renderFrame();f.callParent(arguments)},renderFrame:function(){this.refloatAxes();this.callParent(arguments)}});Ext.define("Ext.chart.SpaceFillingChart",{extend:"Ext.chart.AbstractChart",xtype:"spacefilling",config:{},performLayout:function(){try{this.resizing++;this.callParent();var j=this,k=j.getSurface("chart").getRect(),l=j.getInsetPadding(),a=k[2]-l.left-l.right,m=k[3]-l.top-l.bottom,h=[l.left,l.top,a,m],b=j.getSeries(),d,c,g;j.getSurface().setRect(h);j.setMainRect(h);for(c=0,g=b.length;c<g;c++){d=b[c];d.getSurface().setRect(h);if(d.setRect){d.setRect(h)}d.getOverlaySurface().setRect(k)}j.redraw()}catch(f){throw f}finally{this.resizing--}},redraw:function(){var e=this,c=e.getSeries(),b,a,d;for(a=0,d=c.length;a<d;a++){b=c[a];b.getSprites()}e.renderFrame();e.callParent(arguments)}});Ext.define("Ext.chart.axis.Category",{requires:["Ext.chart.axis.layout.CombineDuplicate","Ext.chart.axis.segmenter.Names"],extend:"Ext.chart.axis.Axis",alias:"axis.category",type:"category",config:{layout:"combineDuplicate",segmenter:"names"}});Ext.define("Ext.chart.axis.Numeric",{extend:"Ext.chart.axis.Axis",alias:["axis.numeric","axis.radial"],type:"numeric",requires:["Ext.chart.axis.layout.Continuous","Ext.chart.axis.segmenter.Numeric"],config:{layout:"continuous",segmenter:"numeric",aggregator:"double"}});Ext.define("Ext.chart.axis.Time",{extend:"Ext.chart.axis.Numeric",alias:"axis.time",type:"time",requires:["Ext.chart.axis.layout.Continuous","Ext.chart.axis.segmenter.Time"],config:{calculateByLabelSize:true,dateFormat:null,fromDate:null,toDate:null,step:[Ext.Date.DAY,1],layout:"continuous",segmenter:"time",aggregator:"time"},updateDateFormat:function(a){this.setRenderer(function(b){return Ext.Date.format(new Date(b),a)})},updateFromDate:function(a){this.setMinimum(+a)},updateToDate:function(a){this.setMaximum(+a)},getCoordFor:function(a){if(Ext.isString(a)){a=new Date(a)}return +a}});Ext.define("Ext.chart.interactions.CrossZoom",{extend:"Ext.chart.interactions.Abstract",type:"crosszoom",alias:"interaction.crosszoom",config:{axes:true,gestures:{dragstart:"onGestureStart",drag:"onGesture",dragend:"onGestureEnd",dblclick:"onDoubleTap"},undoButton:{}},stopAnimationBeforeSync:false,zoomAnimationInProgress:false,constructor:function(){this.callParent(arguments);this.zoomHistory=[]},applyAxes:function(b){var a={};if(b===true){return{top:{},right:{},bottom:{},left:{}}}else{if(Ext.isArray(b)){a={};Ext.each(b,function(c){a[c]={}})}else{if(Ext.isObject(b)){Ext.iterate(b,function(c,d){if(d===true){a[c]={}}else{if(d!==false){a[c]=d}}})}}}return a},applyUndoButton:function(b,a){var c=this;if(b){if(a){a.destroy()}return Ext.create("Ext.Button",Ext.apply({cls:[],text:"Undo Zoom",disabled:true,handler:function(){c.undoZoom()}},b))}else{if(a){a.destroy()}}},getSurface:function(){return this.getChart()&&this.getChart().getSurface("main")},setSeriesOpacity:function(b){var a=this.getChart()&&this.getChart().getSurface("series");if(a){a.element.setStyle("opacity",b)}},onGestureStart:function(d){var g=this,f=g.getChart(),a=g.getSurface(),i=f.getInnerRect(),c=i[2],b=i[3],k=f.getEventXY(d),j=k[0],h=k[1];if(g.zoomAnimationInProgress){return}if(j>0&&j<c&&h>0&&h<b){g.gestureEvent="drag";g.lockEvents(g.gestureEvent);g.startX=j;g.startY=h;g.selectionRect=a.add({type:"rect",globalAlpha:0.5,fillStyle:"rgba(80,80,140,0.5)",strokeStyle:"rgba(80,80,140,1)",lineWidth:2,x:j,y:h,width:0,height:0,zIndex:10000});g.setSeriesOpacity(0.8);return false}},onGesture:function(d){var g=this;if(g.zoomAnimationInProgress){return}if(g.getLocks()[g.gestureEvent]===g){var f=g.getChart(),a=g.getSurface(),i=f.getInnerRect(),c=i[2],b=i[3],k=f.getEventXY(d),j=k[0],h=k[1];if(j<0){j=0}else{if(j>c){j=c}}if(h<0){h=0}else{if(h>b){h=b}}g.selectionRect.setAttributes({width:j-g.startX,height:h-g.startY});if(Math.abs(g.startX-j)<11||Math.abs(g.startY-h)<11){g.selectionRect.setAttributes({globalAlpha:0.5})}else{g.selectionRect.setAttributes({globalAlpha:1})}a.renderFrame();return false}},onGestureEnd:function(d){var g=this;if(g.zoomAnimationInProgress){return}if(g.getLocks()[g.gestureEvent]===g){var f=g.getChart(),a=g.getSurface(),i=f.getInnerRect(),c=i[2],b=i[3],k=f.getEventXY(d),j=k[0],h=k[1];if(j<0){j=0}else{if(j>c){j=c}}if(h<0){h=0}else{if(h>b){h=b}}if(Math.abs(g.startX-j)<11||Math.abs(g.startY-h)<11){a.remove(g.selectionRect)}else{g.zoomBy([Math.min(g.startX,j)/c,1-Math.max(g.startY,h)/b,Math.max(g.startX,j)/c,1-Math.min(g.startY,h)/b]);g.selectionRect.setAttributes({x:Math.min(g.startX,j),y:Math.min(g.startY,h),width:Math.abs(g.startX-j),height:Math.abs(g.startY-h)});g.selectionRect.fx.setConfig(f.getAnimation()||{duration:0});g.selectionRect.setAttributes({globalAlpha:0,x:0,y:0,width:c,height:b});g.zoomAnimationInProgress=true;f.suspendThicknessChanged();g.selectionRect.fx.on("animationend",function(){f.resumeThicknessChanged();a.remove(g.selectionRect);g.selectionRect=null;g.zoomAnimationInProgress=false})}a.renderFrame();g.sync();g.unlockEvents(g.gestureEvent);g.setSeriesOpacity(1);if(!g.zoomAnimationInProgress){a.remove(g.selectionRect);g.selectionRect=null}}},zoomBy:function(o){var n=this,a=n.getAxes(),k=n.getChart(),j=k.getAxes(),l=k.getInherited().rtl,f,d={},c,b;if(l){o=o.slice();c=1-o[0];b=1-o[2];o[0]=Math.min(c,b);o[2]=Math.max(c,b)}for(var h=0;h<j.length;h++){var g=j[h];f=a[g.getPosition()];if(f&&f.allowZoom!==false){var e=g.isSide(),m=g.getVisibleRange();d[g.getId()]=m.slice(0);if(!e){g.setVisibleRange([(m[1]-m[0])*o[0]+m[0],(m[1]-m[0])*o[2]+m[0]])}else{g.setVisibleRange([(m[1]-m[0])*o[1]+m[0],(m[1]-m[0])*o[3]+m[0]])}}}n.zoomHistory.push(d);n.getUndoButton().setDisabled(false)},undoZoom:function(){var c=this.zoomHistory.pop(),d=this.getChart().getAxes();if(c){for(var a=0;a<d.length;a++){var b=d[a];if(c[b.getId()]){b.setVisibleRange(c[b.getId()])}}}this.getUndoButton().setDisabled(this.zoomHistory.length===0);this.sync()},onDoubleTap:function(a){this.undoZoom()}});Ext.define("Ext.chart.interactions.Crosshair",{extend:"Ext.chart.interactions.Abstract",requires:["Ext.chart.grid.HorizontalGrid","Ext.chart.grid.VerticalGrid","Ext.chart.CartesianChart","Ext.chart.axis.layout.Discrete"],type:"crosshair",alias:"interaction.crosshair",config:{axes:{top:{label:{},rect:{}},right:{label:{},rect:{}},bottom:{label:{},rect:{}},left:{label:{},rect:{}}},lines:{horizontal:{strokeStyle:"black",lineDash:[5,5]},vertical:{strokeStyle:"black",lineDash:[5,5]}},gesture:"drag"},applyAxes:function(b,a){return Ext.merge(a||{},b)},applyLines:function(a,b){return Ext.merge(b||{},a)},updateChart:function(a){if(!(a instanceof Ext.chart.CartesianChart)){throw"Crosshair interaction can only be used on cartesian charts."}this.callParent(arguments)},getGestures:function(){var a=this,b={};b[a.getGesture()]="onGesture";b[a.getGesture()+"start"]="onGestureStart";b[a.getGesture()+"end"]="onGestureEnd";return b},onGestureStart:function(J){var L=this,z=L.getChart(),H=z.getTheme().getAxis(),d,B=z.getSurface("overlay"),f=z.getInnerRect(),F=f[2],l=f[3],k=z.getEventXY(J),r=k[0],q=k[1],E=z.getAxes(),m=L.getAxes(),b=L.getLines(),h,v,o,I,t,p,s,w,D,u,G,K,A,g,a,j,M,n,c,C;if(r>0&&r<F&&q>0&&q<l){L.lockEvents(L.getGesture());L.horizontalLine=B.add(Ext.apply({xclass:"Ext.chart.grid.HorizontalGrid",x:0,y:q,width:F},b.horizontal));L.verticalLine=B.add(Ext.apply({xclass:"Ext.chart.grid.VerticalGrid",x:r,y:0,height:l},b.vertical));L.axesLabels=L.axesLabels||{};for(C=0;C<E.length;C++){h=E[C];v=h.getSurface();o=v.getRect();K=h.getSprites()[0];I=o[2];t=o[3];p=h.getPosition();s=h.getAlignment();M=h.getTitle(),n=M&&M.attr.text!==""&&M.getBBox(),A=K.attr;g=K.thickness;a=A.axisLine?A.lineWidth:0;j=a/2;G=Math.max(A.majorTickSize,A.minorTickSize)+a;w=L.axesLabels[p]=v.add({type:"composite"});w.labelRect=w.add(Ext.apply({type:"rect",fillStyle:"white",x:p==="right"?a:0,y:p==="bottom"?a:0,width:I-a-(s==="vertical"&&n?n.width:0),height:t-a-(s==="horizontal"&&n?n.height:0),translationX:p==="left"&&n?n.width:0,translationY:p==="top"&&n?n.height:0},m.rect||m[p].rect));d=Ext.merge({},H.defaults,H[p]);D=Ext.apply({},h.config.label,d.label);u=m.label||m[p].label;w.labelText=w.add(Ext.apply(D,u,{type:"text",x:(function(){switch(p){case"left":c=n?n.x+n.width:0;return c+(I-c-G)/2-j;case"right":c=n?I-n.x:0;return G+(I-G-c)/2+j;default:return 0}})(),y:(function(){switch(p){case"top":c=n?n.y+n.height:0;return c+(t-c-G)/2-j;case"bottom":c=n?t-n.y:0;return G+(t-G-c)/2+j;default:return 0}})()}))}return false}},onGesture:function(G){var K=this;if(K.getLocks()[K.getGesture()]!==K){return}var u=K.getChart(),z=u.getSurface("overlay"),a=Ext.Array.slice(u.getInnerRect()),r=u.getInnerPadding(),t=r.left,q=r.top,E=a[2],f=a[3],d=u.getEventXY(G),k=d[0],j=d[1],D=u.getAxes(),c,h,m,p,J,w,I,H,s,b,C,g,v,n,l,A,F,o,B;if(k<0){k=0}else{if(k>E){k=E}}if(j<0){j=0}else{if(j>f){j=f}}k+=t;j+=q;for(B=0;B<D.length;B++){c=D[B];h=c.getPosition();m=c.getAlignment();p=c.getSurface();J=c.getSprites()[0];w=J.attr.matrix;C=J.attr.textPadding*2;s=K.axesLabels[h];I=J.getLayoutContext();H=c.getSegmenter();if(s){if(m==="vertical"){v=w.getYY();l=w.getDY();F=(j-l-q)/v;if(c.getLayout() instanceof Ext.chart.axis.layout.Discrete){j=Math.round(F)*v+l+q;F=H.from(Math.round(F));F=J.attr.data[F]}else{F=H.from(F)}o=H.renderer(F,I);s.setAttributes({translationY:j-q});s.labelText.setAttributes({text:o});b=s.labelText.getBBox();s.labelRect.setAttributes({height:b.height+C,y:-(b.height+C)/2});p.renderFrame()}else{g=w.getXX();n=w.getDX();A=(k-n-t)/g;if(c.getLayout() instanceof Ext.chart.axis.layout.Discrete){k=Math.round(A)*g+n+t;A=H.from(Math.round(A));A=J.attr.data[A]}else{A=H.from(A)}o=H.renderer(A,I);s.setAttributes({translationX:k-t});s.labelText.setAttributes({text:o});b=s.labelText.getBBox();s.labelRect.setAttributes({width:b.width+C,x:-(b.width+C)/2});p.renderFrame()}}}K.horizontalLine.setAttributes({y:j});K.verticalLine.setAttributes({x:k});z.renderFrame();return false},onGestureEnd:function(h){var l=this,k=l.getChart(),a=k.getSurface("overlay"),j=k.getAxes(),c,g,d,b,f;a.remove(l.verticalLine);a.remove(l.horizontalLine);for(f=0;f<j.length;f++){c=j[f];g=c.getPosition();d=c.getSurface();b=l.axesLabels[g];if(b){delete l.axesLabels[g];d.remove(b)}d.renderFrame()}a.renderFrame();l.unlockEvents(l.getGesture())}});Ext.define("Ext.chart.interactions.ItemHighlight",{extend:"Ext.chart.interactions.Abstract",type:"itemhighlight",alias:"interaction.itemhighlight",config:{gestures:{tap:"onHighlightGesture",mousemove:"onMouseMoveGesture",mouseenter:"onMouseEnterGesture",mouseleave:"onMouseLeaveGesture",mousedown:"onMouseDownGesture",mouseup:"onMouseUpGesture"}},highlightItem:null,onMouseMoveGesture:function(f){var c=this,b,d,a;if(c.isDragging){if(c.tipItem){c.tipItem.series.hideTip(c.tipItem);c.tipItem=null}}else{if(!c.highlightItem){b=c.getItemForEvent(f);a=c.getChart();if(b!==a.getHighlightItem()){a.setHighlightItem(b);c.sync()}if(this.isMousePointer){if(c.tipItem&&(!b||c.tipItem.field!==b.field||c.tipItem.record!==b.record)){c.tipItem.series.hideTip(c.tipItem);c.tipItem=null}if(b&&(d=b.series.getTooltip())){if(d.trackMouse||!c.tipItem){b.series.showTip(b,f.getXY())}c.tipItem=b}}return false}}},showTip:function(b,a){a.series.showTip(a,b.getXY());this.tipItem=a},onMouseEnterGesture:function(){this.isMousePointer=true},onMouseLeaveGesture:function(){this.isMousePointer=false},onMouseDownGesture:function(){this.isDragging=true},onMouseUpGesture:function(){this.isDragging=false},onHighlightGesture:function(c){if(this.isMousePointer){return}var b=this,a=b.getItemForEvent(c);if(b.highlightItem&&a&&(b.highlightItem.index===a.index)){a=null}b.highlightItem=a;b.getChart().setHighlightItem(a)}});Ext.define("Ext.chart.interactions.PanZoom",{extend:"Ext.chart.interactions.Abstract",type:"panzoom",alias:"interaction.panzoom",requires:["Ext.draw.Animator"],config:{axes:{top:{},right:{},bottom:{},left:{}},minZoom:null,maxZoom:null,showOverflowArrows:true,panGesture:"drag",zoomGesture:"pinch",zoomOnPanGesture:false,modeToggleButton:{xtype:"segmentedbutton",width:200,defaults:{ui:"default-toolbar"},items:[{text:"Pan"},{text:"Zoom"}],cls:Ext.baseCSSPrefix+"panzoom-toggle"},hideLabelInGesture:false},stopAnimationBeforeSync:true,applyAxes:function(b,a){return Ext.merge(a||{},b)},applyZoomOnPanGesture:function(a){this.getChart();if(this.isMultiTouch()){return false}return a},updateZoomOnPanGesture:function(b){var a=this.getModeToggleButton();if(!this.isMultiTouch()){a.show();if(b){a.setValue(1)}else{a.setValue(0)}}else{a.hide()}},toggleMode:function(){var a=this;if(!a.isMultiTouch()){a.setZoomOnPanGesture(!a.getZoomOnPanGesture())}},applyModeToggleButton:function(c,b){var d=this,a=Ext.factory(c,"Ext.button.Segmented",b);if(a&&!b){a.addListener("toggle",function(e){d.setZoomOnPanGesture(e.getValue()===1)})}return a},getGestures:function(){var c=this,e={},d=c.getPanGesture(),b=c.getZoomGesture(),a=Ext.supports.Touch;e[b]="onZoomGestureMove";e[b+"start"]="onZoomGestureStart";e[b+"end"]="onZoomGestureEnd";e[d]="onPanGestureMove";e[d+"start"]="onPanGestureStart";e[d+"end"]="onPanGestureEnd";e.doubletap="onDoubleTap";return e},onDoubleTap:function(h){var f=this,c=f.getChart(),g=c.getAxes(),b,a,d;for(a=0,d=g.length;a<d;a++){b=g[a];b.setVisibleRange([0,1])}c.redraw()},onPanGestureStart:function(d){if(!d||!d.touches||d.touches.length<2){var b=this,a=b.getChart().getInnerRect(),c=b.getChart().element.getXY();b.startX=d.getX()-c[0]-a[0];b.startY=d.getY()-c[1]-a[1];b.oldVisibleRanges=null;b.hideLabels();b.getChart().suspendThicknessChanged();b.lockEvents(b.getPanGesture());return false}},onPanGestureMove:function(d){var b=this;if(b.getLocks()[b.getPanGesture()]===b){var a=b.getChart().getInnerRect(),c=b.getChart().element.getXY();if(b.getZoomOnPanGesture()){b.transformAxesBy(b.getZoomableAxes(d),0,0,(d.getX()-c[0]-a[0])/b.startX,b.startY/(d.getY()-c[1]-a[1]))}else{b.transformAxesBy(b.getPannableAxes(d),d.getX()-c[0]-a[0]-b.startX,d.getY()-c[1]-a[1]-b.startY,1,1)}b.sync();return false}},onPanGestureEnd:function(b){var a=this,c=a.getPanGesture();if(a.getLocks()[c]===a){a.getChart().resumeThicknessChanged();a.showLabels();a.sync();a.unlockEvents(c);return false}},onZoomGestureStart:function(b){if(b.touches&&b.touches.length===2){var c=this,i=c.getChart().element.getXY(),f=c.getChart().getInnerRect(),h=i[0]+f[0],d=i[1]+f[1],j=[b.touches[0].point.x-h,b.touches[0].point.y-d,b.touches[1].point.x-h,b.touches[1].point.y-d],g=Math.max(44,Math.abs(j[2]-j[0])),a=Math.max(44,Math.abs(j[3]-j[1]));c.getChart().suspendThicknessChanged();c.lastZoomDistances=[g,a];c.lastPoints=j;c.oldVisibleRanges=null;c.hideLabels();c.lockEvents(c.getZoomGesture());return false}},onZoomGestureMove:function(d){var f=this;if(f.getLocks()[f.getZoomGesture()]===f){var i=f.getChart().getInnerRect(),n=f.getChart().element.getXY(),k=n[0]+i[0],h=n[1]+i[1],o=Math.abs,c=f.lastPoints,m=[d.touches[0].point.x-k,d.touches[0].point.y-h,d.touches[1].point.x-k,d.touches[1].point.y-h],g=Math.max(44,o(m[2]-m[0])),b=Math.max(44,o(m[3]-m[1])),a=this.lastZoomDistances||[g,b],l=g/a[0],j=b/a[1];f.transformAxesBy(f.getZoomableAxes(d),i[2]*(l-1)/2+m[2]-c[2]*l,i[3]*(j-1)/2+m[3]-c[3]*j,l,j);f.sync();return false}},onZoomGestureEnd:function(c){var b=this,a=b.getZoomGesture();if(b.getLocks()[a]===b){b.getChart().resumeThicknessChanged();b.showLabels();b.sync();b.unlockEvents(a);return false}},hideLabels:function(){if(this.getHideLabelInGesture()){this.eachInteractiveAxes(function(a){a.hideLabels()})}},showLabels:function(){if(this.getHideLabelInGesture()){this.eachInteractiveAxes(function(a){a.showLabels()})}},isEventOnAxis:function(c,a){var b=a.getSurface().getRect();return b[0]<=c.getX()&&c.getX()<=b[0]+b[2]&&b[1]<=c.getY()&&c.getY()<=b[1]+b[3]},getPannableAxes:function(d){var h=this,a=h.getAxes(),f=h.getChart().getAxes(),c,g=f.length,k=[],j=false,b;if(d){for(c=0;c<g;c++){if(this.isEventOnAxis(d,f[c])){j=true;break}}}for(c=0;c<g;c++){b=a[f[c].getPosition()];if(b&&b.allowPan!==false&&(!j||this.isEventOnAxis(d,f[c]))){k.push(f[c])}}return k},getZoomableAxes:function(f){var j=this,a=j.getAxes(),g=j.getChart().getAxes(),l=[],d,h=g.length,c,k=false,b;if(f){for(d=0;d<h;d++){if(this.isEventOnAxis(f,g[d])){k=true;break}}}for(d=0;d<h;d++){c=g[d];b=a[c.getPosition()];if(b&&b.allowZoom!==false&&(!k||this.isEventOnAxis(f,c))){l.push(c)}}return l},eachInteractiveAxes:function(c){var d=this,b=d.getAxes(),e=d.getChart().getAxes();for(var a=0;a<e.length;a++){if(b[e[a].getPosition()]){if(false===c.call(this,e[a])){return}}}},transformAxesBy:function(d,j,g,h,e){var f=this.getChart().getInnerRect(),a=this.getAxes(),k,b=this.oldVisibleRanges,l=false;if(!b){this.oldVisibleRanges=b={};this.eachInteractiveAxes(function(i){b[i.getId()]=i.getVisibleRange()})}if(!f){return}for(var c=0;c<d.length;c++){k=a[d[c].getPosition()];l=this.transformAxisBy(d[c],b[d[c].getId()],j,g,h,e,this.minZoom||k.minZoom,this.maxZoom||k.maxZoom)||l}return l},transformAxisBy:function(c,o,r,q,k,i,h,m){var s=this,b=o[1]-o[0],l=c.getVisibleRange(),g=h||s.getMinZoom()||c.config.minZoom,j=m||s.getMaxZoom()||c.config.maxZoom,a=s.getChart().getInnerRect(),f,p;if(!a){return}var d=c.isSide(),e=d?a[3]:a[2],n=d?-q:r;b/=d?i:k;if(b<0){b=-b}if(b*g>1){b=1}if(b*j<1){b=1/j}f=o[0];p=o[1];l=l[1]-l[0];if(b===l&&l===1){return}c.setVisibleRange([(o[0]+o[1]-b)*0.5-n/e*b,(o[0]+o[1]+b)*0.5-n/e*b]);return(Math.abs(f-c.getVisibleRange()[0])>1e-10||Math.abs(p-c.getVisibleRange()[1])>1e-10)},destroy:function(){this.setModeToggleButton(null);this.callParent()}});Ext.define("Ext.chart.interactions.Rotate",{extend:"Ext.chart.interactions.Abstract",type:"rotate",alias:"interaction.rotate",config:{gesture:"rotate",gestures:{rotate:"onRotate",rotateend:"onRotate",dragstart:"onGestureStart",drag:"onGesture",dragend:"onGestureEnd"},rotation:0},oldRotations:null,getAngle:function(f){var c=this,b=c.getChart(),d=b.getEventXY(f),a=b.getCenter();return Math.atan2(d[1]-a[1],d[0]-a[0])},getEventRadius:function(h){var f=this,d=f.getChart(),g=d.getEventXY(h),a=d.getCenter(),c=g[0]-a[0],b=g[1]-a[1];return Math.sqrt(c*c+b*b)},onGestureStart:function(f){var d=this,c=d.getChart(),b=c.getRadius(),a=d.getEventRadius(f);if(b>=a){d.lockEvents("drag");d.angle=d.getAngle(f);d.oldRotations={};return false}},onGesture:function(b){var a=this,c=a.getAngle(b)-a.angle;if(a.getLocks().drag===a){a.doRotateTo(c,true);return false}},doRotateTo:function(d,a,b){var n=this,l=n.getChart(),k=l.getAxes(),f=l.getSeries(),m=n.oldRotations,c,j,g,e,h;if(!b){l.suspendAnimation()}for(e=0,h=k.length;e<h;e++){c=k[e];g=m[c.getId()]||(m[c.getId()]=c.getRotation());c.setRotation(d+(a?g:0))}for(e=0,h=f.length;e<h;e++){j=f[e];g=m[j.getId()]||(m[j.getId()]=j.getRotation());j.setRotation(d+(a?g:0))}n.setRotation(d+(a?g:0));n.fireEvent("rotate",n,n.getRotation());n.sync();if(!b){l.resumeAnimation()}},rotateTo:function(c,b,a){this.doRotateTo(c,b,a);this.oldRotations={}},onGestureEnd:function(b){var a=this;if(a.getLocks().drag===a){a.onGesture(b);a.unlockEvents("drag");a.fireEvent("rotationEnd",a,a.getRotation());return false}},onRotate:function(a){}});Ext.define("Ext.chart.interactions.RotatePie3D",{extend:"Ext.chart.interactions.Rotate",type:"rotatePie3d",alias:"interaction.rotatePie3d",getAngle:function(g){var a=this.getChart(),f=a.getInherited().rtl,d=f?-1:1,h=g.getXY(),c=a.element.getXY(),b=a.getMainRect();return d*Math.atan2(h[1]-c[1]-b[3]*0.5,h[0]-c[0]-b[2]*0.5)}});Ext.define("Ext.chart.series.Cartesian",{extend:"Ext.chart.series.Series",config:{xField:null,yField:null,xAxis:null,yAxis:null},directions:["X","Y"],fieldCategoryX:["X"],fieldCategoryY:["Y"],applyXAxis:function(a,b){return this.getChart().getAxis(a)||b},applyYAxis:function(a,b){return this.getChart().getAxis(a)||b},updateXAxis:function(a){a.processData(this)},updateYAxis:function(a){a.processData(this)},coordinateX:function(){return this.coordinate("X",0,2)},coordinateY:function(){return this.coordinate("Y",1,2)},getItemForPoint:function(a,g){if(this.getSprites()){var f=this,d=f.getSprites()[0],b=f.getStore(),e,c;if(f.getHidden()){return null}if(d){c=d.getIndexNearPoint(a,g);if(c!==-1){e={series:f,category:f.getItemInstancing()?"items":"markers",index:c,record:b.getData().items[c],field:f.getYField(),sprite:d};return e}}}},createSprite:function(){var a=this.callParent(),b=this.getXAxis();a.setAttributes({flipXY:this.getChart().getFlipXY()});if(a.setAggregator&&b&&b.getAggregator){if(b.getAggregator){a.setAggregator({strategy:b.getAggregator()})}else{a.setAggregator({})}}return a},getSprites:function(){var d=this,c=this.getChart(),e=d.getAnimation()||c&&c.getAnimation(),b=d.getItemInstancing(),f=d.sprites,a;if(!c){return[]}if(!f.length){a=d.createSprite()}else{a=f[0]}if(e){d.getLabel().getTemplate().fx.setConfig(e);if(b){a.itemsMarker.getTemplate().fx.setConfig(e)}a.fx.setConfig(e)}return f},provideLegendInfo:function(d){var b=this,a=b.getSubStyleWithTheme(),c=a.fillStyle;if(Ext.isArray(c)){c=c[0]}d.push({name:b.getTitle()||b.getYField()||b.getId(),mark:(Ext.isObject(c)?c.stops&&c.stops[0].color:c)||a.strokeStyle||"black",disabled:b.getHidden(),series:b.getId(),index:0})},getXRange:function(){return[this.dataRange[0],this.dataRange[2]]},getYRange:function(){return[this.dataRange[1],this.dataRange[3]]}});Ext.define("Ext.chart.series.StackedCartesian",{extend:"Ext.chart.series.Cartesian",config:{stacked:true,hidden:[]},animatingSprites:0,themeColorCount:function(){var b=this,a=b.getYField();return(Ext.isArray(a)?a.length:1)},updateStacked:function(){this.processData()},coordinateY:function(){return this.coordinateStacked("Y",1,2)},getFields:function(f){var e=this,a=[],c,b,d;for(b=0,d=f.length;b<d;b++){c=e["get"+f[b]+"Field"]();if(Ext.isArray(c)){a.push.apply(a,c)}else{a.push(c)}}return a},updateLabelOverflowPadding:function(a){this.getLabel().setAttributes({labelOverflowPadding:a})},getSprites:function(){var k=this,j=k.getChart(),c=k.getAnimation()||j&&j.getAnimation(),f=k.getFields(k.fieldCategoryY),b=k.getItemInstancing(),h=k.sprites,l,e=k.getHidden(),g=false,d,a=f.length;if(!j){return[]}for(d=0;d<a;d++){l=h[d];if(!l){l=k.createSprite();l.setAttributes({zIndex:-d});l.setField(f[d]);g=true;e.push(false);if(b){l.itemsMarker.getTemplate().setAttributes(k.getStyleByIndex(d))}else{l.setAttributes(k.getStyleByIndex(d))}}if(c){if(b){l.itemsMarker.getTemplate().fx.setConfig(c)}l.fx.setConfig(c)}}if(g){k.updateHidden(e)}return h},getItemForPoint:function(k,j){if(this.getSprites()){var h=this,b,g,m,a=h.getItemInstancing(),f=h.getSprites(),l=h.getStore(),c=h.getHidden(),n,d,e;for(b=0,g=f.length;b<g;b++){if(!c[b]){m=f[b];d=m.getIndexNearPoint(k,j);if(d!==-1){e=h.getYField();n={series:h,index:d,category:a?"items":"markers",record:l.getData().items[d],field:typeof e==="string"?e:e[b],sprite:m};return n}}}return null}},provideLegendInfo:function(e){var g=this,f=g.getSprites(),h=g.getTitle(),j=g.getYField(),d=g.getHidden(),k=f.length===1,b,l,c,a;for(c=0;c<f.length;c++){b=g.getStyleByIndex(c);l=b.fillStyle;if(Ext.isArray(h)){a=h[c]}else{if(k){a=h}else{if(Ext.isArray(j)){a=j[c]}else{a=g.getId()}}}e.push({name:a,mark:(Ext.isObject(l)?l.stops&&l.stops[0].color:l)||b.strokeStyle||"black",disabled:d[c],series:g.getId(),index:c})}},onSpriteAnimationStart:function(a){this.animatingSprites++;if(this.animatingSprites===1){this.fireEvent("animationstart")}},onSpriteAnimationEnd:function(a){this.animatingSprites--;if(this.animatingSprites===0){this.fireEvent("animationend")}}});Ext.define("Ext.chart.series.sprite.Cartesian",{extend:"Ext.draw.sprite.Sprite",mixins:{markerHolder:"Ext.chart.MarkerHolder"},inheritableStatics:{def:{processors:{dataMinX:"number",dataMaxX:"number",dataMinY:"number",dataMaxY:"number",rangeX:"data",rangeY:"data",dataY:"data",dataX:"data",labels:"default",labelOverflowPadding:"number",selectionTolerance:"number",flipXY:"bool",renderer:"default",visibleMinX:"number",visibleMinY:"number",visibleMaxX:"number",visibleMaxY:"number",innerWidth:"number",innerHeight:"number"},defaults:{dataY:null,dataX:null,dataMinX:0,dataMaxX:1,dataMinY:0,dataMaxY:1,labels:null,labelOverflowPadding:10,selectionTolerance:20,flipXY:false,renderer:null,transformFillStroke:false,visibleMinX:0,visibleMinY:0,visibleMaxX:1,visibleMaxY:1,innerWidth:1,innerHeight:1},dirtyTriggers:{dataX:"dataX,bbox",dataY:"dataY,bbox",dataMinX:"bbox",dataMaxX:"bbox",dataMinY:"bbox",dataMaxY:"bbox",visibleMinX:"panzoom",visibleMinY:"panzoom",visibleMaxX:"panzoom",visibleMaxY:"panzoom",innerWidth:"panzoom",innerHeight:"panzoom"},updaters:{dataX:function(a){this.processDataX();if(!a.dirtyFlags.dataY){a.dirtyFlags.dataY=[]}a.dirtyFlags.dataY.push("dataY")},dataY:function(){this.processDataY()},panzoom:function(f){var d=f.visibleMaxX-f.visibleMinX,c=f.visibleMaxY-f.visibleMinY,b=f.flipXY?f.innerHeight:f.innerWidth,g=!f.flipXY?f.innerHeight:f.innerWidth,a=this.getSurface(),e=a?a.getInherited().rtl:false;if(e&&!f.flipXY){f.translationX=b+f.visibleMinX*b/d}else{f.translationX=-f.visibleMinX*b/d}f.translationY=-f.visibleMinY*g/c;f.scalingX=(e&&!f.flipXY?-1:1)*b/d;f.scalingY=g/c;f.scalingCenterX=0;f.scalingCenterY=0;this.applyTransformations(true)}}}},config:{store:null,field:null},processDataY:Ext.emptyFn,processDataX:Ext.emptyFn,updatePlainBBox:function(b){var a=this.attr;b.x=a.dataMinX;b.y=a.dataMinY;b.width=a.dataMaxX-a.dataMinX;b.height=a.dataMaxY-a.dataMinY},binarySearch:function(d){var b=this.attr.dataX,f=0,a=b.length;if(d<=b[0]){return f}if(d>=b[a-1]){return a-1}while(f+1<a){var c=(f+a)>>1,e=b[c];if(e===d){return c}else{if(e<d){f=c}else{a=c}}}return f},render:function(b,c,g){var f=this,a=f.attr,e=a.inverseMatrix.clone();e.appendMatrix(b.inverseMatrix);if(a.dataX===null||a.dataX===undefined){return}if(a.dataY===null||a.dataY===undefined){return}if(e.getXX()*e.getYX()||e.getXY()*e.getYY()){console.log("Cartesian Series sprite does not support rotation/sheering");return}var d=e.transformList([[g[0]-1,g[3]+1],[g[0]+g[2]+1,-1]]);d=d[0].concat(d[1]);f.renderClipped(b,c,d,g)},renderClipped:Ext.emptyFn,getIndexNearPoint:function(f,e){var w=this,q=w.attr.matrix,h=w.attr.dataX,g=w.attr.dataY,k=w.attr.selectionTolerance,t,r,c=-1,j=q.clone().prependMatrix(w.surfaceMatrix).inverse(),u=j.transformPoint([f,e]),b=j.transformPoint([f-k,e-k]),n=j.transformPoint([f+k,e+k]),a=Math.min(b[0],n[0]),s=Math.max(b[0],n[0]),l=Math.min(b[1],n[1]),d=Math.max(b[1],n[1]),m,v,o,p;for(o=0,p=h.length;o<p;o++){m=h[o];v=g[o];if(m>a&&m<s&&v>l&&v<d){if(c===-1||(Math.abs(m-u[0])<t)&&(Math.abs(v-u[1])<r)){t=Math.abs(m-u[0]);r=Math.abs(v-u[1]);c=o}}}return c}});Ext.define("Ext.chart.series.sprite.StackedCartesian",{extend:"Ext.chart.series.sprite.Cartesian",inheritableStatics:{def:{processors:{groupCount:"number",groupOffset:"number",dataStartY:"data"},defaults:{selectionTolerance:20,groupCount:1,groupOffset:0,dataStartY:null},dirtyTriggers:{dataStartY:"dataY,bbox"}}},getIndexNearPoint:function(e,d){var o=this,q=o.attr.matrix,h=o.attr.dataX,f=o.attr.dataY,u=o.attr.dataStartY,l=o.attr.selectionTolerance,s=0.5,r=Infinity,b=-1,k=q.clone().prependMatrix(this.surfaceMatrix).inverse(),t=k.transformPoint([e,d]),a=k.transformPoint([e-l,d-l]),n=k.transformPoint([e+l,d+l]),j,g,m=Math.min(a[1],n[1]),c=Math.max(a[1],n[1]);for(var p=0;p<h.length;p++){if(Math.min(u[p],f[p])<=c&&m<=Math.max(u[p],f[p])){j=Math.abs(h[p]-t[0]);g=Math.max(-Math.min(f[p]-t[1],t[1]-u[p]),0);if(j<s&&g<=r){s=j;r=g;b=p}}}return b}});Ext.define("Ext.chart.series.sprite.Area",{alias:"sprite.areaSeries",extend:"Ext.chart.series.sprite.StackedCartesian",inheritableStatics:{def:{processors:{step:"bool"},defaults:{step:false}}},renderClipped:function(q,s,A){var B=this,p=B.attr,l=p.dataX,j=p.dataY,C=p.dataStartY,t=p.matrix,h,g,v,f,d,z,w,e=t.elements[0],m=t.elements[4],o=t.elements[3],k=t.elements[5],c=B.surfaceMatrix,n={},r=Math.min(A[0],A[2]),u=Math.max(A[0],A[2]),b=Math.max(0,this.binarySearch(r)),a=Math.min(l.length-1,this.binarySearch(u)+1);s.beginPath();z=l[b]*e+m;w=j[b]*o+k;s.moveTo(z,w);if(p.step){d=w;for(v=b;v<=a;v++){h=l[v]*e+m;g=j[v]*o+k;s.lineTo(h,d);s.lineTo(h,d=g)}}else{for(v=b;v<=a;v++){h=l[v]*e+m;g=j[v]*o+k;s.lineTo(h,g)}}if(C){if(p.step){f=l[a]*e+m;for(v=a;v>=b;v--){h=l[v]*e+m;g=C[v]*o+k;s.lineTo(f,g);s.lineTo(f=h,g)}}else{for(v=a;v>=b;v--){h=l[v]*e+m;g=C[v]*o+k;s.lineTo(h,g)}}}else{s.lineTo(l[a]*e+m,g);s.lineTo(l[a]*e+m,k);s.lineTo(z,k);s.lineTo(z,j[v]*o+k)}if(p.transformFillStroke){p.matrix.toContext(s)}s.fill();if(p.transformFillStroke){p.inverseMatrix.toContext(s)}s.beginPath();s.moveTo(z,w);if(p.step){for(v=b;v<=a;v++){h=l[v]*e+m;g=j[v]*o+k;s.lineTo(h,d);s.lineTo(h,d=g);n.translationX=c.x(h,g);n.translationY=c.y(h,g);B.putMarker("markers",n,v,!p.renderer)}}else{for(v=b;v<=a;v++){h=l[v]*e+m;g=j[v]*o+k;s.lineTo(h,g);n.translationX=c.x(h,g);n.translationY=c.y(h,g);B.putMarker("markers",n,v,!p.renderer)}}if(p.transformFillStroke){p.matrix.toContext(s)}s.stroke()}});Ext.define("Ext.chart.series.Area",{extend:"Ext.chart.series.StackedCartesian",alias:"series.area",type:"area",seriesType:"areaSeries",requires:["Ext.chart.series.sprite.Area"]});Ext.define("Ext.chart.series.sprite.Bar",{alias:"sprite.barSeries",extend:"Ext.chart.series.sprite.StackedCartesian",inheritableStatics:{def:{processors:{minBarWidth:"number",maxBarWidth:"number",minGapWidth:"number",radius:"number",inGroupGapWidth:"number"},defaults:{minBarWidth:2,maxBarWidth:100,minGapWidth:5,inGroupGapWidth:3,radius:0}}},drawLabel:function(k,i,r,h,o){var p=this,n=p.attr,f=p.getBoundMarker("labels")[0],d=f.getTemplate(),l=p.labelCfg||(p.labelCfg={}),c=p.surfaceMatrix,j=n.labelOverflowPadding,b=d.attr.display,m=d.attr.orientation,g,e,a,q,s;l.x=c.x(i,h);l.y=c.y(i,h);if(!n.flipXY){l.rotationRads=-Math.PI*0.5}else{l.rotationRads=0}l.calloutVertical=!n.flipXY;switch(m){case"horizontal":l.rotationRads=0;l.calloutVertical=false;break;case"vertical":l.rotationRads=-Math.PI*0.5;l.calloutVertical=true;break}l.text=k;if(d.attr.renderer){q=d.attr.renderer.call(this,k,f,l,{store:this.getStore()},o);if(typeof q==="string"){l.text=q}else{if(typeof q==="object"){if("text" in q){l.text=q.text}s=true}}}a=p.getMarkerBBox("labels",o,true);if(!a){p.putMarker("labels",l,o);a=p.getMarkerBBox("labels",o,true)}e=(a.width/2+j);if(r>h){e=-e}if((m==="horizontal"&&n.flipXY)||(m==="vertical"&&!n.flipXY)||!m){g=(b==="insideStart")?r+e:h-e}else{g=(b==="insideStart")?r+j*2:h-j*2}l.x=c.x(i,g);l.y=c.y(i,g);g=(b==="insideStart")?r-e:h+e;l.calloutPlaceX=c.x(i,g);l.calloutPlaceY=c.y(i,g);g=(b==="insideStart")?r:h;l.calloutStartX=c.x(i,g);l.calloutStartY=c.y(i,g);if(r>h){e=-e}if(Math.abs(h-r)<=e*2||b==="outside"){l.callout=1}else{l.callout=0}if(s){Ext.apply(l,q)}p.putMarker("labels",l,o)},drawBar:function(j,b,d,c,f,i,a,e){var h=this.itemCfg||(this.itemCfg={}),g;h.x=c;h.y=f;h.width=i-c;h.height=a-f;h.radius=this.attr.radius;if(this.attr.renderer){g=this.attr.renderer.call(this,this,h,{store:this.getStore()},e);Ext.apply(h,g)}this.putMarker("items",h,e,!this.attr.renderer)},renderClipped:function(F,t,E,B){if(this.cleanRedraw){return}var p=this,n=p.attr,v=n.dataX,u=n.dataY,G=n.labels,m=n.dataStartY,l=n.groupCount,D=n.groupOffset-(l-1)*0.5,y=n.inGroupGapWidth,s=t.lineWidth,C=n.matrix,A=C.elements[0],h=C.elements[3],e=C.elements[4],d=F.roundPixel(C.elements[5])-1,J=(A<0?-1:1)*A-n.minGapWidth,j=(Math.min(J,n.maxBarWidth)-y*(l-1))/l,z=F.roundPixel(Math.max(n.minBarWidth,j)),c=p.surfaceMatrix,f,H,b,g,K,a,k=0.5*n.lineWidth,L=Math.min(E[0],E[2]),w=Math.max(E[0],E[2]),x=Math.max(0,Math.floor(L)),o=Math.min(v.length-1,Math.ceil(w)),I=G&&p.getBoundMarker("labels"),r,q;for(K=x;K<=o;K++){r=m?m[K]:0;q=u[K];a=v[K]*A+e+D*(z+y);f=F.roundPixel(a-z/2)+k;g=F.roundPixel(q*h+d+s);H=F.roundPixel(a+z/2)-k;b=F.roundPixel(r*h+d+s);p.drawBar(t,F,E,f,g-k,H,b-k,K);if(I&&G[K]){p.drawLabel(G[K],a,b,g,K)}p.putMarker("markers",{translationX:c.x(a,g),translationY:c.y(a,g)},K,true)}},getIndexNearPoint:function(l,k){var m=this,g=m.attr,h=g.dataX,a=m.getSurface(),b=a.getRect()||[0,0,0,0],j=b[3],e,d,c,n,f=-1;if(g.flipXY){e=j-k;if(a.getInherited().rtl){d=b[2]-l}else{d=l}}else{e=l;d=j-k}for(c=0;c<h.length;c++){n=m.getMarkerBBox("items",c);if(n&&e>=n.x&&e<=(n.x+n.width)&&d>=n.y&&d<=(n.y+n.height)){f=c}}return f}});Ext.define("Ext.chart.series.Bar",{extend:"Ext.chart.series.StackedCartesian",alias:"series.bar",type:"bar",seriesType:"barSeries",requires:["Ext.chart.series.sprite.Bar","Ext.draw.sprite.Rect"],config:{itemInstancing:{type:"rect",fx:{customDurations:{x:0,y:0,width:0,height:0,radius:0}}}},getItemForPoint:function(a,f){if(this.getSprites()){var d=this,c=d.getChart(),e=c.getInnerPadding(),b=c.getInherited().rtl;arguments[0]=a+(b?e.right:-e.left);arguments[1]=f+e.bottom;return d.callParent(arguments)}},updateXAxis:function(a){a.setLabelInSpan(true);this.callParent(arguments)},updateHidden:function(a){this.callParent(arguments);this.updateStacked()},updateStacked:function(c){var f=this.getSprites(),d=f.length,e=[],a={},b;for(b=0;b<d;b++){if(!f[b].attr.hidden){e.push(f[b])}}d=e.length;if(this.getStacked()){a.groupCount=1;a.groupOffset=0;for(b=0;b<d;b++){e[b].setAttributes(a)}}else{a.groupCount=e.length;for(b=0;b<d;b++){a.groupOffset=b;e[b].setAttributes(a)}}this.callParent(arguments)}});Ext.define("Ext.draw.LimitedCache",{config:{limit:40,feeder:function(){return 0},scope:null},cache:null,constructor:function(a){this.cache={};this.cache.list=[];this.cache.tail=0;this.initConfig(a)},get:function(e){var c=this.cache,b=this.getLimit(),a=this.getFeeder(),d=this.getScope()||this;if(c[e]){return c[e].value}if(c.list[c.tail]){delete c[c.list[c.tail].cacheId]}c[e]=c.list[c.tail]={value:a.apply(d,Array.prototype.slice.call(arguments,1)),cacheId:e};c.tail++;if(c.tail===b){c.tail=0}return c[e].value},clear:function(){this.cache={};this.cache.list=[];this.cache.tail=0}});Ext.define("Ext.draw.SegmentTree",{config:{strategy:"double"},time:function(m,l,n,c,E,d,e){var f=0,o,A,s=new Date(n[m.startIdx[0]]),x=new Date(n[m.endIdx[l-1]]),D=Ext.Date,u=[[D.MILLI,1,"ms1",null],[D.MILLI,2,"ms2","ms1"],[D.MILLI,5,"ms5","ms1"],[D.MILLI,10,"ms10","ms5"],[D.MILLI,50,"ms50","ms10"],[D.MILLI,100,"ms100","ms50"],[D.MILLI,500,"ms500","ms100"],[D.SECOND,1,"s1","ms500"],[D.SECOND,10,"s10","s1"],[D.SECOND,30,"s30","s10"],[D.MINUTE,1,"mi1","s10"],[D.MINUTE,5,"mi5","mi1"],[D.MINUTE,10,"mi10","mi5"],[D.MINUTE,30,"mi30","mi10"],[D.HOUR,1,"h1","mi30"],[D.HOUR,6,"h6","h1"],[D.HOUR,12,"h12","h6"],[D.DAY,1,"d1","h12"],[D.DAY,7,"d7","d1"],[D.MONTH,1,"mo1","d1"],[D.MONTH,3,"mo3","mo1"],[D.MONTH,6,"mo6","mo3"],[D.YEAR,1,"y1","mo3"],[D.YEAR,5,"y5","y1"],[D.YEAR,10,"y10","y5"],[D.YEAR,100,"y100","y10"]],z,b,k=f,F=l,j=false,r=m.startIdx,h=m.endIdx,w=m.minIdx,C=m.maxIdx,a=m.open,y=m.close,g=m.minX,q=m.minY,p=m.maxX,B=m.maxY,v,t;for(z=0;l>f+1&&z<u.length;z++){s=new Date(n[r[0]]);b=u[z];s=D.align(s,b[0],b[1]);if(D.diff(s,x,b[0])>n.length*2*b[1]){continue}if(b[3]&&m.map["time_"+b[3]]){o=m.map["time_"+b[3]][0];A=m.map["time_"+b[3]][1]}else{o=k;A=F}f=l;t=s;j=true;r[l]=r[o];h[l]=h[o];w[l]=w[o];C[l]=C[o];a[l]=a[o];y[l]=y[o];g[l]=g[o];q[l]=q[o];p[l]=p[o];B[l]=B[o];t=Ext.Date.add(t,b[0],b[1]);for(v=o+1;v<A;v++){if(n[h[v]]<+t){h[l]=h[v];y[l]=y[v];if(B[v]>B[l]){B[l]=B[v];p[l]=p[v];C[l]=C[v]}if(q[v]<q[l]){q[l]=q[v];g[l]=g[v];w[l]=w[v]}}else{l++;r[l]=r[v];h[l]=h[v];w[l]=w[v];C[l]=C[v];a[l]=a[v];y[l]=y[v];g[l]=g[v];q[l]=q[v];p[l]=p[v];B[l]=B[v];t=Ext.Date.add(t,b[0],b[1])}}if(l>f){m.map["time_"+b[2]]=[f,l]}}},"double":function(h,u,j,a,t,b,c){var e=0,k,f=1,n,d,v,g,s,l,m,r,q,p,o;while(u>e+1){k=e;e=u;f+=f;for(n=k;n<e;n+=2){if(n===e-1){d=h.startIdx[n];v=h.endIdx[n];g=h.minIdx[n];s=h.maxIdx[n];l=h.open[n];m=h.close[n];r=h.minX[n];q=h.minY[n];p=h.maxX[n];o=h.maxY[n]}else{d=h.startIdx[n];v=h.endIdx[n+1];l=h.open[n];m=h.close[n];if(h.minY[n]<=h.minY[n+1]){g=h.minIdx[n];r=h.minX[n];q=h.minY[n]}else{g=h.minIdx[n+1];r=h.minX[n+1];q=h.minY[n+1]}if(h.maxY[n]>=h.maxY[n+1]){s=h.maxIdx[n];p=h.maxX[n];o=h.maxY[n]}else{s=h.maxIdx[n+1];p=h.maxX[n+1];o=h.maxY[n+1]}}h.startIdx[u]=d;h.endIdx[u]=v;h.minIdx[u]=g;h.maxIdx[u]=s;h.open[u]=l;h.close[u]=m;h.minX[u]=r;h.minY[u]=q;h.maxX[u]=p;h.maxY[u]=o;u++}h.map["double_"+f]=[e,u]}},none:Ext.emptyFn,aggregateData:function(h,a,r,c,d){var b=h.length,e=[],s=[],f=[],q=[],j=[],p=[],n=[],o=[],m=[],k=[],g={startIdx:e,endIdx:s,minIdx:f,maxIdx:q,open:j,minX:p,minY:n,maxX:o,maxY:m,close:k},l;for(l=0;l<b;l++){e[l]=l;s[l]=l;f[l]=l;q[l]=l;j[l]=a[l];p[l]=h[l];n[l]=c[l];o[l]=h[l];m[l]=r[l];k[l]=d[l]}g.map={original:[0,b]};if(b){this[this.getStrategy()](g,b,h,a,r,c,d)}return g},binarySearchMin:function(c,g,a,e){var b=this.dataX;if(e<=b[c.startIdx[0]]){return g}if(e>=b[c.startIdx[a-1]]){return a-1}while(g+1<a){var d=(g+a)>>1,f=b[c.startIdx[d]];if(f===e){return d}else{if(f<e){g=d}else{a=d}}}return g},binarySearchMax:function(c,g,a,e){var b=this.dataX;if(e<=b[c.endIdx[0]]){return g}if(e>=b[c.endIdx[a-1]]){return a-1}while(g+1<a){var d=(g+a)>>1,f=b[c.endIdx[d]];if(f===e){return d}else{if(f<e){g=d}else{a=d}}}return a},constructor:function(a){this.initConfig(a)},setData:function(d,a,b,c,e){if(!b){e=c=b=a}this.dataX=d;this.dataOpen=a;this.dataHigh=b;this.dataLow=c;this.dataClose=e;if(d.length===b.length&&d.length===c.length){this.cache=this.aggregateData(d,a,b,c,e)}},getAggregation:function(d,k,i){if(!this.cache){return null}var c=Infinity,g=this.dataX[this.dataX.length-1]-this.dataX[0],l=this.cache.map,m=l.original,a,e,j,b,f,h;for(a in l){e=l[a];j=e[1]-e[0]-1;b=g/j;if(i<=b&&b<c){m=e;c=b}}f=Math.max(this.binarySearchMin(this.cache,m[0],m[1],d),m[0]);h=Math.min(this.binarySearchMax(this.cache,m[0],m[1],k)+1,m[1]);return{data:this.cache,start:f,end:h}}});Ext.define("Ext.chart.series.sprite.Aggregative",{extend:"Ext.chart.series.sprite.Cartesian",requires:["Ext.draw.LimitedCache","Ext.draw.SegmentTree"],inheritableStatics:{def:{processors:{dataHigh:"data",dataLow:"data",dataClose:"data"},aliases:{dataOpen:"dataY"},defaults:{dataHigh:null,dataLow:null,dataClose:null}}},config:{aggregator:{}},applyAggregator:function(b,a){return Ext.factory(b,Ext.draw.SegmentTree,a)},constructor:function(){this.callParent(arguments)},processDataY:function(){var d=this,b=d.attr,e=b.dataHigh,a=b.dataLow,f=b.dataClose,c=b.dataY;d.callParent(arguments);if(b.dataX&&c&&c.length>0){if(e){d.getAggregator().setData(b.dataX,b.dataY,e,a,f)}else{d.getAggregator().setData(b.dataX,b.dataY)}}},getGapWidth:function(){return 1},renderClipped:function(b,c,g,f){var e=this,d=Math.min(g[0],g[2]),a=Math.max(g[0],g[2]),h=e.getAggregator()&&e.getAggregator().getAggregation(d,a,(a-d)/f[2]*e.getGapWidth());if(h){e.dataStart=h.data.startIdx[h.start];e.dataEnd=h.data.endIdx[h.end-1];e.renderAggregates(h.data,h.start,h.end,b,c,g,f)}}});Ext.define("Ext.chart.series.sprite.CandleStick",{alias:"sprite.candlestickSeries",extend:"Ext.chart.series.sprite.Aggregative",inheritableStatics:{def:{processors:{raiseStyle:function(b,a){return Ext.merge({},a||{},b)},dropStyle:function(b,a){return Ext.merge({},a||{},b)},barWidth:"number",padding:"number",ohlcType:"enums(candlestick,ohlc)"},defaults:{raiseStyle:{strokeStyle:"green",fillStyle:"green"},dropStyle:{strokeStyle:"red",fillStyle:"red"},planar:false,barWidth:15,padding:3,lineJoin:"miter",miterLimit:5,ohlcType:"candlestick"},dirtyTriggers:{raiseStyle:"raiseStyle",dropStyle:"dropStyle"},updaters:{raiseStyle:function(){this.raiseTemplate&&this.raiseTemplate.setAttributes(this.attr.raiseStyle)},dropStyle:function(){this.dropTemplate&&this.dropTemplate.setAttributes(this.attr.dropStyle)}}}},candlestick:function(i,c,a,e,h,f,b){var d=Math.min(c,h),g=Math.max(c,h);i.moveTo(f,e);i.lineTo(f,g);i.moveTo(f+b,g);i.lineTo(f+b,d);i.lineTo(f-b,d);i.lineTo(f-b,g);i.closePath();i.moveTo(f,a);i.lineTo(f,d)},ohlc:function(b,d,e,a,f,c,g){b.moveTo(c,e);b.lineTo(c,a);b.moveTo(c,d);b.lineTo(c-g,d);b.moveTo(c,f);b.lineTo(c+g,f)},constructor:function(){this.callParent(arguments);this.raiseTemplate=new Ext.draw.sprite.Rect({parent:this});this.dropTemplate=new Ext.draw.sprite.Rect({parent:this})},getGapWidth:function(){var a=this.attr,b=a.barWidth,c=a.padding;return b+c},renderAggregates:function(d,c,b,t,u,z){var D=this,s=this.attr,j=s.dataX,v=s.matrix,e=v.getXX(),r=v.getYY(),l=v.getDX(),h=v.getDY(),o=s.barWidth/e,C,k=s.ohlcType,f=Math.round(o*0.5*e),a=d.open,y=d.close,B=d.maxY,p=d.minY,q=d.startIdx,m,g,E,n,A,x,w=s.lineWidth*t.devicePixelRatio/2;w-=Math.floor(w);u.save();C=this.raiseTemplate;C.useAttributes(u,z);u.beginPath();for(x=c;x<b;x++){if(a[x]<=y[x]){m=Math.round(a[x]*r+h)+w;g=Math.round(B[x]*r+h)+w;E=Math.round(p[x]*r+h)+w;n=Math.round(y[x]*r+h)+w;A=Math.round(j[q[x]]*e+l)+w;D[k](u,m,g,E,n,A,f)}}u.fillStroke(C.attr);u.restore();u.save();C=this.dropTemplate;C.useAttributes(u,z);u.beginPath();for(x=c;x<b;x++){if(a[x]>y[x]){m=Math.round(a[x]*r+h)+w;g=Math.round(B[x]*r+h)+w;E=Math.round(p[x]*r+h)+w;n=Math.round(y[x]*r+h)+w;A=Math.round(j[q[x]]*e+l)+w;D[k](u,m,g,E,n,A,f)}}u.fillStroke(C.attr);u.restore()}});Ext.define("Ext.chart.series.CandleStick",{extend:"Ext.chart.series.Cartesian",requires:["Ext.chart.series.sprite.CandleStick"],alias:"series.candlestick",type:"candlestick",seriesType:"candlestickSeries",config:{openField:null,highField:null,lowField:null,closeField:null},fieldCategoryY:["Open","High","Low","Close"],themeColorCount:function(){return 2}});Ext.define("Ext.chart.series.Polar",{extend:"Ext.chart.series.Series",config:{rotation:0,radius:null,center:[0,0],offsetX:0,offsetY:0,showInLegend:true,xField:null,angleField:null,yField:null,lengthField:null,xAxis:null,yAxis:null},directions:["X","Y"],fieldCategoryX:["X"],fieldCategoryY:["Y"],getAngleField:function(){return this.getXField()},setAngleField:function(a){return this.setXField(a)},getLengthField:function(){return this.getYField()},setLengthField:function(a){return this.setYField(a)},applyXAxis:function(a,b){return this.getChart().getAxis(a)||b},applyYAxis:function(a,b){return this.getChart().getAxis(a)||b},getXRange:function(){return[this.dataRange[0],this.dataRange[2]]},getYRange:function(){return[this.dataRange[1],this.dataRange[3]]},themeColorCount:function(){var c=this,a=c.getStore(),b=a&&a.getCount()||0;return b},getDefaultSpriteConfig:function(){return{type:this.seriesType,renderer:this.getRenderer(),centerX:0,centerY:0,rotationCenterX:0,rotationCenterY:0}},applyRotation:function(b){var a=Math.PI*2;return(b%a+Math.PI)%a-Math.PI},updateRotation:function(a){var b=this.getSprites();if(b&&b[0]){b[0].setAttributes({baseRotation:a})}}});Ext.define("Ext.chart.series.Gauge",{alias:"series.gauge",extend:"Ext.chart.series.Polar",type:"gauge",seriesType:"pieslice",requires:["Ext.draw.sprite.Sector"],config:{angleField:null,field:null,needle:false,needleLengthRatio:undefined,needleLength:90,needleWidth:4,donut:30,showInLegend:false,value:null,colors:null,sectors:null,minimum:0,maximum:100,rotation:0,totalAngle:Math.PI/2,rect:[0,0,1,1],center:[0.5,0.75],radius:0.5,wholeDisk:false},coordinateX:function(){return this.coordinate("X",0,2)},coordinateY:function(){return this.coordinate("Y",1,2)},updateNeedle:function(b){var a=this,d=a.getSprites(),c=a.valueToAngle(a.getValue());if(d&&d.length){d[0].setAttributes({startAngle:(b?c:0),endAngle:c,strokeOpacity:(b?1:0),lineWidth:(b?a.getNeedleWidth():0)});a.doUpdateStyles()}},themeColorCount:function(){var c=this,a=c.getStore(),b=a&&a.getCount()||0;return b+(c.getNeedle()?0:1)},updateColors:function(a,b){var f=this,h=f.getSectors(),j=h&&h.length,e=f.getSprites(),c=Ext.Array.clone(a),g=a&&a.length,d;if(!g||!a[0]){return}for(d=0;d<j;d++){c[d+1]=h[d].color||c[d+1]||a[d%g]}e[0].setAttributes({strokeStyle:c[0]});this.setSubStyle({fillStyle:c,strokeStyle:c});this.doUpdateStyles()},updateAngleField:function(a){this.setField(a)},updateNeedleLengthRatio:function(a){this.setNeedleLength(a*100)},updateRect:function(f){var d=this.getWholeDisk(),c=d?Math.PI:this.getTotalAngle()/2,g=this.getDonut()/100,e,b,a;if(c<=Math.PI/2){e=2*Math.sin(c);b=1-g*Math.cos(c)}else{e=2;b=1-Math.cos(c)}a=Math.min(f[2]/e,f[3]/b);this.setRadius(a);this.setCenter([f[2]/2,a+(f[3]-b*a)/2])},updateCenter:function(a){this.setStyle({centerX:a[0],centerY:a[1],rotationCenterX:a[0],rotationCenterY:a[1]});this.doUpdateStyles()},updateRotation:function(a){this.setStyle({rotationRads:a-(this.getTotalAngle()+Math.PI)/2});this.doUpdateStyles()},doUpdateShape:function(b,f){var a,d=this.getSectors(),c=(d&&d.length)||0,e=this.getNeedleLength()/100;a=[b*e,b];while(c--){a.push(b)}this.setSubStyle({endRho:a,startRho:b/100*f});this.doUpdateStyles()},updateRadius:function(a){var b=this.getDonut();this.doUpdateShape(a,b)},updateDonut:function(b){var a=this.getRadius();this.doUpdateShape(a,b)},valueToAngle:function(a){a=this.applyValue(a);return this.getTotalAngle()*(a-this.getMinimum())/(this.getMaximum()-this.getMinimum())},applyValue:function(a){return Math.min(this.getMaximum(),Math.max(a,this.getMinimum()))},updateValue:function(b){var a=this,c=a.getNeedle(),e=a.valueToAngle(b),d=a.getSprites();d[0].rendererData.value=b;d[0].setAttributes({startAngle:(c?e:0),endAngle:e});a.doUpdateStyles()},processData:function(){var e=this,j=e.getStore(),a,c,g,b,f,d=j&&j.first(),h,i;if(d){h=e.getField();if(h){i=d.get(h)}}if(a=e.getXAxis()){c=a.getMinimum();g=a.getMaximum();b=a.getSprites()[0].fx;f=b.getDuration();b.setDuration(0);if(Ext.isNumber(c)){e.setMinimum(c)}else{a.setMinimum(e.getMinimum())}if(Ext.isNumber(g)){e.setMaximum(g)}else{a.setMaximum(e.getMaximum())}b.setDuration(f)}if(!Ext.isNumber(i)){i=e.getMinimum()}e.setValue(i)},getDefaultSpriteConfig:function(){return{type:this.seriesType,renderer:this.getRenderer(),fx:{customDurations:{translationX:0,translationY:0,rotationCenterX:0,rotationCenterY:0,centerX:0,centerY:0,startRho:0,endRho:0,baseRotation:0}}}},normalizeSectors:function(f){var d=this,c=(f&&f.length)||0,b,e,g,a;if(c){for(b=0;b<c;b++){e=f[b];if(typeof e==="number"){f[b]={start:(b>0?f[b-1].end:d.getMinimum()),end:Math.min(e,d.getMaximum())};if(b==(c-1)&&f[b].end<d.getMaximum()){f[b+1]={start:f[b].end,end:d.getMaximum()}}}else{if(typeof e.start==="number"){g=Math.max(e.start,d.getMinimum())}else{g=(b>0?f[b-1].end:d.getMinimum())}if(typeof e.end==="number"){a=Math.min(e.end,d.getMaximum())}else{a=d.getMaximum()}f[b].start=g;f[b].end=a}}}else{f=[{start:d.getMinimum(),end:d.getMaximum()}]}return f},getSprites:function(){var j=this,m=j.getStore(),l=j.getValue(),c,g;if(!m&&!Ext.isNumber(l)){return[]}var h=j.getChart(),b=j.getAnimation()||h&&h.getAnimation(),f=j.sprites,k=0,o,n,e,d,a=[];if(f&&f.length){f[0].fx.setConfig(b);return f}d={store:m,field:j.getField(),value:l,series:j};o=j.createSprite();o.setAttributes({zIndex:10},true);o.rendererData=d;o.rendererIndex=k++;a.push(j.getNeedleWidth());j.getLabel().getTemplate().setField(true);n=j.normalizeSectors(j.getSectors());for(c=0,g=n.length;c<g;c++){e={startAngle:j.valueToAngle(n[c].start),endAngle:j.valueToAngle(n[c].end),label:n[c].label,fillStyle:n[c].color,strokeOpacity:0,rotateLabels:false,doCallout:false,labelOverflowPadding:-1};Ext.apply(e,n[c].style);o=j.createSprite();o.rendererData=d;o.rendererIndex=k++;o.setAttributes(e,true);a.push(e.lineWidth)}j.setSubStyle({lineWidth:a});j.doUpdateStyles();return f}});Ext.define("Ext.chart.series.ItemPublisher",{extend:"Ext.event.publisher.Publisher",targetType:"series",handledEvents:["itemmousemove","itemmouseup","itemmousedown","itemmouseover","itemmouseout","itemclick","itemdoubleclick","itemtap","itemtapstart","itemtapend","itemtapcancel","itemtaphold","itemdoubletap","itemsingletap","itemtouchstart","itemtouchmove","itemtouchend","itemdragstart","itemdrag","itemdragend","itempinchstart","itempinch","itempinchend","itemswipe"],delegationRegex:/^item([a-z]+)$/i,getSubscribers:function(b){var a=this.subscribers;if(!a.hasOwnProperty(b)){a[b]={}}return a[b]},subscribe:function(f,a){var b=f.match(this.idSelectorRegex),d=this.dispatcher,e=this.targetType,c,g;if(!b){return false}g=b[1];c=Ext.ComponentManager.get(g);if(!c){return false}if(!c.getChart()){d.addListener(e,f,"chartattached","attachChart",this,[c,a],"before")}else{this.attachChart(c.getChart(),[c,a])}return true},attachChart:function(f,g){var i=this.dispatcher,b=this.targetType,c=g[0],e=g[1],a=this.getSubscribers(f.getId()),d=e.match(this.delegationRegex);if(d){var h=d[1];if(!a.hasOwnProperty(e)){a[e]=[];i.addListener(b,"#"+c.getId(),"chartdetached","detachChart",this,[c,e,a],"after");f.element.on(h,"relayMethod",this,[f,e])}a[e].push(c);return true}else{return false}},unsubscribe:function(f,a){var b=f.match(this.idSelectorRegex),d=this.dispatcher,e=this.targetType,c,g;if(!b){return false}g=b[1];c=Ext.ComponentManager.get(g);if(!c){return false}d.removeListener(e,f,"chartattached","attachChart",this,"before");if(c.getChart()){this.detachChart(c.getChart(),[c,a])}return true},detachChart:function(h,i){var k=this.dispatcher,b=this.targetType,d=i[0],f=i[1],a=this.getSubscribers(h.getId()),e=f.match(this.delegationRegex),g,c;if(e){var j=e[1];if(a.hasOwnProperty(f)){c=a[f];g=Ext.Array.indexOf(c,d);if(g>-1){c.splice(g,1)}if(c.length===0){h.element.un(j,"relayMethod",this,[h,f]);k.removeListener(b,"#"+d.getId(),"chartdetached","detachChart",this,"after");delete a[f]}}}},relayMethod:function(h,f,l){var k=l[0],g=l[1],q=this.dispatcher,a=this.targetType,b=k.getEventXY(h),n=b[0],m=b[1],p=this.getSubscribers(k.getId())[g],d,j;if(p){for(d=0,j=p.length;d<j;d++){var c=p[d],o=c.getItemForPoint(n,m);if(o){q.doDispatchEvent(a,"#"+c.getId(),g,[c,o,h]);return}}}}},function(){});Ext.define("Ext.chart.series.sprite.Line",{alias:"sprite.lineSeries",extend:"Ext.chart.series.sprite.Aggregative",inheritableStatics:{def:{processors:{smooth:"bool",fillArea:"bool",step:"bool",preciseStroke:"bool"},defaults:{smooth:false,fillArea:false,step:false,preciseStroke:true},dirtyTriggers:{dataX:"dataX,bbox,smooth",dataY:"dataY,bbox,smooth",smooth:"smooth"},updaters:{smooth:function(a){if(a.smooth&&a.dataX&&a.dataY&&a.dataX.length>2&&a.dataY.length>2){this.smoothX=Ext.draw.Draw.spline(a.dataX);this.smoothY=Ext.draw.Draw.spline(a.dataY)}else{delete this.smoothX;delete this.smoothY}}}}},list:null,updatePlainBBox:function(d){var b=this.attr,c=Math.min(0,b.dataMinY),a=Math.max(0,b.dataMaxY);d.x=b.dataMinX;d.y=c;d.width=b.dataMaxX-b.dataMinX;d.height=a-c},drawStroke:function(w,z,d,c,E,g){var v=this.attr,B=v.matrix,f=B.getXX(),s=B.getYY(),o=B.getDX(),m=B.getDY(),r=v.smooth,e=v.step,I=Math.pow(2,h(v.dataX.length,c)),u=this.smoothX,t=this.smoothY,C,A,n,H,q,G,p,F,l,k,D,b,a;function h(x,i){var j=0,y=x;while(y<i&&x>0){j++;y+=x>>j}return j>0?j-1:j}z.beginPath();if(r&&u&&t){z.moveTo(u[d*3]*f+o,t[d*3]*s+m);for(C=0,A=d*3+1;C<E.length-3;C+=3,A+=3*I){q=u[A]*f+o;G=t[A]*s+m;p=u[A+1]*f+o;F=t[A+1]*s+m;l=E[C+3];k=E[C+4];D=E[C];b=E[C+1];if(v.renderer){n={type:"line",smooth:true,step:e,cx1:q,cy1:G,cx2:p,cy2:F,x:l,y:k,x0:D,y0:b};H=v.renderer.call(this,this,n,{store:this.getStore()},(d+C/3+1));z.save();Ext.apply(z,H);if(v.fillArea){a=z.strokeOpacity;z.save();z.strokeOpacity=0;z.moveTo(D,b);z.bezierCurveTo(q,G,p,F,l,k);z.lineTo(l,g);z.lineTo(D,g);z.lineTo(D,b);z.closePath();z.fillStroke(v,true);z.restore();z.strokeOpacity=a;z.beginPath()}z.moveTo(D,b);z.bezierCurveTo(q,G,p,F,l,k);z.stroke();z.moveTo(D,b);z.closePath();z.restore();z.beginPath();z.moveTo(l,k)}else{z.bezierCurveTo(q,G,p,F,l,k)}}}else{z.moveTo(E[0],E[1]);for(C=3;C<E.length;C+=3){l=E[C];k=E[C+1];D=E[C-3];b=E[C-2];if(v.renderer){n={type:"line",smooth:false,step:e,x:l,y:k,x0:D,y0:b};H=v.renderer.call(this,this,n,{store:this.getStore()},d+C/3);z.save();Ext.apply(z,H);if(v.fillArea){a=z.strokeOpacity;z.save();z.strokeOpacity=0;if(e){z.lineTo(l,b)}else{z.lineTo(l,k)}z.lineTo(l,g);z.lineTo(D,g);z.lineTo(D,b);z.closePath();z.fillStroke(v,true);z.restore();z.strokeOpacity=a;z.beginPath()}z.moveTo(D,b);if(e){z.lineTo(l,b);z.closePath();z.stroke();z.beginPath();z.moveTo(l,b)}z.lineTo(l,k);z.closePath();z.stroke();z.restore();z.beginPath();z.moveTo(l,k)}else{if(e){z.lineTo(l,b)}z.lineTo(l,k)}}}},drawLabel:function(k,i,h,p,a){var q=this,n=q.attr,e=q.getBoundMarker("labels")[0],d=e.getTemplate(),m=q.labelCfg||(q.labelCfg={}),c=q.surfaceMatrix,g,f,j=n.labelOverflowPadding,o=n.flipXY,l,b,r,s;m.x=c.x(i,h);m.y=c.y(i,h);if(o){m.rotationRads=Math.PI*0.5}else{m.rotationRads=0}m.text=k;if(d.attr.renderer){r=d.attr.renderer.call(q,k,e,m,{store:q.getStore()},p);if(typeof r==="string"){m.text=r}else{if(typeof r==="object"){if("text" in r){m.text=r.text}s=true}}}b=q.getMarkerBBox("labels",p,true);if(!b){q.putMarker("labels",m,p);b=q.getMarkerBBox("labels",p,true)}l=b.height/2;g=i;switch(d.attr.display){case"under":f=h-l-j;break;case"rotate":g+=j;f=h-j;m.rotationRads=-Math.PI/4;break;default:f=h+l+j}m.x=c.x(g,f);m.y=c.y(g,f);if(s){Ext.apply(m,r)}q.putMarker("labels",m,p)},renderAggregates:function(w,t,k,L,n,G,B){var l=this,j=l.attr,r=j.dataX,q=j.dataY,g=j.labels,Q=g&&l.getBoundMarker("labels"),C=j.matrix,a=L.matrix,s=L.devicePixelRatio,A=C.getXX(),f=C.getYY(),d=C.getDX(),c=C.getDY(),z={},p=l.list||(l.list=[]),J,I,O,E,D=w.minX,e=w.maxX,h=w.minY,N=w.maxY,P=w.startIdx;p.length=0;for(O=t;O<k;O++){var M=D[O],o=e[O],K=h[O],m=N[O];if(M<o){p.push(M*A+d,K*f+c,P[O]);p.push(o*A+d,m*f+c,P[O])}else{if(M>o){p.push(o*A+d,m*f+c,P[O]);p.push(M*A+d,K*f+c,P[O])}else{p.push(o*A+d,m*f+c,P[O])}}}if(p.length){for(O=0;O<p.length;O+=3){J=p[O];I=p[O+1];E=p[O+2];if(j.renderer){z={type:"marker",x:J,y:I};z=j.renderer.call(l,l,z,{store:l.getStore()},t+O/3)||{}}z.translationX=a.x(J,I);z.translationY=a.y(J,I);l.putMarker("markers",z,E,!j.renderer);if(Q&&g[E]){l.drawLabel(g[E],J,I,E,B)}}l.drawStroke(L,n,t,k,p,B[1]-s);if(!j.renderer){var v=r[r.length-1]*A+d+s,u=q[q.length-1]*f+c,b=B[1]-s,H=r[0]*A+d-s,F=q[0]*f+c;n.lineTo(v,u);n.lineTo(v,b);n.lineTo(H,b);n.lineTo(H,F)}n.closePath();if(j.transformFillStroke){j.matrix.toContext(n)}if(j.preciseStroke){if(j.fillArea){n.fill()}if(j.transformFillStroke){j.inverseMatrix.toContext(n)}l.drawStroke(L,n,t,k,p,B[1]-s);if(j.transformFillStroke){j.matrix.toContext(n)}n.stroke()}else{if(j.fillArea){n.fillStroke(j,true)}else{n.stroke(true)}}}}});Ext.define("Ext.chart.series.Line",{extend:"Ext.chart.series.Cartesian",alias:"series.line",type:"line",seriesType:"lineSeries",requires:["Ext.chart.series.sprite.Line"],config:{selectionTolerance:20,smooth:false,step:false,fill:undefined,aggregator:{strategy:"double"}},defaultSmoothness:3,overflowBuffer:1,themeMarkerCount:function(){return 1},getDefaultSpriteConfig:function(){var d=this,e=d.callParent(arguments),c=Ext.apply({},d.getStyle()),b,a=false;if(typeof d.config.fill!="undefined"){if(d.config.fill){a=true;if(typeof c.fillStyle=="undefined"){if(typeof c.strokeStyle=="undefined"){b=d.getStyleWithTheme();c.fillStyle=b.fillStyle;c.strokeStyle=b.strokeStyle}else{c.fillStyle=c.strokeStyle}}}}else{if(c.fillStyle){a=true}}if(!a){delete c.fillStyle}c=Ext.apply(e||{},c);return Ext.apply(c,{fillArea:a,step:d.config.step,smooth:d.config.smooth,selectionTolerance:d.config.selectionTolerance})}});Ext.define("Ext.chart.series.sprite.PieSlice",{alias:"sprite.pieslice",mixins:{markerHolder:"Ext.chart.MarkerHolder"},extend:"Ext.draw.sprite.Sector",inheritableStatics:{def:{processors:{doCallout:"bool",label:"string",rotateLabels:"bool",labelOverflowPadding:"number",renderer:"default"},defaults:{doCallout:true,rotateLabels:true,label:"",labelOverflowPadding:10,renderer:null}}},config:{rendererData:null,rendererIndex:0},render:function(b,c,g,f){var e=this,a=e.attr,h={},d;if(a.renderer){h={type:"sector",text:a.text,centerX:a.centerX,centerY:a.centerY,margin:a.margin,startAngle:Math.min(a.startAngle,a.endAngle),endAngle:Math.max(a.startAngle,a.endAngle),startRho:Math.min(a.startRho,a.endRho),endRho:Math.max(a.startRho,a.endRho)};d=a.renderer.call(e,e,h,e.rendererData,e.rendererIndex);e.setAttributes(d);e.useAttributes(c,g)}e.callParent([b,c,g,f]);if(a.label&&e.getBoundMarker("labels")){e.placeLabel()}},placeLabel:function(){var w=this,s=w.attr,r=w.attr.attributeId,t=Math.min(s.startAngle,s.endAngle),p=Math.max(s.startAngle,s.endAngle),k=(t+p)*0.5,n=s.margin,h=s.centerX,g=s.centerY,f=Math.sin(k),c=Math.cos(k),v=Math.min(s.startRho,s.endRho)+n,m=Math.max(s.startRho,s.endRho)+n,l=(v+m)*0.5,b=w.surfaceMatrix,o=w.labelCfg||(w.labelCfg={}),e=w.getBoundMarker("labels")[0],d=e.getTemplate(),a=d.getCalloutLine(),q=a&&a.length||40,u,j,i,z;b.appendMatrix(s.matrix);o.text=s.label;j=h+c*l;i=g+f*l;o.x=b.x(j,i);o.y=b.y(j,i);j=h+c*m;i=g+f*m;o.calloutStartX=b.x(j,i);o.calloutStartY=b.y(j,i);j=h+c*(m+q);i=g+f*(m+q);o.calloutPlaceX=b.x(j,i);o.calloutPlaceY=b.y(j,i);if(!s.rotateLabels){o.rotationRads=0}else{switch(d.attr.orientation){case"horizontal":o.rotationRads=k+Math.atan2(b.y(1,0)-b.y(0,0),b.x(1,0)-b.x(0,0))+Math.PI/2;break;case"vertical":o.rotationRads=k+Math.atan2(b.y(1,0)-b.y(0,0),b.x(1,0)-b.x(0,0));break}}o.calloutColor=(a&&a.color)||w.attr.fillStyle;if(a){if(a.width){o.calloutWidth=a.width}}else{o.calloutHasLine=false}o.globalAlpha=s.globalAlpha*s.fillOpacity;o.hidden=(s.startAngle==s.endAngle);if(d.attr.renderer){z=d.attr.renderer.call(w,w.attr.label,e,o,w.rendererData,w.rendererIndex);if(typeof z==="string"){o.text=z}else{Ext.apply(o,z)}}w.putMarker("labels",o,r);u=w.getMarkerBBox("labels",r,true);if(u){if(s.doCallout){if(d.attr.display==="outside"){w.putMarker("labels",{callout:1},r)}else{if(d.attr.display==="inside"){w.putMarker("labels",{callout:0},r)}else{w.putMarker("labels",{callout:1-w.sliceContainsLabel(s,u)},r)}}}else{w.putMarker("labels",{globalAlpha:w.sliceContainsLabel(s,u)},r)}}},sliceContainsLabel:function(d,f){var e=d.labelOverflowPadding,h=(d.endRho+d.startRho)/2,g=h+(f.width+e)/2,i=h-(f.width+e)/2,j,c,b,a;if(e<0){return 1}if(f.width+e*2>(d.endRho-d.startRho)){return 0}c=Math.sqrt(d.endRho*d.endRho-g*g);b=Math.sqrt(d.endRho*d.endRho-i*i);j=Math.abs(d.endAngle-d.startAngle);a=(j>Math.PI/2?i:Math.abs(Math.tan(j/2))*i);if(f.height+e*2>Math.min(c,b,a)*2){return 0}return 1}});Ext.define("Ext.chart.series.Pie",{extend:"Ext.chart.series.Polar",requires:["Ext.chart.series.sprite.PieSlice"],type:"pie",alias:"series.pie",seriesType:"pieslice",config:{labelField:false,lengthField:false,donut:0,field:null,rotation:0,clockwise:true,totalAngle:2*Math.PI,hidden:[],radiusFactor:100,highlightCfg:{margin:20},style:{}},directions:["X"],setField:function(a){return this.setXField(a)},getField:function(){return this.getXField()},applyLabel:function(a,b){if(Ext.isObject(a)&&!Ext.isString(a.orientation)){Ext.apply(a=Ext.Object.chain(a),{orientation:"vertical"})}if(!b){b=new Ext.chart.Markers({zIndex:10});b.setTemplate(new Ext.chart.label.Label(a))}else{b.getTemplate().setAttributes(a)}return b},updateLabelData:function(){var h=this,j=h.getStore(),g=j.getData().items,e=h.getSprites(),a=h.getLabel().getTemplate().getField(),d=h.getHidden(),b,f,c,k;if(e.length>0&&a){c=[];for(b=0,f=g.length;b<f;b++){c.push(g[b].get(a))}for(b=0,f=e.length;b<f;b++){k=e[b];k.setAttributes({label:c[b]});k.putMarker("labels",{hidden:d[b]},k.attr.attributeId)}}},coordinateX:function(){var n=this,q=n.getStore(),m=q.getData().items,a=m.length,o=n.getXField(),l=n.getLengthField(),p,h=0,d,c=0,g=n.getHidden(),r=[],f,e=0,k=n.getTotalAngle(),b=n.getClockwise()?1:-1,j=n.getSprites();if(!j){return}for(f=0;f<a;f++){p=Math.abs(Number(m[f].get(o)))||0;d=l&&Math.abs(Number(m[f].get(l)))||0;if(!g[f]){h+=p;if(d>c){c=d}}r[f]=h;if(f>=g.length){g[f]=false}}n.maxLength=c;if(h!==0){h=k/h}for(f=0;f<a;f++){j[f].setAttributes({startAngle:e,endAngle:e=(h?b*r[f]*h:0),globalAlpha:1})}for(;f<n.sprites.length;f++){j[f].setAttributes({startAngle:k,endAngle:k,globalAlpha:0})}n.getChart().refreshLegendStore()},updateCenter:function(a){this.setStyle({translationX:a[0]+this.getOffsetX(),translationY:a[1]+this.getOffsetY()});this.doUpdateStyles()},updateRadius:function(a){this.setStyle({startRho:a*this.getDonut()*0.01,endRho:a*this.getRadiusFactor()*0.01});this.doUpdateStyles()},getStyleByIndex:function(d){var j=this,h=j.getStore().getData().items,g=j.getLengthField(),e=j.getRadius(),a,c,f,b;c=g&&Math.abs(Number(h[d].get(g)))||0;f=e*j.getDonut()*0.01;b=e*j.getRadiusFactor()*0.01;a=this.callParent([d]);a.startRho=f;a.endRho=j.maxLength?(f+(b-f)*c/j.maxLength):b;return a},updateDonut:function(b){var a=this.getRadius();this.setStyle({startRho:a*b*0.01,endRho:a*this.getRadiusFactor()*0.01});this.doUpdateStyles()},rotationOffset:-0.5*Math.PI,updateRotation:function(a){this.setStyle({rotationRads:a+this.rotationOffset});this.doUpdateStyles()},updateTotalAngle:function(a){this.processData()},getSprites:function(){var k=this,h=k.getChart(),n=k.getStore();if(!h||!n){return[]}k.getColors();k.getSubStyle();var j=n.getData().items,b=j.length,d=k.getAnimation()||h&&h.getAnimation(),g=k.sprites,o,l=0,f,e,c=false,m=k.getLabel(),a=m.getTemplate();f={store:n,field:k.getField(),series:k};for(e=0;e<b;e++){o=g[e];if(!o){o=k.createSprite();if(k.getHighlight()){o.config.highlight=k.getHighlight();o.addModifier("highlight",true)}if(a.getField()){a.setAttributes({labelOverflowPadding:k.getLabelOverflowPadding()});a.fx.setCustomDurations({callout:200});o.bindMarker("labels",m)}o.setAttributes(k.getStyleByIndex(e));o.rendererData=f;o.rendererIndex=l++;c=true}o.fx.setConfig(d)}if(c){k.doUpdateStyles()}return k.sprites},betweenAngle:function(d,f,c){var e=Math.PI*2,g=this.rotationOffset;if(!this.getClockwise()){d*=-1;f*=-1;c*=-1;f-=g;c-=g}else{f+=g;c+=g}c-=f;d-=f;d%=e;c%=e;d+=e;c+=e;d%=e;c%=e;return d<c},getItemForAngle:function(a){var h=this,f=h.getSprites(),d;a%=Math.PI*2;while(a<0){a+=Math.PI*2}if(f){var j=h.getStore(),g=j.getData().items,c=h.getHidden(),b=0,e=j.getCount();for(;b<e;b++){if(!c[b]){d=f[b].attr;if(d.startAngle<=a&&d.endAngle>=a){return{series:h,sprite:f[b],index:b,record:g[b],field:h.getXField()}}}}}return null},getItemForPoint:function(h,g){var t=this,e=t.getSprites();if(e){var s=t.getCenter(),q=t.getOffsetX(),p=t.getOffsetY(),d=h-s[0]+q,c=g-s[1]+p,b=t.getStore(),j=t.getDonut(),o=b.getData().items,r=Math.atan2(c,d)-t.getRotation(),a=Math.sqrt(d*d+c*c),l=t.getRadius()*j*0.01,m=t.getHidden(),n,f,k;for(n=0,f=o.length;n<f;n++){if(!m[n]){k=e[n].attr;if(a>=l+k.margin&&a<=k.endRho+k.margin){if(t.betweenAngle(r,k.startAngle,k.endAngle)){return{series:t,sprite:e[n],index:n,record:o[n],field:t.getXField()}}}}}return null}},provideLegendInfo:function(e){var g=this,j=g.getStore();if(j){var f=j.getData().items,b=g.getLabel().getTemplate().getField(),h=g.getField(),d=g.getHidden(),c,a,k;for(c=0;c<f.length;c++){a=g.getStyleByIndex(c);k=a.fillStyle;if(Ext.isObject(k)){k=k.stops&&k.stops[0].color}e.push({name:b?String(f[c].get(b)):h+" "+c,mark:k||a.strokeStyle||"black",disabled:d[c],series:g.getId(),index:c})}}}});Ext.define("Ext.chart.series.sprite.Pie3DPart",{extend:"Ext.draw.sprite.Path",mixins:{markerHolder:"Ext.chart.MarkerHolder"},alias:"sprite.pie3dPart",type:"pie3dPart",inheritableStatics:{def:{processors:{centerX:"number",centerY:"number",startAngle:"number",endAngle:"number",startRho:"number",endRho:"number",margin:"number",thickness:"number",distortion:"number",baseColor:"color",baseRotation:"number",part:"enums(top,start,end,inner,outer)"},aliases:{rho:"endRho"},dirtyTriggers:{centerX:"path,bbox",centerY:"path,bbox",startAngle:"path,partZIndex",endAngle:"path,partZIndex",startRho:"path",endRho:"path,bbox",margin:"path,bbox",thickness:"path",baseRotation:"path,partZIndex,partColor",baseColor:"partZIndex,partColor",part:"path,partZIndex"},defaults:{centerX:0,centerY:0,startAngle:0,endAngle:0,startRho:0,endRho:150,margin:0,distortion:1,baseRotation:0,baseColor:"white",part:"top"},updaters:{partColor:function(c){var b=Ext.draw.Color.fly(c.baseColor),a;switch(c.part){case"top":a=b.toString();break;case"outer":a=Ext.create("Ext.draw.gradient.Linear",{type:"linear",stops:[{offset:0,color:b.createDarker(0.3).toString()},{offset:0.3,color:b.toString()},{offset:0.8,color:b.createLighter(0.2).toString()},{offset:1,color:b.createDarker(0.4).toString()}]});break;case"start":a=b.createDarker(0.3).toString();break;case"end":a=b.createDarker(0.3).toString();break;case"inner":a=Ext.create("Ext.draw.gradient.Linear",{type:"linear",stops:[{offset:0,color:b.createDarker(0.4).toString()},{offset:0.2,color:b.createLighter(0.2).toString()},{offset:0.7,color:b.toString()},{offset:1,color:b.createDarker(0.3).toString()}]});break}c.fillStyle=a;c.canvasAttributes.fillStyle=a},partZIndex:function(a){var b=a.baseRotation;switch(a.part){case"top":a.zIndex=5;break;case"outer":a.zIndex=4;break;case"start":a.zIndex=1+Math.sin(a.startAngle+b);break;case"end":a.zIndex=1+Math.sin(a.endAngle+b);break;case"inner":a.zIndex=1;break}a.dirtyZIndex=true}}}},updatePlainBBox:function(c){var a=this.attr,b=a.part==="inner"?a.startRho:a.endRho;c.width=b*2;c.height=b*a.distortion*2+a.thickness;c.x=a.centerX-b;c.y=a.centerY-b*a.distortion},updateTransformedBBox:function(a){return this.updatePlainBBox(a)},updatePath:function(a){if(this.attr.endAngle<this.attr.startAngle){return}this[this.attr.part+"Renderer"](a)},topRenderer:function(n){var k=this.attr,g=k.margin,c=k.distortion,i=k.centerX,h=k.centerY,f=k.baseRotation,j=k.startAngle+f,e=k.endAngle+f,d=(j+e)*0.5,l=k.startRho,b=k.endRho,m=Math.sin(e),a=Math.cos(e);i+=Math.cos(d)*g;h+=Math.sin(d)*g*c;n.ellipse(i,h,l,l*c,0,j,e,false);n.lineTo(i+a*b,h+m*b*c);n.ellipse(i,h,b,b*c,0,e,j,true);n.closePath()},startRenderer:function(o){var l=this.attr,g=l.margin,i=l.centerX,h=l.centerY,c=l.distortion,f=l.baseRotation,k=l.startAngle+f,e=l.endAngle+f,n=l.thickness,m=l.startRho,b=l.endRho,a=Math.sin(k),j=Math.cos(k),d;if(j<0){d=(k+e)*0.5;i+=Math.cos(d)*g;h+=Math.sin(d)*g*c;o.moveTo(i+j*m,h+a*m*c);o.lineTo(i+j*b,h+a*b*c);o.lineTo(i+j*b,h+a*b*c+n);o.lineTo(i+j*m,h+a*m*c+n);o.closePath()}},endRenderer:function(o){var j=this.attr,f=j.margin,h=j.centerX,g=j.centerY,b=j.distortion,e=j.baseRotation,i=j.startAngle+e,d=j.endAngle+e,m=j.thickness,k=j.startRho,a=j.endRho,l=Math.sin(d),n=Math.cos(d),c;if(n>0){c=(i+d)*0.5;h+=Math.cos(c)*f;g+=Math.sin(c)*f*b;o.moveTo(h+n*k,g+l*k*b);o.lineTo(h+n*a,g+l*a*b);o.lineTo(h+n*a,g+l*a*b+m);o.lineTo(h+n*k,g+l*k*b+m);o.closePath()}},innerRenderer:function(q){var l=this.attr,g=l.margin,i=l.centerX,h=l.centerY,b=l.distortion,e=l.baseRotation,k=l.startAngle+e,d=l.endAngle+e,c=(k+d)*0.5,o=l.thickness,n=l.startRho,j=l.globalAlpha<1,p,a,f,m;i+=Math.cos(c)*g;h+=Math.sin(c)*g*b;if(k>=Math.PI*2||j){k-=Math.PI*2;d-=Math.PI*2}if(d>Math.PI&&d<Math.PI*3||j){f=k;m=Math.min(d,Math.PI*2);p=Math.sin(m);a=Math.cos(m);q.ellipse(i,h,n,n*b,0,f,m,false);q.lineTo(i+a*n,h+p*n*b+o);q.ellipse(i,h+o,n,n*b,0,m,f,true);q.closePath()}if(d>Math.PI*3){f=Math.PI;m=d;p=Math.sin(m);a=Math.cos(m);q.ellipse(i,h,n,n*b,0,f,m,false);q.lineTo(i+a*n,h+p*n*b+o);q.ellipse(i,h+o,n,n*b,0,m,f,true);q.closePath()}},outerRenderer:function(q){var m=this.attr,h=m.margin,j=m.centerX,i=m.centerY,c=m.distortion,f=m.baseRotation,l=m.startAngle+f,e=m.endAngle+f,d=(l+e)*0.5,o=m.thickness,b=m.endRho,k=m.globalAlpha<1,p,a,g,n;j+=Math.cos(d)*h;i+=Math.sin(d)*h*c;if(l>=Math.PI*2||k){l-=Math.PI*4;e-=Math.PI*4}if(l<Math.PI||k){g=l;n=Math.min(e,Math.PI);p=Math.sin(n);a=Math.cos(n);q.ellipse(j,i,b,b*c,0,g,n,false);q.lineTo(j+a*b,i+p*b*c+o);q.ellipse(j,i+o,b,b*c,0,n,g,true);q.closePath()}if(e>Math.PI*2){g=Math.max(l,Math.PI*2);n=e;p=Math.sin(n);a=Math.cos(n);q.ellipse(j,i,b,b*c,0,g,n,false);q.lineTo(j+a*b,i+p*b*c+o);q.ellipse(j,i+o,b,b*c,0,n,g,true);q.closePath()}}});Ext.define("Ext.chart.series.Pie3D",{requires:["Ext.chart.series.sprite.Pie3DPart"],extend:"Ext.chart.series.Polar",type:"pie3d",seriesType:"pie3d",alias:"series.pie3d",config:{rect:[0,0,0,0],thickness:35,distortion:0.5,field:null,lengthField:false,donut:false,rotation:0},itemOffset:5,setField:function(a){return this.setXField(a)},getField:function(){return this.getXField()},applyRotation:function(b){var a=Math.PI*2;return(b%a+a)%a},updateRotation:function(b){var d=this.getSprites(),a,c;for(a=0,c=d.length;a<c;a++){d[a].setAttributes({baseRotation:b})}},updateColors:function(a){this.setSubStyle({baseColor:a})},doUpdateStyles:function(){var e=this.getSprites(),d=this.itemOffset,b=0,a=0,c=e&&e.length;for(;b<c;b+=d,a++){e[b].setAttributes(this.getStyleByIndex(a));e[b+1].setAttributes(this.getStyleByIndex(a));e[b+2].setAttributes(this.getStyleByIndex(a));e[b+3].setAttributes(this.getStyleByIndex(a));e[b+4].setAttributes(this.getStyleByIndex(a))}},processData:function(){var k=this,h=k.getChart(),c=h&&h.getAnimation(),o=k.getStore(),j=o.getData().items,a=j.length,m=k.getField(),n,e=0,g,q=[],f=this.getSprites(),l=k.itemOffset,p,b,d;for(d=0;d<a;d++){n=j[d].get(m);e+=n;q[d]=e}if(e===0){return}g=2*Math.PI/e;for(d=0;d<a;d++){q[d]*=g}for(d=0;d<f.length;d++){f[d].fx.setConfig(c)}for(d=0,b=0;d<a;d++){p={opacity:1,startAngle:b,endAngle:q[d]};f[d*l].setAttributes(p);f[d*l+1].setAttributes(p);f[d*l+2].setAttributes(p);f[d*l+3].setAttributes(p);f[d*l+4].setAttributes(p);b=q[d]}},getSprites:function(){var y=this,n=this.getChart(),q=y.getSurface(),j=y.getStore();if(!j){return[]}var o=j.getData().items,m=y.itemOffset,f=o.length,u=y.getAnimation()||n&&n.getAnimation(),d=n.getMainRect()||[0,0,1,1],r=y.getRotation(),w=y.getCenter(),v=y.getOffsetX(),t=y.getOffsetY(),g=Math.min((d[3]-y.getThickness()*2)/y.getDistortion(),d[2])/2,h={centerX:w[0]+v,centerY:w[1]+t-y.getThickness()/2,endRho:g,startRho:g*y.getDonut()/100,thickness:y.getThickness(),distortion:y.getDistortion()},k,b=Math.PI*2,l=y.sprites,c,e,p,a,x,s;for(s=0;s<f;s++){k=Ext.apply({},this.getStyleByIndex(s),h);c=l[s*m];if(!c){c=q.add({type:"pie3dPart",part:"top",startAngle:b,endAngle:b});e=q.add({type:"pie3dPart",part:"start",startAngle:b,endAngle:b});p=q.add({type:"pie3dPart",part:"end",startAngle:b,endAngle:b});a=q.add({type:"pie3dPart",part:"inner",startAngle:b,endAngle:b,thickness:0});x=q.add({type:"pie3dPart",part:"outer",startAngle:b,endAngle:b,thickness:0});c.fx.setDurationOn("baseRotation",0);e.fx.setDurationOn("baseRotation",0);p.fx.setDurationOn("baseRotation",0);a.fx.setDurationOn("baseRotation",0);x.fx.setDurationOn("baseRotation",0);l.push(c,e,p,a,x)}else{e=l[s*m+1];p=l[s*m+2];a=l[s*m+3];x=l[s*m+4];if(u){c.fx.setConfig(u);e.fx.setConfig(u);p.fx.setConfig(u);a.fx.setConfig(u);x.fx.setConfig(u)}}c.setAttributes(k);e.setAttributes(k);p.setAttributes(k);a.setAttributes(k);x.setAttributes(k)}for(s*=m,ln=l.length;s<ln;s++){l[s].fx.setConfig(u);l[s].setAttributes({opacity:0,startAngle:b,endAngle:b,baseRotation:r})}return l}});Ext.define("Ext.chart.series.sprite.Polar",{mixins:{markerHolder:"Ext.chart.MarkerHolder"},extend:"Ext.draw.sprite.Sprite",inheritableStatics:{def:{processors:{dataMinX:"number",dataMaxX:"number",dataMinY:"number",dataMaxY:"number",rangeX:"data",rangeY:"data",dataY:"data",dataX:"data",centerX:"number",centerY:"number",startAngle:"number",endAngle:"number",startRho:"number",endRho:"number",baseRotation:"number",labels:"default",labelOverflowPadding:"number"},defaults:{dataY:null,dataX:null,dataMinX:0,dataMaxX:1,dataMinY:0,dataMaxY:1,centerX:0,centerY:0,startAngle:0,endAngle:Math.PI,startRho:0,endRho:150,baseRotation:0,labels:null,labelOverflowPadding:10},dirtyTriggers:{dataX:"bbox",dataY:"bbox",dataMinX:"bbox",dataMaxX:"bbox",dataMinY:"bbox",dataMaxY:"bbox",centerX:"bbox",centerY:"bbox",startAngle:"bbox",endAngle:"bbox",startRho:"bbox",endRho:"bbox",baseRotation:"bbox"}}},config:{store:null,field:null},updatePlainBBox:function(b){var a=this.attr;b.x=a.centerX-a.endRho;b.y=a.centerY+a.endRho;b.width=a.endRho*2;b.height=a.endRho*2}});Ext.define("Ext.chart.series.sprite.Radar",{alias:"sprite.radar",extend:"Ext.chart.series.sprite.Polar",render:function(p,q){var B=this,o=B.attr,e=o.centerX,d=o.centerY,t=o.matrix,A=o.dataMinX,z=o.dataMaxX,w=o.dataMaxY,k=o.dataX,j=o.dataY,s=o.rangeY,m=o.endRho,v=o.startRho,f=o.baseRotation,u,a=k.length,l={},b=B.surfaceMatrix,h,g,n,c;q.beginPath();for(u=0;u<a;u++){c=(k[u]-A)/(z-A+1)*2*Math.PI+f;n=j[u]/(s?s[1]:w)*(m-v)+v;h=t.x(e+Math.cos(c)*n,d+Math.sin(c)*n);g=t.y(e+Math.cos(c)*n,d+Math.sin(c)*n);if(u===0){q.moveTo(h,g)}q.lineTo(h,g);l.translationX=b.x(h,g);l.translationY=b.y(h,g);B.putMarker("markers",l,u,true)}q.closePath();q.fillStroke(o)}});Ext.define("Ext.chart.series.Radar",{extend:"Ext.chart.series.Polar",type:"radar",seriesType:"radar",alias:"series.radar",requires:["Ext.chart.series.sprite.Radar"],config:{},themeColorCount:function(){return 1},themeMarkerCount:function(){return 1},updateAngularAxis:function(a){a.processData(this)},updateRadialAxis:function(a){a.processData(this)},coordinateX:function(){return this.coordinate("X",0,2)},coordinateY:function(){return this.coordinate("Y",1,2)},updateCenter:function(a){this.setStyle({translationX:a[0]+this.getOffsetX(),translationY:a[1]+this.getOffsetY()});this.doUpdateStyles()},updateRadius:function(a){this.setStyle({endRho:a});this.doUpdateStyles()},updateRotation:function(a){this.setStyle({rotationRads:a});this.doUpdateStyles()},updateTotalAngle:function(a){this.processData()},getItemForPoint:function(j,h){var A=this,o=A.sprites&&A.sprites[0],p=o.attr,l=p.dataX,k=p.dataY,f=p.centerX,e=p.centerY,z=p.dataMinX,w=p.dataMaxX,u=p.dataMaxY,m=p.endRho,t=p.startRho,g=p.baseRotation,s,a=l.length,c=A.getStore(),d=A.getMarker(),q=22,v,b,n;if(A.getHidden()){return null}if(o&&d){for(s=0;s<a;s++){b=(l[s]-z)/(w-z+1)*2*Math.PI+g;n=k[s]/u*(m-t)+t;if(Math.abs(f+Math.cos(b)*n-j)<q&&Math.abs(e+Math.sin(b)*n-h)<q){v={series:A,sprite:o,index:s,record:c.getData().items[s],field:A.getYField()};return v}}}return A.callParent(arguments)},getSprites:function(){if(!this.getChart()){return[]}if(!this.sprites.length){this.createSprite()}return this.sprites},provideLegendInfo:function(d){var b=this,a=b.getSubStyleWithTheme(),c=a.fillStyle;if(Ext.isArray(c)){c=c[0]}d.push({name:b.getTitle()||b.getYField()||b.getId(),mark:(Ext.isObject(c)?c.stops&&c.stops[0].color:c)||a.strokeStyle||"black",disabled:b.getHidden(),series:b.getId(),index:0})}});Ext.define("Ext.chart.series.sprite.Scatter",{alias:"sprite.scatterSeries",extend:"Ext.chart.series.sprite.Cartesian",renderClipped:function(o,p,u,r){if(this.cleanRedraw){return}var z=this,n=z.attr,h=n.dataX,f=n.dataY,v=n.labels,t=v&&z.getBoundMarker("labels"),q=z.attr.matrix,b=q.getXX(),m=q.getYY(),j=q.getDX(),g=q.getDY(),k={},A,a=r[0]-b,w=r[0]+r[2]+b,l=r[1]-m,c=r[1]+r[3]+m,e,d;for(var s=0;s<h.length;s++){e=h[s];d=f[s];e=e*b+j;d=d*m+g;if(a<=e&&e<=w&&l<=d&&d<=c){if(n.renderer){k={type:"items",translationX:e,translationY:d};A=n.renderer.call(z,z,k,{store:z.getStore()},s);k=Ext.apply(k,A)}else{k.translationX=e;k.translationY=d}z.putMarker("items",k,s,!n.renderer);if(t&&v[s]){z.drawLabel(v[s],e,d,s,r)}}}},drawLabel:function(j,h,g,p,a){var q=this,m=q.attr,d=q.getBoundMarker("labels")[0],c=d.getTemplate(),l=q.labelCfg||(q.labelCfg={}),b=q.surfaceMatrix,f,e,i=m.labelOverflowPadding,o=m.flipXY,k,n,r;l.text=j;n=q.getMarkerBBox("labels",p,true);if(!n){q.putMarker("labels",l,p);n=q.getMarkerBBox("labels",p,true)}if(o){l.rotationRads=Math.PI*0.5}else{l.rotationRads=0}k=n.height/2;f=h;switch(c.attr.display){case"under":e=g-k-i;break;case"rotate":f+=i;e=g-i;l.rotationRads=-Math.PI/4;break;default:e=g+k+i}l.x=b.x(f,e);l.y=b.y(f,e);if(c.attr.renderer){r=c.attr.renderer.call(q,j,d,l,{store:q.getStore()},p);if(typeof r==="string"){l.text=r}else{Ext.apply(l,r)}}q.putMarker("labels",l,p)}});Ext.define("Ext.chart.series.Scatter",{extend:"Ext.chart.series.Cartesian",alias:"series.scatter",type:"scatter",seriesType:"scatterSeries",requires:["Ext.chart.series.sprite.Scatter"],config:{itemInstancing:{fx:{customDurations:{translationX:0,translationY:0}}}},themeMarkerCount:function(){return 1},applyMarker:function(b,a){this.getItemInstancing();this.setItemInstancing(b);return this.callParent(arguments)},provideLegendInfo:function(d){var b=this,a=b.getMarkerStyleByIndex(0),c=a.fillStyle;d.push({name:b.getTitle()||b.getYField()||b.getId(),mark:(Ext.isObject(c)?c.stops&&c.stops[0].color:c)||a.strokeStyle||"black",disabled:b.getHidden(),series:b.getId(),index:0})}});Ext.define("Ext.chart.theme.Blue",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.blue","chart.theme.Blue"],config:{baseColor:"#4d7fe6"}});Ext.define("Ext.chart.theme.BlueGradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.blue-gradients","chart.theme.Blue:gradients"],config:{baseColor:"#4d7fe6",gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Category1",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category1","chart.theme.Category1"],config:{colors:["#f0a50a","#c20024","#2044ba","#810065","#7eae29"]}});Ext.define("Ext.chart.theme.Category1Gradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category1-gradients","chart.theme.Category1:gradients"],config:{colors:["#f0a50a","#c20024","#2044ba","#810065","#7eae29"],gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Category2",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category2","chart.theme.Category2"],config:{colors:["#6d9824","#87146e","#2a9196","#d39006","#1e40ac"]}});Ext.define("Ext.chart.theme.Category2Gradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category2-gradients","chart.theme.Category2:gradients"],config:{colors:["#6d9824","#87146e","#2a9196","#d39006","#1e40ac"],gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Category3",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category3","chart.theme.Category3"],config:{colors:["#fbbc29","#ce2e4e","#7e0062","#158b90","#57880e"]}});Ext.define("Ext.chart.theme.Category3Gradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category3-gradients","chart.theme.Category3:gradients"],config:{colors:["#fbbc29","#ce2e4e","#7e0062","#158b90","#57880e"],gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Category4",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category4","chart.theme.Category4"],config:{colors:["#ef5773","#fcbd2a","#4f770d","#1d3eaa","#9b001f"]}});Ext.define("Ext.chart.theme.Category4Gradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category4-gradients","chart.theme.Category4:gradients"],config:{colors:["#ef5773","#fcbd2a","#4f770d","#1d3eaa","#9b001f"],gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Category5",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category5","chart.theme.Category5"],config:{colors:["#7eae29","#fdbe2a","#910019","#27b4bc","#d74dbc"]}});Ext.define("Ext.chart.theme.Category5Gradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category5-gradients","chart.theme.Category5:gradients"],config:{colors:["#7eae29","#fdbe2a","#910019","#27b4bc","#d74dbc"],gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Category6",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category6","chart.theme.Category6"],config:{colors:["#44dce1","#0b2592","#996e05","#7fb325","#b821a1"]}});Ext.define("Ext.chart.theme.Category6Gradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.category6-gradients","chart.theme.Category6:gradients"],config:{colors:["#44dce1","#0b2592","#996e05","#7fb325","#b821a1"],gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.DefaultGradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.default-gradients","chart.theme.Base:gradients"],config:{gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Green",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.green","chart.theme.Green"],config:{baseColor:"#b1da5a"}});Ext.define("Ext.chart.theme.GreenGradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.green-gradients","chart.theme.Green:gradients"],config:{baseColor:"#b1da5a",gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Purple",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.purple","chart.theme.Purple"],config:{baseColor:"#da5abd"}});Ext.define("Ext.chart.theme.PurpleGradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.purple-gradients","chart.theme.Purple:gradients"],config:{baseColor:"#da5abd",gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Red",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.red","chart.theme.Red"],config:{baseColor:"#e84b67"}});Ext.define("Ext.chart.theme.RedGradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.red-gradients","chart.theme.Red:gradients"],config:{baseColor:"#e84b67",gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Sky",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.sky","chart.theme.Sky"],config:{baseColor:"#4ce0e7"}});Ext.define("Ext.chart.theme.SkyGradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.sky-gradients","chart.theme.Sky:gradients"],config:{baseColor:"#4ce0e7",gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.theme.Yellow",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.yellow","chart.theme.Yellow"],config:{baseColor:"#fec935"}});Ext.define("Ext.chart.theme.YellowGradients",{extend:"Ext.chart.theme.Base",singleton:true,alias:["chart.theme.yellow-gradients","chart.theme.Yellow:gradients"],config:{baseColor:"#fec935",gradients:{type:"linear",degrees:90}}});Ext.define("Ext.chart.TipSurface",{extend:"Ext.draw.Container",spriteArray:false,renderFirst:true,constructor:function(a){this.callParent([a]);if(a.sprites){this.spriteArray=[].concat(a.sprites);delete a.sprites}},onRender:function(){var c=this,b=0,a=0,d,e;this.callParent(arguments);e=c.spriteArray;if(c.renderFirst&&e){c.renderFirst=false;for(a=e.length;b<a;b++){d=c.surface.add(e[b]);d.setAttributes({hidden:false},true)}}}});Ext.define("Ext.chart.interactions.ItemInfo",{extend:"Ext.chart.interactions.Abstract",type:"iteminfo",alias:"interaction.iteminfo",config:{extjsGestures:{start:{event:"click",handler:"onInfoGesture"},move:{event:"mousemove",handler:"onInfoGesture"},end:{event:"mouseleave",handler:"onInfoGesture"}}},item:null,onInfoGesture:function(f,a){var c=this,b=c.getItemForEvent(f),d=b&&b.series.tooltip;if(d){d.onMouseMove.call(d,f)}if(b!==c.item){if(b){b.series.showTip(b)}else{c.item.series.hideTip(c.item)}c.item=b}return false}});if(Ext.defaultSetupConfig&&Ext.defaultSetupConfig.eventPublishers){Ext.defaultSetupConfig.eventPublishers.seriesItemEvents={xclass:"Ext.chart.series.ItemPublisher"}};