$(document).ready(function () {
    // Trigger change for selectmenu
    $('body').on('selectmenuchange', 'select', function(e, item) { $(this).trigger('change', [ e, item ]); });
    // Login box
    $("[name=j_username]").focus();
    // Convert 'nice-checkboxes' to nice checkbox
    $('.nice-checkbox').each(function() {
        var checkbox = $(this);
        var checkboxReplace = $('<span class="checkbox"></span>');
        function toggleStyle() {
            if(checkbox[0].checked) {
                checkboxReplace.addClass('checked');
            } else {
                checkboxReplace.removeClass('checked');
            }
        }
        checkboxReplace.on('click', function() {
            checkbox[0].checked = !checkbox[0].checked;
            toggleStyle();
        });
        checkbox.on('change', function() {
            toggleStyle();
        });
        toggleStyle();
        $(this).hide().after(checkboxReplace);
    });
    // Init popups
    $('.modal-dialog').each(function() {
        var el = $(this);
        var width = el.data('width');
        var height = el.data('height');
        el.dialog({
            autoOpen: false,
            modal: true,
            draggable: false,
            resizable: false,
            open: function( event, ui ) {
                // Set width/height
                el.dialog("option", "height", height ? height : 680);
                el.dialog("option", "width", (width ? width : $(window).width() * 0.9));
                // Remove close button
                el.parent().find('.ui-dialog-titlebar').remove();
                if(el.parent().find('.dialog-close').length !== 1) {
                    el.parent().prepend($('<div class="dialog-close"></div>').on('click', function() {
                        el.dialog("close");
                    }));
                }
                el.css("max-height", "95vh");
                // Fire open complete event
                el.trigger('dialogopened');
            }
        });
        el.find('.closebutton').on('click', function() {
            el.dialog("close");
        });
    });
    // Init popup toggles
    $('.modal-dialog-toggle').on('click', function(e) {
        e.preventDefault();
        $($(this).data('target')).dialog("open");
    });
});
Ext.define('B3p.planmonitor.Main', {
    singleton: true,
    convertSelect: function(select) {
        if(typeof select === 'string') {
            var selects = document.querySelectorAll(select);
            for(var i = 0; i < selects.length; i++) {
                this._convertSelect(selects[i],select);
            }
        } else {
            this._convertSelect(select);
        }
    },
    _convertSelect: function(select, previousClass) {
        var multiple = select.hasAttribute('multiple');
        var emptyText = select.getAttribute('data-emptytext');
        var alwaysShowEmptyText = select.getAttribute('data-showemptytext');
        var selectedItems = select.querySelectorAll('[selected]');
        if(selectedItems.length === 0) {
            // In case options are created by JS, [selected] returns no items
            // Check selected manually on all options
            selectedItems = [];
            for(var i = 0; i < select.options.length; i++) {
                if(select.options[i].selected) {
                    selectedItems.push(select.options[i]);
                }
            }
        }
        var selectedValue = multiple ? [] : null;
        if(alwaysShowEmptyText !== 'true') for(var i = 0; i < selectedItems.length; i++) {
            if(multiple) {
                selectedValue.push(selectedItems[i].value);
            } else {
                selectedValue = selectedItems[i].value;
            }
        }
        var hidden = document.createElement('input');
        hidden.type = 'hidden';
        hidden.value = multiple ? selectedValue.join(',') : selectedValue;
        if(select.hasAttribute('name')) {
            hidden.name = select.getAttribute('name');
        }
        if(select.hasAttribute('id')) {
            hidden.id = select.getAttribute('id');
        }
        var prevClass = previousClass.replace(/\./g,"");
        var otherClasses = select.className.split(prevClass).join("");
        var comboconfig = {
            typeAhead: !multiple,
            triggerAction: 'all',
            width: '100%',
            transform: select,
            multiSelect: multiple,
            emptyText: emptyText,
            emptyCls: '.x-form-empty-field .italic',
            cls: 'nice-select ' + otherClasses,
            value: selectedValue,
            name: Ext.id(),
            itemId: hidden.id ? "ext-" + hidden.id : Ext.id(),
            listeners: {
                collapse: {
                    fn: function(combo) {
                        var val = combo.getValue();
                        if((Ext.isArray(val) && val.length === 0) || val === '') {
                            hidden.value = '';
                            this._triggerChange(hidden);
                        }
                    },
                    scope: this
                },
                select: {
                    fn: function(combo, records) {
                        var values = '';
                        for(var i = 0; i < records.length; i++) {
                            values += (i === 0 ? '' : ',') + records[i].getData()[records[i].getFields()[0].name];
                        }
                        hidden.value = values;
                        this._triggerChange(hidden);
                    },
                    scope: this
                },
                afterrender: function(combo) {
                    combo.getEl().dom.parentNode.appendChild(hidden);
                }
            }
        };
        if(select.onchange){
            comboconfig.listeners.change = select.onchange;
        }

        Ext.create('Ext.form.field.ComboBox', comboconfig); 
    },
    _triggerChange: function(el) {
        try {
            var evt = document.createEvent('Event');
            evt.initEvent("change", true, true);
            el.dispatchEvent(evt);
        } catch(e) {}
    }
});
Ext.onReady(function() {
    B3p.planmonitor.Main.convertSelect('select');
});