Ext.define('B3p.planmonitor.TotalCounter', {
    mixins: ['Ext.mixin.Observable'],
    totals: null,
    parentField: null,
    totalField: null,
    config: {
        parent: '',
        fields: [],
        subTotalSuffix: '-total',
        subTotalHiddenSuffix: '-total-hidden',
        total: '',
        doInitCount: true,
        compareField:null,
        totalChanged: null,
        repeatingFields: 1 // If fields are added multiple times using different classes then supply the no of times here
    },
    constructor: function(config) {
        this.initConfig(config);
        this.totals = {};
        this.parentField = document.querySelector(this.config.parent);
        if(!this.parentField) {
            console.log('Counter container not found: ', this.config.parent);
            return;
        }
        if(this.config.total) {
            this.totalField = this.parentField.querySelector(this.config.total);
        }
        if(this.config.doInitCount){
            this.resetTotals();
        }
        this.parentField.addEventListener('keyup', this.handleKeyup.bind(this));
    },
    resetTotals: function() {
        for(var i = 0; i < this.config.fields.length; i++) {
            this.totals[this.config.fields[i]] = 0;
            this.getTotalForField(this.config.fields[i]);
        }
        this.checkTotal();
        this.fireEvent('total_changed', this.getTotal());
    },
    handleKeyup: function(e) {
        if(e.target.tagName.toLowerCase() !== 'input') {
            return;
        }
        for(var i = 0; i < this.config.fields.length; i++) {
            if(e.target.className.indexOf(this.config.fields[i]) !== -1) {
                this.getTotalForField(this.config.fields[i]);
            }
        }
        this.checkTotal();
        this.fireEvent('total_changed', this.getTotal());
    },
    checkTotal: function(){
        if(this.config.total) {
            var totaalcapaciteit = document.getElementById('totaalcapaciteit').value;
            var el = $(this.totalField);
            if(this.getTotal() !== parseInt(totaalcapaciteit) ){
                //var el = document.getElementById(this.config.total);
                el.addClass('error');
            }else{
                el.removeClass('error');
            }
        }
    },
    getTotalForField: function(field) {
        // Find all fields
        if(!this.parentField){
            return;
        }
        var total = 0;
        var fields = this.parentField.querySelectorAll('.' + field);
        for(var i = 0; i < fields.length; i++) {
            total += +(fields[i].value);
        }
        this.totals[field] = total;
        this.setSubTotal(field);
        return total;
    },
    setSubTotal: function(field) {
        // set total
        var subtotal = this.parentField.querySelector('.' + field + this.config.subTotalSuffix);
        if(subtotal) {
            subtotal.innerHTML = this.totals[field];
        }
        var hidden = this.parentField.querySelector('.' + field + this.config.subTotalHiddenSuffix);
        if(hidden){
            hidden.value = this.totals[field];
        }
        this.setTotal();
        if(this.config.totalChanged && Object.prototype.toString.call(this.config.totalChanged) === '[object Function]') {
            this.config.totalChanged(field, this.totals, this.getTotal());
        }
    },
    setTotal: function() {
        if(!this.totalField) {
            return;
        }
        var total = this.getTotal();
        if(this.totalField.value){
            this.totalField.value = total;
            this.fireDomEvent(this.totalField, "keyup");
        }else{
            this.totalField.innerHTML = total;
        }
    },
    getTotal: function() {
        var total = 0;
        for(var field in this.totals) if(this.totals.hasOwnProperty(field)) {
            total += this.totals[field];
        }
        if(this.config.repeatingFields > 1) {
            total = total / this.config.repeatingFields;
        }
        return total;
    },
    fireDomEvent:function(element, eventname){
        var event = null; // The custom event that will be created

        if (!element.fireEvent) {
          event = document.createEvent("HTMLEvents");
          event.initEvent(eventname, true, true);
        } else {
          event = document.createEventObject();
          event.eventType = eventname;
        }

        event.eventName = eventname;
        if (!element.fireEvent) {
          element.dispatchEvent(event);
        } else {
          element.fireEvent("on" + eventname, event);
        }
    }
});