Ext.define('B3p.planmonitor.VariableCreator', {
    mainContainer: null,
    valuesContainer: null,
    dropdownFieldType: 'dropdown',
    mainCategoryType : 'number',
    addupFieldType: 'woningtypen',
    config: {
        regios: [],
        containerCls: '.create-variable',
        variableId: 0,
        variableName: '',
        variableType: 'dropdown',
        variableLocation: 'basisgegevens',
        addupField: 'ja',
        provinceField: 'nee',
        uitgebreidsteField: 'nee',
        values: [],
        selectedRegios: [],
        saveurl: '',
        hideLocation: false,
        hideProvince: false,
        hideType: false,
        isLabel: false
    },
    constructor: function(config) {
        this.initConfig(config);
        this.initInterface();
        if(!this.config.values){
            this.config.values = [];
        }
        if(!config.variableLocation){
            this.config.variableLocation = "basisgegevens";
        }
        if( this.config.values.length === 0) {
            // push returns new length of array, minus 1 gives the index
            var valueIdx = -1 + this.config.values.push({
                value:  '',
                regios:  []
            });

            this.addValue(valueIdx);
            return;
        }
        for(var i = 0; i < this.config.values.length; i++) {
            this.addValue(i);
        }
    },
    initInterface: function() {
        var me = this;
        this.mainContainer = document.querySelector(this.config.containerCls);
        this.mainContainer.className += ' variable-creator';
        // Empty contents
        while (this.mainContainer.firstChild) {
            this.mainContainer.removeChild(this.mainContainer.firstChild);
        }
        // Name field
        this.createInputrow('Naam', function() {
            var nameField = document.createElement('input');
            nameField.type = 'text';
            nameField.className = 'variable-name';
            nameField.readOnly = me.config.isLabel;
            nameField.value = me.config.variableName || '';
            return nameField;
        });
        // Type field
        var typerow = this.createInputrow('Type', function() {
            return me.createSelect(B3p.planmonitor.Config.variabletypes, me.config.variableType, 'variable-type');
        });
        if(this.config.hideType) {
            typerow.style.display = 'none';
        }
        // Lokatie field
        var locationrow = this.createInputrow('Plaats', function() {
            return me.createSelect(B3p.planmonitor.Config.blocks, me.config.variableLocation, 'variable-location');
        });
        if(this.config.hideLocation) {
            locationrow.style.display = 'none';
        }
        // Optelveld field
        var addFieldRow = this.createInputrow('Optelveld', function() {
            return me.createSelect([ { id: 'ja', label: 'Ja' }, { id: 'nee', label: 'Nee' }], me.config.addupField, 'variable-addupfield');
        }, 'variable-addupfield-row');
        addFieldRow.style.display = (me.config.variableLocation === this.addupFieldType ? 'block' : 'none');
        
        var mainCategory = this.createInputrow('Hoofdcategorie', function(){
            return me.createSelect([{id: 'none', label: 'Geen'},{id: 'eengezins', label : 'Eengezins'}, {id: 'meergezins', label: 'Meergezins'}], me.config.mainCategory, 'variable-maincategoryfield');
        }, 'variable-maincategory-row');
        
        mainCategory.style.display = this.showMaincategory() ? 'block' : 'none';
        
        var uitgebreidste = this.createInputrow('Uitgebreide detailplanning', function(){
            return me.createSelect([ { id: 'ja', label: 'Ja' }, { id: 'nee', label: 'Nee' }], me.config.uitgebreidsteField, 'variable-uitgebreidstefield');
        }, 'variable-maincategory-row');
        
        uitgebreidste.style.display = this.showMaincategory() ? 'block' : 'none';
        
        // Provincie field
        var provincerule = this.createInputrow('Provincieveld', function() {
            return me.createSelect([ { id: 'ja', label: 'Ja' }, { id: 'nee', label: 'Nee' }], me.config.provinceField, 'variable-provincefield');
        });
        if(this.config.hideProvince) {
            provincerule.style.display = 'none';
        }
        // Global regio selector (in case of yes/no / textfield type)
        this.addGlobalRegioSelector();
        // waardes label
        var waardeslabel = document.createElement('h2');
        waardeslabel.innerHTML = 'Waardes';
        waardeslabel.className = 'values-label';
        this.mainContainer.appendChild(waardeslabel);
        // waardes label
        var toevoegenlink = document.createElement('a');
        toevoegenlink.innerHTML = '+ Waarde toevoegen';
        toevoegenlink.href = '#';
        toevoegenlink.addEventListener('click', function(e) {
            e.preventDefault();
                  // push returns new length of array, minus 1 gives the index
            var valueIdx = -1 + me.config.values.push({
                value:  '',
                regios:  []
            });
            me.addValue(valueIdx);
        });
        waardeslabel.appendChild(toevoegenlink);
        // waardes container
        this.valuesContainer = document.createElement('div');
        this.valuesContainer.className = 'variable-values';
        this.mainContainer.appendChild(this.valuesContainer);

        this.setType(me.config.variableType);
        this.mainContainer.addEventListener('change', function(e) { me.formChange(e); });
        this.mainContainer.addEventListener('keyup', function(e) { me.formChange(e); });
    },
    saveVariable: function() {
        // Skip empty values, could be removed
        var variable = {
            name: this.config.variableName,
            type: this.config.variableType,
            location: this.config.variableLocation,
            provinceField: this.config.provinceField,
            uitgebreidsteField: this.config.uitgebreidsteField,
            label: this.config.isLabel
        };
        if(variable.location === this.addupFieldType) {
            variable.addupField = this.config.addupField === 'ja';
            variable.mainCategory = this.config.mainCategory;
        }
        if(this.showMultipleValues(variable.type)) {
            var values = [];
            for(var i = 0; i < this.config.values.length; i++) {
                if(this.config.values[i].value !== '') {
                    values.push(this.config.values[i]);
                }
            }
            variable.values = values;
        } else {
            variable.regios = this.config.selectedRegios;
        }
        if(this.config.variableId !== 0) {
            variable.id = this.config.variableId;
        }
        // Save variable using AJAX call
        return $.ajax(this.config.saveurl, {
            type: 'POST',
            dataType: 'json',
            data:{
                variableJSON: JSON.stringify(variable)
            }
        });
    },
    createSelect: function(options, currentValue, className) {
        var select = document.createElement('select');
        var option;
        for(var i = 0; i < options.length; i++) {
            option = document.createElement('option');
            option.value = options[i].id;
            option.innerHTML = options[i].label;
            if(currentValue === options[i].id) {
                option.selected = true;
            }
            select.appendChild(option);
        }
        select.className = className;
        return select;
    },
    createInputrow: function(label, fieldCreator, extraClass) {
        // Create main interface
        var row = document.createElement('div');
        row.className = 'row' + (!!extraClass ? ' ' + extraClass : '');
        this.mainContainer.appendChild(row);
        // naam label
        var domLabel = document.createElement('label');
        domLabel.innerHTML = label;
        row.appendChild(domLabel);
        // input container
        var inputrow = document.createElement('div');
        inputrow.className = 'input';
        row.appendChild(inputrow);
        // name field
        inputrow.appendChild(fieldCreator());
        return row;
    },
    addValue: function(valueIdx){
        var me = this;
        var container = document.createElement('div');
        container.className = 'input';
        var input = document.createElement('input');
        input.type = 'text';
        input.value = this.config.values[valueIdx].value;
        input.setAttribute('data-type', 'value-input');
        input.setAttribute('data-valueidx', valueIdx);
        container.appendChild(input);
        var label = document.createElement('label');
        label.innerHTML = 'Waarde';
        var removelink = document.createElement('a');
        removelink.innerHTML = 'verwijder';
        removelink.href = '#';
        removelink.addEventListener('click', function(e) {
            e.preventDefault();
            // for deletion we just hide the field
            // and make the value empty because we
            // want the array indexes to remain the same
            row.style.display = 'none';
            me.config.values[valueIdx].value = '';
        });
        label.appendChild(removelink);
        var row = document.createElement('div');
        row.className = 'row';
        row.appendChild(label);
        row.appendChild(container);
        this.valuesContainer.appendChild(row);
        row.appendChild(document.createElement('hr'));
        this.createRegioSelector(container, valueIdx);
    },
    addGlobalRegioSelector: function() {
        var container = document.createElement('div');
        container.className = 'input';
        var label = document.createElement('label');
        label.innerHTML = 'Regio\'s';
        var row = document.createElement('div');
        row.className = 'row global-regio-selector';
        row.style.display = (this.showMultipleValues(this.config.variableType) ? 'none' : 'block' );
        row.appendChild(label);
        row.appendChild(container);
        this.createRegioSelector(container, -1);
        this.mainContainer.appendChild(row);
    },
    createRegioSelector: function(container, valueIdx) {
        var regioselector = document.createElement('div');
        regioselector.className = 'regioselector';
        var regios = document.createElement('div');
        regios.className = 'regios';
        var checkboxes = [];
        for(var i = 0; i < this.config.regios.length; i++) {
            checkboxes.push(this.createCheckbox(regios, this.config.regios[i].id, this.config.regios[i].label, valueIdx, 'regio'));
        }
        regioselector.appendChild(this.createCheckall(checkboxes));
        regioselector.appendChild(regios);
        container.appendChild(regioselector);
    },
    createCheckall: function(checkboxes) {
        var me = this;
        var checkall = document.createElement('div');
        checkall.className = 'check-all';
        var check = document.createElement('input');
        check.type = 'checkbox';
        check.addEventListener('change', function(e) {
            e.preventDefault();
            e.stopPropagation();
            for(var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].checked = this.checked;
                me.formChange({ target: checkboxes[i] });
            }
        });
        var label = document.createElement('label');
        var labelContent = document.createElement('span');
        labelContent.innerHTML = 'Alle selecteren';
        label.appendChild(check);
        label.appendChild(labelContent);
        checkall.appendChild(label);
        return checkall;
    },
    createCheckbox: function(container, id, label, valueIdx, type) {
        var me =  this;
        var item = document.createElement('div');
        item.className = 'blockselect';
        var checkbox = document.createElement('input');
        checkbox.type = 'checkbox';
        checkbox.value = id;
        if(valueIdx === -1) {
            checkbox.checked = this.config.selectedRegios ? this.config.selectedRegios.indexOf(id) !== -1 : false;
        } else {
            checkbox.checked = this.config.values[valueIdx].regios.indexOf(id) !== -1;
        }
        checkbox.setAttribute('data-type', type);
        checkbox.setAttribute('data-valueidx', valueIdx);
        var labelEl = document.createElement('label');
        labelEl.appendChild(checkbox);
        var span = document.createElement('span');
        span.innerHTML = label;
        labelEl.appendChild(span);
        item.appendChild(labelEl);
        container.appendChild(item);
        return checkbox;
    },
    /**
     * all changes to the different fields are bubbled up and handled by this single function
     */
    formChange: function(e) {
        var val = (e.target.tagName.toLowerCase() === 'select' ? e.target.options[e.target.selectedIndex].value : e.target.value),
            datatype = '',
            valueidx = -1,
            className = e.target.className || '';
        if(className.indexOf('variable-name') !== -1) {
            this.setName(val);
        }
        if(className.indexOf('variable-type') !== -1) {
            this.setType(val);
        }
        if(className.indexOf('variable-addupfield') !== -1 && this.config.variableLocation === this.addupFieldType) {
            this.config.addupField = val;
        }
        if(className.indexOf('variable-provincefield') !== -1) {
            this.config.provinceField = val;
        }
        if(className.indexOf('variable-uitgebreidstefield') !== -1) {
            this.config.uitgebreidsteField = val;
        }
        if(className.indexOf('variable-maincategoryfield') !== -1) {
            this.config.mainCategory = val;
        }
        if(className.indexOf('variable-location') !== -1) {
            this.setLocation(val);
            var nodes = this.mainContainer.querySelectorAll('.variable-addupfield-row');
            for( var i = 0; i < nodes.length; i++ ) {
                var node = nodes[i];
                node.style.display = (val === this.addupFieldType ? 'block' : 'none');
            }
        }
            
        var mainCategory = this.mainContainer.querySelector('.variable-maincategory-row');
        mainCategory.style.display = this.showMaincategory() ? 'block' : 'none';

        if(e.target.hasAttribute('data-type') && e.target.hasAttribute('data-valueidx')) {
            datatype = e.target.getAttribute('data-type');
            valueidx = e.target.getAttribute('data-valueidx');
            if(datatype === 'value-input') {
                this.setValue(valueidx, val);
            }
            if(datatype === 'regio') {
                val = parseInt(val, 10);
                if(e.target.checked) {
                    this.addRegio(valueidx, val);
                } else {
                    this.removeRegio(valueidx, val);
                }
            }
        }
    },
    setName: function(name) {
        this.config.variableName = name;
    },
    setType: function(type) {
        this.config.variableType = type;
        this.mainContainer.querySelector('.values-label').style.display = (this.showMultipleValues(type) ? 'block' : 'none');
        this.mainContainer.querySelector('.variable-values').style.display = (this.showMultipleValues(type) ? 'block' : 'none');
        this.mainContainer.querySelector('.global-regio-selector').style.display = (this.showMultipleValues(type)? 'none' : 'block');
    },
    setLocation: function(location) {
        this.config.variableLocation = location;
    },
    setValue: function(idx, val) {
        this.config.values[idx].value = val;
    },
    addRegio: function(idx, id) {
        var arrRef;
        if(parseInt(idx, 10) === -1) {
            arrRef = this.config.selectedRegios;
        } else {
            arrRef = this.config.values[idx].regios;
        }
        var index = arrRef.indexOf(id);
        if(index === -1) {
            arrRef.push(id);
        }
    },
    removeRegio: function(idx, id) {
        var arrRef;
        if(parseInt(idx, 10) === -1) {
            arrRef = this.config.selectedRegios;
        } else {
            arrRef = this.config.values[idx].regios;
        }
        var index = arrRef.indexOf(id);
        if(index > -1) {
            arrRef.splice(index, 1);
        }
    },
    showMultipleValues : function(type){
        return type === this.dropdownFieldType || this.config.isLabel;
    },
    showMaincategory: function(){
        return this.config.variableLocation === this.addupFieldType && this.config.addupField === "ja" && this.config.variableType === this.mainCategoryType;
    }
});