// Input 0
Ext.define("viewer.viewercontroller.flamingo.FlamingoLayer", {enabledEvents:null, type:null, constructor:function(a) {
  if(a.id) {
    this.id = a.viewerController.mapComponent.makeFlamingoAcceptableId(a.id), a.id = this.id
  }
  this.enabledEvents = {};
  return this
}, getFrameworkLayer:function() {
  return this.map == null ? null : this.map.getFrameworkMap()
}, toXML:function() {
  Ext.Error.raise({msg:"FlamingoLayer.toXML(): .toXML() must be made!"})
}, getTagName:function() {
  Ext.Error.raise({msg:"FlamingoLayer.getTagName: .getTagName() must be made!"})
}, setOption:function(a, b) {
  this.options[a] = b
}, getId:function() {
  return this.id
}, getFrameworkId:function() {
  return this.map.getId() + "_" + this.getId()
}, setAlpha:function(a) {
  this.map && this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "setAlpha", a)
}, getAlpha:function() {
  return this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getAlpha")
}, getLastMapRequest:function() {
  var a = this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getLastGetMapRequest");
  return a == null ? null : [a]
}, getType:function() {
  return this.type
}, reload:function() {
  return this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "update")
}, addListener:function(a, b, c) {
  var e = this.map.mapComponent.eventList[a];
  e != void 0 && this.enabledEvents[e] == void 0 && (this.map.getFrameworkMap().callMethod(this.map.mapComponent.getId(), "addAllowExternalInterface", this.getFrameworkId() + "." + e), this.enabledEvents[e] = true);
  this.superclass.$className == "viewer.viewercontroller.flamingo.FlamingoArcLayer" ? this.superclass.superclass.addListener.call(this, a, b, c) : this.superclass.addListener.call(this, a, b, c)
}, setVisible:function(a) {
  this.visible = a;
  this.options != null && (this.options.visible = a);
  this.map != null && this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setVisible", a)
}, getVisible:function() {
  if(this.map != null) {
    this.visible = this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "getVisible")
  }
  if(this.options != null) {
    this.options.visible = this.visible
  }
  return this.visible
}, destroy:function() {
  this.superclass.$className == "viewer.viewercontroller.flamingo.FlamingoArcLayer" ? this.superclass.superclass.destroy.call(this) : this.superclass.destroy.call(this)
}});
// Input 1
Ext.define("viewer.viewercontroller.flamingo.FlamingoArcLayer", {extend:"viewer.viewercontroller.controller.ArcLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoArcLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  return this
}, toXML:function() {
  var a = "<fmc:";
  a += this.getTagName();
  a += ' xmlns:fmc="fmc"';
  a += ' id="' + this.getId() + '"';
  for(var b in this.options) {
    b.toLowerCase() == "url" || b.toLowerCase() == "sld" || (a += " " + b + '="' + this.options[b] + '"')
  }
  a += ">";
  for(b = 0;b < this.getMaptips().length;b++) {
    var c = this.getMaptips()[b];
    a += "<layer";
    a += ' id="' + c.layer + '"';
    c.mapTipField != null && (a += ' maptip="' + c.mapTipField + '"');
    c.aka != null && (a += ' aka="' + c.aka + '"');
    a += "/>"
  }
  a += "</fmc:" + this.getTagName() + ">";
  return a
}, getId:function() {
  return this.id
}, getName:function() {
  return this.options.name
}, getServer:function() {
  return this.options.server
}, getService:function() {
  return this.options.service
}, getServlet:function() {
  return this.options.servlet
}, getMapservice:function() {
  return this.options.mapservice
}, getLayers:function() {
  return this.options.visibleids
}, setMaptips:function(a) {
  viewer.viewercontroller.flamingo.FlamingoArcLayer.superclass.setMaptips.call(this, a);
  this.passMaptips()
}, passMaptips:function() {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setMaptipLayers", this.maptips.join(","))
}, getLegendGraphic:function() {
  return null
}, setBuffer:function() {
  console.log("FlamingoArcLayer.setBuffer: .setBuffer() must be made!")
}, removeBuffer:function() {
  console.log("FlamingoArcLayer.removeBuffer: .removeBuffer() must be made!")
}, getLastMapRequest:function() {
  return this.mixins.flamingoLayer.getLastMapRequest.call(this)
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this)
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.flamingoLayer.getVisible.call(this) >= 0 ? true : false
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c)
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this)
}});
// Input 2
Ext.define("viewer.viewercontroller.flamingo.FlamingoArcServerLayer", {extend:"viewer.viewercontroller.flamingo.FlamingoArcLayer", constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoArcServerLayer.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.ARCSERVER_TYPE;
  return this
}, getTagName:function() {
  return"LayerArcServer"
}, setQuery:function(a) {
  a = a != null ? a.getCQL() : "";
  if(a != "") {
    var b = this;
    Ext.create("viewer.ArcQueryUtil").cqlToArcFIDS(a, this.appLayerId, function(a, e) {
      var f = "-1";
      a.length != 0 && (f = e + " IN(" + a.join(",") + ")");
      b.map.getFrameworkMap().callMethod(b.getFrameworkId(), "setDefinitionQuery", f, b.config.options.name);
      setTimeout(function() {
        b.reload()
      }, 500)
    }, function(a) {
      b.getViewerController().logger.error(a)
    })
  }else {
    this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "setDefinitionQuery", null, this.config.options.name), this.reload()
  }
}});
// Input 3
Ext.define("viewer.viewercontroller.flamingo.FlamingoArcIMSLayer", {extend:"viewer.viewercontroller.flamingo.FlamingoArcLayer", constructor:function(a) {
  a.options.layerorder = true;
  this.id = a.id;
  viewer.viewercontroller.flamingo.FlamingoArcIMSLayer.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.ARCIMS_TYPE;
  return this
}, getTagName:function() {
  return"LayerArcIMS"
}, setBuffer:function(a, b) {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setLayerProperty", b, "buffer", {radius:a});
  this.map.update()
}, removeBuffer:function(a) {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setLayerProperty", a, "buffer");
  this.map.update()
}, setQuery:function(a) {
  if(a) {
    var b = this;
    Ext.create("viewer.ArcQueryUtil").cqlToArcXMLSpatialQuery(a.getCQL(), function(a) {
      b.map.getFrameworkMap().callMethod(b.getFrameworkId(), "setQuery", "#ALL#", a);
      b.reload()
    }, console.log)
  }else {
    this.map.getFrameworkMap().callMethod(b.getFrameworkId(), "setQuery", "#ALL#", null), this.reload()
  }
}});
// Input 4
Ext.define("viewer.viewercontroller.flamingo.FlamingoWMSLayer", {extend:"viewer.viewercontroller.controller.WMSLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoWMSLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  return this
}, getTagName:function() {
  return"LayerOGWMS"
}, toXML:function() {
  var a = "<fmc:";
  a += this.getTagName();
  a += ' xmlns:fmc="fmc"';
  a += ' id="' + this.getId() + '"';
  a += ' url="' + this.getOption("url");
  this.getOption("SLD_BODY") && this.getOption("url") && (a += this.getOption("url").indexOf("?") >= 0 ? "&" : "?", a += "SLD_BODY=" + this.getOption("SLD_BODY") + "&");
  a += '"';
  for(var b in this.options) {
    b.toLowerCase() == "url" || b.toLowerCase() == "sld_body" || (a += " " + b + '="' + this.options[b] + '"')
  }
  a += ">";
  for(b = 0;b < this.getMaptips().length;b++) {
    var c = this.getMaptips()[b];
    a += "<layer";
    a += ' id="' + c.layer + '"';
    c.mapTipField != null && (a += ' maptip="' + c.mapTipField + '"');
    c.aka != null && (a += ' aka="' + c.aka + '"');
    a += "/>"
  }
  a += "</fmc:" + this.getTagName() + ">";
  return a
}, setMaptips:function(a) {
  viewer.viewercontroller.flamingo.FlamingoWMSLayer.superclass.setMaptips.call(this, a);
  this.passMaptips()
}, passMaptips:function() {
  this.map.getFrameworkMap().callMethod(this.map.id + "_" + this.id, "setMaptipLayers", this.maptips.join(","))
}, setQuery:function(a) {
  if(a) {
    var b = this.viewerController.app.services[this.serviceId].layers[this.options.name];
    if(b.details != void 0 && (b = b.details.filterable, b != void 0 && b != null && (b = Ext.JSON.decode(b)))) {
      var c = this;
      Ext.create("viewer.SLD", {}).create([this.options.layers], ["default"], a.getCQL(), function(a) {
        c.getFrameworkLayer().callMethod(c.map.getId() + "_" + c.getId(), "setAttribute", "SLD_BODY", encodeURIComponent(a));
        c.reload()
      }, console.log)
    }
  }else {
    this.getFrameworkLayer().callMethod(this.map.getId() + "_" + this.getId(), "removeAttribute", "SLD_BODY"), this.reload()
  }
}, getLayers:function() {
  return this.getFrameworkLayer().options.layers
}, setUrl:function(a) {
  this.url = a
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.flamingoLayer.getVisible.call(this) >= 0 ? true : false
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a)
}, getLastMapRequest:function() {
  return this.mixins.flamingoLayer.getLastMapRequest.call(this)
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this)
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c)
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this)
}});
// Input 5
Ext.define("viewer.viewercontroller.flamingo.FlamingoVectorLayer", {extend:"viewer.viewercontroller.controller.VectorLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, isLoaded:false, gisId:null, constructor:function(a) {
  if(a.labelPropertyName == null) {
    a.labelPropertyName = "label"
  }
  viewer.viewercontroller.flamingo.FlamingoVectorLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  this.colorPrefix = "0x";
  this.id = a.name;
  this.type = viewer.viewercontroller.controller.Layer.VECTOR_TYPE;
  return this
}, getFrameworkId:function() {
  return this.map.editMapId
}, toXML:function() {
  var a = "<fmc:Layer ";
  a += "id='" + this.id + "' ";
  a += "name='" + this.id + "' ";
  a += "visible='true' ";
  a += "labelpropertyname='" + this.labelPropertyName + "' ";
  this.getGeometrytypes() != null && this.getGeometrytypes().length > 0 && (a += "geometrytypes='" + this.getGeometrytypes().join() + "' ");
  this.getShowmeasures() != null && (a += "showmeasures='" + this.getShowmeasures() + "' ");
  this.getEditable() != null && (a += "editable='" + this.getEditable() + "' ");
  a += ">";
  a += "<fmc:Property name='" + this.labelPropertyName + "' title='Label' type='SingleLine'/>";
  a += "<fmc:Style ";
  this.style.fillcolor != null && (a += "fillcolor='" + this.colorPrefix + this.style.fillcolor + "' ");
  this.style.fillopacity != null && (a += "fillopacity='" + this.style.fillopacity + "' ");
  this.style.strokecolor != null && (a += "strokecolor='" + this.colorPrefix + this.style.strokecolor + "' ");
  this.style.strokeopacity != null && (a += "strokeopacity='" + this.style.strokeopacity + "' ");
  a += "/></fmc:Layer>";
  return a
}, adjustStyle:function() {
  var a = "<fmc:Style ";
  this.style.fillcolor != null && (a += "fillcolor='" + this.colorPrefix + this.style.fillcolor + "' ");
  this.style.fillopacity != null && (a += "fillopacity='" + this.style.fillopacity + "' ");
  this.style.strokecolor != null && (a += "strokecolor='" + this.colorPrefix + this.style.strokecolor + "' ");
  this.style.strokeopacity != null && (a += "strokeopacity='" + this.style.strokeopacity + "' ");
  a += "/>";
  this.map.getFrameworkMap().callMethod(this.gisId, "setCompositeInLayer", a, "Style", this.getId())
}, getLayerName:function() {
  return this.layerName
}, removeAllFeatures:function() {
  this.map.getFrameworkMap().callMethod(this.gisId, "removeAllLayerFeatures", this.getId(), false)
}, removeFeature:function(a) {
  this.map.getFrameworkMap().callMethod(this.gisId, "removeLayerFeatureById", this.getId(), a.getId(), false)
}, getActiveFeature:function() {
  var a = this.map.getFrameworkMap().callMethod(this.gisId, "getActiveFeatureAsObject");
  return a == null ? null : this.fromFlamingoFeature(a)
}, getFeature:function(a) {
  return this.getAllFeatures()[a]
}, addFeature:function(a) {
  this.map.getFrameworkMap().callMethod(this.map.editMapId, "addFeature", this.getId(), this.toFlamingoFeature(a))
}, getAllFeatures:function() {
  for(var a = this.map.getFrameworkMap().callMethod(this.getGisId(), "getFeaturesAsObject", false, this.getId()), b = [], c = 0;c < a.length;c++) {
    var e = this.fromFlamingoFeature(a[c]);
    b.push(e)
  }
  return b
}, getFeatureById:function(a) {
  a = this.map.getFrameworkMap().callMethod(this.getGisId(), "getFeature", this.getId(), a);
  return a != null ? this.fromFlamingoFeature(a) : null
}, drawFeature:function(a) {
  this.map != null && this.map.editMapId != null && this.map.getFrameworkMap().callMethod(this.map.editMapId, "editMapDrawNewGeometry", this.getId(), a)
}, stopDrawDrawFeature:function() {
  this.map.getFrameworkMap().callMethod(this.getId(), "removeEditMapCreateGeometry", this.getLayerName())
}, setGisId:function(a) {
  this.gisId = a
}, getGisId:function() {
  return this.gisId
}, setLabel:function(a, b) {
  this.map.getFrameworkMap().callMethod(this.gisId, "setFeatureValue", this.getId(), a, this.getLabelPropertyName(), b)
}, fromFlamingoFeature:function(a) {
  a.wkt = a.wktgeom;
  return new viewer.viewercontroller.controller.Feature(a)
}, toFlamingoFeature:function(a) {
  var b = {};
  b.id = a.getId();
  b.wktgeom = a.getWktgeom();
  b[this.labelPropertyName] = a.getLabel() != "" ? a.getLabel() : null;
  return b
}, getVisible:function() {
  return this.visible
}, fire:function(a, b) {
  this.fireEvent(a, this, b)
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this)
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c)
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this)
}});
// Input 6
Ext.define("viewer.viewercontroller.flamingo.FlamingoMap", {extend:"viewer.viewercontroller.controller.Map", posAttrNames:"left,right,top,bottom,width,height".split(","), enabledEvents:{}, editMapId:null, gisId:"gis", constructor:function(a) {
  if(a.options.startExtent) {
    a.options.extent = a.options.startExtent.toString(), delete a.options.startExtent
  }
  if(a.options.maxExtent) {
    a.options.fullextent = a.options.maxExtent.toString(), delete a.options.maxExtent
  }
  a.options.bottom = "bottom -" + a.options.bottom;
  viewer.viewercontroller.flamingo.FlamingoMap.superclass.constructor.call(this, a);
  this.frameworkMap = this.mapComponent.viewerObject;
  if(Ext.isGecko) {
    var b = this;
    this.frameworkMap.addEventListener("DOMMouseScroll", function(a) {
      b.frameworkMap.callMethod(b.id, "mouseWheelUsed", 0 - a.detail)
    }, false)
  }
  return this
}, getId:function() {
  return this.id
}, getAllWMSLayers:function() {
  for(var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof viewer.viewercontroller.flamingo.FlamingoWMSLayer && a.push(this.layers[b])
  }
  return a
}, getAllVectorLayers:function() {
  for(var a = [], b = 0;b < this.layers.length;b++) {
    this.layers[b] instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer && a.push(this.layers[b])
  }
  return a
}, remove:function() {
  this.getFrameworkMap().callMethod("flamingo", "killComponent", this.getId())
}, addLayer:function(a) {
  this.superclass.addLayer.call(this, a);
  a instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer ? (this.editMapId == null && this.addEditMap(), a.setGisId(this.gisId), this.addLayerToGis(a)) : this.getFrameworkMap().callMethod(this.getId(), "addLayer", a.toXML())
}, addLayerToGis:function(a) {
  if(this.getFrameworkMap().callMethod("flamingo", "isLoaded", this.gisId, true)) {
    this.getFrameworkMap().callMethod(this.gisId, "addLayerAsString", a.toXML()), a.isLoaded = true
  }else {
    var b = this;
    setTimeout(function() {
      b.addLayerToGis(a, b)
    }, 500)
  }
}, removeLayer:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer ? this.getFrameworkMap().callMethod(this.gisId, "removeLayer", a.getId()) : this.getFrameworkMap().callMethod(this.getId(), "removeLayer", this.getId() + "_" + a.getId());
  this.superclass.removeLayer.call(this, a)
}, addEditMap:function() {
  this.editMapId = "editMap";
  this.getFrameworkMap().callMethod(this.getMapComponent().mainContainerId, "addComponent", "<fmc:GIS xmlns:fmc='fmc' id='" + this.gisId + "' geometryeditable='true' alwaysdrawpoints='false'></fmc:GIS>");
  var a = this.getPositionAttributes(), b = "<fmc:EditMap xmlns:fmc='fmc' id='" + this.editMapId + "' editable='true'", c;
  for(c in a) {
    b += " " + c + "='" + a[c] + "'"
  }
  b += "listento='" + this.gisId + "," + this.id + "'/>";
  this.getFrameworkMap().callMethod(this.getMapComponent().mainContainerId, "addComponent", b)
}, getLayerByFlamingoId:function(a) {
  var b = null;
  a.indexOf(this.getId() + "_") == 0 && (b = this.getLayer(a.replace(this.getId() + "_", "")));
  b == null && (b = this.getLayer(a));
  return b
}, setLayerIndex:function(a, b) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoVectorLayer || this.getFrameworkMap().callMethod(this.getId(), "swapLayer", this.getId() + "_" + a.getId(), b);
  return this.superclass.setLayerIndex(a, b)
}, setLayerVisible:function(a, b) {
  this.superclass.setLayerVisible.call(this, a, b);
  a.setVisible(b)
}, zoomToExtent:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "moveToExtent", a, 0)
}, zoomToMaxExtent:function() {
  this.zoomToExtent(this.getFrameworkMap().callMethod(this.getId(), "getFullExtent"))
}, zoomToResolution:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "moveToScale", a, void 0, 0)
}, zoomToScale:function(a) {
  this.zoomToResolution(a)
}, moveTo:function(a, b) {
  this.getFrameworkMap().callMethod(this.getId(), "moveToCoordinate", {x:a, y:b}, 1)
}, setMaxExtent:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "setFullExtent", a)
}, getMaxExtent:function() {
  var a = this.getFrameworkMap().callMethod(this.getId(), "getFullExtent");
  return new viewer.viewercontroller.controller.Extent(a.minx, a.miny, a.maxx, a.maxy)
}, doIdentify:function() {
  Ext.Error.raise({msg:"Map.doIdentify() Not implemented!"})
}, getExtent:function() {
  var a = this.getFrameworkMap().callMethod(this.getId(), "getCurrentExtent");
  return new viewer.viewercontroller.controller.Extent(a.minx, a.miny, a.maxx, a.maxy)
}, update:function() {
  this.getFrameworkMap().callMethod(this.getId(), "update", 100, true)
}, forceUpdate:function() {
  var a = this;
  this.isUpdating() ? setTimeout(function() {
    a.forceUpdate()
  }, 100) : this.update()
}, setMarker:function(a, b, c, e) {
  this.getFrameworkMap().callMethod(this.getId(), "setMarker", a, e, Number(b), Number(c))
}, removeMarker:function(a) {
  this.getFrameworkMap().callMethod(this.getId(), "removeMarker", a)
}, getScale:function(a) {
  return this.getResolution(a)
}, getResolution:function(a) {
  a || (a = this.getExtent());
  return this.getFrameworkMap().callMethod(this.getId(), "getScale", a)
}, coordinateToPixel:function(a, b) {
  return this.getFrameworkMap().callMethod(this.getId(), "coordinate2Point", {x:a, y:b})
}, getCenter:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "getCenter")
}, getWidth:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "getMovieClipWidth")
}, getHeight:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "getMovieClipHeight")
}, isUpdating:function() {
  return this.getFrameworkMap().callMethod(this.getId(), "isUpdating")
}, getPositionAttributes:function() {
  for(var a = {}, b = 0;b < this.posAttrNames.length;b++) {
    var c = this.posAttrNames[b];
    this.options[c] && (a[c] = this.options[c])
  }
  return a
}, toXML:function() {
  var a = "";
  a += "<fmc:Map";
  a += ' xmlns:fmc="fmc"';
  a += ' id="' + this.getId() + '"';
  for(var b in this.options) {
    a += " " + b + '="' + this.options[b] + '"'
  }
  a += ">";
  a += "</fmc:Map>";
  return a
}, addListener:function(a, b, c) {
  viewer.viewercontroller.flamingo.FlamingoMap.superclass.addListener.call(this, a, b, c);
  a = this.mapComponent.eventList[a];
  if(Ext.isArray(a)) {
    for(b = 0;b < a.length;b++) {
      this.addExternalInterface(a[b])
    }
  }else {
    this.addExternalInterface(a)
  }
}, addExternalInterface:function(a) {
  a != void 0 && this.enabledEvents[a] == void 0 && (this.getFrameworkMap().callMethod(this.mapComponent.getId(), "addAllowExternalInterface", this.getId() + "." + a), (a == "onRemoveLayer" || a == "onAddLayer") && this.getFrameworkMap().callMethod(this.mapComponent.getId(), "addAllowExternalInterface", this.gisId + "." + a), this.enabledEvents[a] = true)
}});
// Input 7
Ext.define("viewer.viewercontroller.flamingo.FlamingoTool", {extend:"viewer.viewercontroller.controller.Tool", enabledEvents:null, config:{width:null, height:null, left:null, right:null, top:null, bottom:null, listenTo:null, decimals:null, magicnumber:null, units:null}, constructor:function(a) {
  if(a.id) {
    a.id = a.id.replace(/\./g, "_")
  }
  this.enabledEvents = {};
  viewer.viewercontroller.flamingo.FlamingoTool.superclass.constructor.call(this, a);
  this.initConfig(a);
  return this
}, setVisible:function(a) {
  this.visible = a;
  this.getFrameworkTool() && this.getFrameworkTool().callMethod(this.getId(), "setVisible", visibility)
}, toXML:function() {
  var a = "<fmc:";
  a += this.getTagName(this.getType());
  this.getId() != null && (a += " id='" + this.getId() + "'");
  this.getWidth() != null && (a += " width='" + this.getWidth() + "'");
  this.getHeight() != null && (a += " height='" + this.getHeight() + "'");
  this.getTop() != null && (a += " top='" + this.getTop() + "'");
  this.getLeft() != null && (a += " left='" + this.getLeft() + "'");
  this.getRight() != null && (a += " right='" + this.getRight() + "'");
  this.getBottom() != null && (a += " bottom='" + this.getBottom() + "'");
  this.getDecimals() != null && (a += " decimals='" + this.getDecimals() + "'");
  this.getMagicnumber() != null && (a += " magicnumber='" + this.getMagicnumber() + "'");
  this.getUnits() != null && (a += " units='" + this.getUnits() + "'");
  this.getListenTo() != null && (a += " listento='" + this.getListenTo() + "'");
  a += ">";
  this.getTooltip() != null && (a += "<string id='tooltip' en='" + this.getTooltip() + "'/>");
  a += "</fmc:" + this.getTagName(this.getType()) + ">";
  return a
}, getTagName:function(a) {
  return a == viewer.viewercontroller.controller.Tool.ZOOMIN_BOX ? "ToolZoomin" : a == viewer.viewercontroller.controller.Tool.ZOOMOUT_BOX ? "ToolZoomout" : a == viewer.viewercontroller.controller.Tool.GET_FEATURE_INFO ? "ToolIdentify" : a == viewer.viewercontroller.controller.Tool.PAN ? "ToolPan" : a == viewer.viewercontroller.controller.Tool.SUPERPAN ? "ToolSuperPan" : a == viewer.viewercontroller.controller.Tool.MEASURE ? "ToolMeasure" : a == viewer.viewercontroller.controller.Tool.DEFAULT ? "ToolDefault" : 
  a == viewer.viewercontroller.controller.Tool.FULL_EXTENT ? "ButtonFull" : a == viewer.viewercontroller.controller.Tool.NEXT_EXTENT ? "ButtonNext" : a == viewer.viewercontroller.controller.Tool.PREVIOUS_EXTENT ? "ButtonPrev" : null
}, activate:function() {
  this.frameworkObject.callMethod(this.getId(), "setActive", true)
}, deactivate:function() {
  this.frameworkObject.callMethod(this.getId(), "setActive", true)
}, addListener:function(a, b, c) {
  viewer.viewercontroller.flamingo.FlamingoTool.superclass.addListener.call(this, a, b, c);
  a = this.mapComponent.eventList[a];
  a != void 0 && this.enabledEvents[a] == void 0 && (this.frameworkObject.callMethod(this.mapComponent.getId(), "addAllowExternalInterface", this.getId() + "." + a), this.enabledEvents[a] = true)
}});
// Input 8
Ext.define("viewer.viewercontroller.flamingo.FlamingoImageLayer", {extend:"viewer.viewercontroller.controller.ImageLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoImageLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  this.initConfig(a);
  this.type = viewer.viewercontroller.controller.Layer.IMAGE_TYPE;
  return this
}, getTagName:function() {
  return"LayerImage"
}, toXML:function() {
  var a = "<fmc:";
  a += this.getTagName();
  a += ' xmlns:fmc="fmc"';
  a += ' id="' + this.id + '"';
  a += ' url="' + this.url + '"';
  a += ' extent="' + this.extent + '"';
  a += ' visible="' + this.visible + '"';
  a += "></fmc:" + this.getTagName() + ">";
  return a
}, setUrl:function(a) {
  this.url = a;
  this.getFrameworkLayer() != null && this.getMap() != null && this.getFrameworkLayer().callMethod(this.getFrameworkId(), "setAttribute", "url", a)
}, setExtent:function(a) {
  this.extent = a;
  this.getFrameworkLayer() != null && this.map != null && this.getFrameworkLayer().callMethod(this.getFrameworkId(), "setAttribute", "extent", a.toString())
}, getLastMapRequest:function() {
  return[{url:this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getServiceUrl"), body:null, extent:this.getExtent()}]
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.flamingoLayer.getVisible.call(this)
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c)
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this)
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this)
}});
// Input 9
Ext.define("viewer.viewercontroller.flamingo.FlamingoTilingLayer", {extend:"viewer.viewercontroller.controller.TilingLayer", mixins:{flamingoLayer:"viewer.viewercontroller.flamingo.FlamingoLayer"}, constructor:function(a) {
  viewer.viewercontroller.flamingo.FlamingoTilingLayer.superclass.constructor.call(this, a);
  this.mixins.flamingoLayer.constructor.call(this, a);
  return this
}, getTagName:function() {
  return"TilingLayer"
}, toXML:function() {
  var a = this.getUrl();
  this.getProtocol() == "ArcGisRest" && (/\/tile\/?$/.test(a) || (a += "/tile/"));
  var b = "<fmc:";
  b += this.getTagName();
  b += ' xmlns:fmc="fmc"';
  b += ' id="' + this.getId() + '"';
  b += ' serviceurl="' + a + '"';
  b += ' resolutions="' + this.getResolutions().join(",") + '"';
  b += ' serviceenvelope="' + this.getServiceEnvelope() + '"';
  this.getProtocol() != null && (b += ' type="' + this.getProtocol() + '"');
  this.getTileHeight() != null && (b += ' tileheight="' + this.getTileHeight() + '"');
  this.getTileWidth() != null && (b += ' tilewidth="' + this.getTileWidth() + '"');
  this.getExtension() != null && (b += ' extension="' + this.getExtension() + '"');
  this.config.alpha != null && (b += ' alpha="' + this.config.alpha + '"');
  b += "></fmc:" + this.getTagName() + ">";
  return b
}, getLegendGraphic:function() {
  return null
}, getLayers:function() {
  return null
}, getLastMapRequest:function() {
  var a = this.map.getFrameworkMap().callMethod(this.getFrameworkId(), "getLastRequests"), b;
  for(b in a) {
    if(a[b].extent) {
      a[b].extent = new viewer.viewercontroller.controller.Extent(a[b].extent.minx, a[b].extent.miny, a[b].extent.maxx, a[b].extent.maxy)
    }
  }
  return a
}, setUrl:function(a) {
  this.url = a
}, setVisible:function(a) {
  this.mixins.flamingoLayer.setVisible.call(this, a)
}, getVisible:function() {
  return this.mixins.flamingoLayer.getVisible.call(this)
}, setAlpha:function(a) {
  this.mixins.flamingoLayer.setAlpha.call(this, a)
}, reload:function() {
  this.mixins.flamingoLayer.reload.call(this)
}, addListener:function(a, b, c) {
  this.mixins.flamingoLayer.addListener.call(this, a, b, c)
}, getType:function() {
  return this.mixins.flamingoLayer.getType.call(this)
}, destroy:function() {
  this.mixins.flamingoLayer.destroy.call(this)
}});
// Input 10
Ext.define("viewer.viewercontroller.flamingo.ToolMapClick", {extend:"viewer.viewercontroller.controller.ToolMapClick", enabledEvents:null, constructor:function(a) {
  viewer.viewercontroller.flamingo.ToolMapClick.superclass.constructor.call(this, a);
  this.visible = false;
  this.id = a.id + "_toolMapClick";
  this.enabledEvents = {};
  this.initConfig(a);
  this.mapComponent = this.viewerController.mapComponent;
  this.frameworkObject = this.viewerController.mapComponent.viewerObject;
  this.addListener(viewer.viewercontroller.controller.Event.ON_MAP_CLICKED, a.handler.fn, a.handler.scope);
  this.addTool();
  return this
}, addTool:function() {
  var a = "<fmc:ToolGroup id='" + this.mapComponent.getToolGroup() + "'>";
  a += "<fmc:ToolMapClick id='" + this.id + "' listento='" + this.mapComponent.getMap().getId() + "' visible='" + this.visible + "'/>";
  a += "</fmc:ToolGroup>";
  this.frameworkObject.callMethod(this.mapComponent.flamingoId, "addComponent", a);
  this.mapComponent.tools.push(this)
}, activateTool:function() {
  this.frameworkObject.callMethod(this.id, "activate")
}, deactivateTool:function() {
  this.frameworkObject.callMethod(this.id, "deactivate")
}, addListener:function(a, b, c) {
  viewer.viewercontroller.flamingo.ToolMapClick.superclass.addListener.call(this, a, b, c);
  a = this.viewerController.mapComponent.eventList[a];
  a != void 0 && this.enabledEvents[a] == void 0 && (this.frameworkObject.callMethod(this.viewerController.mapComponent.getId(), "addAllowExternalInterface", this.getId() + "." + a), this.enabledEvents[a] = true)
}});
// Input 11
Ext.define("viewer.viewercontroller.flamingo.FlamingoComponent", {extend:"viewer.viewercontroller.controller.Component", strings:null, config:{tagName:null, width:null, height:null, left:null, right:null, top:null, bottom:null, listenTo:null, units:null, maptipdelay:500, decimals:null, showZoomerButtons:null}, constructor:function(a) {
  if(a.id) {
    a.id = a.id.replace(/\./g, "_")
  }
  this.strings = {};
  viewer.viewercontroller.flamingo.FlamingoComponent.superclass.constructor.call(this, a);
  this.initConfig(a);
  if(a.type == viewer.viewercontroller.controller.Component.BORDER_NAVIGATION) {
    this.setTagName("BorderNavigation");
    var b = a.viewerController.mapComponent.getMap().getPositionAttributes(), c;
    for(c in b) {
      this[c] = b[c]
    }
    a.tooltip_pan_right != void 0 && this.addString("tooltip_west", a.tooltip_pan_right);
    a.tooltip_pan_left != void 0 && this.addString("tooltip_east", a.tooltip_pan_left);
    a.tooltip_pan_up != void 0 && this.addString("tooltip_north", a.tooltip_pan_up);
    a.tooltip_pan_down != void 0 && this.addString("tooltip_south", a.tooltip_pan_down)
  }else {
    a.type == viewer.viewercontroller.controller.Component.SCALEBAR ? (this.setTagName("Scalebar"), this.setBottom("bottom +20"), this.setLeft("50"), this.setWidth("200"), this.getUnits() == null && this.setUnits("m")) : a.type == viewer.viewercontroller.controller.Component.COORDINATES ? (this.setTagName("Coordinates"), this.setBottom("bottom"), this.setRight("right -80"), this.addString("xy", "X: [x] Y: [y]")) : a.type == viewer.viewercontroller.controller.Component.NAVIGATIONPANEL ? (this.setTagName("NavigationControl"), 
    this.setTop("50"), this.setLeft("20"), (this.getHeight() == null || this.getHeight() == "") && this.setHeight("300"), a.show_zoom_buttons != void 0 && this.setShowZoomerButtons(a.show_zoom_buttons), a.tooltip_pan_right != void 0 && this.addString("tooltip_west", a.tooltip_pan_right), a.tooltip_pan_left != void 0 && this.addString("tooltip_east", a.tooltip_pan_left), a.tooltip_pan_up != void 0 && this.addString("tooltip_north", a.tooltip_pan_up), a.tooltip_pan_down != void 0 && this.addString("tooltip_south", 
    a.tooltip_pan_down), a.tooltip_slider != void 0 && this.addString("tooltip_slider", a.tooltip_slider)) : a.type == viewer.viewercontroller.controller.Component.MAPTIP ? this.setTagName("Maptip") : a.type == viewer.viewercontroller.controller.Component.LOADMONITOR ? (this.setTagName("MonitorMap"), this.getWidth() == null && this.setWidth("200"), this.getLeft() == null && this.setLeft("20"), this.getTop() == null && this.setTop("100"), a.loadingText != void 0 && (this.addString("loading", a.loadingText), 
    this.addString("waiting", a.loadingText))) : a.type != viewer.viewercontroller.controller.Component.OVERVIEW && Ext.Error.raise({msg:"Can't find type of component or component not supported"})
  }
  return this
}, setVisible:function(a) {
  this.getFrameworkTool().callMethod(this.getId(), "setVisible", a)
}, toXML:function() {
  var a = "<fmc:";
  a += this.getTagName();
  a += "  xmlns:fmc='fmc' " + this.getParamsAsXml();
  a += ">";
  for(var b in this.strings) {
    a += "<string id='" + b + "' en='" + this.strings[b] + "'/>"
  }
  a += "</fmc:" + this.getTagName() + ">";
  return a
}, getParamsAsXml:function() {
  var a = "";
  this.getId() != null && (a += "id='" + this.getId() + "'");
  this.getWidth() != null && (a += " width='" + this.getWidth() + "'");
  this.getHeight() != null && (a += " height='" + this.getHeight() + "'");
  this.getTop() != null && (a += " top='" + this.getTop() + "'");
  this.getLeft() != null && (a += " left='" + this.getLeft() + "'");
  this.getRight() != null && (a += " right='" + this.getRight() + "'");
  this.getBottom() != null && (a += " bottom='" + this.getBottom() + "'");
  this.getListenTo() != null && (a += " listento='" + this.getListenTo() + "'");
  this.getUnits() != null && (a += " units='" + this.getUnits() + "'");
  this.getDecimals() != null && (a += " decimals='" + this.getDecimals() + "'");
  this.getShowZoomerButtons() != null && (a += " showzoomerbuttons='" + this.getShowZoomerButtons() + "'");
  return a
}, addString:function(a, b) {
  this.strings[a] = b
}, getString:function(a) {
  return this.strings[a]
}});
// Input 12
Ext.define("viewer.viewercontroller.FlamingoMapComponent", {extend:"viewer.viewercontroller.MapComponent", viewerObject:null, toolGroupId:"toolgroup", toolGroupCreated:false, flamingoId:"flamingo", mainContainerId:"mainContainer", bottomContainerId:null, toolMargin:30, enabledEvents:{}, config:{movetime:null, movesteps:null, swfPath:null}, constructor:function(a, b, c) {
  viewer.viewercontroller.FlamingoMapComponent.superclass.constructor.call(this, a, b, c);
  if(this.swfPath == null) {
    this.swfPath = "flamingo/flamingo.swf"
  }
  a = new SWFObject(this.swfPath + "?config=config.xml", this.flamingoId, "100%", "100%", "8", "#FFFFFF");
  a.addParam("wmode", "transparent");
  a.write(b);
  this.viewerObject = document.getElementById("flamingo");
  return this
}, initEvents:function() {
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_DOWN] = "onEvent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_UP] = "onEvent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_EVENT_OVER] = "onEvent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_CAPABILITIES] = "onGetCapabilities";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CONFIG_COMPLETE] = "onConfigComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED] = "onGeometryDrawFinished";
  this.eventList[viewer.viewercontroller.controller.Event.ON_REQUEST] = "onRequest";
  this.eventList[viewer.viewercontroller.controller.Event.ON_SET_TOOL] = "onSetTool";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO] = "onIdentify";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_PROGRESS] = "onIdentifyProgress";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_DATA] = "onIdentifyData";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE] = "onUpdateComplete";
  this.eventList[viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT] = "onReallyChangedExtent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT] = "onChangeExtent";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_ADDED] = "onAddLayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED] = "onRemoveLayer";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAPTIP_DATA] = "onMaptipData";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAPTIP] = "onMaptip";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAPTIP_CANCEL] = "onMaptipCancel";
  this.eventList[viewer.viewercontroller.controller.Event.ON_MAP_CLICKED] = "onMapClicked";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED] = "onActiveFeatureChange";
  this.eventList[viewer.viewercontroller.controller.Event.ON_ACTIVATE] = "onActivate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_DEACTIVATE] = "onDeactivate";
  this.eventList[viewer.viewercontroller.controller.Event.ON_GET_SERVICE_INFO] = "onGetServiceInfo";
  this.eventList[viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED] = ["onShowLayer", "onHideLayer"]
}, getId:function() {
  return"flamingo"
}, createMap:function(a, b) {
  b.id = a;
  b.mapComponent = this;
  if(this.resolutions != null && this.resolutions != "") {
    b.options.resolutions = this.resolutions
  }
  if(this.movetime != null && this.movetime != "") {
    b.options.movetime = this.movetime
  }
  if(this.movesteps != null && this.movesteps != "") {
    b.options.movesteps = this.movesteps
  }
  return new viewer.viewercontroller.flamingo.FlamingoMap(b)
}, createWMSLayer:function(a, b, c, e) {
  var f = {};
  f.name = a;
  f.url = b;
  f.timeout = 30;
  f.retryonerror = 1;
  f.initService = false;
  var b = null, d;
  for(d in c) {
    f[d] = c[d]
  }
  for(d in e) {
    d.toLowerCase() == "id" ? b = e[d] : f[d] = e[d]
  }
  if(e.alpha != void 0) {
    f.alpha = 100 - e.alpha
  }
  b == null && (b = a);
  return new viewer.viewercontroller.flamingo.FlamingoWMSLayer({id:b, options:f, frameworkLayer:this.viewerObject, viewerController:this.viewerController})
}, createTilingLayer:function(a, b, c) {
  if(c == void 0 || c == null) {
    c = {}
  }
  c.url = b;
  c.type = c.protocol;
  if(c.alpha != void 0) {
    c.alpha = 100 - c.alpha
  }
  return Ext.create("viewer.viewercontroller.flamingo.FlamingoTilingLayer", c)
}, createArcConfig:function(a, b, c, e) {
  var f = b.substring(0, b.indexOf("/", 7)), b = b.indexOf("?") != -1 ? b.substring(b.indexOf("/", 7) + 1, b.indexOf("?")) : b.substring(b.indexOf("/", 7) + 1);
  c.visibleids = c.layers;
  var d = c.id;
  delete c.id;
  c.name = a;
  c.server = f;
  c.servlet = b;
  c.timeout = 30;
  c.retryonerror = 1;
  c.initService = false;
  return{id:d, options:c, frameworkLayer:this.viewerObject, viewerController:e}
}, createArcIMSLayer:function(a, b, c, e) {
  a = this.createArcConfig(a, b, c, e);
  return new viewer.viewercontroller.flamingo.FlamingoArcIMSLayer(a)
}, createArcServerLayer:function(a, b, c, e) {
  a = this.createArcConfig(a, b, c, e);
  c.mapservice = c.servlet.substring(21, c.servlet.toLowerCase().indexOf("/mapserver"));
  delete a.options.servlet;
  a.options.esriArcServerVersion = "9.3";
  a.options.dataframe = "layers";
  return new viewer.viewercontroller.flamingo.FlamingoArcServerLayer(a)
}, createImageLayer:function(a, b, c) {
  return Ext.create("viewer.viewercontroller.flamingo.FlamingoImageLayer", {id:a, url:b, extent:c, frameworkLayer:this.viewerObject, viewerController:this.viewerController})
}, createVectorLayer:function(a) {
  a.frameworkLayer = this.viewerObject;
  return new viewer.viewercontroller.flamingo.FlamingoVectorLayer(a)
}, createTool:function(a) {
  if(Ext.isEmpty(a.listenTo)) {
    a.listenTo = this.getMap().getId()
  }
  a.viewerController = this.viewerController;
  var b = null;
  a.type == viewer.viewercontroller.controller.Tool.MAP_CLICK ? b = Ext.create("viewer.viewercontroller.flamingo.ToolMapClick", a) : a.type == viewer.viewercontroller.controller.Tool.TOGGLE || a.type == viewer.viewercontroller.controller.Tool.MAP_TOOL ? (a.toggle = true, b = Ext.create("viewer.components.tools.JSButton", a)) : a.type == viewer.viewercontroller.controller.Tool.BUTTON ? (a.toggle = false, b = Ext.create("viewer.components.tools.JSButton", a)) : b = new viewer.viewercontroller.flamingo.FlamingoTool(a);
  return b
}, createComponent:function(a) {
  if(Ext.isEmpty(a.listenTo)) {
    a.listenTo = this.getMap().getId()
  }
  if(Ext.isEmpty(a.id)) {
    a.id = a.name
  }
  a.viewerController = this.viewerController;
  return a.type == viewer.viewercontroller.controller.Component.OVERVIEW ? Ext.create("viewer.viewercontroller.flamingo.Overview", a) : new viewer.viewercontroller.flamingo.FlamingoComponent(a)
}, createToolGroup:function(a) {
  var b = this.viewerController.getLayout("top_menu"), c = b.height ? b.height : -1, e = "";
  if(c >= 0) {
    var f = c;
    b.heightmeasure && (f += b.heightmeasure == "px" ? "" : b.heightmeasure);
    e += "<fmc:Container top='0' width='100%' height='" + f + "'";
    b.bgcolor && (e += "backgroundcolor='" + b.bgcolor + "'");
    e += ">"
  }
  e += "<fmc:ToolGroup ";
  for(var d in a) {
    e += d + '="' + a[d] + '" '
  }
  e += "></fmc:ToolGroup>";
  c >= 0 && (e += "</fmc:Container>");
  this.viewerObject.callMethod(this.mainContainerId, "addComponent", e)
}, addTool:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoTool || Ext.Error.raise({msg:"The given tool is not of type 'FlamingoTool'"});
  var b = this.getNumberOfVisibleTools();
  a.getLeft() == null && a.getRight() == null && a.setLeft(b * this.toolMargin);
  this.getToolGroup(a);
  viewer.viewercontroller.FlamingoMapComponent.superclass.addTool.call(this, a);
  b = "<fmc:ToolGroup id='" + this.toolGroupId + "'>";
  b += a.toXML();
  b += "</fmc:ToolGroup>";
  this.viewerObject.callMethod(this.flamingoId, "addComponent", b);
  var b = 0, c = false;
  try {
    c = a instanceof viewer.components.tools.JSButton
  }catch(e) {
    c = false
  }
  if(a.getVisible() && !c) {
    for(c = 0;c < this.tools.length;c++) {
      var f = false;
      try {
        f = this.tools[c] instanceof viewer.components.tools.JSButton
      }catch(d) {
        f = false
      }
      this.tools[c].getVisible() && !f && b++
    }
    b == 1 && this.activateTool(a.getId())
  }
}, getNumberOfVisibleTools:function() {
  for(var a = 0, b = 0;b < this.tools.length;b++) {
    this.tools[b].getVisible() && a++
  }
  return a
}, getToolGroup:function(a) {
  if(!this.toolGroupCreated) {
    var b = this.getMap().id;
    if(b == void 0 || b == null) {
      b = a.getListenTo()
    }
    this.createToolGroup({id:this.toolGroupId, listento:b, width:"100%", height:"100", left:"5", top:"5"});
    this.toolGroupCreated = true
  }
  return this.toolGroupId
}, createBottomContent:function() {
  var a = this.viewerController.getLayout("content_bottom"), b = a && a.height && a.height >= 0 ? a.height : -1;
  return b > 0 ? (a.heightmeasure && (b += a.heightmeasure == "px" ? "" : a.heightmeasure), b = "<fmc:Container id='bottomContainer' bottom='bottom' width='100%' height='" + b + "'", a.bgcolor && (b += "backgroundcolor='" + a.bgcolor + "'"), b += ">", b += "</fmc:Container>", this.addComponentXml(b), "bottomContainer") : null
}, addComponentXml:function(a) {
  this.viewerObject.callMethod(this.mainContainerId, "addComponent", a)
}, activateTool:function(a) {
  this.viewerObject.call(this.toolGroupId, "setTool", a)
}, removeTool:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoTool || Ext.Error.raise({msg:"The given tool is not of type 'FlamingoTool'"});
  this.viewerObject.callMethod(a.getId(), "setVisible", false);
  MapComponent.prototype.removeTool.call(this, a)
}, removeToolById:function(a) {
  a = this.getTool(a);
  (a == null || !(a instanceof viewer.viewercontroller.flamingo.FlamingoTool)) && Ext.Error.raise({msg:"The given tool is not of type 'FlamingoTool' or the given id does not exist"});
  this.removeTool(a)
}, addComponent:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoComponent || Ext.Error.raise({msg:"The given Component is not of type 'FlamingoComponent'"});
  viewer.viewercontroller.FlamingoMapComponent.superclass.addComponent.call(this, a);
  var b = this.mainContainerId, c = a.toXML();
  if(a.config.regionName == "content_bottom") {
    if(this.viewerController.getLayoutHeight("content_bottom") >= 0 && this.bottomContainerId == null) {
      this.bottomContainerId = this.createBottomContent()
    }
    if(this.bottomContainerId) {
      b = this.bottomContainerId
    }
  }
  b && this.viewerObject.callMethod(b, "addComponent", c);
  a.type == viewer.viewercontroller.controller.Component.MAPTIP && this.viewerObject.callMethod(this.getMap().id, "getMaptipdelay") == void 0 && this.viewerObject.callMethod(this.getMap().id, "setMaptipdelay", a.getMaptipdelay())
}, addMap:function(a) {
  a instanceof viewer.viewercontroller.flamingo.FlamingoMap || Ext.Error.raise({msg:"FlamingoMapComponent.addMap(): The given map is not of the type 'FlamingoMap'"});
  this.viewerObject.callMethod(this.mainContainerId, "addComponent", a.toXML());
  this.maps.push(a)
}, getMap:function(a) {
  if(a == void 0 && this.maps.length == 1) {
    return this.maps[0]
  }
  for(var b = "", c = 0;c < this.maps.length;c++) {
    if(c != 0 && (b += ","), b += this.maps[c].getId(), this.maps[c].getId() == a) {
      return this.maps[c]
    }
  }
  return null
}, getObject:function(a) {
  a instanceof Array && (a = a[0]);
  a = "" + a;
  if(this.getMap(a) != null) {
    return this.getMap(a)
  }else {
    if(this.getMap() && this.getMap().getLayer(a) != null) {
      return this.getMap().getLayer(a)
    }else {
      if(this.getMap() && a.indexOf(this.getMap().getId() + "_") == 0 && this.getMap().getLayer(a.replace(this.getMap().getId() + "_", "")) != null) {
        return this.getMap().getLayer(a.replace(this.getMap().getId() + "_", ""))
      }else {
        if(this.getTool(a) != null) {
          return this.getTool(a)
        }else {
          if(a == this.getId()) {
            return this
          }else {
            if(this.getMap() && this.getMap().gisId == a) {
              return this.getMap()
            }else {
              if(!this.getMap() || !this.getMap().editMapId) {
                return null
              }
            }
          }
        }
      }
    }
  }
}, handleEvents:function(a, b) {
  var i;
  var c = b[0], e = this.getObject(c);
  if(a == "onEvent") {
    if(b[1].rollover || b[1].rolloff) {
      a = viewer.viewercontroller.controller.Event.ON_EVENT_OVER
    }else {
      if(b[1].toggle) {
        if(b[1].selected && b[1].down) {
          a = viewer.viewercontroller.controller.Event.ON_EVENT_DOWN
        }else {
          if(!b[1].selected && b[1].down) {
            a = viewer.viewercontroller.controller.Event.ON_EVENT_UP
          }
        }
      }else {
        if(b[1].down) {
          a = viewer.viewercontroller.controller.Event.ON_EVENT_DOWN
        }
      }
    }
  }else {
    if(a == "onHideLayer" || a == "onShowLayer") {
      var f = this.getObject(b[1]), d = this.getMap(), d = a == "onShowLayer", a = viewer.viewercontroller.controller.Event.ON_LAYER_VISIBILITY_CHANGED, b = {};
      b.layer = f;
      b.visible = d
    }else {
      if(a = this.getGenericEventName(a), a == null) {
        return
      }
    }
  }
  if(a == viewer.viewercontroller.controller.Event.ON_REQUEST) {
    var g = b[2];
    g.requesttype == "GetMap" && (d = b[0].split("_"), d.length == 2 && this.getMap(d[0]).getLayer(d[1]).setURL(g.url), d.length == 3 && this.getMap(d[0]).getLayer(d[1] + "_" + d[2]).setURL(g.url))
  }else {
    if(a == viewer.viewercontroller.controller.Event.ON_SET_TOOL) {
      c = this.getId(), e = this.getObject(c)
    }else {
      if(a == viewer.viewercontroller.controller.Event.ON_ACTIVATE) {
        console.log("On Activate")
      }else {
        if(a == viewer.viewercontroller.controller.Event.ON_DEACTIVATE) {
          console.log("On Deactivate")
        }else {
          if(a == viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO) {
            var c = b[1], f = (c.minx + c.maxx) / 2, h = (c.miny + c.maxy) / 2, d = e.coordinateToPixel(f, h), b = d = {coord:{x:f, y:h}, x:d.x, y:d.y}
          }else {
            if(a == viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_PROGRESS) {
              b = {nr:b[1], total:b[2]}
            }else {
              if(a == viewer.viewercontroller.controller.Event.ON_GET_FEATURE_INFO_DATA) {
                c = b[2];
                f = (c.minx + c.maxx) / 2;
                h = (c.miny + c.maxy) / 2;
                d = e.map;
                d = d.coordinateToPixel(f, h);
                d = {coord:{x:f, y:h}, x:d.x, y:d.y};
                d.extent = c;
                d.nr = b[3];
                d.total = b[4];
                c = [];
                f = 0;
                for(g in b[1]) {
                  c[f] = {request:{appLayer:e.appLayerId}, features:b[1][g]}
                }
                d.data = c;
                b = d
              }else {
                if(a == viewer.viewercontroller.controller.Event.ON_LAYER_ADDED) {
                  g = b[1];
                  g.indexOf(c + "_") == 0 && (g = g.substring(c.length + 1));
                  f = e.getLayer(g);
                  if(f == null) {
                    return
                  }
                  b = {layer:f}
                }else {
                  if(a == viewer.viewercontroller.controller.Event.ON_LAYER_REMOVED) {
                    g = b[1], g.indexOf(c + "_") == 0 && (g = g.substring(c.length + 1)), f = e.getLayer(g), b = {}, b.layer = f
                  }else {
                    if(a == viewer.viewercontroller.controller.Event.ON_MAPTIP) {
                      d = {}, d.x = b[1], d.y = b[2], d.coord = b[3], b = d
                    }else {
                      if(a == viewer.viewercontroller.controller.Event.ON_MAPTIP_DATA) {
                        d = {};
                        d.coord = b[2];
                        d.x = b[2].x;
                        d.y = b[2].y;
                        d.coord.x = b[2].minx;
                        d.coord.y = b[2].miny;
                        c = [];
                        f = 0;
                        for(g in b[1]) {
                          c[f] = {request:{appLayer:e.appLayerId}, features:b[1][g]}
                        }
                        d.data = c;
                        b = d
                      }else {
                        if(a == viewer.viewercontroller.controller.Event.ON_ACTIVE_FEATURE_CHANGED || a == viewer.viewercontroller.controller.Event.ON_FEATURE_ADDED) {
                          g = b[1].fmc_layername, e = this.getMap().getLayer(g), b = Ext.create("viewer.viewercontroller.controller.Feature", b[1])
                        }else {
                          if(a == viewer.viewercontroller.controller.Event.ON_ALL_LAYERS_LOADING_COMPLETE) {
                            if(!this.viewerController.layersInitialized) {
                              return
                            }
                          }else {
                            if(a == viewer.viewercontroller.controller.Event.ON_FINISHED_CHANGE_EXTENT) {
                              d = {};
                              if(b[1]) {
                                d.extent = new viewer.viewercontroller.controller.Extent(b[1].minx, b[1].miny, b[1].maxx, b[1].maxy)
                              }else {
                                return
                              }
                              b = d
                            }else {
                              a == viewer.viewercontroller.controller.Event.ON_CHANGE_EXTENT ? b = d = {extent:e.getExtent()} : a == viewer.viewercontroller.controller.Event.ON_MAP_CLICKED && (i = d = {coord:b[1]}, b = i)
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  e != void 0 && e.fire(a, b)
}, fire:function(a, b) {
  this.fireEvent(a, this, b)
}, addListener:function(a, b, c) {
  viewer.viewercontroller.FlamingoMapComponent.superclass.addListener.call(this, a, b, c);
  if(this.viewerObject != void 0 && typeof this.viewerObject.callMethod == "function" && this.eventList != void 0) {
    var e = this.eventList[a];
    e != void 0 && this.enabledEvents[e] == void 0 && (this.viewerObject.callMethod(this.getId(), "addAllowExternalInterface", this.getId() + "." + e), this.enabledEvents[e] = true)
  }else {
    var f = this;
    setTimeout(function() {
      f.addListener(a, b, c)
    }, 100)
  }
}, getWidth:function() {
  return this.viewerObject.callMethod(this.flamingoId, "getWidth")
}, getHeight:function() {
  return this.viewerObject.callMethod(this.flamingoId, "getHeight")
}, makeFlamingoAcceptableId:function(a) {
  a = "" + a;
  a.indexOf(":") != -1 && (a = a.replace(/:/g, "_"));
  return a
}});
function dispatchEventJS(a, b) {
  b[0] == null && (b[0] = viewerController.mapComponent.getId(), b[1] = {});
  try {
    viewerController.mapComponent.handleEvents(a, b)
  }catch(c) {
    window.console && console.log && console.log(c)
  }
}
;
// Input 13
Ext.define("viewer.viewercontroller.flamingo.Overview", {extend:"viewer.viewercontroller.flamingo.FlamingoComponent", showButton:null, config:{position:null, url:null, lox:null, loy:null, rbx:null, rby:null, picSelected:null, picOver:null, picNormal:null, picTop:null, picLeft:null}, constructor:function(a) {
  viewer.viewercontroller.flamingo.Overview.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.events = [];
  return this
}, toXML:function() {
  var a = this.lox + "," + this.loy + "," + this.rbx + "," + this.rby, b = "<fmc:Map id='Map" + this.name + "'  width='" + this.width + "' height='" + this.height + "' clear='true' ";
  b += "extent='" + this.viewerController.mapComponent.getMap().getExtent().toString() + "' fullextent='" + this.viewerController.mapComponent.getMap().getMaxExtent().toString() + "'";
  b += "listento='" + this.viewerController.mapComponent.getMap().getId() + "'>";
  b += "<fmc:LayerOverview xmlns:fmc='fmc' id='LayerOverview" + this.name + "' listento='" + this.viewerController.mapComponent.getMap().getId() + "' color='#76B6D1'";
  b += " followfactor='200'/>";
  b += "<fmc:LayerImage id='layerimageoverview" + this.name + "' imageurl='" + this.url + "'";
  b += " extent='" + a + "' listento='" + this.viewerController.mapComponent.getMap().getId() + "'/>";
  b += "</fmc:Map>";
  a = "";
  if(this.position == "upperleft") {
    var c = this.viewerController.getLayout("top_menu"), a = "left = 'left 0' top = '" + c.height;
    a += c.heightmeasure == "px" ? "" : c.heightmeasure;
    a += "'"
  }else {
    this.position == "upperright" ? (c = this.viewerController.getLayout("top_menu"), a = "right = 'right 0' top = '" + c.height, a += c.heightmeasure == "px" ? "" : c.heightmeasure, a += "'") : this.position == "lowerleft" ? (c = this.viewerController.getLayout("content_bottom"), a = "left = 'left 0' bottom = 'bottom -" + c.height, a += c.heightmeasure == "px" ? "" : c.heightmeasure, a += "'") : this.position == "lowerright" && (c = this.viewerController.getLayout("content_bottom"), a = "right = 'right 0' bottom = 'bottom -" + 
    c.height, a += c.heightmeasure == "px" ? "" : c.heightmeasure, a += "'")
  }
  c = {toggle:true, enabled:true, visible:true, selected:true};
  c.iconUrl_up = this.picNormal;
  c.iconUrl_over = this.picOver;
  c.iconUrl_sel = this.picSelected;
  c.iconUrl_dis = this.picNormal;
  c.left = this.picLeft;
  c.top = this.picTop;
  c.viewerController = this.viewerController;
  c.tooltip = "Open/sluit de overzichtskaart";
  this.showButton = Ext.create("viewer.components.tools.JSButton", c);
  var e = this;
  this.showButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_DOWN, function() {
    e.showOverview(true)
  }, this);
  this.showButton.addListener(viewer.viewercontroller.controller.Event.ON_EVENT_UP, function() {
    e.showOverview(false)
  }, this);
  a = "<fmc:Container id='" + this.name + "windowcontainer' " + a + " width='" + this.width + "' height='" + this.height + "' borderwidth='0' bordercolor='#D0D0D0' backgroundcolor='#FFFFFF'>";
  a += b;
  a += "</fmc:Container>";
  return a
}, getExtComponents:function() {
  return[]
}, showOverview:function(a) {
  this.viewerController.mapComponent.viewerObject.callMethod(this.name + "windowcontainer", "setVisible", a)
}});
// Input 14
Ext.define("viewer.components.tools.JSButton", {extend:"viewer.viewercontroller.flamingo.FlamingoTool", config:{name:"JSButton", iconUrl_up:null, iconUrl_over:null, iconUrl_sel:null, iconUrl_dis:null, toggle:false, enabled:false, selected:false, tooltip:null}, constructor:function(a) {
  viewer.components.tools.JSButton.superclass.constructor.call(this, a);
  this.initConfig(a);
  this.id = this.name;
  this.mapComponent = this.viewerController.mapComponent;
  this.frameworkObject = this.viewerController.mapComponent.viewerObject;
  this.viewerController.mapComponent.addTool(this);
  return this
}, toXML:function() {
  var a = "<fmc:";
  a += this.getTagName();
  a += " xmlns:fmc='fmc'";
  this.getId() != null && (a += " id='" + this.getId() + "'");
  this.getWidth() != null && (a += " width='" + this.getWidth() + "'");
  this.getHeight() != null && (a += " height='" + this.getHeight() + "'");
  this.getTop() != null && (a += " top='" + this.getTop() + "'");
  this.getLeft() != null && (a += " left='" + this.getLeft() + "'");
  this.getRight() != null && (a += " right='" + this.getRight() + "'");
  this.getBottom() != null && (a += " bottom='" + this.getBottom() + "'");
  this.getListenTo() != null && (a += " listento='" + this.getListenTo() + "'");
  a += " iconurl_up='" + this.iconUrl_up + "'";
  a += " iconurl_down='" + this.iconUrl_down + "'";
  a += " iconurl_over='" + this.iconUrl_over + "'";
  a += " iconurl_sel='" + this.iconUrl_sel + "'";
  a += " iconurl_dis='" + this.iconUrl_dis + "'";
  this.visible != void 0 && (a += " visible='" + this.visible + "'");
  this.getEnabled() != null && (a += " enabled='" + this.enabled + "'");
  a += " selected='" + this.selected + "'";
  a += " toggle='" + this.toggle + "'";
  a += ">";
  this.getTooltip() != null && (a += "<string id='tooltip' en='" + this.getTooltip() + "'/>");
  a += "</fmc:" + this.getTagName(this.getType()) + ">";
  return a
}, getTagName:function() {
  return"JsButton"
}, activate:function() {
  this.setSelectedState(true)
}, deactivate:function() {
  this.setSelectedState(false)
}, setSelectedState:function(a) {
  this.frameworkObject.callMethod(this.getId(), "setSelectedState", a)
}});
