/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.stripes.BouwplanUtils;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernatespatial.criterion.SpatialRestrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
public class SearchActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(SearchActionBean.class);
    @Validate
    private String provincie;
    @Validate
    private String regio;
    @Validate
    private String geom;
    @Validate
    private String x;
    @Validate
    private String y;
    private GeometryFactory geoFact = new GeometryFactory(new PrecisionModel(), 28992);
    private List<Regio> regios = new ArrayList<Regio>();
    private List<Gemeente> gemeentes = new ArrayList<Gemeente>();
    private String facets = "";
    private String initialExtent;

    @DefaultHandler
    public Resolution searchdefault() {
        return new ForwardResolution("/WEB-INF/jsp/search.jsp");
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void createLists() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        if (this.gebruiker != null) {
            this.facets = this.getFacetsForUser();
            Provincie p = this.gebruiker.resolveProvincie();
            Envelope bbox = null;
            if (this.gebruiker.getProvincie() != null) {
                bbox = this.gebruiker.getProvincie().getTheGeom().getEnvelopeInternal();
                this.provincie = p.getNaam();
            }
            if (this.gebruiker.getRegio() != null) {
                this.regio = this.gebruiker.getRegio().getNaam();
                bbox = this.gebruiker.getRegio().getTheGeom().getEnvelopeInternal();
            }
            if (this.gebruiker.getGemeente() != null) {
                bbox = this.gebruiker.getGemeente().getGemeenteGeom().getTheGeom().getEnvelopeInternal();
            }
            if (bbox != null) {
                this.initialExtent = this.getExtent(bbox).toString();
            }
            this.gemeentes = em.createQuery("FROM Gemeente where provincie = :provincie order by naam").setParameter("provincie", (Object)p).getResultList();
            this.regios = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", (Object)p).getResultList();
        } else {
            if (this.provincie != null) {
                try {
                    Provincie p = (Provincie)em.createQuery("FROM Provincie where naam = :name", Provincie.class).setParameter("name", (Object)this.provincie).getSingleResult();
                    this.gemeentes = em.createQuery("FROM Gemeente where provincie = :provincie order by naam").setParameter("provincie", (Object)p).getResultList();
                    this.regios = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", (Object)p).getResultList();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.gemeentes.isEmpty()) {
                this.gemeentes = em.createQuery("FROM Gemeente order by naam").getResultList();
                this.regios = em.createQuery("from Regio order by naam").getResultList();
            }
        }
    }

    public Resolution filterGemeente() {
        List rs;
        EntityManager em = Stripersist.getEntityManager();
        Provincie p = null;
        Object r = null;
        List<String> regioList = Arrays.asList(this.regio.split(","));
        if (this.provincie != null) {
            p = (Provincie)em.createQuery("FROM Provincie where naam = :name", Provincie.class).setParameter("name", (Object)this.provincie).getSingleResult();
            rs = em.createQuery("select r from Regio r join r.provincie p where p = :provincie and r.naam in :regio order by r.naam", Regio.class).setParameter("provincie", (Object)p).setParameter("regio", regioList).getResultList();
        } else {
            rs = em.createQuery("select r from Regio r where r.naam in :regio order by r.naam", Regio.class).setParameter("regio", regioList).getResultList();
        }
        this.gemeentes = em.createQuery("FROM Gemeente where regio in :regio order by naam").setParameter("regio", (Object)rs).getResultList();
        final JSONArray ar = new JSONArray();
        for (Gemeente gemeente : this.gemeentes) {
            ar.put((Object)gemeente.getNaam());
        }
        return new StreamingResolution("application/json"){

            public void stream(HttpServletResponse response) throws Exception {
                response.getWriter().print(ar.toString());
            }
        };
    }

    private JSONObject getExtent(Envelope e) throws JSONException {
        JSONObject extent = new JSONObject();
        extent.put("minx", e.getMinX());
        extent.put("miny", e.getMinY());
        extent.put("maxx", e.getMaxX());
        extent.put("maxy", e.getMaxY());
        return extent;
    }

    public Resolution close() {
        return new ForwardResolution("/WEB-INF/jsp/search.jsp");
    }

    public Resolution getBouwplanIdsByCoord() {
        Double x = new Double(this.x);
        Double y = new Double(this.y);
        Point point = this.geoFact.createPoint(new Coordinate(x.doubleValue(), y.doubleValue()));
        EntityManager em = Stripersist.getEntityManager();
        Session sess = (Session)em.getDelegate();
        Criteria criteria = sess.createCriteria(Bouwplan.class);
        criteria.add(Restrictions.isNotNull((String)"the_geom"));
        criteria.add((Criterion)SpatialRestrictions.intersects((String)"the_geom", (Geometry)point));
        criteria.add(Restrictions.sqlRestriction((String)"statusprojectid <> 13"));
        List geselecteerdePlannenAll = criteria.list();
        Iterator it = geselecteerdePlannenAll.iterator();
        final JSONArray validBouwplannen = new JSONArray();
        while (it.hasNext()) {
            Bouwplan b = (Bouwplan)it.next();
            if (!BouwplanUtils.isAuthorized(b, this.gebruiker)) continue;
            validBouwplannen.put((Object)b.getId());
        }
        return new StreamingResolution("application/json"){

            public void stream(HttpServletResponse response) throws Exception {
                response.getWriter().print(validBouwplannen.toString());
            }
        };
    }

    private String getFacetsForUser() {
        String facets = "";
        EntityManager em = Stripersist.getEntityManager();
        Provincie p = this.gebruiker.resolveProvincie();
        List vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", (Object)VariableType.SEARCH).getResultList();
        List facetsList = em.createQuery("select variable.name FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie").setParameter("vars", (Object)vars).setParameter("provincie", (Object)p).getResultList();
        facets = StringUtils.join((Collection)facetsList, (String)",");
        return facets;
    }

    public String getProvincie() {
        return this.provincie;
    }

    public void setProvincie(String provincie) {
        this.provincie = provincie;
    }

    public String getGeom() {
        return this.geom;
    }

    public void setGeom(String geom) {
        this.geom = geom;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public String getFacets() {
        return this.facets;
    }

    public void setFacets(String facets) {
        this.facets = facets;
    }

    public List<Regio> getRegios() {
        return this.regios;
    }

    public void setRegios(List<Regio> regios) {
        this.regios = regios;
    }

    public List<Gemeente> getGemeentes() {
        return this.gemeentes;
    }

    public void setGemeentes(List<Gemeente> gemeentes) {
        this.gemeentes = gemeentes;
    }

    public String getRegio() {
        return this.regio;
    }

    public void setRegio(String regio) {
        this.regio = regio;
    }

    public String getInitialExtent() {
        return this.initialExtent;
    }

    public void setInitialExtent(String initialExtent) {
        this.initialExtent = initialExtent;
    }
}

