/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes.sld;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.OnzichtbaarWoningBouwplanEntry;
import nl.b3p.pzh.rwbp.SldMapEntry;
import nl.b3p.pzh.rwbp.WoningBouwplanEntry;
import nl.b3p.pzh.rwbp.ZichtbaarWoningBouwplanEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@StrictBinding
public class SldFilterActionBean
implements ActionBean {
    private static final String ENCODING = "UTF-8";
    private static final Log log = LogFactory.getLog(SldFilterActionBean.class);
    private ActionBeanContext context;
    @Validate
    private String sldkey;
    @Validate
    private String mode;
    public static final String OGCNS = "http://www.opengis.net/ogc";
    public static final String SLDNS = "http://www.opengis.net/sld";
    public static final String SENS = "http://www.opengis.net/se";
    public static final String STROKEOPACITY = "stroke-opacity";
    public static final String STROKEWIDTH = "stroke-width";
    public static final String TEXTCOLOR = "fill";
    public static final String HALOCOLOR = "halofill";
    public static final String FILLCOLOR = "fill-color";
    public static final String FILLOPACITY = "fill-opacity";
    public static final String FONTFAMILY = "font-family";
    public static final String FONTSIZE = "font-size";
    public static final int ACTIEF_BOUWPLAN = 1;
    public static final int INACTIEF_BOUWPLAN = 2;
    public static final String INACTIEVE_BOUWPLAN_KLEUR = "#BEC0C0";
    public static String serverUrl = null;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getSldkey() {
        return this.sldkey;
    }

    public void setSldkey(String sldkey) {
        this.sldkey = sldkey;
    }

    @DefaultHandler
    public Resolution displaySld() throws Exception {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createLayer(Document doc, Node root, Map<String, List<WoningBouwplanEntry>> variatieLijst, String laag) throws Exception {
        Element namedLayer = doc.createElementNS(SLDNS, "NamedLayer");
        Element name = doc.createElementNS(SLDNS, "Name");
        name.appendChild(doc.createTextNode(laag));
        namedLayer.appendChild(name);
        Node userStyle = this.createUserstyle(doc, (Node)namedLayer);
        Set<Map.Entry<String, List<WoningBouwplanEntry>>> entries = variatieLijst.entrySet();
        for (Map.Entry<String, List<WoningBouwplanEntry>> entry : entries) {
            this.createVariatie(doc, entry.getKey(), entry.getValue(), userStyle);
        }
        root.appendChild(namedLayer);
    }

    private Node createUserstyle(Document doc, Node namedLayer) {
        Element userStyle = doc.createElementNS(SLDNS, "UserStyle");
        Element styleName = doc.createElementNS(SLDNS, "Name");
        Element featureTypeStyle = doc.createElementNS(SLDNS, "FeatureTypeStyle");
        styleName.appendChild(doc.createTextNode("nieuweStyle"));
        userStyle.appendChild(styleName);
        userStyle.appendChild(featureTypeStyle);
        namedLayer.appendChild(userStyle);
        return featureTypeStyle;
    }

    private void createVariatie(Document doc, String key, List<WoningBouwplanEntry> woningBouwplannen, Node userStyle) throws Exception {
        String actief = key.substring(0, key.indexOf("_"));
        int relatie = actief.equals("actief") ? 2 : 1;
        boolean isActief = actief.equals("actief");
        if (isActief) {
            for (WoningBouwplanEntry woningbouwplan : woningBouwplannen) {
                ZichtbaarWoningBouwplanEntry wbe = (ZichtbaarWoningBouwplanEntry)woningbouwplan;
                String label = wbe.getLabel();
                Element rule = doc.createElementNS(SLDNS, "Rule");
                Element filter = doc.createElementNS(OGCNS, "Filter");
                Element propertyIsEqualTo = doc.createElementNS(OGCNS, "PropertyIsEqualTo");
                Element propertyName = doc.createElementNS(OGCNS, "PropertyName");
                propertyName.appendChild(doc.createTextNode("id"));
                propertyIsEqualTo.appendChild(propertyName);
                Element literal = doc.createElementNS(OGCNS, "Literal");
                literal.appendChild(doc.createTextNode("" + wbe.getId()));
                propertyIsEqualTo.appendChild(literal);
                filter.appendChild(propertyIsEqualTo);
                rule.appendChild(filter);
                userStyle.appendChild(rule);
                Node polygonSymbolizer = this.createStylePolygon(doc, relatie, (WoningBouwplanEntry)wbe, isActief);
                Node textSymbolizer = this.createStyleText(doc, label, relatie, isActief);
                rule.appendChild(polygonSymbolizer);
                rule.appendChild(textSymbolizer);
            }
        } else {
            boolean needsOr;
            Element rule = doc.createElementNS(SLDNS, "Rule");
            Element filter = doc.createElementNS(OGCNS, "Filter");
            Object connectCheck = filter;
            boolean bl = needsOr = woningBouwplannen.size() > 1;
            if (needsOr) {
                Element or = doc.createElementNS(OGCNS, "Or");
                filter.appendChild(or);
                connectCheck = or;
            }
            for (WoningBouwplanEntry woningbouwplan : woningBouwplannen) {
                OnzichtbaarWoningBouwplanEntry wbe = (OnzichtbaarWoningBouwplanEntry)woningbouwplan;
                Element propertyIsEqualTo = doc.createElementNS(OGCNS, "PropertyIsEqualTo");
                Element propertyName = doc.createElementNS(OGCNS, "PropertyName");
                propertyName.appendChild(doc.createTextNode("id"));
                propertyIsEqualTo.appendChild(propertyName);
                Element literal = doc.createElementNS(OGCNS, "Literal");
                literal.appendChild(doc.createTextNode("" + wbe.getId()));
                propertyIsEqualTo.appendChild(literal);
                connectCheck.appendChild(propertyIsEqualTo);
            }
            rule.appendChild(filter);
            userStyle.appendChild(rule);
            Node polygonsymbolizer = this.createStylePolygon(doc, relatie, woningBouwplannen.get(0), isActief);
            rule.appendChild(polygonsymbolizer);
        }
    }

    private Node createStylePolygon(Document doc, int relatie, WoningBouwplanEntry wbe, boolean actief) throws Exception {
        String geoProperty = "geom";
        Map styles = this.getStyleMap(actief);
        Element polygonSymbolizer = doc.createElementNS(SLDNS, "PolygonSymbolizer");
        Element geo = doc.createElementNS(SLDNS, "Geometry");
        Element propName = doc.createElementNS(OGCNS, "PropertyName");
        propName.appendChild(doc.createTextNode(geoProperty));
        geo.appendChild(propName);
        Element fill = doc.createElementNS(SLDNS, "Fill");
        Element stroke = doc.createElementNS(SLDNS, "Stroke");
        if (wbe.hasHatch()) {
            Element hatch = doc.createElementNS(SLDNS, "GraphicFill");
            Element graphic = doc.createElementNS(SLDNS, "Graphic");
            Element externalGraphic = doc.createElementNS(SLDNS, "ExternalGraphic");
            Element onlineResource = doc.createElementNS(SLDNS, "OnlineResource");
            Element size = doc.createElementNS(SLDNS, "Size");
            size.appendChild(doc.createTextNode("4"));
            String imageName = "%23" + wbe.getKleur().substring(1) + "hatchActive.png";
            onlineResource.setAttribute("xlink:href", serverUrl + "images/" + imageName);
            Element format = doc.createElementNS(SLDNS, "Format");
            format.appendChild(doc.createTextNode("image/png"));
            externalGraphic.appendChild(format);
            externalGraphic.appendChild(onlineResource);
            graphic.appendChild(externalGraphic);
            graphic.appendChild(size);
            hatch.appendChild(graphic);
            fill.appendChild(hatch);
        } else {
            Element cssParamFillColor = doc.createElementNS(SLDNS, "CssParameter");
            cssParamFillColor.setAttribute("name", TEXTCOLOR);
            cssParamFillColor.appendChild(doc.createTextNode(wbe.getKleur()));
            fill.appendChild(cssParamFillColor);
            Element cssParamFillOpacity = doc.createElementNS(SLDNS, "CssParameter");
            cssParamFillOpacity.setAttribute("name", FILLOPACITY);
            cssParamFillOpacity.appendChild(doc.createTextNode((String)styles.get(FILLOPACITY)));
            fill.appendChild(cssParamFillOpacity);
        }
        Element cssParamStrokeColor = doc.createElementNS(SLDNS, "CssParameter");
        cssParamStrokeColor.setAttribute("name", "stroke");
        cssParamStrokeColor.appendChild(doc.createTextNode(wbe.getLijnKleur()));
        stroke.appendChild(cssParamStrokeColor);
        Element cssParamStrokeOpacity = doc.createElementNS(SLDNS, "CssParameter");
        cssParamStrokeOpacity.setAttribute("name", STROKEOPACITY);
        cssParamStrokeOpacity.appendChild(doc.createTextNode((String)styles.get(STROKEOPACITY)));
        stroke.appendChild(cssParamStrokeOpacity);
        Element cssParamStrokeWidth = doc.createElementNS(SLDNS, "CssParameter");
        cssParamStrokeWidth.setAttribute("name", STROKEWIDTH);
        cssParamStrokeWidth.appendChild(doc.createTextNode((String)styles.get(STROKEWIDTH)));
        stroke.appendChild(cssParamStrokeWidth);
        polygonSymbolizer.appendChild(geo);
        polygonSymbolizer.appendChild(fill);
        polygonSymbolizer.appendChild(stroke);
        return polygonSymbolizer;
    }

    private Node createStyleText(Document doc, String text, int relatie, boolean actief) throws Exception {
        Map styles = this.getStyleMap(actief);
        Element textSymbolizer = doc.createElement("TextSymbolizer");
        Element geometry = doc.createElement("Geometry");
        Element propertyName = doc.createElementNS(OGCNS, "PropertyName");
        propertyName.appendChild(doc.createTextNode("geom"));
        geometry.appendChild(propertyName);
        textSymbolizer.appendChild(geometry);
        Element label = doc.createElement("ogc:Label");
        Element labelProperty = doc.createElement("ogc:PropertyName");
        labelProperty.appendChild(doc.createTextNode("naam"));
        label.appendChild(labelProperty);
        textSymbolizer.appendChild(label);
        Element font = doc.createElement("Font");
        Element cssFontFamily = doc.createElementNS(SLDNS, "CssParameter");
        cssFontFamily.setAttribute("name", FONTFAMILY);
        cssFontFamily.appendChild(doc.createTextNode((String)styles.get(FONTFAMILY)));
        font.appendChild(cssFontFamily);
        Element cssFontSize = doc.createElementNS(SLDNS, "CssParameter");
        cssFontSize.setAttribute("name", FONTSIZE);
        cssFontSize.appendChild(doc.createTextNode((String)styles.get(FONTSIZE)));
        font.appendChild(cssFontSize);
        textSymbolizer.appendChild(font);
        Element halo = doc.createElementNS(SLDNS, "Halo");
        Element radius = doc.createElementNS(SLDNS, "Radius");
        radius.appendChild(doc.createTextNode("3"));
        Element haloFill = doc.createElementNS(SLDNS, "Fill");
        Element cssParamHaloFillColor = doc.createElementNS(SLDNS, "CssParameter");
        cssParamHaloFillColor.setAttribute("name", TEXTCOLOR);
        cssParamHaloFillColor.appendChild(doc.createTextNode((String)styles.get(HALOCOLOR)));
        haloFill.appendChild(cssParamHaloFillColor);
        halo.appendChild(haloFill);
        halo.appendChild(radius);
        textSymbolizer.appendChild(halo);
        Element fill = doc.createElementNS(SLDNS, "Fill");
        Element cssParamFillColor = doc.createElementNS(SLDNS, "CssParameter");
        cssParamFillColor.setAttribute("name", TEXTCOLOR);
        cssParamFillColor.appendChild(doc.createTextNode((String)styles.get(TEXTCOLOR)));
        fill.appendChild(cssParamFillColor);
        textSymbolizer.appendChild(fill);
        Element labelPlacement = doc.createElement("LabelPlacement");
        Element pointPlacement = doc.createElement("PointPlacement");
        Element displacement = doc.createElement("Displacement");
        Element displacementX = doc.createElement("DisplacementX");
        displacementX.appendChild(doc.createTextNode("10"));
        Element displacementY = doc.createElement("DisplacementY");
        displacementY.appendChild(doc.createTextNode("20"));
        displacement.appendChild(displacementX);
        displacement.appendChild(displacementY);
        pointPlacement.appendChild(displacement);
        Element anchorPoint = doc.createElement("AnchorPoint");
        Element anchorPointX = doc.createElement("AnchorPointX");
        String anchorP = "1.0";
        anchorPointX.appendChild(doc.createTextNode(anchorP));
        Element anchorPointY = doc.createElement("AnchorPointY");
        anchorPointY.appendChild(doc.createTextNode(anchorP));
        anchorPoint.appendChild(anchorPointX);
        anchorPoint.appendChild(anchorPointY);
        pointPlacement.appendChild(anchorPoint);
        labelPlacement.appendChild(pointPlacement);
        textSymbolizer.appendChild(labelPlacement);
        return textSymbolizer;
    }

    private String getFilter(SldMapEntry entry) {
        String filter = "";
        if (entry.getExtraLaag().length != 0 && entry.getExtraLaag()[0] != null) {
            String extraLaag = entry.getExtraLaag()[0];
            String rolId = entry.getExtraLaagId();
            if (extraLaag.startsWith("bouwplan_gemeente")) {
                filter = "gemeenteid = " + rolId + " and gebruikgegevensid != 1 or gebruikgegevensid = 4";
            } else if (extraLaag.startsWith("bouwplan_regio")) {
                filter = "regioid = " + rolId + " and (gebruikgegevensid != 3 and gebruikgegevensid != 1 or gebruikgegevensid is null) or gebruikgegevensid = 4";
            } else if (extraLaag.startsWith("bouwplan_provincie")) {
                filter = "provincieid = " + rolId + " and (gebruikgegevensid != 3 and gebruikgegevensid != 1 or gebruikgegevensid is null) or gebruikgegevensid = 4";
            } else if (extraLaag.startsWith("bouwplan_rijk")) {
                filter = "gebruikgegevensid = 4";
            }
        }
        return filter;
    }

    private Map<String, String> getStyleMap(boolean actief) throws Exception {
        HashMap<String, String> styles = new HashMap<String, String>();
        if (actief) {
            styles.put(FILLCOLOR, "#FF0000");
            styles.put(FILLOPACITY, "0.6");
            styles.put(STROKEOPACITY, "1.0");
            styles.put(STROKEWIDTH, "2.0");
            styles.put(TEXTCOLOR, "#000000");
            styles.put(HALOCOLOR, "#FFFFFF");
            styles.put(FONTFAMILY, "arial");
            styles.put(FONTSIZE, "10");
        } else {
            styles.put(FILLCOLOR, "#999999");
            styles.put(FILLOPACITY, "0.6");
            styles.put(STROKEOPACITY, "1.0");
            styles.put(STROKEWIDTH, "1.0");
        }
        return styles;
    }

    private Document getDefaultSld() {
        Document doc = null;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ServletContext sc = this.getContext().getServletContext();
            String p = sc.getRealPath("/WEB-INF/DefaultSld.xml");
            File f = new File(p);
            doc = db.parse(f);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return doc;
    }

    static /* synthetic */ ActionBeanContext access$000(SldFilterActionBean x0) {
        return x0.context;
    }

    static /* synthetic */ String access$100(SldFilterActionBean x0) {
        return x0.sldkey;
    }

    static /* synthetic */ Log access$200() {
        return log;
    }

    static /* synthetic */ Document access$300(SldFilterActionBean x0) {
        return x0.getDefaultSld();
    }

    static /* synthetic */ String access$400(SldFilterActionBean x0, SldMapEntry x1) {
        return x0.getFilter(x1);
    }

    static /* synthetic */ void access$500(SldFilterActionBean x0, Document x1, Node x2, Map x3, String x4) throws Exception {
        x0.createLayer(x1, x2, x3, x4);
    }
}

