<%@include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<stripes:layout-definition>
    <!DOCTYPE html>
    <html>
        <head>
            <title>Planmonitor Wonen - ${pageTitle}</title>
            <meta http-equiv="Content-type" content="text/html; charset=UTF-8" />
            <meta http-equiv="X-UA-Compatible" content="IE=Edge">
            <link rel="shortcut icon" href="./images/favicon.ico" />
            <link href="./styles/jquery-ui-1.11.2.min.css" rel="stylesheet" type="text/css" />
            <link rel="stylesheet" type="text/css" href="./js/extjs/resources/css/crisp/ext-theme-crisp-all.css">
            <link href="./styles/rwbp4.css" rel="stylesheet" type="text/css" />
            <c:if test="${not empty actionBean.resolvedProvincie.naam}">
                <link href="./styles/${fn:replace(actionBean.resolvedProvincie.naam,'â','a')}.css" rel="stylesheet" type="text/css" />
            </c:if>
            
            <script type="text/javascript" src="./js/jquery-1.11.2.min.js"></script>
            <script type="text/javascript" src="./js/jquery-ui-1.11.2.min.js"></script>
            <script type="text/javascript" src="./js/extjs/ext-all-debug.js"></script>
            <script type="text/javascript" src="./js/extjs/locale/ext-locale-nl.js"></script>
            <script type="text/javascript" src="./js/main.js"></script>
            <script type="text/javascript" src="./js/viewer-html/common/MobileManager.js"></script>

            <link href="resources/css/flamingo.css" rel="stylesheet" type="text/css" />
            <c:set var="flamingo4" value="true"/>
            <script type="text/javascript">
                //dummy object if console is undefined
                if(console == undefined) {
                   var console = {};
                   console.log = function(logmsg) {
                       //alert(logmsg);
                   }
                }
                var flamingo4 = <c:out value="${flamingo4}"/>;
                var MobileManager= new viewer.components.MobileManager();
                // These variables are needed by some components, we do not use them
                var actionBeans = {css:"resources/css/empty.css"};
                var contextPath = "${contextPath}";
                
                function loadBackgroundLayers(viewerController, legend) {
                    var appLayerId = 100;
                
                <c:forEach items="${actionBean.provincieServices}" var="service">
                    var url = "${service.url}";
                    var layers = "${service.layers}";
                    var on = ${service.defaultOn};
                    
                    var ogcParams ={
                        layers : layers,
                        srs: "epsg:28992",
                        transparent: true
                    };
                    var name=null;
                    <c:if test="${not empty service.name}">
                        name="${service.name}";
                    </c:if>
                    if (name==null){
                        name = layers;
                    }
                    var wmsLayer = viewerController.mapComponent.createWMSLayer (name, url, ogcParams,{id:'pm'+appLayerId,title:name,name: name,visible: on,ratio: 1});
                    wmsLayer.setAlpha(70);
                    viewerController.mapComponent.getMap().addLayer(wmsLayer);
                    legend.addLayer(wmsLayer,"Eigen service");

                    appLayerId++;
                </c:forEach>
                }
            </script>
            
            <c:choose>
                <c:when test="${flamingo4}">
                    <c:set var="debug" value="true"/>
                    <!-- viewer files -->
                    <link href="js/viewer-html/components/resources/css/logger.css" rel="stylesheet">                    
                    <script type="text/javascript" src="./js/viewer/proj4js-compressed.js"></script>
                    <c:choose>
                        <c:when test="${param.flamingo != null && param.flamingo }">
                            <script type="text/javascript" src="./js/viewer/config.js"></script>
                        </c:when>
                        <c:otherwise>
                            <script type="text/javascript" src="./js/viewer-html/common/openlayers/lib/OpenLayers.js"></script>
                            <script type="text/javascript" src="./js/viewer/config_ol.js"></script>
                        </c:otherwise>
                    </c:choose>
                    <c:choose>
                        <c:when test="${debug}">
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/ViewerController.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/MapComponent.js"></script>

                            <script type="text/javascript" src="./js/viewer-html/components/Component.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/LogMessage.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/Logger.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/DataSelectionChecker.js"></script>

                            <script type="text/javascript" src="./js/viewer-html/components/NavigationPanel.js"></script>                    
                            <script type="text/javascript" src="./js/viewer-html/components/tools/Tool.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/tools/Identify.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/LayerSwitch.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/tools/Pan.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/tools/ZoomIn.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/tools/ZoomOut.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/tools/NextExtent.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/components/tools/PreviousExtent.js"></script>

                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/Map.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/Layer.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/TilingLayer.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/WMSLayer.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/ImageLayer.js"></script>                
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/VectorLayer.js"></script>                
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/ArcLayer.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/Feature.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/MapTip.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/Extent.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/Event.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/Tool.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/Component.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/controller/ToolMapClick.js"></script>

                            <c:choose>
                                <c:when test="${param.flamingo != null && param.flamingo }">
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoArcLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoArcServerLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoArcIMSLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoWMSLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoVectorLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoMap.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoTool.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoImageLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoTilingLayer.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/ToolMapClick.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoComponent.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/FlamingoMapComponent.js"></script> 
                                    
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/components/Overview.js"></script>
                                    <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/flamingo/tools/JSButton.js"></script>

                            </c:when>
                            <c:otherwise>
                                <link href="./js/viewer-html/common/resources/css/openlayers.css" rel="stylesheet">
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersArcLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersArcIMSLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersArcServerLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersWMSLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersVectorLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersImageLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersTilingLayer.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersTool.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersMap.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/Utils.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/ToolMapClick.js"></script>

                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersComponent.js"></script>

                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/OpenLayersMapComponent.js"></script>

                                <!-- The components -->
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/components/LoadingPanel.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/components/OpenLayersBorderNavigation.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/components/OpenLayersLoadMonitor.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/components/OpenLayersOverview.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/components/OpenLayersMaptip.js"></script>

                                <!-- The tools -->                        
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/tools/OpenLayersIdentifyTool.js"></script>
                                <script type="text/javascript" src="./js/viewer-html/common/viewercontroller/openlayers/tools/OpenLayersDefaultTool.js"></script>
                        
                        </c:otherwise>
                        </c:choose>
                            <script type="text/javascript" src="./js/viewer-html/common/overrides.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/layout.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ScreenPopup.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/CQLFilterWrapper.js"></script>

                            <script type="text/javascript" src="./js/viewer-html/common/ajax/ServiceInfo.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/CSWClient.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/FeatureService.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/SLD.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/Bookmark.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/LayerSelector.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/CombineImage.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/FeatureInfo.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/EditFeature.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/ArcQueryUtil.js"></script>
                            <script type="text/javascript" src="./js/viewer-html/common/ajax/Twitter.js"></script>

                        </c:when>
                        <c:otherwise>                    
                            <script type="text/javascript" src="./js/viewer/viewer-min.js"></script>                
                            <script type="text/javascript" src="./js/viewer/flamingo-min.js"></script>

                            <script type="text/javascript" src="./js/viewer/layout.js"></script>
                            <script type="text/javascript" src="./js/viewer/component.js"></script>


                            <!--end of viewer-->
                        </c:otherwise>
                    </c:choose>
                </c:when> 
            </c:choose>
            <script>
                (function(OpenLayers) {
                    if(!OpenLayers) {
                        return;
                    }
                    /* Override util class OpenLayers to comply to ExtJS id regex */
                    OpenLayers.Util.createUniqueID = function(prefix) {
                        if (prefix == null) {
                            prefix = "id_";
                        }
                        OpenLayers.Util.lastSeqID += 1;
                        // Added this replace, to make sure there are no dots in the ID
                        return prefix.replace(/\./g, '_') + OpenLayers.Util.lastSeqID;        
                    };
                })(OpenLayers);
            </script>
            <script type="text/javascript" src="./js/viewer.js"></script>
            
            <stripes:layout-component name="head"/>            
        </head>
        <body>
            <header>
                <div>
                    <h1>Planmonitor Wonen</h1>
                    <ul>
                        <li>
                            <a href="<stripes:url value="/Search.action" />" class="btn${pageTitle=='Zoeken' ? ' disabled' : ''}">Zoeken</a>
                        </li>
                        <li>
                            <c:if test="${actionBean.isGemeente == true}">
                                <a href="<stripes:url value="/Edit.action?add=true" />" class="btn${pageTitle=='Bnewerken' ? ' disabled' : ''}">Nieuw plan</a>
                            </c:if>
                        </li>
                        <li>
                            <a href="<stripes:url value="/ImportPlan.action" />" class="btn${pageTitle=='Importeren' ? ' disabled' : ''}">Importeren</a>
                        </li>
                        <li>
                            <a href="<stripes:url value="/Export.action" />" class="btn${pageTitle=='Exporteren' ? ' disabled' : ''}">Export overzicht</a>
                        </li>
                        <li>
                            <a href="<stripes:url value="/Downloads.action" />" class="btn${pageTitle=='Downloads' ? ' disabled' : ''}">Downloads</a>
                        </li>
                    </ul>
                </div>
                <div class="pull-right">
                    <ul>
                        <li>
                            <strong><c:out value="${actionBean.naamGebruiker}"/></strong>
                        </li>
                        <c:if test="${actionBean.gebruiker.rijk == true || actionBean.isBeheerder == true || actionBean.gebruiker.provincie != null}">
                            <li><stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.BeheerActionBean">Beheer</stripes:link></li>
                        </c:if>
                        <li>
                            <stripes:link beanclass="nl.b3p.pzh.rwbp.stripes.ProfielActionBean">Profiel</stripes:link>
                        </li>
                        <li>
                            <a href="${actionBean.help}">Help</a>
                        </li>
                        <li>
                            <a href="mailto:${actionBean.mail}">Contact</a>
                        </li>
                        <li>
                            <a href="${actionBean.about}">Over</a>
                        </li>
                        <li>
                            <c:choose>
                                <c:when test="${empty actionBean.gebruiker}">
                                    <stripes:link href="/login.jsp">Inloggen</stripes:link>
                                </c:when>
                                <c:otherwise>
                                    <stripes:link href="/logout.jsp">Uitloggen</stripes:link>
                                </c:otherwise>
                            </c:choose>
                        </li>
                    </ul>
                </div>
            </header>
            <div id="content">
                <stripes:layout-component name="content"/>
            </div>
        </body>
    </html>

</stripes:layout-definition>
