/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.imagetool.Bbox;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImageUrl;
import nl.b3p.imagetool.CombineImagesHandler;
import nl.b3p.imagetool.CombineTMSUrl;
import nl.b3p.imagetool.CombineWmsUrl;
import nl.b3p.imagetool.ImageTool;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.Gebruikgegevens;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Ontwikkelaartype;
import nl.b3p.pzh.rwbp.entity.Plantype;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.Statusplanologisch;
import nl.b3p.pzh.rwbp.entity.Statusproject;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.entity.Woonmilieu;
import nl.b3p.pzh.rwbp.stripes.BouwplanUtils;
import nl.b3p.pzh.rwbp.stripes.SearchActionBean;
import nl.b3p.pzh.rwbp.stripes.SolrActionBean;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@CustomPopulationStrategy(value=BeanFirstPopulationStrategy.class)
public class EditActionBean
extends ViewerActionBean
implements ValidationErrorHandler {
    private static final Log log = LogFactory.getLog(EditActionBean.class);
    @Validate
    @ValidateNestedProperties(value={@Validate(field="id", on={"save"}), @Validate(field="naam", required=true, maxlength=255, on={"save"}), @Validate(field="referentienummer", maxlength=255, on={"save"}), @Validate(field="masterplan", maxlength=255, on={"save"}), @Validate(field="bestemmingsplannaam", maxlength=255, on={"save"}), @Validate(field="plantype", maxlength=255, required=true, on={"save"}), @Validate(field="imronummer", maxlength=255, on={"save"}), @Validate(field="ontwikkelaartype", on={"save"}), @Validate(field="statusproject", required=true, on={"save"}), @Validate(field="woonmilieu", on={"save"}), @Validate(field="woonmilieuabf14", on={"save"}), @Validate(field="statusplanologisch", required=true, on={"save"}), @Validate(field="gebruikgegevens", required=true, on={"save"}), @Validate(field="ontwikkelaar_namelijk", on={"save"}), @Validate(field="jaar_eerste_oplevering", required=true, on={"save"}), @Validate(field="jaar_laatste_oplevering", required=true, on={"save"}), @Validate(field="restcapaciteit", required=true, on={"save"}), @Validate(field="totaalcapaciteit", required=true, on={"save"}), @Validate(field="gerealiseerdecapaciteit", required=true, on={"save"}), @Validate(field="resterendesloop", on={"save"}), @Validate(field="totaalsloop", required=true, on={"save"}), @Validate(field="gerealiseerdesloop", required=true, on={"save"}), @Validate(field="koop1", on={"save"}), @Validate(field="koop2", on={"save"}), @Validate(field="koop3", on={"save"}), @Validate(field="koop4", on={"save"}), @Validate(field="koopprijsonbekend", on={"save"}), @Validate(field="kooptotaal", on={"save"}), @Validate(field="huur1", on={"save"}), @Validate(field="huur2", on={"save"}), @Validate(field="huur3", on={"save"}), @Validate(field="huur4", on={"save"}), @Validate(field="huurprijsonbekend", on={"save"}), @Validate(field="huurtotaal", on={"save"}), @Validate(field="eensgezins", on={"save"}), @Validate(field="meergezins", on={"save"}), @Validate(field="woningtypeonbekend", on={"save"}), @Validate(field="knelpunten", on={"save"}), @Validate(field="opmerkingen", on={"save"}), @Validate(field="opmerkingenprive", on={"save"}), @Validate(field="opmerkingenprovincie", on={"save"}), @Validate(field="plaatsnaam", on={"save"}), @Validate(field="detailType", on={"save"}), @Validate(field="detailTypeSloop", on={"save"}), @Validate(field="onbekendonbekend", on={"save"})})
    private Bouwplan bouwplan;
    @Validate
    private String geometry;
    private List<Plantype> plantypes = new ArrayList<Plantype>();
    private List<Woonmilieu> woonmilieus = new ArrayList<Woonmilieu>();
    private List<Ontwikkelaartype> ontwikkelaartypes = new ArrayList<Ontwikkelaartype>();
    private List<Statusplanologisch> statusplanologisch = new ArrayList<Statusplanologisch>();
    private List<Statusproject> statusprojecten = new ArrayList<Statusproject>();
    private List<Gebruikgegevens> gebruikgegevens = new ArrayList<Gebruikgegevens>();
    private String bbox;
    @Validate(on={"saveDetailData", "save"})
    private String detailData;
    @Validate(on={"save"})
    private String detailDatasloop;
    @Validate
    private String additionalVariables;
    private String variableValues;
    private String variables;
    private int beginYear;
    @Validate
    private String gemeente;
    private List<ProvincieVariable> optionalVariables = new ArrayList<ProvincieVariable>();
    private Map<String, Boolean> bpOptionalVariables = new HashMap<String, Boolean>();
    private Map<String, String> labelMap = new HashMap<String, String>();
    private String labelMapJSON;
    private boolean canEdit = false;
    @Validate
    private boolean add = false;
    @Validate
    private int width = 370;
    @Validate
    private int height = 285;
    @Validate
    private String key;
    private static LinkedHashMap<String, CombineImageSettings> imageSettings = new LinkedHashMap();

    @DefaultHandler
    public Resolution edit() {
        boolean authorized = this.isAuthorized();
        if (!authorized) {
            return new RedirectResolution(SearchActionBean.class, "close");
        }
        return new ForwardResolution("/WEB-INF/jsp/edit.jsp");
    }

    public Resolution retrieveDetailData() {
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);
            EntityManager em = Stripersist.getEntityManager();
            TypedQuery q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan", BouwplanVariable.class).setParameter("bouwplan", (Object)this.bouwplan);
            List bvs = q.getResultList();
            JSONArray bvArray = new JSONArray();
            for (BouwplanVariable bv : bvs) {
                bvArray.put((Object)bv.toJSON());
            }
            json.put("bouwplanvariables", (Object)bvArray);
            json.put("success", true);
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        catch (JSONException ex) {
            log.error((Object)"Fout met ophalen detail data: ", (Throwable)ex);
            return new ErrorResolution(500, "Fout bij ophalen detail data");
        }
    }

    public Resolution saveGeometry() {
        try {
            Polygon p;
            JSONObject json = new JSONObject();
            json.put("success", false);
            EntityManager em = Stripersist.getEntityManager();
            if (this.geometry != null && (p = this.parseGeometry(json)) != null && json.getBoolean("success")) {
                this.bouwplan.setThe_geom(p);
                em.getTransaction().commit();
                SolrActionBean.addSingleBouwplan(this.bouwplan);
            }
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        catch (JSONException ex) {
            log.error((Object)"Fout met opslaan geometrie: ", (Throwable)ex);
            return new ErrorResolution(500, "Fout met opslaan geometrie");
        }
    }

    public Resolution saveDetailData() {
        try {
            JSONObject json = new JSONObject();
            json.put("success", false);
            if (this.bouwplan == null) {
                json.put("message", (Object)"Bouwplan nog niet opgeslagen.");
                return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
            }
            EntityManager em = Stripersist.getEntityManager();
            this.saveDetailData(this.bouwplan, this.detailData, em);
            em.getTransaction().commit();
            json.put("success", true);
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        catch (JSONException ex) {
            log.error((Object)"Fout met ophalen detail data: ", (Throwable)ex);
            return new ErrorResolution(500, "Fout bij opslaan deja...tail data");
        }
    }

    public Resolution save() throws JSONException {
        JSONObject json;
        Polygon p;
        EntityManager em = Stripersist.getEntityManager();
        this.bouwplan.setDatumlaatstewijziging(new Date());
        boolean nieuw = false;
        if (this.bouwplan.getId() == null) {
            this.bouwplan.setGemeente(this.gebruiker.getGemeente());
            nieuw = true;
        } else if (this.bouwplan.getDetailType().equals("Geen detailplanning") && this.bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) {
            this.removeDetailData(this.bouwplan, em);
        } else {
            TypedQuery q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan", BouwplanVariable.class).setParameter("bouwplan", (Object)this.bouwplan);
            List bvs = q.getResultList();
            for (BouwplanVariable bv : bvs) {
                if (this.bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) {
                    bv.setSloop(null);
                    bv.setGerealiseerdesloop(null);
                }
                if (this.bouwplan.getDetailType().equals("Geen detailplanning")) {
                    bv.setGepland(null);
                    bv.setGerealiseerd(null);
                    bv.setHuur1(null);
                    bv.setHuur2(null);
                    bv.setHuur3(null);
                    bv.setHuur4(null);
                    bv.setHuuronb(null);
                    bv.setKoop1(null);
                    bv.setKoop2(null);
                    bv.setKoop3(null);
                    bv.setKoop4(null);
                    bv.setKooponb(null);
                    bv.setOnbekend(null);
                }
                em.persist((Object)bv);
            }
        }
        if (this.geometry != null && (p = this.parseGeometry(json = new JSONObject())) != null) {
            this.bouwplan.setThe_geom(p);
        }
        em.persist((Object)this.bouwplan);
        this.saveAdditionalVariables();
        if (nieuw) {
            if (!this.bouwplan.getDetailType().equals("Geen detailplanning") && !this.bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) {
                JSONArray sloop = new JSONArray(this.detailDatasloop);
                HashMap<Integer, BouwplanVariable> sloopByYear = new HashMap<Integer, BouwplanVariable>();
                for (int i = 0; i < sloop.length(); ++i) {
                    BouwplanVariable bv;
                    bv = BouwplanVariable.fromJSON(sloop.getJSONObject(i));
                    sloopByYear.put(bv.getYear(), bv);
                }
                JSONArray planning = new JSONArray(this.detailData);
                for (int i = 0; i < planning.length(); ++i) {
                    JSONObject bvJSON = planning.getJSONObject(i);
                    BouwplanVariable bv = BouwplanVariable.fromJSON(bvJSON);
                    bv.setBouwplan(this.bouwplan);
                    if (bv.getType().equals("onbekend")) {
                        BouwplanVariable sloopBV = (BouwplanVariable)sloopByYear.get(bv.getYear());
                        bv.setSloop(sloopBV.getSloop());
                        bv.setGerealiseerdesloop(sloopBV.getGerealiseerdesloop());
                    }
                    em.persist((Object)bv);
                }
                if (this.bouwplan.getDetailType().equals("uitgebreid")) {
                    BouwplanVariable onbekend = (BouwplanVariable)sloopByYear.get(-1);
                    onbekend.setBouwplan(this.bouwplan);
                    em.persist((Object)onbekend);
                }
            } else if (!this.bouwplan.getDetailType().equals("Geen detailplanning") || !this.bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) {
                if (!this.bouwplan.getDetailType().equals("Geen detailplanning")) {
                    this.saveDetailData(this.bouwplan, this.detailData, em);
                } else if (!this.bouwplan.getDetailTypeSloop().equals("Geen detailplanning voor sloop")) {
                    this.saveDetailData(this.bouwplan, this.detailDatasloop, em);
                }
            }
        }
        em.getTransaction().commit();
        SolrActionBean.addSingleBouwplan(this.bouwplan);
        this.add = false;
        return this.edit();
    }

    public Resolution deletePlan() {
        EntityManager em = Stripersist.getEntityManager();
        this.removeBouwplan(this.bouwplan, em);
        SolrActionBean.removeSingleBouwplan(this.bouwplan);
        return new RedirectResolution(SearchActionBean.class);
    }

    public void removeBouwplan(Bouwplan bp, EntityManager em) {
        em.remove((Object)bp);
        em.getTransaction().commit();
    }

    public Resolution bouwplanImage() throws Exception {
        if (this.bouwplan != null && this.bouwplan.getThe_geom() != null) {
            CombineImageSettings cis;
            if (this.key != null) {
                cis = imageSettings.get(this.key);
                cis.setWidth(Integer.valueOf(this.width));
                cis.setHeight(Integer.valueOf(this.height));
            } else {
                cis = EditActionBean.createCombineImageSettings(this.bouwplan, this.getMapserverUrl(), this.getLayers(), this.width, this.height, this.getHttpRequestParams());
            }
            return new StreamingResolution(""){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stream(HttpServletResponse response) throws IOException {
                    try (ServletOutputStream out = response.getOutputStream();){
                        CombineImagesHandler.combineImage((OutputStream)out, (CombineImageSettings)cis, (String)cis.getMimeType(), (int)10000);
                    }
                }
            };
        }
        final BufferedImage img = new BufferedImage(this.width, this.height, 3);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        return new StreamingResolution(""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stream(HttpServletResponse response) throws IOException {
                try (ServletOutputStream out = response.getOutputStream();){
                    ImageTool.writeImage((BufferedImage)img, (String)"image/png", (OutputStream)out);
                }
            }
        };
    }

    public static CombineImageSettings createCombineImageSettings(Bouwplan bouwplan, String mapUrl, String layers, int width, int height, String httpRequestParams) throws Exception {
        String bbox = BouwplanUtils.makeBboxBouwplan(bouwplan);
        if (bbox == null) {
            return null;
        }
        mapUrl = mapUrl.contains("?") ? mapUrl + "&" : mapUrl + "?";
        mapUrl = mapUrl + "layers=" + layers + "&version=1.1.1&format=image/png&srs=EPSG:28992&request=getmap&service=wms&width=" + width + "&height=" + height + "&bbox=" + bbox + "&" + httpRequestParams;
        String tms = "http://geodata.nationaalgeoregister.nl/tiles/service/tms/1.0.0/brtachtergrondkaart@EPSG:28992@png8/";
        CombineImageSettings cis = new CombineImageSettings();
        CombineTMSUrl ctu = new CombineTMSUrl();
        ctu.setServiceBbox(new Bbox("-285401.0,22598.0,595401.0,903401.0"));
        ctu.setTileWidth(Integer.valueOf(256));
        ctu.setTileHeight(Integer.valueOf(256));
        ctu.setExtension("png");
        String resolutions = "3440.64,1720.32,860.16,430.08,215.04,107.52,53.76,26.88,13.44,6.72,3.36,1.68,0.84,0.42,0.21,0.105";
        String[] tokens = resolutions.split(",");
        Double[] res = new Double[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            res[i] = new Double(tokens[i]);
        }
        ctu.setResolutions(res);
        CombineTMSUrl ciu = ctu;
        ciu.setUrl(tms);
        cis.addUrl((CombineImageUrl)ciu);
        CombineWmsUrl cmu = new CombineWmsUrl();
        cmu.setUrl(mapUrl);
        cis.addUrl((CombineImageUrl)cmu);
        cis.setBbox(bbox);
        cis.setHeight(Integer.valueOf(height));
        cis.setWidth(Integer.valueOf(width));
        cis.setSrid(Integer.valueOf(28992));
        cis.setMimeType("image/png");
        imageSettings.put("" + cis.hashCode(), cis);
        return cis;
    }

    @ValidationMethod(on={"save"})
    public void handleGeometryValidation() {
        if (this.geometry == null && this.bouwplan.getThe_geom() == null) {
            this.getContext().getValidationErrors().add("Geometrie", (ValidationError)new SimpleError("Geometrie mag niet leeg zijn. Teken een geometrie.", new Object[0]));
        }
    }

    public Resolution filterGemeentes() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        Session sess = (Session)em.getDelegate();
        Criteria criteria = sess.createCriteria(Gemeente.class);
        criteria.addOrder(Order.asc((String)"naam"));
        criteria.add(Restrictions.ilike((String)"naam", (String)this.gemeente, (MatchMode)MatchMode.ANYWHERE));
        List gemeentes = criteria.list();
        JSONArray gems = new JSONArray();
        for (Gemeente gem : gemeentes) {
            gems.put((Object)gem.getNaam());
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(gems.toString()));
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    private void createLists() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        this.plantypes = em.createQuery("from Plantype order by id").getResultList();
        this.woonmilieus = em.createQuery("from Woonmilieu order by type").getResultList();
        this.ontwikkelaartypes = em.createQuery("from Ontwikkelaartype order by id").getResultList();
        this.statusplanologisch = em.createQuery("from Statusplanologisch order by volgorde").getResultList();
        this.statusprojecten = em.createQuery("from Statusproject order by volgorde").getResultList();
        this.gebruikgegevens = em.createQuery("from Gebruikgegevens order by volgorde").getResultList();
        String id = this.context.getRequest().getParameter("bouwplan.id");
        if (id != null && !id.isEmpty()) {
            Integer idValue = Integer.parseInt(id);
            this.bouwplan = (Bouwplan)em.find(Bouwplan.class, (Object)idValue);
        }
        Calendar c = Calendar.getInstance();
        this.beginYear = c.get(1) - 2;
    }

    @DontValidate
    @After(stages={LifecycleStage.EventHandling}, on={"!bouwplanImage"})
    private void retrieveVariables() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        List vars = null;
        Gemeente gemeente = null;
        gemeente = this.bouwplan != null && this.bouwplan.getGemeente() != null ? this.bouwplan.getGemeente() : this.gebruiker.getGemeente();
        Provincie p = gemeente.getProvincie();
        vars = gemeente.getRegio() != null ? em.createQuery("select p FROM ProvincieAdditionalVariable p join p.regios r where p.label = false and r.id = :regio order by additional_variable", ProvincieAdditionalVariable.class).setParameter("regio", (Object)gemeente.getRegio().getId()).getResultList() : em.createQuery("FROM ProvincieAdditionalVariable where label = false and provincie = :provincie and usedByMunicipalities = true order by additional_variable", ProvincieAdditionalVariable.class).setParameter("provincie", (Object)p).getResultList();
        JSONArray ar = new JSONArray();
        for (ProvincieAdditionalVariable var : vars) {
            ar.put((Object)var.toJSON(gemeente));
        }
        this.variables = ar.toString();
        if (this.bouwplan != null && !this.add) {
            List values = em.createQuery("FROM BouwplanAdditionalVariable WHERE bouwplan = :bouwplan").setParameter("bouwplan", (Object)this.bouwplan).getResultList();
            JSONObject valuesObject = new JSONObject();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                BouwplanAdditionalVariable var = (BouwplanAdditionalVariable)iterator.next();
                if (var.getVariable() == null) continue;
                valuesObject.put(var.getVariable().getId().toString(), (Object)var.toJSON());
            }
            this.variableValues = valuesObject.toString();
        } else {
            this.variableValues = new JSONArray().toString();
        }
        this.optionalVariables = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie", ProvincieVariable.class).setParameter("provincie", (Object)p).getResultList();
        for (ProvincieVariable provincieVariable : this.optionalVariables) {
            this.bpOptionalVariables.put(provincieVariable.getVariable().getName(), Boolean.TRUE);
        }
        List optionalLabelVars = em.createQuery("SELECT label FROM ConfigurableVariable WHERE type = :type", String.class).setParameter("type", (Object)VariableType.LABEL).getResultList();
        List labelVars = null;
        labelVars = optionalLabelVars.size() > 0 ? em.createQuery("FROM ProvincieAdditionalVariable WHERE label = true and additional_variable in :vars and provincie = :provincie").setParameter("vars", (Object)optionalLabelVars).setParameter("provincie", (Object)p).getResultList() : new ArrayList();
        this.labelMap = new HashMap<String, String>();
        Regio regio = gemeente.getRegio();
        for (String optionalLabelVar : optionalLabelVars) {
            String value = null;
            for (ProvincieAdditionalVariable labelVar : labelVars) {
                if (!labelVar.getAdditional_variable().equals(optionalLabelVar)) continue;
                for (ProvincieAdditionalVariableValue pavv : labelVar.getValues()) {
                    if (regio == null && pavv.isUsedByMunicipalities()) {
                        value = pavv.getValue();
                    }
                    if (!pavv.getRegios().contains(gemeente.getRegio())) continue;
                    value = pavv.getValue();
                }
            }
            this.labelMap.put("" + optionalLabelVar, value != null ? value : optionalLabelVar);
        }
        this.labelMapJSON = new JSONObject(this.labelMap).toString();
        boolean bl = this.gebruiker != null ? this.gebruiker.getProvincie() == null : (this.canEdit = false);
        if (this.bouwplan != null && this.gebruiker != null) {
            boolean bl2 = this.canEdit = this.gebruiker.getGemeente() != null && this.gebruiker.getGemeente().getId() == this.bouwplan.getGemeente().getId() || this.gebruiker.getProvincie() != null && this.gebruiker.getProvincie().getId() == this.bouwplan.getGemeente().getProvincie().getId();
        }
        if (this.bouwplan != null && this.bouwplan.getThe_geom() != null) {
            this.bbox = BouwplanUtils.makeBboxBouwplan(this.bouwplan);
        } else if (this.gebruiker != null) {
            this.bbox = BouwplanUtils.makeBbox(this.gebruiker);
        }
    }

    private boolean isAuthorized() {
        boolean authorized = false;
        if (this.bouwplan != null) {
            authorized = BouwplanUtils.isAuthorized(this.bouwplan, this.gebruiker);
        } else if (this.add) {
            authorized = this.gebruiker != null ? this.gebruiker.getGemeente() != null : false;
        }
        return authorized;
    }

    private Polygon parseGeometry(JSONObject json) throws JSONException {
        Polygon p = null;
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        Geometry geom = null;
        try {
            Geometry gemeenteGeom;
            geom = wktreader.read(this.geometry);
            if (geom.getGeometryType().equalsIgnoreCase("Point")) {
                geom = geom.buffer(50.0, 4, 1);
            }
            if (!geom.within(gemeenteGeom = this.gebruiker.getGemeente().getTheGeom())) {
                json.put("message", (Object)"Geometrie niet binnen gemeente");
            }
            if (geom.getGeometryType().equalsIgnoreCase("MultiPolygon")) {
                log.error((Object)"Geometry kan niet als multipolygon worden opgeslagen");
                json.put("message", (Object)"Geometry kan niet als multipolygon worden opgeslagen");
            } else if (geom.getGeometryType().equalsIgnoreCase("Polygon")) {
                p = (Polygon)geom;
                if (!p.isValid()) {
                    log.debug((Object)"Geometry is invalide. Maak valide");
                    p = (Polygon)p.buffer(0.0);
                }
                if (!p.isValid()) {
                    json.put("message", (Object)"Geometry is invalide. Maak valide");
                } else {
                    json.put("success", true);
                }
            } else {
                log.error((Object)"Geometry moet of als polygon zijn getekend of als multipolygon.");
                json.put("message", (Object)"Geometry moet of als polygon zijn getekend of als multipolygon.");
            }
        }
        catch (ParseException e) {
            log.error((Object)"Geometry kan niet worden opgeslagen");
            json.put("message", (Object)"Geometry kan niet worden opgeslagen");
        }
        return p;
    }

    private void saveAdditionalVariables() {
        try {
            EntityManager em = Stripersist.getEntityManager();
            em.createQuery("DELETE BouwplanAdditionalVariable WHERE bouwplan = :bouwplan").setParameter("bouwplan", (Object)this.bouwplan).executeUpdate();
            JSONObject values = new JSONObject(this.additionalVariables);
            Iterator iterator = values.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                JSONObject value = values.getJSONObject(key);
                ProvincieAdditionalVariable pav = (ProvincieAdditionalVariable)em.find(ProvincieAdditionalVariable.class, (Object)value.getInt("id"));
                BouwplanAdditionalVariable bav = new BouwplanAdditionalVariable();
                bav.setBouwplan(this.bouwplan);
                bav.setVariable(pav);
                bav.setVariableValue(value.get("value").toString());
                em.persist((Object)bav);
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Cannot save additional variables", (Throwable)ex);
        }
    }

    private void removeDetailData(Bouwplan bouwplan, EntityManager em) {
        TypedQuery q = em.createQuery("FROM BouwplanVariable where bouwplan = :bouwplan", BouwplanVariable.class).setParameter("bouwplan", (Object)bouwplan);
        List bvs = q.getResultList();
        for (BouwplanVariable bv : bvs) {
            em.remove((Object)bv);
        }
    }

    private void saveDetailData(Bouwplan bouwplan, String detailData, EntityManager em) throws JSONException {
        if (detailData != null) {
            this.removeDetailData(bouwplan, em);
            JSONArray newDetailData = new JSONArray(detailData);
            for (int i = 0; i < newDetailData.length(); ++i) {
                JSONObject bv = newDetailData.getJSONObject(i);
                BouwplanVariable bouwplanVariable = BouwplanVariable.fromJSON(bv);
                bouwplanVariable.setBouwplan(bouwplan);
                em.persist((Object)bouwplanVariable);
            }
        }
    }

    public void setAdd(boolean add) {
        this.add = add;
    }

    public boolean isAdd() {
        return this.add;
    }

    public Bouwplan getBouwplan() {
        return this.bouwplan;
    }

    public void setBouwplan(Bouwplan bouwplan) {
        this.bouwplan = bouwplan;
    }

    public List<Plantype> getPlantypes() {
        return this.plantypes;
    }

    public void setPlantypes(List<Plantype> plantypes) {
        this.plantypes = plantypes;
    }

    public List<Ontwikkelaartype> getOntwikkelaartypes() {
        return this.ontwikkelaartypes;
    }

    public void setOntwikkelaartypes(List<Ontwikkelaartype> ontwikkelaartypes) {
        this.ontwikkelaartypes = ontwikkelaartypes;
    }

    public List<Statusplanologisch> getStatusplanologisch() {
        return this.statusplanologisch;
    }

    public void setStatusplanologisch(List<Statusplanologisch> statusplanologisch) {
        this.statusplanologisch = statusplanologisch;
    }

    public List<Statusproject> getStatusprojecten() {
        return this.statusprojecten;
    }

    public void setStatusprojecten(List<Statusproject> statusprojecten) {
        this.statusprojecten = statusprojecten;
    }

    public String getDetailData() {
        return this.detailData;
    }

    public void setDetailData(String detailData) {
        this.detailData = detailData;
    }

    public List<Woonmilieu> getWoonmilieus() {
        return this.woonmilieus;
    }

    public void setWoonmilieus(List<Woonmilieu> woonmilieus) {
        this.woonmilieus = woonmilieus;
    }

    public String getBbox() {
        return this.bbox;
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    public String getGeometry() {
        return this.geometry;
    }

    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    public String getVariables() {
        return this.variables;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public String getAdditionalVariables() {
        return this.additionalVariables;
    }

    public void setAdditionalVariables(String additionalVariables) {
        this.additionalVariables = additionalVariables;
    }

    public String getVariableValues() {
        return this.variableValues;
    }

    public void setVariableValues(String variableValues) {
        this.variableValues = variableValues;
    }

    public int getBeginYear() {
        return this.beginYear;
    }

    public void setBeginYear(int beginYear) {
        this.beginYear = beginYear;
    }

    public List<Gebruikgegevens> getGebruikgegevens() {
        return this.gebruikgegevens;
    }

    public void setGebruikgegevens(List<Gebruikgegevens> gebruikgegevens) {
        this.gebruikgegevens = gebruikgegevens;
    }

    public String getGemeente() {
        return this.gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public Map<String, Boolean> getBpOptionalVariables() {
        return this.bpOptionalVariables;
    }

    public void setBpOptionalVariables(Map<String, Boolean> bpOptionalVariables) {
        this.bpOptionalVariables = bpOptionalVariables;
    }

    public Map<String, String> getLabelMap() {
        return this.labelMap;
    }

    public void setLabelMap(Map<String, String> labelMap) {
        this.labelMap = labelMap;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLabelMapJSON() {
        return this.labelMapJSON;
    }

    public void setLabelMapJSON(String labelMapJSON) {
        this.labelMapJSON = labelMapJSON;
    }

    public String getDetailDatasloop() {
        return this.detailDatasloop;
    }

    public void setDetailDatasloop(String detailDatasloop) {
        this.detailDatasloop = detailDatasloop;
    }

    public Resolution handleValidationErrors(ValidationErrors ve) throws Exception {
        if (this.bouwplan != null && this.bouwplan.getGemeente() == null && this.gebruiker != null) {
            this.bouwplan.setGemeente(this.gebruiker.getGemeente());
        }
        this.retrieveVariables();
        return null;
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

