-- View: extern_volledig_basis

 DROP VIEW extern_volledig_basis cascade;

CREATE OR REPLACE VIEW extern_volledig_basis AS 
 SELECT b.the_geom,
    b.id,
    b.datumlaatstewijziging,
    b.plan_identificatie AS planidentificatie,
    b.aanmaakdatum,
    b.naam,
    gem.naam AS gemeente,
    b.plaatsnaam,
    r.naam AS regio,
    b.referentienummer,
    b.bestemmingsplannaam,
    b.imronummer,
    b.masterplan,
    ot.type AS opdrachtg_type,
    b.ontwikkelaar_namelijk AS opdrachtge_namelijk,
    b.knelpunten,
    g.naam AS gebruikgegevens,
    sp.type AS status_plan,
    stp.type AS status_proj,
    b.jaar_eerste_oplevering,
    b.jaar_laatste_oplevering,
    b.totaalcapaciteit,
    b.gerealiseerdecapaciteit AS gereal_cap,
    b.restcapaciteit,
    b.resterendesloop AS rest_sloop,
    b.totaalsloop AS totaal_sloop,
    b.gerealiseerdesloop AS gerealiseerde_sloop,
    b.meergezins,
    b.eensgezins,
    b.woningtypeonbekend AS onbekend,
    b.huur1,
    b.huur2,
    b.huur3,
    b.huur4,
    b.huurprijsonbekend,
    b.huurtotaal,
    b.koop1,
    b.koop2,
    b.koop3,
    b.koop4,
    b.kooptotaal,
    b.koopprijsonbekend,
    b.detail_type,
    b.detail_type_sloop,
    p.type AS plantype,
    w.type AS woonmilieu_abf6,
    b.woonmilieuabf14,
    gem.provincie,
    geb.fullname as gebruiker
   FROM bouwplan b
     LEFT JOIN ontwikkelaartype ot ON b.ontwikkelaartypeid = ot.id
     LEFT JOIN plantype p ON b.plantypeid = p.id
     LEFT JOIN woonmilieu w ON b.woonmilieuid = w.id
     LEFT JOIN gebruikgegevens g ON b.gebruikgegevensid = g.id
     LEFT JOIN gemeente gem ON b.gemeenteid = gem.id
     LEFT JOIN regio r ON r.id = gem.regioid
     JOIN statusplanologisch sp ON b.statusplanologischid = sp.id
     JOIN statusproject stp ON stp.id = b.statusprojectid
     left join gebruiker geb on b.gebruikerid = geb.id;

ALTER TABLE extern_volledig_basis
  OWNER TO planmonitor;

GRANT ALL ON TABLE extern_volledig_basis TO planmonitor;

GRANT usage ON schema data TO fryslan;
GRANT usage ON schema data TO zuidholland;
GRANT usage ON schema data TO overijssel;


create view extern_fryslan_volledig as
    select * from extern_volledig_basis where provincie = 4;
    alter table extern_fryslan_volledig owner to planmonitor;


create view extern_overijssel_volledig as
    select * from  extern_volledig_basis where provincie = 6;
    alter table extern_overijssel_volledig owner to planmonitor;


create view extern_zuidholland_volledig as
    select * from  extern_volledig_basis where provincie = 1;
    alter table extern_zuidholland_volledig owner to planmonitor;


GRANT SELECT ON TABLE extern_fryslan_volledig TO fryslan;
GRANT SELECT ON TABLE extern_overijssel_volledig TO overijssel;
GRANT SELECT ON TABLE extern_zuidholland_volledig TO zuidholland;




CREATE OR REPLACE VIEW extern_eenvouding_basis AS 
 SELECT b.the_geom,
    b.id,
    b.datumlaatstewijziging,
    b.aanmaakdatum,
    b.plan_identificatie AS planidentificatie,
    b.naam AS plannaam,
    g.naam AS gemeente,
    b.plaatsnaam,
    r.naam AS regio,
    b.referentienummer,
    b.bestemmingsplannaam,
    b.imronummer,
    b.masterplan,
    o.type AS opdr_type,
    b.ontwikkelaar_namelijk AS opdr_nml,
    gg.naam AS gebruikgegevens,
    p.type AS plantype,
    s.type AS status_plan,
    sp.type AS status_proj,
    b.knelpunten,
    b.jaar_eerste_oplevering,
    b.jaar_laatste_oplevering,
    b.totaalcapaciteit AS totaalcap,
    b.gerealiseerdecapaciteit AS gereal_cap,
    b.restcapaciteit AS restcap,
    b.resterendesloop AS rest_sloop,
    b.totaalsloop AS totaal_slp,
    b.gerealiseerdesloop AS gereal_slp,
    b.detail_type AS detailcap,
    b.detail_type_sloop AS detailslp,
    b.woonmilieuabf14 AS woonmabf14,
    wm.type AS woonmabf6,
    b.meergezins,
    b.eensgezins AS eengezins,
    b.woningtypeonbekend AS onbekend,
    b.huur1,
    b.huur2,
    b.huur3,
    b.huur4,
    b.huurprijsonbekend,
    b.huurtotaal,
    b.koop1,
    b.koop2,
    b.koop3,
    b.koop4,
    b.kooptotaal,
    b.koopprijsonbekend,
    b.totaalcapaciteit - (b.huurtotaal + b.kooptotaal) AS onb_kp_hr,
    g.provincie,
    geb.fullname as gebruiker
   FROM bouwplan b
     JOIN gemeente g ON b.gemeenteid = g.id
     JOIN gebruikgegevens gg ON gg.id = b.gebruikgegevensid
     JOIN regio r ON g.regioid = r.id
     LEFT JOIN ontwikkelaartype o ON b.ontwikkelaartypeid = o.id
     LEFT JOIN woonmilieu wm ON wm.id = b.woonmilieuid
     LEFT JOIN plantype p ON b.plantypeid = p.id
     JOIN statusplanologisch s ON b.statusplanologischid = s.id
     JOIN statusproject sp ON b.statusprojectid = sp.id
     left join gebruiker geb on b.gebruikerid = geb.id;

ALTER TABLE extern_eenvouding_basis
  OWNER TO planmonitor;



create view extern_fryslan_eenvoudig as
    select * from extern_eenvouding_basis where provincie = 4;
    alter table extern_fryslan_eenvoudig owner to planmonitor;


create view extern_overijssel_eenvoudig as
    select * from  extern_eenvouding_basis where provincie = 6;
    alter table extern_overijssel_eenvoudig owner to planmonitor;


create view extern_zuidholland_eenvoudig as
    select * from  extern_eenvouding_basis where provincie = 1;
    alter table extern_zuidholland_eenvoudig owner to planmonitor;


GRANT SELECT ON TABLE extern_fryslan_eenvoudig TO fryslan;
GRANT SELECT ON TABLE extern_overijssel_eenvoudig TO overijssel;
GRANT SELECT ON TABLE extern_zuidholland_eenvoudig TO zuidholland;
