package nl.b3p.pzh.rwbp.entity;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Jytte
 */

@Entity
public class Bouwplanopmerking {

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;

    @ManyToOne (targetEntity=nl.b3p.pzh.rwbp.entity.Bouwplan.class)
    @JoinColumn(name="bouwplanid")
    private Bouwplan bouwplan;

    @ManyToOne (targetEntity=nl.b3p.pzh.rwbp.entity.Gebruiker.class)
    @JoinColumn(name="gebruikerid")
    private Gebruiker gebruiker;

    @ManyToOne (targetEntity=nl.b3p.pzh.rwbp.entity.Accesslevel.class)
    @JoinColumn(name="accesslevelid")
    private Accesslevel accesslevel;

    @Temporal(TemporalType.TIMESTAMP)
    private Date tijd;

    private String opmerking;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getOpmerking() {
        return opmerking;
    }

    public void setOpmerking(String opmerking) {
        this.opmerking = opmerking;
    }

    public Date getTijd() {
        return tijd;
    }

    public void setTijd(Date tijd) {
        this.tijd = tijd;
    }

    public Accesslevel getAccesslevel() {
        return accesslevel;
    }

    public void setAccesslevel(Accesslevel accesslevel) {
        this.accesslevel = accesslevel;
    }

    public Bouwplan getBouwplan() {
        return bouwplan;
    }

    public void setBouwplan(Bouwplan bouwplan) {
        this.bouwplan = bouwplan;
    }

    public Gebruiker getGebruiker() {
        return gebruiker;
    }

    public void setGebruiker(Gebruiker gebruiker) {
        this.gebruiker = gebruiker;
    }

    
}
