package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
@StrictBinding
@CustomPopulationStrategy(BeanFirstPopulationStrategy.class)
public class AdminServicesActionBean extends ViewerActionBean implements ValidationErrorHandler{

    private static final Log log = LogFactory.getLog(AdminServicesActionBean.class);
    private final String JSP = "/WEB-INF/jsp/admin/services.jsp";
    private List<ProvincieService> services = new ArrayList<ProvincieService>();
    @ValidateNestedProperties({
        @Validate(field = "url", mask="((([A-Za-z]{3,9}:(?:\\/\\/)?)(?:[-;:&=\\+\\$,\\w]+@)?[A-Za-z0-9.-]+|(?:www.|[-;:&=\\+\\$,\\w]+@)[A-Za-z0-9.-]+)((?:\\/[\\+~%\\/.\\w-_]*)?\\??(?:[-\\+=&;%@.\\w_]*)#?(?:[\\w]*))?)/?", required = true, maxlength = 255, on = {"save"}),
        @Validate(field = "layers", label="Lagen", required = true, maxlength = 255, on = {"save"}),
        @Validate(field = "name", maxlength = 255),
        @Validate(field = "defaultOn", on = {"save"})
    })
    private ProvincieService service;
    @Validate
    private Integer serviceid;

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution selectService() {
        return new ForwardResolution(JSP);
    }

    public Resolution save() {
        EntityManager em = Stripersist.getEntityManager();
        Gebruiker g = getGebruiker();
        Provincie provincie = g.getProvincie();
        service.setProvincie(provincie);
        em.persist(service);
        em.getTransaction().commit();
        serviceid = null;
        service = null;
        context.getMessages().add(new SimpleMessage("Service opgeslagen"));
        return new ForwardResolution(JSP);
    }
    
    public Resolution delete (){
        EntityManager em = Stripersist.getEntityManager();
        em.remove(service);
        em.getTransaction().commit();
        service=null;
        context.getMessages().add(new SimpleMessage("Service verwijderd"));
        return new ForwardResolution(JSP);
    }

    @Before(stages = LifecycleStage.BindingAndValidation)
    private void loadEntity() {
        EntityManager em = Stripersist.getEntityManager();
        Integer id = null;
        try {
            id = Integer.parseInt(context.getRequest().getParameter("serviceid"));
        } catch (NumberFormatException nfe) {
        }
        if(id != null) {
            serviceid = id;
            service = (ProvincieService)em.find(ProvincieService.class, serviceid);
        }
    }

    @After(stages = LifecycleStage.EventHandling)
    private void createLists(){
        EntityManager em = Stripersist.getEntityManager();
        Provincie provincie = gebruiker.getProvincie();
        services = em.createQuery("FROM ProvincieService WHERE provincie = :provincie ORDER BY id").setParameter("provincie", provincie).getResultList();
    }
    // <editor-fold defaultstate="collapsed" desc="getters en setters">

    public List<ProvincieService> getServices() {
        return services;
    }

    public void setServices(List<ProvincieService> services) {
        this.services = services;
    }

    public Integer getServiceid() {
        return serviceid;
    }

    public void setServiceid(Integer serviceid) {
        this.serviceid = serviceid;
    }

    public ProvincieService getService() {
        return service;
    }

    public void setService(ProvincieService service) {
        this.service = service;
    }
    // </editor-fold>

    public Resolution handleValidationErrors(ValidationErrors errors) throws Exception {
        createLists();
        return null;
    }

}
