package nl.b3p.pzh.rwbp.stripes;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import nl.b3p.pzh.rwbp.SearchQuery;
import nl.b3p.pzh.rwbp.SolrInitializer;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gebruiker;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.stripesstuff.stripersist.Stripersist;

/**
 *
 * @author Jytte
 */
public class BouwplanUtils {
    
    private static final Log log = LogFactory.getLog(BouwplanUtils.class);
    /* Voor rechten op plannen */

    public static final int OPENBAAR = 1;
    public static final int AFGESCHERMD = 2;
    public static final int PRIVE = 3;
    public static final int RIJK = 4;

    /* Voor aantallen tab */
    //---------- HUUR -----------
    //sociaal 1
    public static final int HUURGOEDKOOPEENSGEZINS = 3;
    public static final int HUURGOEDKOOPMEERGEZINS = 6;
    public static final int HUURGOEDKOOPONBEKEND = 9;
    //sociaal 2
    public static final int HUURSOCIAALEENSGEZINS = 4;
    public static final int HUURSOCIAALMEERGEZINS = 7;
    public static final int HUURSOCIAALONBEKEND = 10;
    //sociaal 3
    public static final int HUURSOCIAAL3EENSGEZINS = 34;
    public static final int HUURSOCIAAL3MEERGEZINS = 35;
    public static final int HUURSOCIAAL3ONBEKEND = 36;
    //sociaal 4
    public static final int HUURSOCIAAL4EENSGEZINS = 37;
    public static final int HUURSOCIAAL4MEERGEZINS = 38;
    public static final int HUURSOCIAAL4ONBEKEND = 39;
    //markt1
    public static final int HUURMARKTEENSGEZINS = 5;
    public static final int HUURMARKTMEERGEZINS = 8;
    public static final int HUURMARKTONBEKEND = 11;
    //markt 2
    public static final int HUURMARKT2EENSGEZINS = 31;
    public static final int HUURMARKT2MEERGEZINS = 32;
    public static final int HUURMARKT2ONBEKEND = 33;
    //onbekend
    public static final int HUURONBEKENDEENSGEZINS = 21;
    public static final int HUURONBEKENDMEERGEZINS = 22;
    public static final int HUURONBEKENDONBEKEND = 23;
    //---------- KOOP -----------
    //sociaal 1
    public static final int KOOPSOCIAALEENSGEZINS = 12;
    public static final int KOOPSOCIAALMEERGEZINS = 14;
    public static final int KOOPSOCIAALONBEKEND = 16;
    //martk1
    public static final int KOOPMARKTEENSGEZINS = 13;
    public static final int KOOPMARKTMEERGEZINS = 15;
    public static final int KOOPMARKTONBEKEND = 17;
    //markt 2
    public static final int KOOPMARKT2EENSGEZINS = 28;
    public static final int KOOPMARKT2MEERGEZINS = 29;
    public static final int KOOPMARKT2ONBEKEND = 30;
    // markt 3
    public static final int KOOPMARKT3EENSGEZINS = 42;
    public static final int KOOPMARKT3MEERGEZINS = 44;
    public static final int KOOPMARKT3ONBEKEND = 46;
    // markt 4
    public static final int KOOPMARKT4EENSGEZINS = 43;
    public static final int KOOPMARKT4MEERGEZINS = 45;
    public static final int KOOPMARKT4ONBEKEND = 47;
    //onbekend
    public static final int KOOPONBEKENDEENSGEZINS = 24;
    public static final int KOOPONBEKENDMEERGEZINS = 25;
    public static final int KOOPONBEKENDONBEKEND = 26;
    public static final int GEREALISEERD = 27;
    public static final int ONBEKENDONBEKEND = 18;
    public static final int ONBEKENDEENSGEZINS = 40;
    public static final int ONBEKENDMEERGEZINS = 41;
    public static final int NIEUWBOUW = 1;
    public static final int SLOOP = 2;
    public static final int TEMPORARY_GEOMETRY_THRESHOLD = 5;


    public static List<Bouwplan> getBouwplansFromSearch(SearchQuery sq){
        List<Bouwplan> bouwplannen = new ArrayList<Bouwplan>();
        return bouwplannen;
    }

    public static List<Integer> getAllIdsFromQuery(SearchQuery sq) throws SolrServerException {
        SolrQuery query = sq.toQueryAll();
        SolrDocumentList list = getDocumentList(query);
        return getIdsFromSolrDoc(list);
    }

    public static List<Integer> getAllIdsFromQuery(SearchQuery sq,int max) throws SolrServerException {
        SolrQuery query = sq.toQueryAll(max);
        SolrDocumentList list = getDocumentList(query);
        return getIdsFromSolrDoc(list);
    }

    public static SolrDocumentList getDocumentList(SolrQuery q) throws SolrServerException{
        SolrServer server = SolrInitializer.getServerInstance();

        QueryResponse rsp = server.query(q);
        SolrDocumentList list = rsp.getResults();
        return list;
    }

    public static QueryResponse getResponse(SolrQuery q) throws SolrServerException{
        SolrServer server = SolrInitializer.getServerInstance();

        QueryResponse rsp = server.query(q);
        return rsp;
    }

    public static List<Integer> getIdsFromSolrDoc(SolrDocumentList list){
        List<Integer> ids = new ArrayList<Integer>();
        for (SolrDocument doc : list) {
            String id = (String) doc.get("id");
            ids.add(new Integer(id));
        }
        return ids;
    }

    public static boolean isAuthorized(Bouwplan bouwplan, Gebruiker gebruiker){
        boolean authorized = false;
        if(bouwplan != null){
            switch(bouwplan.getGebruikgegevens().getId()){
                case 1://openbaar
                    authorized = true;
                    break;
                case 2: // Gemeente, eigen regio en eigen provincie
                    if(gebruiker != null ){
                        if(gebruiker.getGemeente() != null){
                            authorized =  gebruiker.getGemeente().getId() == bouwplan.getGemeente().getId();
                        }else if( gebruiker.getProvincie() != null){
                            authorized = gebruiker.getProvincie().getId().equals(bouwplan.getGemeente().getProvincie().getId());
                        }else if( gebruiker.getRegio()!= null){
                            authorized = gebruiker.getRegio().getId() == bouwplan.getGemeente().getRegio().getId() ;
                        }
                    }
                    break;
                case 3://Alleen gemeente
                    authorized =  gebruiker.getGemeente().getId() == bouwplan.getGemeente().getId();
                    break;
                case 4: // Alle ingelogde gebruikers
                    authorized = gebruiker != null;
                    break;
                case 5: // gemeente, eigen regio
                    if(gebruiker != null ){
                        if(gebruiker.getGemeente() != null){
                            authorized =  gebruiker.getGemeente().getId() == bouwplan.getGemeente().getId();
                        }else if( gebruiker.getRegio()!= null){
                            authorized = gebruiker.getRegio().getId() == bouwplan.getGemeente().getRegio().getId() ;
                        }
                    }
                    break;
            }
        }
        return authorized;
    }

    public static String makeBbox(Gebruiker gebruiker) {
        Geometry geom = null;
        if (gebruiker.getGemeente() != null) {
            Gemeente userGemeente = gebruiker.getGemeente();
            geom = userGemeente.getTheGeom();
        } else if (gebruiker.getRegio() != null) {
            geom = gebruiker.getRegio().getTheGeom();
        } else if (gebruiker.getProvincie() != null) {
            geom = gebruiker.getProvincie().getTheGeom();
        }else if(gebruiker.isRijk()){
            try {            
                WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
                geom = wktreader.read("POLYGON ((12000 304000,280000 304000,280000 620000,12000 620000,12000 304000));"); // Heel Nederland
            } catch (ParseException ex) {
                log.error("Could not parse geometry of The Netherlands:",ex);
            }
        }
        if (geom != null) {
            Envelope env = geom.getEnvelopeInternal();
            double x = -10;
            double y = 0;

            StringBuilder sb = new StringBuilder();
            sb.append(env.getMinX() - x);
            sb.append(",");
            sb.append(env.getMinY() - y);
            sb.append(",");
            sb.append(env.getMaxX() + x);
            sb.append(",");
            sb.append(env.getMaxY() + y);
            return sb.toString();
        }
        return null;
    }

    public static String makeBboxBouwplan(Bouwplan bouwplan) {
        Geometry geom = bouwplan.getThe_geom();

        if (geom != null) {
            Envelope env = null;
            if (geom.getArea() > TEMPORARY_GEOMETRY_THRESHOLD) {
                env = geom.getEnvelopeInternal();
            } else {
                Geometry bufferedGeom = geom.buffer(100);
                env = bufferedGeom.getEnvelopeInternal();
            }

            double x = env.getMaxX() - env.getMinX();
            double y = env.getMaxY() - env.getMinY();

            StringBuilder sb = new StringBuilder();
            sb.append(env.getMinX() - x);
            sb.append(",");
            sb.append(env.getMinY() - y);
            sb.append(",");
            sb.append(env.getMaxX() + x);
            sb.append(",");
            sb.append(env.getMaxY() + y);
            return sb.toString();
        }
        return null;
    }
}
