/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.export.ExportConfigServlet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author Meine Toonen meinetoonen@b3partners.nl
 */
public class DownloadsActionBean extends ViewerActionBean {

    private static final Log log = LogFactory.getLog(DownloadsActionBean.class);

    private final String JSP = "/WEB-INF/jsp/downloads.jsp";

    private List<String> reports = new ArrayList<String>();

    @Validate
    private String reportName;


    // <editor-fold defaultstate="collapsed" desc="Getters und setters">
    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public List<String> getReports() {
        return reports;
    }

    public void setReports(List<String> reports) {
        this.reports = reports;
    }
    
    // </editor-fold>

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution(JSP);
    }

    public Resolution download() throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        String location = ExportConfigServlet.getDownloadLocation();
        String government = getGovernmentType();
        String governmentname = getGovernmentName();

        String reportType = reportName.substring(0, reportName.indexOf(".") );
        String extensie = reportName.substring(reportName.indexOf("."));
        String fileName = governmentname + "_" + reportType + extensie;
        File parentLocation = new File(location, government);
        File typeLocation = new File( parentLocation, reportType);
        final File report = new File(typeLocation, fileName);
        String filenameInclDate = reportType + "(" + sdf.format(new Date(report.lastModified())) + ")" + extensie;
        if ( report.exists()) {
            
            String contenttype = Files.probeContentType(report.toPath());
            
            return new StreamingResolution(contenttype) {
                @Override
                public void stream(HttpServletResponse response) throws Exception {
                    FileInputStream fis = new FileInputStream(report);

                    IOUtils.copy(fis, response.getOutputStream());
                }
            }.setAttachment(true).setFilename(filenameInclDate);
        } else {
            context.getValidationErrors().add("Bestand", new SimpleError("Bestand niet gevonden."));
            log.error("Bestand geprobeerd te downloaden, wat niet bestaat. Bestand: " + report.getAbsolutePath() + " - " + governmentname + " for user: " + ( gebruiker != null ?gebruiker.getUsername() : " niet ingelogd ") + "uit " + governmentname);
            return new ForwardResolution(JSP);
        }
    }

    @Before
    private void generateReportList() {
        if (gebruiker != null) {
            String location = ExportConfigServlet.getDownloadLocation();

            String government = getGovernmentType();
            String governmentname = getGovernmentName();
            File dir = new File(location, government);
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        addReportsForGovernmentName(file, governmentname, reports);
                    }
                }
            }
        }
    }
    
    private String getGovernmentType() {
        String government = null;
        if (gebruiker.getGemeente() != null) {
            government = "Gemeenten";
        } else if (gebruiker.getRegio() != null) {
            government = "Regios";
        } else if (gebruiker.getProvincie() != null) {
            government = "Provincies";
        } else if (gebruiker.isRijk()) {
            government = "Rijk";
        }
        return government;
    }

    private String getGovernmentName() {
        String governmentname = null;
        if(gebruiker == null){
            return null;
        }
        if (gebruiker.getGemeente() != null) {
            governmentname = gebruiker.getGemeente().getNaam();
        } else if (gebruiker.getRegio() != null) {
            governmentname = gebruiker.getRegio().getNaam();
        } else if (gebruiker.getProvincie() != null) {
            governmentname = gebruiker.getProvincie().getNaam();
        } else if (gebruiker.isRijk()) {
            governmentname = "Rijk";
        }
        return governmentname;
    }

    /**
     * Check if a file exists in the given directory which contains the given
     * governmentname in the filename. Returns null if no file is found, returns
     * the filename when found.
     *
     * @param dir The directory in which the file can reside
     * @param governmentName The governmentname that should be checked
     * @return The filename of the found report. Null if not found.
     */
    private void addReportsForGovernmentName(File dir, String governmentName, List<String> reports ) {
        if (governmentName != null) {
            String[] files = dir.list();
            for (String file : files) {
                if (file.substring(0, file.indexOf("_")).equals(governmentName)) {
                    reports.add(dir.getName() + file.substring(file.indexOf(".")));
                }
            }
        }
    }

}
