/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class SolrInitializer
implements ServletContextListener {
    private static SolrServer server;
    private static final Log log;
    private ServletContext context;
    private static final String SOLR_CORE_NAME = "planmonitor";
    private final String SOLR_URL = "planmonitor.solr.url";
    private String solrUrl;

    public void contextInitialized(ServletContextEvent sce) {
        log.debug((Object)"SolrInitializer initializing");
        this.context = sce.getServletContext();
        this.init();
        this.inializeSolr();
    }

    private void inializeSolr() {
        log.debug((Object)"Initialize the Solr Server instance");
        server = new HttpSolrServer(this.solrUrl + SOLR_CORE_NAME);
    }

    public static SolrServer getServerInstance() {
        return server;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (server != null) {
            server.shutdown();
            log.debug((Object)"SolrInitializer destroyed");
        }
    }

    private void init() {
        this.solrUrl = this.context.getInitParameter("planmonitor.solr.url");
    }

    static {
        log = LogFactory.getLog(SolrInitializer.class);
    }
}

