/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.tag.BeanFirstPopulationStrategy;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.commons.stripes.CustomPopulationStrategy;
import nl.b3p.pzh.rwbp.entity.ConfigurableVariable;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieVariable;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
@CustomPopulationStrategy(value=BeanFirstPopulationStrategy.class)
public class AdminSearchActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(AdminSearchActionBean.class);
    private final String JSP = "/WEB-INF/jsp/admin/search.jsp";
    private List<ConfigurableVariable> vars = new ArrayList();
    @Validate
    private Integer[] savedFacetFields = new Integer[0];

    @DefaultHandler
    public Resolution view() {
        return new ForwardResolution("/WEB-INF/jsp/admin/search.jsp");
    }

    public Resolution save() {
        Provincie p = this.gebruiker.resolveProvincie();
        EntityManager em = Stripersist.getEntityManager();
        List varsToBeRemoved = em.createQuery("FROM ConfigurableVariable WHERE type = :search").setParameter("search", (Object)VariableType.SEARCH).getResultList();
        if (!varsToBeRemoved.isEmpty()) {
            List optionalProvincieVars = em.createQuery("FROM ProvincieVariable WHERE provincie = :provincie and variable in :vars").setParameter("provincie", (Object)p).setParameter("vars", (Object)varsToBeRemoved).getResultList();
            for (ProvincieVariable provVar : optionalProvincieVars) {
                em.remove((Object)provVar);
            }
        }
        if (this.getContext().getRequest().getParameterValues("savedFacetFields") != null) {
            for (int i = 0; i < this.savedFacetFields.length; ++i) {
                Integer facetVar = this.savedFacetFields[i];
                ConfigurableVariable var = (ConfigurableVariable)em.find(ConfigurableVariable.class, (Object)facetVar);
                ProvincieVariable provVar = new ProvincieVariable();
                provVar.setProvincie(p);
                provVar.setVariable(var);
                em.persist((Object)provVar);
            }
        }
        em.getTransaction().commit();
        this.createList();
        return new ForwardResolution("/WEB-INF/jsp/admin/search.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    private void createList() {
        EntityManager em = Stripersist.getEntityManager();
        Provincie p = this.gebruiker.getProvincie();
        this.vars = em.createQuery("FROM ConfigurableVariable WHERE type = :type").setParameter("type", (Object)VariableType.SEARCH).getResultList();
        List numVars = em.createQuery("select variable.id FROM ProvincieVariable WHERE variable in :vars and provincie = :provincie").setParameter("vars", (Object)this.vars).setParameter("provincie", (Object)p).getResultList();
        this.savedFacetFields = numVars.toArray(new Integer[numVars.size()]);
    }

    public List<ConfigurableVariable> getVars() {
        return this.vars;
    }

    public void setVars(List<ConfigurableVariable> vars) {
        this.vars = vars;
    }

    public Integer[] getSavedFacetFields() {
        return this.savedFacetFields;
    }

    public void setSavedFacetFields(Integer[] savedFacetFields) {
        this.savedFacetFields = savedFacetFields;
    }
}

