-- View: gepland_view


 DROP VIEW volledig_opmerking_view;
 DROP VIEW rapportage_planninghov_view;
 DROP VIEW rapportage_planningperperiode_view;
 DROP VIEW rapportage_pertype_view;
 DROP VIEW volledig_overzicht_view;
 DROP VIEW volledig_extravelden_view;
 
 DROP VIEW extragepland_view;
 
 DROP VIEW extragerealiseerd_view;
 DROP VIEW planningperperiode_overzicht_view;
 DROP VIEW planningperperiode_overzicht_shape_view;
 DROP VIEW pertype_overzicht_view;
 DROP VIEW pertype_overzicht_shape_view;
 DROP VIEW volledig_overzicht_shape_view;
 DROP VIEW status_view;
 DROP VIEW volledig_aantal_view_incl_gerealiseerd;
 DROP VIEW gepland_view;
DROP VIEW planningaantal_per_soort_per_periode_per_bouwplan;
DROP VIEW volledig_totaal_uitgebreid_view;
 DROP VIEW eenvoudig_overzicht_shape_view;

 -- View: planningaantal_per_soort_per_periode_per_bouwplan

-- DROP VIEW planningaantal_per_soort_per_periode_per_bouwplan;

CREATE OR REPLACE VIEW planningaantal_per_soort_per_periode_per_bouwplan AS 
 SELECT b.id AS bouwplanid, p.id AS periodeid, p.omschrijving AS periodeomschrijving, fmt.factsoortid, fmt.planningaantal
   FROM bouwplan b, periode p, factmetperiode fmt
  WHERE fmt.bouwplanid = b.id AND fmt.periodeid = p.id AND b.the_geom IS NOT NULL
  ORDER BY b.id, p.id, p.omschrijving, fmt.factsoortid;



CREATE OR REPLACE VIEW gepland_view AS 
 SELECT p.bouwplanid AS id, p.periodeid, p.periodeomschrijving AS omschrijving, sum(
        CASE
            WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 AND p.factsoortid <> 27 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_t, COALESCE(max(
        CASE
            WHEN p.factsoortid = 3 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 4 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 34 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_s3, COALESCE(COALESCE(max(
        CASE
            WHEN p.factsoortid = 37 THEN p.planningaantal
            ELSE NULL::integer
        END), 0), 0) AS p_h_eg_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 5 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 31 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 21 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 6 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 7 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 35 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 38 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 8 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 32 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 22 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 9 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 10 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 36 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 39 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 11 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 33 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 23 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 12 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 13 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 28 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 42 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 43 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 24 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 14 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 15 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 29 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 44 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 45 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m4,COALESCE(max(
        CASE
            WHEN p.factsoortid = 25 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 16 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 17 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 30 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 46 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 47 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m4,COALESCE(max(
        CASE
            WHEN p.factsoortid = 26 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 40 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_eg, COALESCE(max(
        CASE
            WHEN p.factsoortid = 41 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_mg, COALESCE(max(
        CASE
            WHEN p.factsoortid = 18 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 2 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 27 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS gerealiseerd
   FROM planningaantal_per_soort_per_periode_per_bouwplan p
  GROUP BY p.bouwplanid, p.periodeomschrijving, p.periodeid
  ORDER BY p.bouwplanid, p.periodeomschrijving;

-- View: gerealiseerd_view


CREATE OR REPLACE VIEW volledig_aantal_view_incl_gerealiseerd AS 
 SELECT gep.id, gep.periodeid, gep.omschrijving, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_t
            ELSE 0::bigint
        END AS p_t, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_eg_g
            ELSE 0
        END AS p_h_eg_s1, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_eg_s
            ELSE 0
        END AS p_h_eg_s2, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_eg_s3
            ELSE 0
        END AS p_h_eg_s3, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_eg_s4
            ELSE 0
        END AS p_h_eg_s4, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_eg_m
            ELSE 0
        END AS p_h_eg_m, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_eg_m2
            ELSE 0
        END AS p_h_eg_m2, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_eg_o
            ELSE 0
        END AS p_h_eg_o, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_mg_g
            ELSE 0
        END AS p_h_mg_s1, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_mg_s
            ELSE 0
        END AS p_h_mg_s2, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_mg_s3
            ELSE 0
        END AS p_h_mg_s3, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_mg_s4
            ELSE 0
        END AS p_h_mg_s4, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_mg_m
            ELSE 0
        END AS p_h_mg_m, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_mg_m2
            ELSE 0
        END AS p_h_mg_m2, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_mg_o
            ELSE 0
        END AS p_h_mg_o, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_on_g
            ELSE 0
        END AS p_h_on_s1, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_on_s
            ELSE 0
        END AS p_h_on_s2, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_on_s3
            ELSE 0
        END AS p_h_on_s3, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_on_s4
            ELSE 0
        END AS p_h_on_s4, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_on_m
            ELSE 0
        END AS p_h_on_m, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_on_m2
            ELSE 0
        END AS p_h_on_m2, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_h_on_o
            ELSE 0
        END AS p_h_on_o, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_eg_s
            ELSE 0
        END AS p_k_eg_s, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_eg_m
            ELSE 0
        END AS p_k_eg_m, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_eg_m2
            ELSE 0
        END AS p_k_eg_m2, 
		 CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_eg_m3
            ELSE 0
        END AS p_k_eg_m3, 
		 CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_eg_m4
            ELSE 0
        END AS p_k_eg_m4, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_eg_o
            ELSE 0
        END AS p_k_eg_o, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_mg_s
            ELSE 0
        END AS p_k_mg_s, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_mg_m
            ELSE 0
        END AS p_k_mg_m, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_mg_m2
            ELSE 0
        END AS p_k_mg_m2, 
		 CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_mg_m3
            ELSE 0
        END AS p_k_mg_m3, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_mg_m4
            ELSE 0
        END AS p_k_mg_m4, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_mg_o
            ELSE 0
        END AS p_k_mg_o, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_on_s
            ELSE 0
        END AS p_k_on_s, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_on_m
            ELSE 0
        END AS p_k_on_m, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_on_m2
            ELSE 0
        END AS p_k_on_m2, 
		CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_on_m3
            ELSE 0
        END AS p_k_on_m3, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_on_m4
            ELSE 0
        END AS p_k_on_m4, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_k_on_o
            ELSE 0
        END AS p_k_on_o, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_o_eg
            ELSE 0
        END AS p_o_eg, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_o_mg
            ELSE 0
        END AS p_o_mg, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_o_o
            ELSE 0
        END AS p_o_o, 
        CASE
            WHEN gep.gerealiseerd = 2 THEN gep.p_s
            ELSE 0
        END AS p_s, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_t
            ELSE 0::bigint
        END AS r_t, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_eg_g
            ELSE 0
        END AS r_h_eg_s1, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_eg_s
            ELSE 0
        END AS r_h_eg_s2, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_eg_s3
            ELSE 0
        END AS r_h_eg_s3, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_eg_s4
            ELSE 0
        END AS r_h_eg_s4, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_eg_m
            ELSE 0
        END AS r_h_eg_m, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_eg_m2
            ELSE 0
        END AS r_h_eg_m2, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_eg_o
            ELSE 0
        END AS r_h_eg_o, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_mg_g
            ELSE 0
        END AS r_h_mg_s1, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_mg_s
            ELSE 0
        END AS r_h_mg_s2, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_mg_s3
            ELSE 0
        END AS r_h_mg_s3, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_mg_s4
            ELSE 0
        END AS r_h_mg_s4, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_mg_m
            ELSE 0
        END AS r_h_mg_m, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_mg_m2
            ELSE 0
        END AS r_h_mg_m2, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_mg_o
            ELSE 0
        END AS r_h_mg_o, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_on_g
            ELSE 0
        END AS r_h_on_s1, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_on_s
            ELSE 0
        END AS r_h_on_s2, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_on_s3
            ELSE 0
        END AS r_h_on_s3, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_on_s4
            ELSE 0
        END AS r_h_on_s4, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_on_m
            ELSE 0
        END AS r_h_on_m, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_on_m2
            ELSE 0
        END AS r_h_on_m2, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_h_on_o
            ELSE 0
        END AS r_h_on_o, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_eg_s
            ELSE 0
        END AS r_k_eg_s, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_eg_m
            ELSE 0
        END AS r_k_eg_m, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_eg_m2
            ELSE 0
        END AS r_k_eg_m2, 
		 CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_eg_m3
            ELSE 0
        END AS r_k_eg_m3, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_eg_m4
            ELSE 0
        END AS r_k_eg_m4, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_eg_o
            ELSE 0
        END AS r_k_eg_o, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_mg_s
            ELSE 0
        END AS r_k_mg_s, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_mg_m
            ELSE 0
        END AS r_k_mg_m, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_mg_m2
            ELSE 0
        END AS r_k_mg_m2, 
		CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_mg_m3
            ELSE 0
        END AS r_k_mg_m3, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_mg_m4
            ELSE 0
        END AS r_k_mg_m4, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_mg_o
            ELSE 0
        END AS r_k_mg_o, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_on_s
            ELSE 0
        END AS r_k_on_s, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_on_m
            ELSE 0
        END AS r_k_on_m, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_on_m2
            ELSE 0
        END AS r_k_on_m2, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_on_m3
            ELSE 0
        END AS r_k_on_m3, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_on_m4
            ELSE 0
        END AS r_k_on_m4, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_k_on_o
            ELSE 0
        END AS r_k_on_o, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_o_eg
            ELSE 0
        END AS r_o_eg, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_o_mg
            ELSE 0
        END AS r_o_mg, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_o_o
            ELSE 0
        END AS r_o_o, 
        CASE
            WHEN gep.gerealiseerd = 1 THEN gep.p_s
            ELSE 0
        END AS r_s, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_t
            ELSE 0::bigint
        END AS o_t, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_eg_g
            ELSE 0
        END AS o_h_eg_s1, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_eg_s
            ELSE 0
        END AS o_h_eg_s2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_eg_s3
            ELSE 0
        END AS o_h_eg_s3, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_eg_s4
            ELSE 0
        END AS o_h_eg_s4, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_eg_m
            ELSE 0
        END AS o_h_eg_m, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_eg_m2
            ELSE 0
        END AS o_h_eg_m2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_eg_o
            ELSE 0
        END AS o_h_eg_o, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_mg_g
            ELSE 0
        END AS o_h_mg_s1, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_mg_s
            ELSE 0
        END AS o_h_mg_s2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_mg_s3
            ELSE 0
        END AS o_h_mg_s3, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_mg_s4
            ELSE 0
        END AS o_h_mg_s4, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_mg_m
            ELSE 0
        END AS o_h_mg_m, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_mg_m2
            ELSE 0
        END AS o_h_mg_m2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_mg_o
            ELSE 0
        END AS o_h_mg_o, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_on_g
            ELSE 0
        END AS o_h_on_s1, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_on_s
            ELSE 0
        END AS o_h_on_s2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_on_s3
            ELSE 0
        END AS o_h_on_s3, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_on_s4
            ELSE 0
        END AS o_h_on_s4, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_on_m
            ELSE 0
        END AS o_h_on_m, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_on_m2
            ELSE 0
        END AS o_h_on_m2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_h_on_o
            ELSE 0
        END AS o_h_on_o, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_eg_s
            ELSE 0
        END AS o_k_eg_s, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_eg_m
            ELSE 0
        END AS o_k_eg_m, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_eg_m2
            ELSE 0
        END AS o_k_eg_m2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_eg_m3
            ELSE 0
        END AS o_k_eg_m3, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_eg_m4
            ELSE 0
        END AS o_k_eg_m4, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_eg_o
            ELSE 0
        END AS o_k_eg_o, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_mg_s
            ELSE 0
        END AS o_k_mg_s, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_mg_m
            ELSE 0
        END AS o_k_mg_m, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_mg_m2
            ELSE 0
        END AS o_k_mg_m2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_mg_m3
            ELSE 0
        END AS o_k_mg_m3, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_mg_m4
            ELSE 0
        END AS o_k_mg_m4, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_mg_o
            ELSE 0
        END AS o_k_mg_o, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_on_s
            ELSE 0
        END AS o_k_on_s, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_on_m
            ELSE 0
        END AS o_k_on_m, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_on_m2
            ELSE 0
        END AS o_k_on_m2, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_on_m3
            ELSE 0
        END AS o_k_on_m3, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_on_m4
            ELSE 0
        END AS o_k_on_m4, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_k_on_o
            ELSE 0
        END AS o_k_on_o, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_o_eg
            ELSE 0
        END AS o_o_eg, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_o_mg
            ELSE 0
        END AS o_o_mg, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_o_o
            ELSE 0
        END AS o_o_o, 
        CASE
            WHEN gep.gerealiseerd = 0 THEN gep.p_s
            ELSE 0
        END AS o_s
   FROM gepland_view gep;

-- View: status_view


CREATE OR REPLACE VIEW status_view AS 
 SELECT b.id, b.prognose_start, b.prognose_oplevering, spl.type AS statusplanologisch, spt.type AS statusproject, b.status_namelijk, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 1 AND bv.bouwplanid = b.id) AS alg_voortgang, ( SELECT bv.toelichting
           FROM bouwplanvoortgang bv
          WHERE bv.voortgangsoortid = 1 AND bv.bouwplanid = b.id) AS alg_toelichting, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 2 AND bv.bouwplanid = b.id) AS plan_voortgang, ( SELECT bv.toelichting
           FROM bouwplanvoortgang bv
          WHERE bv.voortgangsoortid = 2 AND bv.bouwplanid = b.id) AS plan_toelichting, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 3 AND bv.bouwplanid = b.id) AS start_voortgang, ( SELECT bv.toelichting
           FROM bouwplanvoortgang bv
          WHERE bv.voortgangsoortid = 3 AND bv.bouwplanid = b.id) AS start_toelichting, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 4 AND bv.bouwplanid = b.id) AS bouwrijp_voortgang, ( SELECT bv.toelichting
           FROM bouwplanvoortgang bv
          WHERE bv.voortgangsoortid = 4 AND bv.bouwplanid = b.id) AS bouwrijp_toelichting, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 5 AND bv.bouwplanid = b.id) AS vergunning_voortgang, ( SELECT bv.toelichting
           FROM bouwplanvoortgang bv
          WHERE bv.voortgangsoortid = 5 AND bv.bouwplanid = b.id) AS vergunning_toelichting, ( SELECT vs.type
           FROM bouwplanvoortgang bv
      LEFT JOIN voortgangstatus vs ON vs.id = bv.voortgangstatusid
     WHERE bv.voortgangsoortid = 6 AND bv.bouwplanid = b.id) AS overig_voortgang, ( SELECT bv.toelichting
           FROM bouwplanvoortgang bv
          WHERE bv.voortgangsoortid = 6 AND bv.bouwplanid = b.id) AS overig_toelichting
   FROM bouwplan b
   LEFT JOIN statusplanologisch spl ON b.statusplanologischid = spl.id
   LEFT JOIN statusproject spt ON b.statusprojectid = spt.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;



-- View: volledig_overzicht_shape_view
-- DROP VIEW volledig_overzicht_shape_view;

CREATE OR REPLACE VIEW volledig_overzicht_shape_view AS 
  SELECT b.the_geom,
   b.id,
   b.plan_identificatie AS planidentificatie,
   b.naam,
   gem.naam as gemeente,r.naam as regio,b.referentienummer,
   b.masterplan,
   b.bestemmingsplannaam,

b.huur1,b.huur2,b.huur3,b.huur4,b.huurprijsonbekend,b.huurtotaal,b.koop1,b.koop2,b.koop3,b.koop4,b.kooptotaal,b.koopprijsonbekend,
 b.imronummer,
 b.jaar_eerste_oplevering,
 b.jaar_laatste_oplevering,
b.restcapaciteit,
 b.resterendesloop,
ot.type AS opdrachtgever,
 b.ontwikkelaar_namelijk AS opdrachtgever_namelijk,
  a.naam AS aanduiding,
   p.type AS plantype,
    w.type AS woonmilieu,
   b.woonmilieu_namelijk as woonm_nml,
   b.woonmilieu_rosetta as rosetta, 
   g.naam AS gebruikgegevens, 
   sv.statusplanologisch as status_plan, sv.statusproject as status_proj
   FROM bouwplan b
   LEFT JOIN ontwikkelaartype ot ON b.ontwikkelaartypeid = ot.id
   LEFT JOIN aanduiding a ON b.aanduidingid = a.id
   LEFT JOIN plantype p ON b.plantypeid = p.id
   LEFT JOIN woonmilieu w ON b.woonmilieuid = w.id
   LEFT JOIN gebruikgegevens g ON b.gebruikgegevensid = g.id
   LEFT JOIN gemeente gem on b.gemeenteid = gem.id
   LEFT JOIN regio r on r.id = gem.regioid
   JOIN status_view sv ON b.id = sv.id;


-- View: pertype_overzicht_shape_view

CREATE OR REPLACE VIEW pertype_overzicht_shape_view AS 
 SELECT b.the_geom, b.id,b.planidentificatie, b.naam,b.gemeente,b.regio, b.referentienummer, b.masterplan, b.bestemmingsplannaam, b.opdrachtgever, b.opdrachtgever_namelijk, b.aanduiding, b.plantype, b.woonmilieu,
 b.woonm_nml,  b.rosetta, b.invloedsgebied_hov, b.naam_invloedsgebied_hov,b.ligginggebied, b.gebruikgegevens, b.prognose_start, b.prognose_oplevering, b.status_planologisch , 
 b.status_project as status_project, b.status_namelijk,  b.alg_voortgang,  b.alg_toelichting, b.plan_voortgang, b.plan_toelichting, b.start_voortgang, b.start_toelichting, b.bouwrijp_voortgang, b.bouwrijp_toelichting, 
 b.vergunning_voortgang, b.vergunning_toelichting, b.overig_voortgang, b.overig_toelichting,
 
 COALESCE(( SELECT sum(gepland_view.p_t) AS sum FROM gepland_view WHERE gepland_view.id = b.id AND (gepland_view.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7]))), 0::numeric) AS "to_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "hu_2015",
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30,42,43,44,45,46,47]))), 0::bigint) AS "ko_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "ei_on_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40,42,43]))), 0::bigint) AS "eg_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41,44,45]))), 0::bigint) AS "mg_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39,46,47]))), 0::bigint) AS "ty_on_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "so_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11,42,43,44,45,46,47]))), 0::bigint) AS "ma_2015", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "pr_on_2015",
		  COALESCE(( SELECT sum(gepland_view.p_t) AS sum FROM gepland_view WHERE gepland_view.id = b.id AND (gepland_view.periodeid = ANY (ARRAY[8, 9, 10, 11, 12]))), 0::numeric) AS "to_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "hu_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30,42,43,44,45,46,47]))), 0::bigint) AS "ko_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "ei_on_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40,42,43]))), 0::bigint) AS "eg_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41,44,45]))), 0::bigint) AS "mg_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39,46,47]))), 0::bigint) AS "ty_on_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "so_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11,42,43,44,45,46,47]))), 0::bigint) AS "ma_1519", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "pr_on_1519",
		  COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 13), 0::numeric) AS "to_2024", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "hu_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30,42,43,44,45,46,47]))), 0::bigint) AS "ko_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "ei_on_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40,42,43]))), 0::bigint) AS "eg_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41,44,45]))), 0::bigint) AS "mg_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39,46,47]))), 0::bigint) AS "ty_on_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "so_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11,42,43,44,45,46,47]))), 0::bigint) AS "ma_2024", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "pr_on_2024", 
		  COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 14), 0::numeric) AS "to_2529", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "hu_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30,42,43,44,45,46,47]))), 0::bigint) AS "ko_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "ei_on_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40,42,43]))), 0::bigint) AS "eg_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41,44,45]))), 0::bigint) AS "mg_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39,46,47]))), 0::bigint) AS "ty_on_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "so_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11,42,43,44,45,46,47]))), 0::bigint) AS "ma_2529", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "pr_on_2529", 
		  COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 16), 0::numeric) AS "to_30_ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "hu_30_ev", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30,42,43,44,45,46,47]))), 0::bigint) AS "ko_30_ev", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "ei_on_30_ev", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40,42,43]))), 0::bigint) AS "eg_30_ev", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41,44,45]))), 0::bigint) AS "mg_30_ev",
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39,46,47]))), 0::bigint) AS "ty_on_30_ev", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "so_30_ev",
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11,42,43,44,45,46,47]))), 0::bigint) AS "ma_30_ev", 
		  COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "pr_on_30_ev"
   FROM volledig_overzicht_shape_view b;


-- View: pertype_overzicht_view


CREATE OR REPLACE VIEW pertype_overzicht_view AS 
 SELECT pertype_overzicht_shape_view.id, pertype_overzicht_shape_view.planidentificatie,pertype_overzicht_shape_view.naam, pertype_overzicht_shape_view.gemeente, pertype_overzicht_shape_view.regio,pertype_overzicht_shape_view.referentienummer, 
 pertype_overzicht_shape_view.masterplan, pertype_overzicht_shape_view.bestemmingsplannaam, pertype_overzicht_shape_view.opdrachtgever, pertype_overzicht_shape_view.opdrachtgever_namelijk, 
 pertype_overzicht_shape_view.aanduiding, pertype_overzicht_shape_view.plantype, pertype_overzicht_shape_view.woonmilieu, pertype_overzicht_shape_view.woonm_nml, pertype_overzicht_shape_view.rosetta, 
 pertype_overzicht_shape_view.invloedsgebied_hov,pertype_overzicht_shape_view.naam_invloedsgebied_hov, pertype_overzicht_shape_view.ligginggebied,
 pertype_overzicht_shape_view.gebruikgegevens, pertype_overzicht_shape_view.prognose_start, pertype_overzicht_shape_view.prognose_oplevering, pertype_overzicht_shape_view.status_planologisch,
 pertype_overzicht_shape_view.status_project, pertype_overzicht_shape_view.status_namelijk, pertype_overzicht_shape_view.alg_voortgang, pertype_overzicht_shape_view.alg_toelichting, 
 pertype_overzicht_shape_view.plan_voortgang, pertype_overzicht_shape_view.plan_toelichting, pertype_overzicht_shape_view.start_voortgang, pertype_overzicht_shape_view.start_toelichting, 
 pertype_overzicht_shape_view.bouwrijp_voortgang, pertype_overzicht_shape_view.bouwrijp_toelichting, pertype_overzicht_shape_view.vergunning_voortgang, pertype_overzicht_shape_view.vergunning_toelichting, 
 pertype_overzicht_shape_view.overig_voortgang, pertype_overzicht_shape_view.overig_toelichting, pertype_overzicht_shape_view."to_2015", pertype_overzicht_shape_view."hu_2015", 
 pertype_overzicht_shape_view."ko_2015", pertype_overzicht_shape_view."ei_on_2015", pertype_overzicht_shape_view."eg_2015", pertype_overzicht_shape_view."mg_2015", pertype_overzicht_shape_view."ty_on_2015", 
 pertype_overzicht_shape_view."so_2015", pertype_overzicht_shape_view."ma_2015", pertype_overzicht_shape_view."pr_on_2015", pertype_overzicht_shape_view."to_1519", pertype_overzicht_shape_view."hu_1519",
 pertype_overzicht_shape_view."ko_1519", pertype_overzicht_shape_view."ei_on_1519", pertype_overzicht_shape_view."eg_1519", pertype_overzicht_shape_view."mg_1519", pertype_overzicht_shape_view."ty_on_1519",
 pertype_overzicht_shape_view."so_1519", pertype_overzicht_shape_view."ma_1519", pertype_overzicht_shape_view."pr_on_1519", pertype_overzicht_shape_view."to_2024", pertype_overzicht_shape_view."hu_2024",
 pertype_overzicht_shape_view."ko_2024", pertype_overzicht_shape_view."ei_on_2024", pertype_overzicht_shape_view."eg_2024", pertype_overzicht_shape_view."mg_2024", pertype_overzicht_shape_view."ty_on_2024",
 pertype_overzicht_shape_view."so_2024", pertype_overzicht_shape_view."ma_2024", pertype_overzicht_shape_view."pr_on_2024", pertype_overzicht_shape_view."to_2529", pertype_overzicht_shape_view."hu_2529",
 pertype_overzicht_shape_view."ko_2529", pertype_overzicht_shape_view."ei_on_2529", pertype_overzicht_shape_view."eg_2529", pertype_overzicht_shape_view."mg_2529", pertype_overzicht_shape_view."ty_on_2529",
 pertype_overzicht_shape_view."so_2529", pertype_overzicht_shape_view."ma_2529", pertype_overzicht_shape_view."pr_on_2529", pertype_overzicht_shape_view."to_30_ev", pertype_overzicht_shape_view."hu_30_ev",
 pertype_overzicht_shape_view."ko_30_ev", pertype_overzicht_shape_view."ei_on_30_ev", pertype_overzicht_shape_view."eg_30_ev", pertype_overzicht_shape_view."mg_30_ev", pertype_overzicht_shape_view."ty_on_30_ev",
 pertype_overzicht_shape_view."so_30_ev", pertype_overzicht_shape_view."ma_30_ev", pertype_overzicht_shape_view."pr_on_30_ev"
   FROM pertype_overzicht_shape_view;

-- View: volledig_aantal_view

-- View: planningperperiode_overzicht_shape_view

-- DROP VIEW planningperperiode_overzicht_shape_view;

CREATE OR REPLACE VIEW planningperperiode_overzicht_shape_view AS 
 SELECT b.the_geom, b.id,b.planidentificatie, b.naam, b.gemeente, b.regio, b.referentienummer, b.masterplan, b.bestemmingsplannaam, b.opdrachtgever, b.opdrachtgever_namelijk, b.aanduiding, b.plantype, b.woonmilieu,
 b.woonm_nml, b.rosetta, b.invloedsgebied_hov, b.naam_invloedsgebied_hov, b.ligginggebied,  b.gebruikgegevens, b.prognose_start, b.prognose_oplevering, b.status_planologisch as status_planologisch, b.status_project as status_project, b.status_namelijk,
 b.alg_voortgang, b.alg_toelichting, b.plan_voortgang, b.plan_toelichting, b.start_voortgang, b.start_toelichting, b.bouwrijp_voortgang, b.bouwrijp_toelichting, b.vergunning_voortgang, b.vergunning_toelichting, 
 b.overig_voortgang, b.overig_toelichting, 
 COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t FROM volledig_aantal_view_incl_gerealiseerd aan WHERE aan.id = b.id AND aan.periodeid = 2), 0::bigint) AS "nb_2009", 
 COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 3), 0::bigint) AS "nb_2010",
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 4), 0::bigint) AS "nb_2011", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 5), 0::bigint) AS "nb_2012",
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 6), 0::bigint) AS "nb_2013", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 7), 0::bigint) AS "nb_2014", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 8), 0::bigint) AS "nb_2015", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 9), 0::bigint) AS "nb_2016", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 10), 0::bigint) AS "nb_2017", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 11), 0::bigint) AS "nb_2018", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 12), 0::bigint) AS "nb_2019", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 13), 0::bigint) AS "nb_2024", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 14), 0::bigint) AS "nb_2529", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 16), 0::bigint) AS "nb_2030_ev", 
		  COALESCE(( SELECT aan.p_t + aan.o_t + aan.r_t  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 17), 0::bigint) AS "nb_on", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s FROM volledig_aantal_view_incl_gerealiseerd aan   WHERE aan.id = b.id AND aan.periodeid = 2), 0) AS "sl_2009", 
		   COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 3), 0) AS "sl_2010", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s FROM volledig_aantal_view_incl_gerealiseerd aan WHERE b.id = aan.id AND aan.periodeid = 4), 0) AS "sl_2011",
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 5), 0) AS "sl_2012",
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 6), 0) AS "sl_2013",
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 7), 0) AS "sl_2014", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 8), 0) AS "sl_2015",
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 9), 0) AS "sl_2016", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 10), 0) AS "sl_2017",
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 11), 0) AS "sl_2018", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 12), 0) AS "sl_2019", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 13), 0) AS "sl_2024", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 14), 0) AS "sl_2529", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 16), 0) AS "sl_2030_ev", 
		  COALESCE(( SELECT aan.p_s + aan.o_s + aan.r_s  FROM volledig_aantal_view_incl_gerealiseerd aan  WHERE b.id = aan.id AND aan.periodeid = 17), 0) AS "sl_on"
   FROM volledig_overzicht_shape_view b;




-- View: planningperperiode_overzicht_view

CREATE OR REPLACE VIEW planningperperiode_overzicht_view AS 
 SELECT planningperperiode_overzicht_shape_view.id,  planningperperiode_overzicht_shape_view.planidentificatie, planningperperiode_overzicht_shape_view.naam, planningperperiode_overzicht_shape_view.gemeente,planningperperiode_overzicht_shape_view.regio,
 planningperperiode_overzicht_shape_view.referentienummer, planningperperiode_overzicht_shape_view.masterplan, 
 planningperperiode_overzicht_shape_view.bestemmingsplannaam, planningperperiode_overzicht_shape_view.opdrachtgever, planningperperiode_overzicht_shape_view.opdrachtgever_namelijk, 
 planningperperiode_overzicht_shape_view.aanduiding, planningperperiode_overzicht_shape_view.plantype, planningperperiode_overzicht_shape_view.woonmilieu, planningperperiode_overzicht_shape_view.woonm_nml, 
 planningperperiode_overzicht_shape_view.rosetta, planningperperiode_overzicht_shape_view.invloedsgebied_hov,planningperperiode_overzicht_shape_view.naam_invloedsgebied_hov,
 planningperperiode_overzicht_shape_view.ligginggebied,planningperperiode_overzicht_shape_view.gebruikgegevens, 
 planningperperiode_overzicht_shape_view.prognose_start, planningperperiode_overzicht_shape_view.prognose_oplevering, planningperperiode_overzicht_shape_view.status_planologisch, 
 planningperperiode_overzicht_shape_view.status_project, planningperperiode_overzicht_shape_view.status_namelijk, planningperperiode_overzicht_shape_view.alg_voortgang, 
 planningperperiode_overzicht_shape_view.alg_toelichting, planningperperiode_overzicht_shape_view.plan_voortgang, planningperperiode_overzicht_shape_view.plan_toelichting, 
 planningperperiode_overzicht_shape_view.start_voortgang, planningperperiode_overzicht_shape_view.start_toelichting, planningperperiode_overzicht_shape_view.bouwrijp_voortgang, 
 planningperperiode_overzicht_shape_view.bouwrijp_toelichting, planningperperiode_overzicht_shape_view.vergunning_voortgang, planningperperiode_overzicht_shape_view.vergunning_toelichting,
 planningperperiode_overzicht_shape_view.overig_voortgang, planningperperiode_overzicht_shape_view.overig_toelichting, planningperperiode_overzicht_shape_view."nb_2009" as "nieuwbouw tot 2009", 
 planningperperiode_overzicht_shape_view."nb_2010" as "nieuwbouw 2010", planningperperiode_overzicht_shape_view."nb_2011" as "nieuwbouw 2011", planningperperiode_overzicht_shape_view."nb_2012" as "nieuwbouw 2012", planningperperiode_overzicht_shape_view."nb_2013" as "nieuwbouw 2013",
 planningperperiode_overzicht_shape_view."nb_2014" as "nieuwbouw 2014", planningperperiode_overzicht_shape_view."nb_2015" as "nieuwbouw 2015", planningperperiode_overzicht_shape_view."nb_2016" as "nieuwbouw 2016", planningperperiode_overzicht_shape_view."nb_2017" as "nieuwbouw 2017",
 planningperperiode_overzicht_shape_view."nb_2018" as "nieuwbouw 2018", planningperperiode_overzicht_shape_view."nb_2019" as "nieuwbouw 2019", planningperperiode_overzicht_shape_view."nb_2024" as "nieuwbouw 2020-2024", planningperperiode_overzicht_shape_view."nb_2529" as "nieuwbouw 2025-2029",
 planningperperiode_overzicht_shape_view."nb_2030_ev" as "nieuwbouw 2030 even verder", planningperperiode_overzicht_shape_view."nb_on" as "nieuwbouw onbekend", planningperperiode_overzicht_shape_view."sl_2009" as "sloop tot 2009", planningperperiode_overzicht_shape_view."sl_2010" as "sloop 2010", 
 planningperperiode_overzicht_shape_view."sl_2011" as "sloop 2011", planningperperiode_overzicht_shape_view."sl_2012" as "sloop 2012", planningperperiode_overzicht_shape_view."sl_2013" as "sloop 2013", planningperperiode_overzicht_shape_view."sl_2014" as "sloop 2014",
 planningperperiode_overzicht_shape_view."sl_2015" as "sloop 2015", planningperperiode_overzicht_shape_view."sl_2016" as "sloop 2016", planningperperiode_overzicht_shape_view."sl_2017" as "sloop 2017", planningperperiode_overzicht_shape_view."sl_2018" as "sloop 2018", 
 planningperperiode_overzicht_shape_view."sl_2019" as "sloop 2019", planningperperiode_overzicht_shape_view."sl_2024" as "sloop 2020-2024", planningperperiode_overzicht_shape_view."sl_2529" as "sloop 2025-2029", planningperperiode_overzicht_shape_view."sl_2030_ev" as "sloop 2030 en verder", 
 planningperperiode_overzicht_shape_view."sl_on" as "sloop onbekend"
   FROM planningperperiode_overzicht_shape_view;


-- View: volledig_extravelden_view

-- View: extragepland_view

-- DROP VIEW extragepland_view;

CREATE OR REPLACE VIEW extragepland_view AS 
 SELECT b.id, p.omschrijving AS jaar, es.type AS extraveldsoort, e.aantalgepland AS waarde
   FROM extraveld e
   LEFT JOIN bouwplan b ON e.bouwplanid = b.id
   LEFT JOIN periode p ON e.periodeid = p.id
   LEFT JOIN extraveldsoort es ON e.extraveldsoortid = es.id
  ORDER BY b.id;


-- View: extragerealiseerd_view


CREATE OR REPLACE VIEW extragerealiseerd_view AS 
 SELECT b.id, p.omschrijving AS jaar, es.type AS extraveldsoort, e.aantalgerealiseerd AS waarde
   FROM extraveld e
   LEFT JOIN bouwplan b ON e.bouwplanid = b.id
   LEFT JOIN periode p ON e.periodeid = p.id
   LEFT JOIN extraveldsoort es ON e.extraveldsoortid = es.id
  ORDER BY b.id;



CREATE OR REPLACE VIEW volledig_extravelden_view AS 
 SELECT ger.id, ger.jaar, ger.extraveldsoort, ger.waarde AS gerealiseerd_waarde, gep.waarde AS gepland_waarde
   FROM extragepland_view gep
   JOIN extragerealiseerd_view ger ON ger.id = gep.id;


-- View: volledig_overzicht_view


CREATE OR REPLACE VIEW volledig_overzicht_view AS 
 SELECT 
    volledig_overzicht_shape_view.id,    volledig_overzicht_shape_view.planidentificatie,    volledig_overzicht_shape_view.naam,    volledig_overzicht_shape_view.gemeente,    volledig_overzicht_shape_view.regio,    volledig_overzicht_shape_view.referentienummer,    volledig_overzicht_shape_view.masterplan,    volledig_overzicht_shape_view.bestemmingsplannaam,    volledig_overzicht_shape_view.huur1,    volledig_overzicht_shape_view.huur2,    volledig_overzicht_shape_view.huur3,    volledig_overzicht_shape_view.huur4,    volledig_overzicht_shape_view.huurprijsonbekend,    volledig_overzicht_shape_view.huurtotaal,    volledig_overzicht_shape_view.koop1,    volledig_overzicht_shape_view.koop2,    volledig_overzicht_shape_view.koop3,    volledig_overzicht_shape_view.koop4,    volledig_overzicht_shape_view.kooptotaal,    volledig_overzicht_shape_view.koopprijsonbekend,    volledig_overzicht_shape_view.imronummer,    volledig_overzicht_shape_view.jaar_eerste_oplevering,    volledig_overzicht_shape_view.jaar_laatste_oplevering,    volledig_overzicht_shape_view.restcapaciteit,    volledig_overzicht_shape_view.resterendesloop,    volledig_overzicht_shape_view.opdrachtgever,    volledig_overzicht_shape_view.opdrachtgever_namelijk,    volledig_overzicht_shape_view.aanduiding,    volledig_overzicht_shape_view.plantype,    volledig_overzicht_shape_view.woonmilieu,    volledig_overzicht_shape_view.woonm_nml,    volledig_overzicht_shape_view.rosetta,    volledig_overzicht_shape_view.gebruikgegevens,    volledig_overzicht_shape_view.status_plan,    volledig_overzicht_shape_view.status_proj   FROM volledig_overzicht_shape_view;
ALTER TABLE volledig_overzicht_view;



-- View: rapportage_pertype_view


CREATE OR REPLACE VIEW rapportage_pertype_view AS 
 SELECT g.naam AS gemeentenaam, b.naam, aant.status_planologisch, aant.status_project , aant.alg_voortgang, (aant."to_2015" + aant."to_1519" + aant."to_2024" + aant."to_2529" + aant."to_30_ev")::bigint as "nieuwbouw totaal",
 aant."hu_2015" + aant."hu_1519" + aant."hu_2024" + aant."hu_2529" + aant."hu_30_ev" as "huur", aant."ko_2015" + aant."ko_1519" + aant."ko_2024" + aant."ko_2529" + aant."ko_30_ev" as "koop", 
 aant."ei_on_2015" + aant."ei_on_1519" + aant."ei_on_2024" + aant."ei_on_2529" + aant."ei_on_30_ev" AS "eigendom onbekend", aant."eg_2015" + aant."eg_1519" + aant."eg_2024" + aant."eg_2529" + aant."eg_30_ev" as "eengezins",
 aant."mg_2015" + aant."mg_1519" + aant."mg_2024" + aant."mg_2529" + aant."mg_30_ev" AS "meergezins", aant."ty_on_2015" + aant."ty_on_1519" + aant."ty_on_2024" + aant."ty_on_2529" + aant."ty_on_30_ev" AS "type onbekend", 
 b.id
   FROM pertype_overzicht_view aant
   JOIN bouwplan b ON b.id = aant.id
   JOIN gemeente g ON g.id = b.gemeenteid;




-- View: rapportage_planningperperiode_view


CREATE OR REPLACE VIEW rapportage_planningperperiode_view AS 
 SELECT g.naam AS gemeentenaam, b.naam, aant.status_planologisch, aant.status_project, aant.alg_voortgang, aant."to_2015"::bigint as "totaal 2015", aant."to_1519"::bigint as "totaal 2015-2019", aant."to_2024"::bigint as "totaal 2020-2024", aant."to_2529"::bigint as "totaal 2025-2029", 
 aant."to_30_ev"::bigint as "totaal 2030 en verder", b.id
   FROM pertype_overzicht_view aant
   JOIN bouwplan b ON b.id = aant.id
   JOIN gemeente g ON g.id = b.gemeenteid;



-- View: rapportage_planninghov_view

-- DROP VIEW rapportage_planninghov_view;

CREATE OR REPLACE VIEW rapportage_planninghov_view AS 
 SELECT r.naam AS regio, g.naam AS gemeentenaam, b.naam AS plannaam, ( SELECT h.legenda
           FROM invloedsgebied_hov h
          WHERE st_intersects(b.the_geom, h.the_geom)
          ORDER BY b.id, st_area(st_intersection(h.the_geom, st_buffer(b.the_geom, 0::double precision))) DESC
         LIMIT 1) AS invloedsgebied_hov, ( SELECT h.naam
           FROM invloedsgebied_hov h
          WHERE st_intersects(b.the_geom, h.the_geom)
          ORDER BY b.id, st_area(st_intersection(h.the_geom, st_buffer(b.the_geom, 0::double precision))) DESC
         LIMIT 1) AS naam_invloedsgebied_hov, s.type AS status_planologisch, 100::double precision * s.percentage AS status_percentage, p.omschrijving AS periode, p.p_t AS nieuwbouw, p.p_s AS sloop, s.percentage * p.p_t::double precision AS ont_cap_nieuwbouw, s.percentage * p.p_s::double precision AS ontw_cap_sloop, b.id
   FROM bouwplan b
   LEFT JOIN gepland_view p ON b.id = p.id
   LEFT JOIN gemeente g ON g.id = b.gemeenteid
   LEFT JOIN regio r ON r.id = g.regioid
   LEFT JOIN statusplanologisch s ON s.id = b.statusplanologischid;
   

CREATE OR REPLACE VIEW volledig_opmerking_view AS 
 SELECT b.id, ( SELECT bouwplanopmerking.opmerking
           FROM bouwplanopmerking
          WHERE bouwplanopmerking.bouwplanid = b.id AND bouwplanopmerking.accesslevelid = 2) AS opmerking
   FROM bouwplan b
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;


   
   ----------------------------------------------------------------
   -- Not export views (for mapfiles)                            --
   
-- View: bouwplan_view

-- DROP VIEW bouwplan_view;


 DROP VIEW bouwplan_view;

CREATE OR REPLACE VIEW bouwplan_view AS 
 SELECT b.id,
    b.the_geom,
    b.naam,
    b.gebruikgegevensid,
    b.aanduidingid,
        CASE plantypeid
            WHEN 1 THEN '#048500'::text
            WHEN 2 THEN '#09FF00'::text
            WHEN 3 THEN '#FFE100'::text
            WHEN 6 THEN '#FF8800'::text
            WHEN 7 THEN '#AA00FF'::text
            WHEN 99 THEN '#C0C0C0'::text
            ELSE '#000000'::text
        END AS plantype,
    b.gemeenteid,
    g.regioid,
    g.provincie AS provincieid,
    b.statusprojectid
   FROM bouwplan b
     LEFT JOIN gemeente g ON b.gemeenteid = g.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;

-- DROP VIEW info_view;

CREATE OR REPLACE VIEW info_view AS 
 SELECT b.id, b.the_geom, b.naam AS plannaam, b.aanduidingid, ( SELECT v.voortgangstatusid
           FROM bouwplanvoortgang v
          WHERE v.bouwplanid = b.id AND v.voortgangsoortid = 1) AS voortgangid, g.naam AS gemeente, to_char(b.prognose_start, 'DD-MM-YYYY'::text) AS prognose_start, to_char(b.prognose_oplevering, 'DD-MM-YYYY'::text) AS prognose_oplevering, 
    b.plantypeid as plantypeid,( SELECT vs.type
           FROM bouwplanvoortgang v
      LEFT JOIN voortgangstatus vs ON v.voortgangstatusid = vs.id
     WHERE v.bouwplanid = b.id AND v.voortgangsoortid = 1) AS voortgang, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid = 2) AS tweeduizendnegen, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid >= 3 AND f.periodeid <= 7) AS tweeduizendtien_veertien, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid >= 8 AND f.periodeid <= 12) AS tweeduizendveertien_negentien, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid = 13) AS tweeduizendtwintig, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27 AND f.periodeid = 17) AS onbekend, ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19) AS totaal
   FROM bouwplan b
   LEFT JOIN gemeente g ON b.gemeenteid = g.id
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL AND b.gebruikgegevensid = 1
  ORDER BY b.id;


-- View: volledig_totaal_uitgebreid_view

CREATE OR REPLACE VIEW volledig_totaal_uitgebreid_view AS 
 SELECT bp.id as bvid,
    bp.bouwplan as id,
    bp.year,
    bp.gepland,
    bp.sloop,
    bp.gerealiseerd,
    bp.eengezinshuur1,
    bp.eengezinshuur2,
    bp.eengezinshuur3,
    bp.eengezinshuur4,
    bp.eengezinshuuronb,
    bp.eengezinskoop1,
    bp.eengezinskoop2,
    bp.eengezinskoop3,
    bp.eengezinskoop4,
    bp.eengezinskooponb,
    bp.meergezinshuur1,
    bp.meergezinshuur2,
    bp.meergezinshuur3,
    bp.meergezinshuur4,
    bp.meergezinshuuronb,
    bp.meergezinskoop1,
    bp.meergezinskoop2,
    bp.meergezinskoop3,
    bp.meergezinskoop4,
    bp.meergezinskooponb,
    bp.onbekendhuur1,
    bp.onbekendhuur2,
    bp.onbekendhuur3,
    bp.onbekendhuur4,
    bp.onbekendhuuronb,
    bp.onbekendkoop1,
    bp.onbekendkoop2,
    bp.onbekendkoop3,
    bp.onbekendkoop4,
    bp.onbekendkooponb,
    bp.onbekendgerealiseerd,
    bp.eengezinsgerealiseerd,
    bp.meergezinsgerealiseerd
   FROM bouwplan_variable bp;

ALTER TABLE volledig_totaal_uitgebreid_view
  OWNER TO planmonitor;


-- View: eenvoudig_overzicht_shape_view

-- DROP VIEW eenvoudig_overzicht_shape_view;

CREATE OR REPLACE VIEW eenvoudig_overzicht_shape_view AS 
 SELECT b.the_geom,
    b.id,    b.naam as plannaam,        g.naam as gemeente,        b.plaatsnaam,        b.referentienummer,        b.bestemmingsplannaam as "best-plan",        b.imronummer,        b.masterplan,        o.type as opdr_type,        b.ontwikkelaar_namelijk as opdr_naam,        p.type AS plantype,        s.type AS status_plan,        sp.type AS status_proj,        b.knelpunten,        b.jaar_eerste_oplevering as jaar_begin,        b.jaar_laatste_oplevering as jaar_eind,        b.restcapaciteit as plancap,        b.resterendesloop as sloop,        gepland.gepland2013 AS gep2013,        gepland.gepland2014 AS gep2014,        gepland.gepland2015 AS gep2015,        gepland.gepland2016 AS gep2016,        gepland.gepland2017 AS gep2017,        gepland.gepland2018 AS gep2018,        gepland.gepland2019 AS gep2019,        gepland.gepland2020 AS gep2020,        gepland.gepland2021 AS gep2021,        gepland.gepland2022 AS gep2022,        gepland.gepland2023 AS gep2023,        gepland.gepland2024 AS gep2024,        gepland.gepland2025 AS gep2025,        gepland.gepland2026 AS gep2026,        gepland.gepland2027 AS gep2027,        gepland.gepland2028 AS gep2028,        gepland.gepland2029 AS gep2029,        gepland.gepland2030 AS gep2030,        gepland.gepland2031 AS gep2031,        gepland.gepland2032 AS gep2032,        gepland.gepland2033 AS gep2033,        gepland.gepland2034 AS gep2034,        gepland.gepland2035 AS gep2035,        gepland.gepland2036 AS gep2036,        gepland.gepland2037 AS gep2037,        gepland.gepland2038 AS gep2038,        gepland.gepland2039 AS gep2039,        gepland.gepland2040 AS gep2040   FROM bouwplan b
     JOIN bouwplan_data_gepland() gepland(bouwplan, gepland2013, gepland2014, gepland2015, gepland2016, gepland2017, gepland2018, gepland2019, gepland2020, gepland2021, gepland2022, gepland2023, gepland2024, gepland2025, gepland2026, gepland2027, gepland2028, gepland2029, gepland2030, gepland2031, gepland2032, gepland2033, gepland2034, gepland2035, gepland2036, gepland2037, gepland2038, gepland2039, gepland2040) ON b.id = gepland.bouwplan
     JOIN gemeente g ON b.gemeenteid = g.id
     JOIN ontwikkelaartype o ON b.ontwikkelaartypeid = o.id
     JOIN plantype p ON b.plantypeid = p.id
     JOIN statusplanologisch s ON b.statusplanologischid = s.id
     JOIN statusproject sp ON b.statusprojectid = sp.id;


--------------------------------
-- Alter the owners

/*


 ALTER TABLE volledig_aantal_view_incl_gerealiseerd OWNER TO rwbp;
 ALTER TABLE rapportage_planninghov_view OWNER TO rwbp;
 ALTER TABLE rapportage_planningperperiode_view OWNER TO rwbp;
 ALTER TABLE rapportage_pertype_view OWNER TO rwbp;
 ALTER TABLE volledig_overzicht_view OWNER TO rwbp;
 ALTER TABLE volledig_extravelden_view OWNER TO rwbp;
 ALTER TABLE extragepland_view OWNER TO rwbp ;
 ALTER TABLE extragerealiseerd_view OWNER TO rwbp;
 ALTER TABLE planningperperiode_overzicht_view OWNER TO rwbp;
 ALTER TABLE planningperperiode_overzicht_shape_view OWNER TO rwbp;
 
 ALTER TABLE pertype_overzicht_view OWNER TO rwbp;
 ALTER TABLE pertype_overzicht_shape_view OWNER TO rwbp;
 ALTER TABLE volledig_overzicht_shape_view OWNER TO rwbp;
 ALTER TABLE status_view OWNER TO rwbp;
 
 ALTER TABLE gepland_view OWNER TO rwbp;
 ALTER TABLE planningaantal_per_soort_per_periode_per_bouwplan OWNER TO rwbp;
 ALTER TABLE bouwplan_view OWNER TO rwbp;
 ALTER TABLE info_view OWNER TO rwbp;
ALTER TABLE volledig_opmerking_view OWNER TO rwbp;*/