Ext.define('B3p.planmonitor.VariableInstantiator', {
    subcategories:null,
    subcategorycounters: [],
    config: {
        variables:null,
        variableValues:null,
        isProvince:null
    },
    constructor: function(config){
        this.subcategories = new Object();
        this.initConfig(config);
        this.initInterface();
        this.initSubcategoryCounters();
    },

    initInterface : function(){
        var variables = this.config.variables;
        for(var i = 0 ; i < variables.length ; i++){
            var variable = variables[i];
            this.createVariable(variable);
        }
        this.hideEmptyBlocks();
        this.makeNiceDropdowns();
    },
    
    initSubcategoryCounters : function(){
        for(var key in this.subcategories) if(this.subcategories.hasOwnProperty(key)) {
            this.subcategorycounters.push(Ext.create('B3p.planmonitor.TotalCounter', {
                parent: '.' + key + "_counter",
                fields: [
                    'subcategory' 
                ],
                compareField: key,
                totalChanged: (function(field, totals, total) {
                    var actual = +(document.getElementById ( "type-"+this.compareField).value);
                    var span = document.getElementById( this.compareField + "_subcategories_error");
                    var errormessage = ['<span class="error-message">Subcategorieën (',total,') tellen niet op tot hoofdcategorie (', actual, ')</span>'].join("")
                    var container = $("#" + this.compareField + "_subcategories");
                    container.removeClass('error').find('.error-message').remove();
                    if((actual !== 0 || total !== 0) && actual !== total) {
                        container.addClass('error').append(errormessage);
                    }
                })
            }));
        }
    },

    resetSubcategoryCounters: function() {
        for(var i = 0; i < this.subcategorycounters.length; i++) {
            this.subcategorycounters[i].resetTotals();
        }
    },

    getValues : function(){
        var variables = this.config.variables;
        var values = {};
        for(var i = 0 ; i < variables.length ; i++){
            var variable = variables[i];
            var id = variable.id;
            var type = variable.type;
            var value = {
                id : id,
                name: variable.name
            };
            if (type === "radio") {
                value.value = $("input[name=" + id +"]:checked").val();
            } else if (type === "text" || type === "dropdown" || type === "number") {
                value.value = $("#" + id ).val();
            } else {
                alert("verkeerd type opgegeven: " + type);
                continue;
            }
            if(value.value === undefined){
                value.value = null;
            }
            values[variable.id] = value;
        }
        return values;
    },

    createVariable: function(variable){
        var type = variable.type;

        var container = this.getLocation(variable);
        var rowDiv = document.createElement('div');
        rowDiv.className ="row";

        var label = document.createElement('label');
        label.innerHTML = variable.name;

        var inputDiv = document.createElement('div');
        inputDiv.className ="input";

        var field = null;
        if(!this.config.isProvince && variable.provinceField){
            field = this.createLabel(variable);
        }else if(type === "dropdown"){
            field = this.createDropdown(variable);
        }else if( type === "radio"){
            field = this.createRadio(variable);
        }else if( type === "text"){
            field = this.createTextfield(variable);
        }else if(type === "number"){
            field = this.createTextfield(variable);
            field.onkeypress = this.isNumber;
        }else{
            alert("verkeerd type opgegeven: " + type);
            return;
        }

        if(!variable.provinceField){
           field.className += " gemeentefield";
        }

        inputDiv.appendChild(field);
        rowDiv.appendChild(label);
        rowDiv.appendChild(inputDiv);
        container.appendChild(rowDiv);
    },
    getLocation : function (variable){
        var location = variable.location || "basisgegevens";
        if(variable.location === "woningtypen" && variable.additionField === true){
            if(variable.mainCategory !== "none"){
                location = variable.mainCategory + "_subcategories";
            }else{
                location += "-addition";
            }
        }
        var container = document.getElementById(location);
        return container;
    },
    createLabel : function(variable){
        var currentValue = null;
        if (this.config.variableValues[variable.id]) {
            currentValue = this.config.variableValues[variable.id].value;
        }
        if(currentValue === "-1"){
            currentValue = "";
        }else{
            if(variable.type === "dropdown"){
                for(var i = 0 ; i < variable.values.length ;i++){
                    if(variable.values[i].id === parseInt(currentValue)){
                        currentValue = variable.values[i].value;
                        break;
                    }
                }
            }
        }
        var input = document.createElement('label');
        input.innerHTML =currentValue;
        input.id = variable.id;
        return input;
    },
    createDropdown : function(variable){
        var select = document.createElement('select');
        select.id = variable.id;
        select.className = "nice-dropdown";
        var option;
        var options = variable.values;
        var currentValue = null;
        if(this.config.variableValues[variable.id]){
            currentValue = parseInt( this.config.variableValues[variable.id].value);
        } else {
            currentValue = -1;
        }
        option = document.createElement('option');
        option.value = -1;
        option.innerHTML = "-- Maak een keuze --";
        if (currentValue === option.value) {
            option.selected = true;
        }
        select.appendChild(option);
        for(var i = 0; i < options.length; i++) {
            option = document.createElement('option');
            option.value = options[i].id;
            option.innerHTML = options[i].value;
            if(currentValue === options[i].id) {
                option.selected = true;
            }
            select.appendChild(option);
        }
        return select;
    },
    createRadio : function(variable){
        var currentValue = null;
        if (this.config.variableValues[variable.id]) {
            currentValue = this.config.variableValues[variable.id].value;
        } 
        var radioYes = document.createElement('input');
        radioYes.id = variable.id + "_yes";
        radioYes.type = 'radio';
        radioYes.name = variable.id;
        radioYes.value = "Ja";
        if(currentValue === "Ja"){
            radioYes.checked = "checked";
        }

        var radioNo = document.createElement('input');
        radioNo.id = variable.id + "_no";
        radioNo.type = 'radio';
        radioNo.name = variable.id;
        radioNo.value = "Nee";
        if (currentValue === "Nee") {
            radioNo.checked = "checked";
        }

        var labelYes = document.createElement('label');
        labelYes.htmlFor = variable.id + "_yes";
        labelYes.innerHTML = 'Ja';

        var labelNo = document.createElement('label');
        labelNo.htmlFor = variable.id + "_no";
        labelNo.innerHTML = 'Nee';

        var rowDivJa = document.createElement('div');
        rowDivJa.className = "additional-var-radio";
        rowDivJa.appendChild(radioYes);
        rowDivJa.appendChild(labelYes);

        var rowDivNee = document.createElement('div');
        rowDivNee.className = "additional-var-radio";
        rowDivNee.appendChild(radioNo);
        rowDivNee.appendChild(labelNo);

        var total = document.createElement('div');
        total.appendChild(rowDivJa);
        total.appendChild(rowDivNee);
        return total;

    },
    createTextfield : function(variable){
        var currentValue = null;
        if (this.config.variableValues[variable.id]) {
            currentValue = this.config.variableValues[variable.id].value;
        }
        var input = document.createElement('input');
        input.type = 'text';
        input.value =currentValue;
        input.id = variable.id;
        if(variable.location === "woningtypen" && variable.additionField === true){
            if(variable.mainCategory !== "none"){
                this.makeSubcategory(variable, input);
            }else{
                input.className = "numeric woningtype";
            }
        }
        return input;
    },
    makeSubcategory: function(variable, input){
        var mainCategory = variable.mainCategory;
        this.subcategories[mainCategory] = true;
        input.className += "numeric subcategory " + mainCategory;       
        
        var main = document.querySelector(".woningtype." + mainCategory);
        main.readOnly = true;
    },
    hideEmptyBlocks: function() {
        var blocks = document.querySelectorAll('.blocks .block');
        for(var i = 0; i < blocks.length; i++) {
            if(blocks[i].querySelectorAll(':not(h2)').length === 0) {
                blocks[i].style.display = 'none';
            }
        }
    },
    makeNiceDropdowns : function() {
        B3p.planmonitor.Main.convertSelect(".nice-dropdown");
    },
    checkMainCategories: function(readOnly){
        for(var cat in this.subcategories){
            var main = document.querySelector(".woningtype." + cat);
            main.readOnly = readOnly;
        }
    },
    isNumber: function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    }
});