/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.stripes.EditActionBean;
import nl.b3p.pzh.rwbp.stripes.SolrActionBean;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
public class BeheerActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(BeheerActionBean.class);
    @Validate
    private String gemeente;

    @DefaultHandler
    public Resolution beheerdefault() {
        return new ForwardResolution("/WEB-INF/jsp/beheer.jsp");
    }

    public Resolution deletePlannenFromGemeente() {
        StringBuilder message = new StringBuilder();
        if (this.getIsBeheerder().booleanValue()) {
            EntityManager em = Stripersist.getEntityManager();
            List gems = em.createQuery("FROM Gemeente where naam = :naam", Gemeente.class).setParameter("naam", (Object)this.gemeente).getResultList();
            if (gems.size() > 1) {
                message.append("Meer dan 1 gemeente gevonden. Geef de hele naam op. Afgebroken.");
            } else if (gems.isEmpty()) {
                message.append("Geen gemeente gevonden. Afgebroken.");
            } else {
                Gemeente gem = (Gemeente)gems.get(0);
                Set<Bouwplan> bps = gem.getBouwplannen();
                message.append("Gemeente gevonden. Er zijn ");
                message.append(bps.size());
                message.append(" bouwplannen die worden verwijderd.");
                EditActionBean eb = new EditActionBean();
                ArrayList<String> ids = new ArrayList<String>();
                for (Bouwplan bp : bps) {
                    if (!em.getTransaction().isActive()) {
                        em.getTransaction().begin();
                    }
                    ids.add(bp.getId().toString());
                    eb.removeBouwplan(bp, em);
                }
                SolrActionBean.removeMultipleBouwplans(ids);
            }
        } else {
            return new ErrorResolution(401, "Alleen beheerders mogen gemeentes weggooien.");
        }
        return new StreamingResolution("plain/text", message.toString()).setAttachment(false);
    }

    public String getGemeente() {
        return this.gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }
}

