-- View: volledig_detailplanning_view

-- DROP VIEW volledig_detailplanning_view;

CREATE OR REPLACE VIEW volledig_detailplanning_view AS 
 SELECT bv.id AS bvid,
    bv.bouwplan AS id,
    bv.year,
    bv.gepland,
    bv.sloop,
    bv.type,
    bv.huur1,
    bv.huur2,
    bv.huur3,
    bv.huur4,
    bv.huuronb,
    bv.koop1,
    bv.koop2,
    bv.koop3,
    bv.koop4,
    bv.kooponb,
    bv.onbekend,
    bv.gerealiseerd,
    bv.gerealiseerdesloop,
    bv.afgeleidedata
   FROM bouwplan_variable bv
     JOIN bouwplan bp ON bv.bouwplan = bp.id
  WHERE (bp.detail_type::text = 'uitgebreid'::text OR bp.detail_type::text = 'normaal'::text) AND bp.detail_type_sloop::text = 'normaal'::text AND bv.afgeleidedata = false
UNION
 SELECT row_number() OVER ()::integer AS bvid,
    bouwplan.id,
    0 AS year,
    bouwplan.totaalcapaciteit AS gepland,
    bouwplan.totaalsloop AS sloop,
    NULL::text AS type,
    0 AS huur1,
    0 AS huur2,
    0 AS huur3,
    0 AS huur4,
    0 AS huuronb,
    0 AS koop1,
    0 AS koop2,
    0 AS koop3,
    0 AS koop4,
    0 AS kooponb,
    0 AS onbekend,
    false AS gerealiseerd,
    false AS gerealiseerdesloop,
    false AS afgeleidedata
   FROM bouwplan
  WHERE (bouwplan.detail_type::text = 'Geen detailplanning'::text OR bouwplan.detail_type IS NULL) AND (bouwplan.detail_type_sloop IS NULL OR bouwplan.detail_type_sloop::text = 'Geen detailplanning voor sloop'::text)
UNION
 SELECT row_number() OVER ()::integer AS bvid,
    bouwplan.id,
    0 AS year,
    bouwplan.totaalcapaciteit AS gepland,
    NULL::integer AS sloop,
    NULL::text AS type,
    0 AS huur1,
    0 AS huur2,
    0 AS huur3,
    0 AS huur4,
    0 AS huuronb,
    0 AS koop1,
    0 AS koop2,
    0 AS koop3,
    0 AS koop4,
    0 AS kooponb,
    0 AS onbekend,
    NULL::boolean AS gerealiseerd,
    NULL::boolean AS gerealiseerdesloop,
    false AS afgeleidedata
   FROM bouwplan
  WHERE (bouwplan.detail_type::text = 'Geen detailplanning'::text OR bouwplan.detail_type IS NULL) AND bouwplan.detail_type_sloop::text = 'normaal'::text
UNION
 SELECT bv.id AS bvid,
    bv.bouwplan AS id,
    bv.year,
    NULL::integer AS gepland,
    bv.sloop,
    NULL::text AS type,
    NULL::integer AS huur1,
    NULL::integer AS huur2,
    NULL::integer AS huur3,
    NULL::integer AS huur4,
    NULL::integer AS huuronb,
    NULL::integer AS koop1,
    NULL::integer AS koop2,
    NULL::integer AS koop3,
    NULL::integer AS koop4,
    NULL::integer AS kooponb,
    NULL::integer AS onbekend,
    NULL::boolean AS gerealiseerd,
    NULL::boolean AS gerealiseerdesloop,
    bv.afgeleidedata
   FROM bouwplan_variable bv
     JOIN bouwplan bp ON bv.bouwplan = bp.id
  WHERE (bp.detail_type::text = 'Geen detailplanning'::text OR bp.detail_type IS NULL) AND bp.detail_type_sloop::text = 'normaal'::text
UNION
 SELECT bv.id AS bvid,
    bv.bouwplan AS id,
    bv.year,
    bv.gepland,
    NULL::integer AS sloop,
    bv.type,
    bv.huur1,
    bv.huur2,
    bv.huur3,
    bv.huur4,
    bv.huuronb,
    bv.koop1,
    bv.koop2,
    bv.koop3,
    bv.koop4,
    bv.kooponb,
    bv.onbekend,
    bv.gerealiseerd,
    NULL::boolean AS gerealiseerdesloop,
    bv.afgeleidedata
   FROM bouwplan_variable bv
     JOIN bouwplan bp ON bv.bouwplan = bp.id
  WHERE (bp.detail_type::text = 'uitgebreid'::text OR bp.detail_type::text = 'normaal'::text) AND (bp.detail_type_sloop::text = 'Geen detailplanning voor sloop'::text OR bp.detail_type_sloop IS NULL)
UNION
 SELECT row_number() OVER ()::integer AS bvid,
    bouwplan.id,
    0 AS year,
    NULL::integer AS gepland,
    bouwplan.totaalsloop AS sloop,
    NULL::text AS type,
    0 AS huur1,
    0 AS huur2,
    0 AS huur3,
    0 AS huur4,
    0 AS huuronb,
    0 AS koop1,
    0 AS koop2,
    0 AS koop3,
    0 AS koop4,
    0 AS kooponb,
    0 AS onbekend,
    NULL::boolean AS gerealiseerd,
    NULL::boolean AS gerealiseerdesloop,
    false AS afgeleidedata
   FROM bouwplan
  WHERE (bouwplan.detail_type::text = 'Geen detailplanning'::text OR bouwplan.detail_type IS NULL) AND bouwplan.detail_type_sloop::text = 'normaal'::text;

ALTER TABLE volledig_detailplanning_view
  OWNER TO planmonitor;
